// Internal samples for flash memory

#ifndef _SAMPLES_H 
#define _SAMPLES_H

#define INTERNAL_SAMPLE_F 6000

//Entry:text
//     0:  0
//     1:  1
//     2:  10
//     3:  100
//     4:  1000
//     5:  1000000
//     6:  11
//     7:  12
//     8:  13
//     9:  14
//    10:  15
//    11:  16
//    12:  17
//    13:  18
//    14:  19
//    15:  2
//    16:  20
//    17:  3
//    18:  30
//    19:  4
//    20:  40
//    21:  5
//    22:  50
//    23:  6
//    24:  60
//    25:  7
//    26:  70
//    27:  8
//    28:  80
//    29:  9
//    30:  90
//    31:  and
//    32:  file
//    33:  mode
//    34:  off
//    35:  on
//    36:  pause (actually silence)
//    37:  switch
//    38:  volume
//    39:  alt
//    40:  asr
//    41:  crop
//    42:  fail
//    43:  loop
//    44:  ok
//    45:  random
//    46:  roundrobin
//    47:  single
//    48:  mixed
//    49:  not
//    50:  high
//    51:  low
//    52:  power
//    53:  logic

//    54:  analog
//    55:  billion
//    56:  frequency
//    57:  point
//    58:  ready
//    59:  sample
//    60:  select
//    61:  speed
//    62:  standby
//    63:  trigger

const unsigned char WAV0[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x82, 0x82,
	0x84, 0x84, 0x84, 0x83, 0x84, 0x83, 0x82, 0x82, 0x82, 0x80, 0x80, 0x80,
	0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82,
	0x82, 0x83, 0x82, 0x82, 0x83, 0x82, 0x82, 0x85, 0x83, 0x83, 0x86, 0x85,
	0x86, 0x88, 0x88, 0x87, 0x87, 0x88, 0x86, 0x86, 0x85, 0x84, 0x84, 0x83,
	0x83, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x84, 0x83, 0x82, 0x84, 0x83,
	0x82, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7B, 0x7A, 0x7B,
	0x7A, 0x79, 0x7A, 0x7B, 0x7A, 0x7B, 0x7D, 0x7D, 0x7E, 0x81, 0x81, 0x82,
	0x83, 0x83, 0x84, 0x83, 0x84, 0x83, 0x81, 0x82, 0x82, 0x80, 0x81, 0x82,
	0x81, 0x80, 0x82, 0x82, 0x80, 0x82, 0x82, 0x80, 0x81, 0x82, 0x81, 0x80,
	0x83, 0x82, 0x82, 0x84, 0x84, 0x83, 0x83, 0x85, 0x83, 0x81, 0x83, 0x81,
	0x7F, 0x81, 0x81, 0x7F, 0x80, 0x82, 0x80, 0x80, 0x82, 0x81, 0x80, 0x82,
	0x81, 0x80, 0x82, 0x82, 0x7F, 0x81, 0x82, 0x80, 0x80, 0x81, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82,
	0x83, 0x82, 0x82, 0x85, 0x83, 0x85, 0x86, 0x86, 0x86, 0x86, 0x86, 0x84,
	0x84, 0x84, 0x82, 0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x7C, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81, 0x81,
	0x81, 0x82, 0x83, 0x80, 0x81, 0x82, 0x80, 0x81, 0x81, 0x82, 0x80, 0x80,
	0x82, 0x7F, 0x7F, 0x80, 0x81, 0x7E, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x80, 0x80,
	0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81,
	0x82, 0x80, 0x82, 0x82, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x7E,
	0x7D, 0x7C, 0x7D, 0x7B, 0x7C, 0x7D, 0x7B, 0x7E, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7F, 0x7E, 0x80, 0x80, 0x80, 0x82, 0x82, 0x81, 0x82, 0x83, 0x82, 0x83,
	0x84, 0x83, 0x84, 0x83, 0x83, 0x83, 0x80, 0x81, 0x80, 0x7E, 0x7D, 0x7C,
	0x7D, 0x7C, 0x7D, 0x7E, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x81, 0x81, 0x82,
	0x82, 0x83, 0x83, 0x83, 0x82, 0x83, 0x82, 0x82, 0x83, 0x82, 0x7F, 0x83,
	0x7F, 0x80, 0x82, 0x7F, 0x80, 0x81, 0x7F, 0x7D, 0x7F, 0x7D, 0x7D, 0x7D,
	0x7F, 0x7F, 0x7F, 0x82, 0x84, 0x82, 0x84, 0x88, 0x86, 0x87, 0x88, 0x88,
	0x86, 0x85, 0x87, 0x80, 0x83, 0x82, 0x7E, 0x81, 0x7E, 0x7F, 0x7C, 0x7F,
	0x81, 0x7E, 0x85, 0x86, 0x85, 0x8A, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x86,
	0x84, 0x84, 0x7E, 0x79, 0x7A, 0x77, 0x73, 0x72, 0x76, 0x73, 0x72, 0x78,
	0x76, 0x79, 0x7B, 0x7B, 0x7D, 0x7C, 0x80, 0x7F, 0x81, 0x82, 0x82, 0x85,
	0x86, 0x85, 0x87, 0x87, 0x87, 0x88, 0x8A, 0x89, 0x8A, 0x8A, 0x88, 0x87,
	0x86, 0x88, 0x83, 0x82, 0x85, 0x81, 0x7F, 0x82, 0x81, 0x7F, 0x80, 0x80,
	0x88, 0x88, 0x87, 0x91, 0x8E, 0x8E, 0x90, 0x8E, 0x8C, 0x88, 0x88, 0x84,
	0x7E, 0x7F, 0x7D, 0x79, 0x7A, 0x7A, 0x7A, 0x7A, 0x7D, 0x7E, 0x7E, 0x81,
	0x83, 0x82, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x80, 0x7F, 0x7F, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x7E, 0x7F, 0x7D, 0x7D, 0x7C, 0x8A, 0x8A,
	0x88, 0x97, 0x93, 0x93, 0x96, 0x95, 0x8F, 0x89, 0x8B, 0x82, 0x7C, 0x7E,
	0x78, 0x75, 0x76, 0x78, 0x77, 0x78, 0x7F, 0x7E, 0x80, 0x85, 0x86, 0x85,
	0x87, 0x87, 0x83, 0x83, 0x83, 0x7F, 0x7D, 0x7E, 0x7B, 0x7A, 0x7B, 0x7C,
	0x7A, 0x7D, 0x7F, 0x7E, 0x80, 0x82, 0x82, 0x81, 0x84, 0x82, 0x81, 0x82,
	0x81, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x81, 0x93, 0x8A, 0x96, 0xA2, 0x98,
	0x9F, 0x9E, 0x9A, 0x90, 0x8F, 0x8A, 0x79, 0x7D, 0x77, 0x6E, 0x72, 0x72,
	0x72, 0x72, 0x7C, 0x7D, 0x7D, 0x89, 0x87, 0x88, 0x8B, 0x8B, 0x88, 0x88,
	0x88, 0x81, 0x80, 0x80, 0x7B, 0x7A, 0x7B, 0x79, 0x78, 0x7C, 0x7C, 0x7C,
	0x81, 0x81, 0x81, 0x83, 0x85, 0x83, 0x84, 0x84, 0x81, 0x80, 0x82, 0x7D,
	0x7E, 0x7C, 0x81, 0x93, 0x88, 0x9B, 0xA1, 0x9A, 0xA3, 0xA0, 0x9B, 0x91,
	0x93, 0x85, 0x7B, 0x7E, 0x72, 0x6D, 0x70, 0x6F, 0x6E, 0x74, 0x7B, 0x79,
	0x82, 0x88, 0x86, 0x8B, 0x8E, 0x8B, 0x88, 0x8B, 0x84, 0x80, 0x80, 0x7E,
	0x77, 0x7B, 0x7A, 0x77, 0x7C, 0x7D, 0x7C, 0x7F, 0x83, 0x82, 0x82, 0x87,
	0x83, 0x83, 0x85, 0x81, 0x80, 0x80, 0x80, 0x7A, 0x80, 0x79, 0x8E, 0x91,
	0x8B, 0xA9, 0x9D, 0xA0, 0xA7, 0x9F, 0x95, 0x92, 0x8C, 0x7A, 0x7A, 0x74,
	0x69, 0x6C, 0x6E, 0x6A, 0x70, 0x79, 0x7A, 0x7F, 0x89, 0x89, 0x8A, 0x91,
	0x8D, 0x8A, 0x8B, 0x87, 0x7F, 0x80, 0x7C, 0x76, 0x77, 0x77, 0x75, 0x76,
	0x7A, 0x7B, 0x7C, 0x82, 0x81, 0x83, 0x87, 0x85, 0x85, 0x85, 0x85, 0x80,
	0x82, 0x7E, 0x7F, 0x79, 0x8F, 0x91, 0x87, 0xA9, 0x9F, 0x99, 0xAA, 0xA0,
	0x91, 0x96, 0x8F, 0x79, 0x7B, 0x7B, 0x69, 0x6D, 0x75, 0x6B, 0x70, 0x7E,
	0x7A, 0x7D, 0x8B, 0x89, 0x87, 0x90, 0x8E, 0x86, 0x8A, 0x87, 0x7D, 0x7E,
	0x7E, 0x75, 0x76, 0x7A, 0x76, 0x76, 0x7E, 0x7C, 0x7D, 0x84, 0x83, 0x84,
	0x86, 0x87, 0x84, 0x85, 0x84, 0x81, 0x7D, 0x81, 0x7A, 0x83, 0x9C, 0x88,
	0x9A, 0xB1, 0x97, 0x9F, 0xAF, 0x92, 0x8B, 0x96, 0x7D, 0x70, 0x7A, 0x6E,
	0x62, 0x6E, 0x71, 0x6A, 0x76, 0x81, 0x7D, 0x84, 0x8F, 0x8B, 0x89, 0x90,
	0x8C, 0x84, 0x84, 0x83, 0x79, 0x78, 0x7A, 0x75, 0x74, 0x79, 0x7A, 0x79,
	0x7F, 0x82, 0x81, 0x84, 0x88, 0x85, 0x85, 0x86, 0x84, 0x80, 0x81, 0x7E,
	0x7C, 0x79, 0x85, 0x9E, 0x8F, 0x94, 0xB7, 0xA2, 0x90, 0xAE, 0x9D, 0x77,
	0x8C, 0x88, 0x61, 0x6C, 0x7B, 0x61, 0x65, 0x7E, 0x75, 0x73, 0x89, 0x8D,
	0x85, 0x8F, 0x95, 0x8B, 0x88, 0x8A, 0x83, 0x7B, 0x7A, 0x78, 0x74, 0x73,
	0x76, 0x79, 0x79, 0x7C, 0x83, 0x84, 0x84, 0x88, 0x89, 0x85, 0x84, 0x85,
	0x80, 0x7E, 0x7D, 0x7C, 0x79, 0x7B, 0x79, 0x86, 0xA1, 0x96, 0x95, 0xBC,
	0xB6, 0x90, 0xA6, 0xB0, 0x7E, 0x74, 0x8B, 0x70, 0x58, 0x6F, 0x72, 0x62,
	0x72, 0x81, 0x7F, 0x87, 0x90, 0x8F, 0x93, 0x93, 0x88, 0x89, 0x88, 0x78,
	0x75, 0x7C, 0x72, 0x6C, 0x79, 0x7A, 0x74, 0x7E, 0x87, 0x82, 0x85, 0x8C,
	0x87, 0x84, 0x87, 0x81, 0x7D, 0x7F, 0x7C, 0x76, 0x7B, 0x7C, 0x79, 0x7B,
	0x85, 0x9F, 0xAA, 0x99, 0xA2, 0xBA, 0xA5, 0x86, 0x92, 0x92, 0x6E, 0x66,
	0x75, 0x6C, 0x63, 0x72, 0x79, 0x7A, 0x89, 0x8F, 0x89, 0x93, 0x99, 0x88,
	0x83, 0x8B, 0x7F, 0x70, 0x76, 0x78, 0x6F, 0x73, 0x7B, 0x7A, 0x7E, 0x87,
	0x86, 0x85, 0x8C, 0x8A, 0x82, 0x85, 0x87, 0x7D, 0x79, 0x7E, 0x7C, 0x77,
	0x7B, 0x7F, 0x7D, 0x80, 0x84, 0x82, 0x81, 0x96, 0xB3, 0xAA, 0x93, 0xA2,
	0xB1, 0x94, 0x78, 0x7E, 0x7F, 0x6D, 0x66, 0x6A, 0x6E, 0x78, 0x80, 0x7B,
	0x7D, 0x8F, 0x94, 0x85, 0x82, 0x8B, 0x87, 0x7B, 0x79, 0x78, 0x75, 0x78,
	0x7A, 0x76, 0x7A, 0x85, 0x86, 0x80, 0x85, 0x8B, 0x86, 0x81, 0x82, 0x7F,
	0x7B, 0x7C, 0x7C, 0x77, 0x7A, 0x7F, 0x7D, 0x7B, 0x81, 0x84, 0x81, 0x81,
	0x84, 0x82, 0x7F, 0x91, 0xB0, 0xB0, 0x95, 0x93, 0xA5, 0x9C, 0x81, 0x74,
	0x72, 0x6F, 0x71, 0x72, 0x6B, 0x71, 0x87, 0x90, 0x86, 0x87, 0x93, 0x93,
	0x89, 0x84, 0x7F, 0x77, 0x76, 0x7B, 0x75, 0x6F, 0x77, 0x82, 0x81, 0x81,
	0x86, 0x88, 0x87, 0x88, 0x87, 0x7F, 0x7B, 0x7F, 0x7D, 0x77, 0x77, 0x7C,
	0x7D, 0x7E, 0x82, 0x83, 0x81, 0x84, 0x86, 0x82, 0x7E, 0x7F, 0x7F, 0x7E,
	0x92, 0xB2, 0xB2, 0x98, 0x91, 0x9E, 0x9B, 0x87, 0x77, 0x6E, 0x67, 0x6E,
	0x7A, 0x76, 0x6E, 0x7A, 0x90, 0x94, 0x8D, 0x8B, 0x8B, 0x88, 0x88, 0x84,
	0x74, 0x67, 0x6C, 0x79, 0x78, 0x73, 0x77, 0x80, 0x86, 0x8C, 0x8F, 0x88,
	0x81, 0x83, 0x88, 0x82, 0x77, 0x75, 0x77, 0x79, 0x7B, 0x7E, 0x7D, 0x7D,
	0x82, 0x89, 0x88, 0x83, 0x81, 0x83, 0x85, 0x85, 0x83, 0x7D, 0x82, 0xA0,
	0xBC, 0xB4, 0x97, 0x8C, 0x97, 0x99, 0x89, 0x77, 0x69, 0x62, 0x6B, 0x7D,
	0x80, 0x75, 0x75, 0x87, 0x97, 0x97, 0x8F, 0x87, 0x82, 0x81, 0x85, 0x81,
	0x73, 0x68, 0x6E, 0x7B, 0x7F, 0x7D, 0x7C, 0x80, 0x85, 0x8C, 0x8E, 0x89,
	0x7F, 0x7C, 0x81, 0x82, 0x7C, 0x76, 0x75, 0x78, 0x7D, 0x81, 0x82, 0x7F,
	0x7F, 0x84, 0x88, 0x87, 0x81, 0x7E, 0x7E, 0x80, 0x80, 0x7E, 0x7C, 0x86,
	0xA4, 0xBE, 0xB6, 0x99, 0x8E, 0x99, 0x9C, 0x8A, 0x73, 0x66, 0x64, 0x6A,
	0x77, 0x7E, 0x78, 0x75, 0x83, 0x97, 0x9C, 0x91, 0x88, 0x85, 0x85, 0x84,
	0x80, 0x78, 0x6E, 0x6E, 0x77, 0x80, 0x7E, 0x7A, 0x7E, 0x87, 0x8C, 0x8B,
	0x87, 0x83, 0x81, 0x80, 0x80, 0x7D, 0x78, 0x75, 0x79, 0x7E, 0x7F, 0x7E,
	0x7F, 0x82, 0x85, 0x86, 0x85, 0x83, 0x80, 0x7F, 0x7F, 0x7E, 0x7C, 0x7A,
	0x7B, 0x7E, 0x7F, 0x83, 0x9A, 0xBB, 0xC1, 0xA4, 0x8D, 0x97, 0xA4, 0x91,
	0x6E, 0x60, 0x68, 0x70, 0x71, 0x73, 0x76, 0x7B, 0x88, 0x98, 0x9C, 0x90,
	0x84, 0x86, 0x8B, 0x82, 0x73, 0x6C, 0x71, 0x76, 0x78, 0x79, 0x7C, 0x81,
	0x87, 0x8D, 0x8C, 0x87, 0x83, 0x84, 0x84, 0x7E, 0x77, 0x76, 0x79, 0x7A,
	0x7B, 0x7C, 0x7F, 0x82, 0x84, 0x86, 0x85, 0x83, 0x82, 0x82, 0x80, 0x7C,
	0x7A, 0x7B, 0x7D, 0x7D, 0x7D, 0x7E, 0x81, 0x82, 0x83, 0x82, 0x85, 0x9C,
	0xBE, 0xC0, 0x9B, 0x85, 0x98, 0xA6, 0x86, 0x5E, 0x5F, 0x75, 0x7A, 0x6F,
	0x6F, 0x7C, 0x8B, 0x94, 0x95, 0x8D, 0x86, 0x8B, 0x8E, 0x81, 0x6F, 0x6F,
	0x79, 0x7A, 0x73, 0x74, 0x80, 0x87, 0x87, 0x87, 0x88, 0x87, 0x85, 0x84,
	0x80, 0x79, 0x77, 0x7B, 0x7C, 0x79, 0x7B, 0x81, 0x84, 0x83, 0x83, 0x86,
	0x85, 0x81, 0x80, 0x7F, 0x7D, 0x7B, 0x7C, 0x7D, 0x7D, 0x7D, 0x80, 0x82,
	0x82, 0x81, 0x83, 0x82, 0x80, 0x7F, 0x7F, 0x7E, 0x90, 0xB9, 0xC8, 0xA1,
	0x80, 0x94, 0xA7, 0x84, 0x57, 0x5C, 0x78, 0x7A, 0x6E, 0x74, 0x84, 0x90,
	0x97, 0x97, 0x8B, 0x83, 0x89, 0x89, 0x76, 0x68, 0x71, 0x7D, 0x79, 0x74,
	0x7D, 0x88, 0x8A, 0x88, 0x88, 0x86, 0x81, 0x7E, 0x7D, 0x78, 0x74, 0x78,
	0x7D, 0x7D, 0x7E, 0x83, 0x87, 0x85, 0x84, 0x83, 0x82, 0x7E, 0x7D, 0x7C,
	0x7B, 0x7B, 0x7D, 0x7F, 0x7F, 0x80, 0x83, 0x83, 0x82, 0x81, 0x81, 0x7F,
	0x7C, 0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x80, 0x81, 0x84, 0xAA, 0xD3, 0xBE,
	0x8B, 0x8E, 0xAA, 0x8F, 0x5B, 0x56, 0x6E, 0x72, 0x71, 0x7A, 0x81, 0x8A,
	0x9E, 0xA0, 0x88, 0x7C, 0x89, 0x88, 0x70, 0x68, 0x74, 0x7B, 0x7C, 0x81,
	0x82, 0x84, 0x8D, 0x8F, 0x81, 0x7A, 0x80, 0x81, 0x77, 0x75, 0x7A, 0x7E,
	0x80, 0x83, 0x82, 0x81, 0x86, 0x86, 0x7F, 0x7B, 0x7F, 0x7F, 0x7C, 0x7A,
	0x79, 0x7C, 0x82, 0x82, 0x7E, 0x80, 0x85, 0x83, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7D, 0x80, 0x82, 0x81, 0x7F, 0x81, 0x81, 0x81, 0x7E, 0x8C,
	0xBC, 0xC5, 0x98, 0x85, 0x9D, 0x96, 0x72, 0x62, 0x66, 0x74, 0x86, 0x82,
	0x78, 0x8A, 0x9E, 0x92, 0x7D, 0x7B, 0x7D, 0x7C, 0x78, 0x71, 0x72, 0x83,
	0x8B, 0x82, 0x80, 0x88, 0x88, 0x82, 0x7D, 0x78, 0x7A, 0x80, 0x7E, 0x79,
	0x7B, 0x82, 0x84, 0x82, 0x7F, 0x7F, 0x82, 0x81, 0x7C, 0x7B, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x81, 0x82, 0x80, 0x7D, 0x7F, 0x80, 0x7F, 0x7E, 0x7E,
	0x7F, 0x81, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x80, 0x80,
	0x80, 0x7F, 0x81, 0x7E, 0x88, 0xB5, 0xBC, 0x92, 0x84, 0x90, 0x84, 0x71,
	0x65, 0x64, 0x7C, 0x8F, 0x85, 0x81, 0x91, 0x93, 0x89, 0x7C, 0x71, 0x74,
	0x7C, 0x77, 0x76, 0x80, 0x89, 0x8B, 0x88, 0x80, 0x7F, 0x82, 0x7C, 0x76,
	0x78, 0x7D, 0x81, 0x83, 0x81, 0x82, 0x86, 0x83, 0x7E, 0x7C, 0x7D, 0x7D,
	0x7F, 0x7E, 0x7E, 0x82, 0x83, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7D,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0xA9,
	0xC0, 0xA1, 0x8B, 0x85, 0x7F, 0x7D, 0x6A, 0x5E, 0x79, 0x8D, 0x8D, 0x8C,
	0x88, 0x8C, 0x90, 0x7D, 0x6E, 0x73, 0x79, 0x7D, 0x7F, 0x7C, 0x86, 0x8E,
	0x87, 0x80, 0x7C, 0x7C, 0x7E, 0x7B, 0x78, 0x7F, 0x84, 0x85, 0x84, 0x81,
	0x80, 0x82, 0x7E, 0x7B, 0x7C, 0x7E, 0x81, 0x81, 0x80, 0x81, 0x83, 0x81,
	0x7F, 0x7D, 0x7D, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x82, 0x81, 0x7F, 0x7E,
	0x7B, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x80, 0x80, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0xA9, 0xC0, 0xA7, 0x92, 0x81, 0x7B,
	0x7D, 0x68, 0x61, 0x78, 0x89, 0x91, 0x89, 0x7F, 0x87, 0x89, 0x7C, 0x72,
	0x6E, 0x7A, 0x86, 0x82, 0x80, 0x83, 0x88, 0x88, 0x7F, 0x76, 0x79, 0x7E,
	0x80, 0x7E, 0x7C, 0x82, 0x87, 0x84, 0x7F, 0x7C, 0x7E, 0x81, 0x7E, 0x7F,
	0x81, 0x83, 0x85, 0x81, 0x7E, 0x7F, 0x7E, 0x7F, 0x7E, 0x7D, 0x80, 0x82,
	0x82, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x7E, 0x7E, 0x7F, 0x81, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7E, 0x83, 0x86, 0x84, 0x82, 0x7F, 0x7F, 0x81,
	0x7C, 0x9C, 0xB8, 0xAA, 0x9A, 0x82, 0x79, 0x7F, 0x6F, 0x67, 0x70, 0x7E,
	0x94, 0x93, 0x87, 0x86, 0x83, 0x82, 0x7A, 0x6D, 0x72, 0x7E, 0x85, 0x85,
	0x7D, 0x7E, 0x85, 0x84, 0x7F, 0x77, 0x77, 0x80, 0x83, 0x80, 0x7E, 0x7E,
	0x84, 0x85, 0x7F, 0x7B, 0x7B, 0x80, 0x82, 0x7E, 0x7D, 0x7F, 0x82, 0x84,
	0x7F, 0x7D, 0x7E, 0x80, 0x81, 0x80, 0x80, 0x81, 0x83, 0x82, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x81, 0x7D, 0x97, 0xB8, 0xAE, 0x9D,
	0x83, 0x76, 0x7F, 0x75, 0x6B, 0x6D, 0x76, 0x91, 0x98, 0x8C, 0x85, 0x7E,
	0x82, 0x81, 0x73, 0x6F, 0x75, 0x81, 0x8C, 0x86, 0x81, 0x82, 0x84, 0x85,
	0x7D, 0x74, 0x77, 0x7E, 0x84, 0x83, 0x7E, 0x7F, 0x84, 0x85, 0x82, 0x7B,
	0x79, 0x7E, 0x81, 0x81, 0x7E, 0x7E, 0x81, 0x84, 0x83, 0x7E, 0x7C, 0x7E,
	0x80, 0x81, 0x7E, 0x7D, 0x7F, 0x82, 0x82, 0x80, 0x7D, 0x7E, 0x80, 0x80,
	0x7D, 0x7C, 0x7D, 0x80, 0x82, 0x80, 0x7F, 0x7E, 0x81, 0x81, 0x80, 0x7D,
	0x7E, 0x7D, 0x89, 0xAD, 0xB4, 0xA8, 0x90, 0x79, 0x7B, 0x7A, 0x70, 0x6C,
	0x6C, 0x81, 0x95, 0x95, 0x8E, 0x81, 0x7E, 0x83, 0x7E, 0x75, 0x6F, 0x73,
	0x82, 0x8A, 0x89, 0x83, 0x7F, 0x83, 0x85, 0x80, 0x78, 0x74, 0x7A, 0x82,
	0x84, 0x82, 0x7E, 0x80, 0x85, 0x84, 0x7F, 0x7A, 0x79, 0x7E, 0x82, 0x80,
	0x7D, 0x7B, 0x7F, 0x84, 0x83, 0x80, 0x7C, 0x7D, 0x81, 0x82, 0x80, 0x7D,
	0x7C, 0x80, 0x82, 0x82, 0x7F, 0x7D, 0x7F, 0x81, 0x82, 0x7F, 0x7D, 0x7E,
	0x81, 0x81, 0x81, 0x7E, 0x7E, 0x7F, 0x81, 0x7F, 0x85, 0xA3, 0xB1, 0xAF,
	0x9B, 0x7E, 0x76, 0x76, 0x75, 0x73, 0x6A, 0x72, 0x85, 0x93, 0x98, 0x8B,
	0x7F, 0x7E, 0x7E, 0x7F, 0x78, 0x70, 0x74, 0x7E, 0x89, 0x8C, 0x85, 0x80,
	0x7F, 0x82, 0x84, 0x7E, 0x77, 0x76, 0x7B, 0x84, 0x86, 0x82, 0x7E, 0x7E,
	0x82, 0x85, 0x81, 0x7B, 0x78, 0x7C, 0x81, 0x83, 0x81, 0x7E, 0x7E, 0x81,
	0x84, 0x82, 0x7E, 0x7B, 0x7D, 0x7F, 0x80, 0x7E, 0x7C, 0x7D, 0x80, 0x83,
	0x83, 0x80, 0x7E, 0x7E, 0x7F, 0x81, 0x80, 0x7E, 0x7C, 0x7F, 0x80, 0x83,
	0x7F, 0x88, 0xA3, 0xB0, 0xB2, 0x9C, 0x7F, 0x75, 0x72, 0x76, 0x75, 0x6A,
	0x6B, 0x75, 0x88, 0x98, 0x94, 0x88, 0x7D, 0x79, 0x80, 0x80, 0x7A, 0x73,
	0x70, 0x7C, 0x88, 0x8D, 0x89, 0x7F, 0x7C, 0x7F, 0x83, 0x83, 0x7B, 0x75,
	0x77, 0x7F, 0x87, 0x87, 0x81, 0x7D, 0x7E, 0x83, 0x87, 0x83, 0x7D, 0x77,
	0x7A, 0x80, 0x84, 0x84, 0x7E, 0x7C, 0x7E, 0x82, 0x85, 0x82, 0x7D, 0x7A,
	0x7C, 0x81, 0x84, 0x81, 0x7E, 0x7C, 0x7E, 0x82, 0x84, 0x81, 0x7D, 0x7C,
	0x7E, 0x82, 0x84, 0x82, 0x7D, 0x89, 0xA1, 0xB1, 0xB5, 0x9F, 0x83, 0x73,
	0x6D, 0x75, 0x76, 0x70, 0x6D, 0x71, 0x84, 0x95, 0x99, 0x90, 0x7F, 0x76,
	0x78, 0x7D, 0x81, 0x7A, 0x73, 0x74, 0x7E, 0x8C, 0x91, 0x8B, 0x80, 0x78,
	0x7A, 0x80, 0x83, 0x80, 0x78, 0x76, 0x7A, 0x84, 0x8A, 0x88, 0x80, 0x7A,
	0x7A, 0x80, 0x84, 0x82, 0x7D, 0x78, 0x7A, 0x80, 0x86, 0x86, 0x81, 0x7B,
	0x7A, 0x7E, 0x83, 0x84, 0x80, 0x7C, 0x7A, 0x7E, 0x83, 0x85, 0x82, 0x7D,
	0x7B, 0x7D, 0x81, 0x84, 0x81, 0x7E, 0x7B, 0x82, 0x97, 0xA6, 0xAD, 0xA1,
	0x8C, 0x7D, 0x75, 0x79, 0x7A, 0x75, 0x70, 0x6F, 0x78, 0x87, 0x90, 0x91,
	0x86, 0x7C, 0x7A, 0x7D, 0x82, 0x81, 0x7B, 0x76, 0x77, 0x7F, 0x87, 0x89,
	0x85, 0x7E, 0x7A, 0x7D, 0x81, 0x84, 0x81, 0x7B, 0x79, 0x7C, 0x82, 0x85,
	0x83, 0x7D, 0x79, 0x7A, 0x7F, 0x83, 0x83, 0x7F, 0x7C, 0x7B, 0x7F, 0x83,
	0x84, 0x81, 0x7D, 0x7B, 0x7E, 0x81, 0x83, 0x81, 0x7E, 0x7C, 0x7D, 0x81,
	0x83, 0x82, 0x7F, 0x7D, 0x7D, 0x80, 0x83, 0x83, 0x86, 0x8C, 0x92, 0x96,
	0x92, 0x8B, 0x82, 0x7D, 0x7D, 0x80, 0x81, 0x80, 0x7D, 0x7D, 0x80, 0x83,
	0x85, 0x83, 0x7F, 0x7C, 0x7C, 0x7F, 0x81, 0x81, 0x7F, 0x7D, 0x7D, 0x80,
	0x82, 0x83, 0x81, 0x7F, 0x7D, 0x7E, 0x80, 0x82, 0x81, 0x7F, 0x7E, 0x7E,
	0x80, 0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x7F, 0x7E,
	0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x83, 0x89, 0x8E, 0x8F, 0x8B,
	0x85, 0x81, 0x81, 0x83, 0x84, 0x83, 0x80, 0x7E, 0x7F, 0x81, 0x83, 0x82,
	0x80, 0x7D, 0x7C, 0x7E, 0x81, 0x82, 0x80, 0x7E, 0x7D, 0x7E, 0x80, 0x81,
	0x81, 0x7F, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x80,
	0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x84, 0x88, 0x8A, 0x89, 0x85, 0x82, 0x81,
	0x83, 0x85, 0x86, 0x84, 0x82, 0x81, 0x81, 0x82, 0x82, 0x81, 0x7F, 0x7E,
	0x7F, 0x80, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x82, 0x83, 0x84, 0x82, 0x81, 0x80, 0x81, 0x82, 0x83, 0x82,
	0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80
};
const unsigned char WAV1[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x83, 0x84, 0x85, 0x86, 0x86, 0x85,
	0x83, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x81, 0x84, 0x88, 0x8C, 0x90, 0x91, 0x8F, 0x8B, 0x87,
	0x84, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7C, 0x7A, 0x79, 0x79, 0x7A, 0x7C,
	0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x81, 0x86, 0x8D, 0x95, 0x98, 0x99, 0x94, 0x8D,
	0x86, 0x81, 0x7E, 0x7D, 0x7D, 0x7C, 0x7A, 0x78, 0x76, 0x76, 0x77, 0x79,
	0x7C, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x83, 0x83, 0x83, 0x83,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x88, 0x90, 0x9A, 0xA0,
	0xA1, 0x9D, 0x93, 0x89, 0x81, 0x7C, 0x7A, 0x78, 0x78, 0x76, 0x73, 0x72,
	0x72, 0x74, 0x78, 0x7C, 0x7F, 0x81, 0x81, 0x81, 0x82, 0x83, 0x86, 0x88,
	0x89, 0x89, 0x86, 0x83, 0x80, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7C, 0x7C,
	0x7B, 0x7C, 0x7D, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7E, 0x7F, 0x87, 0x91, 0x9F, 0xA8, 0xAB, 0xA6, 0x98, 0x8A, 0x7C, 0x73,
	0x6F, 0x6E, 0x6F, 0x6F, 0x6F, 0x70, 0x73, 0x78, 0x7E, 0x85, 0x89, 0x8A,
	0x88, 0x85, 0x82, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7D, 0x7C, 0x7B, 0x7D,
	0x7E, 0x80, 0x82, 0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x8C, 0x98,
	0xA8, 0xB0, 0xB0, 0xA3, 0x90, 0x7C, 0x6C, 0x65, 0x65, 0x6B, 0x72, 0x78,
	0x7D, 0x81, 0x86, 0x8A, 0x8E, 0x8E, 0x8A, 0x84, 0x7C, 0x77, 0x75, 0x76,
	0x7A, 0x7E, 0x81, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x82, 0x80, 0x7E,
	0x7C, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82,
	0x81, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x86, 0x92, 0xA4, 0xB2, 0xB6, 0xAD,
	0x98, 0x80, 0x6B, 0x62, 0x61, 0x68, 0x70, 0x77, 0x7B, 0x7F, 0x84, 0x8A,
	0x8E, 0x8F, 0x8B, 0x83, 0x7A, 0x74, 0x73, 0x76, 0x7C, 0x81, 0x84, 0x84,
	0x82, 0x81, 0x83, 0x85, 0x87, 0x87, 0x85, 0x81, 0x7D, 0x7A, 0x7B, 0x7D,
	0x7F, 0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x7F, 0x7E,
	0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x7D, 0x7D, 0x7A, 0x7A,
	0x78, 0x7B, 0x7B, 0x84, 0x95, 0xA7, 0xB8, 0xBB, 0xB0, 0x96, 0x7C, 0x64,
	0x5C, 0x5D, 0x67, 0x72, 0x7A, 0x80, 0x84, 0x88, 0x8C, 0x8F, 0x8B, 0x84,
	0x7A, 0x73, 0x6F, 0x74, 0x7A, 0x83, 0x87, 0x87, 0x85, 0x82, 0x80, 0x80,
	0x80, 0x7E, 0x7D, 0x7A, 0x7B, 0x7D, 0x81, 0x84, 0x86, 0x84, 0x81, 0x7D,
	0x7C, 0x7C, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7C,
	0x7C, 0x7C, 0x7E, 0x80, 0x83, 0x83, 0x83, 0x81, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7E, 0x8A, 0x9B, 0xB2, 0xBE, 0xBA, 0xA2, 0x7F, 0x60, 0x50, 0x54, 0x63,
	0x76, 0x82, 0x89, 0x87, 0x88, 0x86, 0x86, 0x80, 0x7A, 0x72, 0x70, 0x76,
	0x82, 0x8D, 0x92, 0x8F, 0x85, 0x7B, 0x75, 0x76, 0x7A, 0x7F, 0x7F, 0x80,
	0x7F, 0x81, 0x84, 0x87, 0x85, 0x80, 0x7A, 0x77, 0x78, 0x7D, 0x82, 0x85,
	0x84, 0x81, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x7D, 0x7D, 0x7D, 0x80, 0x82,
	0x84, 0x82, 0x80, 0x7C, 0x7D, 0x7D, 0x81, 0x81, 0x81, 0x80, 0x7E, 0x94,
	0xAD, 0xCA, 0xC9, 0xB1, 0x82, 0x5D, 0x4C, 0x56, 0x6E, 0x82, 0x8B, 0x88,
	0x88, 0x89, 0x8F, 0x89, 0x7E, 0x6B, 0x64, 0x68, 0x7E, 0x91, 0x9A, 0x92,
	0x83, 0x76, 0x74, 0x7A, 0x7F, 0x81, 0x7B, 0x79, 0x7A, 0x84, 0x87, 0x87,
	0x7E, 0x77, 0x74, 0x7C, 0x83, 0x88, 0x85, 0x7F, 0x7B, 0x7C, 0x82, 0x84,
	0x83, 0x7C, 0x7A, 0x7A, 0x82, 0x85, 0x87, 0x80, 0x7C, 0x79, 0x7E, 0x81,
	0x85, 0x81, 0x7E, 0x7D, 0x81, 0x85, 0x84, 0x81, 0x79, 0x92, 0xB6, 0xD7,
	0xCD, 0xA2, 0x67, 0x46, 0x4B, 0x6C, 0x8A, 0x91, 0x89, 0x80, 0x88, 0x92,
	0x95, 0x7F, 0x65, 0x55, 0x66, 0x84, 0xA0, 0xA0, 0x8D, 0x78, 0x72, 0x7B,
	0x84, 0x81, 0x74, 0x6F, 0x77, 0x8D, 0x98, 0x93, 0x7D, 0x6E, 0x6C, 0x7B,
	0x88, 0x8B, 0x80, 0x78, 0x7A, 0x85, 0x8D, 0x88, 0x7B, 0x6F, 0x73, 0x7F,
	0x8C, 0x8B, 0x83, 0x7A, 0x7C, 0x83, 0x87, 0x82, 0x78, 0x74, 0x7A, 0x85,
	0x8B, 0x87, 0x7D, 0x77, 0x7B, 0x81, 0x87, 0x7E, 0x8C, 0xAD, 0xCF, 0xCD,
	0xA1, 0x6B, 0x49, 0x53, 0x70, 0x8C, 0x8B, 0x86, 0x7E, 0x88, 0x8B, 0x85,
	0x6F, 0x60, 0x66, 0x7E, 0x95, 0x97, 0x8A, 0x78, 0x79, 0x7E, 0x86, 0x7D,
	0x75, 0x70, 0x7E, 0x8C, 0x93, 0x88, 0x79, 0x72, 0x78, 0x83, 0x85, 0x80,
	0x77, 0x7C, 0x81, 0x89, 0x82, 0x7A, 0x75, 0x7B, 0x84, 0x87, 0x83, 0x7B,
	0x7B, 0x7F, 0x85, 0x83, 0x7D, 0x79, 0x7C, 0x82, 0x86, 0x83, 0x7D, 0x7A,
	0x7E, 0x82, 0x84, 0x7E, 0x7C, 0x7B, 0x83, 0x80, 0x95, 0xB6, 0xC8, 0xB5,
	0x83, 0x64, 0x5B, 0x72, 0x7C, 0x82, 0x7C, 0x88, 0x97, 0x9F, 0x8F, 0x73,
	0x63, 0x68, 0x7D, 0x87, 0x88, 0x7F, 0x83, 0x89, 0x8F, 0x83, 0x75, 0x6B,
	0x75, 0x83, 0x8B, 0x89, 0x82, 0x82, 0x83, 0x85, 0x7D, 0x77, 0x74, 0x7D,
	0x85, 0x88, 0x83, 0x7F, 0x7E, 0x82, 0x81, 0x7D, 0x79, 0x7B, 0x80, 0x85,
	0x84, 0x80, 0x7D, 0x7E, 0x81, 0x80, 0x7E, 0x7C, 0x7D, 0x7F, 0x81, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7D, 0x7E, 0x7E, 0x82, 0x7D, 0x99, 0xBD,
	0xC8, 0xA4, 0x6F, 0x5F, 0x6A, 0x82, 0x7C, 0x78, 0x7B, 0x96, 0xA6, 0x9A,
	0x7D, 0x66, 0x6F, 0x79, 0x81, 0x77, 0x7B, 0x87, 0x95, 0x91, 0x80, 0x74,
	0x74, 0x7D, 0x7D, 0x7C, 0x7A, 0x83, 0x8B, 0x8A, 0x82, 0x79, 0x7A, 0x7D,
	0x7F, 0x7C, 0x7D, 0x80, 0x86, 0x86, 0x82, 0x7D, 0x7E, 0x83, 0x83, 0x7F,
	0x7B, 0x7F, 0x83, 0x83, 0x80, 0x7E, 0x80, 0x82, 0x81, 0x7E, 0x7D, 0x7F,
	0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x81,
	0x7D, 0x88, 0xB1, 0xBC, 0xAA, 0x7D, 0x72, 0x7A, 0x7C, 0x72, 0x6B, 0x83,
	0x97, 0x9F, 0x8C, 0x82, 0x81, 0x82, 0x79, 0x6E, 0x73, 0x80, 0x8B, 0x88,
	0x85, 0x85, 0x87, 0x82, 0x79, 0x75, 0x79, 0x80, 0x82, 0x83, 0x85, 0x87,
	0x85, 0x80, 0x7C, 0x7B, 0x7D, 0x7D, 0x7E, 0x80, 0x83, 0x84, 0x83, 0x80,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x80, 0x81, 0x82, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x7D, 0x80, 0x81, 0x82, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x81, 0xA0, 0xB0, 0xA6, 0x8C, 0x7E,
	0x83, 0x79, 0x70, 0x6B, 0x7F, 0x8D, 0x8E, 0x89, 0x8A, 0x90, 0x85, 0x79,
	0x73, 0x7A, 0x7E, 0x7B, 0x7D, 0x84, 0x8B, 0x86, 0x80, 0x7F, 0x80, 0x7E,
	0x79, 0x7B, 0x7F, 0x83, 0x81, 0x80, 0x83, 0x83, 0x80, 0x7C, 0x7D, 0x7F,
	0x7F, 0x7E, 0x7F, 0x83, 0x82, 0x81, 0x7F, 0x80, 0x80, 0x7E, 0x7D, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7F, 0x98, 0xA5, 0x9F, 0x95, 0x8F, 0x8F, 0x7E, 0x72, 0x71, 0x7B, 0x7F,
	0x7B, 0x81, 0x87, 0x8A, 0x82, 0x7D, 0x80, 0x7F, 0x7C, 0x78, 0x7E, 0x82,
	0x81, 0x7F, 0x80, 0x84, 0x81, 0x7E, 0x7D, 0x80, 0x80, 0x7E, 0x7E, 0x80,
	0x82, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x82, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x8A, 0x9B, 0x9C, 0x98, 0x93,
	0x93, 0x8B, 0x7D, 0x7B, 0x79, 0x7A, 0x74, 0x77, 0x7C, 0x7C, 0x7D, 0x7D,
	0x81, 0x81, 0x80, 0x80, 0x81, 0x82, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7E, 0x85, 0x90, 0x92, 0x95, 0x94, 0x94, 0x92, 0x8D, 0x8D, 0x89, 0x84,
	0x80, 0x7C, 0x7B, 0x77, 0x77, 0x77, 0x77, 0x79, 0x79, 0x7C, 0x7E, 0x80,
	0x82, 0x83, 0x85, 0x85, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x7F, 0x7E,
	0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81,
	0x82, 0x82, 0x82, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x8B, 0x8E, 0x8E, 0x90, 0x8E,
	0x8D, 0x8D, 0x8D, 0x8D, 0x87, 0x84, 0x80, 0x7E, 0x7D, 0x7C, 0x7C, 0x7A,
	0x7A, 0x7B, 0x7C, 0x7F, 0x81, 0x83, 0x84, 0x84, 0x85, 0x86, 0x86, 0x86,
	0x84, 0x83, 0x81, 0x80, 0x7F, 0x7D, 0x7D, 0x7C, 0x7B, 0x7B, 0x7C, 0x7D,
	0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81,
	0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x86, 0x8C,
	0x8C, 0x8E, 0x8E, 0x8D, 0x8D, 0x8D, 0x8E, 0x8A, 0x87, 0x84, 0x80, 0x7F,
	0x7E, 0x7E, 0x7C, 0x7B, 0x7B, 0x7C, 0x7E, 0x80, 0x82, 0x83, 0x84, 0x85,
	0x86, 0x86, 0x87, 0x86, 0x85, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7C,
	0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x83, 0x84, 0x84,
	0x84, 0x83, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82,
	0x87, 0x8B, 0x8C, 0x8E, 0x8D, 0x8C, 0x8C, 0x8D, 0x8D, 0x8A, 0x88, 0x85,
	0x82, 0x81, 0x80, 0x80, 0x7E, 0x7D, 0x7D, 0x7D, 0x7F, 0x80, 0x82, 0x83,
	0x83, 0x85, 0x85, 0x87, 0x87, 0x87, 0x86, 0x85, 0x84, 0x83, 0x82, 0x81,
	0x80, 0x7F, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81,
	0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x81,
	0x85, 0x87, 0x89, 0x8A, 0x8B, 0x8B, 0x8B, 0x8C, 0x8C, 0x8A, 0x89, 0x87,
	0x85, 0x83, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x84, 0x85, 0x85, 0x85, 0x85, 0x84,
	0x84, 0x83, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x82, 0x85, 0x86,
	0x87, 0x87, 0x88, 0x88, 0x89, 0x8A, 0x8A, 0x89, 0x88, 0x87, 0x86, 0x85,
	0x85, 0x84, 0x83, 0x82, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x83, 0x84, 0x84, 0x85, 0x85, 0x85,
	0x85, 0x85, 0x85, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAV10[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x80,
	0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x81, 0x82, 0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F,
	0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80, 0x82, 0x83,
	0x81, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x7E, 0x7E, 0x7F,
	0x81, 0x81, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x83, 0x83,
	0x84, 0x83, 0x7E, 0x7D, 0x7D, 0x80, 0x82, 0x7D, 0x7E, 0x7F, 0x7F, 0x81,
	0x82, 0x83, 0x7F, 0x80, 0x7F, 0x7D, 0x7D, 0x80, 0x80, 0x7F, 0x82, 0x7D,
	0x7F, 0x81, 0x82, 0x80, 0x7E, 0x7E, 0x7E, 0x85, 0x81, 0x7E, 0x81, 0x7F,
	0x7F, 0x81, 0x83, 0x80, 0x7E, 0x80, 0x7C, 0x7C, 0x7E, 0x82, 0x7F, 0x82,
	0x80, 0x7C, 0x7F, 0x7E, 0x7C, 0x81, 0x7D, 0x7A, 0x83, 0x82, 0x84, 0x8B,
	0x89, 0x85, 0x89, 0x84, 0x81, 0x83, 0x7F, 0x7C, 0x79, 0x79, 0x7A, 0x78,
	0x75, 0x79, 0x7C, 0x7C, 0x7E, 0x83, 0x7E, 0x7F, 0x83, 0x81, 0x7E, 0x7F,
	0x7C, 0x76, 0x7C, 0x7C, 0x7E, 0x82, 0x86, 0x85, 0x84, 0x85, 0x85, 0x83,
	0x83, 0x86, 0x83, 0x85, 0x81, 0x80, 0x7D, 0x7D, 0x80, 0x7A, 0x7D, 0x7E,
	0x7A, 0x7F, 0x83, 0x80, 0x83, 0x88, 0x85, 0x85, 0x85, 0x82, 0x7B, 0x7D,
	0x7F, 0x7A, 0x7F, 0x84, 0x7C, 0x7D, 0x82, 0x7C, 0x7D, 0x7E, 0x80, 0x7E,
	0x81, 0x84, 0x83, 0x84, 0x88, 0x85, 0x81, 0x81, 0x80, 0x7B, 0x7F, 0x81,
	0x7D, 0x80, 0x80, 0x7F, 0x80, 0x84, 0x83, 0x82, 0x83, 0x82, 0x7F, 0x81,
	0x7C, 0x80, 0x82, 0x7F, 0x7E, 0x7F, 0x7E, 0x7C, 0x7C, 0x7E, 0x7F, 0x7F,
	0x7D, 0x7A, 0x80, 0x7E, 0x7F, 0x81, 0x82, 0x81, 0x83, 0x81, 0x7F, 0x81,
	0x7E, 0x7E, 0x7D, 0x80, 0x7D, 0x80, 0x82, 0x80, 0x82, 0x84, 0x82, 0x7F,
	0x82, 0x80, 0x7C, 0x82, 0x7F, 0x7E, 0x83, 0x80, 0x7B, 0x81, 0x83, 0x7A,
	0x82, 0x81, 0x7D, 0x80, 0x81, 0x7E, 0x80, 0x83, 0x7E, 0x80, 0x82, 0x7E,
	0x80, 0x82, 0x80, 0x80, 0x81, 0x7F, 0x7E, 0x81, 0x81, 0x7D, 0x80, 0x81,
	0x7D, 0x81, 0x80, 0x81, 0x7E, 0x81, 0x7F, 0x7C, 0x82, 0x7E, 0x7F, 0x81,
	0x80, 0x7D, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x80, 0x7D, 0x81, 0x81, 0x7E,
	0x80, 0x80, 0x7D, 0x80, 0x81, 0x7E, 0x81, 0x81, 0x7D, 0x80, 0x81, 0x7E,
	0x80, 0x82, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x81,
	0x7F, 0x80, 0x81, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x7E,
	0x82, 0x80, 0x7F, 0x82, 0x82, 0x7F, 0x82, 0x80, 0x7D, 0x81, 0x7F, 0x7D,
	0x7E, 0x80, 0x7D, 0x7E, 0x82, 0x7C, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x80,
	0x7E, 0x83, 0x7E, 0x7F, 0x83, 0x80, 0x7F, 0x81, 0x82, 0x7D, 0x82, 0x83,
	0x7E, 0x82, 0x83, 0x7E, 0x7E, 0x84, 0x7D, 0x7E, 0x83, 0x7D, 0x7E, 0x81,
	0x80, 0x7E, 0x82, 0x81, 0x7D, 0x82, 0x82, 0x7D, 0x81, 0x82, 0x7E, 0x82,
	0x84, 0x7D, 0x83, 0x84, 0x80, 0x85, 0x83, 0x81, 0x81, 0x83, 0x80, 0x7F,
	0x82, 0x7F, 0x7E, 0x81, 0x7F, 0x80, 0x82, 0x82, 0x80, 0x82, 0x81, 0x80,
	0x81, 0x81, 0x82, 0x81, 0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x82, 0x8A, 0x87, 0x8D,
	0x8F, 0x8D, 0x8D, 0x8C, 0x8A, 0x86, 0x89, 0x85, 0x84, 0x85, 0x84, 0x82,
	0x82, 0x82, 0x7F, 0x80, 0x7F, 0x7D, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7C, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x7F, 0x8C, 0x97, 0x97, 0xA5, 0xA6, 0xA3, 0x9F, 0x9B,
	0x91, 0x89, 0x89, 0x81, 0x80, 0x82, 0x81, 0x81, 0x82, 0x82, 0x7E, 0x7F,
	0x7D, 0x7A, 0x7A, 0x7A, 0x7A, 0x7B, 0x7E, 0x7D, 0x7E, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E,
	0x87, 0x9A, 0xA0, 0xAD, 0xB5, 0xB0, 0xA8, 0x9E, 0x91, 0x81, 0x7D, 0x78,
	0x75, 0x7B, 0x80, 0x82, 0x85, 0x88, 0x84, 0x81, 0x81, 0x7C, 0x7A, 0x7C,
	0x7C, 0x7C, 0x80, 0x82, 0x80, 0x82, 0x82, 0x7F, 0x7C, 0x7C, 0x7A, 0x79,
	0x7C, 0x7C, 0x7D, 0x80, 0x81, 0x80, 0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x94, 0xAA, 0xB0,
	0xC2, 0xC1, 0xB2, 0xA1, 0x90, 0x7C, 0x6D, 0x70, 0x6F, 0x74, 0x82, 0x89,
	0x8C, 0x8F, 0x8F, 0x87, 0x82, 0x81, 0x79, 0x79, 0x7B, 0x7C, 0x7D, 0x82,
	0x84, 0x82, 0x83, 0x83, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x81,
	0x82, 0x81, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7E, 0x81, 0x7D, 0x8A, 0xB1, 0xB3, 0xBE, 0xC7, 0xAF,
	0x99, 0x87, 0x77, 0x64, 0x68, 0x73, 0x76, 0x87, 0x94, 0x94, 0x93, 0x91,
	0x88, 0x7B, 0x7A, 0x76, 0x72, 0x78, 0x7E, 0x80, 0x84, 0x8A, 0x86, 0x84,
	0x84, 0x7F, 0x7B, 0x7B, 0x7C, 0x7B, 0x7E, 0x83, 0x83, 0x84, 0x86, 0x83,
	0x80, 0x80, 0x7E, 0x7B, 0x7D, 0x7E, 0x7F, 0x80, 0x82, 0x82, 0x80, 0x82,
	0x7F, 0x7F, 0x7E, 0x80, 0x7B, 0x93, 0xC0, 0xB5, 0xC1, 0xC3, 0x9E, 0x85,
	0x76, 0x67, 0x5A, 0x6B, 0x7C, 0x81, 0x93, 0x9E, 0x94, 0x8E, 0x89, 0x7A,
	0x6F, 0x72, 0x74, 0x74, 0x81, 0x87, 0x88, 0x8A, 0x8A, 0x83, 0x7D, 0x7D,
	0x79, 0x77, 0x7C, 0x7F, 0x7F, 0x83, 0x86, 0x83, 0x82, 0x81, 0x7D, 0x7C,
	0x7D, 0x7D, 0x7E, 0x80, 0x82, 0x81, 0x81, 0x82, 0x7F, 0x80, 0x7D, 0x7F,
	0x7D, 0x7F, 0x7F, 0x81, 0x7D, 0x9A, 0xCE, 0xB2, 0xBF, 0xBF, 0x88, 0x75,
	0x68, 0x61, 0x59, 0x74, 0x8A, 0x88, 0x9C, 0x9F, 0x8E, 0x83, 0x7E, 0x72,
	0x68, 0x75, 0x79, 0x7B, 0x89, 0x8E, 0x89, 0x86, 0x86, 0x7C, 0x76, 0x7A,
	0x78, 0x7A, 0x80, 0x85, 0x83, 0x84, 0x87, 0x7C, 0x7A, 0x7D, 0x78, 0x79,
	0x7F, 0x81, 0x80, 0x84, 0x85, 0x80, 0x80, 0x7F, 0x7C, 0x7C, 0x7F, 0x7E,
	0x7E, 0x82, 0x81, 0x81, 0x80, 0x81, 0x7F, 0xBF, 0xC2, 0xA9, 0xCB, 0x9F,
	0x78, 0x70, 0x67, 0x58, 0x62, 0x86, 0x84, 0x8E, 0xA3, 0x95, 0x87, 0x82,
	0x7B, 0x69, 0x6E, 0x7A, 0x76, 0x81, 0x8C, 0x8C, 0x86, 0x88, 0x84, 0x77,
	0x79, 0x7B, 0x77, 0x7C, 0x83, 0x83, 0x82, 0x8B, 0x88, 0x80, 0x85, 0x7F,
	0x7A, 0x7B, 0x7E, 0x7C, 0x7D, 0x84, 0x82, 0x82, 0x82, 0x82, 0x7D, 0x7E,
	0x7F, 0x7D, 0x7D, 0x81, 0x7F, 0x81, 0x81, 0x82, 0x7C, 0x92, 0xD2, 0xAD,
	0xB8, 0xC3, 0x88, 0x76, 0x69, 0x67, 0x53, 0x72, 0x8B, 0x82, 0x99, 0x9F,
	0x93, 0x81, 0x84, 0x76, 0x66, 0x75, 0x77, 0x79, 0x84, 0x8E, 0x8A, 0x85,
	0x89, 0x7F, 0x77, 0x7B, 0x79, 0x78, 0x7E, 0x81, 0x7F, 0x82, 0x83, 0x80,
	0x7F, 0x7F, 0x7F, 0x7B, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x7E, 0x81,
	0x80, 0x7D, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7E, 0x82, 0x7E, 0x82,
	0x7A, 0xA7, 0xD3, 0xA6, 0xC4, 0xB5, 0x7C, 0x70, 0x68, 0x5F, 0x55, 0x7E,
	0x8A, 0x89, 0x9F, 0x9F, 0x8E, 0x80, 0x81, 0x71, 0x66, 0x77, 0x78, 0x7A,
	0x87, 0x90, 0x88, 0x86, 0x89, 0x7C, 0x77, 0x7B, 0x7F, 0x79, 0x82, 0x88,
	0x81, 0x83, 0x85, 0x82, 0x7B, 0x7E, 0x7F, 0x7A, 0x7E, 0x82, 0x7F, 0x80,
	0x84, 0x81, 0x7E, 0x80, 0x81, 0x7B, 0x7F, 0x80, 0x7F, 0x7F, 0x82, 0x81,
	0x7F, 0x82, 0x80, 0x7E, 0x82, 0x7A, 0xAD, 0xCA, 0xA3, 0xC0, 0xA9, 0x7A,
	0x6C, 0x69, 0x64, 0x5A, 0x83, 0x8B, 0x8C, 0x9B, 0x9C, 0x8D, 0x7C, 0x82,
	0x6F, 0x6A, 0x76, 0x7B, 0x7E, 0x83, 0x92, 0x86, 0x86, 0x86, 0x7D, 0x78,
	0x77, 0x7D, 0x77, 0x7F, 0x84, 0x84, 0x83, 0x85, 0x84, 0x7C, 0x7F, 0x7D,
	0x7B, 0x7C, 0x7F, 0x82, 0x7E, 0x85, 0x82, 0x80, 0x7F, 0x80, 0x7E, 0x7C,
	0x81, 0x7B, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7D, 0x83, 0x79,
	0xAA, 0xC9, 0x9F, 0xB8, 0xA4, 0x7C, 0x67, 0x6A, 0x6A, 0x5D, 0x85, 0x8E,
	0x90, 0x94, 0x9A, 0x8D, 0x76, 0x7E, 0x73, 0x6E, 0x73, 0x81, 0x84, 0x82,
	0x90, 0x89, 0x82, 0x7F, 0x7F, 0x78, 0x75, 0x7E, 0x7D, 0x7F, 0x83, 0x87,
	0x83, 0x80, 0x83, 0x7D, 0x7B, 0x7C, 0x7E, 0x7D, 0x7F, 0x83, 0x81, 0x81,
	0x82, 0x82, 0x7E, 0x7E, 0x80, 0x7D, 0x7E, 0x7F, 0x82, 0x7F, 0x81, 0x81,
	0x7F, 0x7F, 0x7F, 0x80, 0x7D, 0x80, 0x80, 0xB7, 0xBB, 0x9F, 0xB4, 0x93,
	0x79, 0x63, 0x6D, 0x6B, 0x64, 0x8A, 0x90, 0x93, 0x91, 0x95, 0x89, 0x71,
	0x7A, 0x72, 0x70, 0x76, 0x83, 0x88, 0x82, 0x8F, 0x88, 0x80, 0x7D, 0x7C,
	0x7A, 0x74, 0x7F, 0x81, 0x80, 0x84, 0x86, 0x84, 0x7E, 0x80, 0x7E, 0x7A,
	0x7D, 0x7D, 0x7F, 0x7E, 0x82, 0x82, 0x81, 0x81, 0x7F, 0x80, 0x7D, 0x7E,
	0x7F, 0x7E, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x84, 0xBA, 0xB4, 0x9E, 0xAE, 0x8B, 0x72, 0x5D, 0x6B, 0x6C,
	0x67, 0x8C, 0x94, 0x93, 0x90, 0x92, 0x87, 0x6F, 0x76, 0x74, 0x71, 0x77,
	0x84, 0x8B, 0x83, 0x8B, 0x8A, 0x7F, 0x7A, 0x7B, 0x7B, 0x76, 0x7D, 0x83,
	0x82, 0x82, 0x84, 0x84, 0x7C, 0x7D, 0x7F, 0x7C, 0x7C, 0x7F, 0x82, 0x7F,
	0x81, 0x83, 0x80, 0x7F, 0x7E, 0x80, 0x7D, 0x7D, 0x81, 0x7F, 0x80, 0x80,
	0x81, 0x80, 0x7E, 0x81, 0x7E, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7D, 0x93,
	0xBE, 0xA7, 0xA5, 0xA5, 0x88, 0x70, 0x61, 0x73, 0x69, 0x71, 0x8C, 0x92,
	0x93, 0x8C, 0x94, 0x83, 0x72, 0x78, 0x75, 0x74, 0x75, 0x85, 0x88, 0x82,
	0x8B, 0x82, 0x7A, 0x75, 0x76, 0x79, 0x74, 0x7F, 0x83, 0x84, 0x84, 0x85,
	0x86, 0x7C, 0x7D, 0x7D, 0x7A, 0x7B, 0x7D, 0x82, 0x80, 0x82, 0x84, 0x81,
	0x80, 0x7E, 0x80, 0x7D, 0x7C, 0x80, 0x7F, 0x82, 0x82, 0x83, 0x83, 0x81,
	0x81, 0x7F, 0x7E, 0x7D, 0x7D, 0x80, 0x7D, 0x82, 0x7F, 0x8B, 0xB3, 0xA9,
	0xA6, 0xA6, 0x95, 0x81, 0x6B, 0x74, 0x6D, 0x6C, 0x7B, 0x88, 0x8E, 0x8A,
	0x93, 0x92, 0x88, 0x83, 0x82, 0x7F, 0x75, 0x78, 0x7D, 0x7B, 0x7C, 0x81,
	0x86, 0x82, 0x82, 0x85, 0x82, 0x7E, 0x7E, 0x80, 0x7D, 0x7B, 0x7F, 0x80,
	0x7F, 0x7F, 0x82, 0x82, 0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x7F,
	0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x89, 0xA3, 0xA1, 0xA2,
	0xA3, 0x99, 0x92, 0x85, 0x8A, 0x84, 0x7A, 0x7A, 0x75, 0x75, 0x71, 0x77,
	0x7E, 0x7C, 0x81, 0x84, 0x86, 0x85, 0x85, 0x89, 0x85, 0x83, 0x82, 0x81,
	0x7E, 0x7B, 0x7D, 0x7C, 0x7B, 0x7C, 0x7D, 0x7F, 0x7D, 0x7F, 0x81, 0x80,
	0x81, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x90, 0x94, 0x95,
	0x98, 0x94, 0x94, 0x90, 0x92, 0x91, 0x88, 0x85, 0x7F, 0x7B, 0x78, 0x78,
	0x7A, 0x78, 0x79, 0x7A, 0x7C, 0x80, 0x82, 0x87, 0x88, 0x88, 0x8A, 0x89,
	0x8A, 0x88, 0x87, 0x85, 0x81, 0x7F, 0x7D, 0x7C, 0x7B, 0x7A, 0x7A, 0x7A,
	0x7B, 0x7C, 0x7E, 0x80, 0x82, 0x83, 0x84, 0x84, 0x85, 0x85, 0x85, 0x84,
	0x82, 0x81, 0x81, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x82, 0x82, 0x81, 0x86, 0x91, 0x91,
	0x92, 0x93, 0x8F, 0x8F, 0x8E, 0x90, 0x8D, 0x86, 0x84, 0x7E, 0x7D, 0x7D,
	0x7C, 0x7D, 0x7A, 0x7A, 0x7C, 0x7E, 0x82, 0x84, 0x86, 0x86, 0x86, 0x87,
	0x87, 0x88, 0x87, 0x85, 0x82, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B,
	0x7B, 0x7C, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x83, 0x84, 0x84, 0x83,
	0x82, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x82, 0x89,
	0x8E, 0x8E, 0x90, 0x8F, 0x8E, 0x8E, 0x8E, 0x8E, 0x8A, 0x87, 0x83, 0x7F,
	0x7F, 0x7D, 0x7E, 0x7C, 0x7B, 0x7B, 0x7C, 0x7F, 0x81, 0x83, 0x84, 0x84,
	0x86, 0x87, 0x88, 0x88, 0x87, 0x86, 0x84, 0x83, 0x81, 0x80, 0x7F, 0x7D,
	0x7C, 0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x84,
	0x84, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x86, 0x8B, 0x8B, 0x8C, 0x8C, 0x8B, 0x8B, 0x8B, 0x8C, 0x8A, 0x87,
	0x85, 0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7C, 0x7C, 0x7C, 0x7D, 0x7F, 0x80,
	0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x86, 0x85, 0x85, 0x84, 0x83,
	0x82, 0x81, 0x80, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x82, 0x82, 0x82, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x82, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8A, 0x8B, 0x8C,
	0x8B, 0x8A, 0x89, 0x87, 0x86, 0x85, 0x84, 0x83, 0x81, 0x80, 0x7F, 0x7F,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83,
	0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x84, 0x85, 0x86, 0x86, 0x87, 0x87,
	0x87, 0x88, 0x88, 0x87, 0x86, 0x86, 0x85, 0x84, 0x85, 0x84, 0x84, 0x84,
	0x85, 0x84, 0x84, 0x85, 0x85, 0x84, 0x84, 0x83, 0x83, 0x84, 0x84, 0x84,
	0x84, 0x85, 0x85, 0x86, 0x86, 0x86, 0x87, 0x86, 0x86, 0x84, 0x83, 0x83,
	0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x83, 0x83,
	0x83, 0x84, 0x85, 0x86, 0x86, 0x87, 0x86, 0x85, 0x85, 0x85, 0x84, 0x84,
	0x85, 0x84, 0x84, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x84,
	0x83, 0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D,
	0x7D, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80
};
const unsigned char WAV100[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81,
	0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F,
	0x7E, 0x7F, 0x81, 0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x82, 0x80, 0x7E, 0x7D, 0x7F, 0x82, 0x81,
	0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7E, 0x7E, 0x7F,
	0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x81,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x82, 0x80, 0x7E, 0x7F, 0x80, 0x82, 0x80,
	0x7D, 0x7C, 0x80, 0x82, 0x82, 0x7F, 0x7D, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x7F,
	0x80, 0x81, 0x80, 0x7F, 0x7D, 0x7F, 0x80, 0x82, 0x81, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x7E, 0x7D, 0x7E, 0x80,
	0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7C, 0x80, 0x81, 0x82, 0x7F, 0x7E, 0x7D,
	0x7F, 0x81, 0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x81, 0x81, 0x81, 0x7F, 0x80,
	0x7E, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7F,
	0x82, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x81,
	0x7F, 0x7E, 0x7E, 0x81, 0x82, 0x81, 0x7F, 0x7E, 0x7E, 0x81, 0x82, 0x80,
	0x7F, 0x7E, 0x80, 0x81, 0x82, 0x7F, 0x7F, 0x7F, 0x82, 0x82, 0x7F, 0x7E,
	0x7C, 0x80, 0x83, 0x85, 0x82, 0x7E, 0x7C, 0x7D, 0x81, 0x85, 0x83, 0x7E,
	0x7C, 0x7D, 0x82, 0x82, 0x82, 0x7F, 0x7D, 0x7E, 0x7F, 0x80, 0x7F, 0x81,
	0x80, 0x81, 0x7E, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x7E, 0x7E, 0x7C,
	0x7E, 0x7F, 0x82, 0x83, 0x81, 0x7F, 0x7B, 0x7D, 0x7D, 0x80, 0x7F, 0x7F,
	0x7C, 0x7D, 0x80, 0x83, 0x82, 0x7A, 0x79, 0x7A, 0x82, 0x81, 0x7C, 0x78,
	0x78, 0x7D, 0x81, 0x84, 0x80, 0x80, 0x7E, 0x81, 0x86, 0x89, 0x86, 0x85,
	0x87, 0x8D, 0x90, 0x8A, 0x83, 0x7A, 0x7D, 0x81, 0x89, 0x87, 0x82, 0x80,
	0x7E, 0x81, 0x7C, 0x81, 0x83, 0x8B, 0x8A, 0x85, 0x7F, 0x7D, 0x81, 0x7C,
	0x7C, 0x7B, 0x83, 0x7F, 0x7E, 0x7B, 0x79, 0x7C, 0x80, 0x86, 0x82, 0x7B,
	0x73, 0x7B, 0x83, 0x8A, 0x8A, 0x83, 0x7B, 0x7C, 0x83, 0x87, 0x84, 0x7C,
	0x7B, 0x7E, 0x82, 0x80, 0x7D, 0x7C, 0x7F, 0x83, 0x94, 0x9F, 0x9F, 0x91,
	0x83, 0x81, 0x85, 0x8A, 0x85, 0x83, 0x81, 0x85, 0x83, 0x7F, 0x7B, 0x7B,
	0x81, 0x82, 0x81, 0x7D, 0x7D, 0x7F, 0x80, 0x7F, 0x7C, 0x7D, 0x7F, 0x81,
	0x80, 0x7F, 0x7D, 0x7F, 0x81, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x81, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7D, 0x7C, 0x7C, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x93, 0xA9, 0xB2,
	0xA1, 0x88, 0x7D, 0x80, 0x8B, 0x8A, 0x85, 0x80, 0x86, 0x88, 0x85, 0x7C,
	0x77, 0x7B, 0x82, 0x85, 0x80, 0x7D, 0x7C, 0x7F, 0x80, 0x7F, 0x7C, 0x7D,
	0x80, 0x82, 0x82, 0x7E, 0x7D, 0x7E, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x81,
	0x80, 0x80, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7E, 0x7E, 0x7D, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x83, 0xA1, 0xBC,
	0xC3, 0xA4, 0x81, 0x6F, 0x77, 0x89, 0x8D, 0x8A, 0x81, 0x86, 0x88, 0x86,
	0x7A, 0x73, 0x77, 0x81, 0x8A, 0x85, 0x81, 0x7E, 0x85, 0x87, 0x84, 0x7C,
	0x79, 0x7E, 0x83, 0x86, 0x81, 0x7D, 0x7C, 0x80, 0x82, 0x81, 0x7E, 0x7D,
	0x7F, 0x82, 0x82, 0x7F, 0x7D, 0x7E, 0x80, 0x82, 0x80, 0x7F, 0x7E, 0x80,
	0x7F, 0x7E, 0x7B, 0x7C, 0x7F, 0x82, 0x82, 0x80, 0x7D, 0x82, 0xAC, 0xD0,
	0xD6, 0xA5, 0x70, 0x58, 0x6B, 0x89, 0x92, 0x8B, 0x80, 0x8A, 0x91, 0x91,
	0x7B, 0x6D, 0x6D, 0x7F, 0x8E, 0x8D, 0x83, 0x79, 0x7E, 0x83, 0x84, 0x7B,
	0x77, 0x7A, 0x84, 0x88, 0x85, 0x7D, 0x7A, 0x7E, 0x82, 0x82, 0x7D, 0x7C,
	0x7F, 0x83, 0x84, 0x80, 0x7D, 0x7C, 0x80, 0x81, 0x81, 0x7E, 0x7E, 0x80,
	0x80, 0x80, 0x7C, 0x7D, 0x7E, 0x82, 0x80, 0x82, 0x7A, 0x94, 0xCB, 0xE4,
	0xC8, 0x7D, 0x55, 0x56, 0x7B, 0x89, 0x86, 0x81, 0x90, 0xA5, 0xA0, 0x86,
	0x64, 0x63, 0x73, 0x89, 0x8A, 0x84, 0x81, 0x8C, 0x90, 0x87, 0x75, 0x6C,
	0x76, 0x82, 0x89, 0x83, 0x81, 0x81, 0x87, 0x84, 0x7C, 0x76, 0x77, 0x80,
	0x84, 0x85, 0x7F, 0x80, 0x81, 0x83, 0x7E, 0x7B, 0x7B, 0x7F, 0x83, 0x82,
	0x80, 0x7D, 0x7F, 0x7F, 0x81, 0x7C, 0x80, 0x79, 0xA3, 0xDA, 0xEA, 0xB9,
	0x6C, 0x51, 0x5D, 0x7E, 0x7C, 0x7C, 0x85, 0xA6, 0xB2, 0x9C, 0x76, 0x5E,
	0x69, 0x78, 0x83, 0x7C, 0x83, 0x8E, 0x9B, 0x93, 0x7F, 0x70, 0x6F, 0x7A,
	0x7D, 0x80, 0x7F, 0x88, 0x8C, 0x8B, 0x7F, 0x77, 0x77, 0x7B, 0x80, 0x7E,
	0x81, 0x82, 0x88, 0x84, 0x80, 0x7A, 0x7B, 0x7D, 0x7F, 0x80, 0x7F, 0x83,
	0x7D, 0x76, 0x73, 0x77, 0x82, 0x81, 0x88, 0xC2, 0xE9, 0xD9, 0x8D, 0x57,
	0x57, 0x6F, 0x7A, 0x6E, 0x7C, 0x99, 0xB8, 0xA7, 0x84, 0x67, 0x6A, 0x75,
	0x77, 0x74, 0x79, 0x8F, 0x9B, 0x96, 0x7E, 0x72, 0x72, 0x79, 0x79, 0x76,
	0x7D, 0x88, 0x90, 0x89, 0x80, 0x79, 0x7B, 0x7C, 0x7A, 0x7A, 0x7D, 0x86,
	0x87, 0x85, 0x7F, 0x7E, 0x7E, 0x7D, 0x7C, 0x7B, 0x7F, 0x82, 0x84, 0x81,
	0x82, 0x85, 0x84, 0x82, 0x77, 0x9D, 0xD5, 0xDE, 0xAD, 0x71, 0x6C, 0x75,
	0x77, 0x60, 0x68, 0x8A, 0xAB, 0xA7, 0x8B, 0x7D, 0x7C, 0x80, 0x6E, 0x68,
	0x6F, 0x89, 0x93, 0x8E, 0x84, 0x82, 0x86, 0x7D, 0x74, 0x6F, 0x7A, 0x83,
	0x85, 0x82, 0x83, 0x88, 0x85, 0x7E, 0x77, 0x7A, 0x7D, 0x7F, 0x7E, 0x80,
	0x83, 0x86, 0x82, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D, 0x7E, 0x80, 0x83, 0x81,
	0x7F, 0x78, 0x7D, 0x79, 0xA5, 0xD0, 0xCF, 0xA7, 0x81, 0x83, 0x78, 0x69,
	0x53, 0x6C, 0x8B, 0x9C, 0x94, 0x8E, 0x96, 0x8F, 0x7F, 0x67, 0x6C, 0x75,
	0x7F, 0x7B, 0x81, 0x8E, 0x92, 0x8B, 0x7A, 0x77, 0x76, 0x77, 0x72, 0x76,
	0x80, 0x87, 0x88, 0x84, 0x85, 0x84, 0x80, 0x78, 0x78, 0x7B, 0x7E, 0x7E,
	0x7F, 0x84, 0x85, 0x84, 0x7F, 0x7F, 0x7F, 0x7E, 0x7B, 0x7C, 0x7F, 0x82,
	0x80, 0x84, 0x80, 0x99, 0xC5, 0xCA, 0xB4, 0x95, 0x93, 0x85, 0x6C, 0x58,
	0x64, 0x7C, 0x82, 0x84, 0x8D, 0xA0, 0x9B, 0x8A, 0x7B, 0x7E, 0x7A, 0x70,
	0x6B, 0x76, 0x85, 0x85, 0x84, 0x87, 0x8F, 0x89, 0x7F, 0x7B, 0x7F, 0x7E,
	0x78, 0x77, 0x7D, 0x83, 0x80, 0x7F, 0x82, 0x86, 0x82, 0x7E, 0x7E, 0x81,
	0x7F, 0x7C, 0x7C, 0x80, 0x81, 0x7F, 0x7E, 0x81, 0x83, 0x80, 0x7E, 0x7F,
	0x7F, 0x7D, 0x7B, 0x80, 0xA6, 0xB8, 0xB7, 0xAD, 0xAC, 0xA8, 0x91, 0x80,
	0x76, 0x78, 0x6D, 0x69, 0x6D, 0x77, 0x7B, 0x7A, 0x81, 0x88, 0x8A, 0x85,
	0x86, 0x87, 0x85, 0x80, 0x7D, 0x7E, 0x7D, 0x7B, 0x7B, 0x7D, 0x7C, 0x7C,
	0x7D, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x82, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7D, 0x90, 0xA4, 0xA9, 0xAD, 0xAA, 0xAC,
	0xA5, 0xA5, 0xA2, 0x9C, 0x91, 0x85, 0x7F, 0x77, 0x75, 0x71, 0x71, 0x6F,
	0x70, 0x72, 0x76, 0x7C, 0x7F, 0x84, 0x86, 0x89, 0x8A, 0x8C, 0x8C, 0x8A,
	0x89, 0x85, 0x83, 0x80, 0x7E, 0x7B, 0x7A, 0x78, 0x77, 0x78, 0x78, 0x7A,
	0x7B, 0x7E, 0x7F, 0x81, 0x83, 0x84, 0x85, 0x85, 0x85, 0x84, 0x83, 0x82,
	0x82, 0x83, 0x83, 0x83, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x8F,
	0x9C, 0xA1, 0xA8, 0xA6, 0xA5, 0xA0, 0xA1, 0xA1, 0x9C, 0x96, 0x8B, 0x83,
	0x7A, 0x78, 0x77, 0x77, 0x76, 0x74, 0x75, 0x77, 0x7D, 0x83, 0x8A, 0x8D,
	0x8F, 0x8F, 0x8F, 0x90, 0x90, 0x90, 0x8D, 0x88, 0x84, 0x7F, 0x7C, 0x7A,
	0x79, 0x78, 0x77, 0x77, 0x77, 0x79, 0x7C, 0x7F, 0x82, 0x84, 0x85, 0x86,
	0x87, 0x88, 0x89, 0x89, 0x88, 0x86, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7C,
	0x7B, 0x7A, 0x7A, 0x7B, 0x7B, 0x82, 0x92, 0x9A, 0xA3, 0xA7, 0xA6, 0xA5,
	0xA2, 0xA4, 0xA1, 0x9E, 0x97, 0x8D, 0x84, 0x7B, 0x77, 0x73, 0x73, 0x72,
	0x71, 0x72, 0x72, 0x76, 0x7B, 0x82, 0x87, 0x8B, 0x8E, 0x8F, 0x90, 0x90,
	0x90, 0x90, 0x8D, 0x8A, 0x85, 0x81, 0x7D, 0x7A, 0x79, 0x77, 0x77, 0x76,
	0x76, 0x77, 0x78, 0x7B, 0x7D, 0x81, 0x83, 0x85, 0x86, 0x87, 0x88, 0x88,
	0x88, 0x87, 0x86, 0x84, 0x82, 0x80, 0x7E, 0x7D, 0x7C, 0x7B, 0x7A, 0x7A,
	0x7A, 0x7F, 0x8A, 0x92, 0x9B, 0xA1, 0xA2, 0xA3, 0xA0, 0xA1, 0xA0, 0xA0,
	0x9E, 0x98, 0x92, 0x8A, 0x83, 0x7E, 0x7A, 0x79, 0x77, 0x77, 0x76, 0x75,
	0x76, 0x78, 0x7C, 0x80, 0x84, 0x88, 0x8A, 0x8B, 0x8C, 0x8D, 0x8D, 0x8D,
	0x8D, 0x8C, 0x8A, 0x88, 0x85, 0x83, 0x81, 0x7F, 0x7E, 0x7C, 0x7C, 0x7B,
	0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x82, 0x83, 0x83,
	0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x84, 0x89,
	0x8C, 0x92, 0x94, 0x95, 0x94, 0x93, 0x92, 0x91, 0x90, 0x8F, 0x8C, 0x89,
	0x86, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C,
	0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x86, 0x89, 0x86, 0x8C,
	0x89, 0x88, 0x89, 0x87, 0x86, 0x86, 0x84, 0x84, 0x83, 0x81, 0x81, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x84, 0x89, 0x7E, 0x85, 0x87, 0x7F,
	0x82, 0x80, 0x80, 0x82, 0x7F, 0x80, 0x82, 0x80, 0x7B, 0x82, 0x80, 0x7A,
	0x81, 0x83, 0x7D, 0x7F, 0x82, 0x7A, 0x81, 0x7F, 0x7A, 0x82, 0x7E, 0x78,
	0x83, 0x81, 0x7A, 0x82, 0x7B, 0x7C, 0x85, 0x7C, 0x7C, 0x85, 0x7D, 0x7D,
	0x82, 0x7B, 0x80, 0x7F, 0x75, 0x80, 0x83, 0x78, 0x7D, 0x85, 0x7C, 0x7A,
	0x85, 0x7F, 0x7B, 0x80, 0x7E, 0x7D, 0x7E, 0x80, 0x7B, 0x80, 0x81, 0x78,
	0x83, 0x84, 0x79, 0x81, 0x89, 0x7D, 0x7E, 0x86, 0x81, 0x7E, 0x82, 0x7F,
	0x7C, 0x84, 0x82, 0x7B, 0x81, 0x86, 0x7F, 0x80, 0x86, 0x7E, 0x7F, 0x87,
	0x7B, 0x7B, 0x83, 0x7E, 0x7B, 0x80, 0x82, 0x7F, 0x7F, 0x7B, 0x84, 0x83,
	0x76, 0x81, 0x8B, 0x7A, 0x7A, 0x85, 0x7F, 0x7F, 0x7F, 0x7E, 0x86, 0x7E,
	0x78, 0x88, 0x84, 0x76, 0x81, 0x84, 0x7D, 0x7F, 0x81, 0x81, 0x81, 0x7E,
	0x7D, 0x84, 0x7D, 0x79, 0x81, 0x7E, 0x7B, 0x7E, 0x7B, 0x7C, 0x84, 0x7E,
	0x7B, 0x7E, 0x7E, 0x7F, 0x7F, 0x7C, 0x79, 0x7F, 0x7E, 0x7B, 0x7D, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x87, 0x83, 0x7A, 0x82, 0x86, 0x7D, 0x79, 0x81,
	0x81, 0x7E, 0x8B, 0x85, 0x81, 0x8B, 0x8C, 0x83, 0x84, 0x89, 0x84, 0x80,
	0x80, 0x80, 0x7E, 0x7D, 0x7B, 0x7C, 0x7E, 0x7C, 0x7B, 0x7E, 0x7F, 0x7E,
	0x7D, 0x7E, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x82, 0x93, 0x96, 0x8B, 0x8E, 0x9C, 0x97, 0x88, 0x87,
	0x8A, 0x85, 0x7D, 0x78, 0x76, 0x79, 0x79, 0x75, 0x75, 0x7E, 0x81, 0x7E,
	0x80, 0x87, 0x89, 0x86, 0x85, 0x86, 0x86, 0x84, 0x80, 0x7D, 0x7D, 0x7E,
	0x7B, 0x78, 0x7B, 0x7E, 0x7D, 0x7D, 0x7F, 0x82, 0x83, 0x83, 0x82, 0x83,
	0x83, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x7C, 0x7C, 0x7D, 0x7E, 0x7D, 0x7D,
	0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x91, 0xA6, 0xA1, 0x92, 0x9B, 0xA9,
	0x9C, 0x88, 0x85, 0x87, 0x7F, 0x76, 0x6F, 0x6E, 0x74, 0x7A, 0x76, 0x76,
	0x83, 0x8C, 0x88, 0x86, 0x8C, 0x8D, 0x88, 0x84, 0x80, 0x7D, 0x7D, 0x7B,
	0x76, 0x75, 0x7A, 0x7D, 0x7B, 0x7D, 0x83, 0x85, 0x85, 0x85, 0x85, 0x84,
	0x84, 0x82, 0x7E, 0x7D, 0x7D, 0x7C, 0x7A, 0x7A, 0x7C, 0x7D, 0x7E, 0x7F,
	0x80, 0x82, 0x83, 0x83, 0x82, 0x81, 0x82, 0x80, 0x80, 0x98, 0xAE, 0xA2,
	0x91, 0xA1, 0xAE, 0x98, 0x81, 0x81, 0x81, 0x78, 0x71, 0x6C, 0x6C, 0x77,
	0x82, 0x81, 0x81, 0x8E, 0x96, 0x91, 0x8B, 0x8B, 0x89, 0x82, 0x7C, 0x77,
	0x73, 0x75, 0x78, 0x76, 0x77, 0x7F, 0x85, 0x84, 0x85, 0x89, 0x89, 0x86,
	0x84, 0x81, 0x7D, 0x7C, 0x7B, 0x79, 0x77, 0x77, 0x79, 0x7C, 0x7E, 0x7F,
	0x81, 0x85, 0x85, 0x83, 0x82, 0x82, 0x81, 0x7E, 0x7D, 0x7C, 0x7C, 0x7E,
	0x9B, 0xB8, 0xAC, 0x93, 0xA4, 0xB7, 0x9B, 0x78, 0x7A, 0x7F, 0x71, 0x66,
	0x69, 0x70, 0x7D, 0x88, 0x85, 0x86, 0x97, 0x9D, 0x8C, 0x83, 0x89, 0x86,
	0x76, 0x71, 0x74, 0x73, 0x74, 0x79, 0x7B, 0x7F, 0x89, 0x8C, 0x86, 0x86,
	0x8C, 0x87, 0x7D, 0x7C, 0x7D, 0x79, 0x76, 0x75, 0x76, 0x7A, 0x7F, 0x7F,
	0x7F, 0x85, 0x8A, 0x84, 0x81, 0x84, 0x83, 0x7D, 0x7B, 0x7C, 0x7A, 0x7B,
	0x7C, 0x7E, 0x7D, 0x95, 0xC1, 0xBE, 0x98, 0x9F, 0xBE, 0xA2, 0x6F, 0x6E,
	0x7F, 0x70, 0x5F, 0x66, 0x75, 0x83, 0x8A, 0x87, 0x8C, 0x9E, 0x9C, 0x85,
	0x7F, 0x8B, 0x80, 0x6B, 0x6D, 0x78, 0x75, 0x73, 0x7C, 0x82, 0x87, 0x8C,
	0x8A, 0x86, 0x8B, 0x89, 0x7D, 0x78, 0x7E, 0x7E, 0x76, 0x77, 0x80, 0x81,
	0x80, 0x82, 0x85, 0x86, 0x85, 0x81, 0x80, 0x81, 0x7F, 0x7A, 0x7B, 0x7E,
	0x7E, 0x7C, 0x7F, 0x82, 0x81, 0x82, 0x82, 0xA8, 0xCA, 0xAA, 0x8F, 0xB4,
	0xB9, 0x79, 0x67, 0x85, 0x79, 0x55, 0x62, 0x7A, 0x7A, 0x7C, 0x87, 0x8E,
	0x99, 0x97, 0x85, 0x85, 0x90, 0x7D, 0x68, 0x76, 0x7E, 0x6E, 0x6F, 0x82,
	0x84, 0x81, 0x87, 0x8B, 0x88, 0x89, 0x83, 0x7D, 0x80, 0x7E, 0x74, 0x77,
	0x80, 0x7B, 0x79, 0x83, 0x86, 0x80, 0x83, 0x86, 0x82, 0x80, 0x80, 0x7D,
	0x7D, 0x7E, 0x7C, 0x7C, 0x80, 0x80, 0x7E, 0x82, 0x83, 0x81, 0x7F, 0xA5,
	0xC6, 0xA7, 0x9B, 0xC4, 0xB0, 0x72, 0x79, 0x89, 0x62, 0x50, 0x6E, 0x73,
	0x6F, 0x7E, 0x8A, 0x90, 0x98, 0x8E, 0x87, 0x91, 0x86, 0x6E, 0x75, 0x7F,
	0x6E, 0x6C, 0x81, 0x82, 0x7B, 0x86, 0x8C, 0x86, 0x85, 0x83, 0x80, 0x80,
	0x7B, 0x76, 0x7D, 0x7E, 0x78, 0x7E, 0x86, 0x80, 0x80, 0x86, 0x83, 0x7F,
	0x81, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x80, 0x7F, 0x7E, 0x82, 0x81, 0x80,
	0x80, 0x85, 0x7E, 0x9C, 0xBB, 0x9E, 0xA0, 0xC4, 0xA3, 0x79, 0x8C, 0x83,
	0x5D, 0x5E, 0x70, 0x6B, 0x6D, 0x7A, 0x87, 0x8F, 0x89, 0x89, 0x93, 0x8A,
	0x78, 0x7E, 0x81, 0x72, 0x71, 0x7E, 0x7E, 0x7C, 0x81, 0x89, 0x88, 0x83,
	0x84, 0x87, 0x80, 0x79, 0x7E, 0x7E, 0x79, 0x7A, 0x80, 0x80, 0x7E, 0x81,
	0x84, 0x82, 0x80, 0x81, 0x81, 0x7E, 0x7D, 0x7F, 0x7E, 0x7E, 0x7D, 0x82,
	0x7E, 0x79, 0x7E, 0x7F, 0x77, 0x7C, 0x7F, 0x84, 0xA7, 0xA1, 0x9A, 0xB6,
	0xAE, 0x8E, 0x91, 0x8D, 0x73, 0x68, 0x6C, 0x6E, 0x6A, 0x6E, 0x7E, 0x86,
	0x80, 0x89, 0x91, 0x88, 0x81, 0x84, 0x81, 0x79, 0x76, 0x7B, 0x7C, 0x79,
	0x7D, 0x84, 0x82, 0x81, 0x86, 0x85, 0x80, 0x7F, 0x81, 0x7E, 0x7B, 0x7C,
	0x7F, 0x7E, 0x7D, 0x81, 0x82, 0x80, 0x80, 0x82, 0x81, 0x7F, 0x7F, 0x80,
	0x7F, 0x7C, 0x7F, 0x7F, 0x7E, 0x7E, 0x81, 0x80, 0x80, 0x80, 0x82, 0x7E,
	0x88, 0xA2, 0x95, 0x96, 0xAB, 0x9E, 0x8B, 0x8D, 0x89, 0x77, 0x6D, 0x73,
	0x75, 0x6D, 0x74, 0x81, 0x82, 0x7F, 0x89, 0x8C, 0x84, 0x81, 0x85, 0x81,
	0x78, 0x7A, 0x7F, 0x7B, 0x79, 0x80, 0x83, 0x7F, 0x81, 0x86, 0x83, 0x7E,
	0x81, 0x81, 0x7D, 0x7C, 0x7F, 0x7F, 0x7C, 0x7F, 0x82, 0x80, 0x7F, 0x81,
	0x82, 0x7F, 0x7F, 0x80, 0x7F, 0x7D, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x81,
	0x7F, 0x80, 0x80, 0x81, 0x7D, 0x8A, 0x99, 0x8D, 0x96, 0xA2, 0x94, 0x8B,
	0x8C, 0x86, 0x78, 0x72, 0x78, 0x75, 0x6F, 0x7A, 0x80, 0x7E, 0x80, 0x88,
	0x88, 0x81, 0x82, 0x85, 0x7D, 0x7A, 0x7E, 0x7E, 0x7A, 0x7C, 0x81, 0x80,
	0x7F, 0x83, 0x84, 0x80, 0x80, 0x82, 0x80, 0x7D, 0x7E, 0x7F, 0x7D, 0x7D,
	0x80, 0x80, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x89, 0x8F,
	0x89, 0x92, 0x97, 0x8F, 0x8C, 0x8B, 0x87, 0x7D, 0x7A, 0x7D, 0x77, 0x75,
	0x7A, 0x7C, 0x7C, 0x7E, 0x84, 0x84, 0x81, 0x83, 0x84, 0x80, 0x7E, 0x7F,
	0x7E, 0x7B, 0x7D, 0x7F, 0x7E, 0x7E, 0x81, 0x82, 0x80, 0x81, 0x82, 0x81,
	0x7F, 0x7F, 0x80, 0x7E, 0x7D, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x86, 0x89, 0x87, 0x8E, 0x91, 0x90, 0x90, 0x90, 0x90,
	0x8B, 0x88, 0x87, 0x83, 0x7F, 0x7E, 0x7D, 0x7B, 0x79, 0x7B, 0x7C, 0x7B,
	0x7B, 0x7D, 0x7D, 0x7D, 0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x83,
	0x84, 0x85, 0x85, 0x86, 0x86, 0x86, 0x86, 0x86, 0x85, 0x84, 0x83, 0x82,
	0x82, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84, 0x84,
	0x85, 0x85, 0x85, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F,
	0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x84, 0x83,
	0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x80,
	0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x80, 0x81, 0x81, 0x81, 0x82, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7D, 0x7E, 0x7F, 0x7E,
	0x7F, 0x81, 0x81, 0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x81,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x7D,
	0x7E, 0x81, 0x80, 0x81, 0x83, 0x83, 0x81, 0x82, 0x82, 0x80, 0x7E, 0x7E,
	0x7E, 0x7B, 0x7A, 0x7B, 0x7C, 0x7C, 0x7D, 0x80, 0x7F, 0x7E, 0x81, 0x80,
	0x7F, 0x7F, 0x7F, 0x7C, 0x7C, 0x7E, 0x7C, 0x7D, 0x7F, 0x80, 0x7E, 0x81,
	0x85, 0x81, 0x82, 0x86, 0x83, 0x85, 0x85, 0x84, 0x80, 0x7F, 0x81, 0x7D,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x7E, 0x82, 0x83, 0x82, 0x85, 0x84,
	0x84, 0x83, 0x82, 0x82, 0x81, 0x80, 0x80, 0x81, 0x81, 0x83, 0x84, 0x82,
	0x82, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81,
	0x81, 0x81, 0x84, 0x83, 0x82, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E,
	0x80, 0x80, 0x81, 0x82, 0x82, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x80, 0x7E,
	0x7E, 0x80, 0x81, 0x7F, 0x80, 0x82, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80,
	0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80
};
const unsigned char WAV1000[] = {
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x82, 0x80, 0x80, 0x81, 0x7F,
	0x7F, 0x80, 0x7E, 0x7D, 0x7E, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7E, 0x80, 0x80, 0x80, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x7D, 0x81, 0x82, 0x7F, 0x7F, 0x7F, 0x7F, 0x7D, 0x7D, 0x7F, 0x80,
	0x7F, 0x7D, 0x7C, 0x80, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x81, 0x81, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x82, 0x82, 0x81, 0x84, 0x87, 0x86, 0x86, 0x87,
	0x83, 0x83, 0x82, 0x7E, 0x7A, 0x79, 0x7B, 0x79, 0x7C, 0x7E, 0x7E, 0x80,
	0x7F, 0x7D, 0x7C, 0x7F, 0x80, 0x81, 0x83, 0x84, 0x85, 0x81, 0x7A, 0x7E,
	0x81, 0x79, 0x7D, 0x83, 0x83, 0x81, 0x82, 0x85, 0x80, 0x7F, 0x80, 0x7E,
	0x7D, 0x7B, 0x7A, 0x78, 0x77, 0x78, 0x78, 0x78, 0x7B, 0x80, 0x82, 0x87,
	0x8B, 0x88, 0x82, 0x81, 0x7D, 0x78, 0x77, 0x7B, 0x7B, 0x86, 0xA0, 0x9E,
	0x9E, 0xA1, 0x99, 0x88, 0x78, 0x78, 0x70, 0x6B, 0x74, 0x7E, 0x81, 0x84,
	0x8C, 0x8C, 0x84, 0x81, 0x80, 0x7A, 0x75, 0x78, 0x7C, 0x7B, 0x7F, 0x84,
	0x84, 0x82, 0x82, 0x82, 0x7D, 0x7B, 0x7D, 0x7E, 0x7D, 0x7F, 0x83, 0x82,
	0x81, 0x81, 0x81, 0x7F, 0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x80,
	0x80, 0x81, 0x7F, 0x80, 0x7D, 0x8F, 0xAC, 0xA2, 0xA2, 0xA4, 0x97, 0x7D,
	0x6D, 0x75, 0x6C, 0x6B, 0x7A, 0x89, 0x8A, 0x86, 0x8E, 0x88, 0x79, 0x75,
	0x77, 0x77, 0x74, 0x7F, 0x88, 0x86, 0x85, 0x87, 0x85, 0x7B, 0x78, 0x7C,
	0x7B, 0x7A, 0x80, 0x86, 0x84, 0x81, 0x83, 0x82, 0x7C, 0x7A, 0x7E, 0x7E,
	0x7D, 0x80, 0x84, 0x82, 0x80, 0x81, 0x80, 0x7E, 0x7B, 0x7F, 0x7F, 0x80,
	0x7E, 0x99, 0xB7, 0xA1, 0x9D, 0x9C, 0x8C, 0x6E, 0x62, 0x76, 0x74, 0x75,
	0x87, 0x96, 0x90, 0x7F, 0x84, 0x7F, 0x6F, 0x6D, 0x7A, 0x84, 0x7E, 0x86,
	0x8F, 0x89, 0x7D, 0x7A, 0x7F, 0x77, 0x74, 0x7F, 0x88, 0x84, 0x81, 0x88,
	0x84, 0x7A, 0x78, 0x7E, 0x7E, 0x7A, 0x80, 0x87, 0x83, 0x7F, 0x80, 0x82,
	0x7B, 0x7A, 0x7F, 0x82, 0x7E, 0x80, 0x83, 0x84, 0x7B, 0x8E, 0xC6, 0xB2,
	0x9D, 0xA0, 0x95, 0x75, 0x55, 0x73, 0x80, 0x78, 0x85, 0x9A, 0x9D, 0x7B,
	0x77, 0x80, 0x72, 0x6A, 0x76, 0x8F, 0x88, 0x80, 0x8C, 0x8A, 0x7A, 0x6F,
	0x7B, 0x81, 0x77, 0x7E, 0x8B, 0x8B, 0x7D, 0x7E, 0x7E, 0x73, 0x73, 0x79,
	0x85, 0x83, 0x82, 0x88, 0x84, 0x7D, 0x77, 0x7C, 0x7E, 0x7C, 0x80, 0x86,
	0x85, 0x80, 0x7D, 0x81, 0x7C, 0x80, 0xC5, 0xCC, 0xA0, 0x93, 0x88, 0x78,
	0x4A, 0x5F, 0x87, 0x8C, 0x8E, 0x90, 0xA0, 0x83, 0x65, 0x6C, 0x77, 0x7B,
	0x77, 0x8B, 0x9B, 0x88, 0x7A, 0x79, 0x7E, 0x74, 0x70, 0x84, 0x8C, 0x88,
	0x7F, 0x84, 0x84, 0x75, 0x74, 0x7E, 0x84, 0x81, 0x7D, 0x89, 0x85, 0x7C,
	0x78, 0x7D, 0x82, 0x7C, 0x7E, 0x85, 0x85, 0x7F, 0x7B, 0x80, 0x81, 0x7A,
	0x80, 0x7E, 0xC5, 0xE4, 0xA1, 0x83, 0x6F, 0x77, 0x55, 0x56, 0x95, 0xA8,
	0x9F, 0x83, 0x94, 0x8F, 0x62, 0x5C, 0x75, 0x96, 0x8C, 0x80, 0x92, 0x8F,
	0x78, 0x62, 0x73, 0x89, 0x83, 0x7F, 0x88, 0x92, 0x80, 0x6E, 0x75, 0x81,
	0x81, 0x7B, 0x83, 0x8E, 0x84, 0x78, 0x77, 0x81, 0x7A, 0x72, 0x7F, 0x88,
	0x8B, 0x7C, 0x7B, 0x80, 0x7F, 0x79, 0x7A, 0x84, 0x8A, 0x7C, 0x8B, 0xE7,
	0xDD, 0x84, 0x4E, 0x58, 0x86, 0x67, 0x71, 0xA9, 0xBE, 0x9E, 0x5B, 0x66,
	0x7B, 0x73, 0x6E, 0x7B, 0xA9, 0xA0, 0x78, 0x6B, 0x72, 0x83, 0x72, 0x76,
	0x8D, 0x98, 0x8B, 0x70, 0x75, 0x7E, 0x7D, 0x78, 0x7D, 0x8F, 0x8C, 0x7C,
	0x76, 0x7B, 0x82, 0x7B, 0x7C, 0x83, 0x8A, 0x84, 0x78, 0x7C, 0x81, 0x81,
	0x7C, 0x7C, 0x84, 0x87, 0x7D, 0x7F, 0x76, 0xB1, 0xF8, 0xC6, 0x77, 0x37,
	0x5E, 0x85, 0x75, 0x87, 0xA0, 0xC1, 0x98, 0x5C, 0x5B, 0x6E, 0x87, 0x79,
	0x81, 0xA0, 0x96, 0x7E, 0x5E, 0x6B, 0x84, 0x81, 0x80, 0x7F, 0x93, 0x8F,
	0x77, 0x6F, 0x73, 0x85, 0x82, 0x7D, 0x84, 0x88, 0x89, 0x78, 0x74, 0x7D,
	0x80, 0x84, 0x7C, 0x83, 0x86, 0x82, 0x7D, 0x78, 0x7C, 0x7F, 0x7E, 0x81,
	0x81, 0x84, 0x82, 0x7C, 0xCD, 0xEF, 0xBD, 0x67, 0x33, 0x68, 0x81, 0x85,
	0x82, 0x9A, 0xBD, 0x9A, 0x6E, 0x53, 0x6A, 0x85, 0x7E, 0x82, 0x8D, 0x9F,
	0x91, 0x71, 0x66, 0x6F, 0x83, 0x83, 0x7E, 0x86, 0x8E, 0x8D, 0x7B, 0x70,
	0x76, 0x7E, 0x83, 0x7F, 0x82, 0x87, 0x87, 0x7F, 0x76, 0x79, 0x7E, 0x82,
	0x80, 0x80, 0x84, 0x83, 0x81, 0x7A, 0x7C, 0x7D, 0x7F, 0x79, 0x7D, 0x7B,
	0x9B, 0xE7, 0xE4, 0xAF, 0x53, 0x3F, 0x66, 0x7C, 0x88, 0x80, 0xA2, 0xB4,
	0xA0, 0x77, 0x55, 0x67, 0x78, 0x81, 0x82, 0x87, 0x9D, 0x94, 0x84, 0x6A,
	0x6B, 0x79, 0x76, 0x77, 0x77, 0x8C, 0x95, 0x8B, 0x7C, 0x70, 0x79, 0x7C,
	0x7C, 0x7B, 0x80, 0x8B, 0x89, 0x83, 0x79, 0x79, 0x7D, 0x7E, 0x7E, 0x7E,
	0x83, 0x86, 0x84, 0x7F, 0x7A, 0x7F, 0x7C, 0x82, 0x7B, 0x97, 0xDE, 0xE9,
	0xC0, 0x62, 0x41, 0x58, 0x78, 0x88, 0x7C, 0x93, 0xAA, 0xB2, 0x90, 0x64,
	0x5D, 0x6A, 0x7F, 0x7F, 0x80, 0x8D, 0x97, 0x98, 0x7E, 0x6F, 0x6B, 0x78,
	0x7F, 0x7F, 0x88, 0x8D, 0x95, 0x88, 0x7A, 0x72, 0x74, 0x7D, 0x7E, 0x81,
	0x82, 0x88, 0x8A, 0x83, 0x7D, 0x76, 0x7B, 0x7D, 0x80, 0x80, 0x81, 0x84,
	0x84, 0x82, 0x7D, 0x7B, 0x7C, 0x7F, 0x80, 0xBD, 0xE8, 0xE7, 0xA6, 0x58,
	0x4B, 0x5B, 0x7E, 0x79, 0x7C, 0x8F, 0xAB, 0xB7, 0x94, 0x72, 0x5E, 0x69,
	0x77, 0x79, 0x7C, 0x82, 0x96, 0x9A, 0x8F, 0x7B, 0x6D, 0x73, 0x77, 0x7D,
	0x7B, 0x80, 0x8D, 0x93, 0x91, 0x81, 0x78, 0x75, 0x79, 0x7C, 0x7B, 0x7E,
	0x82, 0x89, 0x89, 0x83, 0x7E, 0x7A, 0x7C, 0x7C, 0x7D, 0x7D, 0x80, 0x84,
	0x84, 0x84, 0x7F, 0x7E, 0x7C, 0xA6, 0xCE, 0xD5, 0xB5, 0x7C, 0x6D, 0x69,
	0x76, 0x70, 0x6B, 0x7C, 0x93, 0xAA, 0x9F, 0x8B, 0x7A, 0x75, 0x7A, 0x73,
	0x71, 0x72, 0x81, 0x90, 0x91, 0x8C, 0x80, 0x7F, 0x7D, 0x7B, 0x77, 0x74,
	0x7C, 0x82, 0x8A, 0x89, 0x85, 0x83, 0x80, 0x80, 0x7B, 0x79, 0x79, 0x7D,
	0x82, 0x83, 0x84, 0x82, 0x82, 0x82, 0x7F, 0x7E, 0x7B, 0x7D, 0x7E, 0x80,
	0x81, 0x81, 0x81, 0x82, 0xA6, 0xC5, 0xCC, 0xAF, 0x7F, 0x6E, 0x68, 0x71,
	0x6B, 0x67, 0x75, 0x8B, 0xA2, 0x9F, 0x91, 0x84, 0x7E, 0x7F, 0x75, 0x6E,
	0x6C, 0x77, 0x86, 0x8B, 0x8B, 0x86, 0x86, 0x85, 0x81, 0x7A, 0x74, 0x76,
	0x7B, 0x81, 0x83, 0x84, 0x86, 0x87, 0x86, 0x82, 0x7D, 0x7B, 0x7B, 0x7D,
	0x7D, 0x7E, 0x80, 0x82, 0x84, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x7D, 0x7D,
	0x7D, 0x7F, 0x80, 0x82, 0x9F, 0xBB, 0xC5, 0xB3, 0x90, 0x7F, 0x75, 0x72,
	0x67, 0x5F, 0x6A, 0x7C, 0x91, 0x95, 0x91, 0x8F, 0x8E, 0x8C, 0x80, 0x73,
	0x6E, 0x71, 0x79, 0x7C, 0x7F, 0x82, 0x87, 0x8C, 0x89, 0x84, 0x7E, 0x7C,
	0x7C, 0x7A, 0x79, 0x79, 0x7D, 0x82, 0x83, 0x83, 0x82, 0x83, 0x83, 0x81,
	0x7E, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x81, 0x82, 0x82, 0x81, 0x80,
	0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x93, 0xAC, 0xB8, 0xB3, 0xA2, 0x9B, 0x92,
	0x86, 0x73, 0x65, 0x68, 0x71, 0x79, 0x7D, 0x81, 0x8B, 0x91, 0x92, 0x8A,
	0x82, 0x80, 0x7D, 0x7A, 0x74, 0x74, 0x79, 0x7F, 0x82, 0x82, 0x84, 0x86,
	0x86, 0x84, 0x7F, 0x7D, 0x7D, 0x7C, 0x7B, 0x7B, 0x7D, 0x7F, 0x81, 0x81,
	0x81, 0x82, 0x82, 0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x7E, 0x89, 0x9E, 0xA9, 0xAC, 0xA6,
	0xA5, 0xA2, 0x97, 0x87, 0x79, 0x76, 0x74, 0x73, 0x72, 0x76, 0x7F, 0x85,
	0x87, 0x87, 0x87, 0x88, 0x85, 0x81, 0x7C, 0x7B, 0x7C, 0x7B, 0x7B, 0x7B,
	0x7F, 0x81, 0x83, 0x83, 0x84, 0x85, 0x84, 0x82, 0x80, 0x7F, 0x7F, 0x7E,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x8A, 0x99,
	0xA1, 0xA4, 0xA3, 0xA7, 0xA4, 0x9B, 0x8F, 0x87, 0x83, 0x7D, 0x77, 0x74,
	0x77, 0x7B, 0x7C, 0x7D, 0x80, 0x84, 0x85, 0x84, 0x83, 0x82, 0x82, 0x80,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7D, 0x7F, 0x8A, 0x92, 0x97, 0x99, 0x9D, 0xA1, 0x9E, 0x99, 0x94, 0x91,
	0x8C, 0x84, 0x80, 0x7D, 0x7C, 0x7A, 0x79, 0x7A, 0x7D, 0x7E, 0x7E, 0x80,
	0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x82, 0x88, 0x8A, 0x8C, 0x8E, 0x92,
	0x92, 0x91, 0x91, 0x90, 0x8F, 0x8B, 0x89, 0x87, 0x85, 0x83, 0x81, 0x80,
	0x7F, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x82, 0x83, 0x83, 0x85, 0x86, 0x85,
	0x85, 0x85, 0x84, 0x83, 0x83, 0x83, 0x83, 0x82, 0x80, 0x80, 0x7E, 0x7D,
	0x7C, 0x7B, 0x79, 0x79, 0x7A, 0x7A, 0x79, 0x78, 0x7A, 0x78, 0x78, 0x78,
	0x78, 0x79, 0x79, 0x7A, 0x7B, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x83, 0x83,
	0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x86, 0x87, 0x87, 0x88, 0x88, 0x89,
	0x89, 0x88, 0x87, 0x88, 0x88, 0x86, 0x87, 0x88, 0x87, 0x87, 0x87, 0x86,
	0x86, 0x86, 0x85, 0x83, 0x82, 0x82, 0x80, 0x81, 0x7F, 0x7F, 0x7E, 0x7D,
	0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7C, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x81, 0x82, 0x83, 0x82, 0x83,
	0x83, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E,
	0x7E, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x7D,
	0x80, 0x7F, 0x7D, 0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x7D, 0x7F, 0x81,
	0x7E, 0x7E, 0x81, 0x81, 0x7E, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x80,
	0x7E, 0x81, 0x80, 0x80, 0x7F, 0x81, 0x81, 0x7F, 0x80, 0x7F, 0x81, 0x80,
	0x81, 0x82, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7D, 0x7E, 0x80, 0x7E, 0x7E, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x7E, 0x81, 0x7F, 0x7E, 0x81, 0x81,
	0x7F, 0x80, 0x82, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x7F,
	0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x83,
	0x7F, 0x7F, 0x81, 0x7F, 0x7D, 0x80, 0x82, 0x7E, 0x7F, 0x80, 0x80, 0x7E,
	0x7E, 0x80, 0x7F, 0x7D, 0x7F, 0x81, 0x7F, 0x80, 0x82, 0x82, 0x81, 0x81,
	0x83, 0x80, 0x7F, 0x81, 0x7E, 0x7E, 0x7E, 0x7C, 0x7B, 0x7D, 0x7E, 0x7C,
	0x7D, 0x80, 0x7D, 0x7E, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x7C, 0x7D, 0x7E,
	0x7D, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x82,
	0x83, 0x83, 0x84, 0x84, 0x84, 0x83, 0x80, 0x83, 0x83, 0x80, 0x81, 0x80,
	0x7F, 0x7C, 0x7C, 0x7D, 0x7C, 0x7B, 0x7A, 0x7A, 0x7A, 0x78, 0x7A, 0x7B,
	0x7B, 0x7D, 0x7E, 0x87, 0x89, 0x89, 0x8E, 0x8E, 0x8C, 0x89, 0x88, 0x87,
	0x81, 0x80, 0x7F, 0x7C, 0x7B, 0x7B, 0x7D, 0x7C, 0x7C, 0x7F, 0x7F, 0x7F,
	0x80, 0x81, 0x82, 0x81, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7E,
	0x88, 0x94, 0x93, 0x98, 0x9C, 0x9B, 0x94, 0x8B, 0x89, 0x80, 0x77, 0x75,
	0x74, 0x75, 0x75, 0x79, 0x80, 0x81, 0x82, 0x86, 0x86, 0x85, 0x82, 0x81,
	0x80, 0x7C, 0x7B, 0x7D, 0x7D, 0x7D, 0x7E, 0x80, 0x81, 0x80, 0x82, 0x82,
	0x81, 0x80, 0x7F, 0x80, 0x7E, 0x7D, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x89, 0xA3, 0xA3,
	0xA5, 0xB0, 0xA9, 0x9B, 0x8A, 0x81, 0x79, 0x66, 0x65, 0x6C, 0x6D, 0x73,
	0x7B, 0x88, 0x8B, 0x87, 0x8E, 0x8C, 0x84, 0x7F, 0x7C, 0x7C, 0x76, 0x75,
	0x7D, 0x7D, 0x7E, 0x81, 0x85, 0x86, 0x82, 0x82, 0x83, 0x7E, 0x7C, 0x7D,
	0x7D, 0x7C, 0x7C, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x80, 0x7F, 0x81,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x7F,
	0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x7D, 0x8B, 0xAE, 0xAC, 0xAC, 0xB6, 0xAB,
	0x99, 0x81, 0x7A, 0x73, 0x5D, 0x63, 0x70, 0x72, 0x7A, 0x84, 0x93, 0x90,
	0x89, 0x8F, 0x88, 0x7D, 0x78, 0x78, 0x79, 0x72, 0x76, 0x80, 0x7D, 0x80,
	0x84, 0x87, 0x85, 0x7F, 0x83, 0x81, 0x7B, 0x7C, 0x7D, 0x7E, 0x7C, 0x7E,
	0x83, 0x80, 0x80, 0x83, 0x82, 0x80, 0x7E, 0x80, 0x80, 0x7C, 0x7E, 0x80,
	0x7F, 0x7F, 0x80, 0x83, 0x80, 0x80, 0x82, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7D, 0x80, 0x7E, 0x8B, 0xB1, 0xAD, 0xAB, 0xB1, 0xA4, 0x91, 0x76, 0x73,
	0x6E, 0x5D, 0x69, 0x76, 0x7D, 0x83, 0x8A, 0x98, 0x8A, 0x80, 0x85, 0x7A,
	0x73, 0x70, 0x77, 0x7D, 0x77, 0x82, 0x8A, 0x86, 0x85, 0x84, 0x86, 0x7D,
	0x79, 0x7E, 0x7B, 0x7A, 0x7D, 0x81, 0x83, 0x7F, 0x83, 0x85, 0x80, 0x7F,
	0x7F, 0x80, 0x7B, 0x79, 0x7E, 0x7D, 0x7C, 0x7F, 0x81, 0x82, 0x7F, 0x82,
	0x83, 0x7E, 0x7F, 0x7F, 0x7F, 0x7D, 0x7E, 0x80, 0x80, 0x7E, 0x82, 0x7F,
	0x8B, 0xAD, 0xAB, 0xA7, 0xAB, 0xA1, 0x8F, 0x76, 0x74, 0x71, 0x62, 0x6A,
	0x76, 0x7B, 0x7F, 0x84, 0x90, 0x8A, 0x83, 0x88, 0x82, 0x7D, 0x79, 0x7B,
	0x7E, 0x78, 0x7D, 0x82, 0x80, 0x81, 0x82, 0x84, 0x81, 0x7D, 0x81, 0x7F,
	0x7D, 0x7E, 0x7F, 0x80, 0x7E, 0x7F, 0x82, 0x7F, 0x7F, 0x81, 0x80, 0x80,
	0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x85, 0x9C, 0xA4,
	0xA1, 0xA3, 0x9E, 0x97, 0x8C, 0x86, 0x85, 0x79, 0x75, 0x77, 0x73, 0x75,
	0x76, 0x7C, 0x80, 0x7E, 0x85, 0x87, 0x84, 0x86, 0x85, 0x85, 0x82, 0x7E,
	0x81, 0x7D, 0x7D, 0x7F, 0x7D, 0x7F, 0x7E, 0x7F, 0x81, 0x7F, 0x81, 0x82,
	0x81, 0x82, 0x80, 0x81, 0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x8B, 0x98, 0x98, 0x99, 0x97,
	0x93, 0x93, 0x90, 0x91, 0x8B, 0x82, 0x7E, 0x78, 0x77, 0x78, 0x77, 0x79,
	0x77, 0x78, 0x7E, 0x81, 0x86, 0x89, 0x88, 0x89, 0x88, 0x89, 0x8A, 0x87,
	0x85, 0x81, 0x7E, 0x7D, 0x7B, 0x7B, 0x7B, 0x79, 0x7A, 0x7A, 0x7C, 0x7F,
	0x80, 0x82, 0x82, 0x82, 0x84, 0x84, 0x84, 0x84, 0x82, 0x80, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7C, 0x7C, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x81,
	0x81, 0x82, 0x82, 0x82, 0x82, 0x8C, 0x93, 0x93, 0x95, 0x91, 0x8F, 0x8F,
	0x8E, 0x8E, 0x8A, 0x86, 0x82, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C,
	0x7E, 0x80, 0x83, 0x84, 0x84, 0x84, 0x85, 0x85, 0x86, 0x85, 0x84, 0x82,
	0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x80,
	0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x82, 0x8B, 0x8F, 0x90, 0x92, 0x8E, 0x8D, 0x8D, 0x8C, 0x8C,
	0x87, 0x83, 0x7F, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7A, 0x7B, 0x7D, 0x7F,
	0x83, 0x84, 0x85, 0x86, 0x85, 0x86, 0x86, 0x85, 0x84, 0x81, 0x7F, 0x7C,
	0x7B, 0x7B, 0x7A, 0x7A, 0x7A, 0x7A, 0x7B, 0x7D, 0x7F, 0x81, 0x81, 0x82,
	0x83, 0x83, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82,
	0x83, 0x89, 0x8D, 0x8F, 0x91, 0x8F, 0x8D, 0x8D, 0x8B, 0x8B, 0x89, 0x86,
	0x83, 0x7E, 0x7D, 0x7C, 0x7B, 0x7C, 0x7B, 0x7C, 0x7C, 0x7D, 0x80, 0x82,
	0x84, 0x85, 0x85, 0x86, 0x86, 0x85, 0x86, 0x85, 0x84, 0x82, 0x80, 0x7F,
	0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x83,
	0x88, 0x8A, 0x8D, 0x8F, 0x8E, 0x8E, 0x8C, 0x8C, 0x8C, 0x8A, 0x89, 0x86,
	0x82, 0x80, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x80,
	0x82, 0x83, 0x84, 0x84, 0x84, 0x85, 0x84, 0x85, 0x84, 0x83, 0x82, 0x81,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x82, 0x84,
	0x86, 0x87, 0x86, 0x86, 0x86, 0x85, 0x85, 0x85, 0x84, 0x83, 0x81, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x83, 0x84, 0x85, 0x85, 0x84, 0x84,
	0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7F, 0x7F, 0x81, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82,
	0x83, 0x84, 0x84, 0x83, 0x83, 0x83, 0x84, 0x84, 0x84, 0x82, 0x80, 0x7F,
	0x7F, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x82, 0x81, 0x80, 0x80,
	0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x81, 0x82, 0x80, 0x81, 0x84, 0x81, 0x80, 0x83, 0x82, 0x80, 0x81, 0x80,
	0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x82, 0x83, 0x81, 0x82, 0x84, 0x82, 0x82,
	0x84, 0x84, 0x83, 0x82, 0x81, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x81, 0x82,
	0x7F, 0x7D, 0x83, 0x81, 0x7D, 0x81, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x7E,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7D, 0x7D, 0x7F, 0x7D, 0x7D, 0x7E, 0x7D,
	0x7E, 0x7D, 0x7C, 0x7C, 0x7E, 0x7D, 0x7D, 0x81, 0x7F, 0x7E, 0x81, 0x80,
	0x7E, 0x7D, 0x7F, 0x7C, 0x7C, 0x7F, 0x7D, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E,
	0x81, 0x7F, 0x80, 0x81, 0x81, 0x7E, 0x7C, 0x7F, 0x7D, 0x7E, 0x80, 0x81,
	0x82, 0x81, 0x83, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x80, 0x7D, 0x7E, 0x80, 0x7D, 0x7F, 0x81, 0x7F, 0x7F, 0x82, 0x81,
	0x80, 0x82, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81,
	0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x82, 0x80,
	0x7F, 0x83, 0x83, 0x80, 0x81, 0x82, 0x80, 0x7E, 0x81, 0x81, 0x7E, 0x80,
	0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7D, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x80,
	0x7F, 0x82, 0x81, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7E, 0x80, 0x80, 0x80, 0x80, 0x82, 0x81, 0x80, 0x81, 0x80, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x82, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAV1000000[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x83, 0x85, 0x86, 0x87, 0x87,
	0x87, 0x88, 0x87, 0x87, 0x86, 0x84, 0x83, 0x82, 0x80, 0x80, 0x7F, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x8A, 0x90,
	0x91, 0x95, 0x94, 0x92, 0x94, 0x92, 0x8F, 0x8D, 0x87, 0x83, 0x81, 0x7D,
	0x7B, 0x77, 0x74, 0x74, 0x74, 0x75, 0x78, 0x77, 0x79, 0x7C, 0x7D, 0x80,
	0x82, 0x82, 0x84, 0x84, 0x84, 0x85, 0x84, 0x82, 0x82, 0x80, 0x80, 0x80,
	0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x89, 0x97, 0x99, 0x9D, 0x9F, 0x9B, 0x9D, 0x9E, 0x96, 0x92,
	0x8C, 0x83, 0x81, 0x7D, 0x77, 0x76, 0x72, 0x72, 0x74, 0x74, 0x76, 0x79,
	0x79, 0x7D, 0x80, 0x81, 0x84, 0x84, 0x84, 0x86, 0x85, 0x84, 0x84, 0x82,
	0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x80, 0x80, 0x81, 0x82, 0x82,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x8B, 0x9C, 0x9D, 0xA1,
	0xA4, 0x9F, 0xA4, 0xA5, 0x9A, 0x95, 0x8E, 0x86, 0x86, 0x7F, 0x78, 0x76,
	0x71, 0x72, 0x74, 0x72, 0x74, 0x76, 0x77, 0x7D, 0x7F, 0x7F, 0x82, 0x83,
	0x84, 0x87, 0x85, 0x85, 0x85, 0x83, 0x83, 0x83, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x86, 0x99, 0xA0, 0xA0, 0xA5, 0xA3, 0xA5, 0xAB, 0xA3, 0x9B,
	0x95, 0x8D, 0x8A, 0x87, 0x7D, 0x78, 0x74, 0x72, 0x74, 0x73, 0x71, 0x73,
	0x74, 0x78, 0x7C, 0x7D, 0x7E, 0x80, 0x82, 0x86, 0x86, 0x85, 0x86, 0x85,
	0x85, 0x85, 0x82, 0x81, 0x81, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x92, 0xA8, 0xA5, 0xA8,
	0xAE, 0xAC, 0xAF, 0xAA, 0x9C, 0x97, 0x8F, 0x86, 0x81, 0x77, 0x71, 0x70,
	0x6C, 0x6D, 0x6F, 0x6E, 0x73, 0x77, 0x79, 0x82, 0x84, 0x86, 0x8B, 0x8A,
	0x8B, 0x8C, 0x88, 0x87, 0x85, 0x81, 0x80, 0x7E, 0x7B, 0x7C, 0x7A, 0x7A,
	0x7B, 0x7B, 0x7C, 0x7E, 0x7E, 0x7F, 0x81, 0x80, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x84, 0x83, 0x82, 0x83, 0x82, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7C, 0x91, 0xB1, 0xAD, 0xAD, 0xBC, 0xB5, 0xAA, 0x9F, 0x91, 0x8B, 0x7B,
	0x6D, 0x6D, 0x66, 0x62, 0x68, 0x69, 0x71, 0x79, 0x7D, 0x87, 0x8A, 0x8A,
	0x8D, 0x8A, 0x87, 0x84, 0x7F, 0x7C, 0x7A, 0x77, 0x79, 0x79, 0x7A, 0x7E,
	0x7F, 0x82, 0x83, 0x83, 0x84, 0x83, 0x82, 0x81, 0x7F, 0x7F, 0x7D, 0x7D,
	0x7C, 0x79, 0x7D, 0x7C, 0x7B, 0x7E, 0x80, 0x80, 0x80, 0x82, 0x82, 0x81,
	0x80, 0x81, 0x7E, 0x7F, 0x7D, 0x84, 0xB5, 0xB4, 0xAB, 0xCA, 0xB9, 0x9D,
	0x93, 0x81, 0x72, 0x5A, 0x5B, 0x6B, 0x60, 0x6E, 0x86, 0x87, 0x8C, 0x91,
	0x95, 0x8B, 0x7F, 0x84, 0x7B, 0x70, 0x76, 0x79, 0x78, 0x7A, 0x83, 0x87,
	0x82, 0x86, 0x88, 0x81, 0x7E, 0x80, 0x7E, 0x7A, 0x7B, 0x7F, 0x7E, 0x7D,
	0x82, 0x83, 0x80, 0x81, 0x82, 0x80, 0x7D, 0x80, 0x7F, 0x7D, 0x7E, 0x80,
	0x80, 0x7F, 0x81, 0x82, 0x7E, 0x80, 0x80, 0x80, 0x7E, 0x83, 0xB1, 0xAD,
	0xA8, 0xC5, 0xB2, 0x98, 0x88, 0x80, 0x6B, 0x58, 0x68, 0x6D, 0x6A, 0x7C,
	0x8B, 0x8C, 0x86, 0x8E, 0x8A, 0x79, 0x7A, 0x7A, 0x76, 0x74, 0x7E, 0x84,
	0x80, 0x86, 0x8B, 0x85, 0x81, 0x81, 0x80, 0x77, 0x79, 0x7E, 0x7B, 0x7D,
	0x84, 0x84, 0x82, 0x83, 0x85, 0x80, 0x7C, 0x7F, 0x7D, 0x7B, 0x7D, 0x81,
	0x7F, 0x80, 0x83, 0x82, 0x80, 0x80, 0x81, 0x7E, 0x7D, 0x80, 0x7E, 0x80,
	0x7D, 0xA4, 0xB3, 0xA2, 0xBD, 0xB7, 0x9F, 0x85, 0x81, 0x71, 0x51, 0x61,
	0x69, 0x69, 0x73, 0x87, 0x92, 0x84, 0x8C, 0x8D, 0x7B, 0x76, 0x78, 0x7B,
	0x72, 0x7D, 0x89, 0x84, 0x87, 0x8B, 0x8A, 0x7F, 0x7D, 0x80, 0x76, 0x76,
	0x7B, 0x7D, 0x7E, 0x80, 0x87, 0x83, 0x81, 0x82, 0x81, 0x7E, 0x7B, 0x7F,
	0x7D, 0x7D, 0x80, 0x82, 0x82, 0x80, 0x82, 0x82, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7C, 0x80, 0x80, 0x84, 0xB3, 0xAE, 0xAB, 0xB8, 0xB1, 0xA0, 0x79, 0x7D,
	0x6F, 0x5E, 0x5E, 0x69, 0x7D, 0x76, 0x85, 0x91, 0x8F, 0x88, 0x7F, 0x86,
	0x78, 0x72, 0x75, 0x7B, 0x7F, 0x7A, 0x87, 0x89, 0x87, 0x83, 0x83, 0x84,
	0x7A, 0x79, 0x79, 0x7D, 0x7C, 0x7B, 0x82, 0x83, 0x84, 0x81, 0x83, 0x82,
	0x7F, 0x7D, 0x7C, 0x7F, 0x7D, 0x7E, 0x7F, 0x82, 0x81, 0x81, 0x80, 0x81,
	0x7F, 0x7F, 0x7E, 0x80, 0x7C, 0x88, 0xB3, 0xBE, 0xB8, 0xA7, 0xA6, 0x9B,
	0x7B, 0x67, 0x60, 0x6E, 0x6A, 0x6F, 0x7C, 0x90, 0x97, 0x8E, 0x8D, 0x8B,
	0x87, 0x78, 0x71, 0x74, 0x76, 0x78, 0x77, 0x82, 0x88, 0x89, 0x86, 0x84,
	0x89, 0x85, 0x80, 0x79, 0x7B, 0x7E, 0x7C, 0x7C, 0x7D, 0x83, 0x84, 0x83,
	0x81, 0x82, 0x82, 0x7F, 0x7D, 0x7C, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x83,
	0x80, 0x81, 0x7F, 0x81, 0x7E, 0x80, 0x7A, 0x8B, 0xB3, 0xC2, 0xBC, 0x9A,
	0x93, 0x8A, 0x81, 0x69, 0x5E, 0x6B, 0x79, 0x87, 0x84, 0x8F, 0x96, 0x9D,
	0x8F, 0x81, 0x7B, 0x79, 0x77, 0x6F, 0x72, 0x78, 0x85, 0x87, 0x87, 0x88,
	0x8C, 0x8C, 0x84, 0x7D, 0x78, 0x7A, 0x7A, 0x7A, 0x7A, 0x7F, 0x85, 0x86,
	0x86, 0x83, 0x83, 0x81, 0x80, 0x7B, 0x7A, 0x7B, 0x7E, 0x7F, 0x7F, 0x81,
	0x83, 0x84, 0x82, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x9D, 0xBA, 0xC8,
	0xB1, 0x94, 0x85, 0x81, 0x7B, 0x68, 0x60, 0x67, 0x80, 0x8C, 0x92, 0x8E,
	0x94, 0x96, 0x90, 0x81, 0x73, 0x71, 0x72, 0x77, 0x75, 0x7B, 0x81, 0x8C,
	0x8C, 0x88, 0x80, 0x7E, 0x7E, 0x7C, 0x79, 0x75, 0x78, 0x7D, 0x83, 0x83,
	0x83, 0x82, 0x84, 0x84, 0x81, 0x7D, 0x7B, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F,
	0x81, 0x83, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x7C, 0x7B, 0x79, 0x7F, 0x98,
	0xB2, 0xC0, 0xB0, 0x99, 0x84, 0x7F, 0x7B, 0x72, 0x67, 0x64, 0x73, 0x84,
	0x93, 0x91, 0x90, 0x8C, 0x8E, 0x89, 0x80, 0x74, 0x6F, 0x72, 0x78, 0x7E,
	0x7E, 0x82, 0x84, 0x8A, 0x8A, 0x87, 0x80, 0x7C, 0x7A, 0x7B, 0x7B, 0x7B,
	0x7B, 0x7E, 0x82, 0x85, 0x85, 0x83, 0x81, 0x80, 0x80, 0x7E, 0x7D, 0x7B,
	0x7C, 0x7E, 0x81, 0x81, 0x82, 0x80, 0x81, 0x81, 0x82, 0x80, 0x80, 0x7C,
	0x82, 0x95, 0xAB, 0xB9, 0xAD, 0x99, 0x82, 0x7C, 0x78, 0x77, 0x6E, 0x6B,
	0x6F, 0x7E, 0x8E, 0x94, 0x92, 0x88, 0x86, 0x83, 0x84, 0x7C, 0x76, 0x70,
	0x74, 0x7A, 0x80, 0x83, 0x82, 0x83, 0x83, 0x86, 0x84, 0x82, 0x7B, 0x7A,
	0x79, 0x7D, 0x7F, 0x80, 0x7F, 0x80, 0x82, 0x83, 0x84, 0x81, 0x7F, 0x7D,
	0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7E, 0x82, 0x84, 0x86, 0x84, 0x82, 0x7F,
	0x7F, 0x7E, 0x7F, 0x8E, 0xA0, 0xB3, 0xB2, 0xA4, 0x8B, 0x7C, 0x75, 0x75,
	0x73, 0x6F, 0x6E, 0x75, 0x84, 0x8F, 0x96, 0x90, 0x88, 0x81, 0x80, 0x7E,
	0x7C, 0x76, 0x74, 0x76, 0x7D, 0x84, 0x87, 0x87, 0x83, 0x83, 0x82, 0x83,
	0x80, 0x7D, 0x79, 0x79, 0x7C, 0x80, 0x82, 0x82, 0x81, 0x81, 0x82, 0x82,
	0x82, 0x7F, 0x7D, 0x7C, 0x7E, 0x7E, 0x7F, 0x7D, 0x7B, 0x7B, 0x7D, 0x80,
	0x82, 0x81, 0x80, 0x80, 0x7F, 0x8B, 0x9B, 0xAF, 0xB3, 0xA8, 0x92, 0x80,
	0x77, 0x75, 0x75, 0x71, 0x6F, 0x71, 0x7D, 0x89, 0x94, 0x93, 0x8D, 0x85,
	0x82, 0x81, 0x80, 0x7B, 0x76, 0x73, 0x76, 0x7D, 0x83, 0x87, 0x85, 0x84,
	0x83, 0x84, 0x83, 0x82, 0x7D, 0x7A, 0x79, 0x7B, 0x7E, 0x80, 0x80, 0x80,
	0x81, 0x82, 0x83, 0x82, 0x81, 0x7E, 0x7D, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x81, 0x81, 0x7F, 0x81, 0x8D, 0x9F, 0xAF, 0xB0,
	0xA4, 0x90, 0x81, 0x7A, 0x79, 0x76, 0x71, 0x6D, 0x70, 0x7B, 0x88, 0x90,
	0x90, 0x8B, 0x84, 0x82, 0x81, 0x80, 0x7A, 0x75, 0x73, 0x77, 0x7C, 0x81,
	0x83, 0x83, 0x83, 0x84, 0x86, 0x85, 0x81, 0x7D, 0x7B, 0x7B, 0x7C, 0x7D,
	0x7E, 0x7E, 0x7F, 0x81, 0x83, 0x83, 0x84, 0x84, 0x85, 0x84, 0x83, 0x80,
	0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x82, 0x81, 0x87, 0x96,
	0xA8, 0xB1, 0xAA, 0x9B, 0x8B, 0x85, 0x80, 0x7B, 0x70, 0x6B, 0x6C, 0x76,
	0x82, 0x88, 0x8A, 0x8B, 0x8F, 0x90, 0x8E, 0x85, 0x7E, 0x78, 0x78, 0x77,
	0x77, 0x77, 0x79, 0x7E, 0x84, 0x87, 0x87, 0x86, 0x85, 0x85, 0x82, 0x7F,
	0x7B, 0x7A, 0x7A, 0x7C, 0x7C, 0x7E, 0x7F, 0x80, 0x82, 0x82, 0x82, 0x81,
	0x81, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7D, 0x7F, 0x7E, 0x80, 0x7F, 0x82,
	0x7F, 0x88, 0x9B, 0xAA, 0xAD, 0xA0, 0x97, 0x91, 0x8F, 0x84, 0x75, 0x6C,
	0x6D, 0x73, 0x74, 0x77, 0x7C, 0x87, 0x8E, 0x8F, 0x8C, 0x8A, 0x8A, 0x85,
	0x7F, 0x78, 0x76, 0x77, 0x77, 0x78, 0x7A, 0x7F, 0x83, 0x86, 0x86, 0x86,
	0x86, 0x84, 0x82, 0x7E, 0x7D, 0x7B, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x84,
	0x84, 0x84, 0x83, 0x82, 0x81, 0x7E, 0x7E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x81, 0x81, 0x82, 0x99, 0xA6, 0xA6, 0xA0, 0x9D, 0xA1, 0x93,
	0x86, 0x7C, 0x7D, 0x77, 0x6F, 0x71, 0x77, 0x7F, 0x7E, 0x82, 0x89, 0x8C,
	0x8A, 0x85, 0x87, 0x84, 0x7F, 0x7A, 0x7A, 0x7B, 0x79, 0x79, 0x7B, 0x80,
	0x81, 0x81, 0x83, 0x84, 0x84, 0x82, 0x80, 0x80, 0x7E, 0x7C, 0x7C, 0x7C,
	0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x80, 0x7E, 0x86, 0x9E, 0x9E, 0xA0,
	0xA7, 0xA6, 0x9A, 0x8D, 0x8B, 0x7B, 0x70, 0x6C, 0x6B, 0x6A, 0x6A, 0x74,
	0x79, 0x7D, 0x85, 0x89, 0x8B, 0x8A, 0x8A, 0x88, 0x83, 0x81, 0x7D, 0x7B,
	0x78, 0x79, 0x7A, 0x7B, 0x7D, 0x7F, 0x80, 0x80, 0x82, 0x81, 0x80, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x93, 0x94, 0x97, 0xAD, 0xA3, 0xA5, 0xA8, 0x9A, 0x90, 0x88, 0x7F,
	0x6F, 0x6E, 0x6A, 0x63, 0x6B, 0x6C, 0x71, 0x78, 0x7E, 0x82, 0x85, 0x8B,
	0x87, 0x88, 0x88, 0x83, 0x82, 0x80, 0x7E, 0x7D, 0x7E, 0x7D, 0x7D, 0x80,
	0x7F, 0x80, 0x82, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7E, 0x7F, 0x7F, 0x7E, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x81, 0x81, 0x81, 0x82, 0x82, 0x81, 0x87, 0x97, 0x90, 0xA6, 0xA7, 0x9D,
	0xAE, 0x96, 0x95, 0x8F, 0x7B, 0x7B, 0x6F, 0x6B, 0x69, 0x6B, 0x6D, 0x70,
	0x7A, 0x79, 0x83, 0x86, 0x84, 0x8D, 0x86, 0x87, 0x87, 0x80, 0x81, 0x7D,
	0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7E, 0x7D, 0x80, 0x81, 0x80, 0x83, 0x81,
	0x82, 0x82, 0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x81, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x80, 0x7E,
	0x81, 0x7C, 0x91, 0x95, 0x98, 0xB2, 0xA0, 0xAB, 0xA6, 0x91, 0x95, 0x80,
	0x77, 0x73, 0x69, 0x68, 0x6B, 0x6D, 0x72, 0x7C, 0x7F, 0x86, 0x8E, 0x8A,
	0x8F, 0x8D, 0x87, 0x87, 0x80, 0x7C, 0x7B, 0x78, 0x76, 0x79, 0x79, 0x7A,
	0x7F, 0x7F, 0x81, 0x85, 0x83, 0x85, 0x85, 0x81, 0x83, 0x80, 0x7D, 0x7F,
	0x7D, 0x7C, 0x7F, 0x7E, 0x7E, 0x81, 0x7F, 0x81, 0x82, 0x80, 0x81, 0x81,
	0x7F, 0x80, 0x80, 0x7E, 0x80, 0x7E, 0x7F, 0x7E, 0x81, 0x7C, 0x8C, 0x9B,
	0x95, 0xB2, 0xA7, 0xA3, 0xAA, 0x8F, 0x8D, 0x82, 0x72, 0x6F, 0x6C, 0x6A,
	0x6C, 0x77, 0x77, 0x80, 0x8A, 0x84, 0x8F, 0x8B, 0x86, 0x88, 0x81, 0x7E,
	0x7C, 0x7A, 0x78, 0x7A, 0x7B, 0x7A, 0x81, 0x80, 0x81, 0x85, 0x82, 0x83,
	0x83, 0x81, 0x80, 0x81, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x82, 0x83, 0xA1, 0x9D, 0xA6, 0xB9,
	0x9E, 0xA3, 0x94, 0x7E, 0x76, 0x69, 0x65, 0x5F, 0x6C, 0x6D, 0x75, 0x87,
	0x83, 0x8E, 0x91, 0x8A, 0x8A, 0x84, 0x7F, 0x7A, 0x7A, 0x78, 0x77, 0x7E,
	0x7B, 0x80, 0x83, 0x81, 0x84, 0x82, 0x82, 0x7F, 0x7F, 0x7F, 0x7B, 0x7F,
	0x7D, 0x7E, 0x81, 0x7F, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x80,
	0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7E, 0x82, 0x7D, 0x91, 0xA5, 0x96, 0xB4, 0xAA, 0x97,
	0x9A, 0x83, 0x74, 0x69, 0x69, 0x62, 0x66, 0x79, 0x76, 0x84, 0x8E, 0x8A,
	0x8E, 0x8A, 0x86, 0x7E, 0x7C, 0x7B, 0x74, 0x7B, 0x7C, 0x7D, 0x82, 0x84,
	0x84, 0x83, 0x84, 0x80, 0x7E, 0x7F, 0x7C, 0x7C, 0x7E, 0x7E, 0x7F, 0x80,
	0x82, 0x80, 0x81, 0x82, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x7F, 0x81, 0x7F, 0x80, 0x7D, 0x88, 0xAA, 0x9A, 0xAC, 0xB5, 0x97, 0x96,
	0x87, 0x78, 0x68, 0x6C, 0x70, 0x67, 0x7D, 0x84, 0x83, 0x8D, 0x8E, 0x8A,
	0x82, 0x84, 0x7C, 0x74, 0x7B, 0x78, 0x78, 0x7F, 0x82, 0x82, 0x84, 0x87,
	0x82, 0x80, 0x82, 0x7C, 0x7C, 0x7D, 0x7D, 0x7C, 0x7F, 0x81, 0x7F, 0x82,
	0x82, 0x80, 0x80, 0x7F, 0x80, 0x7D, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x81, 0x82, 0x80, 0x84, 0x7D, 0x9D, 0xB3, 0x9E, 0xBA, 0xAF, 0x95, 0x8A,
	0x7C, 0x71, 0x5C, 0x6D, 0x70, 0x6D, 0x84, 0x8C, 0x8C, 0x8E, 0x92, 0x88,
	0x7C, 0x80, 0x78, 0x70, 0x78, 0x7A, 0x7D, 0x83, 0x89, 0x8B, 0x86, 0x89,
	0x84, 0x7D, 0x7D, 0x7A, 0x7A, 0x78, 0x7E, 0x7F, 0x7F, 0x84, 0x84, 0x82,
	0x82, 0x81, 0x7F, 0x7D, 0x7E, 0x7D, 0x7C, 0x7F, 0x7F, 0x80, 0x81, 0x82,
	0x7D, 0x7A, 0x7E, 0x79, 0x79, 0x7C, 0x7E, 0x7F, 0x80, 0x84, 0x81, 0x81,
	0x83, 0x80, 0x7F, 0x7D, 0x7F, 0x7C, 0xA4, 0xAD, 0xA0, 0xBB, 0xA9, 0x95,
	0x86, 0x7D, 0x6E, 0x5D, 0x6F, 0x70, 0x6E, 0x7F, 0x8A, 0x8A, 0x88, 0x91,
	0x8A, 0x7D, 0x81, 0x7C, 0x74, 0x75, 0x7B, 0x7C, 0x7A, 0x84, 0x86, 0x82,
	0x86, 0x85, 0x81, 0x7D, 0x7F, 0x7E, 0x79, 0x7D, 0x7F, 0x7E, 0x80, 0x83,
	0x81, 0x7D, 0x81, 0x7F, 0x7B, 0x7E, 0x7F, 0x7D, 0x7E, 0x80, 0x81, 0x7F,
	0x81, 0x82, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x7F, 0x95, 0xA8, 0x9D, 0xAC, 0xA9,
	0x98, 0x90, 0x85, 0x7F, 0x70, 0x6F, 0x76, 0x6F, 0x76, 0x80, 0x81, 0x85,
	0x88, 0x8D, 0x88, 0x85, 0x87, 0x80, 0x7C, 0x7C, 0x7B, 0x7A, 0x79, 0x7E,
	0x7D, 0x7B, 0x80, 0x80, 0x80, 0x81, 0x82, 0x83, 0x80, 0x81, 0x82, 0x7E,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x81, 0x7F, 0x7F, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x96, 0x9F,
	0x9D, 0xA6, 0xA1, 0x99, 0x94, 0x8F, 0x8E, 0x82, 0x7D, 0x7C, 0x72, 0x70,
	0x74, 0x73, 0x76, 0x78, 0x7C, 0x81, 0x80, 0x87, 0x8B, 0x89, 0x8C, 0x8B,
	0x89, 0x87, 0x84, 0x84, 0x80, 0x7C, 0x7C, 0x79, 0x78, 0x79, 0x79, 0x7B,
	0x7B, 0x7D, 0x80, 0x80, 0x82, 0x84, 0x84, 0x85, 0x84, 0x84, 0x84, 0x81,
	0x81, 0x80, 0x7E, 0x7E, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x80,
	0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x8C, 0x96, 0x95, 0x98, 0x96, 0x93, 0x94, 0x94, 0x95, 0x8F, 0x86,
	0x82, 0x7C, 0x7A, 0x7C, 0x7A, 0x7A, 0x77, 0x77, 0x7B, 0x7D, 0x83, 0x86,
	0x85, 0x87, 0x86, 0x88, 0x8A, 0x88, 0x87, 0x83, 0x7F, 0x7F, 0x7C, 0x7D,
	0x7C, 0x79, 0x79, 0x79, 0x7A, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x83, 0x83,
	0x85, 0x85, 0x83, 0x83, 0x81, 0x80, 0x80, 0x7E, 0x7E, 0x7D, 0x7C, 0x7C,
	0x7D, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x83, 0x83, 0x83, 0x82, 0x81,
	0x81, 0x80, 0x80, 0x7F, 0x80, 0x8E, 0x94, 0x93, 0x98, 0x93, 0x93, 0x95,
	0x93, 0x93, 0x8B, 0x84, 0x81, 0x7B, 0x7C, 0x7D, 0x7A, 0x7A, 0x78, 0x7A,
	0x7F, 0x82, 0x86, 0x86, 0x86, 0x87, 0x88, 0x89, 0x89, 0x87, 0x84, 0x81,
	0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7A, 0x7A, 0x7B, 0x7E, 0x7F, 0x80, 0x81,
	0x82, 0x85, 0x86, 0x87, 0x87, 0x85, 0x84, 0x83, 0x82, 0x81, 0x7F, 0x7E,
	0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x82, 0x82, 0x83,
	0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x8A, 0x91, 0x90,
	0x93, 0x91, 0x91, 0x93, 0x92, 0x93, 0x8C, 0x86, 0x83, 0x7E, 0x7E, 0x7D,
	0x7B, 0x79, 0x77, 0x79, 0x7C, 0x7F, 0x82, 0x83, 0x85, 0x86, 0x88, 0x8A,
	0x8A, 0x89, 0x87, 0x85, 0x83, 0x81, 0x80, 0x7E, 0x7C, 0x7B, 0x7A, 0x7A,
	0x7B, 0x7C, 0x7D, 0x7E, 0x80, 0x81, 0x83, 0x85, 0x85, 0x85, 0x84, 0x84,
	0x83, 0x82, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7E, 0x7F, 0x81, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81,
	0x80, 0x86, 0x8C, 0x8B, 0x8D, 0x8C, 0x8C, 0x8D, 0x8D, 0x8E, 0x8B, 0x87,
	0x85, 0x83, 0x82, 0x81, 0x80, 0x7E, 0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x82,
	0x83, 0x83, 0x85, 0x87, 0x88, 0x88, 0x87, 0x86, 0x85, 0x84, 0x84, 0x82,
	0x81, 0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7F, 0x81,
	0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x84, 0x83, 0x82, 0x82, 0x81, 0x80,
	0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x82, 0x82, 0x82, 0x83, 0x86, 0x8B, 0x8B, 0x8C, 0x8D, 0x8C, 0x8D,
	0x8D, 0x8E, 0x8C, 0x89, 0x88, 0x85, 0x84, 0x83, 0x82, 0x80, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x84, 0x85, 0x86, 0x87, 0x87,
	0x87, 0x87, 0x87, 0x86, 0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x87, 0x87,
	0x89, 0x8A, 0x8A, 0x8B, 0x8C, 0x8E, 0x8D, 0x8B, 0x8A, 0x89, 0x88, 0x87,
	0x86, 0x85, 0x83, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81,
	0x82, 0x82, 0x82, 0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7C, 0x7B,
	0x7C, 0x7D, 0x7C, 0x7C, 0x7D, 0x7C, 0x7B, 0x7D, 0x7E, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80,
	0x7F, 0x81, 0x82, 0x81, 0x80, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7C,
	0x7B, 0x7B, 0x7A, 0x7B, 0x7B, 0x7B, 0x7B, 0x7A, 0x7B, 0x7B, 0x7B, 0x7B,
	0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x81, 0x82,
	0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7C,
	0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7C,
	0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x82, 0x81, 0x82, 0x82, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81,
	0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F
};
const unsigned char WAV11[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x83, 0x83, 0x82, 0x85, 0x83, 0x82, 0x81,
	0x80, 0x7E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x8F, 0x8D,
	0x8C, 0x95, 0x8D, 0x87, 0x81, 0x7E, 0x77, 0x72, 0x78, 0x77, 0x7A, 0x7F,
	0x82, 0x84, 0x82, 0x85, 0x82, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7F, 0x80,
	0x80, 0x82, 0x82, 0x82, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x81, 0x7D, 0x8B, 0xA3, 0x93, 0xA1, 0xA7, 0x94, 0x8C, 0x7F, 0x7E,
	0x6D, 0x69, 0x73, 0x72, 0x77, 0x7D, 0x87, 0x88, 0x84, 0x89, 0x85, 0x7F,
	0x7C, 0x7B, 0x7C, 0x78, 0x7D, 0x80, 0x80, 0x82, 0x83, 0x85, 0x81, 0x80,
	0x80, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7D, 0x88, 0xA3,
	0x9E, 0x9E, 0xA0, 0x9D, 0x92, 0x7B, 0x79, 0x73, 0x6D, 0x6A, 0x70, 0x7D,
	0x7F, 0x83, 0x89, 0x8C, 0x8A, 0x82, 0x82, 0x7F, 0x7A, 0x77, 0x78, 0x7D,
	0x7D, 0x7F, 0x82, 0x85, 0x85, 0x84, 0x84, 0x83, 0x81, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7E,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x7E,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7E, 0x80, 0x7E, 0x88, 0xA4, 0xA9, 0xA6, 0x99,
	0x95, 0x92, 0x81, 0x73, 0x68, 0x70, 0x75, 0x78, 0x7B, 0x82, 0x8F, 0x90,
	0x8C, 0x85, 0x83, 0x82, 0x7B, 0x77, 0x73, 0x78, 0x7C, 0x80, 0x81, 0x83,
	0x86, 0x87, 0x85, 0x80, 0x7E, 0x7D, 0x7D, 0x7C, 0x7B, 0x7C, 0x7F, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x80, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7D,
	0x7E, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x99, 0xAD, 0xB5, 0xA7, 0x93, 0x8D, 0x86,
	0x81, 0x6E, 0x67, 0x68, 0x79, 0x86, 0x8A, 0x8B, 0x8B, 0x93, 0x91, 0x8C,
	0x7D, 0x77, 0x75, 0x78, 0x79, 0x77, 0x7A, 0x7F, 0x88, 0x8A, 0x89, 0x84,
	0x82, 0x82, 0x80, 0x7D, 0x78, 0x78, 0x7B, 0x7F, 0x80, 0x81, 0x82, 0x85,
	0x89, 0x89, 0x85, 0x80, 0x7E, 0x7E, 0x7E, 0x7C, 0x7B, 0x7B, 0x7F, 0x82,
	0x83, 0x82, 0x82, 0x82, 0x82, 0x81, 0x7F, 0x7D, 0x7D, 0x7D, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x94, 0xA9, 0xB9, 0xB1, 0x9F, 0x8F, 0x87, 0x86, 0x7B,
	0x70, 0x64, 0x6B, 0x77, 0x87, 0x8B, 0x8A, 0x8C, 0x8F, 0x94, 0x8D, 0x84,
	0x77, 0x75, 0x75, 0x79, 0x78, 0x78, 0x7B, 0x81, 0x89, 0x8A, 0x89, 0x85,
	0x85, 0x85, 0x84, 0x80, 0x7A, 0x78, 0x79, 0x7D, 0x7E, 0x7F, 0x7F, 0x81,
	0x83, 0x85, 0x85, 0x82, 0x80, 0x7E, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7E,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x8C, 0x9A, 0xA9, 0xA9, 0xA1, 0x95, 0x8D, 0x8B, 0x86, 0x7E,
	0x71, 0x6D, 0x6E, 0x78, 0x7E, 0x83, 0x82, 0x84, 0x88, 0x8D, 0x8E, 0x88,
	0x81, 0x7A, 0x7B, 0x7C, 0x7D, 0x7A, 0x78, 0x76, 0x7B, 0x80, 0x84, 0x84,
	0x81, 0x81, 0x81, 0x84, 0x84, 0x82, 0x7E, 0x7C, 0x7C, 0x7F, 0x80, 0x7F,
	0x7D, 0x7C, 0x7E, 0x81, 0x83, 0x82, 0x81, 0x80, 0x81, 0x82, 0x83, 0x82,
	0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7F, 0x80, 0x81,
	0x80, 0x83, 0x8C, 0x99, 0xA5, 0xA6, 0xA0, 0x96, 0x90, 0x8C, 0x8B, 0x85,
	0x7C, 0x71, 0x6B, 0x6C, 0x71, 0x78, 0x7A, 0x7A, 0x7A, 0x7E, 0x83, 0x8A,
	0x8B, 0x8A, 0x85, 0x82, 0x81, 0x83, 0x83, 0x81, 0x7C, 0x79, 0x79, 0x7B,
	0x7E, 0x7F, 0x7F, 0x7D, 0x7D, 0x7F, 0x82, 0x84, 0x84, 0x82, 0x7F, 0x7E,
	0x7F, 0x81, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7F, 0x80, 0x81, 0x80, 0x7F,
	0x7E, 0x7F, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x81,
	0x81, 0x86, 0x90, 0x9D, 0xA6, 0xA8, 0xA2, 0x9A, 0x91, 0x8D, 0x8A, 0x85,
	0x7E, 0x75, 0x6E, 0x6B, 0x6E, 0x74, 0x79, 0x7B, 0x7C, 0x7D, 0x81, 0x86,
	0x8A, 0x8C, 0x8A, 0x86, 0x82, 0x81, 0x80, 0x81, 0x7F, 0x7C, 0x79, 0x78,
	0x79, 0x7B, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x83, 0x84, 0x84, 0x82,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x86, 0x8F, 0x9B, 0xA2, 0xA3, 0x9E, 0x97, 0x91, 0x8D, 0x8A, 0x86,
	0x7F, 0x77, 0x71, 0x6E, 0x6F, 0x73, 0x77, 0x79, 0x79, 0x7B, 0x7E, 0x83,
	0x88, 0x8A, 0x8A, 0x88, 0x85, 0x83, 0x83, 0x83, 0x81, 0x7E, 0x7B, 0x79,
	0x79, 0x7A, 0x7C, 0x7D, 0x7E, 0x7E, 0x7E, 0x80, 0x82, 0x83, 0x84, 0x83,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x80,
	0x84, 0x8D, 0x98, 0x9F, 0xA2, 0x9F, 0x9A, 0x97, 0x95, 0x92, 0x8D, 0x85,
	0x7B, 0x74, 0x71, 0x72, 0x73, 0x75, 0x75, 0x75, 0x77, 0x7C, 0x82, 0x87,
	0x89, 0x88, 0x87, 0x86, 0x86, 0x87, 0x86, 0x83, 0x7F, 0x7C, 0x7A, 0x7B,
	0x7B, 0x7C, 0x7B, 0x7A, 0x7B, 0x7D, 0x80, 0x82, 0x82, 0x82, 0x81, 0x82,
	0x82, 0x83, 0x82, 0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x7D,
	0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x81, 0x86,
	0x92, 0xA2, 0xAB, 0xAA, 0xA1, 0x97, 0x91, 0x8F, 0x8E, 0x86, 0x7A, 0x6E,
	0x6A, 0x6C, 0x72, 0x76, 0x76, 0x74, 0x76, 0x7C, 0x84, 0x8A, 0x8A, 0x88,
	0x86, 0x87, 0x88, 0x88, 0x83, 0x7E, 0x7A, 0x7B, 0x7D, 0x7E, 0x7C, 0x7B,
	0x7A, 0x7D, 0x81, 0x83, 0x82, 0x80, 0x7F, 0x80, 0x83, 0x83, 0x81, 0x7E,
	0x7D, 0x7E, 0x80, 0x80, 0x7F, 0x7D, 0x7B, 0x7C, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7E, 0x80, 0x81, 0x82, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x82, 0x96, 0xAC,
	0xBC, 0xB3, 0xA0, 0x8B, 0x86, 0x84, 0x80, 0x73, 0x66, 0x66, 0x71, 0x83,
	0x8C, 0x8F, 0x89, 0x8A, 0x8B, 0x8B, 0x83, 0x78, 0x71, 0x72, 0x79, 0x7E,
	0x80, 0x7F, 0x82, 0x86, 0x8A, 0x87, 0x82, 0x7C, 0x7B, 0x7C, 0x7D, 0x7C,
	0x7B, 0x7C, 0x81, 0x84, 0x85, 0x84, 0x83, 0x82, 0x81, 0x7F, 0x7C, 0x7C,
	0x7C, 0x7F, 0x80, 0x82, 0x81, 0x82, 0x81, 0x82, 0x7F, 0x7F, 0x7D, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0xA1, 0xC3, 0xD4, 0xAF,
	0x80, 0x63, 0x6D, 0x7B, 0x77, 0x6C, 0x6F, 0x8E, 0xA4, 0xA9, 0x91, 0x82,
	0x7A, 0x80, 0x78, 0x6F, 0x6A, 0x76, 0x88, 0x90, 0x8F, 0x87, 0x87, 0x85,
	0x83, 0x78, 0x73, 0x72, 0x7B, 0x85, 0x8B, 0x8C, 0x88, 0x86, 0x82, 0x7F,
	0x7A, 0x78, 0x78, 0x7C, 0x81, 0x84, 0x85, 0x86, 0x84, 0x83, 0x7E, 0x7D,
	0x7B, 0x7C, 0x7D, 0x7F, 0x80, 0x82, 0x83, 0x83, 0x81, 0x80, 0x7D, 0x7F,
	0x81, 0x81, 0x81, 0x7F, 0x82, 0x7E, 0xA8, 0xD2, 0xE0, 0xAE, 0x74, 0x61,
	0x6F, 0x7E, 0x6D, 0x6C, 0x7D, 0xA7, 0xAE, 0x9E, 0x84, 0x7F, 0x80, 0x77,
	0x6A, 0x66, 0x7B, 0x8C, 0x94, 0x8B, 0x8A, 0x8A, 0x87, 0x79, 0x70, 0x70,
	0x7C, 0x82, 0x83, 0x83, 0x88, 0x8B, 0x85, 0x7D, 0x77, 0x7A, 0x7B, 0x7D,
	0x7C, 0x81, 0x85, 0x87, 0x83, 0x7F, 0x7E, 0x7D, 0x7D, 0x7B, 0x7D, 0x82,
	0x85, 0x85, 0x81, 0x80, 0x7F, 0x80, 0x7D, 0x7C, 0x7D, 0x80, 0x82, 0x80,
	0x82, 0x7F, 0x84, 0x7A, 0xA1, 0xD1, 0xDF, 0xB3, 0x77, 0x6B, 0x6F, 0x78,
	0x62, 0x6D, 0x88, 0xAB, 0xA8, 0x90, 0x85, 0x82, 0x82, 0x6C, 0x66, 0x6F,
	0x88, 0x8F, 0x8B, 0x87, 0x8A, 0x8C, 0x7E, 0x73, 0x70, 0x7B, 0x80, 0x80,
	0x81, 0x86, 0x8B, 0x86, 0x7E, 0x79, 0x7B, 0x7D, 0x7D, 0x7B, 0x80, 0x7F,
	0x7E, 0x7B, 0x7D, 0x80, 0x80, 0x7F, 0x7D, 0x80, 0x80, 0x80, 0x7D, 0x7E,
	0x80, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x80,
	0x7E, 0x81, 0x7C, 0xA9, 0xD4, 0xD6, 0xB0, 0x7B, 0x77, 0x6F, 0x6E, 0x5D,
	0x71, 0x91, 0xA6, 0xA2, 0x8D, 0x8D, 0x85, 0x7D, 0x67, 0x68, 0x76, 0x87,
	0x8A, 0x87, 0x8C, 0x8E, 0x89, 0x79, 0x73, 0x75, 0x7C, 0x7D, 0x7D, 0x86,
	0x8C, 0x8E, 0x83, 0x7D, 0x7B, 0x7C, 0x7C, 0x78, 0x7D, 0x82, 0x88, 0x84,
	0x82, 0x80, 0x81, 0x7F, 0x7B, 0x7B, 0x7D, 0x81, 0x81, 0x80, 0x82, 0x82,
	0x82, 0x7E, 0x7D, 0x7E, 0x7E, 0x80, 0x7F, 0x81, 0x80, 0x82, 0x80, 0x80,
	0x7E, 0x80, 0x7B, 0xA1, 0xC9, 0xCE, 0xB1, 0x7F, 0x79, 0x72, 0x73, 0x64,
	0x6B, 0x87, 0x9C, 0xA3, 0x90, 0x8D, 0x87, 0x84, 0x73, 0x68, 0x70, 0x7F,
	0x8D, 0x8A, 0x88, 0x8A, 0x8B, 0x87, 0x79, 0x74, 0x75, 0x7D, 0x7F, 0x7F,
	0x82, 0x86, 0x8A, 0x85, 0x7F, 0x7B, 0x7C, 0x7D, 0x7C, 0x7C, 0x7E, 0x83,
	0x85, 0x82, 0x81, 0x7F, 0x81, 0x7D, 0x79, 0x79, 0x7A, 0x81, 0x80, 0x82,
	0x80, 0x82, 0x82, 0x80, 0x7E, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x81,
	0x81, 0x81, 0x80, 0x7F, 0xA3, 0xBE, 0xC2, 0xA6, 0x82, 0x7C, 0x77, 0x7C,
	0x6F, 0x6A, 0x78, 0x88, 0x9C, 0x95, 0x8C, 0x87, 0x84, 0x86, 0x79, 0x72,
	0x70, 0x77, 0x84, 0x84, 0x87, 0x84, 0x87, 0x89, 0x83, 0x7E, 0x77, 0x79,
	0x7C, 0x7D, 0x80, 0x7E, 0x82, 0x85, 0x86, 0x85, 0x80, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7C, 0x7D, 0x7F, 0x82, 0x83, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7E,
	0x7E, 0x7D, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7E,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7E, 0x8D, 0xA0, 0xA8, 0xA5, 0x95, 0x8C, 0x89,
	0x84, 0x7E, 0x71, 0x70, 0x76, 0x80, 0x88, 0x86, 0x87, 0x88, 0x8A, 0x8B,
	0x83, 0x7D, 0x78, 0x79, 0x7D, 0x7C, 0x7B, 0x7A, 0x7E, 0x83, 0x83, 0x83,
	0x80, 0x7F, 0x81, 0x81, 0x80, 0x7D, 0x7C, 0x7E, 0x80, 0x80, 0x7F, 0x7E,
	0x80, 0x81, 0x82, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x82, 0x82, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x88, 0x8F, 0x92, 0x92, 0x8F, 0x8E,
	0x8D, 0x8B, 0x88, 0x82, 0x7F, 0x7E, 0x7D, 0x7C, 0x79, 0x78, 0x78, 0x79,
	0x7A, 0x7A, 0x7A, 0x7A, 0x7C, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x85, 0x85, 0x86, 0x86, 0x87,
	0x88, 0x88, 0x87, 0x86, 0x86, 0x85, 0x85, 0x83, 0x82, 0x81, 0x80, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x83, 0x88, 0x86, 0x86, 0x87, 0x88,
	0x88, 0x86, 0x84, 0x84, 0x84, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x8E, 0x91, 0x8D, 0x8F, 0x8F, 0x90,
	0x8B, 0x82, 0x80, 0x81, 0x7D, 0x7A, 0x7A, 0x7C, 0x80, 0x80, 0x7F, 0x83,
	0x85, 0x84, 0x83, 0x81, 0x81, 0x81, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x7E,
	0x7F, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x83, 0x9F, 0xA9, 0x9C, 0x9C, 0x9C, 0x94, 0x88,
	0x75, 0x72, 0x78, 0x72, 0x70, 0x79, 0x82, 0x8A, 0x89, 0x87, 0x8E, 0x8B,
	0x83, 0x7E, 0x7B, 0x7B, 0x7A, 0x74, 0x78, 0x7F, 0x7F, 0x81, 0x82, 0x85,
	0x86, 0x82, 0x7F, 0x80, 0x7E, 0x7C, 0x7B, 0x7C, 0x7F, 0x7F, 0x7F, 0x81,
	0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F,
	0x80, 0x80, 0x81, 0x7F, 0xA1, 0xBA, 0xA7, 0xA3, 0xA6, 0x9C, 0x8A, 0x6E,
	0x6B, 0x76, 0x6A, 0x6A, 0x78, 0x87, 0x8F, 0x88, 0x8B, 0x93, 0x89, 0x7D,
	0x79, 0x79, 0x7A, 0x73, 0x75, 0x80, 0x83, 0x83, 0x83, 0x86, 0x89, 0x81,
	0x7D, 0x7F, 0x7E, 0x7B, 0x79, 0x7C, 0x81, 0x80, 0x80, 0x82, 0x83, 0x82,
	0x7D, 0x7D, 0x7F, 0x7D, 0x7B, 0x7D, 0x80, 0x81, 0x7F, 0x81, 0x82, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x80,
	0x81, 0x7E, 0x81, 0x7C, 0x93, 0xC3, 0xB8, 0xAB, 0xB0, 0xA7, 0x94, 0x6E,
	0x62, 0x70, 0x66, 0x63, 0x72, 0x85, 0x94, 0x8A, 0x8B, 0x96, 0x8A, 0x7C,
	0x75, 0x75, 0x7A, 0x71, 0x74, 0x82, 0x85, 0x86, 0x84, 0x87, 0x89, 0x83,
	0x80, 0x81, 0x7F, 0x7E, 0x7B, 0x7D, 0x81, 0x7F, 0x7F, 0x81, 0x82, 0x82,
	0x7E, 0x7F, 0x81, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0xAA, 0xC2, 0xAD, 0xB0, 0xAE,
	0xA0, 0x82, 0x64, 0x6C, 0x6C, 0x5C, 0x69, 0x7C, 0x8C, 0x8D, 0x87, 0x9C,
	0x9A, 0x84, 0x7F, 0x7E, 0x7E, 0x71, 0x6C, 0x7F, 0x81, 0x7C, 0x81, 0x89,
	0x8C, 0x81, 0x7C, 0x85, 0x7F, 0x77, 0x78, 0x7E, 0x82, 0x7C, 0x7E, 0x87,
	0x84, 0x7F, 0x7F, 0x82, 0x82, 0x79, 0x7A, 0x81, 0x7D, 0x7C, 0x7E, 0x83,
	0x83, 0x7D, 0x81, 0x84, 0x7F, 0x7D, 0x7E, 0x81, 0x7F, 0x7B, 0x80, 0x82,
	0x7F, 0x7F, 0x80, 0x82, 0x80, 0x7C, 0x81, 0x80, 0x7F, 0x7D, 0x85, 0xAB,
	0xAB, 0xA2, 0xAD, 0xA7, 0x96, 0x7B, 0x70, 0x76, 0x65, 0x60, 0x72, 0x7D,
	0x83, 0x81, 0x8D, 0x95, 0x85, 0x7E, 0x81, 0x7D, 0x76, 0x70, 0x7C, 0x82,
	0x7B, 0x81, 0x89, 0x88, 0x83, 0x7F, 0x84, 0x81, 0x78, 0x7B, 0x7F, 0x7F,
	0x7C, 0x7E, 0x86, 0x82, 0x7E, 0x82, 0x83, 0x80, 0x7C, 0x7E, 0x81, 0x7D,
	0x7C, 0x81, 0x81, 0x80, 0x7E, 0x82, 0x82, 0x7E, 0x7E, 0x80, 0x80, 0x7C,
	0x7D, 0x80, 0x7E, 0x7D, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x82, 0x80, 0x7E,
	0x80, 0x7F, 0x7F, 0x7D, 0x8C, 0xA4, 0x9E, 0xA0, 0xA7, 0x9F, 0x91, 0x7F,
	0x7C, 0x78, 0x67, 0x6C, 0x75, 0x78, 0x7C, 0x81, 0x8C, 0x8C, 0x85, 0x8A,
	0x88, 0x80, 0x7D, 0x7C, 0x7E, 0x79, 0x78, 0x7F, 0x7E, 0x7E, 0x81, 0x82,
	0x84, 0x80, 0x80, 0x83, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7D, 0x7F, 0x81,
	0x80, 0x81, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7F, 0x8F,
	0x96, 0x97, 0x9D, 0x9C, 0x9A, 0x95, 0x91, 0x90, 0x88, 0x82, 0x80, 0x7A,
	0x77, 0x74, 0x74, 0x76, 0x74, 0x77, 0x7B, 0x7B, 0x7F, 0x81, 0x83, 0x85,
	0x83, 0x85, 0x84, 0x82, 0x83, 0x81, 0x7F, 0x7E, 0x7C, 0x7C, 0x7B, 0x7B,
	0x7C, 0x7B, 0x7D, 0x7E, 0x7E, 0x80, 0x80, 0x81, 0x82, 0x81, 0x82, 0x82,
	0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7D, 0x7E,
	0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x82, 0x8F, 0x93, 0x95, 0x97, 0x94, 0x94,
	0x93, 0x93, 0x92, 0x8A, 0x84, 0x80, 0x7B, 0x7B, 0x7A, 0x79, 0x78, 0x76,
	0x79, 0x7C, 0x7F, 0x84, 0x84, 0x86, 0x87, 0x87, 0x8A, 0x89, 0x88, 0x86,
	0x82, 0x81, 0x7F, 0x7E, 0x7D, 0x7B, 0x7B, 0x7B, 0x7C, 0x7E, 0x7E, 0x80,
	0x81, 0x82, 0x83, 0x83, 0x84, 0x84, 0x83, 0x83, 0x81, 0x81, 0x80, 0x7F,
	0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x86,
	0x92, 0x92, 0x95, 0x95, 0x91, 0x93, 0x92, 0x92, 0x8E, 0x85, 0x81, 0x7C,
	0x7B, 0x7B, 0x79, 0x78, 0x76, 0x77, 0x7B, 0x7E, 0x82, 0x84, 0x85, 0x87,
	0x87, 0x89, 0x8A, 0x88, 0x86, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7B, 0x79,
	0x79, 0x7A, 0x7C, 0x7D, 0x7F, 0x80, 0x81, 0x82, 0x84, 0x85, 0x85, 0x84,
	0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D,
	0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81,
	0x7F, 0x7F, 0x7D, 0x82, 0x8D, 0x8E, 0x90, 0x91, 0x8F, 0x92, 0x92, 0x93,
	0x91, 0x8A, 0x87, 0x82, 0x80, 0x80, 0x7D, 0x7B, 0x78, 0x78, 0x7A, 0x7C,
	0x80, 0x82, 0x83, 0x85, 0x86, 0x89, 0x8A, 0x8A, 0x89, 0x87, 0x85, 0x83,
	0x82, 0x80, 0x7E, 0x7C, 0x7A, 0x7A, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x80,
	0x81, 0x84, 0x85, 0x85, 0x85, 0x85, 0x85, 0x84, 0x83, 0x82, 0x80, 0x7F,
	0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81,
	0x82, 0x82, 0x83, 0x83, 0x85, 0x8C, 0x8C, 0x8C, 0x8D, 0x8C, 0x8C, 0x8B,
	0x8C, 0x8A, 0x86, 0x84, 0x82, 0x80, 0x80, 0x7F, 0x7F, 0x7D, 0x7D, 0x7E,
	0x7F, 0x81, 0x82, 0x84, 0x84, 0x85, 0x87, 0x87, 0x88, 0x87, 0x86, 0x86,
	0x84, 0x84, 0x83, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x84, 0x84, 0x84, 0x85, 0x84, 0x84,
	0x83, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x81, 0x86, 0x89, 0x89, 0x8B, 0x8C, 0x8C, 0x8D, 0x8E,
	0x8E, 0x8B, 0x8A, 0x88, 0x86, 0x85, 0x84, 0x82, 0x80, 0x7E, 0x7E, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x84,
	0x85, 0x85, 0x85, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x83, 0x85, 0x86, 0x86, 0x87, 0x87, 0x87, 0x88, 0x89, 0x88, 0x87,
	0x87, 0x86, 0x85, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x83, 0x83, 0x84,
	0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80
};
const unsigned char WAV12[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x7E,
	0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x81, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x80,
	0x7E, 0x7E, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F,
	0x7D, 0x7D, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x80, 0x80, 0x7F, 0x81, 0x82,
	0x80, 0x81, 0x83, 0x80, 0x80, 0x81, 0x7F, 0x7E, 0x80, 0x7D, 0x7C, 0x81,
	0x80, 0x80, 0x82, 0x84, 0x81, 0x85, 0x82, 0x7E, 0x81, 0x7E, 0x7C, 0x7A,
	0x7C, 0x79, 0x7C, 0x7F, 0x7C, 0x83, 0x80, 0x7F, 0x7E, 0x82, 0x81, 0x81,
	0x84, 0x7F, 0x80, 0x83, 0x84, 0x80, 0x81, 0x80, 0x7D, 0x82, 0x84, 0x82,
	0x85, 0x83, 0x7F, 0x80, 0x7E, 0x80, 0x7D, 0x7C, 0x7E, 0x7B, 0x7D, 0x82,
	0x81, 0x81, 0x86, 0x85, 0x82, 0x83, 0x83, 0x7E, 0x80, 0x80, 0x79, 0x7C,
	0x82, 0x7F, 0x7F, 0x86, 0x84, 0x84, 0x87, 0x85, 0x7C, 0x86, 0x87, 0x80,
	0x80, 0x7F, 0x7B, 0x7A, 0x7A, 0x7B, 0x7E, 0x7D, 0x78, 0x74, 0x7E, 0x7C,
	0x7D, 0x81, 0x83, 0x7B, 0x7C, 0x82, 0x80, 0x7D, 0x7D, 0x85, 0x7A, 0x7C,
	0x86, 0x81, 0x7B, 0x83, 0x83, 0x78, 0x84, 0x84, 0x80, 0x85, 0x86, 0x78,
	0x80, 0x8A, 0x78, 0x80, 0x86, 0x7F, 0x7C, 0x83, 0x7F, 0x7B, 0x83, 0x80,
	0x7C, 0x81, 0x80, 0x78, 0x7C, 0x7F, 0x7C, 0x7F, 0x85, 0x82, 0x7F, 0x84,
	0x81, 0x82, 0x82, 0x81, 0x82, 0x7F, 0x81, 0x88, 0x82, 0x7E, 0x8C, 0x83,
	0x87, 0x8C, 0x85, 0x80, 0x7D, 0x82, 0x7B, 0x82, 0x81, 0x7F, 0x82, 0x7F,
	0x82, 0x82, 0x82, 0x7B, 0x82, 0x83, 0x7C, 0x81, 0x7F, 0x7E, 0x7F, 0x82,
	0x82, 0x80, 0x82, 0x81, 0x7E, 0x84, 0x80, 0x7F, 0x82, 0x7F, 0x81, 0x87,
	0x7F, 0x81, 0x8A, 0x80, 0x89, 0x86, 0x86, 0x84, 0x7D, 0x88, 0x7E, 0x82,
	0x88, 0x7D, 0x81, 0x7D, 0x81, 0x7C, 0x80, 0x82, 0x7C, 0x83, 0x7F, 0x80,
	0x7C, 0x83, 0x82, 0x7F, 0x87, 0x84, 0x7F, 0x84, 0x83, 0x7F, 0x81, 0x81,
	0x7F, 0x7B, 0x80, 0x82, 0x7D, 0x7E, 0x84, 0x81, 0x7F, 0x83, 0x83, 0x7C,
	0x82, 0x83, 0x7B, 0x7D, 0x80, 0x7F, 0x7A, 0x83, 0x80, 0x7C, 0x80, 0x81,
	0x7C, 0x7E, 0x84, 0x7F, 0x7F, 0x81, 0x85, 0x7F, 0x80, 0x87, 0x7D, 0x7E,
	0x85, 0x80, 0x80, 0x7F, 0x81, 0x7E, 0x7B, 0x82, 0x80, 0x7E, 0x7E, 0x82,
	0x80, 0x7E, 0x7F, 0x81, 0x81, 0x7F, 0x82, 0x84, 0x7F, 0x80, 0x83, 0x7F,
	0x7E, 0x81, 0x82, 0x7B, 0x7F, 0x83, 0x7E, 0x7C, 0x81, 0x7E, 0x7C, 0x80,
	0x81, 0x80, 0x7E, 0x83, 0x82, 0x7E, 0x80, 0x84, 0x7F, 0x7E, 0x82, 0x82,
	0x7E, 0x7D, 0x81, 0x80, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7C, 0x7F, 0x82,
	0x81, 0x7C, 0x7C, 0x81, 0x82, 0x7F, 0x7E, 0x80, 0x82, 0x81, 0x7F, 0x80,
	0x82, 0x7E, 0x7E, 0x83, 0x80, 0x7C, 0x7F, 0x7F, 0x7D, 0x7F, 0x80, 0x81,
	0x7F, 0x7E, 0x7F, 0x82, 0x82, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x7F, 0x7D,
	0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x7D, 0x7C, 0x81, 0x82, 0x7F, 0x7A,
	0x7C, 0x81, 0x83, 0x80, 0x7D, 0x7E, 0x82, 0x83, 0x80, 0x7B, 0x7B, 0x81,
	0x84, 0x80, 0x79, 0x7B, 0x81, 0x85, 0x82, 0x7D, 0x7D, 0x81, 0x84, 0x81,
	0x7F, 0x7E, 0x7D, 0x82, 0x83, 0x7E, 0x7C, 0x7E, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x7D, 0x81, 0x82,
	0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x7F, 0x7E, 0x7F,
	0x82, 0x82, 0x7F, 0x7D, 0x7F, 0x81, 0x81, 0x81, 0x7F, 0x7D, 0x7E, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7E, 0x7F, 0x81, 0x82, 0x82, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x7E, 0x7D,
	0x7E, 0x7F, 0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x81, 0x81, 0x80,
	0x81, 0x82, 0x82, 0x82, 0x81, 0x7E, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81,
	0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x82, 0x83, 0x84, 0x85, 0x86, 0x88,
	0x8A, 0x8A, 0x88, 0x85, 0x82, 0x80, 0x81, 0x81, 0x81, 0x7F, 0x7E, 0x7D,
	0x7E, 0x7F, 0x82, 0x83, 0x86, 0x87, 0x87, 0x87, 0x86, 0x85, 0x84, 0x82,
	0x81, 0x7F, 0x80, 0x85, 0x88, 0x8B, 0x8B, 0x88, 0x86, 0x84, 0x83, 0x83,
	0x82, 0x80, 0x7E, 0x7C, 0x7B, 0x7D, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F,
	0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x84, 0x8D, 0x97, 0x9F, 0xA0, 0x9B,
	0x93, 0x89, 0x83, 0x7F, 0x7D, 0x7A, 0x77, 0x73, 0x72, 0x73, 0x77, 0x7D,
	0x81, 0x84, 0x84, 0x83, 0x82, 0x82, 0x83, 0x84, 0x83, 0x81, 0x7E, 0x7C,
	0x7C, 0x7C, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x88, 0x95,
	0xA2, 0xAE, 0xB0, 0xA9, 0x9B, 0x8A, 0x7D, 0x75, 0x71, 0x70, 0x6E, 0x6C,
	0x6C, 0x6E, 0x74, 0x7C, 0x84, 0x89, 0x8A, 0x87, 0x84, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x7E, 0x7B, 0x7B, 0x7B, 0x7E, 0x81, 0x83, 0x82, 0x81, 0x7F,
	0x7E, 0x7F, 0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D,
	0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x89, 0x9A, 0xAB, 0xBA, 0xBA, 0xAE, 0x9B, 0x84, 0x76, 0x6E,
	0x6B, 0x6C, 0x6B, 0x6B, 0x6F, 0x77, 0x84, 0x8E, 0x94, 0x93, 0x8B, 0x84,
	0x7F, 0x7C, 0x7C, 0x7C, 0x79, 0x77, 0x76, 0x78, 0x7E, 0x83, 0x88, 0x87,
	0x85, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7B, 0x79, 0x7A, 0x7C, 0x80,
	0x82, 0x83, 0x81, 0x80, 0x80, 0x81, 0x82, 0x81, 0x80, 0x7D, 0x7C, 0x7D,
	0x7F, 0x80, 0x81, 0x80, 0x80, 0x7E, 0x85, 0x9E, 0xB7, 0xCA, 0xCA, 0xB3,
	0x96, 0x79, 0x69, 0x67, 0x64, 0x63, 0x61, 0x65, 0x74, 0x88, 0x9B, 0xA3,
	0x9D, 0x92, 0x86, 0x7F, 0x7D, 0x79, 0x73, 0x6D, 0x69, 0x6F, 0x7B, 0x87,
	0x8E, 0x8D, 0x89, 0x85, 0x84, 0x85, 0x83, 0x7F, 0x79, 0x76, 0x78, 0x7C,
	0x81, 0x83, 0x82, 0x81, 0x82, 0x84, 0x85, 0x83, 0x7F, 0x7B, 0x7A, 0x7C,
	0x7E, 0x80, 0x7F, 0x7E, 0x7F, 0x81, 0x83, 0x84, 0x81, 0x80, 0x7C, 0x8A,
	0xB1, 0xC9, 0xCC, 0xAD, 0x85, 0x74, 0x74, 0x7D, 0x78, 0x65, 0x5D, 0x68,
	0x87, 0xA4, 0xA6, 0x99, 0x87, 0x80, 0x88, 0x89, 0x7F, 0x6C, 0x5E, 0x67,
	0x7B, 0x8C, 0x91, 0x87, 0x82, 0x85, 0x8D, 0x91, 0x85, 0x75, 0x6E, 0x72,
	0x7E, 0x83, 0x7F, 0x7C, 0x7D, 0x88, 0x8F, 0x8B, 0x82, 0x78, 0x78, 0x7E,
	0x7F, 0x7D, 0x78, 0x78, 0x80, 0x87, 0x89, 0x84, 0x7F, 0x7E, 0x81, 0x82,
	0x7F, 0x75, 0x75, 0x77, 0x8A, 0xC6, 0xDB, 0xCA, 0xA1, 0x79, 0x81, 0x85,
	0x74, 0x5E, 0x4E, 0x6A, 0x93, 0xA4, 0xA3, 0x8F, 0x8F, 0x9A, 0x93, 0x81,
	0x66, 0x5B, 0x6C, 0x7B, 0x83, 0x82, 0x80, 0x90, 0x98, 0x93, 0x84, 0x74,
	0x75, 0x79, 0x77, 0x75, 0x74, 0x7E, 0x8B, 0x8C, 0x8A, 0x83, 0x82, 0x83,
	0x7E, 0x79, 0x75, 0x77, 0x7E, 0x81, 0x82, 0x82, 0x84, 0x87, 0x85, 0x80,
	0x7C, 0x78, 0x79, 0x7A, 0x7B, 0x7E, 0x80, 0x83, 0x85, 0x83, 0x82, 0xAF,
	0xD5, 0xC3, 0xA2, 0x7D, 0x7F, 0x85, 0x6D, 0x5E, 0x61, 0x7D, 0x9B, 0x96,
	0x90, 0x90, 0x93, 0x94, 0x7C, 0x6C, 0x6B, 0x73, 0x7E, 0x7B, 0x7E, 0x8B,
	0x8F, 0x90, 0x84, 0x7B, 0x7D, 0x7A, 0x78, 0x75, 0x78, 0x83, 0x85, 0x85,
	0x84, 0x83, 0x85, 0x80, 0x7B, 0x7A, 0x7A, 0x7E, 0x7F, 0x7F, 0x82, 0x83,
	0x84, 0x80, 0x7D, 0x7D, 0x7E, 0x7E, 0x7D, 0x7E, 0x80, 0x82, 0x81, 0x81,
	0x7F, 0x80, 0x7F, 0x7E, 0x7C, 0x85, 0xC0, 0xD3, 0xB8, 0x9A, 0x80, 0x88,
	0x78, 0x5A, 0x60, 0x71, 0x90, 0x98, 0x8B, 0x94, 0x93, 0x8C, 0x7B, 0x67,
	0x71, 0x78, 0x7A, 0x7E, 0x80, 0x8F, 0x8F, 0x85, 0x80, 0x79, 0x7D, 0x7A,
	0x74, 0x7C, 0x7F, 0x86, 0x86, 0x80, 0x85, 0x81, 0x7F, 0x7C, 0x78, 0x7E,
	0x7F, 0x84, 0x88, 0x84, 0x86, 0x82, 0x7F, 0x7E, 0x7A, 0x7C, 0x7E, 0x7F,
	0x83, 0x81, 0x83, 0x83, 0x7F, 0x7F, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x82,
	0x7D, 0xA6, 0xD8, 0xC8, 0xA6, 0x83, 0x80, 0x81, 0x61, 0x5C, 0x6F, 0x8E,
	0xA1, 0x8E, 0x8E, 0x91, 0x89, 0x7C, 0x64, 0x6C, 0x7C, 0x7F, 0x85, 0x82,
	0x8D, 0x91, 0x82, 0x7C, 0x75, 0x79, 0x7D, 0x77, 0x7E, 0x83, 0x88, 0x89,
	0x7F, 0x84, 0x84, 0x7F, 0x7D, 0x78, 0x7F, 0x82, 0x7F, 0x82, 0x80, 0x83,
	0x83, 0x7C, 0x7F, 0x7C, 0x80, 0x80, 0x7D, 0x81, 0x81, 0x81, 0x81, 0x7D,
	0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x81, 0x81, 0x86, 0x81, 0xB3, 0xE2, 0xC6,
	0x9D, 0x75, 0x7B, 0x7B, 0x5B, 0x5F, 0x75, 0x9C, 0xA7, 0x8D, 0x8B, 0x87,
	0x83, 0x74, 0x5F, 0x70, 0x80, 0x89, 0x8B, 0x82, 0x8E, 0x8A, 0x7E, 0x75,
	0x70, 0x7E, 0x7E, 0x7D, 0x83, 0x84, 0x8B, 0x84, 0x7B, 0x7C, 0x7A, 0x7F,
	0x7C, 0x7C, 0x84, 0x83, 0x85, 0x80, 0x7D, 0x80, 0x7D, 0x7E, 0x7D, 0x7D,
	0x83, 0x80, 0x82, 0x80, 0x7F, 0x81, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x80,
	0x7F, 0x81, 0x7E, 0x82, 0x7C, 0x89, 0xD1, 0xE2, 0xBC, 0x87, 0x6C, 0x7F,
	0x6D, 0x5A, 0x64, 0x85, 0xAE, 0xA1, 0x8C, 0x85, 0x80, 0x80, 0x66, 0x63,
	0x77, 0x86, 0x92, 0x85, 0x88, 0x8B, 0x84, 0x7C, 0x6C, 0x75, 0x7D, 0x82,
	0x84, 0x81, 0x89, 0x87, 0x80, 0x7B, 0x76, 0x7E, 0x7D, 0x7E, 0x81, 0x81,
	0x87, 0x82, 0x7F, 0x7D, 0x7C, 0x7F, 0x7D, 0x7D, 0x7E, 0x81, 0x83, 0x80,
	0x80, 0x7E, 0x80, 0x7F, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x7F, 0x81, 0x7E,
	0x82, 0x7C, 0x89, 0xD2, 0xE4, 0xC4, 0x7E, 0x5F, 0x75, 0x6F, 0x6E, 0x62,
	0x8B, 0xB2, 0xAF, 0x98, 0x75, 0x7D, 0x79, 0x70, 0x68, 0x6E, 0x90, 0x96,
	0x95, 0x84, 0x80, 0x85, 0x78, 0x74, 0x6C, 0x7D, 0x88, 0x89, 0x88, 0x80,
	0x87, 0x80, 0x7C, 0x74, 0x78, 0x80, 0x83, 0x89, 0x84, 0x87, 0x81, 0x7F,
	0x7B, 0x79, 0x7D, 0x7E, 0x83, 0x82, 0x83, 0x84, 0x80, 0x80, 0x7B, 0x7D,
	0x7D, 0x7F, 0x81, 0x80, 0x83, 0x80, 0x82, 0x7D, 0x80, 0x7C, 0x81, 0x7A,
	0x9B, 0xDB, 0xE6, 0xBE, 0x61, 0x4A, 0x5C, 0x83, 0x87, 0x79, 0x8E, 0xA4,
	0xB9, 0x94, 0x72, 0x5F, 0x6C, 0x7E, 0x7A, 0x7F, 0x83, 0x9A, 0x99, 0x8A,
	0x75, 0x6D, 0x78, 0x79, 0x7F, 0x7A, 0x87, 0x92, 0x94, 0x89, 0x76, 0x74,
	0x74, 0x7F, 0x7D, 0x80, 0x82, 0x88, 0x8B, 0x83, 0x7E, 0x76, 0x7B, 0x7D,
	0x80, 0x80, 0x81, 0x85, 0x84, 0x83, 0x7D, 0x7B, 0x7C, 0x7E, 0x80, 0x7F,
	0x82, 0x82, 0x85, 0x82, 0x80, 0x7B, 0x7D, 0x7D, 0x80, 0x80, 0x82, 0xB6,
	0xD9, 0xDC, 0x97, 0x55, 0x44, 0x62, 0x8E, 0x8E, 0x8B, 0x85, 0xA1, 0xA8,
	0x98, 0x71, 0x58, 0x66, 0x7A, 0x90, 0x88, 0x88, 0x87, 0x92, 0x8F, 0x7E,
	0x6F, 0x67, 0x78, 0x83, 0x8D, 0x86, 0x84, 0x83, 0x85, 0x83, 0x79, 0x75,
	0x74, 0x80, 0x85, 0x88, 0x83, 0x80, 0x81, 0x7F, 0x80, 0x7A, 0x7B, 0x7C,
	0x82, 0x84, 0x81, 0x81, 0x7D, 0x81, 0x7E, 0x80, 0x7C, 0x7E, 0x7E, 0x81,
	0x82, 0x80, 0x80, 0x7D, 0x80, 0x7E, 0x80, 0x7D, 0x81, 0x7C, 0xA3, 0xCA,
	0xDC, 0xB4, 0x6B, 0x45, 0x49, 0x7E, 0x94, 0x9B, 0x84, 0x88, 0x97, 0xA3,
	0x95, 0x6E, 0x5B, 0x5C, 0x7F, 0x92, 0x99, 0x89, 0x81, 0x82, 0x87, 0x86,
	0x76, 0x6E, 0x6D, 0x81, 0x8C, 0x92, 0x87, 0x7D, 0x7B, 0x7D, 0x82, 0x7B,
	0x7A, 0x78, 0x83, 0x8A, 0x8C, 0x84, 0x7B, 0x78, 0x7A, 0x81, 0x81, 0x80,
	0x7D, 0x80, 0x83, 0x85, 0x83, 0x7D, 0x7B, 0x7A, 0x80, 0x81, 0x82, 0x80,
	0x7F, 0x80, 0x81, 0x81, 0x7E, 0x7D, 0x7C, 0x84, 0x82, 0x99, 0xB5, 0xCD,
	0xBE, 0x8B, 0x59, 0x42, 0x5F, 0x83, 0xA2, 0x9A, 0x8F, 0x85, 0x8E, 0x92,
	0x87, 0x71, 0x5D, 0x66, 0x7C, 0x98, 0x9A, 0x91, 0x7C, 0x78, 0x7B, 0x81,
	0x7F, 0x76, 0x73, 0x79, 0x89, 0x90, 0x8F, 0x81, 0x76, 0x73, 0x7A, 0x82,
	0x83, 0x80, 0x7C, 0x7F, 0x83, 0x88, 0x84, 0x7D, 0x77, 0x78, 0x7E, 0x84,
	0x86, 0x81, 0x7E, 0x7D, 0x81, 0x81, 0x82, 0x7E, 0x7D, 0x7D, 0x81, 0x83,
	0x83, 0x80, 0x7D, 0x7D, 0x7F, 0x81, 0x82, 0x80, 0x7E, 0x98, 0xB6, 0xCE,
	0xB7, 0x86, 0x50, 0x43, 0x5D, 0x88, 0xA3, 0x9E, 0x8D, 0x7E, 0x86, 0x8C,
	0x8E, 0x77, 0x65, 0x5E, 0x73, 0x8F, 0xA0, 0x99, 0x82, 0x72, 0x6F, 0x7C,
	0x84, 0x84, 0x79, 0x75, 0x7A, 0x89, 0x91, 0x8D, 0x7E, 0x71, 0x70, 0x7A,
	0x86, 0x89, 0x84, 0x7B, 0x7A, 0x7F, 0x86, 0x87, 0x82, 0x7B, 0x78, 0x7C,
	0x83, 0x87, 0x84, 0x7E, 0x7A, 0x7C, 0x81, 0x84, 0x83, 0x7E, 0x7B, 0x7C,
	0x81, 0x83, 0x84, 0x7F, 0x7D, 0x7A, 0x80, 0x7F, 0x8B, 0xA0, 0xB9, 0xC2,
	0xA9, 0x80, 0x57, 0x4F, 0x60, 0x83, 0x96, 0x9A, 0x8C, 0x84, 0x84, 0x8A,
	0x88, 0x7A, 0x6B, 0x64, 0x72, 0x86, 0x99, 0x96, 0x8A, 0x77, 0x73, 0x77,
	0x81, 0x83, 0x7F, 0x78, 0x78, 0x82, 0x8A, 0x8F, 0x85, 0x7B, 0x71, 0x76,
	0x7D, 0x88, 0x87, 0x82, 0x7B, 0x7B, 0x80, 0x85, 0x86, 0x7F, 0x7A, 0x77,
	0x7D, 0x83, 0x88, 0x84, 0x7F, 0x7A, 0x7B, 0x80, 0x83, 0x83, 0x7F, 0x7C,
	0x7B, 0x81, 0x84, 0x87, 0x81, 0x7E, 0x78, 0x7E, 0x96, 0xB3, 0xC7, 0xB7,
	0x94, 0x66, 0x52, 0x57, 0x73, 0x8A, 0x94, 0x8E, 0x85, 0x86, 0x8B, 0x8F,
	0x83, 0x74, 0x64, 0x68, 0x78, 0x8E, 0x98, 0x93, 0x85, 0x79, 0x78, 0x7D,
	0x82, 0x80, 0x7A, 0x75, 0x79, 0x83, 0x8D, 0x8E, 0x85, 0x7A, 0x73, 0x76,
	0x7E, 0x86, 0x85, 0x81, 0x7B, 0x7C, 0x81, 0x86, 0x85, 0x7F, 0x79, 0x77,
	0x7C, 0x84, 0x8B, 0x8A, 0x83, 0x7C, 0x79, 0x7C, 0x80, 0x83, 0x81, 0x7E,
	0x7C, 0x7E, 0x82, 0x85, 0x85, 0x7D, 0x86, 0x99, 0xB6, 0xC1, 0xB3, 0x8C,
	0x63, 0x50, 0x58, 0x75, 0x8C, 0x96, 0x8D, 0x85, 0x82, 0x8A, 0x8E, 0x89,
	0x78, 0x68, 0x64, 0x71, 0x87, 0x96, 0x97, 0x88, 0x7A, 0x72, 0x78, 0x80,
	0x85, 0x81, 0x7A, 0x76, 0x7B, 0x86, 0x8D, 0x8C, 0x81, 0x77, 0x72, 0x78,
	0x81, 0x89, 0x88, 0x82, 0x7B, 0x7A, 0x7E, 0x84, 0x85, 0x82, 0x7B, 0x78,
	0x7A, 0x80, 0x86, 0x87, 0x83, 0x7C, 0x7A, 0x7B, 0x81, 0x83, 0x84, 0x7F,
	0x7D, 0x7B, 0x7F, 0x82, 0x86, 0x95, 0xA6, 0xB8, 0xB7, 0xA8, 0x86, 0x69,
	0x57, 0x5C, 0x6D, 0x82, 0x8E, 0x8E, 0x8B, 0x86, 0x87, 0x85, 0x84, 0x7A,
	0x72, 0x6B, 0x71, 0x7D, 0x8B, 0x92, 0x8E, 0x85, 0x7A, 0x77, 0x78, 0x7E,
	0x80, 0x80, 0x7C, 0x7C, 0x7E, 0x84, 0x88, 0x88, 0x83, 0x7C, 0x77, 0x77,
	0x7D, 0x81, 0x85, 0x83, 0x80, 0x7D, 0x7E, 0x80, 0x83, 0x83, 0x7F, 0x7C,
	0x7A, 0x7C, 0x7F, 0x83, 0x84, 0x82, 0x7F, 0x7D, 0x7E, 0x80, 0x82, 0x83,
	0x80, 0x7E, 0x7C, 0x80, 0x8D, 0xA0, 0xB1, 0xB4, 0xAA, 0x92, 0x7D, 0x6D,
	0x6C, 0x72, 0x7B, 0x80, 0x81, 0x80, 0x82, 0x88, 0x8C, 0x8D, 0x86, 0x7D,
	0x73, 0x72, 0x76, 0x80, 0x86, 0x88, 0x84, 0x7F, 0x7D, 0x7E, 0x82, 0x83,
	0x83, 0x7E, 0x7B, 0x79, 0x7C, 0x80, 0x84, 0x84, 0x82, 0x7E, 0x7C, 0x7D,
	0x7F, 0x82, 0x82, 0x80, 0x7D, 0x7D, 0x7D, 0x80, 0x82, 0x84, 0x82, 0x80,
	0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x81,
	0x81, 0x7E, 0x81, 0x88, 0x96, 0xA2, 0xA7, 0xA3, 0x96, 0x89, 0x7F, 0x7D,
	0x7F, 0x82, 0x80, 0x7D, 0x79, 0x79, 0x7C, 0x81, 0x85, 0x83, 0x80, 0x7B,
	0x7B, 0x7C, 0x80, 0x82, 0x82, 0x80, 0x7D, 0x7C, 0x7E, 0x81, 0x82, 0x82,
	0x80, 0x7E, 0x7D, 0x7E, 0x80, 0x82, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x81,
	0x82, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x85, 0x8C, 0x94, 0x95, 0x94, 0x8D, 0x88, 0x85, 0x85, 0x85,
	0x83, 0x81, 0x7C, 0x7B, 0x7B, 0x7E, 0x80, 0x80, 0x7F, 0x7D, 0x7D, 0x7E,
	0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x81, 0x84, 0x89, 0x8C, 0x8C, 0x8B, 0x88, 0x87, 0x87, 0x87, 0x86,
	0x84, 0x82, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x82, 0x85, 0x87, 0x87, 0x87, 0x87, 0x88, 0x89, 0x89, 0x88,
	0x87, 0x86, 0x85, 0x86, 0x86, 0x85, 0x83, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7B, 0x7B, 0x7C, 0x7C,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x83, 0x83, 0x84, 0x84,
	0x84, 0x84, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x84, 0x83, 0x83, 0x82,
	0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x80, 0x7F, 0x7D,
	0x7F, 0x81, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7E, 0x81, 0x81, 0x7E, 0x7F, 0x81, 0x81, 0x7F,
	0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F
};
const unsigned char WAV13[] = {
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x7E,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x80,
	0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7E,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7C, 0x7D, 0x7F, 0x7F, 0x81, 0x83, 0x83, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x83, 0x83, 0x80, 0x80, 0x80, 0x83, 0x84,
	0x7F, 0x82, 0x83, 0x81, 0x81, 0x82, 0x86, 0x82, 0x7F, 0x82, 0x7F, 0x7C,
	0x7C, 0x7F, 0x80, 0x7F, 0x7D, 0x7F, 0x7E, 0x7B, 0x7B, 0x7C, 0x77, 0x76,
	0x77, 0x79, 0x79, 0x7A, 0x7D, 0x84, 0x95, 0x96, 0x97, 0x9C, 0x99, 0x94,
	0x89, 0x82, 0x80, 0x76, 0x71, 0x72, 0x74, 0x77, 0x78, 0x7F, 0x85, 0x86,
	0x87, 0x88, 0x88, 0x85, 0x82, 0x81, 0x7F, 0x7D, 0x7B, 0x7C, 0x7D, 0x7D,
	0x7E, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x81, 0x82, 0x83,
	0x81, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x82,
	0xA2, 0xA6, 0x9D, 0xA7, 0xA8, 0x9F, 0x8E, 0x80, 0x7F, 0x75, 0x67, 0x69,
	0x6F, 0x75, 0x77, 0x7D, 0x89, 0x8F, 0x8D, 0x8C, 0x8D, 0x8A, 0x82, 0x7B,
	0x79, 0x78, 0x75, 0x74, 0x78, 0x7D, 0x80, 0x81, 0x84, 0x87, 0x87, 0x84,
	0x83, 0x82, 0x80, 0x7C, 0x7B, 0x7C, 0x7B, 0x7C, 0x7D, 0x7F, 0x82, 0x83,
	0x83, 0x84, 0x83, 0x83, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7E, 0x7E,
	0x80, 0x7F, 0x82, 0x80, 0x83, 0x7E, 0x99, 0xBE, 0xB0, 0x9F, 0xAF, 0xB3,
	0x91, 0x78, 0x74, 0x72, 0x64, 0x5D, 0x61, 0x70, 0x7D, 0x82, 0x85, 0x91,
	0x9A, 0x94, 0x88, 0x85, 0x85, 0x7B, 0x71, 0x6F, 0x74, 0x77, 0x78, 0x7A,
	0x82, 0x88, 0x8A, 0x86, 0x87, 0x87, 0x84, 0x7D, 0x7A, 0x7B, 0x7B, 0x79,
	0x79, 0x7D, 0x80, 0x82, 0x81, 0x83, 0x84, 0x84, 0x81, 0x7F, 0x7F, 0x7F,
	0x7D, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x81, 0x7F,
	0x86, 0xB2, 0xC3, 0xA4, 0x9A, 0xB8, 0xAF, 0x7D, 0x69, 0x75, 0x70, 0x5D,
	0x5F, 0x6C, 0x78, 0x85, 0x8F, 0x8B, 0x8F, 0x9B, 0x96, 0x80, 0x79, 0x80,
	0x7A, 0x6C, 0x6C, 0x76, 0x7B, 0x7D, 0x81, 0x86, 0x89, 0x8D, 0x88, 0x7B,
	0x78, 0x7E, 0x7C, 0x71, 0x72, 0x7C, 0x81, 0x7F, 0x80, 0x85, 0x88, 0x86,
	0x84, 0x81, 0x7F, 0x7F, 0x7E, 0x79, 0x79, 0x7D, 0x80, 0x7E, 0x7F, 0x82,
	0x84, 0x83, 0x81, 0x81, 0x80, 0x7D, 0x7A, 0x95, 0xC1, 0xC0, 0x98, 0x90,
	0xAB, 0xA1, 0x70, 0x59, 0x6A, 0x73, 0x69, 0x67, 0x75, 0x85, 0x92, 0x97,
	0x90, 0x89, 0x8E, 0x90, 0x7F, 0x6C, 0x70, 0x7A, 0x76, 0x70, 0x76, 0x84,
	0x8B, 0x8A, 0x88, 0x88, 0x87, 0x86, 0x80, 0x78, 0x75, 0x79, 0x7C, 0x7A,
	0x79, 0x7F, 0x86, 0x86, 0x84, 0x83, 0x84, 0x83, 0x7F, 0x7D, 0x7B, 0x7B,
	0x7D, 0x7D, 0x7D, 0x7E, 0x83, 0x8B, 0x8E, 0x8C, 0x91, 0x90, 0x7B, 0x69,
	0x72, 0x7E, 0x73, 0x66, 0x70, 0x7E, 0x7D, 0x7B, 0x88, 0x96, 0x9D, 0xA5,
	0xA8, 0x9B, 0x8C, 0x8B, 0x89, 0x6E, 0x61, 0x80, 0x97, 0x7D, 0x5F, 0x75,
	0x9E, 0xA0, 0x79, 0x66, 0x84, 0xA2, 0x91, 0x68, 0x60, 0x7F, 0x97, 0x8D,
	0x7C, 0x80, 0x93, 0x9A, 0x92, 0x85, 0x7F, 0x84, 0x8B, 0x85, 0x85, 0x93,
	0x97, 0x98, 0xA5, 0xBB, 0xBC, 0x9F, 0x84, 0x8B, 0x96, 0x7C, 0x53, 0x4C,
	0x6E, 0x88, 0x83, 0x81, 0x97, 0xA2, 0x9A, 0x94, 0x92, 0x82, 0x6D, 0x6C,
	0x74, 0x75, 0x76, 0x86, 0x92, 0x8F, 0x8D, 0x9B, 0x9D, 0x89, 0x7B, 0x82,
	0x7F, 0x6D, 0x6B, 0x77, 0x7E, 0x7A, 0x7A, 0x82, 0x8B, 0x8F, 0x8F, 0x8A,
	0x88, 0x88, 0x88, 0x83, 0x7C, 0x7C, 0x80, 0x81, 0x85, 0x8C, 0x8C, 0x8F,
	0x99, 0xA1, 0xA1, 0x9A, 0x94, 0x90, 0x89, 0x81, 0x7D, 0x7B, 0x7B, 0x7B,
	0x7B, 0x7E, 0x85, 0x8B, 0x8D, 0x8E, 0x8C, 0x89, 0x87, 0x87, 0x85, 0x7E,
	0x7B, 0x7D, 0x7E, 0x7D, 0x7E, 0x82, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x80,
	0x7E, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x80, 0x82, 0x82, 0x81, 0x82,
	0x84, 0x83, 0x81, 0x81, 0x82, 0x82, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x82, 0x81, 0x81, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x82, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7D, 0x7E,
	0x7E, 0x7F, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80,
	0x82, 0x82, 0x7F, 0x81, 0x82, 0x80, 0x80, 0x80, 0x7E, 0x7C, 0x7E, 0x7E,
	0x7D, 0x7E, 0x7F, 0x7E, 0x80, 0x81, 0x81, 0x82, 0x83, 0x81, 0x81, 0x81,
	0x80, 0x7E, 0x7E, 0x82, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7C, 0x7D, 0x7E, 0x7D, 0x7F, 0x7D, 0x7E, 0x80, 0x7D, 0x7B,
	0x7F, 0x80, 0x7D, 0x7F, 0x82, 0x7D, 0x7F, 0x82, 0x7E, 0x7E, 0x7F, 0x7E,
	0x7C, 0x7F, 0x7F, 0x7B, 0x82, 0x7F, 0x7C, 0x7F, 0x80, 0x7F, 0x7F, 0x82,
	0x7E, 0x7C, 0x7E, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x7E, 0x81, 0x80, 0x7E,
	0x7F, 0x7E, 0x7E, 0x7D, 0x80, 0x7C, 0x7F, 0x82, 0x7C, 0x7F, 0x80, 0x80,
	0x7F, 0x82, 0x80, 0x7E, 0x82, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7D, 0x7D,
	0x7F, 0x80, 0x7E, 0x81, 0x82, 0x7D, 0x80, 0x82, 0x7D, 0x7F, 0x7F, 0x7D,
	0x7D, 0x81, 0x7E, 0x7D, 0x84, 0x7C, 0x7E, 0x82, 0x7F, 0x7F, 0x81, 0x80,
	0x7D, 0x81, 0x80, 0x7D, 0x80, 0x82, 0x7E, 0x7E, 0x83, 0x7C, 0x7F, 0x80,
	0x7D, 0x80, 0x80, 0x80, 0x80, 0x82, 0x80, 0x82, 0x80, 0x7E, 0x81, 0x7E,
	0x7E, 0x82, 0x7E, 0x81, 0x81, 0x7D, 0x83, 0x7F, 0x7E, 0x7D, 0x81, 0x7E,
	0x7D, 0x82, 0x7E, 0x81, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7A,
	0x83, 0x81, 0x7D, 0x81, 0x80, 0x7C, 0x82, 0x80, 0x7C, 0x84, 0x7F, 0x81,
	0x83, 0x7E, 0x83, 0x80, 0x82, 0x82, 0x7F, 0x81, 0x7D, 0x81, 0x7E, 0x80,
	0x7F, 0x7E, 0x82, 0x7D, 0x82, 0x7E, 0x82, 0x80, 0x7F, 0x85, 0x7F, 0x82,
	0x81, 0x80, 0x7F, 0x81, 0x7F, 0x7F, 0x81, 0x7B, 0x7F, 0x7D, 0x7C, 0x7F,
	0x7E, 0x7E, 0x80, 0x81, 0x7F, 0x84, 0x81, 0x7F, 0x85, 0x80, 0x80, 0x83,
	0x80, 0x7C, 0x81, 0x7E, 0x7B, 0x82, 0x7D, 0x7F, 0x82, 0x7F, 0x82, 0x82,
	0x81, 0x83, 0x83, 0x82, 0x84, 0x84, 0x84, 0x86, 0x83, 0x83, 0x83, 0x83,
	0x82, 0x80, 0x82, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x81, 0x7F, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x80, 0x82, 0x82, 0x81, 0x84, 0x81, 0x85,
	0x88, 0x86, 0x8C, 0x8C, 0x8D, 0x8F, 0x8D, 0x8C, 0x8B, 0x88, 0x85, 0x83,
	0x80, 0x7F, 0x7D, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7E, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x7F, 0x83, 0x8A, 0x89, 0x95, 0x95, 0x99, 0x9E, 0x99, 0x9B, 0x95,
	0x8F, 0x8A, 0x83, 0x7E, 0x79, 0x75, 0x73, 0x72, 0x72, 0x74, 0x76, 0x78,
	0x7C, 0x7D, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7E, 0x80, 0x7F, 0x81, 0x7E, 0x88, 0x8F, 0x91, 0xA3, 0x9F, 0xA9,
	0xAA, 0xA2, 0xA5, 0x96, 0x90, 0x86, 0x7B, 0x75, 0x6E, 0x6B, 0x68, 0x6A,
	0x6A, 0x70, 0x74, 0x78, 0x80, 0x82, 0x87, 0x89, 0x8A, 0x8B, 0x89, 0x88,
	0x86, 0x83, 0x81, 0x7E, 0x7C, 0x7B, 0x79, 0x7A, 0x7A, 0x7B, 0x7D, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x83, 0x82, 0x83, 0x81, 0x81, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x92,
	0x8F, 0xA2, 0xA8, 0xA4, 0xB6, 0xA0, 0xA8, 0x99, 0x8B, 0x8A, 0x76, 0x75,
	0x6D, 0x68, 0x6B, 0x6B, 0x6F, 0x75, 0x79, 0x7E, 0x86, 0x87, 0x8C, 0x8D,
	0x8B, 0x8E, 0x87, 0x87, 0x83, 0x7E, 0x7E, 0x79, 0x79, 0x78, 0x78, 0x79,
	0x7A, 0x7C, 0x7E, 0x80, 0x81, 0x84, 0x83, 0x84, 0x84, 0x82, 0x82, 0x81,
	0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x81, 0x80, 0x82, 0x7F, 0x93, 0x91, 0xA0, 0xB0, 0xA2, 0xBA, 0xA1, 0xA5,
	0x9D, 0x84, 0x8C, 0x71, 0x73, 0x6C, 0x63, 0x6B, 0x67, 0x6E, 0x75, 0x78,
	0x80, 0x86, 0x88, 0x8E, 0x8F, 0x8C, 0x8F, 0x87, 0x87, 0x84, 0x7C, 0x7F,
	0x77, 0x78, 0x77, 0x76, 0x76, 0x77, 0x76, 0x78, 0x7B, 0x79, 0x81, 0x7E,
	0x83, 0x84, 0x82, 0x86, 0x82, 0x84, 0x83, 0x7F, 0x81, 0x7E, 0x7E, 0x7E,
	0x7C, 0x7D, 0x7D, 0x7C, 0x80, 0x7D, 0x81, 0x7F, 0x82, 0x7E, 0x8C, 0x9A,
	0x99, 0xBC, 0xA6, 0xBB, 0xAD, 0x9A, 0xA4, 0x7B, 0x86, 0x6F, 0x67, 0x6D,
	0x5E, 0x6A, 0x69, 0x6E, 0x79, 0x7C, 0x84, 0x8C, 0x8C, 0x91, 0x91, 0x8C,
	0x8F, 0x85, 0x84, 0x80, 0x7B, 0x7C, 0x79, 0x7B, 0x7A, 0x7C, 0x7C, 0x7F,
	0x80, 0x82, 0x84, 0x84, 0x85, 0x85, 0x83, 0x84, 0x80, 0x80, 0x7F, 0x7C,
	0x7F, 0x7A, 0x7E, 0x7C, 0x7D, 0x7F, 0x7E, 0x81, 0x80, 0x82, 0x80, 0x81,
	0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7F, 0x7A, 0x94, 0x94, 0xAA, 0xBA, 0xA9,
	0xC0, 0x9C, 0xA2, 0x94, 0x7D, 0x88, 0x6C, 0x72, 0x69, 0x64, 0x6B, 0x6B,
	0x73, 0x7F, 0x83, 0x8B, 0x94, 0x90, 0x9A, 0x92, 0x91, 0x90, 0x82, 0x83,
	0x78, 0x73, 0x74, 0x6C, 0x72, 0x72, 0x74, 0x7D, 0x7D, 0x84, 0x88, 0x89,
	0x8E, 0x8C, 0x8B, 0x8A, 0x84, 0x82, 0x7E, 0x78, 0x7A, 0x74, 0x75, 0x76,
	0x74, 0x7A, 0x7A, 0x7F, 0x83, 0x84, 0x87, 0x87, 0x87, 0x87, 0x84, 0x82,
	0x81, 0x7C, 0x7C, 0x79, 0x79, 0x93, 0x8F, 0xAF, 0xAF, 0xA9, 0xB7, 0x94,
	0xA3, 0x8D, 0x87, 0x89, 0x72, 0x77, 0x6A, 0x69, 0x6F, 0x74, 0x7B, 0x89,
	0x89, 0x91, 0x95, 0x90, 0x9B, 0x8F, 0x91, 0x8C, 0x7E, 0x80, 0x72, 0x72,
	0x72, 0x6F, 0x76, 0x76, 0x7A, 0x80, 0x83, 0x88, 0x8D, 0x8C, 0x91, 0x8E,
	0x8B, 0x8C, 0x81, 0x83, 0x7B, 0x78, 0x79, 0x73, 0x79, 0x76, 0x7A, 0x7F,
	0x80, 0x85, 0x87, 0x89, 0x89, 0x89, 0x86, 0x86, 0x81, 0x7F, 0x7D, 0x78,
	0x7B, 0x76, 0x7A, 0x78, 0x8E, 0x96, 0xA6, 0xB8, 0xA7, 0xB6, 0x99, 0x9A,
	0x93, 0x81, 0x8B, 0x72, 0x74, 0x68, 0x65, 0x6E, 0x73, 0x80, 0x89, 0x90,
	0x90, 0x97, 0x92, 0x97, 0x96, 0x8E, 0x8E, 0x7C, 0x7A, 0x70, 0x6D, 0x72,
	0x6F, 0x79, 0x78, 0x7E, 0x82, 0x86, 0x8C, 0x8F, 0x91, 0x8E, 0x8C, 0x83,
	0x81, 0x7B, 0x78, 0x78, 0x74, 0x76, 0x74, 0x78, 0x7B, 0x7F, 0x85, 0x87,
	0x8A, 0x89, 0x8A, 0x86, 0x88, 0x84, 0x84, 0x82, 0x7C, 0x7D, 0x77, 0x7A,
	0x7A, 0x7C, 0x80, 0x7F, 0x82, 0x99, 0x9A, 0xB2, 0xB4, 0xA9, 0xB0, 0x8E,
	0x95, 0x84, 0x7D, 0x81, 0x6E, 0x71, 0x69, 0x6A, 0x74, 0x7E, 0x87, 0x93,
	0x93, 0x94, 0x97, 0x8E, 0x94, 0x8B, 0x87, 0x83, 0x75, 0x74, 0x6D, 0x6F,
	0x74, 0x77, 0x7D, 0x81, 0x84, 0x88, 0x8B, 0x8C, 0x8F, 0x8C, 0x89, 0x84,
	0x7C, 0x7B, 0x76, 0x76, 0x78, 0x77, 0x7A, 0x7B, 0x7E, 0x83, 0x85, 0x88,
	0x89, 0x87, 0x88, 0x83, 0x81, 0x80, 0x7C, 0x7C, 0x79, 0x79, 0x7A, 0x79,
	0x7E, 0x7D, 0x83, 0x82, 0x86, 0x82, 0x8F, 0x9B, 0x9E, 0xB4, 0xA0, 0xA7,
	0x97, 0x8A, 0x91, 0x7C, 0x85, 0x75, 0x71, 0x71, 0x6E, 0x78, 0x7F, 0x87,
	0x8B, 0x90, 0x8D, 0x91, 0x8F, 0x8D, 0x8E, 0x82, 0x81, 0x78, 0x74, 0x76,
	0x72, 0x7A, 0x78, 0x7C, 0x7F, 0x82, 0x86, 0x89, 0x8A, 0x89, 0x88, 0x82,
	0x82, 0x7D, 0x7C, 0x7C, 0x78, 0x7A, 0x78, 0x7A, 0x7D, 0x7F, 0x82, 0x84,
	0x85, 0x85, 0x85, 0x84, 0x83, 0x81, 0x7F, 0x7E, 0x7B, 0x7B, 0x7A, 0x7B,
	0x7B, 0x7B, 0x7E, 0x7F, 0x81, 0x82, 0x82, 0x84, 0x80, 0x94, 0x97, 0xA2,
	0xAB, 0x97, 0xA0, 0x89, 0x8B, 0x89, 0x7C, 0x82, 0x71, 0x72, 0x71, 0x74,
	0x7D, 0x84, 0x88, 0x89, 0x8E, 0x8A, 0x91, 0x8D, 0x8A, 0x8A, 0x7B, 0x7E,
	0x76, 0x76, 0x79, 0x75, 0x7C, 0x7A, 0x7E, 0x81, 0x85, 0x88, 0x89, 0x89,
	0x85, 0x85, 0x80, 0x80, 0x7E, 0x7A, 0x7C, 0x77, 0x7A, 0x7B, 0x7C, 0x80,
	0x80, 0x82, 0x83, 0x84, 0x84, 0x84, 0x82, 0x81, 0x7F, 0x7D, 0x7D, 0x7C,
	0x7C, 0x7D, 0x7C, 0x7F, 0x7E, 0x81, 0x82, 0x82, 0x83, 0x81, 0x83, 0x7F,
	0x91, 0x96, 0x9F, 0xA8, 0x93, 0x9A, 0x87, 0x84, 0x89, 0x79, 0x7F, 0x72,
	0x6F, 0x74, 0x75, 0x80, 0x86, 0x88, 0x89, 0x8C, 0x89, 0x8D, 0x8D, 0x86,
	0x86, 0x7A, 0x79, 0x78, 0x74, 0x7B, 0x78, 0x7A, 0x7E, 0x7E, 0x85, 0x88,
	0x89, 0x8B, 0x87, 0x85, 0x83, 0x80, 0x7F, 0x7D, 0x79, 0x7A, 0x78, 0x79,
	0x7D, 0x7E, 0x82, 0x83, 0x83, 0x85, 0x85, 0x84, 0x84, 0x82, 0x7F, 0x7E,
	0x7B, 0x7C, 0x7C, 0x7B, 0x7D, 0x7E, 0x7F, 0x83, 0x82, 0x84, 0x84, 0x82,
	0x83, 0x81, 0x80, 0x81, 0x92, 0x94, 0x9F, 0xA3, 0x92, 0x9A, 0x8A, 0x88,
	0x8D, 0x7C, 0x7F, 0x75, 0x6F, 0x78, 0x77, 0x80, 0x85, 0x85, 0x88, 0x8A,
	0x8C, 0x8D, 0x8F, 0x88, 0x84, 0x80, 0x78, 0x7B, 0x79, 0x77, 0x7B, 0x77,
	0x7C, 0x80, 0x80, 0x87, 0x87, 0x86, 0x87, 0x84, 0x83, 0x82, 0x7F, 0x7D,
	0x7C, 0x79, 0x7A, 0x7B, 0x7B, 0x7F, 0x7F, 0x81, 0x83, 0x83, 0x84, 0x84,
	0x84, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x82, 0x82, 0x81, 0x82, 0x80, 0x90, 0x98, 0x9A, 0xA6,
	0x98, 0x95, 0x96, 0x8A, 0x8E, 0x87, 0x7C, 0x7A, 0x72, 0x72, 0x76, 0x79,
	0x7D, 0x7E, 0x82, 0x83, 0x88, 0x8D, 0x8C, 0x8D, 0x89, 0x84, 0x83, 0x7E,
	0x7D, 0x7D, 0x78, 0x78, 0x77, 0x78, 0x7B, 0x7C, 0x80, 0x81, 0x82, 0x84,
	0x84, 0x86, 0x86, 0x84, 0x84, 0x81, 0x7F, 0x7F, 0x7D, 0x7D, 0x7C, 0x7B,
	0x7C, 0x7C, 0x7D, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x83, 0x82, 0x84, 0x84,
	0x83, 0x83, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E,
	0x7E, 0x8B, 0x96, 0x97, 0x9F, 0x9B, 0x95, 0x98, 0x93, 0x92, 0x8E, 0x85,
	0x7F, 0x77, 0x75, 0x75, 0x74, 0x78, 0x77, 0x78, 0x7D, 0x7E, 0x85, 0x89,
	0x8B, 0x8D, 0x8A, 0x8A, 0x8A, 0x87, 0x87, 0x83, 0x7F, 0x7C, 0x79, 0x79,
	0x79, 0x78, 0x7A, 0x7A, 0x7B, 0x7D, 0x7F, 0x83, 0x84, 0x85, 0x86, 0x85,
	0x86, 0x85, 0x84, 0x83, 0x81, 0x7F, 0x7E, 0x7C, 0x7C, 0x7C, 0x7B, 0x7C,
	0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82,
	0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x88, 0x90, 0x91, 0x95, 0x94, 0x92,
	0x94, 0x93, 0x94, 0x91, 0x8A, 0x86, 0x80, 0x7D, 0x7D, 0x7B, 0x7A, 0x79,
	0x77, 0x7A, 0x7C, 0x80, 0x83, 0x84, 0x86, 0x87, 0x88, 0x8A, 0x8A, 0x89,
	0x87, 0x84, 0x82, 0x7F, 0x7E, 0x7D, 0x7B, 0x7A, 0x79, 0x7A, 0x7B, 0x7C,
	0x7E, 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81,
	0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x80,
	0x81, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x88,
	0x8F, 0x8F, 0x92, 0x90, 0x8F, 0x90, 0x8F, 0x90, 0x8D, 0x87, 0x84, 0x7F,
	0x7D, 0x7D, 0x7B, 0x7B, 0x79, 0x78, 0x7A, 0x7C, 0x80, 0x82, 0x84, 0x85,
	0x86, 0x87, 0x88, 0x88, 0x88, 0x86, 0x84, 0x82, 0x80, 0x7F, 0x7E, 0x7C,
	0x7B, 0x7A, 0x7A, 0x7B, 0x7C, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x84, 0x85,
	0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C,
	0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x85, 0x8A, 0x8A, 0x8D, 0x8D, 0x8B, 0x8C, 0x8C,
	0x8D, 0x8B, 0x88, 0x86, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7D, 0x7D, 0x7D,
	0x7E, 0x80, 0x82, 0x83, 0x84, 0x84, 0x86, 0x86, 0x87, 0x87, 0x86, 0x85,
	0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82,
	0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x84, 0x88, 0x89,
	0x8A, 0x8B, 0x8A, 0x8A, 0x8A, 0x8B, 0x8A, 0x88, 0x87, 0x85, 0x83, 0x83,
	0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x82,
	0x83, 0x84, 0x85, 0x85, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x82,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x82, 0x85, 0x86, 0x87, 0x88, 0x88, 0x89, 0x8A, 0x8B, 0x8A,
	0x89, 0x89, 0x87, 0x86, 0x86, 0x86, 0x84, 0x83, 0x82, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x83,
	0x83, 0x85, 0x86, 0x87, 0x86, 0x86, 0x85, 0x85, 0x87, 0x87, 0x86, 0x85,
	0x85, 0x84, 0x84, 0x85, 0x85, 0x84, 0x83, 0x83, 0x82, 0x82, 0x83, 0x83,
	0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7B,
	0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7A, 0x7B, 0x7B, 0x7A,
	0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B,
	0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80
};
const unsigned char WAV14[] = {
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x82,
	0x7E, 0x7E, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F,
	0x81, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x81, 0x81, 0x7D, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x81,
	0x81, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x81, 0x7D, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x81,
	0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x7F,
	0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x82, 0x80, 0x7F,
	0x7D, 0x7F, 0x81, 0x81, 0x7E, 0x7D, 0x7F, 0x81, 0x81, 0x80, 0x7C, 0x7D,
	0x81, 0x82, 0x80, 0x7C, 0x7D, 0x80, 0x82, 0x81, 0x7F, 0x7E, 0x80, 0x81,
	0x80, 0x81, 0x7E, 0x7D, 0x81, 0x81, 0x7F, 0x7F, 0x7E, 0x7C, 0x7F, 0x82,
	0x80, 0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x80, 0x7D, 0x7B, 0x7F, 0x82,
	0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x82, 0x80, 0x7D, 0x80, 0x80, 0x7E,
	0x80, 0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x82, 0x80, 0x80, 0x81, 0x81, 0x82,
	0x83, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7F,
	0x7D, 0x7D, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D, 0x7D, 0x7F, 0x80, 0x81,
	0x7F, 0x7C, 0x7B, 0x7C, 0x7D, 0x7C, 0x7B, 0x7B, 0x7C, 0x7E, 0x7F, 0x81,
	0x82, 0x83, 0x82, 0x84, 0x84, 0x82, 0x83, 0x83, 0x81, 0x80, 0x7F, 0x7C,
	0x7C, 0x7D, 0x7D, 0x81, 0x8B, 0x91, 0x95, 0x96, 0x90, 0x88, 0x82, 0x7C,
	0x79, 0x79, 0x7A, 0x7B, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x87, 0x93, 0xA1, 0xAD, 0xB3, 0xAE, 0xA1,
	0x8E, 0x79, 0x69, 0x62, 0x61, 0x67, 0x70, 0x78, 0x7E, 0x82, 0x83, 0x85,
	0x87, 0x88, 0x89, 0x89, 0x86, 0x81, 0x7C, 0x78, 0x76, 0x77, 0x7A, 0x7E,
	0x82, 0x83, 0x84, 0x83, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7D,
	0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x86, 0x92, 0xA0, 0xB0, 0xBC,
	0xBC, 0xB2, 0x9E, 0x84, 0x6B, 0x59, 0x51, 0x52, 0x5D, 0x69, 0x75, 0x7F,
	0x85, 0x88, 0x8B, 0x8B, 0x8B, 0x8B, 0x88, 0x84, 0x80, 0x7B, 0x78, 0x78,
	0x7A, 0x7D, 0x82, 0x84, 0x85, 0x85, 0x82, 0x7F, 0x7D, 0x7C, 0x7C, 0x7D,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x81, 0x80, 0x7E,
	0x7D, 0x7C, 0x7C, 0x7D, 0x7F, 0x80, 0x82, 0x82, 0x82, 0x82, 0x8A, 0x98,
	0xA8, 0xB8, 0xC1, 0xBC, 0xAC, 0x93, 0x75, 0x5D, 0x4F, 0x4B, 0x52, 0x60,
	0x6D, 0x79, 0x83, 0x87, 0x8A, 0x8D, 0x8D, 0x8D, 0x8D, 0x89, 0x83, 0x7E,
	0x79, 0x77, 0x78, 0x7C, 0x7F, 0x83, 0x85, 0x83, 0x81, 0x7F, 0x7C, 0x7C,
	0x7C, 0x7D, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x8B, 0x9D, 0xB0, 0xC2, 0xCA, 0xBF, 0xA8, 0x89, 0x67, 0x4E, 0x44,
	0x46, 0x52, 0x65, 0x76, 0x82, 0x8C, 0x92, 0x94, 0x96, 0x95, 0x90, 0x8A,
	0x82, 0x78, 0x72, 0x70, 0x72, 0x78, 0x7F, 0x84, 0x86, 0x86, 0x83, 0x80,
	0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x82, 0x85, 0x87,
	0x88, 0x86, 0x82, 0x7E, 0x7B, 0x79, 0x7A, 0x7C, 0x7D, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x82, 0x82, 0x8A, 0x9E, 0xB4, 0xC6, 0xD0, 0xC5, 0xA7, 0x84,
	0x62, 0x48, 0x41, 0x48, 0x54, 0x64, 0x74, 0x7F, 0x88, 0x94, 0x9C, 0x9F,
	0x9F, 0x96, 0x87, 0x7A, 0x70, 0x6A, 0x6D, 0x74, 0x7A, 0x7F, 0x83, 0x83,
	0x83, 0x84, 0x85, 0x85, 0x85, 0x82, 0x7D, 0x7A, 0x79, 0x79, 0x7B, 0x7E,
	0x80, 0x80, 0x81, 0x81, 0x80, 0x82, 0x83, 0x82, 0x81, 0x80, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x87, 0x9F, 0xBC, 0xCE,
	0xD3, 0xC2, 0x9C, 0x76, 0x5D, 0x4E, 0x4D, 0x57, 0x5E, 0x62, 0x6C, 0x7B,
	0x8A, 0x9C, 0xA7, 0xA3, 0x95, 0x85, 0x76, 0x6F, 0x72, 0x77, 0x79, 0x7A,
	0x79, 0x79, 0x7E, 0x86, 0x8C, 0x8C, 0x89, 0x81, 0x7A, 0x7B, 0x7F, 0x82,
	0x83, 0x81, 0x7C, 0x7A, 0x7D, 0x81, 0x84, 0x85, 0x81, 0x7C, 0x7B, 0x7D,
	0x80, 0x82, 0x83, 0x80, 0x7D, 0x7C, 0x7E, 0x81, 0x83, 0x83, 0x7F, 0x7D,
	0x7C, 0x8A, 0xAF, 0xD0, 0xD7, 0xC8, 0xA9, 0x82, 0x69, 0x65, 0x63, 0x5B,
	0x56, 0x54, 0x5A, 0x73, 0x92, 0xA3, 0xA3, 0x9A, 0x8A, 0x7F, 0x81, 0x85,
	0x7F, 0x75, 0x6C, 0x68, 0x70, 0x82, 0x8E, 0x8E, 0x89, 0x83, 0x81, 0x86,
	0x8A, 0x85, 0x7A, 0x72, 0x71, 0x77, 0x81, 0x86, 0x83, 0x7E, 0x7D, 0x80,
	0x86, 0x89, 0x85, 0x7D, 0x78, 0x79, 0x7D, 0x82, 0x83, 0x7F, 0x7B, 0x7C,
	0x80, 0x85, 0x85, 0x81, 0x7C, 0x7C, 0x7E, 0x91, 0xBB, 0xD8, 0xCC, 0xB1,
	0x9B, 0x86, 0x7B, 0x7A, 0x6B, 0x51, 0x4A, 0x5A, 0x71, 0x89, 0x98, 0x94,
	0x8B, 0x90, 0x99, 0x97, 0x8C, 0x7B, 0x68, 0x63, 0x70, 0x79, 0x77, 0x75,
	0x79, 0x81, 0x8F, 0x97, 0x91, 0x84, 0x7E, 0x7F, 0x80, 0x7F, 0x78, 0x70,
	0x70, 0x7A, 0x83, 0x85, 0x84, 0x81, 0x81, 0x87, 0x8A, 0x86, 0x7D, 0x79,
	0x79, 0x7C, 0x7E, 0x7C, 0x78, 0x7A, 0x80, 0x85, 0x85, 0x83, 0x80, 0x80,
	0x83, 0x82, 0x8A, 0xAD, 0xC7, 0xB9, 0xA1, 0x98, 0x92, 0x89, 0x81, 0x6F,
	0x58, 0x5A, 0x6F, 0x7C, 0x7F, 0x83, 0x87, 0x8D, 0x9C, 0xA0, 0x8E, 0x7F,
	0x7F, 0x7F, 0x78, 0x73, 0x6D, 0x6C, 0x77, 0x84, 0x84, 0x81, 0x86, 0x8C,
	0x8D, 0x8B, 0x84, 0x7B, 0x7A, 0x7D, 0x7B, 0x76, 0x76, 0x7A, 0x7E, 0x83,
	0x85, 0x83, 0x83, 0x86, 0x86, 0x81, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7B,
	0x7B, 0x80, 0x82, 0x81, 0x81, 0x83, 0x83, 0x83, 0x80, 0x88, 0xAC, 0xC2,
	0xAA, 0x91, 0x9E, 0xA5, 0x8F, 0x78, 0x6C, 0x67, 0x6E, 0x75, 0x6B, 0x69,
	0x84, 0x96, 0x8C, 0x89, 0x94, 0x96, 0x8D, 0x86, 0x7D, 0x75, 0x78, 0x78,
	0x6E, 0x6E, 0x7C, 0x82, 0x7F, 0x83, 0x8A, 0x8B, 0x8A, 0x88, 0x83, 0x7E,
	0x80, 0x7D, 0x75, 0x77, 0x7D, 0x7B, 0x7A, 0x80, 0x84, 0x83, 0x84, 0x86,
	0x84, 0x82, 0x83, 0x80, 0x7C, 0x7D, 0x7D, 0x7B, 0x7B, 0x7E, 0x7F, 0x7F,
	0x81, 0x82, 0x82, 0x82, 0x81, 0x8D, 0xB1, 0xB7, 0x97, 0x9C, 0xC0, 0xAB,
	0x79, 0x81, 0x97, 0x79, 0x5C, 0x70, 0x7D, 0x70, 0x72, 0x82, 0x86, 0x8A,
	0x91, 0x8D, 0x8A, 0x92, 0x8D, 0x7B, 0x7B, 0x83, 0x78, 0x6D, 0x77, 0x7E,
	0x77, 0x79, 0x85, 0x88, 0x84, 0x88, 0x8C, 0x88, 0x85, 0x85, 0x82, 0x7F,
	0x7E, 0x7C, 0x79, 0x7B, 0x7C, 0x7B, 0x7C, 0x81, 0x81, 0x80, 0x83, 0x85,
	0x82, 0x81, 0x82, 0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7F, 0x82, 0x8F, 0x94, 0x8D, 0x93, 0x9F, 0x96, 0x8A, 0x91, 0x93, 0x82,
	0x7C, 0x85, 0x7F, 0x74, 0x78, 0x7F, 0x7A, 0x78, 0x80, 0x82, 0x80, 0x82,
	0x85, 0x84, 0x83, 0x82, 0x7E, 0x7D, 0x7E, 0x79, 0x74, 0x75, 0x75, 0x71,
	0x71, 0x75, 0x76, 0x76, 0x7B, 0x7E, 0x80, 0x84, 0x85, 0x86, 0x8B, 0x8B,
	0x86, 0x89, 0x89, 0x80, 0x7E, 0x82, 0x7C, 0x77, 0x7D, 0x7E, 0x79, 0x7B,
	0x80, 0x7E, 0x7B, 0x80, 0x81, 0x7C, 0x7D, 0x80, 0x7D, 0x7A, 0x7C, 0x7D,
	0x7A, 0x79, 0x7C, 0x7C, 0x79, 0x7B, 0x7C, 0x7A, 0x79, 0x7B, 0x7B, 0x7A,
	0x7B, 0x7B, 0x7A, 0x7A, 0x7B, 0x7A, 0x7B, 0x7C, 0x7C, 0x7C, 0x7E, 0x7E,
	0x7E, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83,
	0x82, 0x82, 0x83, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x7E,
	0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x7F, 0x7E, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x7D,
	0x80, 0x81, 0x80, 0x83, 0x83, 0x81, 0x81, 0x82, 0x7F, 0x81, 0x7F, 0x7F,
	0x7E, 0x7D, 0x7E, 0x7F, 0x7C, 0x7D, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x7E,
	0x81, 0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x82, 0x7F, 0x81, 0x80, 0x80, 0x7F,
	0x7E, 0x82, 0x7F, 0x82, 0x83, 0x81, 0x81, 0x83, 0x7F, 0x80, 0x80, 0x7E,
	0x7F, 0x7D, 0x7D, 0x7F, 0x7C, 0x7C, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x80,
	0x82, 0x7F, 0x81, 0x81, 0x7F, 0x83, 0x82, 0x7D, 0x84, 0x81, 0x7F, 0x86,
	0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x7D, 0x83, 0x7E, 0x80, 0x7E,
	0x81, 0x80, 0x7D, 0x7F, 0x7E, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x7E, 0x80,
	0x80, 0x7F, 0x7E, 0x81, 0x7F, 0x7D, 0x82, 0x80, 0x7E, 0x81, 0x7F, 0x7D,
	0x82, 0x7F, 0x7F, 0x83, 0x7F, 0x7D, 0x84, 0x7D, 0x7E, 0x83, 0x7C, 0x81,
	0x81, 0x7E, 0x80, 0x83, 0x7E, 0x80, 0x82, 0x7E, 0x7F, 0x82, 0x7C, 0x7E,
	0x83, 0x7E, 0x7F, 0x83, 0x80, 0x7F, 0x84, 0x80, 0x7D, 0x84, 0x7F, 0x7B,
	0x81, 0x7F, 0x7C, 0x81, 0x7F, 0x7C, 0x82, 0x7F, 0x7D, 0x82, 0x7E, 0x7F,
	0x81, 0x80, 0x7F, 0x82, 0x7E, 0x7F, 0x81, 0x7E, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x7F, 0x82,
	0x7F, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7C, 0x81, 0x7F, 0x7D, 0x82,
	0x80, 0x7E, 0x82, 0x82, 0x7E, 0x82, 0x81, 0x7D, 0x81, 0x80, 0x7D, 0x7F,
	0x82, 0x7C, 0x83, 0x82, 0x7D, 0x83, 0x80, 0x7B, 0x81, 0x80, 0x7A, 0x83,
	0x7F, 0x7E, 0x83, 0x80, 0x80, 0x83, 0x7F, 0x7F, 0x84, 0x7E, 0x80, 0x81,
	0x7F, 0x7E, 0x82, 0x7E, 0x7D, 0x83, 0x7C, 0x7E, 0x7F, 0x7C, 0x7E, 0x7F,
	0x7C, 0x7E, 0x80, 0x7B, 0x81, 0x80, 0x7D, 0x81, 0x7F, 0x7E, 0x7F, 0x80,
	0x7C, 0x80, 0x80, 0x7B, 0x81, 0x7E, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x82,
	0x80, 0x83, 0x82, 0x81, 0x84, 0x83, 0x82, 0x83, 0x82, 0x80, 0x83, 0x80,
	0x82, 0x81, 0x80, 0x81, 0x7E, 0x7E, 0x7F, 0x7F, 0x7D, 0x81, 0x7E, 0x7E,
	0x80, 0x7C, 0x7F, 0x7E, 0x7C, 0x7D, 0x7E, 0x7D, 0x80, 0x80, 0x80, 0x83,
	0x81, 0x82, 0x83, 0x87, 0x86, 0x8A, 0x8D, 0x8B, 0x8F, 0x8D, 0x8D, 0x8B,
	0x89, 0x86, 0x84, 0x81, 0x7F, 0x7E, 0x7B, 0x7C, 0x7B, 0x7B, 0x7C, 0x7C,
	0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x82, 0x8A, 0x89, 0x95, 0x96,
	0x99, 0x9F, 0x99, 0x9B, 0x95, 0x8F, 0x8B, 0x83, 0x7E, 0x79, 0x75, 0x72,
	0x72, 0x71, 0x73, 0x75, 0x76, 0x7A, 0x7B, 0x7D, 0x80, 0x80, 0x83, 0x82,
	0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x7F,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E,
	0x85, 0x8E, 0x8E, 0xA1, 0x9F, 0xA7, 0xAB, 0xA1, 0xA6, 0x97, 0x91, 0x89,
	0x7B, 0x77, 0x6F, 0x6B, 0x6B, 0x6A, 0x6D, 0x73, 0x76, 0x7C, 0x82, 0x84,
	0x89, 0x8A, 0x8A, 0x8B, 0x88, 0x87, 0x83, 0x81, 0x7F, 0x7C, 0x7B, 0x7A,
	0x7A, 0x7A, 0x7B, 0x7C, 0x7D, 0x7F, 0x80, 0x82, 0x82, 0x83, 0x84, 0x84,
	0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7D,
	0x7E, 0x7F, 0x80, 0x80, 0x81, 0x7F, 0x90, 0x90, 0x9C, 0xAB, 0xA0, 0xB5,
	0xA3, 0xA5, 0xA2, 0x8B, 0x91, 0x7A, 0x77, 0x73, 0x67, 0x6E, 0x69, 0x6C,
	0x73, 0x74, 0x7D, 0x82, 0x85, 0x8A, 0x8C, 0x8B, 0x8F, 0x89, 0x88, 0x86,
	0x7F, 0x81, 0x7A, 0x79, 0x7A, 0x75, 0x7A, 0x78, 0x79, 0x7D, 0x7A, 0x80,
	0x7F, 0x81, 0x83, 0x81, 0x84, 0x82, 0x82, 0x82, 0x80, 0x80, 0x80, 0x7E,
	0x7F, 0x7D, 0x7E, 0x7D, 0x7E, 0x7D, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x82,
	0x80, 0x97, 0x8F, 0xA9, 0xAA, 0xA5, 0xB8, 0x97, 0xA8, 0x8E, 0x84, 0x85,
	0x6A, 0x75, 0x66, 0x67, 0x6C, 0x68, 0x73, 0x77, 0x7C, 0x84, 0x88, 0x8A,
	0x90, 0x8D, 0x8D, 0x8D, 0x85, 0x86, 0x80, 0x7C, 0x7C, 0x75, 0x78, 0x78,
	0x75, 0x7D, 0x78, 0x7F, 0x80, 0x7F, 0x86, 0x82, 0x86, 0x84, 0x84, 0x84,
	0x81, 0x81, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7D, 0x80, 0x7D,
	0x82, 0x7E, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x82, 0x9B, 0x91, 0xB8,
	0xAB, 0xB2, 0xBA, 0x95, 0xAC, 0x81, 0x85, 0x7A, 0x64, 0x72, 0x5E, 0x68,
	0x6A, 0x6A, 0x77, 0x7A, 0x81, 0x8A, 0x8C, 0x8F, 0x94, 0x8C, 0x90, 0x89,
	0x82, 0x84, 0x76, 0x7B, 0x73, 0x72, 0x76, 0x72, 0x7A, 0x7A, 0x7D, 0x82,
	0x83, 0x87, 0x88, 0x88, 0x87, 0x86, 0x83, 0x83, 0x7E, 0x7E, 0x7C, 0x78,
	0x7C, 0x77, 0x79, 0x79, 0x76, 0x7C, 0x7A, 0x7E, 0x82, 0x7F, 0x86, 0x81,
	0x85, 0x82, 0x82, 0x81, 0x82, 0x7C, 0x89, 0x97, 0x98, 0xBB, 0xA5, 0xB8,
	0xA9, 0x96, 0xA2, 0x7C, 0x8B, 0x77, 0x70, 0x73, 0x62, 0x6D, 0x6A, 0x72,
	0x7C, 0x84, 0x8A, 0x92, 0x92, 0x94, 0x97, 0x8D, 0x92, 0x85, 0x82, 0x7D,
	0x72, 0x76, 0x6D, 0x71, 0x73, 0x74, 0x7B, 0x7E, 0x82, 0x88, 0x89, 0x8C,
	0x8D, 0x8A, 0x8D, 0x87, 0x86, 0x82, 0x7C, 0x7C, 0x76, 0x78, 0x77, 0x78,
	0x7B, 0x7C, 0x7F, 0x82, 0x84, 0x86, 0x87, 0x87, 0x87, 0x85, 0x82, 0x82,
	0x7C, 0x7E, 0x7A, 0x7A, 0x7A, 0x7C, 0x96, 0x94, 0xB4, 0xAE, 0xAD, 0xB1,
	0x92, 0xA1, 0x88, 0x8A, 0x85, 0x71, 0x75, 0x64, 0x69, 0x6D, 0x76, 0x80,
	0x8A, 0x8D, 0x91, 0x95, 0x91, 0x9B, 0x90, 0x92, 0x89, 0x7D, 0x7C, 0x6E,
	0x72, 0x6F, 0x71, 0x76, 0x76, 0x7C, 0x81, 0x86, 0x8B, 0x90, 0x8F, 0x90,
	0x8A, 0x86, 0x83, 0x7C, 0x7C, 0x77, 0x75, 0x75, 0x73, 0x77, 0x79, 0x7D,
	0x83, 0x85, 0x88, 0x89, 0x89, 0x88, 0x87, 0x83, 0x83, 0x7D, 0x7C, 0x79,
	0x76, 0x79, 0x77, 0x7C, 0x7C, 0x7F, 0x82, 0x99, 0x9C, 0xB4, 0xB6, 0xAB,
	0xB2, 0x8F, 0x98, 0x84, 0x7F, 0x81, 0x6C, 0x72, 0x65, 0x69, 0x72, 0x7A,
	0x88, 0x91, 0x94, 0x96, 0x98, 0x91, 0x97, 0x8D, 0x8A, 0x85, 0x74, 0x76,
	0x6A, 0x6E, 0x72, 0x72, 0x7D, 0x7D, 0x83, 0x88, 0x8A, 0x8F, 0x90, 0x8F,
	0x8C, 0x86, 0x7F, 0x7D, 0x76, 0x76, 0x76, 0x73, 0x79, 0x77, 0x7D, 0x80,
	0x83, 0x8A, 0x89, 0x8A, 0x8A, 0x85, 0x85, 0x80, 0x7F, 0x7D, 0x78, 0x79,
	0x77, 0x78, 0x7B, 0x7C, 0x80, 0x82, 0x84, 0x84, 0x88, 0x9C, 0x9C, 0xB2,
	0xAD, 0xA4, 0xA4, 0x87, 0x90, 0x7E, 0x7E, 0x7D, 0x6E, 0x74, 0x6B, 0x73,
	0x7B, 0x84, 0x8D, 0x92, 0x92, 0x91, 0x92, 0x8B, 0x90, 0x86, 0x83, 0x7D,
	0x72, 0x75, 0x6E, 0x75, 0x79, 0x7A, 0x82, 0x80, 0x87, 0x88, 0x8B, 0x8D,
	0x8A, 0x88, 0x82, 0x7F, 0x7A, 0x7A, 0x78, 0x78, 0x78, 0x78, 0x7C, 0x7D,
	0x81, 0x84, 0x85, 0x88, 0x85, 0x86, 0x84, 0x82, 0x81, 0x7E, 0x7C, 0x7A,
	0x7A, 0x79, 0x7D, 0x7E, 0x81, 0x83, 0x82, 0x85, 0x83, 0x86, 0x83, 0x84,
	0x98, 0x94, 0xA8, 0xA3, 0x99, 0x9E, 0x85, 0x91, 0x84, 0x80, 0x81, 0x71,
	0x76, 0x71, 0x77, 0x7E, 0x84, 0x87, 0x8B, 0x8A, 0x8A, 0x8E, 0x87, 0x8C,
	0x83, 0x7E, 0x7D, 0x73, 0x7A, 0x77, 0x79, 0x7D, 0x7A, 0x80, 0x81, 0x84,
	0x88, 0x88, 0x87, 0x86, 0x82, 0x81, 0x80, 0x7C, 0x7D, 0x79, 0x7A, 0x7A,
	0x7B, 0x7E, 0x7F, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x81, 0x81, 0x7F,
	0x7E, 0x7D, 0x7C, 0x7D, 0x7C, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82,
	0x81, 0x83, 0x7E, 0x8F, 0x96, 0x9D, 0xAB, 0x97, 0xA1, 0x8F, 0x8C, 0x90,
	0x7E, 0x84, 0x74, 0x72, 0x73, 0x73, 0x7D, 0x81, 0x86, 0x87, 0x8B, 0x8A,
	0x8F, 0x8F, 0x89, 0x8B, 0x7E, 0x7E, 0x79, 0x75, 0x7B, 0x75, 0x7A, 0x7A,
	0x7C, 0x82, 0x84, 0x88, 0x89, 0x88, 0x86, 0x84, 0x82, 0x80, 0x7F, 0x7B,
	0x7B, 0x79, 0x78, 0x7C, 0x7C, 0x80, 0x81, 0x82, 0x84, 0x83, 0x85, 0x84,
	0x83, 0x81, 0x7F, 0x7E, 0x7C, 0x7C, 0x7B, 0x7D, 0x7E, 0x80, 0x83, 0x83,
	0x84, 0x85, 0x83, 0x85, 0x81, 0x82, 0x7E, 0x89, 0x95, 0x96, 0xA8, 0x97,
	0x99, 0x94, 0x85, 0x91, 0x81, 0x80, 0x7B, 0x6F, 0x76, 0x74, 0x7B, 0x82,
	0x84, 0x87, 0x8A, 0x8C, 0x8C, 0x91, 0x8A, 0x88, 0x83, 0x79, 0x7D, 0x76,
	0x78, 0x7A, 0x77, 0x7C, 0x7D, 0x80, 0x86, 0x87, 0x88, 0x88, 0x85, 0x84,
	0x83, 0x7F, 0x7E, 0x7C, 0x78, 0x7A, 0x79, 0x7B, 0x80, 0x7F, 0x83, 0x84,
	0x83, 0x86, 0x84, 0x84, 0x83, 0x80, 0x7F, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C,
	0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x83, 0x83, 0x82, 0x82, 0x81, 0x80, 0x80,
	0x93, 0x95, 0x9E, 0xA6, 0x94, 0x9B, 0x90, 0x88, 0x90, 0x7F, 0x7D, 0x78,
	0x6D, 0x75, 0x76, 0x7B, 0x82, 0x83, 0x84, 0x88, 0x8C, 0x8C, 0x8F, 0x8A,
	0x85, 0x83, 0x7B, 0x7B, 0x7C, 0x76, 0x7A, 0x78, 0x79, 0x7F, 0x80, 0x85,
	0x86, 0x87, 0x87, 0x86, 0x86, 0x84, 0x83, 0x80, 0x7C, 0x7C, 0x7A, 0x7A,
	0x7C, 0x7B, 0x7D, 0x7E, 0x7F, 0x82, 0x83, 0x84, 0x84, 0x83, 0x83, 0x81,
	0x80, 0x7F, 0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x82, 0x93, 0x98, 0x9C, 0xA4, 0x96, 0x95, 0x94,
	0x8B, 0x8E, 0x85, 0x7C, 0x78, 0x71, 0x73, 0x75, 0x79, 0x7D, 0x7D, 0x82,
	0x83, 0x87, 0x8E, 0x8D, 0x8E, 0x8C, 0x87, 0x86, 0x83, 0x81, 0x7F, 0x7B,
	0x79, 0x77, 0x77, 0x79, 0x7A, 0x7D, 0x7E, 0x7F, 0x82, 0x83, 0x85, 0x86,
	0x86, 0x86, 0x83, 0x82, 0x81, 0x7F, 0x7F, 0x7C, 0x7B, 0x7B, 0x7A, 0x7B,
	0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x82, 0x81,
	0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x86, 0x92,
	0x93, 0x99, 0x99, 0x95, 0x96, 0x95, 0x94, 0x91, 0x8A, 0x85, 0x7D, 0x79,
	0x79, 0x77, 0x78, 0x77, 0x76, 0x79, 0x7B, 0x80, 0x85, 0x86, 0x89, 0x89,
	0x89, 0x8A, 0x8A, 0x8B, 0x88, 0x85, 0x82, 0x7F, 0x7D, 0x7D, 0x7B, 0x7A,
	0x79, 0x79, 0x7A, 0x7C, 0x7E, 0x80, 0x81, 0x83, 0x83, 0x84, 0x85, 0x86,
	0x85, 0x84, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7F, 0x80, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81,
	0x80, 0x80, 0x7E, 0x82, 0x8D, 0x90, 0x91, 0x94, 0x90, 0x90, 0x91, 0x91,
	0x91, 0x8B, 0x87, 0x83, 0x7E, 0x7F, 0x7D, 0x7C, 0x7B, 0x79, 0x7A, 0x7C,
	0x7F, 0x83, 0x84, 0x85, 0x86, 0x86, 0x88, 0x88, 0x88, 0x87, 0x84, 0x82,
	0x81, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7E, 0x80, 0x81, 0x83,
	0x83, 0x84, 0x85, 0x86, 0x86, 0x86, 0x84, 0x83, 0x81, 0x80, 0x80, 0x7E,
	0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x82,
	0x83, 0x83, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x87, 0x8B, 0x8C,
	0x8F, 0x8E, 0x8D, 0x8F, 0x8F, 0x8F, 0x8C, 0x89, 0x85, 0x81, 0x80, 0x7F,
	0x7D, 0x7C, 0x7A, 0x7A, 0x7B, 0x7D, 0x7F, 0x81, 0x83, 0x83, 0x85, 0x86,
	0x87, 0x88, 0x88, 0x86, 0x85, 0x83, 0x82, 0x81, 0x7F, 0x7E, 0x7C, 0x7C,
	0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x84, 0x84, 0x84,
	0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x86, 0x8A, 0x8A, 0x8C, 0x8C, 0x8B, 0x8B, 0x8C, 0x8C, 0x8A,
	0x88, 0x86, 0x83, 0x82, 0x82, 0x81, 0x80, 0x7E, 0x7E, 0x7D, 0x7E, 0x80,
	0x81, 0x82, 0x82, 0x83, 0x84, 0x85, 0x86, 0x86, 0x86, 0x85, 0x85, 0x84,
	0x83, 0x83, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x83, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x84, 0x86, 0x87, 0x89, 0x89,
	0x8A, 0x8A, 0x8B, 0x8C, 0x8A, 0x89, 0x88, 0x87, 0x85, 0x84, 0x84, 0x82,
	0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x83, 0x85, 0x85, 0x86, 0x87, 0x87, 0x87, 0x88, 0x87, 0x87, 0x88, 0x87,
	0x86, 0x85, 0x84, 0x83, 0x81, 0x81, 0x81, 0x7F, 0x7D, 0x7D, 0x7C, 0x7C,
	0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7B, 0x7C,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7C,
	0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x82,
	0x83, 0x84, 0x84, 0x83, 0x83, 0x83, 0x84, 0x83, 0x84, 0x84, 0x83, 0x83,
	0x82, 0x83, 0x83, 0x83, 0x84, 0x84, 0x85, 0x85, 0x85, 0x84, 0x84, 0x84,
	0x83, 0x83, 0x84, 0x84, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80
};
const unsigned char WAV15[] = {
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x7F,
	0x80, 0x7F, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x81,
	0x81, 0x80, 0x83, 0x82, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7D,
	0x7D, 0x80, 0x7E, 0x7C, 0x7F, 0x81, 0x80, 0x7E, 0x81, 0x83, 0x80, 0x81,
	0x82, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x82, 0x80, 0x7E, 0x81, 0x80, 0x80, 0x83, 0x80, 0x80,
	0x84, 0x82, 0x80, 0x82, 0x82, 0x83, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x81, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x82, 0x83,
	0x80, 0x7E, 0x7F, 0x7F, 0x7D, 0x7D, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F,
	0x7E, 0x7F, 0x80, 0x88, 0x90, 0x8C, 0x8F, 0x92, 0x8E, 0x89, 0x83, 0x81,
	0x7F, 0x78, 0x77, 0x7A, 0x7B, 0x7C, 0x7D, 0x81, 0x83, 0x82, 0x83, 0x84,
	0x83, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80,
	0x81, 0x7F, 0x80, 0x7F, 0x81, 0x7E, 0x8D, 0xA5, 0x9C, 0x9F, 0xAA, 0xA2,
	0x97, 0x88, 0x80, 0x7D, 0x6C, 0x67, 0x6F, 0x70, 0x73, 0x78, 0x81, 0x8A,
	0x88, 0x88, 0x8C, 0x88, 0x82, 0x7D, 0x7C, 0x7B, 0x77, 0x77, 0x7C, 0x7D,
	0x7D, 0x81, 0x84, 0x85, 0x83, 0x83, 0x83, 0x81, 0x7E, 0x7E, 0x7E, 0x7D,
	0x7C, 0x7D, 0x7F, 0x7F, 0x7F, 0x81, 0x82, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7D, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x81, 0x7F, 0x86, 0xA8, 0xA6,
	0xA2, 0xB4, 0xAD, 0xA0, 0x8E, 0x81, 0x7E, 0x67, 0x5E, 0x68, 0x68, 0x6C,
	0x73, 0x80, 0x8D, 0x89, 0x8D, 0x93, 0x8C, 0x85, 0x80, 0x7F, 0x7C, 0x74,
	0x77, 0x7C, 0x7A, 0x7C, 0x81, 0x85, 0x84, 0x82, 0x85, 0x84, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7C, 0x7B, 0x7F, 0x7F, 0x7E, 0x81, 0x83, 0x82, 0x81, 0x81,
	0x82, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7F, 0x7F, 0x7F, 0x7F, 0x81,
	0x80, 0x96, 0xA4, 0x9C, 0xA8, 0xAD, 0xA4, 0x98, 0x89, 0x85, 0x79, 0x68,
	0x6B, 0x6C, 0x6B, 0x71, 0x75, 0x81, 0x85, 0x82, 0x88, 0x89, 0x85, 0x82,
	0x7D, 0x7E, 0x7C, 0x77, 0x7B, 0x7D, 0x7E, 0x80, 0x80, 0x84, 0x84, 0x81,
	0x82, 0x81, 0x80, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D, 0x7C, 0x7D, 0x7E, 0x7E,
	0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x94, 0x9D, 0x9B, 0xA2, 0xA5, 0xA2, 0x98,
	0x8B, 0x88, 0x84, 0x79, 0x75, 0x77, 0x7A, 0x7C, 0x7C, 0x82, 0x88, 0x87,
	0x87, 0x87, 0x86, 0x84, 0x7F, 0x7D, 0x7D, 0x7B, 0x7A, 0x7B, 0x7D, 0x7F,
	0x7F, 0x80, 0x82, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x86, 0x8F, 0x8F,
	0x91, 0x94, 0x96, 0x94, 0x90, 0x8E, 0x8D, 0x8A, 0x86, 0x85, 0x84, 0x83,
	0x82, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7B, 0x7B, 0x7A,
	0x7C, 0x7B, 0x7A, 0x7A, 0x7B, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x82,
	0x82, 0x83, 0x84, 0x84, 0x84, 0x85, 0x85, 0x84, 0x84, 0x84, 0x83, 0x82,
	0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81,
	0x81, 0x81, 0x81, 0x82, 0x82, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x83, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7D, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x7F, 0x80, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x81, 0x82, 0x81, 0x82,
	0x80, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x81, 0x82,
	0x83, 0x81, 0x81, 0x81, 0x81, 0x80, 0x82, 0x81, 0x81, 0x81, 0x7F, 0x7F,
	0x7E, 0x80, 0x7E, 0x7D, 0x80, 0x7D, 0x7E, 0x82, 0x80, 0x80, 0x83, 0x83,
	0x80, 0x82, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x81, 0x81, 0x82, 0x80,
	0x81, 0x80, 0x80, 0x82, 0x83, 0x82, 0x83, 0x7F, 0x7D, 0x7F, 0x80, 0x82,
	0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x82, 0x81, 0x81, 0x80, 0x7D, 0x81,
	0x7F, 0x7D, 0x7C, 0x7D, 0x7F, 0x7E, 0x80, 0x80, 0x81, 0x7E, 0x80, 0x81,
	0x80, 0x7E, 0x80, 0x81, 0x7C, 0x80, 0x81, 0x7E, 0x80, 0x81, 0x7C, 0x81,
	0x81, 0x7E, 0x81, 0x81, 0x7F, 0x7F, 0x83, 0x7E, 0x81, 0x84, 0x7F, 0x80,
	0x83, 0x7E, 0x80, 0x82, 0x7D, 0x7F, 0x7F, 0x7C, 0x7F, 0x7E, 0x7C, 0x7F,
	0x80, 0x7D, 0x7F, 0x82, 0x7D, 0x80, 0x82, 0x7D, 0x7E, 0x82, 0x7D, 0x7E,
	0x80, 0x7C, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7D, 0x80, 0x82, 0x7E, 0x7F,
	0x80, 0x80, 0x7D, 0x81, 0x81, 0x7E, 0x80, 0x80, 0x7D, 0x81, 0x81, 0x7D,
	0x82, 0x81, 0x7F, 0x82, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7E, 0x81, 0x7E,
	0x7E, 0x82, 0x7F, 0x7F, 0x83, 0x80, 0x7F, 0x82, 0x80, 0x7E, 0x81, 0x7F,
	0x7D, 0x80, 0x81, 0x7E, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x82,
	0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x83, 0x7E, 0x7E, 0x82,
	0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x80, 0x82,
	0x80, 0x80, 0x84, 0x7F, 0x82, 0x82, 0x7E, 0x81, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80,
	0x7E, 0x81, 0x80, 0x7D, 0x81, 0x7D, 0x7E, 0x80, 0x7F, 0x80, 0x83, 0x82,
	0x83, 0x85, 0x83, 0x85, 0x84, 0x81, 0x84, 0x82, 0x81, 0x82, 0x7F, 0x7F,
	0x7E, 0x7C, 0x7D, 0x7D, 0x7B, 0x7A, 0x7A, 0x7B, 0x7A, 0x7C, 0x7C, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D, 0x7C, 0x7D, 0x82, 0x82, 0x86,
	0x8B, 0x8A, 0x8F, 0x8E, 0x8E, 0x8E, 0x8B, 0x88, 0x86, 0x83, 0x80, 0x7F,
	0x7C, 0x7C, 0x7A, 0x7A, 0x7B, 0x7B, 0x7C, 0x7E, 0x7E, 0x7F, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x7F,
	0x84, 0x89, 0x89, 0x95, 0x94, 0x9A, 0x9D, 0x98, 0x9A, 0x93, 0x8F, 0x89,
	0x82, 0x7D, 0x78, 0x74, 0x73, 0x72, 0x72, 0x74, 0x76, 0x79, 0x7C, 0x7E,
	0x81, 0x82, 0x83, 0x84, 0x83, 0x83, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7F,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x83, 0x8F, 0x8D, 0x9F, 0xA0, 0xA4, 0xAD, 0xA0,
	0xA6, 0x99, 0x91, 0x8A, 0x7C, 0x78, 0x6F, 0x6A, 0x69, 0x69, 0x6A, 0x70,
	0x73, 0x79, 0x7F, 0x82, 0x88, 0x89, 0x8A, 0x8C, 0x89, 0x89, 0x85, 0x82,
	0x81, 0x7D, 0x7C, 0x7A, 0x7A, 0x7A, 0x7B, 0x7B, 0x7D, 0x7E, 0x7F, 0x81,
	0x81, 0x82, 0x83, 0x82, 0x83, 0x82, 0x81, 0x82, 0x80, 0x80, 0x7F, 0x7E,
	0x7F, 0x7E, 0x7D, 0x80, 0x7C, 0x81, 0x7D, 0x81, 0x7E, 0x87, 0x93, 0x91,
	0xAB, 0xA0, 0xAE, 0xAE, 0x9F, 0xA8, 0x8E, 0x8E, 0x81, 0x73, 0x74, 0x66,
	0x69, 0x69, 0x69, 0x70, 0x74, 0x7A, 0x81, 0x85, 0x89, 0x8E, 0x8C, 0x8E,
	0x8C, 0x87, 0x88, 0x80, 0x7F, 0x7C, 0x78, 0x7A, 0x76, 0x78, 0x7A, 0x79,
	0x7E, 0x7D, 0x80, 0x82, 0x81, 0x84, 0x83, 0x83, 0x84, 0x81, 0x82, 0x80,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7F, 0x7E, 0x80, 0x7F, 0x81,
	0x7F, 0x82, 0x7E, 0x92, 0x91, 0xA0, 0xAF, 0xA1, 0xB9, 0xA0, 0xA3, 0x9B,
	0x82, 0x89, 0x70, 0x70, 0x6C, 0x62, 0x6C, 0x68, 0x6E, 0x77, 0x78, 0x82,
	0x87, 0x88, 0x8F, 0x8D, 0x8D, 0x8E, 0x86, 0x88, 0x81, 0x7D, 0x7D, 0x77,
	0x78, 0x78, 0x76, 0x7C, 0x7B, 0x7F, 0x82, 0x81, 0x86, 0x84, 0x85, 0x85,
	0x83, 0x83, 0x81, 0x7F, 0x7F, 0x7D, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7E,
	0x7E, 0x81, 0x7F, 0x82, 0x80, 0x81, 0x82, 0x7F, 0x82, 0x7F, 0x9A, 0x91,
	0xB1, 0xAF, 0xAA, 0xBE, 0x95, 0xA9, 0x87, 0x80, 0x7F, 0x63, 0x72, 0x61,
	0x66, 0x6B, 0x6A, 0x76, 0x7A, 0x80, 0x88, 0x8C, 0x8D, 0x91, 0x8D, 0x8C,
	0x8B, 0x82, 0x83, 0x7B, 0x78, 0x78, 0x71, 0x76, 0x75, 0x76, 0x7D, 0x7B,
	0x82, 0x83, 0x84, 0x89, 0x86, 0x87, 0x87, 0x82, 0x83, 0x7F, 0x7E, 0x7D,
	0x7B, 0x7A, 0x7C, 0x79, 0x7E, 0x7D, 0x7F, 0x80, 0x7C, 0x81, 0x79, 0x7F,
	0x7B, 0x7C, 0x7F, 0x7B, 0x81, 0x7C, 0x81, 0x99, 0x96, 0xB5, 0xB5, 0xAF,
	0xBC, 0x97, 0xA3, 0x88, 0x80, 0x81, 0x69, 0x71, 0x65, 0x65, 0x6C, 0x6C,
	0x77, 0x81, 0x83, 0x90, 0x91, 0x91, 0x97, 0x8D, 0x90, 0x89, 0x81, 0x81,
	0x74, 0x74, 0x71, 0x6D, 0x74, 0x72, 0x78, 0x7E, 0x7F, 0x87, 0x88, 0x8A,
	0x8D, 0x8A, 0x8A, 0x88, 0x81, 0x81, 0x7B, 0x79, 0x7A, 0x74, 0x7A, 0x77,
	0x7B, 0x7E, 0x7F, 0x84, 0x84, 0x87, 0x87, 0x87, 0x85, 0x85, 0x80, 0x82,
	0x7C, 0x7D, 0x7A, 0x7B, 0x77, 0x88, 0x95, 0x9E, 0xBB, 0xA8, 0xBA, 0xA4,
	0x9A, 0x9D, 0x83, 0x8D, 0x79, 0x73, 0x6F, 0x64, 0x6A, 0x6F, 0x76, 0x84,
	0x8A, 0x8D, 0x96, 0x92, 0x97, 0x98, 0x8F, 0x92, 0x84, 0x7F, 0x79, 0x6E,
	0x72, 0x6E, 0x71, 0x76, 0x76, 0x7E, 0x82, 0x86, 0x8E, 0x8D, 0x91, 0x8E,
	0x8A, 0x87, 0x81, 0x7D, 0x7A, 0x76, 0x75, 0x74, 0x73, 0x78, 0x79, 0x7E,
	0x84, 0x84, 0x8A, 0x87, 0x8A, 0x89, 0x86, 0x85, 0x80, 0x7E, 0x7B, 0x79,
	0x77, 0x78, 0x76, 0x7B, 0x79, 0x93, 0x97, 0xAD, 0xB8, 0xA9, 0xB6, 0x96,
	0x9B, 0x8E, 0x81, 0x86, 0x6F, 0x71, 0x66, 0x65, 0x6D, 0x76, 0x81, 0x8C,
	0x92, 0x92, 0x9A, 0x91, 0x9A, 0x93, 0x8E, 0x8B, 0x77, 0x78, 0x69, 0x6C,
	0x6E, 0x6E, 0x78, 0x78, 0x7F, 0x83, 0x89, 0x8E, 0x91, 0x92, 0x8E, 0x8B,
	0x82, 0x80, 0x78, 0x77, 0x75, 0x73, 0x75, 0x73, 0x78, 0x7B, 0x81, 0x85,
	0x89, 0x8B, 0x8B, 0x89, 0x88, 0x85, 0x83, 0x7F, 0x7C, 0x79, 0x76, 0x76,
	0x77, 0x79, 0x7D, 0x7E, 0x84, 0x81, 0x8E, 0x9F, 0xA1, 0xBB, 0xAA, 0xAD,
	0xA0, 0x89, 0x90, 0x79, 0x80, 0x76, 0x6E, 0x70, 0x68, 0x72, 0x79, 0x84,
	0x8F, 0x95, 0x94, 0x95, 0x92, 0x8E, 0x90, 0x86, 0x85, 0x7A, 0x72, 0x72,
	0x6B, 0x74, 0x75, 0x7B, 0x81, 0x82, 0x87, 0x89, 0x8C, 0x8E, 0x8D, 0x8A,
	0x86, 0x7F, 0x7B, 0x79, 0x76, 0x78, 0x77, 0x78, 0x7B, 0x7C, 0x81, 0x84,
	0x86, 0x89, 0x87, 0x87, 0x85, 0x82, 0x81, 0x7E, 0x7D, 0x7A, 0x7A, 0x78,
	0x7B, 0x7A, 0x7F, 0x80, 0x82, 0x84, 0x83, 0x85, 0x85, 0x9A, 0x97, 0xAC,
	0xA6, 0x9B, 0x9F, 0x84, 0x90, 0x80, 0x80, 0x7F, 0x6F, 0x75, 0x6E, 0x77,
	0x7E, 0x86, 0x8A, 0x8E, 0x8D, 0x8C, 0x91, 0x8A, 0x8F, 0x85, 0x7F, 0x7D,
	0x72, 0x78, 0x73, 0x78, 0x7B, 0x7A, 0x80, 0x81, 0x86, 0x88, 0x8A, 0x89,
	0x88, 0x84, 0x81, 0x80, 0x7C, 0x7D, 0x79, 0x79, 0x79, 0x79, 0x7D, 0x7F,
	0x82, 0x83, 0x84, 0x85, 0x84, 0x85, 0x82, 0x83, 0x81, 0x7F, 0x80, 0x7C,
	0x7E, 0x7D, 0x7D, 0x7F, 0x7E, 0x81, 0x81, 0x81, 0x83, 0x81, 0x84, 0x7F,
	0x90, 0x96, 0x9E, 0xAB, 0x98, 0xA0, 0x8E, 0x8A, 0x8D, 0x7D, 0x83, 0x74,
	0x71, 0x72, 0x73, 0x7C, 0x82, 0x87, 0x89, 0x8C, 0x8A, 0x8F, 0x8E, 0x8A,
	0x8A, 0x7E, 0x7D, 0x77, 0x76, 0x79, 0x76, 0x7A, 0x7A, 0x7C, 0x82, 0x84,
	0x88, 0x89, 0x88, 0x86, 0x84, 0x81, 0x80, 0x7E, 0x7C, 0x7C, 0x7A, 0x7B,
	0x7C, 0x7D, 0x81, 0x81, 0x83, 0x84, 0x83, 0x85, 0x83, 0x82, 0x81, 0x7F,
	0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x7D, 0x7F, 0x7F, 0x81, 0x82, 0x82, 0x82,
	0x83, 0x80, 0x81, 0x7C, 0x89, 0x95, 0x97, 0xA8, 0x97, 0x98, 0x93, 0x85,
	0x90, 0x81, 0x7F, 0x7B, 0x6E, 0x75, 0x74, 0x7B, 0x83, 0x84, 0x87, 0x89,
	0x8A, 0x8C, 0x90, 0x89, 0x88, 0x81, 0x79, 0x7C, 0x75, 0x78, 0x79, 0x75,
	0x7D, 0x7B, 0x81, 0x85, 0x85, 0x89, 0x87, 0x86, 0x84, 0x82, 0x80, 0x7E,
	0x7C, 0x79, 0x7A, 0x79, 0x7B, 0x7E, 0x7E, 0x82, 0x82, 0x83, 0x85, 0x83,
	0x85, 0x82, 0x80, 0x7F, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F,
	0x81, 0x82, 0x82, 0x83, 0x81, 0x83, 0x80, 0x81, 0x7E, 0x8B, 0x96, 0x98,
	0xA8, 0x98, 0x97, 0x95, 0x85, 0x8F, 0x83, 0x7C, 0x7C, 0x6D, 0x73, 0x75,
	0x79, 0x81, 0x82, 0x85, 0x86, 0x8B, 0x8C, 0x8D, 0x8D, 0x85, 0x84, 0x7D,
	0x7A, 0x7C, 0x77, 0x79, 0x79, 0x77, 0x7C, 0x7E, 0x82, 0x86, 0x86, 0x86,
	0x86, 0x85, 0x80, 0x80, 0x7C, 0x78, 0x7A, 0x76, 0x78, 0x7A, 0x79, 0x7D,
	0x7E, 0x80, 0x83, 0x83, 0x85, 0x84, 0x84, 0x82, 0x81, 0x80, 0x7D, 0x7D,
	0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x82, 0x83, 0x82,
	0x83, 0x81, 0x85, 0x96, 0x97, 0x9F, 0xA1, 0x93, 0x96, 0x90, 0x8B, 0x8D,
	0x82, 0x7C, 0x76, 0x72, 0x74, 0x76, 0x7B, 0x7C, 0x7E, 0x82, 0x83, 0x89,
	0x8C, 0x8B, 0x8F, 0x8B, 0x89, 0x89, 0x84, 0x84, 0x80, 0x7C, 0x7B, 0x78,
	0x79, 0x79, 0x7A, 0x7D, 0x7C, 0x7F, 0x81, 0x82, 0x85, 0x85, 0x85, 0x85,
	0x84, 0x83, 0x82, 0x80, 0x7F, 0x7D, 0x7D, 0x7B, 0x7C, 0x7E, 0x7D, 0x7F,
	0x80, 0x80, 0x82, 0x82, 0x83, 0x84, 0x83, 0x83, 0x82, 0x81, 0x81, 0x7F,
	0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x82, 0x90, 0x96, 0x9A,
	0x9F, 0x98, 0x97, 0x96, 0x93, 0x93, 0x8D, 0x85, 0x7F, 0x77, 0x77, 0x76,
	0x76, 0x78, 0x76, 0x77, 0x7B, 0x7E, 0x85, 0x88, 0x8A, 0x8B, 0x8A, 0x8B,
	0x8A, 0x89, 0x88, 0x84, 0x80, 0x7D, 0x7A, 0x7A, 0x79, 0x78, 0x78, 0x77,
	0x79, 0x7B, 0x7E, 0x81, 0x82, 0x83, 0x85, 0x85, 0x86, 0x86, 0x85, 0x84,
	0x82, 0x80, 0x7F, 0x7D, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x80, 0x80,
	0x7F, 0x7E, 0x7F, 0x8A, 0x90, 0x90, 0x95, 0x92, 0x91, 0x92, 0x91, 0x92,
	0x8E, 0x87, 0x84, 0x7E, 0x7D, 0x7D, 0x7B, 0x7A, 0x78, 0x78, 0x7B, 0x7D,
	0x82, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x89, 0x88, 0x85, 0x83, 0x81,
	0x7F, 0x7E, 0x7D, 0x7B, 0x7A, 0x7A, 0x7A, 0x7C, 0x7D, 0x7F, 0x80, 0x81,
	0x82, 0x83, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E,
	0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x89, 0x8E, 0x8E,
	0x92, 0x90, 0x8F, 0x90, 0x90, 0x91, 0x8D, 0x88, 0x85, 0x80, 0x7F, 0x7E,
	0x7D, 0x7B, 0x79, 0x79, 0x7B, 0x7D, 0x80, 0x82, 0x83, 0x84, 0x85, 0x87,
	0x88, 0x88, 0x88, 0x86, 0x84, 0x83, 0x81, 0x80, 0x7F, 0x7D, 0x7C, 0x7B,
	0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x82, 0x83, 0x84, 0x84, 0x84,
	0x83, 0x83, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x80, 0x80, 0x84, 0x8A, 0x8A, 0x8D, 0x8D, 0x8C, 0x8D, 0x8D, 0x8E,
	0x8C, 0x89, 0x87, 0x83, 0x81, 0x80, 0x7F, 0x7E, 0x7C, 0x7C, 0x7B, 0x7D,
	0x7F, 0x80, 0x82, 0x82, 0x84, 0x85, 0x86, 0x88, 0x88, 0x87, 0x86, 0x85,
	0x84, 0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82,
	0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x85, 0x88, 0x89,
	0x8A, 0x8A, 0x8A, 0x8A, 0x8B, 0x8C, 0x8A, 0x88, 0x87, 0x85, 0x84, 0x83,
	0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82,
	0x83, 0x84, 0x84, 0x85, 0x85, 0x85, 0x85, 0x84, 0x84, 0x84, 0x83, 0x82,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x81, 0x85, 0x86, 0x87, 0x88, 0x88, 0x89, 0x89, 0x8B,
	0x8A, 0x89, 0x88, 0x87, 0x87, 0x86, 0x86, 0x85, 0x83, 0x83, 0x82, 0x82,
	0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x82, 0x83, 0x83, 0x83, 0x85, 0x86, 0x87, 0x88, 0x89, 0x88,
	0x87, 0x88, 0x88, 0x88, 0x87, 0x87, 0x87, 0x86, 0x85, 0x85, 0x85, 0x85,
	0x86, 0x87, 0x87, 0x88, 0x88, 0x89, 0x89, 0x89, 0x89, 0x88, 0x87, 0x86,
	0x86, 0x84, 0x83, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B,
	0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F
};
const unsigned char WAV16[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80,
	0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x81, 0x7E, 0x7F,
	0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x7E,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80,
	0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x82, 0x80, 0x7E,
	0x80, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81,
	0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F,
	0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x82, 0x7F,
	0x7F, 0x82, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7D, 0x81, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x7C, 0x82, 0x7F, 0x7E, 0x7D, 0x7F, 0x82, 0x7C, 0x81, 0x82,
	0x7F, 0x7E, 0x80, 0x82, 0x7D, 0x7E, 0x82, 0x7F, 0x7C, 0x81, 0x83, 0x7D,
	0x7E, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x82, 0x7F, 0x7F, 0x80,
	0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x7E, 0x7E, 0x81, 0x7F, 0x7F,
	0x7D, 0x80, 0x81, 0x7D, 0x81, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x7E,
	0x81, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x81,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7E, 0x80, 0x80, 0x7F,
	0x80, 0x82, 0x81, 0x81, 0x83, 0x81, 0x7F, 0x84, 0x82, 0x81, 0x84, 0x84,
	0x86, 0x84, 0x85, 0x87, 0x84, 0x83, 0x86, 0x85, 0x85, 0x84, 0x84, 0x83,
	0x80, 0x82, 0x80, 0x7C, 0x7F, 0x7D, 0x7B, 0x7E, 0x7E, 0x7F, 0x81, 0x83,
	0x84, 0x84, 0x85, 0x84, 0x82, 0x81, 0x80, 0x7F, 0x7C, 0x86, 0x8D, 0x89,
	0x91, 0x95, 0x90, 0x8D, 0x8B, 0x89, 0x7F, 0x7B, 0x7C, 0x77, 0x75, 0x78,
	0x7B, 0x7C, 0x7E, 0x83, 0x84, 0x83, 0x85, 0x86, 0x83, 0x81, 0x81, 0x7F,
	0x7C, 0x7C, 0x7D, 0x7C, 0x7D, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x81, 0x81,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80,
	0x7F, 0x82, 0x9C, 0x9A, 0x96, 0xAD, 0xA3, 0x96, 0x93, 0x8C, 0x7E, 0x6E,
	0x73, 0x70, 0x65, 0x71, 0x79, 0x78, 0x7E, 0x88, 0x8E, 0x87, 0x8C, 0x90,
	0x82, 0x80, 0x83, 0x7B, 0x76, 0x7A, 0x7D, 0x78, 0x7B, 0x83, 0x80, 0x7F,
	0x86, 0x84, 0x7F, 0x81, 0x82, 0x7E, 0x7C, 0x80, 0x7E, 0x7B, 0x80, 0x80,
	0x7E, 0x80, 0x83, 0x81, 0x7F, 0x83, 0x81, 0x7E, 0x81, 0x80, 0x7E, 0x7E,
	0x80, 0x7F, 0x7E, 0x80, 0x82, 0x7B, 0x91, 0xA8, 0x91, 0xAB, 0xB8, 0x96,
	0x9A, 0x98, 0x7E, 0x6E, 0x70, 0x6D, 0x5D, 0x6A, 0x77, 0x6E, 0x7B, 0x89,
	0x84, 0x84, 0x8C, 0x88, 0x7E, 0x82, 0x82, 0x78, 0x7C, 0x81, 0x7B, 0x7D,
	0x84, 0x82, 0x80, 0x84, 0x83, 0x7F, 0x7F, 0x81, 0x7C, 0x7C, 0x80, 0x7D,
	0x7C, 0x81, 0x82, 0x7E, 0x83, 0x84, 0x7F, 0x82, 0x82, 0x7D, 0x7F, 0x80,
	0x7D, 0x7D, 0x80, 0x7E, 0x7E, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x9D,
	0x97, 0x94, 0xB7, 0xA1, 0x96, 0xA8, 0x8B, 0x7A, 0x7F, 0x6F, 0x61, 0x67,
	0x6B, 0x65, 0x70, 0x7E, 0x79, 0x81, 0x8C, 0x84, 0x85, 0x8A, 0x81, 0x7D,
	0x80, 0x7C, 0x79, 0x7E, 0x7F, 0x7D, 0x82, 0x86, 0x82, 0x84, 0x86, 0x81,
	0x80, 0x81, 0x7D, 0x7B, 0x7E, 0x7C, 0x7B, 0x7F, 0x7F, 0x7E, 0x82, 0x82,
	0x80, 0x82, 0x82, 0x7F, 0x80, 0x80, 0x7D, 0x7F, 0x7F, 0x7D, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x82, 0x90, 0x8C, 0x92, 0xA2, 0x95, 0x9B, 0xA2, 0x90,
	0x92, 0x91, 0x7F, 0x80, 0x7D, 0x71, 0x74, 0x75, 0x70, 0x75, 0x78, 0x78,
	0x7C, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x7D, 0x7C, 0x7E, 0x7D,
	0x7D, 0x7F, 0x7F, 0x80, 0x83, 0x82, 0x83, 0x86, 0x82, 0x82, 0x85, 0x80,
	0x80, 0x82, 0x7C, 0x7E, 0x7F, 0x7B, 0x7E, 0x80, 0x7C, 0x81, 0x83, 0x7F,
	0x85, 0x84, 0x80, 0x85, 0x83, 0x81, 0x85, 0x82, 0x81, 0x84, 0x82, 0x81,
	0x83, 0x82, 0x81, 0x83, 0x82, 0x82, 0x84, 0x85, 0x85, 0x86, 0x88, 0x87,
	0x88, 0x88, 0x86, 0x86, 0x85, 0x82, 0x81, 0x80, 0x7E, 0x7C, 0x7C, 0x7A,
	0x79, 0x79, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7F, 0x80, 0x81, 0x82, 0x83,
	0x83, 0x83, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7C,
	0x7C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B,
	0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E,
	0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x81,
	0x7F, 0x7E, 0x81, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7F,
	0x82, 0x7F, 0x7E, 0x82, 0x81, 0x7E, 0x81, 0x80, 0x7E, 0x81, 0x80, 0x7C,
	0x7E, 0x81, 0x7E, 0x7E, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x80, 0x81,
	0x7F, 0x7F, 0x7F, 0x82, 0x81, 0x7D, 0x7E, 0x80, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x7E, 0x7D, 0x7F, 0x82, 0x80, 0x7E, 0x81, 0x81, 0x7D, 0x7F, 0x82,
	0x7F, 0x7C, 0x81, 0x83, 0x7E, 0x7D, 0x81, 0x80, 0x7E, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x7E, 0x7D, 0x81,
	0x80, 0x7D, 0x80, 0x81, 0x7E, 0x7E, 0x81, 0x80, 0x7F, 0x82, 0x81, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7C, 0x7D, 0x7F, 0x7E, 0x7E, 0x81, 0x7F, 0x7F,
	0x82, 0x80, 0x7D, 0x81, 0x82, 0x7E, 0x80, 0x81, 0x7F, 0x7D, 0x80, 0x7F,
	0x7C, 0x7F, 0x81, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x81, 0x7F, 0x81,
	0x80, 0x7E, 0x80, 0x80, 0x7E, 0x7D, 0x82, 0x82, 0x7D, 0x7F, 0x82, 0x7E,
	0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x81, 0x7E, 0x7F, 0x84, 0x7F,
	0x81, 0x82, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x82, 0x7F, 0x80, 0x83, 0x7F, 0x7E, 0x82, 0x7E, 0x7E, 0x80,
	0x7F, 0x7D, 0x81, 0x81, 0x7E, 0x80, 0x82, 0x7E, 0x7F, 0x81, 0x7E, 0x7F,
	0x7F, 0x7D, 0x80, 0x81, 0x7D, 0x7F, 0x83, 0x7E, 0x7C, 0x84, 0x7F, 0x7B,
	0x81, 0x81, 0x7B, 0x7F, 0x83, 0x7C, 0x7F, 0x84, 0x7E, 0x7E, 0x83, 0x7F,
	0x7D, 0x81, 0x81, 0x7C, 0x7E, 0x84, 0x7D, 0x7D, 0x85, 0x7F, 0x7B, 0x84,
	0x81, 0x7A, 0x82, 0x83, 0x7B, 0x7F, 0x85, 0x7B, 0x7D, 0x86, 0x7E, 0x7B,
	0x86, 0x81, 0x78, 0x83, 0x84, 0x79, 0x7E, 0x85, 0x7D, 0x7B, 0x85, 0x7F,
	0x7B, 0x84, 0x82, 0x7B, 0x81, 0x82, 0x7B, 0x80, 0x82, 0x7D, 0x7E, 0x84,
	0x80, 0x7C, 0x81, 0x81, 0x7C, 0x80, 0x83, 0x7B, 0x80, 0x84, 0x7B, 0x7F,
	0x84, 0x7D, 0x7D, 0x83, 0x7F, 0x7C, 0x82, 0x81, 0x7C, 0x81, 0x81, 0x7C,
	0x7F, 0x83, 0x7D, 0x7E, 0x82, 0x80, 0x7E, 0x81, 0x81, 0x7E, 0x7E, 0x81,
	0x80, 0x7D, 0x81, 0x81, 0x7E, 0x7F, 0x82, 0x7F, 0x7E, 0x82, 0x80, 0x7D,
	0x80, 0x82, 0x7D, 0x7F, 0x83, 0x7E, 0x7E, 0x82, 0x7E, 0x7E, 0x81, 0x81,
	0x7E, 0x7E, 0x83, 0x7F, 0x7D, 0x82, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x7F,
	0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x82, 0x7F, 0x7E, 0x81, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x81,
	0x80, 0x7E, 0x7F, 0x82, 0x7E, 0x7E, 0x82, 0x80, 0x7D, 0x81, 0x81, 0x7E,
	0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x81, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x81,
	0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x80, 0x81, 0x7F, 0x7F,
	0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F,
	0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x82, 0x80, 0x82, 0x81, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x81,
	0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80,
	0x81, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x7F, 0x7D, 0x7C, 0x7E,
	0x7C, 0x7C, 0x7E, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x7F, 0x81, 0x7F, 0x81, 0x80, 0x7D, 0x7D, 0x7C, 0x7B, 0x7B, 0x7C, 0x7C,
	0x7D, 0x7F, 0x80, 0x83, 0x83, 0x84, 0x87, 0x85, 0x86, 0x87, 0x84, 0x80,
	0x81, 0x7D, 0x7B, 0x7D, 0x7B, 0x7C, 0x7E, 0x7F, 0x82, 0x82, 0x86, 0x87,
	0x87, 0x8A, 0x8A, 0x8B, 0x8E, 0x8C, 0x8A, 0x8A, 0x87, 0x87, 0x84, 0x81,
	0x82, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x82, 0x80, 0x81, 0x82, 0x81,
	0x81, 0x82, 0x84, 0x81, 0x85, 0x83, 0x82, 0x85, 0x80, 0x89, 0x89, 0x88,
	0x93, 0x8D, 0x91, 0x92, 0x8D, 0x8D, 0x8A, 0x86, 0x82, 0x81, 0x7B, 0x79,
	0x79, 0x75, 0x77, 0x78, 0x78, 0x7B, 0x7C, 0x7E, 0x7F, 0x81, 0x82, 0x83,
	0x84, 0x82, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7D, 0x81, 0x8E,
	0x86, 0x9A, 0x9C, 0x98, 0xA9, 0x9C, 0x9E, 0x9B, 0x8F, 0x8A, 0x83, 0x79,
	0x73, 0x71, 0x69, 0x6B, 0x6D, 0x6A, 0x73, 0x74, 0x77, 0x7E, 0x7E, 0x82,
	0x85, 0x85, 0x85, 0x87, 0x84, 0x84, 0x85, 0x82, 0x82, 0x81, 0x80, 0x81,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7D, 0x7F, 0x7D, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81,
	0x7F, 0x91, 0x89, 0x98, 0xA5, 0x96, 0xB1, 0x9E, 0x9F, 0xA1, 0x8B, 0x8E,
	0x7E, 0x76, 0x70, 0x6B, 0x66, 0x68, 0x6A, 0x68, 0x75, 0x73, 0x7C, 0x82,
	0x81, 0x8B, 0x88, 0x89, 0x8B, 0x87, 0x87, 0x85, 0x82, 0x80, 0x80, 0x7C,
	0x7D, 0x7D, 0x7B, 0x7F, 0x7C, 0x7E, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x81, 0x7F, 0x81,
	0x80, 0x7F, 0x81, 0x7C, 0x93, 0x87, 0x9C, 0xA4, 0x98, 0xB4, 0x98, 0xA3,
	0x9A, 0x88, 0x8C, 0x77, 0x74, 0x6E, 0x68, 0x68, 0x6A, 0x6A, 0x71, 0x77,
	0x78, 0x84, 0x81, 0x88, 0x8A, 0x87, 0x8D, 0x85, 0x88, 0x83, 0x82, 0x81,
	0x7E, 0x7E, 0x7C, 0x7E, 0x7B, 0x7F, 0x7C, 0x7E, 0x7F, 0x7D, 0x81, 0x7F,
	0x80, 0x81, 0x7E, 0x81, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7E, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x7D, 0x93, 0x8B, 0x9B, 0xAA,
	0x97, 0xB7, 0x99, 0xA2, 0x9B, 0x82, 0x8B, 0x71, 0x72, 0x6C, 0x66, 0x69,
	0x6B, 0x6C, 0x74, 0x79, 0x7A, 0x86, 0x82, 0x89, 0x8B, 0x86, 0x8C, 0x85,
	0x86, 0x85, 0x7F, 0x81, 0x7E, 0x7C, 0x7E, 0x7A, 0x7D, 0x7D, 0x7C, 0x7F,
	0x7E, 0x7D, 0x80, 0x7E, 0x7D, 0x80, 0x7C, 0x80, 0x7E, 0x7F, 0x81, 0x7F,
	0x81, 0x81, 0x7F, 0x82, 0x7F, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7E, 0x82, 0x99, 0x8A, 0xB0, 0xA1, 0xA8, 0xB5, 0x8D, 0xA9, 0x7C, 0x82,
	0x77, 0x61, 0x71, 0x5C, 0x6A, 0x69, 0x6E, 0x76, 0x7C, 0x80, 0x86, 0x8A,
	0x88, 0x90, 0x87, 0x8C, 0x87, 0x82, 0x86, 0x7C, 0x7F, 0x7C, 0x79, 0x7D,
	0x78, 0x7C, 0x7E, 0x7D, 0x82, 0x81, 0x83, 0x85, 0x83, 0x84, 0x84, 0x80,
	0x83, 0x7E, 0x7F, 0x7F, 0x7C, 0x7F, 0x7C, 0x7D, 0x7F, 0x7D, 0x80, 0x80,
	0x80, 0x81, 0x82, 0x7F, 0x83, 0x7E, 0x82, 0x7F, 0x7E, 0x9A, 0x8D, 0xB1,
	0xAA, 0xA8, 0xB7, 0x92, 0xA4, 0x86, 0x81, 0x80, 0x6A, 0x73, 0x67, 0x69,
	0x6D, 0x6F, 0x75, 0x80, 0x80, 0x8A, 0x8F, 0x8A, 0x97, 0x89, 0x8E, 0x8A,
	0x7F, 0x85, 0x78, 0x7A, 0x79, 0x73, 0x7A, 0x77, 0x79, 0x80, 0x7C, 0x85,
	0x85, 0x84, 0x89, 0x85, 0x86, 0x86, 0x80, 0x83, 0x7E, 0x7B, 0x7E, 0x78,
	0x7C, 0x7B, 0x79, 0x80, 0x7C, 0x81, 0x82, 0x81, 0x89, 0x84, 0x8C, 0x87,
	0x87, 0x86, 0x82, 0x81, 0x7F, 0x7A, 0x8C, 0x94, 0x9D, 0xB5, 0xA1, 0xB4,
	0x9D, 0x98, 0x9A, 0x81, 0x8D, 0x77, 0x75, 0x71, 0x68, 0x6F, 0x70, 0x76,
	0x80, 0x84, 0x85, 0x8F, 0x86, 0x90, 0x8D, 0x88, 0x8E, 0x7E, 0x82, 0x78,
	0x74, 0x78, 0x71, 0x78, 0x77, 0x78, 0x7E, 0x7F, 0x84, 0x87, 0x87, 0x8A,
	0x88, 0x86, 0x85, 0x81, 0x7E, 0x7E, 0x79, 0x7A, 0x7A, 0x78, 0x7F, 0x7C,
	0x82, 0x83, 0x83, 0x87, 0x84, 0x86, 0x85, 0x83, 0x83, 0x7F, 0x7E, 0x7D,
	0x7A, 0x7C, 0x7A, 0x7D, 0x7B, 0x91, 0x96, 0xA8, 0xB7, 0xA6, 0xB5, 0x96,
	0x9A, 0x91, 0x81, 0x89, 0x6F, 0x73, 0x67, 0x66, 0x6F, 0x75, 0x82, 0x89,
	0x90, 0x90, 0x97, 0x92, 0x99, 0x93, 0x8D, 0x8B, 0x79, 0x7A, 0x6F, 0x6F,
	0x72, 0x70, 0x78, 0x78, 0x7D, 0x82, 0x87, 0x8D, 0x90, 0x90, 0x8E, 0x8A,
	0x83, 0x81, 0x7B, 0x79, 0x78, 0x74, 0x76, 0x74, 0x78, 0x7C, 0x7F, 0x85,
	0x86, 0x89, 0x89, 0x88, 0x87, 0x85, 0x82, 0x80, 0x7C, 0x7A, 0x77, 0x78,
	0x77, 0x7B, 0x7C, 0x80, 0x80, 0x8B, 0x9E, 0xA0, 0xBA, 0xAB, 0xAD, 0xA2,
	0x8A, 0x93, 0x7A, 0x82, 0x76, 0x6D, 0x6F, 0x67, 0x71, 0x78, 0x84, 0x8D,
	0x95, 0x93, 0x96, 0x94, 0x8F, 0x93, 0x86, 0x87, 0x7B, 0x73, 0x74, 0x6C,
	0x76, 0x75, 0x7B, 0x80, 0x81, 0x86, 0x89, 0x8C, 0x8D, 0x8E, 0x88, 0x86,
	0x7F, 0x7B, 0x7B, 0x76, 0x79, 0x76, 0x77, 0x7A, 0x7A, 0x82, 0x82, 0x87,
	0x88, 0x87, 0x87, 0x84, 0x82, 0x80, 0x7F, 0x7B, 0x7B, 0x78, 0x78, 0x7B,
	0x7A, 0x80, 0x7F, 0x83, 0x83, 0x84, 0x85, 0x85, 0x9B, 0x98, 0xAC, 0xA6,
	0x9C, 0x9F, 0x85, 0x90, 0x81, 0x80, 0x7E, 0x6F, 0x76, 0x6F, 0x79, 0x80,
	0x87, 0x8B, 0x8D, 0x8E, 0x8C, 0x91, 0x8A, 0x8D, 0x84, 0x7E, 0x7C, 0x73,
	0x78, 0x75, 0x79, 0x7B, 0x7B, 0x80, 0x81, 0x87, 0x88, 0x8A, 0x88, 0x87,
	0x83, 0x80, 0x80, 0x7B, 0x7E, 0x79, 0x7A, 0x7B, 0x7A, 0x7F, 0x7F, 0x83,
	0x84, 0x83, 0x85, 0x83, 0x84, 0x83, 0x81, 0x7F, 0x7D, 0x7C, 0x7B, 0x7D,
	0x7C, 0x7E, 0x7E, 0x80, 0x80, 0x82, 0x82, 0x84, 0x83, 0x85, 0x82, 0x88,
	0x99, 0x97, 0xAB, 0x9E, 0x9A, 0x99, 0x85, 0x90, 0x80, 0x80, 0x7C, 0x6F,
	0x75, 0x71, 0x7A, 0x81, 0x86, 0x88, 0x8B, 0x8B, 0x8B, 0x90, 0x89, 0x8A,
	0x82, 0x7C, 0x7C, 0x74, 0x7A, 0x78, 0x79, 0x7C, 0x7B, 0x80, 0x83, 0x87,
	0x88, 0x88, 0x86, 0x84, 0x83, 0x7F, 0x80, 0x7B, 0x7B, 0x7A, 0x78, 0x7C,
	0x7B, 0x7F, 0x81, 0x81, 0x84, 0x83, 0x84, 0x84, 0x82, 0x80, 0x7F, 0x7C,
	0x7C, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7F, 0x80, 0x82, 0x83, 0x83, 0x82,
	0x82, 0x80, 0x81, 0x7E, 0x7F, 0x93, 0x92, 0xA3, 0xA2, 0x95, 0x9D, 0x88,
	0x8F, 0x89, 0x7E, 0x80, 0x70, 0x72, 0x73, 0x76, 0x7F, 0x83, 0x86, 0x87,
	0x8C, 0x8A, 0x90, 0x8D, 0x87, 0x88, 0x7B, 0x7C, 0x79, 0x75, 0x7B, 0x76,
	0x7A, 0x7C, 0x7D, 0x84, 0x85, 0x88, 0x88, 0x87, 0x83, 0x82, 0x7F, 0x7C,
	0x7D, 0x77, 0x79, 0x79, 0x78, 0x7E, 0x7E, 0x81, 0x84, 0x82, 0x85, 0x84,
	0x83, 0x84, 0x81, 0x7F, 0x7E, 0x7C, 0x7B, 0x7C, 0x7B, 0x7D, 0x7E, 0x7E,
	0x81, 0x82, 0x84, 0x86, 0x84, 0x86, 0x82, 0x82, 0x80, 0x80, 0x7D, 0x89,
	0x96, 0x96, 0xA7, 0x99, 0x96, 0x97, 0x86, 0x90, 0x85, 0x7C, 0x7D, 0x6E,
	0x74, 0x77, 0x78, 0x83, 0x82, 0x86, 0x88, 0x8A, 0x8C, 0x8D, 0x8C, 0x85,
	0x83, 0x7D, 0x79, 0x7C, 0x77, 0x79, 0x7A, 0x77, 0x7E, 0x7E, 0x82, 0x87,
	0x85, 0x87, 0x86, 0x84, 0x84, 0x82, 0x80, 0x7D, 0x7C, 0x7A, 0x7A, 0x7B,
	0x7C, 0x7E, 0x7F, 0x81, 0x83, 0x84, 0x84, 0x85, 0x84, 0x83, 0x82, 0x80,
	0x7E, 0x7E, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7F, 0x7F, 0x81, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x7E, 0x8E, 0x97, 0x97, 0xA3, 0x97, 0x92,
	0x95, 0x8B, 0x8E, 0x89, 0x7E, 0x7B, 0x73, 0x73, 0x76, 0x78, 0x7C, 0x7C,
	0x80, 0x81, 0x85, 0x8C, 0x8B, 0x8C, 0x8A, 0x85, 0x84, 0x81, 0x80, 0x7E,
	0x7A, 0x79, 0x76, 0x77, 0x79, 0x7A, 0x7D, 0x7E, 0x7F, 0x82, 0x83, 0x85,
	0x86, 0x85, 0x85, 0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B,
	0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83,
	0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F,
	0x7F, 0x86, 0x94, 0x96, 0x9C, 0x9D, 0x96, 0x97, 0x94, 0x92, 0x90, 0x88,
	0x82, 0x7A, 0x76, 0x77, 0x75, 0x78, 0x78, 0x77, 0x7A, 0x7D, 0x82, 0x88,
	0x89, 0x8B, 0x8B, 0x89, 0x8B, 0x89, 0x88, 0x86, 0x81, 0x7E, 0x7B, 0x7A,
	0x7A, 0x79, 0x79, 0x79, 0x79, 0x7C, 0x7E, 0x81, 0x83, 0x84, 0x85, 0x85,
	0x85, 0x86, 0x85, 0x85, 0x83, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B,
	0x7B, 0x7B, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83,
	0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x84, 0x8E, 0x8E, 0x93,
	0x93, 0x90, 0x93, 0x92, 0x92, 0x91, 0x89, 0x86, 0x80, 0x7C, 0x7D, 0x7B,
	0x7A, 0x79, 0x77, 0x79, 0x7B, 0x7F, 0x83, 0x84, 0x86, 0x87, 0x88, 0x8A,
	0x8A, 0x89, 0x88, 0x84, 0x82, 0x80, 0x7E, 0x7D, 0x7C, 0x7A, 0x79, 0x79,
	0x7B, 0x7C, 0x7E, 0x7F, 0x80, 0x82, 0x83, 0x84, 0x85, 0x85, 0x85, 0x84,
	0x83, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x81, 0x8A, 0x8E, 0x8F, 0x92, 0x90, 0x8F, 0x90, 0x8F, 0x90, 0x8B,
	0x87, 0x83, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x79, 0x7A, 0x7B, 0x7D, 0x81,
	0x83, 0x84, 0x85, 0x86, 0x88, 0x88, 0x89, 0x88, 0x86, 0x84, 0x82, 0x80,
	0x7F, 0x7E, 0x7D, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x82,
	0x83, 0x84, 0x84, 0x85, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E,
	0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x85, 0x89, 0x89, 0x8B, 0x8B,
	0x8A, 0x8B, 0x8B, 0x8C, 0x8A, 0x88, 0x86, 0x83, 0x82, 0x82, 0x81, 0x80,
	0x7E, 0x7E, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x83, 0x85,
	0x85, 0x85, 0x85, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x85, 0x88, 0x88, 0x8A, 0x8B, 0x8B, 0x8C, 0x8D, 0x8E, 0x8C, 0x8B, 0x89,
	0x88, 0x86, 0x85, 0x85, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x84, 0x84, 0x85, 0x85, 0x85,
	0x85, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x82, 0x85, 0x85, 0x86, 0x87, 0x87, 0x87, 0x88,
	0x89, 0x88, 0x87, 0x87, 0x86, 0x85, 0x85, 0x85, 0x83, 0x83, 0x83, 0x83,
	0x82, 0x82, 0x82, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7E, 0x7F,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x82, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x82, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x81,
	0x82, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x83, 0x82, 0x82, 0x81, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F
};
const unsigned char WAV17[] = {
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x7F,
	0x81, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80,
	0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x7E, 0x82, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x81, 0x7E, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x81, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x7E, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x7E, 0x81, 0x7E, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x81,
	0x80, 0x7F, 0x7E, 0x82, 0x7F, 0x7D, 0x81, 0x82, 0x7E, 0x7E, 0x81, 0x7F,
	0x7F, 0x81, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x7F,
	0x7E, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7D, 0x7E, 0x81, 0x7E, 0x81,
	0x80, 0x82, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80,
	0x7F, 0x7E, 0x80, 0x80, 0x7D, 0x80, 0x81, 0x7E, 0x81, 0x80, 0x80, 0x7E,
	0x81, 0x80, 0x7E, 0x81, 0x7F, 0x7F, 0x7E, 0x82, 0x80, 0x7F, 0x84, 0x80,
	0x7F, 0x81, 0x80, 0x7F, 0x7E, 0x80, 0x7E, 0x7D, 0x80, 0x80, 0x7D, 0x7E,
	0x81, 0x7F, 0x7E, 0x81, 0x82, 0x7D, 0x7F, 0x82, 0x7E, 0x7F, 0x81, 0x81,
	0x7E, 0x81, 0x83, 0x7E, 0x80, 0x83, 0x7F, 0x7F, 0x81, 0x7F, 0x7B, 0x7E,
	0x80, 0x7E, 0x7F, 0x82, 0x81, 0x7F, 0x82, 0x83, 0x80, 0x80, 0x83, 0x81,
	0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x82, 0x83, 0x82, 0x84, 0x86, 0x83, 0x82,
	0x81, 0x82, 0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x7C, 0x7B, 0x7C, 0x7C, 0x7C,
	0x7A, 0x79, 0x7D, 0x7C, 0x7C, 0x7E, 0x80, 0x81, 0x80, 0x82, 0x82, 0x81,
	0x7F, 0x87, 0x90, 0x8B, 0x90, 0x93, 0x8F, 0x89, 0x84, 0x84, 0x7A, 0x77,
	0x79, 0x78, 0x78, 0x79, 0x80, 0x81, 0x80, 0x85, 0x85, 0x83, 0x81, 0x82,
	0x7F, 0x7B, 0x7C, 0x7C, 0x7B, 0x7C, 0x7E, 0x81, 0x80, 0x81, 0x83, 0x82,
	0x81, 0x80, 0x81, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x7F,
	0x81, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7D, 0x7A, 0x88, 0xA5, 0x9E, 0xA4,
	0xAE, 0xA6, 0x95, 0x83, 0x85, 0x70, 0x63, 0x6A, 0x6E, 0x72, 0x73, 0x86,
	0x8C, 0x87, 0x8C, 0x8D, 0x88, 0x7B, 0x7E, 0x7D, 0x75, 0x76, 0x7B, 0x80,
	0x79, 0x7F, 0x85, 0x80, 0x80, 0x80, 0x84, 0x7D, 0x7C, 0x81, 0x7F, 0x7D,
	0x7E, 0x83, 0x81, 0x7D, 0x82, 0x82, 0x7F, 0x7E, 0x81, 0x81, 0x7C, 0x80,
	0x7F, 0x82, 0x7A, 0x97, 0xB7, 0xA2, 0xAC, 0xAD, 0xA1, 0x7F, 0x6F, 0x78,
	0x5F, 0x5D, 0x6C, 0x7C, 0x7E, 0x7F, 0x99, 0x92, 0x87, 0x85, 0x86, 0x7D,
	0x6C, 0x7A, 0x7B, 0x77, 0x7B, 0x85, 0x8B, 0x80, 0x85, 0x89, 0x80, 0x7A,
	0x7C, 0x82, 0x78, 0x7B, 0x82, 0x83, 0x80, 0x7F, 0x87, 0x81, 0x7C, 0x80,
	0x80, 0x7D, 0x7A, 0x81, 0x82, 0x7D, 0x81, 0x82, 0x83, 0x79, 0xAF, 0xC5,
	0xA7, 0xB7, 0xB0, 0x9C, 0x69, 0x66, 0x6F, 0x52, 0x5F, 0x75, 0x8F, 0x85,
	0x8B, 0xA3, 0x8B, 0x7D, 0x78, 0x7F, 0x70, 0x67, 0x83, 0x83, 0x80, 0x83,
	0x90, 0x8C, 0x77, 0x83, 0x80, 0x78, 0x73, 0x7D, 0x86, 0x79, 0x83, 0x89,
	0x86, 0x7E, 0x7F, 0x86, 0x7A, 0x78, 0x81, 0x80, 0x7E, 0x7C, 0x87, 0x82,
	0x7C, 0x81, 0x81, 0x7E, 0x7B, 0xC4, 0xC3, 0xA2, 0xB4, 0xA5, 0x84, 0x51,
	0x65, 0x6C, 0x52, 0x6E, 0x8D, 0x9B, 0x8B, 0x92, 0xA0, 0x7B, 0x6E, 0x73,
	0x79, 0x6F, 0x70, 0x91, 0x8C, 0x83, 0x88, 0x8C, 0x80, 0x6D, 0x7C, 0x7E,
	0x76, 0x7B, 0x87, 0x8B, 0x7D, 0x82, 0x88, 0x7C, 0x76, 0x7C, 0x81, 0x7B,
	0x79, 0x85, 0x84, 0x7E, 0x7D, 0x84, 0x81, 0x79, 0x7E, 0x85, 0x7B, 0x89,
	0xD2, 0xBE, 0xA0, 0xAA, 0x99, 0x70, 0x47, 0x66, 0x72, 0x61, 0x7C, 0x9D,
	0x9F, 0x85, 0x84, 0x90, 0x6F, 0x62, 0x71, 0x7E, 0x7D, 0x79, 0x94, 0x95,
	0x80, 0x7E, 0x81, 0x7E, 0x6E, 0x73, 0x87, 0x82, 0x7D, 0x87, 0x8C, 0x83,
	0x77, 0x7E, 0x81, 0x77, 0x78, 0x83, 0x86, 0x7E, 0x80, 0x87, 0x82, 0x79,
	0x7E, 0x7F, 0x80, 0x7A, 0x81, 0x81, 0x98, 0xD1, 0xB9, 0xA5, 0xA8, 0x8E,
	0x72, 0x50, 0x5F, 0x76, 0x6B, 0x7E, 0x97, 0x9E, 0x90, 0x7D, 0x86, 0x7A,
	0x67, 0x6C, 0x7A, 0x85, 0x7F, 0x86, 0x94, 0x8C, 0x80, 0x7B, 0x7D, 0x7B,
	0x72, 0x78, 0x83, 0x84, 0x83, 0x82, 0x88, 0x84, 0x7A, 0x7B, 0x7E, 0x7D,
	0x7A, 0x7E, 0x84, 0x84, 0x80, 0x81, 0x82, 0x80, 0x7B, 0x7D, 0x7F, 0x81,
	0x7A, 0x88, 0xC5, 0xC6, 0xA6, 0xA4, 0x9C, 0x8A, 0x63, 0x52, 0x6E, 0x76,
	0x73, 0x80, 0x94, 0xA1, 0x8D, 0x7E, 0x84, 0x7D, 0x6F, 0x6A, 0x75, 0x85,
	0x81, 0x80, 0x8B, 0x8E, 0x86, 0x7A, 0x7A, 0x80, 0x7B, 0x76, 0x7B, 0x82,
	0x86, 0x81, 0x80, 0x85, 0x84, 0x7E, 0x7A, 0x7C, 0x80, 0x7D, 0x7C, 0x80,
	0x83, 0x83, 0x80, 0x7F, 0x81, 0x81, 0x7C, 0x7E, 0x7D, 0xA1, 0xC9, 0xB5,
	0xA8, 0xA5, 0x98, 0x8D, 0x6B, 0x5A, 0x70, 0x74, 0x75, 0x7E, 0x87, 0x9A,
	0x98, 0x86, 0x85, 0x82, 0x7B, 0x76, 0x6B, 0x76, 0x81, 0x7E, 0x82, 0x85,
	0x88, 0x8C, 0x81, 0x7C, 0x7F, 0x7B, 0x7B, 0x79, 0x78, 0x80, 0x82, 0x80,
	0x83, 0x82, 0x84, 0x83, 0x7E, 0x7D, 0x7F, 0x7D, 0x7E, 0x7D, 0x7E, 0x82,
	0x81, 0x80, 0x81, 0x81, 0x80, 0x99, 0xB6, 0xB0, 0xA5, 0x9C, 0x95, 0x8F,
	0x77, 0x63, 0x66, 0x6D, 0x75, 0x79, 0x7B, 0x8A, 0x95, 0x93, 0x8E, 0x86,
	0x83, 0x82, 0x79, 0x72, 0x73, 0x77, 0x7D, 0x7F, 0x7F, 0x85, 0x88, 0x88,
	0x85, 0x80, 0x7F, 0x7F, 0x7C, 0x7A, 0x7A, 0x7C, 0x80, 0x80, 0x80, 0x82,
	0x83, 0x83, 0x82, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7F, 0x80,
	0x7F, 0x88, 0x9B, 0xA0, 0x9D, 0x99, 0x94, 0x94, 0x8D, 0x80, 0x79, 0x78,
	0x7A, 0x7B, 0x76, 0x77, 0x7C, 0x80, 0x82, 0x80, 0x7F, 0x82, 0x83, 0x82,
	0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x7F,
	0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x86, 0x8C,
	0x8D, 0x8E, 0x8E, 0x8F, 0x90, 0x8D, 0x8A, 0x88, 0x86, 0x85, 0x83, 0x7F,
	0x7E, 0x7E, 0x7D, 0x7D, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x83, 0x85, 0x86, 0x87, 0x88,
	0x8A, 0x8B, 0x8A, 0x89, 0x89, 0x88, 0x87, 0x86, 0x84, 0x83, 0x82, 0x81,
	0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x87, 0x86, 0x86, 0x87, 0x88, 0x89, 0x88,
	0x86, 0x86, 0x86, 0x84, 0x83, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x87, 0x91, 0x8F, 0x8E, 0x90, 0x90, 0x8E, 0x87, 0x82, 0x83,
	0x80, 0x7C, 0x7A, 0x7B, 0x7D, 0x7D, 0x7C, 0x7E, 0x81, 0x81, 0x81, 0x80,
	0x82, 0x83, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E,
	0x88, 0xA2, 0xA3, 0x9A, 0x9E, 0x9C, 0x94, 0x86, 0x76, 0x78, 0x77, 0x6F,
	0x71, 0x78, 0x80, 0x86, 0x85, 0x88, 0x8F, 0x8A, 0x84, 0x81, 0x7E, 0x7D,
	0x7A, 0x79, 0x7D, 0x7F, 0x80, 0x82, 0x83, 0x85, 0x83, 0x81, 0x81, 0x80,
	0x7E, 0x7D, 0x7C, 0x7E, 0x7F, 0x7E, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0xA1,
	0xB8, 0xA7, 0xA9, 0xAC, 0xA1, 0x8D, 0x74, 0x72, 0x73, 0x65, 0x67, 0x74,
	0x80, 0x86, 0x85, 0x8E, 0x95, 0x8B, 0x84, 0x81, 0x7E, 0x79, 0x72, 0x74,
	0x7C, 0x7E, 0x7F, 0x83, 0x89, 0x89, 0x84, 0x83, 0x83, 0x7F, 0x7B, 0x7A,
	0x7B, 0x7D, 0x7B, 0x7E, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7E, 0x7F,
	0x7E, 0x7E, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x84, 0x84, 0x85, 0xB3, 0xC1,
	0xAF, 0xB6, 0xB0, 0xA4, 0x85, 0x6C, 0x72, 0x69, 0x5D, 0x66, 0x75, 0x84,
	0x86, 0x89, 0x97, 0x94, 0x89, 0x83, 0x7F, 0x7D, 0x72, 0x70, 0x78, 0x7A,
	0x7B, 0x7F, 0x86, 0x8A, 0x85, 0x84, 0x85, 0x82, 0x7D, 0x7A, 0x7C, 0x7C,
	0x7B, 0x7C, 0x80, 0x82, 0x81, 0x81, 0x84, 0x82, 0x80, 0x7F, 0x7F, 0x7E,
	0x7D, 0x7D, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7C, 0x9E, 0xB9, 0xAC,
	0xB6, 0xB8, 0xAD, 0x95, 0x79, 0x79, 0x6C, 0x5A, 0x61, 0x6B, 0x77, 0x7A,
	0x82, 0x95, 0x93, 0x8D, 0x8D, 0x89, 0x83, 0x77, 0x74, 0x78, 0x74, 0x75,
	0x77, 0x7C, 0x7F, 0x7E, 0x83, 0x85, 0x83, 0x83, 0x82, 0x82, 0x7F, 0x7C,
	0x7E, 0x7C, 0x7C, 0x7D, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x81, 0x81, 0x80,
	0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7E, 0x80, 0x7F, 0x98, 0xB0, 0xAE,
	0xB6, 0xB3, 0xAA, 0x9A, 0x89, 0x85, 0x75, 0x6A, 0x6B, 0x69, 0x6E, 0x71,
	0x7C, 0x85, 0x87, 0x8F, 0x92, 0x90, 0x8E, 0x89, 0x86, 0x7F, 0x79, 0x78,
	0x73, 0x70, 0x70, 0x71, 0x74, 0x76, 0x7C, 0x80, 0x82, 0x86, 0x88, 0x89,
	0x88, 0x88, 0x86, 0x83, 0x80, 0x7E, 0x7C, 0x7A, 0x79, 0x79, 0x79, 0x7A,
	0x7C, 0x7E, 0x7F, 0x81, 0x82, 0x84, 0x82, 0x81, 0x80, 0x84, 0x9A, 0xA0,
	0xA4, 0xA5, 0x9D, 0x9A, 0x96, 0x97, 0x96, 0x8C, 0x85, 0x7A, 0x74, 0x73,
	0x73, 0x78, 0x77, 0x77, 0x79, 0x7B, 0x82, 0x87, 0x8C, 0x8E, 0x8C, 0x8B,
	0x8B, 0x8B, 0x8B, 0x88, 0x85, 0x80, 0x7C, 0x7A, 0x79, 0x7A, 0x7A, 0x79,
	0x79, 0x7A, 0x7C, 0x7F, 0x82, 0x84, 0x84, 0x85, 0x84, 0x85, 0x85, 0x84,
	0x84, 0x81, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7A, 0x7A, 0x79, 0x7C, 0x8E,
	0x99, 0xA1, 0xA7, 0xA2, 0xA0, 0x9E, 0x9E, 0x9D, 0x97, 0x8F, 0x83, 0x7A,
	0x76, 0x73, 0x74, 0x73, 0x72, 0x72, 0x73, 0x79, 0x7E, 0x84, 0x89, 0x8A,
	0x8C, 0x8D, 0x8E, 0x8F, 0x8E, 0x8B, 0x87, 0x83, 0x7F, 0x7C, 0x7B, 0x79,
	0x78, 0x77, 0x77, 0x78, 0x79, 0x7C, 0x7F, 0x81, 0x82, 0x83, 0x84, 0x85,
	0x86, 0x86, 0x85, 0x84, 0x82, 0x80, 0x7F, 0x7E, 0x7D, 0x7B, 0x7B, 0x7B,
	0x87, 0x93, 0x9B, 0xA4, 0xA3, 0xA1, 0xA0, 0x9E, 0x9E, 0x9B, 0x96, 0x8C,
	0x83, 0x7C, 0x77, 0x76, 0x75, 0x73, 0x73, 0x72, 0x74, 0x78, 0x7D, 0x82,
	0x85, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8B, 0x8A, 0x87, 0x84, 0x80, 0x7F,
	0x7D, 0x7C, 0x7B, 0x79, 0x79, 0x78, 0x79, 0x7B, 0x7C, 0x7E, 0x7F, 0x81,
	0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E,
	0x7D, 0x80, 0x89, 0x8F, 0x97, 0x9B, 0x9B, 0x9B, 0x9A, 0x99, 0x99, 0x97,
	0x94, 0x8E, 0x88, 0x82, 0x7E, 0x7C, 0x7A, 0x79, 0x77, 0x76, 0x76, 0x77,
	0x79, 0x7C, 0x80, 0x82, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x89, 0x87,
	0x86, 0x84, 0x82, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7B, 0x7B, 0x7C,
	0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x82, 0x81, 0x7F, 0x7C,
	0x7A, 0x78, 0x76, 0x75, 0x75, 0x73, 0x71, 0x70, 0x70, 0x71, 0x73, 0x76,
	0x79, 0x7C, 0x80, 0x83, 0x86, 0x8A, 0x8C, 0x8E, 0x91, 0x94, 0x97, 0x98,
	0x98, 0x96, 0x93, 0x90, 0x8D, 0x8B, 0x8B, 0x8A, 0x89, 0x88, 0x86, 0x83,
	0x82, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x80, 0x7E, 0x7D, 0x7B, 0x7A, 0x7B, 0x7B, 0x7A, 0x79, 0x77,
	0x76, 0x77, 0x78, 0x79, 0x7B, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x82, 0x85,
	0x87, 0x88, 0x89, 0x89, 0x89, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
	0x87, 0x87, 0x86, 0x85, 0x85, 0x85, 0x84, 0x84, 0x83, 0x83, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84,
	0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x7F, 0x81, 0x82, 0x7F,
	0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x83,
	0x82, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7D, 0x80,
	0x80, 0x7E, 0x80, 0x7E, 0x80, 0x81, 0x83, 0x84, 0x84, 0x82, 0x82, 0x81,
	0x80, 0x80, 0x7E, 0x7E, 0x7C, 0x7C, 0x7E, 0x7D, 0x7B, 0x7D, 0x7F, 0x7E,
	0x80, 0x82, 0x7F, 0x7F, 0x82, 0x7F, 0x82, 0x83, 0x80, 0x80, 0x82, 0x7F,
	0x7F, 0x81, 0x7C, 0x7E, 0x82, 0x7F, 0x7F, 0x84, 0x82, 0x81, 0x85, 0x81,
	0x7E, 0x84, 0x7F, 0x7B, 0x7E, 0x7D, 0x7B, 0x7F, 0x81, 0x7B, 0x81, 0x81,
	0x7D, 0x81, 0x84, 0x81, 0x7F, 0x83, 0x7F, 0x7E, 0x83, 0x7F, 0x80, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x81, 0x7F, 0x81, 0x7E, 0x7F, 0x7F, 0x7E,
	0x7F, 0x80, 0x7D, 0x7F, 0x82, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82,
	0x81, 0x80, 0x82, 0x80, 0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x7D, 0x7F, 0x7F,
	0x7C, 0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x82, 0x7F, 0x7E, 0x81,
	0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x7F, 0x80, 0x7E, 0x81, 0x7F, 0x7F, 0x81,
	0x80, 0x80, 0x83, 0x7F, 0x7F, 0x81, 0x7F, 0x7D, 0x82, 0x7E, 0x80, 0x83,
	0x7E, 0x7D, 0x84, 0x7F, 0x7C, 0x85, 0x7C, 0x7F, 0x83, 0x7E, 0x80, 0x82,
	0x7C, 0x80, 0x85, 0x79, 0x81, 0x83, 0x7B, 0x81, 0x82, 0x7C, 0x80, 0x83,
	0x7B, 0x81, 0x83, 0x7B, 0x80, 0x81, 0x7C, 0x7F, 0x82, 0x7C, 0x80, 0x82,
	0x7C, 0x83, 0x82, 0x7D, 0x82, 0x81, 0x7D, 0x82, 0x80, 0x7D, 0x83, 0x7E,
	0x7D, 0x82, 0x7E, 0x7D, 0x82, 0x7F, 0x7D, 0x82, 0x7E, 0x7E, 0x82, 0x7F,
	0x7F, 0x83, 0x7F, 0x80, 0x83, 0x7F, 0x80, 0x81, 0x7E, 0x7F, 0x80, 0x7D,
	0x7F, 0x80, 0x7E, 0x80, 0x81, 0x80, 0x81, 0x82, 0x81, 0x82, 0x81, 0x7F,
	0x83, 0x80, 0x7F, 0x81, 0x7E, 0x7F, 0x7F, 0x7D, 0x7E, 0x7F, 0x7C, 0x7E,
	0x7E, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x81, 0x83, 0x84, 0x86, 0x87, 0x86,
	0x87, 0x87, 0x85, 0x85, 0x81, 0x80, 0x80, 0x7B, 0x7A, 0x7A, 0x78, 0x78,
	0x79, 0x79, 0x79, 0x7B, 0x7D, 0x7C, 0x7E, 0x7E, 0x7E, 0x80, 0x7E, 0x7F,
	0x7E, 0x83, 0x84, 0x86, 0x8B, 0x8A, 0x8E, 0x8E, 0x8D, 0x8D, 0x8B, 0x88,
	0x86, 0x83, 0x80, 0x7F, 0x7C, 0x7C, 0x7B, 0x7A, 0x7B, 0x7B, 0x7C, 0x7D,
	0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D,
	0x7E, 0x7E, 0x7E, 0x81, 0x89, 0x89, 0x94, 0x96, 0x99, 0x9F, 0x99, 0x9C,
	0x95, 0x90, 0x8B, 0x83, 0x7E, 0x79, 0x74, 0x72, 0x72, 0x71, 0x74, 0x76,
	0x78, 0x7C, 0x7D, 0x80, 0x82, 0x83, 0x84, 0x83, 0x83, 0x82, 0x82, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x82, 0x81, 0x82, 0x82,
	0x81, 0x82, 0x81, 0x80, 0x81, 0x7E, 0x89, 0x8C, 0x91, 0xA2, 0x9C, 0xAA,
	0xA7, 0xA1, 0xA3, 0x93, 0x90, 0x84, 0x7A, 0x75, 0x6E, 0x6B, 0x6A, 0x6A,
	0x6E, 0x73, 0x77, 0x7E, 0x82, 0x86, 0x8A, 0x8A, 0x8C, 0x8A, 0x88, 0x87,
	0x83, 0x81, 0x7F, 0x7B, 0x7B, 0x7A, 0x79, 0x7B, 0x7A, 0x7D, 0x7D, 0x7F,
	0x81, 0x81, 0x83, 0x82, 0x83, 0x82, 0x83, 0x81, 0x82, 0x81, 0x7F, 0x81,
	0x7D, 0x80, 0x7D, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x85, 0x92, 0x8F,
	0xA9, 0xA2, 0xAB, 0xB2, 0x9E, 0xAA, 0x91, 0x8D, 0x85, 0x73, 0x75, 0x68,
	0x6B, 0x6B, 0x6E, 0x74, 0x7A, 0x80, 0x84, 0x8C, 0x8A, 0x90, 0x8C, 0x8C,
	0x8B, 0x84, 0x85, 0x7D, 0x7D, 0x79, 0x78, 0x78, 0x77, 0x79, 0x7A, 0x7C,
	0x7D, 0x81, 0x81, 0x83, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x7F, 0x7F,
	0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x84, 0x96, 0x91, 0xAC, 0xA7, 0xAB, 0xB6, 0x9B, 0xA9, 0x8E, 0x88,
	0x84, 0x6D, 0x75, 0x66, 0x68, 0x6C, 0x68, 0x73, 0x76, 0x7B, 0x84, 0x86,
	0x89, 0x90, 0x8B, 0x8E, 0x8B, 0x86, 0x87, 0x7F, 0x7E, 0x7C, 0x77, 0x79,
	0x77, 0x77, 0x7C, 0x78, 0x7F, 0x7E, 0x7F, 0x83, 0x7F, 0x83, 0x82, 0x7F,
	0x83, 0x7F, 0x80, 0x80, 0x7D, 0x81, 0x7C, 0x7F, 0x7E, 0x7E, 0x7E, 0x80,
	0x7E, 0x81, 0x7F, 0x81, 0x7F, 0x82, 0x7D, 0x8F, 0x96, 0x9B, 0xB8, 0xA3,
	0xBF, 0xA9, 0xA3, 0xA5, 0x82, 0x8E, 0x71, 0x70, 0x6D, 0x60, 0x6B, 0x66,
	0x6D, 0x75, 0x79, 0x81, 0x88, 0x8A, 0x8F, 0x91, 0x8C, 0x90, 0x87, 0x86,
	0x82, 0x7A, 0x7E, 0x74, 0x78, 0x76, 0x75, 0x7A, 0x77, 0x7E, 0x7E, 0x82,
	0x84, 0x85, 0x87, 0x86, 0x86, 0x83, 0x83, 0x80, 0x7F, 0x7D, 0x7B, 0x7C,
	0x7A, 0x7C, 0x7B, 0x7D, 0x7E, 0x7F, 0x82, 0x81, 0x83, 0x82, 0x84, 0x81,
	0x83, 0x7E, 0x95, 0x96, 0xA9, 0xB9, 0xA7, 0xBD, 0x9A, 0x9E, 0x92, 0x7C,
	0x86, 0x6C, 0x73, 0x6B, 0x65, 0x6E, 0x6D, 0x75, 0x80, 0x84, 0x8C, 0x92,
	0x8F, 0x97, 0x90, 0x8D, 0x8E, 0x80, 0x82, 0x77, 0x71, 0x73, 0x6B, 0x71,
	0x73, 0x75, 0x7D, 0x7E, 0x84, 0x89, 0x89, 0x8D, 0x8B, 0x8A, 0x88, 0x83,
	0x80, 0x7D, 0x79, 0x77, 0x77, 0x74, 0x79, 0x77, 0x7C, 0x7E, 0x7F, 0x86,
	0x81, 0x88, 0x82, 0x84, 0x83, 0x7F, 0x81, 0x7C, 0x7B, 0x7C, 0x76, 0x8F,
	0x92, 0xA5, 0xB7, 0xA5, 0xB9, 0x9A, 0x9D, 0x95, 0x82, 0x8C, 0x73, 0x76,
	0x6B, 0x66, 0x6B, 0x6F, 0x76, 0x84, 0x87, 0x8D, 0x95, 0x8F, 0x99, 0x91,
	0x91, 0x8F, 0x81, 0x81, 0x75, 0x72, 0x71, 0x6E, 0x73, 0x75, 0x77, 0x7E,
	0x81, 0x86, 0x8C, 0x8B, 0x90, 0x8D, 0x89, 0x88, 0x80, 0x7E, 0x7B, 0x76,
	0x77, 0x73, 0x75, 0x77, 0x78, 0x7F, 0x81, 0x84, 0x88, 0x88, 0x88, 0x89,
	0x85, 0x86, 0x80, 0x7F, 0x7B, 0x79, 0x77, 0x79, 0x76, 0x80, 0x96, 0x96,
	0xB9, 0xAA, 0xB1, 0xAD, 0x92, 0xA2, 0x82, 0x8B, 0x7C, 0x6D, 0x6F, 0x5F,
	0x69, 0x6D, 0x78, 0x84, 0x8D, 0x8F, 0x96, 0x96, 0x95, 0x9B, 0x90, 0x91,
	0x84, 0x79, 0x77, 0x69, 0x71, 0x6E, 0x71, 0x78, 0x77, 0x80, 0x84, 0x89,
	0x8E, 0x91, 0x8E, 0x8D, 0x86, 0x81, 0x7F, 0x77, 0x79, 0x74, 0x73, 0x75,
	0x73, 0x7A, 0x7C, 0x82, 0x86, 0x88, 0x89, 0x8A, 0x87, 0x87, 0x84, 0x81,
	0x7E, 0x7B, 0x78, 0x78, 0x75, 0x7A, 0x7B, 0x7F, 0x82, 0x88, 0x9E, 0xA0,
	0xB9, 0xB1, 0xAE, 0xA8, 0x8E, 0x93, 0x7D, 0x80, 0x77, 0x6E, 0x6E, 0x67,
	0x6E, 0x76, 0x82, 0x8B, 0x96, 0x95, 0x98, 0x96, 0x90, 0x93, 0x88, 0x87,
	0x7F, 0x74, 0x75, 0x6C, 0x72, 0x75, 0x78, 0x81, 0x80, 0x87, 0x8A, 0x8B,
	0x8F, 0x8E, 0x8B, 0x88, 0x81, 0x7D, 0x7A, 0x76, 0x77, 0x76, 0x76, 0x7A,
	0x79, 0x80, 0x82, 0x85, 0x89, 0x88, 0x8A, 0x88, 0x86, 0x84, 0x81, 0x7F,
	0x7C, 0x7A, 0x78, 0x7A, 0x79, 0x7D, 0x7D, 0x80, 0x83, 0x83, 0x86, 0x85,
	0x9A, 0x9A, 0xAC, 0xAD, 0x9F, 0xA5, 0x87, 0x8E, 0x82, 0x7C, 0x81, 0x6F,
	0x75, 0x6E, 0x74, 0x7D, 0x84, 0x8C, 0x8F, 0x90, 0x8E, 0x91, 0x8B, 0x8E,
	0x87, 0x80, 0x7E, 0x72, 0x76, 0x73, 0x76, 0x7C, 0x7A, 0x81, 0x81, 0x85,
	0x88, 0x8A, 0x8B, 0x89, 0x85, 0x82, 0x81, 0x7D, 0x80, 0x7B, 0x7C, 0x7B,
	0x79, 0x7E, 0x7E, 0x82, 0x84, 0x83, 0x85, 0x83, 0x84, 0x83, 0x82, 0x81,
	0x7E, 0x7E, 0x7B, 0x7D, 0x7B, 0x7E, 0x7D, 0x7F, 0x80, 0x80, 0x82, 0x82,
	0x81, 0x81, 0x7D, 0x81, 0x94, 0x93, 0xA8, 0xA0, 0x99, 0x9C, 0x85, 0x92,
	0x84, 0x81, 0x80, 0x6F, 0x74, 0x70, 0x76, 0x7F, 0x82, 0x86, 0x89, 0x89,
	0x8B, 0x90, 0x8B, 0x8D, 0x85, 0x7E, 0x7F, 0x76, 0x7C, 0x79, 0x78, 0x7D,
	0x79, 0x80, 0x81, 0x84, 0x88, 0x87, 0x87, 0x84, 0x84, 0x81, 0x82, 0x7D,
	0x7C, 0x7B, 0x78, 0x7C, 0x7B, 0x7E, 0x80, 0x80, 0x83, 0x82, 0x84, 0x83,
	0x82, 0x81, 0x7F, 0x7D, 0x7C, 0x7C, 0x7B, 0x7D, 0x7C, 0x7D, 0x7F, 0x7F,
	0x82, 0x82, 0x82, 0x83, 0x81, 0x82, 0x80, 0x80, 0x7E, 0x81, 0x94, 0x93,
	0xA6, 0xA0, 0x98, 0x9C, 0x88, 0x91, 0x85, 0x7F, 0x7D, 0x6E, 0x73, 0x70,
	0x77, 0x7E, 0x82, 0x87, 0x87, 0x8D, 0x8B, 0x91, 0x8D, 0x89, 0x86, 0x7B,
	0x7D, 0x76, 0x77, 0x79, 0x75, 0x7B, 0x7A, 0x7E, 0x83, 0x85, 0x89, 0x88,
	0x89, 0x86, 0x86, 0x83, 0x80, 0x7F, 0x7A, 0x7A, 0x79, 0x79, 0x7C, 0x7D,
	0x80, 0x81, 0x82, 0x84, 0x85, 0x85, 0x84, 0x83, 0x80, 0x7F, 0x7D, 0x7D,
	0x7C, 0x7B, 0x7C, 0x7D, 0x7E, 0x80, 0x81, 0x82, 0x84, 0x83, 0x83, 0x83,
	0x80, 0x82, 0x7E, 0x7F, 0x7C, 0x8A, 0x96, 0x98, 0xA9, 0x98, 0x98, 0x96,
	0x86, 0x90, 0x83, 0x7C, 0x7B, 0x6D, 0x73, 0x76, 0x79, 0x83, 0x84, 0x87,
	0x87, 0x89, 0x89, 0x8B, 0x8A, 0x82, 0x82, 0x7A, 0x78, 0x7B, 0x77, 0x7B,
	0x7B, 0x79, 0x7F, 0x7F, 0x83, 0x87, 0x86, 0x86, 0x85, 0x82, 0x82, 0x81,
	0x7E, 0x7D, 0x7B, 0x7A, 0x7B, 0x7C, 0x7F, 0x81, 0x82, 0x83, 0x83, 0x84,
	0x84, 0x84, 0x83, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x82, 0x83, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F,
	0x7E, 0x83, 0x95, 0x97, 0x9F, 0xA3, 0x95, 0x98, 0x93, 0x8C, 0x90, 0x84,
	0x7C, 0x77, 0x70, 0x73, 0x75, 0x79, 0x7B, 0x7D, 0x81, 0x83, 0x8A, 0x8D,
	0x8D, 0x8E, 0x88, 0x85, 0x84, 0x7F, 0x7F, 0x7B, 0x77, 0x76, 0x74, 0x77,
	0x78, 0x7B, 0x7E, 0x7E, 0x81, 0x83, 0x85, 0x87, 0x86, 0x86, 0x85, 0x82,
	0x81, 0x7F, 0x7E, 0x7D, 0x7B, 0x7A, 0x7A, 0x7B, 0x7C, 0x7D, 0x7F, 0x80,
	0x81, 0x82, 0x83, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x84, 0x93,
	0x98, 0x9B, 0xA0, 0x98, 0x96, 0x96, 0x91, 0x90, 0x89, 0x81, 0x7B, 0x74,
	0x74, 0x74, 0x74, 0x77, 0x75, 0x78, 0x7C, 0x80, 0x87, 0x89, 0x8B, 0x8C,
	0x8A, 0x8B, 0x8A, 0x88, 0x87, 0x82, 0x7E, 0x7C, 0x79, 0x79, 0x78, 0x78,
	0x79, 0x79, 0x7B, 0x7E, 0x80, 0x83, 0x84, 0x85, 0x86, 0x86, 0x86, 0x86,
	0x85, 0x83, 0x81, 0x7F, 0x7E, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C,
	0x7E, 0x7F, 0x81, 0x81, 0x82, 0x83, 0x83, 0x84, 0x83, 0x83, 0x82, 0x81,
	0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x82, 0x8F, 0x92, 0x95, 0x97,
	0x93, 0x94, 0x94, 0x94, 0x93, 0x8B, 0x86, 0x81, 0x7B, 0x7C, 0x7A, 0x78,
	0x78, 0x76, 0x78, 0x7B, 0x7F, 0x84, 0x85, 0x87, 0x88, 0x88, 0x8A, 0x8B,
	0x8A, 0x88, 0x84, 0x82, 0x80, 0x7E, 0x7D, 0x7B, 0x7A, 0x79, 0x79, 0x7A,
	0x7C, 0x7E, 0x80, 0x81, 0x82, 0x83, 0x85, 0x87, 0x87, 0x87, 0x86, 0x84,
	0x83, 0x82, 0x81, 0x7F, 0x7D, 0x7C, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x80,
	0x80, 0x7F, 0x7E, 0x80, 0x8A, 0x8E, 0x90, 0x93, 0x91, 0x91, 0x92, 0x92,
	0x92, 0x8D, 0x89, 0x85, 0x80, 0x7F, 0x7E, 0x7C, 0x7A, 0x78, 0x79, 0x7A,
	0x7D, 0x80, 0x82, 0x83, 0x85, 0x86, 0x88, 0x89, 0x89, 0x88, 0x86, 0x85,
	0x83, 0x81, 0x80, 0x7E, 0x7D, 0x7B, 0x7A, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E,
	0x7F, 0x81, 0x82, 0x83, 0x84, 0x85, 0x84, 0x84, 0x83, 0x82, 0x82, 0x80,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x81,
	0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x87,
	0x8B, 0x8B, 0x8E, 0x8D, 0x8D, 0x8E, 0x8E, 0x8F, 0x8C, 0x89, 0x86, 0x83,
	0x82, 0x81, 0x80, 0x7E, 0x7C, 0x7C, 0x7C, 0x7E, 0x80, 0x81, 0x82, 0x83,
	0x84, 0x86, 0x87, 0x88, 0x88, 0x87, 0x86, 0x85, 0x84, 0x83, 0x82, 0x80,
	0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81,
	0x82, 0x83, 0x83, 0x83, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x81, 0x82, 0x81, 0x83, 0x88, 0x89, 0x8A, 0x8B, 0x8B, 0x8B,
	0x8B, 0x8C, 0x8C, 0x8A, 0x88, 0x86, 0x84, 0x84, 0x83, 0x82, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x82, 0x83, 0x84, 0x85, 0x85,
	0x85, 0x84, 0x85, 0x85, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x86, 0x87, 0x88, 0x89, 0x89, 0x89, 0x8A, 0x8C, 0x8B, 0x8A, 0x89, 0x88,
	0x87, 0x86, 0x86, 0x85, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x82, 0x83, 0x84, 0x83, 0x84, 0x84, 0x84, 0x85, 0x85, 0x86, 0x86,
	0x85, 0x85, 0x84, 0x83, 0x83, 0x83, 0x82, 0x80, 0x7E, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7C, 0x7B, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7C, 0x7B, 0x7C,
	0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81,
	0x82, 0x84, 0x85, 0x86, 0x86, 0x86, 0x86, 0x86, 0x87, 0x87, 0x87, 0x87,
	0x87, 0x86, 0x86, 0x86, 0x86, 0x86, 0x87, 0x88, 0x88, 0x88, 0x89, 0x89,
	0x89, 0x89, 0x89, 0x89, 0x89, 0x88, 0x88, 0x88, 0x89, 0x89, 0x8A, 0x8A,
	0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8A, 0x8A, 0x8A, 0x88, 0x87,
	0x87, 0x86, 0x85, 0x85, 0x84, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80
};
const unsigned char WAV18[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7E, 0x83, 0x88, 0x84, 0x90, 0x88,
	0x8A, 0x8C, 0x80, 0x84, 0x7B, 0x79, 0x7A, 0x76, 0x79, 0x7C, 0x7B, 0x80,
	0x82, 0x80, 0x85, 0x82, 0x81, 0x83, 0x7C, 0x80, 0x7D, 0x7C, 0x7F, 0x7B,
	0x7F, 0x7F, 0x80, 0x81, 0x82, 0x80, 0x82, 0x80, 0x7F, 0x80, 0x7E, 0x7F,
	0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x80, 0x7E, 0x81, 0x7E, 0x84, 0x99, 0x88,
	0xA9, 0x9C, 0x97, 0xA7, 0x81, 0x8F, 0x7A, 0x6D, 0x74, 0x64, 0x6A, 0x72,
	0x6E, 0x7D, 0x82, 0x81, 0x8F, 0x87, 0x87, 0x8C, 0x7C, 0x83, 0x7C, 0x76,
	0x80, 0x74, 0x7E, 0x7E, 0x7C, 0x84, 0x81, 0x82, 0x85, 0x80, 0x83, 0x81,
	0x7D, 0x81, 0x7C, 0x7D, 0x80, 0x7B, 0x81, 0x7F, 0x7E, 0x83, 0x7E, 0x81,
	0x80, 0x80, 0x7F, 0x82, 0x7C, 0x82, 0x7D, 0x80, 0x7F, 0x7F, 0x7E, 0x89,
	0x9A, 0x8A, 0xB4, 0x97, 0xA6, 0xA8, 0x84, 0x9D, 0x73, 0x77, 0x72, 0x5E,
	0x6E, 0x67, 0x6A, 0x7B, 0x76, 0x83, 0x8C, 0x84, 0x92, 0x8A, 0x86, 0x8D,
	0x7B, 0x84, 0x7D, 0x77, 0x7F, 0x76, 0x7C, 0x7E, 0x7A, 0x83, 0x80, 0x7F,
	0x87, 0x7D, 0x85, 0x81, 0x7E, 0x83, 0x7C, 0x7F, 0x80, 0x7C, 0x81, 0x7D,
	0x7E, 0x82, 0x7B, 0x83, 0x7D, 0x7F, 0x81, 0x7E, 0x81, 0x81, 0x7D, 0x84,
	0x7A, 0x8F, 0x96, 0x8C, 0xB7, 0x93, 0xB0, 0xA7, 0x8B, 0xA6, 0x73, 0x84,
	0x71, 0x5F, 0x70, 0x5B, 0x69, 0x6E, 0x6A, 0x7E, 0x7C, 0x81, 0x8E, 0x84,
	0x90, 0x8C, 0x85, 0x8E, 0x7E, 0x84, 0x81, 0x78, 0x81, 0x77, 0x7C, 0x7E,
	0x79, 0x82, 0x7D, 0x7F, 0x83, 0x7D, 0x83, 0x80, 0x7F, 0x82, 0x7E, 0x80,
	0x80, 0x7C, 0x81, 0x7C, 0x80, 0x7E, 0x7E, 0x80, 0x7E, 0x81, 0x7F, 0x80,
	0x80, 0x81, 0x80, 0x99, 0x87, 0xA6, 0xA4, 0x9B, 0xBB, 0x8F, 0xAC, 0x8E,
	0x82, 0x8A, 0x64, 0x76, 0x61, 0x60, 0x6C, 0x5F, 0x73, 0x72, 0x78, 0x87,
	0x81, 0x8E, 0x8D, 0x8C, 0x91, 0x8A, 0x89, 0x88, 0x7F, 0x82, 0x7B, 0x7A,
	0x7C, 0x76, 0x7C, 0x7A, 0x7A, 0x80, 0x7B, 0x82, 0x80, 0x80, 0x84, 0x7F,
	0x84, 0x80, 0x81, 0x81, 0x7E, 0x80, 0x7E, 0x7D, 0x7F, 0x7D, 0x7F, 0x7F,
	0x7F, 0x7F, 0x81, 0x7C, 0x8D, 0x8D, 0x90, 0xAA, 0x93, 0xB3, 0x9E, 0xA0,
	0xA6, 0x85, 0x98, 0x76, 0x79, 0x72, 0x62, 0x6C, 0x5F, 0x66, 0x6B, 0x69,
	0x77, 0x78, 0x7E, 0x89, 0x85, 0x8F, 0x8D, 0x8C, 0x91, 0x87, 0x8B, 0x84,
	0x81, 0x82, 0x7A, 0x7D, 0x78, 0x78, 0x7A, 0x78, 0x7C, 0x7C, 0x7C, 0x81,
	0x7E, 0x83, 0x81, 0x82, 0x84, 0x81, 0x83, 0x82, 0x80, 0x82, 0x7E, 0x80,
	0x7F, 0x7D, 0x80, 0x7D, 0x7F, 0x7E, 0x8E, 0x85, 0x9C, 0x99, 0x9C, 0xAB,
	0x96, 0xAB, 0x92, 0x97, 0x8D, 0x7D, 0x80, 0x6E, 0x70, 0x6A, 0x66, 0x6A,
	0x69, 0x6C, 0x74, 0x74, 0x7E, 0x7F, 0x84, 0x8A, 0x88, 0x8E, 0x8A, 0x8B,
	0x8A, 0x86, 0x86, 0x82, 0x80, 0x7E, 0x7C, 0x7B, 0x7B, 0x79, 0x7C, 0x7A,
	0x7D, 0x7E, 0x7F, 0x82, 0x80, 0x84, 0x82, 0x84, 0x83, 0x83, 0x82, 0x82,
	0x80, 0x81, 0x7D, 0x80, 0x7D, 0x7E, 0x7D, 0x83, 0x88, 0x87, 0x9A, 0x8F,
	0xA3, 0x9A, 0x9D, 0xA1, 0x91, 0x9A, 0x88, 0x88, 0x7F, 0x79, 0x76, 0x71,
	0x6E, 0x70, 0x6D, 0x71, 0x73, 0x73, 0x7C, 0x79, 0x81, 0x81, 0x83, 0x86,
	0x84, 0x87, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7D, 0x7F, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x88, 0x85, 0x8E,
	0x8F, 0x91, 0x98, 0x93, 0x98, 0x93, 0x91, 0x8E, 0x88, 0x85, 0x7F, 0x7B,
	0x77, 0x75, 0x72, 0x73, 0x72, 0x74, 0x75, 0x77, 0x7A, 0x7B, 0x7E, 0x80,
	0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x83,
	0x83, 0x87, 0x88, 0x8A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8B, 0x8A, 0x88, 0x86,
	0x85, 0x83, 0x81, 0x80, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84,
	0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82,
	0x82, 0x82, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x7E,
	0x80, 0x80, 0x7D, 0x80, 0x80, 0x7D, 0x7F, 0x82, 0x7F, 0x80, 0x80, 0x7D,
	0x80, 0x81, 0x80, 0x82, 0x81, 0x7D, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x7E,
	0x7F, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7D, 0x7F, 0x7F, 0x7D, 0x80, 0x81, 0x7F, 0x81, 0x83, 0x81, 0x80, 0x82,
	0x80, 0x7F, 0x81, 0x7E, 0x7C, 0x81, 0x80, 0x7E, 0x81, 0x83, 0x80, 0x83,
	0x83, 0x7F, 0x82, 0x81, 0x7D, 0x7F, 0x7D, 0x7D, 0x7E, 0x7C, 0x7C, 0x7F,
	0x7F, 0x7D, 0x81, 0x81, 0x7D, 0x82, 0x82, 0x7E, 0x80, 0x7F, 0x7D, 0x7D,
	0x81, 0x7C, 0x7E, 0x82, 0x7C, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x80, 0x7E, 0x7F, 0x81,
	0x7C, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x82, 0x80, 0x80, 0x80,
	0x81, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x82, 0x80, 0x7E, 0x81, 0x7E, 0x7F,
	0x80, 0x7D, 0x7F, 0x81, 0x7E, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x80, 0x7E,
	0x82, 0x7F, 0x81, 0x83, 0x80, 0x81, 0x82, 0x7F, 0x7F, 0x82, 0x7D, 0x7F,
	0x7F, 0x7D, 0x80, 0x7E, 0x7C, 0x81, 0x80, 0x7D, 0x80, 0x82, 0x7D, 0x80,
	0x81, 0x7B, 0x82, 0x80, 0x7D, 0x83, 0x81, 0x7E, 0x82, 0x82, 0x7D, 0x82,
	0x81, 0x7C, 0x81, 0x81, 0x7D, 0x81, 0x82, 0x7F, 0x82, 0x82, 0x80, 0x80,
	0x82, 0x7F, 0x7E, 0x80, 0x7C, 0x7F, 0x7F, 0x7D, 0x7F, 0x80, 0x7E, 0x80,
	0x81, 0x7D, 0x82, 0x7F, 0x7E, 0x81, 0x7E, 0x7D, 0x81, 0x7E, 0x7E, 0x82,
	0x7C, 0x7F, 0x7F, 0x7D, 0x7D, 0x7F, 0x7D, 0x7D, 0x80, 0x7C, 0x80, 0x80,
	0x82, 0x82, 0x84, 0x83, 0x83, 0x83, 0x80, 0x80, 0x7F, 0x7E, 0x7D, 0x7B,
	0x7A, 0x7B, 0x79, 0x7B, 0x7C, 0x7C, 0x7C, 0x7E, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x7E, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x7E, 0x82, 0x84, 0x84, 0x8B, 0x8A, 0x8D, 0x8F, 0x8C, 0x8D, 0x8B, 0x88,
	0x86, 0x84, 0x80, 0x7F, 0x7C, 0x7C, 0x7B, 0x7A, 0x7B, 0x7B, 0x7C, 0x7D,
	0x7F, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x89, 0x88, 0x92, 0x96, 0x96, 0x9F, 0x99,
	0x9B, 0x97, 0x90, 0x8C, 0x84, 0x7F, 0x7A, 0x76, 0x72, 0x73, 0x71, 0x73,
	0x77, 0x78, 0x7D, 0x7F, 0x82, 0x85, 0x84, 0x86, 0x85, 0x84, 0x84, 0x82,
	0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7C, 0x7A, 0x7B, 0x79,
	0x7B, 0x7B, 0x7B, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x82, 0x8F, 0x8F, 0x9B,
	0xA4, 0xA1, 0xAE, 0xA4, 0xA4, 0x9F, 0x91, 0x8D, 0x7F, 0x78, 0x72, 0x6B,
	0x6B, 0x6A, 0x6C, 0x71, 0x76, 0x7B, 0x81, 0x84, 0x88, 0x8B, 0x8A, 0x8B,
	0x89, 0x86, 0x85, 0x81, 0x7F, 0x7D, 0x7B, 0x7A, 0x7A, 0x7A, 0x7B, 0x7C,
	0x7D, 0x7F, 0x7F, 0x81, 0x81, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x7F,
	0x7F, 0x7F, 0x7D, 0x7F, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x92, 0x8E, 0xA3, 0xA7, 0xA3, 0xB5, 0x9E, 0xA8, 0x99, 0x8A,
	0x8C, 0x73, 0x76, 0x6B, 0x66, 0x6B, 0x66, 0x6E, 0x72, 0x77, 0x7E, 0x84,
	0x87, 0x8D, 0x8D, 0x8D, 0x8F, 0x87, 0x89, 0x82, 0x80, 0x7E, 0x78, 0x7A,
	0x77, 0x77, 0x79, 0x79, 0x7C, 0x7D, 0x80, 0x82, 0x85, 0x86, 0x86, 0x87,
	0x85, 0x86, 0x82, 0x82, 0x80, 0x7D, 0x7D, 0x7B, 0x7B, 0x7C, 0x7B, 0x7E,
	0x7D, 0x7F, 0x7F, 0x81, 0x81, 0x83, 0x7F, 0x8B, 0x95, 0x95, 0xB1, 0xA2,
	0xB2, 0xAC, 0x9B, 0xA5, 0x85, 0x89, 0x7A, 0x6B, 0x72, 0x62, 0x69, 0x6A,
	0x6A, 0x76, 0x77, 0x7E, 0x86, 0x87, 0x8D, 0x8F, 0x8B, 0x8F, 0x88, 0x86,
	0x85, 0x7D, 0x7E, 0x79, 0x77, 0x79, 0x76, 0x79, 0x7B, 0x7A, 0x81, 0x7F,
	0x82, 0x85, 0x82, 0x86, 0x83, 0x83, 0x84, 0x7F, 0x82, 0x7E, 0x7E, 0x7E,
	0x7B, 0x7E, 0x7C, 0x7E, 0x7E, 0x7E, 0x80, 0x80, 0x81, 0x80, 0x83, 0x7F,
	0x80, 0x7B, 0x8D, 0x91, 0x9C, 0xB4, 0xA1, 0xBB, 0xA1, 0x9E, 0x9C, 0x7B,
	0x89, 0x6B, 0x6F, 0x6B, 0x62, 0x6E, 0x68, 0x72, 0x78, 0x7D, 0x83, 0x8A,
	0x8A, 0x8F, 0x8E, 0x8B, 0x8D, 0x84, 0x85, 0x7E, 0x7A, 0x7A, 0x74, 0x76,
	0x76, 0x76, 0x7A, 0x7C, 0x7E, 0x83, 0x83, 0x86, 0x87, 0x85, 0x87, 0x83,
	0x83, 0x81, 0x7E, 0x7E, 0x7B, 0x7B, 0x7C, 0x79, 0x7E, 0x7C, 0x7E, 0x80,
	0x7F, 0x84, 0x81, 0x84, 0x82, 0x83, 0x82, 0x82, 0x7E, 0x82, 0x7A, 0x90,
	0x96, 0xA1, 0xBC, 0xA5, 0xBE, 0xA1, 0x9C, 0x9B, 0x7B, 0x8B, 0x70, 0x71,
	0x6F, 0x62, 0x6E, 0x6A, 0x73, 0x7D, 0x82, 0x89, 0x92, 0x90, 0x95, 0x94,
	0x8D, 0x91, 0x82, 0x83, 0x7B, 0x73, 0x76, 0x6E, 0x72, 0x73, 0x74, 0x7C,
	0x7D, 0x83, 0x87, 0x89, 0x8B, 0x8C, 0x89, 0x89, 0x85, 0x81, 0x80, 0x79,
	0x7B, 0x76, 0x78, 0x78, 0x79, 0x7C, 0x7D, 0x82, 0x82, 0x86, 0x85, 0x88,
	0x85, 0x85, 0x83, 0x81, 0x7F, 0x7D, 0x7C, 0x7B, 0x78, 0x7F, 0x94, 0x95,
	0xB4, 0xAF, 0xB0, 0xB3, 0x95, 0xA3, 0x87, 0x88, 0x81, 0x6D, 0x71, 0x61,
	0x67, 0x6A, 0x73, 0x7D, 0x88, 0x8D, 0x94, 0x97, 0x94, 0x9C, 0x91, 0x93,
	0x89, 0x7E, 0x7C, 0x6E, 0x70, 0x6D, 0x6E, 0x73, 0x75, 0x7B, 0x80, 0x85,
	0x8C, 0x90, 0x92, 0x92, 0x8E, 0x89, 0x85, 0x7E, 0x7C, 0x76, 0x75, 0x73,
	0x72, 0x75, 0x77, 0x7C, 0x81, 0x85, 0x89, 0x8B, 0x8A, 0x8B, 0x88, 0x87,
	0x83, 0x7F, 0x7C, 0x79, 0x76, 0x77, 0x75, 0x7C, 0x78, 0x8B, 0x9A, 0xA2,
	0xBD, 0xAB, 0xB7, 0xA3, 0x95, 0x99, 0x7F, 0x87, 0x76, 0x6D, 0x6B, 0x62,
	0x6B, 0x73, 0x7D, 0x8A, 0x91, 0x92, 0x99, 0x95, 0x97, 0x98, 0x8E, 0x8E,
	0x80, 0x79, 0x76, 0x6E, 0x73, 0x73, 0x76, 0x7D, 0x7C, 0x83, 0x88, 0x8A,
	0x91, 0x8F, 0x8E, 0x8C, 0x84, 0x81, 0x7D, 0x79, 0x78, 0x76, 0x75, 0x77,
	0x76, 0x7C, 0x7F, 0x83, 0x88, 0x87, 0x88, 0x86, 0x82, 0x80, 0x7F, 0x7A,
	0x7D, 0x77, 0x79, 0x78, 0x76, 0x7D, 0x7B, 0x82, 0x83, 0x83, 0x86, 0x99,
	0x9B, 0xAF, 0xB1, 0xA4, 0xAB, 0x89, 0x90, 0x81, 0x7A, 0x82, 0x6D, 0x75,
	0x6A, 0x6E, 0x78, 0x7F, 0x8B, 0x92, 0x93, 0x92, 0x93, 0x8B, 0x90, 0x88,
	0x84, 0x82, 0x73, 0x76, 0x6D, 0x71, 0x77, 0x77, 0x81, 0x80, 0x85, 0x88,
	0x89, 0x8C, 0x8D, 0x8A, 0x87, 0x81, 0x7D, 0x7C, 0x79, 0x7B, 0x7A, 0x7A,
	0x7C, 0x7B, 0x80, 0x82, 0x85, 0x87, 0x86, 0x87, 0x84, 0x83, 0x81, 0x7F,
	0x7E, 0x7C, 0x7B, 0x7A, 0x7A, 0x7C, 0x7D, 0x80, 0x81, 0x83, 0x82, 0x85,
	0x7F, 0x92, 0x96, 0x9E, 0xAD, 0x97, 0xA3, 0x8B, 0x8A, 0x8B, 0x7B, 0x85,
	0x73, 0x74, 0x72, 0x71, 0x7C, 0x81, 0x88, 0x8B, 0x8D, 0x8A, 0x90, 0x8B,
	0x8D, 0x8A, 0x80, 0x81, 0x75, 0x78, 0x76, 0x76, 0x7C, 0x79, 0x7E, 0x80,
	0x83, 0x87, 0x89, 0x89, 0x88, 0x85, 0x82, 0x81, 0x7D, 0x7D, 0x7B, 0x79,
	0x7A, 0x79, 0x7C, 0x7E, 0x80, 0x84, 0x83, 0x85, 0x84, 0x84, 0x84, 0x82,
	0x81, 0x7F, 0x7F, 0x7D, 0x7D, 0x7D, 0x7D, 0x7F, 0x7E, 0x80, 0x81, 0x81,
	0x84, 0x80, 0x85, 0x7F, 0x88, 0x98, 0x96, 0xAC, 0x9D, 0x9C, 0x98, 0x85,
	0x91, 0x80, 0x82, 0x7B, 0x70, 0x73, 0x73, 0x7B, 0x83, 0x89, 0x88, 0x8F,
	0x8B, 0x8D, 0x91, 0x89, 0x8C, 0x80, 0x7B, 0x7B, 0x73, 0x7A, 0x77, 0x79,
	0x7C, 0x7B, 0x81, 0x84, 0x87, 0x8A, 0x89, 0x86, 0x85, 0x82, 0x7F, 0x7F,
	0x7B, 0x7B, 0x79, 0x78, 0x7C, 0x7C, 0x80, 0x81, 0x82, 0x84, 0x84, 0x85,
	0x85, 0x83, 0x82, 0x80, 0x7D, 0x7C, 0x7C, 0x7B, 0x7D, 0x7C, 0x7E, 0x7F,
	0x80, 0x82, 0x83, 0x82, 0x84, 0x81, 0x81, 0x7F, 0x81, 0x95, 0x93, 0xA3,
	0xA0, 0x93, 0x9A, 0x86, 0x8E, 0x88, 0x7D, 0x80, 0x70, 0x73, 0x74, 0x78,
	0x81, 0x84, 0x87, 0x87, 0x8B, 0x8A, 0x8F, 0x8C, 0x87, 0x86, 0x7A, 0x7C,
	0x79, 0x78, 0x7D, 0x7A, 0x7B, 0x7F, 0x7F, 0x84, 0x87, 0x87, 0x88, 0x85,
	0x83, 0x83, 0x7F, 0x7E, 0x7E, 0x7A, 0x7B, 0x7A, 0x7B, 0x7F, 0x7F, 0x81,
	0x83, 0x82, 0x84, 0x84, 0x83, 0x83, 0x7F, 0x7E, 0x7C, 0x7A, 0x7B, 0x7B,
	0x7C, 0x7D, 0x7D, 0x7F, 0x80, 0x82, 0x83, 0x83, 0x82, 0x82, 0x80, 0x80,
	0x7E, 0x82, 0x95, 0x94, 0xA3, 0xA1, 0x93, 0x9B, 0x89, 0x8C, 0x8C, 0x7B,
	0x80, 0x73, 0x70, 0x78, 0x76, 0x80, 0x83, 0x83, 0x87, 0x89, 0x8C, 0x8C,
	0x8D, 0x88, 0x84, 0x81, 0x7A, 0x7C, 0x79, 0x78, 0x7A, 0x77, 0x7B, 0x7E,
	0x80, 0x85, 0x85, 0x86, 0x86, 0x85, 0x84, 0x83, 0x82, 0x7E, 0x7D, 0x7B,
	0x7A, 0x7C, 0x7B, 0x7D, 0x7E, 0x7E, 0x81, 0x81, 0x82, 0x84, 0x83, 0x83,
	0x82, 0x80, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F,
	0x81, 0x82, 0x83, 0x85, 0x83, 0x83, 0x83, 0x91, 0x9A, 0x9B, 0xA4, 0x98,
	0x94, 0x94, 0x8A, 0x8D, 0x87, 0x7D, 0x79, 0x72, 0x73, 0x75, 0x79, 0x7D,
	0x7D, 0x82, 0x83, 0x87, 0x8D, 0x8B, 0x8D, 0x8A, 0x86, 0x85, 0x81, 0x81,
	0x7E, 0x7A, 0x79, 0x77, 0x77, 0x79, 0x7A, 0x7E, 0x7E, 0x7F, 0x82, 0x83,
	0x85, 0x86, 0x85, 0x85, 0x83, 0x82, 0x81, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B,
	0x7B, 0x7D, 0x7D, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83,
	0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F,
	0x7F, 0x8B, 0x96, 0x97, 0x9F, 0x9B, 0x96, 0x98, 0x94, 0x94, 0x91, 0x87,
	0x83, 0x7A, 0x76, 0x78, 0x75, 0x77, 0x76, 0x76, 0x7A, 0x7C, 0x82, 0x87,
	0x88, 0x8B, 0x8A, 0x8A, 0x8B, 0x8A, 0x89, 0x86, 0x81, 0x7F, 0x7B, 0x7A,
	0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7F, 0x82, 0x84, 0x85, 0x86, 0x86,
	0x85, 0x86, 0x85, 0x84, 0x82, 0x80, 0x7F, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C,
	0x7C, 0x7C, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x84, 0x84, 0x84, 0x85, 0x84,
	0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x85, 0x8F, 0x90, 0x93, 0x94,
	0x90, 0x92, 0x92, 0x93, 0x91, 0x8A, 0x86, 0x80, 0x7D, 0x7D, 0x7B, 0x7A,
	0x7A, 0x7A, 0x7C, 0x7E, 0x82, 0x85, 0x87, 0x88, 0x89, 0x89, 0x8A, 0x8A,
	0x89, 0x86, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7B, 0x7A, 0x7A, 0x7A, 0x7C,
	0x7D, 0x7F, 0x81, 0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81,
	0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F,
	0x7E, 0x84, 0x8C, 0x8D, 0x90, 0x90, 0x8E, 0x90, 0x90, 0x91, 0x8F, 0x8A,
	0x87, 0x82, 0x7F, 0x7F, 0x7D, 0x7C, 0x7A, 0x79, 0x7A, 0x7B, 0x7F, 0x81,
	0x82, 0x84, 0x84, 0x86, 0x87, 0x88, 0x88, 0x86, 0x85, 0x83, 0x81, 0x80,
	0x7F, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81,
	0x83, 0x83, 0x84, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x82, 0x88, 0x8A, 0x8B, 0x8D,
	0x8C, 0x8C, 0x8C, 0x8D, 0x8D, 0x8A, 0x87, 0x83, 0x81, 0x80, 0x7F, 0x7E,
	0x7C, 0x7B, 0x7B, 0x7C, 0x7E, 0x80, 0x81, 0x82, 0x83, 0x84, 0x86, 0x87,
	0x88, 0x87, 0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x7F, 0x7E, 0x7D, 0x7C,
	0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x82, 0x83, 0x83,
	0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7D,
	0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82,
	0x82, 0x83, 0x88, 0x89, 0x89, 0x8B, 0x8A, 0x8A, 0x8A, 0x8B, 0x8B, 0x89,
	0x87, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84,
	0x84, 0x83, 0x83, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x84, 0x86, 0x86, 0x88,
	0x88, 0x88, 0x89, 0x8A, 0x8A, 0x89, 0x88, 0x88, 0x87, 0x86, 0x86, 0x85,
	0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82,
	0x83, 0x83, 0x84, 0x86, 0x87, 0x87, 0x86, 0x86, 0x85, 0x86, 0x87, 0x86,
	0x85, 0x84, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7D, 0x7C,
	0x7D, 0x7C, 0x7B, 0x7C, 0x7C, 0x7C, 0x7B, 0x7C, 0x7B, 0x7B, 0x7B, 0x7B,
	0x7B, 0x7B, 0x7B, 0x7B, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x82,
	0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x85, 0x84, 0x84, 0x84, 0x84, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x84, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x83, 0x84, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80
};
const unsigned char WAV19[] = {
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x83, 0x86, 0x89, 0x8B, 0x8B, 0x8B, 0x8A, 0x8A,
	0x89, 0x88, 0x86, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7B, 0x7B,
	0x7C, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x82, 0x83, 0x83, 0x84, 0x84, 0x83,
	0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x86, 0x8E, 0x94, 0x99, 0x97, 0x96, 0x95, 0x95, 0x95,
	0x92, 0x8E, 0x86, 0x81, 0x7D, 0x7A, 0x7A, 0x78, 0x77, 0x76, 0x76, 0x79,
	0x7C, 0x80, 0x82, 0x84, 0x85, 0x85, 0x87, 0x87, 0x88, 0x86, 0x84, 0x82,
	0x80, 0x7F, 0x7D, 0x7D, 0x7C, 0x7A, 0x7A, 0x7A, 0x7B, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x7F, 0x89, 0x94, 0x9A, 0xA2, 0xA0, 0x9F, 0x9D, 0x9D, 0x9D,
	0x99, 0x95, 0x8B, 0x84, 0x7E, 0x7A, 0x79, 0x76, 0x76, 0x74, 0x73, 0x76,
	0x79, 0x7F, 0x82, 0x86, 0x88, 0x89, 0x8C, 0x8C, 0x8E, 0x8D, 0x8B, 0x88,
	0x84, 0x82, 0x80, 0x7E, 0x7C, 0x7A, 0x78, 0x77, 0x78, 0x79, 0x7B, 0x7D,
	0x7E, 0x80, 0x81, 0x83, 0x85, 0x85, 0x86, 0x86, 0x85, 0x84, 0x83, 0x82,
	0x81, 0x80, 0x7E, 0x7D, 0x86, 0x92, 0x98, 0xA1, 0xA1, 0x9F, 0xA0, 0x9F,
	0xA1, 0xA0, 0x9C, 0x94, 0x8C, 0x85, 0x7F, 0x7E, 0x7B, 0x79, 0x76, 0x73,
	0x74, 0x76, 0x7B, 0x7F, 0x83, 0x86, 0x88, 0x8B, 0x8D, 0x8F, 0x90, 0x90,
	0x8E, 0x8B, 0x88, 0x85, 0x83, 0x81, 0x7E, 0x7C, 0x79, 0x78, 0x77, 0x78,
	0x7A, 0x7B, 0x7D, 0x7E, 0x80, 0x82, 0x84, 0x86, 0x87, 0x87, 0x88, 0x88,
	0x88, 0x87, 0x86, 0x84, 0x82, 0x81, 0x7F, 0x7E, 0x87, 0x95, 0x99, 0xA1,
	0xA1, 0x9F, 0xA1, 0xA0, 0xA4, 0xA2, 0x9E, 0x96, 0x8D, 0x88, 0x83, 0x81,
	0x7E, 0x7B, 0x78, 0x74, 0x74, 0x76, 0x79, 0x7C, 0x7E, 0x80, 0x82, 0x84,
	0x87, 0x89, 0x8A, 0x8A, 0x89, 0x87, 0x86, 0x85, 0x83, 0x81, 0x7F, 0x7D,
	0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7F, 0x80, 0x82, 0x83,
	0x83, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7D,
	0x7E, 0x7D, 0x8D, 0xA0, 0xA5, 0xAB, 0xA8, 0xAA, 0xA6, 0xA2, 0x9F, 0x96,
	0x90, 0x85, 0x7F, 0x79, 0x77, 0x75, 0x73, 0x74, 0x73, 0x77, 0x77, 0x7A,
	0x7C, 0x7E, 0x81, 0x82, 0x85, 0x84, 0x85, 0x85, 0x84, 0x84, 0x82, 0x82,
	0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7E, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x7D, 0x98, 0xB2, 0xB6,
	0xB3, 0xAC, 0xAD, 0x9A, 0x84, 0x72, 0x72, 0x73, 0x6D, 0x72, 0x7C, 0x8A,
	0x88, 0x87, 0x87, 0x89, 0x82, 0x7A, 0x78, 0x7B, 0x7D, 0x79, 0x7D, 0x81,
	0x85, 0x82, 0x81, 0x82, 0x82, 0x80, 0x7C, 0x7D, 0x7F, 0x7E, 0x7C, 0x7F,
	0x82, 0x82, 0x80, 0x80, 0x81, 0x80, 0x7E, 0x7D, 0x7F, 0x7F, 0x80, 0x7E,
	0x81, 0x81, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x81, 0x7F, 0x81,
	0x7E, 0x82, 0x7E, 0x82, 0x7C, 0x9A, 0xCA, 0xCA, 0xB3, 0x92, 0x94, 0x7D,
	0x63, 0x55, 0x6C, 0x87, 0x89, 0x8D, 0x94, 0xA1, 0x8D, 0x7A, 0x6E, 0x77,
	0x75, 0x70, 0x77, 0x87, 0x92, 0x88, 0x85, 0x84, 0x86, 0x79, 0x71, 0x75,
	0x7F, 0x83, 0x7F, 0x84, 0x87, 0x88, 0x7D, 0x7A, 0x7C, 0x7E, 0x7C, 0x7B,
	0x81, 0x84, 0x85, 0x7E, 0x81, 0x7F, 0x80, 0x7B, 0x7C, 0x7F, 0x81, 0x80,
	0x7F, 0x82, 0x81, 0x80, 0x7B, 0x7D, 0x7E, 0x81, 0x7E, 0x80, 0x81, 0x83,
	0x7F, 0x80, 0x7B, 0xA9, 0xD3, 0xC8, 0x9E, 0x7C, 0x82, 0x72, 0x64, 0x5B,
	0x83, 0x9D, 0x9F, 0x8E, 0x8B, 0x8F, 0x7D, 0x6B, 0x64, 0x7A, 0x7F, 0x81,
	0x7E, 0x8B, 0x8E, 0x84, 0x77, 0x73, 0x7D, 0x7C, 0x7D, 0x7C, 0x87, 0x89,
	0x85, 0x7C, 0x7B, 0x7E, 0x7D, 0x7B, 0x7C, 0x83, 0x85, 0x83, 0x7E, 0x80,
	0x7F, 0x7F, 0x7B, 0x7E, 0x82, 0x85, 0x82, 0x80, 0x7F, 0x80, 0x7E, 0x7D,
	0x7D, 0x80, 0x82, 0x81, 0x80, 0x7F, 0x81, 0x7F, 0x7F, 0x7D, 0x81, 0x7F,
	0x82, 0x7D, 0xB3, 0xD9, 0xCE, 0x90, 0x6A, 0x72, 0x73, 0x6D, 0x60, 0x86,
	0xA3, 0xAF, 0x8B, 0x78, 0x72, 0x79, 0x71, 0x6B, 0x7B, 0x8E, 0x9C, 0x8A,
	0x80, 0x77, 0x7D, 0x76, 0x74, 0x77, 0x86, 0x8D, 0x8A, 0x81, 0x7D, 0x7D,
	0x7B, 0x79, 0x79, 0x81, 0x88, 0x8A, 0x84, 0x7F, 0x7C, 0x7D, 0x7B, 0x7C,
	0x7E, 0x84, 0x85, 0x84, 0x80, 0x7D, 0x7E, 0x7D, 0x7D, 0x7E, 0x81, 0x82,
	0x83, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x80, 0x80, 0x82, 0x77, 0x7A,
	0x75, 0x8F, 0xCF, 0xE8, 0xC0, 0x6E, 0x53, 0x60, 0x7A, 0x75, 0x7A, 0x94,
	0xB1, 0xAB, 0x80, 0x63, 0x61, 0x77, 0x7B, 0x7E, 0x83, 0x96, 0x99, 0x89,
	0x72, 0x6B, 0x74, 0x7D, 0x7E, 0x7D, 0x86, 0x8D, 0x8B, 0x7D, 0x74, 0x75,
	0x7D, 0x80, 0x80, 0x80, 0x86, 0x87, 0x82, 0x7A, 0x79, 0x7B, 0x80, 0x80,
	0x81, 0x82, 0x83, 0x83, 0x7E, 0x7C, 0x7B, 0x80, 0x7F, 0x82, 0x82, 0x87,
	0x82, 0x80, 0x7B, 0x7D, 0x7E, 0x80, 0x7F, 0x81, 0x82, 0x82, 0x81, 0x7C,
	0x80, 0x7A, 0xB8, 0xE2, 0xDC, 0x8B, 0x54, 0x58, 0x74, 0x82, 0x72, 0x87,
	0xA0, 0xB8, 0x93, 0x71, 0x5C, 0x70, 0x7B, 0x7D, 0x7D, 0x89, 0x9B, 0x93,
	0x82, 0x6C, 0x72, 0x77, 0x81, 0x7C, 0x83, 0x88, 0x8E, 0x85, 0x7A, 0x74,
	0x79, 0x7F, 0x7F, 0x81, 0x82, 0x87, 0x84, 0x80, 0x79, 0x7C, 0x7C, 0x7E,
	0x7D, 0x80, 0x83, 0x84, 0x81, 0x7D, 0x7D, 0x7D, 0x7F, 0x7E, 0x80, 0x80,
	0x83, 0x81, 0x80, 0x7D, 0x7F, 0x7E, 0x80, 0x7E, 0x81, 0x80, 0x82, 0x7F,
	0x80, 0x7C, 0x85, 0xC4, 0xE3, 0xC9, 0x79, 0x5A, 0x68, 0x7A, 0x72, 0x6B,
	0x8C, 0xAC, 0xB0, 0x87, 0x6D, 0x69, 0x79, 0x76, 0x72, 0x7B, 0x91, 0x9C,
	0x8D, 0x7B, 0x72, 0x79, 0x7A, 0x78, 0x79, 0x85, 0x8E, 0x8C, 0x84, 0x7D,
	0x7D, 0x7C, 0x79, 0x79, 0x7F, 0x85, 0x87, 0x83, 0x80, 0x7F, 0x7E, 0x7C,
	0x7A, 0x7E, 0x81, 0x84, 0x81, 0x81, 0x80, 0x80, 0x7E, 0x7D, 0x7E, 0x7F,
	0x81, 0x81, 0x81, 0x80, 0x7C, 0x79, 0x7B, 0x7E, 0x81, 0x80, 0x81, 0x81,
	0x83, 0x7D, 0x80, 0x77, 0xA2, 0xD9, 0xD3, 0x9E, 0x6A, 0x76, 0x78, 0x6C,
	0x5A, 0x7C, 0xA4, 0xAB, 0x91, 0x7C, 0x83, 0x7F, 0x70, 0x60, 0x75, 0x8A,
	0x90, 0x85, 0x86, 0x8D, 0x86, 0x75, 0x6D, 0x78, 0x82, 0x80, 0x7E, 0x86,
	0x8C, 0x86, 0x7A, 0x79, 0x7D, 0x7E, 0x7A, 0x7C, 0x84, 0x87, 0x83, 0x7E,
	0x80, 0x80, 0x7E, 0x7A, 0x7B, 0x7F, 0x80, 0x80, 0x80, 0x83, 0x81, 0x7F,
	0x7D, 0x7F, 0x7E, 0x7F, 0x7E, 0x81, 0x81, 0x81, 0x7F, 0x80, 0x7F, 0x7F,
	0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x85, 0xC9, 0xD8, 0xB7, 0x84, 0x81, 0x7B,
	0x57, 0x57, 0x75, 0x9C, 0x8E, 0x94, 0x9E, 0xA1, 0x7D, 0x6A, 0x74, 0x77,
	0x70, 0x70, 0x8E, 0x94, 0x8C, 0x82, 0x8B, 0x85, 0x73, 0x6F, 0x7A, 0x82,
	0x7A, 0x7F, 0x8B, 0x8C, 0x7D, 0x7B, 0x81, 0x7C, 0x75, 0x79, 0x84, 0x82,
	0x7E, 0x83, 0x88, 0x80, 0x7A, 0x7F, 0x80, 0x7B, 0x7A, 0x81, 0x84, 0x7F,
	0x80, 0x83, 0x82, 0x7D, 0x7D, 0x81, 0x7F, 0x7C, 0x7F, 0x83, 0x7D, 0x7B,
	0x80, 0x7E, 0x7D, 0x7E, 0x82, 0x81, 0x80, 0xBF, 0xCC, 0xB0, 0xAD, 0xA5,
	0x86, 0x59, 0x67, 0x6F, 0x6C, 0x76, 0x96, 0xA1, 0x8E, 0x92, 0x8F, 0x80,
	0x69, 0x71, 0x78, 0x74, 0x7C, 0x8D, 0x90, 0x86, 0x8C, 0x89, 0x7D, 0x76,
	0x7A, 0x7A, 0x74, 0x7E, 0x84, 0x84, 0x82, 0x87, 0x86, 0x7D, 0x7E, 0x7E,
	0x7C, 0x79, 0x7F, 0x81, 0x7F, 0x82, 0x83, 0x82, 0x7E, 0x81, 0x7B, 0x7A,
	0x7B, 0x7C, 0x7D, 0x7E, 0x82, 0x81, 0x82, 0x83, 0x81, 0x80, 0x7E, 0x7F,
	0x7D, 0x7E, 0x7E, 0x80, 0x7F, 0x82, 0x7F, 0x8B, 0xBE, 0xB6, 0xB6, 0xBE,
	0xA7, 0x88, 0x73, 0x74, 0x5A, 0x5F, 0x70, 0x75, 0x7D, 0x8D, 0x99, 0x90,
	0x94, 0x93, 0x84, 0x7D, 0x7A, 0x76, 0x6E, 0x75, 0x7A, 0x79, 0x82, 0x87,
	0x88, 0x85, 0x8A, 0x84, 0x7F, 0x7F, 0x7C, 0x7A, 0x79, 0x7D, 0x80, 0x82,
	0x87, 0x88, 0x86, 0x86, 0x85, 0x82, 0x7F, 0x7F, 0x7D, 0x7B, 0x7C, 0x7D,
	0x7D, 0x7F, 0x81, 0x81, 0x82, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x81, 0x7F, 0x83, 0x80, 0x8E, 0xAB, 0xAD, 0xBA,
	0xBB, 0xAD, 0xA0, 0x95, 0x90, 0x80, 0x7D, 0x78, 0x6B, 0x6B, 0x6C, 0x71,
	0x76, 0x81, 0x89, 0x8A, 0x90, 0x91, 0x90, 0x8F, 0x8D, 0x89, 0x80, 0x7D,
	0x77, 0x70, 0x70, 0x6F, 0x6F, 0x70, 0x74, 0x76, 0x79, 0x7F, 0x83, 0x85,
	0x89, 0x8A, 0x8A, 0x88, 0x88, 0x86, 0x82, 0x81, 0x7D, 0x7B, 0x79, 0x78,
	0x78, 0x78, 0x7A, 0x7A, 0x7C, 0x7E, 0x7F, 0x81, 0x83, 0x85, 0x85, 0x85,
	0x85, 0x83, 0x83, 0x82, 0x80, 0x7F, 0x7D, 0x7D, 0x7B, 0x85, 0x94, 0x98,
	0xA2, 0xA4, 0x9F, 0x9D, 0x9C, 0x9C, 0x98, 0x95, 0x8E, 0x81, 0x7A, 0x74,
	0x71, 0x72, 0x73, 0x74, 0x73, 0x75, 0x78, 0x7D, 0x84, 0x89, 0x8D, 0x8F,
	0x8E, 0x8E, 0x8C, 0x8C, 0x8B, 0x88, 0x84, 0x7F, 0x7B, 0x78, 0x77, 0x77,
	0x77, 0x77, 0x78, 0x79, 0x7B, 0x7E, 0x81, 0x84, 0x86, 0x87, 0x87, 0x87,
	0x87, 0x86, 0x86, 0x84, 0x82, 0x80, 0x7D, 0x7C, 0x7B, 0x7A, 0x7A, 0x7A,
	0x7B, 0x7B, 0x7C, 0x7E, 0x7F, 0x81, 0x82, 0x83, 0x83, 0x84, 0x8B, 0x95,
	0x9B, 0xA3, 0xA3, 0xA0, 0x9E, 0x9A, 0x99, 0x96, 0x93, 0x8D, 0x86, 0x7F,
	0x79, 0x77, 0x76, 0x76, 0x77, 0x77, 0x78, 0x79, 0x7C, 0x80, 0x84, 0x88,
	0x8A, 0x8A, 0x8B, 0x8A, 0x8A, 0x89, 0x88, 0x86, 0x83, 0x81, 0x7E, 0x7C,
	0x7B, 0x7A, 0x7A, 0x79, 0x7A, 0x7A, 0x7B, 0x7C, 0x7E, 0x80, 0x81, 0x82,
	0x83, 0x83, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E,
	0x7D, 0x7C, 0x7C, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x81, 0x87,
	0x8D, 0x94, 0x98, 0x99, 0x99, 0x98, 0x97, 0x96, 0x95, 0x93, 0x8E, 0x8A,
	0x84, 0x80, 0x7D, 0x7B, 0x7A, 0x79, 0x78, 0x78, 0x78, 0x79, 0x7B, 0x7D,
	0x7F, 0x81, 0x83, 0x84, 0x85, 0x85, 0x86, 0x86, 0x86, 0x85, 0x84, 0x83,
	0x82, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7D, 0x7E, 0x80,
	0x84, 0x88, 0x8D, 0x90, 0x91, 0x91, 0x90, 0x90, 0x90, 0x90, 0x91, 0x90,
	0x8E, 0x8B, 0x88, 0x86, 0x85, 0x86, 0x89, 0x8B, 0x8D, 0x8E, 0x8F, 0x8F,
	0x90, 0x90, 0x90, 0x8F, 0x8D, 0x8B, 0x88, 0x85, 0x84, 0x84, 0x83, 0x83,
	0x83, 0x82, 0x80, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7C, 0x7B, 0x7B,
	0x7A, 0x7B, 0x7D, 0x7F, 0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x85, 0x85,
	0x86, 0x87, 0x87, 0x86, 0x85, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x80,
	0x7F, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7C,
	0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x83, 0x85, 0x86, 0x87, 0x87, 0x88,
	0x89, 0x89, 0x89, 0x89, 0x88, 0x87, 0x86, 0x85, 0x83, 0x82, 0x81, 0x80,
	0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7B, 0x7A, 0x79, 0x78, 0x78, 0x77, 0x76,
	0x76, 0x76, 0x75, 0x75, 0x75, 0x75, 0x76, 0x76, 0x76, 0x77, 0x77, 0x77,
	0x78, 0x78, 0x79, 0x7A, 0x7B, 0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83,
	0x83, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83,
	0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x83,
	0x83, 0x81, 0x81, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x81, 0x82, 0x81, 0x80, 0x80, 0x7F,
	0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7D, 0x7F, 0x80, 0x80, 0x81, 0x83, 0x81,
	0x84, 0x84, 0x81, 0x7F, 0x81, 0x7D, 0x7E, 0x81, 0x7E, 0x80, 0x82, 0x7E,
	0x7C, 0x83, 0x7F, 0x7E, 0x83, 0x7F, 0x7E, 0x82, 0x7F, 0x7E, 0x82, 0x83,
	0x7D, 0x82, 0x84, 0x7D, 0x81, 0x82, 0x7B, 0x7B, 0x81, 0x7A, 0x7F, 0x83,
	0x81, 0x81, 0x83, 0x81, 0x81, 0x83, 0x80, 0x82, 0x82, 0x82, 0x7F, 0x80,
	0x7E, 0x7E, 0x80, 0x7D, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x7D, 0x80,
	0x82, 0x7F, 0x80, 0x83, 0x81, 0x80, 0x82, 0x80, 0x7E, 0x81, 0x7F, 0x7C,
	0x80, 0x81, 0x7E, 0x81, 0x83, 0x80, 0x82, 0x85, 0x80, 0x7F, 0x81, 0x7E,
	0x7F, 0x7F, 0x7E, 0x80, 0x7E, 0x7E, 0x81, 0x80, 0x7F, 0x81, 0x7E, 0x7F,
	0x81, 0x7E, 0x81, 0x81, 0x7D, 0x80, 0x82, 0x7D, 0x81, 0x80, 0x7E, 0x80,
	0x81, 0x7F, 0x81, 0x80, 0x7E, 0x82, 0x80, 0x7E, 0x82, 0x81, 0x7E, 0x81,
	0x81, 0x7E, 0x80, 0x81, 0x7C, 0x80, 0x82, 0x7E, 0x80, 0x82, 0x7F, 0x80,
	0x83, 0x7F, 0x7E, 0x83, 0x7E, 0x7D, 0x81, 0x7D, 0x7D, 0x80, 0x80, 0x7D,
	0x83, 0x7E, 0x7E, 0x82, 0x7D, 0x80, 0x81, 0x7D, 0x7F, 0x83, 0x7D, 0x80,
	0x80, 0x7D, 0x80, 0x80, 0x7E, 0x7D, 0x81, 0x7C, 0x80, 0x81, 0x7E, 0x81,
	0x82, 0x7F, 0x80, 0x83, 0x7C, 0x82, 0x82, 0x7C, 0x82, 0x81, 0x7E, 0x81,
	0x81, 0x7E, 0x80, 0x81, 0x7C, 0x7F, 0x82, 0x7C, 0x80, 0x83, 0x7D, 0x80,
	0x84, 0x7E, 0x80, 0x83, 0x7E, 0x7F, 0x82, 0x7E, 0x7D, 0x81, 0x7D, 0x7E,
	0x82, 0x7D, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x81, 0x7D, 0x7E,
	0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x7F,
	0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x82, 0x7E, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x83, 0x82, 0x82, 0x83, 0x83, 0x81, 0x82, 0x80,
	0x80, 0x80, 0x7D, 0x7F, 0x7D, 0x7B, 0x7D, 0x7E, 0x7B, 0x7E, 0x7F, 0x7D,
	0x81, 0x80, 0x81, 0x84, 0x81, 0x84, 0x85, 0x82, 0x84, 0x84, 0x80, 0x80,
	0x80, 0x7B, 0x7E, 0x7D, 0x7C, 0x80, 0x7F, 0x80, 0x83, 0x82, 0x82, 0x86,
	0x83, 0x86, 0x86, 0x83, 0x85, 0x83, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x82,
	0x82, 0x85, 0x8A, 0x89, 0x8D, 0x8D, 0x8C, 0x8C, 0x8A, 0x88, 0x86, 0x83,
	0x80, 0x7F, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x88, 0x88, 0x90, 0x96, 0x95, 0x9D, 0x99, 0x99, 0x97,
	0x90, 0x8D, 0x85, 0x7F, 0x7B, 0x76, 0x74, 0x73, 0x72, 0x73, 0x77, 0x78,
	0x7D, 0x7F, 0x81, 0x85, 0x84, 0x86, 0x85, 0x84, 0x84, 0x82, 0x81, 0x80,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x82, 0x81, 0x81, 0x82, 0x81, 0x82,
	0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7D, 0x8A, 0x8C, 0x94, 0xA2, 0x9E,
	0xAC, 0xA6, 0xA3, 0xA3, 0x93, 0x90, 0x83, 0x7A, 0x74, 0x6D, 0x6B, 0x6A,
	0x6C, 0x6F, 0x75, 0x78, 0x7F, 0x83, 0x86, 0x8A, 0x8A, 0x8B, 0x8A, 0x87,
	0x86, 0x82, 0x81, 0x7D, 0x7C, 0x7B, 0x79, 0x7A, 0x7A, 0x7C, 0x7C, 0x7E,
	0x7F, 0x80, 0x82, 0x82, 0x83, 0x82, 0x82, 0x82, 0x80, 0x81, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x80,
	0x91, 0x8F, 0x9F, 0xA9, 0xA2, 0xB5, 0xA1, 0xA6, 0x9C, 0x8B, 0x8C, 0x76,
	0x76, 0x6E, 0x67, 0x6B, 0x69, 0x6D, 0x73, 0x77, 0x7E, 0x84, 0x87, 0x8C,
	0x8E, 0x8C, 0x8E, 0x89, 0x87, 0x85, 0x7E, 0x7F, 0x79, 0x78, 0x79, 0x75,
	0x7A, 0x78, 0x7C, 0x7E, 0x80, 0x83, 0x85, 0x87, 0x86, 0x89, 0x83, 0x87,
	0x82, 0x81, 0x81, 0x7B, 0x7F, 0x7A, 0x7C, 0x7C, 0x7A, 0x7F, 0x7C, 0x80,
	0x7E, 0x82, 0x81, 0x83, 0x81, 0x87, 0x98, 0x92, 0xB0, 0xA4, 0xAE, 0xB2,
	0x98, 0xA8, 0x87, 0x88, 0x7E, 0x6A, 0x74, 0x62, 0x69, 0x6B, 0x69, 0x76,
	0x76, 0x7E, 0x85, 0x88, 0x8C, 0x8F, 0x8C, 0x8E, 0x8A, 0x86, 0x86, 0x7D,
	0x7E, 0x79, 0x77, 0x78, 0x75, 0x79, 0x79, 0x7C, 0x7E, 0x80, 0x82, 0x84,
	0x85, 0x85, 0x85, 0x83, 0x83, 0x81, 0x80, 0x7F, 0x7D, 0x7D, 0x7C, 0x7C,
	0x7D, 0x7C, 0x7F, 0x7E, 0x80, 0x80, 0x81, 0x80, 0x83, 0x7F, 0x81, 0x7E,
	0x81, 0x9A, 0x8F, 0xB5, 0xA9, 0xAF, 0xB9, 0x94, 0xAA, 0x82, 0x84, 0x7C,
	0x65, 0x73, 0x60, 0x69, 0x6B, 0x6B, 0x77, 0x7A, 0x81, 0x89, 0x8B, 0x8E,
	0x92, 0x8C, 0x8E, 0x89, 0x84, 0x85, 0x7C, 0x7C, 0x79, 0x75, 0x78, 0x76,
	0x78, 0x7D, 0x7B, 0x82, 0x82, 0x84, 0x87, 0x84, 0x87, 0x86, 0x82, 0x84,
	0x7F, 0x7E, 0x7E, 0x7A, 0x7D, 0x7A, 0x7B, 0x7D, 0x7C, 0x80, 0x7F, 0x81,
	0x82, 0x82, 0x82, 0x83, 0x80, 0x83, 0x7E, 0x81, 0x7D, 0x81, 0x9A, 0x93,
	0xB7, 0xAD, 0xB0, 0xB5, 0x95, 0xA4, 0x84, 0x86, 0x7F, 0x6D, 0x74, 0x66,
	0x69, 0x6C, 0x6E, 0x78, 0x82, 0x85, 0x91, 0x91, 0x93, 0x98, 0x8E, 0x92,
	0x89, 0x82, 0x80, 0x74, 0x75, 0x70, 0x6F, 0x73, 0x73, 0x78, 0x7E, 0x80,
	0x86, 0x89, 0x8A, 0x8E, 0x8A, 0x8A, 0x87, 0x82, 0x81, 0x7B, 0x77, 0x77,
	0x71, 0x76, 0x74, 0x77, 0x7D, 0x7D, 0x83, 0x84, 0x86, 0x89, 0x87, 0x87,
	0x86, 0x82, 0x82, 0x7C, 0x7C, 0x78, 0x7A, 0x75, 0x8A, 0x92, 0xA1, 0xB9,
	0xA5, 0xBB, 0x9E, 0x9E, 0x9C, 0x84, 0x93, 0x76, 0x77, 0x6D, 0x63, 0x6D,
	0x6E, 0x79, 0x84, 0x89, 0x8E, 0x95, 0x91, 0x99, 0x97, 0x91, 0x93, 0x82,
	0x80, 0x76, 0x6F, 0x73, 0x6C, 0x74, 0x74, 0x76, 0x7E, 0x80, 0x88, 0x8D,
	0x8F, 0x90, 0x8E, 0x88, 0x87, 0x80, 0x7D, 0x7B, 0x75, 0x77, 0x72, 0x75,
	0x77, 0x7A, 0x80, 0x83, 0x86, 0x89, 0x88, 0x89, 0x88, 0x87, 0x84, 0x82,
	0x7C, 0x7B, 0x77, 0x78, 0x77, 0x77, 0x7A, 0x79, 0x96, 0x95, 0xB2, 0xB4,
	0xAB, 0xB4, 0x92, 0x9C, 0x88, 0x83, 0x83, 0x6F, 0x71, 0x64, 0x67, 0x6D,
	0x79, 0x81, 0x8F, 0x91, 0x93, 0x99, 0x90, 0x9A, 0x8F, 0x8F, 0x87, 0x78,
	0x77, 0x6A, 0x6F, 0x6E, 0x73, 0x77, 0x7C, 0x80, 0x84, 0x8B, 0x8C, 0x93,
	0x8F, 0x8E, 0x89, 0x80, 0x7F, 0x77, 0x78, 0x75, 0x74, 0x76, 0x75, 0x7A,
	0x7C, 0x82, 0x87, 0x88, 0x88, 0x88, 0x84, 0x82, 0x80, 0x7D, 0x7D, 0x79,
	0x78, 0x78, 0x76, 0x7B, 0x7B, 0x80, 0x81, 0x84, 0x82, 0x8F, 0x9D, 0xA1,
	0xB8, 0xA5, 0xAB, 0x98, 0x88, 0x8E, 0x77, 0x83, 0x74, 0x71, 0x71, 0x6A,
	0x76, 0x7B, 0x87, 0x8E, 0x94, 0x91, 0x93, 0x8F, 0x8C, 0x8E, 0x83, 0x84,
	0x78, 0x73, 0x73, 0x6E, 0x77, 0x78, 0x7D, 0x81, 0x82, 0x87, 0x89, 0x8C,
	0x8C, 0x8C, 0x86, 0x84, 0x7F, 0x7B, 0x7E, 0x77, 0x7C, 0x78, 0x79, 0x7D,
	0x7C, 0x84, 0x83, 0x86, 0x86, 0x85, 0x85, 0x84, 0x82, 0x81, 0x7F, 0x7C,
	0x7C, 0x7A, 0x7B, 0x7C, 0x7D, 0x80, 0x7F, 0x81, 0x82, 0x82, 0x86, 0x82,
	0x97, 0x98, 0xA5, 0xAC, 0x99, 0xA3, 0x89, 0x8D, 0x88, 0x7C, 0x82, 0x70,
	0x73, 0x70, 0x74, 0x7C, 0x84, 0x88, 0x8C, 0x8E, 0x8B, 0x91, 0x8C, 0x8C,
	0x89, 0x7E, 0x7E, 0x74, 0x75, 0x76, 0x74, 0x7A, 0x79, 0x7D, 0x81, 0x83,
	0x88, 0x89, 0x89, 0x88, 0x85, 0x82, 0x81, 0x7D, 0x7B, 0x7A, 0x77, 0x7A,
	0x78, 0x7C, 0x7F, 0x80, 0x84, 0x83, 0x85, 0x85, 0x84, 0x84, 0x82, 0x81,
	0x7F, 0x7E, 0x7C, 0x7D, 0x7C, 0x7C, 0x7F, 0x7D, 0x81, 0x80, 0x82, 0x83,
	0x82, 0x82, 0x83, 0x7F, 0x86, 0x96, 0x95, 0xAA, 0x9D, 0x9A, 0x99, 0x85,
	0x92, 0x81, 0x81, 0x7D, 0x6F, 0x75, 0x72, 0x7A, 0x81, 0x85, 0x88, 0x8A,
	0x8B, 0x8B, 0x90, 0x89, 0x8A, 0x83, 0x7B, 0x7D, 0x74, 0x7A, 0x78, 0x78,
	0x7C, 0x7A, 0x81, 0x83, 0x86, 0x88, 0x88, 0x86, 0x84, 0x83, 0x80, 0x80,
	0x7C, 0x7B, 0x7B, 0x78, 0x7C, 0x7C, 0x7F, 0x81, 0x81, 0x83, 0x83, 0x84,
	0x84, 0x83, 0x81, 0x80, 0x7E, 0x7C, 0x7D, 0x7C, 0x7C, 0x7D, 0x7D, 0x80,
	0x7F, 0x82, 0x82, 0x82, 0x84, 0x83, 0x84, 0x82, 0x81, 0x82, 0x93, 0x95,
	0xA2, 0xA3, 0x93, 0x9B, 0x88, 0x8B, 0x8A, 0x7C, 0x81, 0x72, 0x71, 0x76,
	0x76, 0x81, 0x84, 0x86, 0x89, 0x8B, 0x8B, 0x8E, 0x8D, 0x87, 0x86, 0x7C,
	0x7B, 0x7B, 0x76, 0x7C, 0x78, 0x7A, 0x7E, 0x7D, 0x84, 0x86, 0x87, 0x88,
	0x86, 0x84, 0x83, 0x81, 0x7E, 0x7E, 0x7A, 0x7A, 0x7B, 0x7A, 0x7E, 0x7F,
	0x80, 0x83, 0x82, 0x84, 0x85, 0x83, 0x84, 0x82, 0x7F, 0x80, 0x7D, 0x7D,
	0x7D, 0x7C, 0x7D, 0x7E, 0x7E, 0x80, 0x80, 0x82, 0x83, 0x82, 0x82, 0x82,
	0x80, 0x80, 0x7F, 0x7F, 0x92, 0x95, 0x9F, 0xA6, 0x93, 0x9A, 0x8E, 0x87,
	0x8E, 0x7D, 0x7D, 0x76, 0x6D, 0x74, 0x75, 0x7C, 0x82, 0x84, 0x86, 0x88,
	0x8C, 0x8C, 0x8E, 0x8B, 0x84, 0x83, 0x7B, 0x7A, 0x7B, 0x76, 0x79, 0x78,
	0x78, 0x7E, 0x7F, 0x84, 0x89, 0x88, 0x8A, 0x8A, 0x87, 0x87, 0x84, 0x81,
	0x7F, 0x7C, 0x79, 0x79, 0x79, 0x7A, 0x7C, 0x7E, 0x7F, 0x82, 0x83, 0x84,
	0x86, 0x85, 0x84, 0x83, 0x80, 0x80, 0x7E, 0x7D, 0x7C, 0x7C, 0x7B, 0x7B,
	0x7C, 0x7C, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x83, 0x82, 0x91, 0x99,
	0x9B, 0xA4, 0x98, 0x94, 0x94, 0x8A, 0x8C, 0x86, 0x7C, 0x78, 0x72, 0x72,
	0x75, 0x79, 0x7D, 0x7D, 0x83, 0x85, 0x89, 0x90, 0x8F, 0x90, 0x8E, 0x89,
	0x88, 0x84, 0x81, 0x7F, 0x7A, 0x78, 0x76, 0x76, 0x78, 0x79, 0x7C, 0x7E,
	0x7F, 0x83, 0x84, 0x86, 0x87, 0x87, 0x86, 0x84, 0x83, 0x81, 0x7F, 0x7E,
	0x7C, 0x7A, 0x7A, 0x7A, 0x7A, 0x7B, 0x7C, 0x7E, 0x7F, 0x80, 0x82, 0x82,
	0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7E, 0x7E, 0x89, 0x94, 0x96, 0x9C, 0x9B, 0x96, 0x98, 0x96,
	0x95, 0x91, 0x89, 0x83, 0x7B, 0x78, 0x78, 0x76, 0x77, 0x76, 0x76, 0x79,
	0x7C, 0x81, 0x86, 0x88, 0x8A, 0x8A, 0x8A, 0x8B, 0x8A, 0x89, 0x86, 0x82,
	0x7F, 0x7C, 0x7A, 0x79, 0x78, 0x78, 0x77, 0x78, 0x7A, 0x7C, 0x7F, 0x81,
	0x83, 0x84, 0x85, 0x86, 0x86, 0x86, 0x85, 0x83, 0x81, 0x80, 0x7E, 0x7D,
	0x7C, 0x7B, 0x7B, 0x7A, 0x7C, 0x7E, 0x7F, 0x81, 0x82, 0x83, 0x84, 0x84,
	0x85, 0x85, 0x84, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x86, 0x8E, 0x8E,
	0x92, 0x92, 0x8F, 0x92, 0x91, 0x92, 0x8F, 0x89, 0x86, 0x80, 0x7C, 0x7C,
	0x7A, 0x79, 0x78, 0x77, 0x79, 0x7B, 0x7E, 0x82, 0x83, 0x85, 0x86, 0x87,
	0x89, 0x89, 0x89, 0x87, 0x84, 0x82, 0x80, 0x7F, 0x7D, 0x7C, 0x7B, 0x7A,
	0x7A, 0x7B, 0x7C, 0x7E, 0x7F, 0x80, 0x82, 0x83, 0x84, 0x85, 0x85, 0x85,
	0x84, 0x83, 0x82, 0x81, 0x80, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D,
	0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x85, 0x8D, 0x8F, 0x90, 0x91, 0x8E, 0x8F, 0x8F, 0x8F, 0x8D, 0x89, 0x85,
	0x81, 0x7F, 0x7F, 0x7D, 0x7D, 0x7B, 0x7B, 0x7C, 0x7D, 0x80, 0x82, 0x83,
	0x85, 0x85, 0x86, 0x87, 0x87, 0x87, 0x85, 0x83, 0x82, 0x80, 0x7F, 0x7E,
	0x7D, 0x7C, 0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83,
	0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x82,
	0x82, 0x84, 0x8A, 0x8C, 0x8C, 0x8E, 0x8C, 0x8C, 0x8C, 0x8C, 0x8B, 0x88,
	0x86, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x7D, 0x7C, 0x7C, 0x7D, 0x7F, 0x80,
	0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x87, 0x86, 0x85, 0x84, 0x83,
	0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F,
	0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82,
	0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x83, 0x87, 0x88, 0x8A, 0x8B, 0x8B, 0x8C, 0x8D, 0x8E, 0x8D, 0x8B,
	0x8A, 0x88, 0x87, 0x86, 0x85, 0x83, 0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x84, 0x84, 0x84,
	0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x84,
	0x86, 0x86, 0x87, 0x87, 0x87, 0x87, 0x88, 0x89, 0x87, 0x87, 0x86, 0x85,
	0x85, 0x85, 0x84, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x83, 0x83, 0x84, 0x84, 0x84,
	0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80
};
const unsigned char WAV2[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80,
	0x7D, 0x7D, 0x7F, 0x7E, 0x80, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x82,
	0x82, 0x80, 0x81, 0x7F, 0x7F, 0x82, 0x82, 0x81, 0x82, 0x7E, 0x7D, 0x7E,
	0x80, 0x82, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x82, 0x82, 0x80, 0x7E, 0x7C,
	0x7C, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x83, 0x83,
	0x84, 0x83, 0x81, 0x81, 0x7F, 0x7F, 0x7B, 0x7E, 0x81, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7D, 0x7E, 0x80, 0x83, 0x81, 0x83, 0x80, 0x7F, 0x83, 0x83,
	0x85, 0x87, 0x84, 0x82, 0x84, 0x80, 0x80, 0x7F, 0x7D, 0x7B, 0x79, 0x7A,
	0x7C, 0x79, 0x79, 0x7D, 0x7F, 0x7F, 0x81, 0x84, 0x7F, 0x82, 0x82, 0x81,
	0x82, 0x83, 0x81, 0x81, 0x82, 0x7F, 0x82, 0x84, 0x7E, 0x82, 0x84, 0x7E,
	0x80, 0x82, 0x7A, 0x79, 0x7F, 0x7A, 0x7E, 0x82, 0x83, 0x81, 0x83, 0x83,
	0x83, 0x83, 0x84, 0x85, 0x82, 0x84, 0x81, 0x81, 0x7E, 0x7C, 0x7F, 0x80,
	0x7E, 0x80, 0x83, 0x81, 0x82, 0x86, 0x80, 0x81, 0x85, 0x7E, 0x7D, 0x7E,
	0x7D, 0x7A, 0x7F, 0x7F, 0x7A, 0x81, 0x7F, 0x7B, 0x7D, 0x82, 0x7F, 0x7B,
	0x85, 0x7D, 0x7E, 0x84, 0x81, 0x81, 0x82, 0x82, 0x7F, 0x83, 0x80, 0x82,
	0x81, 0x83, 0x7F, 0x80, 0x80, 0x7D, 0x81, 0x7E, 0x7D, 0x80, 0x7D, 0x7E,
	0x82, 0x7F, 0x80, 0x83, 0x83, 0x7D, 0x84, 0x80, 0x7E, 0x82, 0x81, 0x7D,
	0x7F, 0x82, 0x7B, 0x81, 0x80, 0x7E, 0x81, 0x82, 0x7F, 0x7F, 0x82, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7E, 0x80, 0x7E, 0x81,
	0x81, 0x7E, 0x81, 0x7C, 0x81, 0x7E, 0x80, 0x7D, 0x7F, 0x80, 0x7D, 0x82,
	0x7F, 0x81, 0x80, 0x81, 0x7F, 0x81, 0x82, 0x7D, 0x82, 0x81, 0x7D, 0x82,
	0x80, 0x7D, 0x7E, 0x82, 0x7B, 0x80, 0x83, 0x7C, 0x82, 0x81, 0x80, 0x7F,
	0x81, 0x7F, 0x7C, 0x83, 0x7D, 0x7D, 0x83, 0x7D, 0x7F, 0x81, 0x80, 0x7E,
	0x82, 0x81, 0x7D, 0x82, 0x80, 0x7D, 0x81, 0x80, 0x7C, 0x81, 0x81, 0x7D,
	0x80, 0x82, 0x7E, 0x7F, 0x82, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x80, 0x7F,
	0x7E, 0x81, 0x7F, 0x7E, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80,
	0x82, 0x7E, 0x80, 0x82, 0x7F, 0x7F, 0x82, 0x80, 0x7D, 0x82, 0x80, 0x7C,
	0x81, 0x7F, 0x7E, 0x7F, 0x82, 0x7E, 0x7F, 0x83, 0x7D, 0x7E, 0x82, 0x7E,
	0x7F, 0x80, 0x81, 0x7E, 0x81, 0x80, 0x7F, 0x82, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7E, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x7F,
	0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E,
	0x7D, 0x7F, 0x7E, 0x7E, 0x81, 0x7C, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x81,
	0x7F, 0x82, 0x83, 0x80, 0x82, 0x83, 0x80, 0x81, 0x83, 0x81, 0x80, 0x82,
	0x83, 0x80, 0x81, 0x83, 0x7E, 0x7E, 0x81, 0x7F, 0x7D, 0x81, 0x7F, 0x7B,
	0x80, 0x7E, 0x7B, 0x7F, 0x7D, 0x7A, 0x7F, 0x7F, 0x7D, 0x7E, 0x7E, 0x7D,
	0x7D, 0x7F, 0x7B, 0x7A, 0x7D, 0x78, 0x79, 0x7B, 0x79, 0x7A, 0x7D, 0x7C,
	0x82, 0x88, 0x87, 0x8F, 0x92, 0x90, 0x92, 0x92, 0x8F, 0x8B, 0x89, 0x85,
	0x7F, 0x7F, 0x7C, 0x78, 0x79, 0x78, 0x78, 0x7A, 0x7C, 0x7D, 0x7E, 0x81,
	0x82, 0x82, 0x83, 0x83, 0x82, 0x82, 0x82, 0x80, 0x7F, 0x7F, 0x7E, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7E, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x82, 0x96, 0x90, 0x96, 0xAA, 0x9D,
	0xA0, 0xA6, 0x99, 0x93, 0x8E, 0x86, 0x7B, 0x73, 0x76, 0x6B, 0x68, 0x73,
	0x6E, 0x71, 0x7C, 0x7E, 0x81, 0x88, 0x8C, 0x8B, 0x8B, 0x90, 0x8A, 0x85,
	0x87, 0x80, 0x7A, 0x7B, 0x78, 0x74, 0x76, 0x79, 0x78, 0x78, 0x7F, 0x80,
	0x7F, 0x87, 0x87, 0x84, 0x88, 0x87, 0x83, 0x82, 0x82, 0x7E, 0x7C, 0x7C,
	0x7D, 0x75, 0x8D, 0x9A, 0x8A, 0xAD, 0xB1, 0x9E, 0xB2, 0xAB, 0x99, 0x95,
	0x8D, 0x81, 0x6E, 0x6F, 0x6F, 0x5B, 0x67, 0x71, 0x66, 0x76, 0x83, 0x82,
	0x89, 0x92, 0x96, 0x8F, 0x92, 0x95, 0x85, 0x82, 0x86, 0x75, 0x73, 0x77,
	0x70, 0x6F, 0x75, 0x79, 0x77, 0x7D, 0x87, 0x84, 0x85, 0x8E, 0x8A, 0x86,
	0x8B, 0x86, 0x80, 0x7F, 0x7E, 0x79, 0x76, 0x7A, 0x79, 0x76, 0x7D, 0x9D,
	0x95, 0x98, 0xBD, 0xAB, 0xA3, 0xB5, 0xA1, 0x8E, 0x8C, 0x81, 0x70, 0x63,
	0x6C, 0x63, 0x58, 0x6F, 0x71, 0x6C, 0x83, 0x8C, 0x89, 0x92, 0x9A, 0x95,
	0x8E, 0x92, 0x8D, 0x7C, 0x7E, 0x7D, 0x6D, 0x6F, 0x75, 0x6E, 0x70, 0x7C,
	0x7D, 0x7D, 0x87, 0x8C, 0x88, 0x8B, 0x90, 0x88, 0x84, 0x87, 0x80, 0x79,
	0x7C, 0x79, 0x74, 0x76, 0x7A, 0x79, 0x79, 0x82, 0x80, 0x9C, 0xA5, 0x9A,
	0xBB, 0xB6, 0xA1, 0xB0, 0xA1, 0x87, 0x86, 0x77, 0x6A, 0x61, 0x5F, 0x64,
	0x5C, 0x69, 0x7A, 0x74, 0x84, 0x94, 0x8E, 0x95, 0x9B, 0x95, 0x8F, 0x8B,
	0x88, 0x7D, 0x73, 0x78, 0x6F, 0x69, 0x75, 0x72, 0x72, 0x7D, 0x81, 0x82,
	0x87, 0x8B, 0x8D, 0x88, 0x8B, 0x89, 0x7F, 0x81, 0x80, 0x77, 0x78, 0x7A,
	0x76, 0x77, 0x7B, 0x7E, 0x7C, 0x81, 0x85, 0x85, 0x80, 0x97, 0xAB, 0x94,
	0xAB, 0xBF, 0x9A, 0xA2, 0xAA, 0x84, 0x7E, 0x7E, 0x6B, 0x62, 0x61, 0x69,
	0x64, 0x65, 0x7E, 0x7D, 0x7B, 0x95, 0x94, 0x8B, 0x97, 0x95, 0x89, 0x86,
	0x85, 0x7C, 0x72, 0x76, 0x76, 0x6C, 0x73, 0x7C, 0x75, 0x7D, 0x86, 0x82,
	0x84, 0x8A, 0x87, 0x83, 0x84, 0x83, 0x7E, 0x7C, 0x7E, 0x7B, 0x78, 0x7C,
	0x7D, 0x7B, 0x7E, 0x82, 0x80, 0x81, 0x85, 0x83, 0x82, 0x82, 0x84, 0x7D,
	0x8C, 0xA9, 0x92, 0xA1, 0xBF, 0x9A, 0x98, 0xA9, 0x87, 0x7A, 0x7D, 0x6F,
	0x65, 0x61, 0x6A, 0x6D, 0x66, 0x7B, 0x87, 0x7C, 0x8D, 0x98, 0x8B, 0x8E,
	0x92, 0x88, 0x81, 0x7F, 0x7D, 0x75, 0x71, 0x78, 0x76, 0x72, 0x7D, 0x80,
	0x7D, 0x84, 0x88, 0x85, 0x85, 0x87, 0x86, 0x81, 0x7F, 0x81, 0x7C, 0x78,
	0x7D, 0x7C, 0x79, 0x7D, 0x7F, 0x7E, 0x80, 0x83, 0x83, 0x82, 0x82, 0x83,
	0x81, 0x7F, 0x80, 0x80, 0x7B, 0x81, 0x9F, 0x9A, 0x93, 0xB1, 0xAB, 0x95,
	0x9D, 0x97, 0x82, 0x78, 0x73, 0x72, 0x66, 0x62, 0x73, 0x72, 0x6F, 0x82,
	0x89, 0x85, 0x8C, 0x91, 0x8F, 0x89, 0x86, 0x87, 0x7E, 0x77, 0x7A, 0x78,
	0x72, 0x76, 0x7A, 0x7B, 0x7D, 0x81, 0x85, 0x85, 0x84, 0x87, 0x86, 0x82,
	0x81, 0x81, 0x7E, 0x7C, 0x7B, 0x7C, 0x7C, 0x7B, 0x7E, 0x80, 0x7F, 0x81,
	0x83, 0x82, 0x82, 0x82, 0x82, 0x83, 0x81, 0x80, 0x82, 0x80, 0x7F, 0x7F,
	0x7F, 0x7E, 0x81, 0x9A, 0x9D, 0x93, 0xA6, 0xA9, 0x99, 0x94, 0x8F, 0x86,
	0x7B, 0x6D, 0x71, 0x70, 0x67, 0x6E, 0x78, 0x79, 0x7E, 0x85, 0x8B, 0x8C,
	0x86, 0x88, 0x89, 0x80, 0x7C, 0x7C, 0x79, 0x77, 0x75, 0x78, 0x7C, 0x7C,
	0x7E, 0x83, 0x84, 0x84, 0x84, 0x85, 0x85, 0x82, 0x7F, 0x80, 0x7E, 0x7B,
	0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x92, 0x9F, 0x96, 0x9C, 0xA5, 0x9D, 0x95, 0x8A, 0x84, 0x82,
	0x74, 0x6C, 0x70, 0x71, 0x71, 0x75, 0x79, 0x83, 0x87, 0x86, 0x8A, 0x8D,
	0x8A, 0x87, 0x82, 0x81, 0x7E, 0x79, 0x77, 0x79, 0x79, 0x7A, 0x7B, 0x7E,
	0x82, 0x82, 0x83, 0x85, 0x85, 0x84, 0x82, 0x81, 0x80, 0x7F, 0x7D, 0x7C,
	0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81, 0x81,
	0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x91, 0x9C, 0x97, 0x99, 0x9B, 0x9A, 0x95, 0x88, 0x7E,
	0x7E, 0x77, 0x71, 0x6F, 0x70, 0x77, 0x7B, 0x7B, 0x81, 0x87, 0x8A, 0x8B,
	0x88, 0x87, 0x87, 0x83, 0x7E, 0x7A, 0x79, 0x79, 0x79, 0x78, 0x7A, 0x7E,
	0x80, 0x82, 0x83, 0x83, 0x85, 0x84, 0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7C,
	0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x81, 0x81, 0x7F,
	0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x82,
	0x82, 0x82, 0x81, 0x80, 0x7F, 0x89, 0x98, 0x9A, 0x99, 0x97, 0x95, 0x96,
	0x8E, 0x81, 0x7B, 0x77, 0x76, 0x75, 0x70, 0x71, 0x77, 0x7D, 0x82, 0x84,
	0x84, 0x88, 0x8A, 0x89, 0x86, 0x81, 0x7E, 0x7E, 0x7C, 0x7A, 0x79, 0x79,
	0x7C, 0x7E, 0x7F, 0x80, 0x81, 0x83, 0x84, 0x84, 0x82, 0x81, 0x80, 0x7F,
	0x7E, 0x7C, 0x7B, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x82, 0x84, 0x8E, 0x97, 0x9A, 0x9B,
	0x96, 0x92, 0x90, 0x8A, 0x84, 0x7C, 0x76, 0x75, 0x77, 0x78, 0x7A, 0x7B,
	0x7F, 0x84, 0x87, 0x87, 0x86, 0x84, 0x84, 0x83, 0x80, 0x7E, 0x7B, 0x7B,
	0x7C, 0x7D, 0x7E, 0x7E, 0x7F, 0x81, 0x82, 0x83, 0x82, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x8B,
	0x92, 0x96, 0x95, 0x91, 0x8F, 0x8D, 0x89, 0x84, 0x7E, 0x79, 0x78, 0x79,
	0x7B, 0x7C, 0x7C, 0x7E, 0x81, 0x84, 0x85, 0x84, 0x82, 0x81, 0x81, 0x81,
	0x7F, 0x7D, 0x7C, 0x7C, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F,
	0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x85, 0x8A, 0x8E, 0x8F, 0x8D, 0x8B, 0x8A, 0x89, 0x88, 0x84, 0x80,
	0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x81, 0x84, 0x87, 0x8A, 0x8A, 0x89, 0x89, 0x88, 0x88, 0x87,
	0x85, 0x83, 0x82, 0x81, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x82, 0x82, 0x81, 0x81, 0x81, 0x82, 0x83, 0x83, 0x82, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x81, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F
};
const unsigned char WAV20[] = {
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7D, 0x7F, 0x7F, 0x80, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7D, 0x80, 0x80, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7D, 0x81, 0x7D, 0x7F, 0x81, 0x7E, 0x7E, 0x7F, 0x82, 0x7F,
	0x82, 0x81, 0x7F, 0x82, 0x83, 0x81, 0x7F, 0x81, 0x7D, 0x7E, 0x7D, 0x7D,
	0x7E, 0x80, 0x83, 0x81, 0x82, 0x81, 0x80, 0x83, 0x80, 0x7F, 0x81, 0x7E,
	0x80, 0x86, 0x80, 0x7F, 0x88, 0x82, 0x88, 0x86, 0x83, 0x7D, 0x7D, 0x7E,
	0x7C, 0x80, 0x83, 0x81, 0x7C, 0x82, 0x7F, 0x7E, 0x80, 0x82, 0x83, 0x83,
	0x83, 0x80, 0x80, 0x81, 0x82, 0x7F, 0x82, 0x84, 0x7C, 0x7D, 0x80, 0x7E,
	0x7C, 0x81, 0x7F, 0x7C, 0x7E, 0x80, 0x7D, 0x80, 0x85, 0x80, 0x81, 0x81,
	0x80, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7B, 0x7E, 0x7F, 0x7C, 0x7E,
	0x7E, 0x80, 0x7F, 0x82, 0x83, 0x82, 0x7E, 0x81, 0x81, 0x7E, 0x81, 0x80,
	0x83, 0x81, 0x83, 0x81, 0x7F, 0x80, 0x7C, 0x7F, 0x7F, 0x79, 0x7B, 0x81,
	0x7E, 0x7B, 0x80, 0x83, 0x7A, 0x80, 0x85, 0x7D, 0x7C, 0x80, 0x80, 0x79,
	0x81, 0x80, 0x7B, 0x81, 0x7F, 0x7C, 0x7E, 0x82, 0x82, 0x7E, 0x7F, 0x83,
	0x7D, 0x7D, 0x85, 0x82, 0x7B, 0x81, 0x86, 0x7F, 0x7E, 0x84, 0x7F, 0x7F,
	0x81, 0x7D, 0x7B, 0x7D, 0x81, 0x7D, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7E,
	0x7F, 0x84, 0x80, 0x7F, 0x83, 0x80, 0x7F, 0x82, 0x81, 0x7E, 0x81, 0x82,
	0x81, 0x7D, 0x7E, 0x81, 0x7F, 0x80, 0x7D, 0x7D, 0x82, 0x7F, 0x7F, 0x82,
	0x80, 0x7F, 0x83, 0x82, 0x7E, 0x7E, 0x82, 0x80, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7D, 0x80, 0x82, 0x80, 0x7D,
	0x7F, 0x84, 0x82, 0x7D, 0x7D, 0x81, 0x82, 0x81, 0x7D, 0x7F, 0x83, 0x7E,
	0x7C, 0x7F, 0x82, 0x80, 0x7C, 0x7E, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x80,
	0x81, 0x81, 0x7E, 0x7D, 0x81, 0x81, 0x81, 0x82, 0x7D, 0x7E, 0x85, 0x83,
	0x81, 0x7E, 0x7D, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x82, 0x82,
	0x7F, 0x7F, 0x7F, 0x7D, 0x82, 0x84, 0x7C, 0x7C, 0x80, 0x83, 0x81, 0x7D,
	0x7D, 0x81, 0x82, 0x80, 0x7D, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x81, 0x81, 0x7D, 0x7F, 0x81, 0x82, 0x80, 0x80, 0x7F, 0x7E, 0x80,
	0x80, 0x7E, 0x7E, 0x81, 0x80, 0x80, 0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x82, 0x82, 0x80, 0x7C, 0x7B, 0x81, 0x83, 0x82, 0x7E, 0x7D,
	0x80, 0x82, 0x82, 0x7F, 0x7C, 0x7D, 0x7F, 0x81, 0x81, 0x7C, 0x7B, 0x7F,
	0x83, 0x81, 0x7E, 0x7E, 0x7F, 0x81, 0x82, 0x80, 0x7C, 0x7C, 0x80, 0x81,
	0x81, 0x7E, 0x7D, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x7F,
	0x7F, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7E,
	0x7E, 0x80, 0x81, 0x82, 0x7E, 0x7C, 0x7F, 0x82, 0x82, 0x82, 0x80, 0x7E,
	0x7F, 0x7F, 0x80, 0x81, 0x81, 0x7F, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x80,
	0x7F, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x80,
	0x80, 0x7F, 0x80, 0x81, 0x82, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x80,
	0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80,
	0x82, 0x82, 0x83, 0x84, 0x83, 0x82, 0x82, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x81, 0x86, 0x8A, 0x8C, 0x8C, 0x88, 0x85, 0x82,
	0x80, 0x80, 0x80, 0x7F, 0x7D, 0x7C, 0x7B, 0x7C, 0x7E, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x85, 0x8F, 0x99, 0xA1, 0xA2, 0x9B,
	0x91, 0x84, 0x7C, 0x79, 0x77, 0x77, 0x75, 0x73, 0x73, 0x76, 0x7B, 0x81,
	0x85, 0x87, 0x85, 0x83, 0x82, 0x81, 0x82, 0x81, 0x80, 0x7E, 0x7C, 0x7B,
	0x7D, 0x7F, 0x81, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x8D, 0xA0, 0xB0, 0xB9,
	0xAF, 0x9B, 0x86, 0x75, 0x70, 0x70, 0x6E, 0x6C, 0x69, 0x6C, 0x77, 0x84,
	0x91, 0x94, 0x8E, 0x85, 0x7D, 0x7A, 0x7B, 0x7A, 0x77, 0x74, 0x74, 0x7A,
	0x82, 0x89, 0x8A, 0x87, 0x83, 0x80, 0x81, 0x81, 0x80, 0x7C, 0x79, 0x78,
	0x7C, 0x80, 0x83, 0x83, 0x81, 0x80, 0x80, 0x82, 0x82, 0x80, 0x7C, 0x79,
	0x79, 0x7D, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x82, 0x83, 0x83, 0x99, 0xB6,
	0xC6, 0xC5, 0xA6, 0x87, 0x74, 0x6C, 0x70, 0x6C, 0x64, 0x63, 0x6A, 0x82,
	0x97, 0x9F, 0x99, 0x88, 0x80, 0x7D, 0x7D, 0x7A, 0x6F, 0x69, 0x6D, 0x7A,
	0x88, 0x8D, 0x8A, 0x85, 0x84, 0x87, 0x87, 0x81, 0x78, 0x71, 0x74, 0x7B,
	0x81, 0x83, 0x80, 0x81, 0x83, 0x87, 0x88, 0x83, 0x7D, 0x79, 0x79, 0x7C,
	0x7D, 0x7D, 0x7D, 0x7F, 0x83, 0x86, 0x84, 0x82, 0x7E, 0x7F, 0x7E, 0x82,
	0xAE, 0xD1, 0xD5, 0xBA, 0x8A, 0x79, 0x78, 0x77, 0x6E, 0x57, 0x59, 0x70,
	0x8F, 0xA4, 0x9E, 0x98, 0x96, 0x95, 0x8E, 0x78, 0x66, 0x62, 0x6B, 0x78,
	0x7D, 0x80, 0x87, 0x90, 0x97, 0x91, 0x85, 0x7B, 0x76, 0x77, 0x75, 0x73,
	0x75, 0x7B, 0x85, 0x8A, 0x8A, 0x88, 0x85, 0x83, 0x81, 0x7A, 0x75, 0x75,
	0x78, 0x7E, 0x7F, 0x82, 0x84, 0x87, 0x87, 0x84, 0x7F, 0x7D, 0x7B, 0x7D,
	0x78, 0x87, 0xC6, 0xDF, 0xCD, 0xA0, 0x7E, 0x89, 0x82, 0x6B, 0x52, 0x52,
	0x79, 0x93, 0x9B, 0x9C, 0x9E, 0xA7, 0x9A, 0x80, 0x6E, 0x68, 0x6E, 0x6D,
	0x6E, 0x7A, 0x8A, 0x96, 0x94, 0x8E, 0x8B, 0x86, 0x7E, 0x73, 0x6E, 0x72,
	0x78, 0x7D, 0x81, 0x86, 0x8B, 0x8D, 0x88, 0x82, 0x7D, 0x7A, 0x78, 0x76,
	0x79, 0x7D, 0x81, 0x84, 0x85, 0x86, 0x84, 0x82, 0x7E, 0x7D, 0x7A, 0x7D,
	0x7A, 0x80, 0x7C, 0x9A, 0xE0, 0xDA, 0xB9, 0x97, 0x8E, 0x8E, 0x63, 0x4D,
	0x5C, 0x79, 0x8A, 0x8B, 0x9E, 0xAF, 0xA3, 0x8A, 0x7A, 0x7B, 0x70, 0x63,
	0x67, 0x7B, 0x87, 0x87, 0x8A, 0x94, 0x92, 0x84, 0x79, 0x79, 0x79, 0x73,
	0x72, 0x7C, 0x85, 0x85, 0x84, 0x87, 0x89, 0x82, 0x7A, 0x7D, 0x7D, 0x79,
	0x7A, 0x7F, 0x84, 0x81, 0x82, 0x84, 0x84, 0x7E, 0x7D, 0x7F, 0x7E, 0x7C,
	0x7D, 0x81, 0x81, 0x81, 0x80, 0xC6, 0xDD, 0xB3, 0xB1, 0xA8, 0x91, 0x60,
	0x51, 0x6E, 0x6C, 0x70, 0x90, 0xA6, 0x9F, 0x8E, 0x96, 0x8A, 0x6C, 0x68,
	0x73, 0x73, 0x6F, 0x81, 0x91, 0x8B, 0x86, 0x8D, 0x89, 0x79, 0x73, 0x7C,
	0x79, 0x74, 0x7E, 0x88, 0x84, 0x81, 0x87, 0x86, 0x7E, 0x80, 0x82, 0x7F,
	0x7C, 0x7F, 0x83, 0x7E, 0x7F, 0x83, 0x81, 0x7E, 0x80, 0x81, 0x7F, 0x7C,
	0x81, 0x7F, 0x7F, 0x7E, 0x84, 0x7B, 0x99, 0xD0, 0xB7, 0xB3, 0xB8, 0x9E,
	0x77, 0x61, 0x6D, 0x5E, 0x5C, 0x7B, 0x8C, 0x8D, 0x91, 0x9F, 0x94, 0x7E,
	0x7E, 0x7B, 0x6D, 0x6B, 0x78, 0x7E, 0x7C, 0x86, 0x8F, 0x88, 0x83, 0x85,
	0x81, 0x77, 0x77, 0x7C, 0x7A, 0x7B, 0x81, 0x85, 0x84, 0x86, 0x88, 0x85,
	0x80, 0x80, 0x7E, 0x7B, 0x7A, 0x7E, 0x7E, 0x7E, 0x82, 0x83, 0x82, 0x81,
	0x81, 0x81, 0x7C, 0x7F, 0x7D, 0x80, 0x7B, 0x8F, 0xC3, 0xB5, 0xB5, 0xBD,
	0xA7, 0x85, 0x6F, 0x75, 0x60, 0x5C, 0x72, 0x7E, 0x82, 0x8A, 0x9D, 0x97,
	0x8A, 0x8B, 0x84, 0x77, 0x6E, 0x76, 0x76, 0x72, 0x7E, 0x86, 0x86, 0x85,
	0x8A, 0x89, 0x7F, 0x7E, 0x7E, 0x7A, 0x77, 0x7C, 0x7E, 0x7A, 0x7D, 0x81,
	0x81, 0x7F, 0x81, 0x83, 0x80, 0x7F, 0x81, 0x7F, 0x7D, 0x7E, 0x80, 0x7E,
	0x7E, 0x80, 0x81, 0x7E, 0x80, 0x81, 0x80, 0x7E, 0x86, 0xB2, 0xB2, 0xB1,
	0xBA, 0xAA, 0x95, 0x7B, 0x7E, 0x71, 0x63, 0x6D, 0x71, 0x71, 0x73, 0x81,
	0x88, 0x84, 0x8C, 0x8F, 0x8B, 0x85, 0x85, 0x84, 0x7A, 0x7A, 0x7C, 0x7A,
	0x78, 0x7B, 0x7F, 0x7D, 0x80, 0x83, 0x83, 0x81, 0x82, 0x84, 0x81, 0x7F,
	0x81, 0x7F, 0x7E, 0x7D, 0x7F, 0x7E, 0x7D, 0x7F, 0x7F, 0x7F, 0x80, 0x81,
	0x81, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x90, 0xAA,
	0xA9, 0xB2, 0xB1, 0xA6, 0x99, 0x8F, 0x90, 0x84, 0x7E, 0x7B, 0x73, 0x6D,
	0x6B, 0x72, 0x74, 0x77, 0x81, 0x84, 0x86, 0x88, 0x8B, 0x8C, 0x89, 0x8B,
	0x88, 0x84, 0x80, 0x7E, 0x7C, 0x78, 0x79, 0x7A, 0x79, 0x7B, 0x7C, 0x7F,
	0x80, 0x82, 0x84, 0x85, 0x85, 0x86, 0x86, 0x84, 0x83, 0x83, 0x81, 0x7F,
	0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80,
	0x8D, 0x9C, 0xA0, 0xA8, 0xA9, 0xA6, 0xA0, 0x9D, 0x9E, 0x98, 0x94, 0x8E,
	0x85, 0x7D, 0x76, 0x75, 0x73, 0x74, 0x76, 0x76, 0x77, 0x78, 0x7D, 0x81,
	0x84, 0x89, 0x8B, 0x8C, 0x8B, 0x8B, 0x8A, 0x89, 0x88, 0x86, 0x83, 0x80,
	0x7E, 0x7C, 0x7A, 0x79, 0x79, 0x79, 0x7A, 0x7A, 0x7B, 0x7C, 0x7E, 0x80,
	0x81, 0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80,
	0x7F, 0x7E, 0x81, 0x88, 0x8E, 0x94, 0x98, 0x99, 0x98, 0x95, 0x95, 0x94,
	0x94, 0x93, 0x8F, 0x8A, 0x84, 0x80, 0x7D, 0x7B, 0x7B, 0x7B, 0x7A, 0x7A,
	0x79, 0x7A, 0x7B, 0x7E, 0x81, 0x83, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
	0x85, 0x85, 0x84, 0x82, 0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x85, 0x88, 0x8B, 0x8D, 0x8D, 0x8B,
	0x8A, 0x88, 0x87, 0x87, 0x87, 0x86, 0x85, 0x83, 0x81, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x84,
	0x85, 0x86, 0x86, 0x86, 0x86, 0x85, 0x85, 0x86, 0x86, 0x86, 0x86, 0x85,
	0x84, 0x84, 0x83, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7E,
	0x80, 0x80, 0x80, 0x81, 0x82, 0x80, 0x81, 0x81, 0x80, 0x80, 0x81, 0x7E,
	0x7E, 0x80, 0x80, 0x7F, 0x81, 0x82, 0x81, 0x82, 0x82, 0x80, 0x81, 0x7F,
	0x7E, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7B, 0x7C, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7D, 0x80, 0x80, 0x7F, 0x7E,
	0x81, 0x7F, 0x7E, 0x80, 0x7F, 0x7D, 0x7E, 0x82, 0x80, 0x83, 0x87, 0x84,
	0x84, 0x87, 0x84, 0x82, 0x83, 0x81, 0x7E, 0x7D, 0x7D, 0x7C, 0x79, 0x7A,
	0x7B, 0x7B, 0x7B, 0x7D, 0x7F, 0x7D, 0x7F, 0x81, 0x80, 0x81, 0x83, 0x7F,
	0x7D, 0x7E, 0x7C, 0x7B, 0x7D, 0x7E, 0x7D, 0x80, 0x81, 0x82, 0x85, 0x82,
	0x85, 0x86, 0x83, 0x83, 0x84, 0x7F, 0x7B, 0x7F, 0x7A, 0x7B, 0x7E, 0x80,
	0x7F, 0x82, 0x85, 0x82, 0x84, 0x84, 0x82, 0x82, 0x81, 0x81, 0x89, 0x86,
	0x89, 0x8C, 0x89, 0x89, 0x88, 0x87, 0x82, 0x83, 0x80, 0x7D, 0x7E, 0x7D,
	0x7B, 0x7D, 0x7D, 0x7D, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x7E, 0x87, 0x90,
	0x8B, 0x9A, 0x9D, 0x97, 0x9D, 0x99, 0x91, 0x8B, 0x88, 0x7D, 0x77, 0x78,
	0x70, 0x6F, 0x74, 0x72, 0x75, 0x7B, 0x7D, 0x7F, 0x84, 0x86, 0x84, 0x87,
	0x86, 0x82, 0x84, 0x81, 0x7E, 0x7E, 0x7E, 0x7C, 0x7D, 0x7E, 0x7D, 0x7E,
	0x80, 0x7F, 0x81, 0x82, 0x81, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F,
	0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x82, 0x7E, 0x95,
	0x95, 0x90, 0xB0, 0x9F, 0xA0, 0xAC, 0x95, 0x93, 0x8C, 0x7F, 0x74, 0x71,
	0x6F, 0x62, 0x6D, 0x6E, 0x6A, 0x7A, 0x7A, 0x7E, 0x87, 0x88, 0x8A, 0x8B,
	0x8C, 0x87, 0x84, 0x86, 0x7D, 0x7D, 0x7D, 0x77, 0x7A, 0x7A, 0x7A, 0x7C,
	0x7E, 0x80, 0x7F, 0x83, 0x83, 0x81, 0x84, 0x82, 0x81, 0x81, 0x7F, 0x80,
	0x7E, 0x7F, 0x7D, 0x7D, 0x80, 0x7D, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7E,
	0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x7E,
	0x85, 0x9C, 0x88, 0xA1, 0xAD, 0x91, 0xAC, 0x9D, 0x8A, 0x91, 0x80, 0x75,
	0x70, 0x6F, 0x66, 0x67, 0x72, 0x6A, 0x77, 0x80, 0x7C, 0x88, 0x8A, 0x89,
	0x8C, 0x8A, 0x87, 0x83, 0x84, 0x7E, 0x7B, 0x7F, 0x78, 0x7A, 0x7D, 0x7A,
	0x7E, 0x7F, 0x7F, 0x80, 0x82, 0x82, 0x81, 0x82, 0x81, 0x82, 0x81, 0x82,
	0x82, 0x80, 0x83, 0x7F, 0x80, 0x81, 0x7D, 0x80, 0x7E, 0x7D, 0x7F, 0x7D,
	0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x7F, 0x81, 0x80, 0x80,
	0x7F, 0x81, 0x7C, 0x8E, 0x92, 0x87, 0xAC, 0x97, 0x96, 0xAD, 0x88, 0x91,
	0x8E, 0x74, 0x79, 0x71, 0x69, 0x69, 0x6F, 0x6B, 0x70, 0x7D, 0x77, 0x83,
	0x89, 0x83, 0x8D, 0x8A, 0x87, 0x89, 0x84, 0x81, 0x7F, 0x7F, 0x7B, 0x7C,
	0x7D, 0x7A, 0x7E, 0x7E, 0x7D, 0x81, 0x7F, 0x81, 0x82, 0x80, 0x81, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x80,
	0x7F, 0x80, 0x80, 0x81, 0x80, 0x82, 0x7D, 0x8C, 0x94, 0x87, 0xA9, 0x9B,
	0x93, 0xAE, 0x8C, 0x8F, 0x92, 0x74, 0x7B, 0x74, 0x65, 0x6D, 0x6B, 0x69,
	0x72, 0x78, 0x78, 0x83, 0x88, 0x84, 0x8F, 0x8B, 0x88, 0x8D, 0x84, 0x82,
	0x83, 0x7C, 0x7B, 0x7C, 0x78, 0x7A, 0x7C, 0x7A, 0x7E, 0x7F, 0x7E, 0x83,
	0x81, 0x82, 0x83, 0x81, 0x81, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D,
	0x7F, 0x7E, 0x7F, 0x81, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x81, 0x7F, 0x81,
	0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x80, 0x7F, 0x7C, 0x81, 0x7A,
	0x81, 0x93, 0x80, 0x9C, 0x9F, 0x8B, 0xAD, 0x94, 0x8E, 0x9C, 0x7D, 0x81,
	0x7F, 0x6A, 0x72, 0x6F, 0x67, 0x71, 0x73, 0x71, 0x7D, 0x80, 0x7E, 0x8A,
	0x87, 0x87, 0x8C, 0x84, 0x85, 0x83, 0x7D, 0x7E, 0x7B, 0x79, 0x7A, 0x7A,
	0x7B, 0x7C, 0x7E, 0x7F, 0x81, 0x82, 0x82, 0x83, 0x82, 0x82, 0x82, 0x81,
	0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7D, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7C,
	0x7E, 0x7F, 0x7C, 0x80, 0x7D, 0x7E, 0x81, 0x7E, 0x80, 0x81, 0x7F, 0x82,
	0x81, 0x80, 0x80, 0x81, 0x7E, 0x82, 0x7D, 0x87, 0x8E, 0x85, 0x9F, 0x94,
	0x94, 0xA7, 0x8C, 0x96, 0x92, 0x7B, 0x86, 0x76, 0x6D, 0x75, 0x68, 0x6C,
	0x71, 0x6F, 0x75, 0x7B, 0x7C, 0x81, 0x86, 0x85, 0x88, 0x89, 0x85, 0x87,
	0x85, 0x81, 0x83, 0x80, 0x7E, 0x7F, 0x7D, 0x7D, 0x7E, 0x7C, 0x7E, 0x7E,
	0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x80,
	0x7F, 0x80, 0x7F, 0x87, 0x89, 0x88, 0x99, 0x8E, 0x97, 0x9D, 0x8C, 0x99,
	0x8C, 0x83, 0x89, 0x77, 0x78, 0x77, 0x6D, 0x73, 0x71, 0x70, 0x77, 0x78,
	0x7A, 0x80, 0x80, 0x81, 0x86, 0x82, 0x84, 0x85, 0x80, 0x84, 0x81, 0x7F,
	0x82, 0x7E, 0x80, 0x81, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x7E, 0x7E, 0x7F, 0x7D, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x7F,
	0x81, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x82,
	0x86, 0x84, 0x8E, 0x8C, 0x8E, 0x94, 0x8D, 0x92, 0x8D, 0x88, 0x8A, 0x80,
	0x80, 0x7D, 0x76, 0x7A, 0x75, 0x76, 0x79, 0x77, 0x7A, 0x7C, 0x7C, 0x7F,
	0x80, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x7E, 0x80, 0x80,
	0x7F, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x84, 0x83, 0x88, 0x8B,
	0x89, 0x8F, 0x8B, 0x8D, 0x8D, 0x88, 0x8A, 0x85, 0x83, 0x83, 0x7F, 0x80,
	0x7F, 0x7D, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x82,
	0x80, 0x82, 0x81, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x82, 0x82, 0x84, 0x86, 0x85, 0x87, 0x86, 0x86,
	0x88, 0x85, 0x86, 0x85, 0x84, 0x84, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81, 0x82, 0x82, 0x81,
	0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80
};
const unsigned char WAV3[] = {
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7F,
	0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x7D, 0x7E, 0x7F,
	0x80, 0x7F, 0x7D, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x7F, 0x7F, 0x7E,
	0x82, 0x81, 0x82, 0x84, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7E,
	0x7C, 0x7E, 0x7F, 0x7D, 0x7D, 0x7F, 0x81, 0x80, 0x80, 0x82, 0x81, 0x82,
	0x83, 0x83, 0x82, 0x7E, 0x7F, 0x80, 0x7C, 0x7C, 0x7B, 0x7E, 0x7D, 0x7F,
	0x82, 0x7F, 0x81, 0x80, 0x7E, 0x7E, 0x80, 0x83, 0x82, 0x81, 0x81, 0x7F,
	0x7C, 0x7E, 0x7C, 0x7D, 0x7F, 0x80, 0x82, 0x83, 0x83, 0x82, 0x81, 0x81,
	0x80, 0x7D, 0x80, 0x82, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7B, 0x7F, 0x80,
	0x7F, 0x7D, 0x7B, 0x80, 0x7F, 0x7F, 0x81, 0x82, 0x80, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x81, 0x82, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x83, 0x82, 0x81, 0x81, 0x80, 0x80,
	0x7E, 0x80, 0x82, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x80,
	0x80, 0x81, 0x83, 0x83, 0x83, 0x84, 0x82, 0x82, 0x83, 0x7F, 0x7F, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7F, 0x81, 0x81,
	0x80, 0x80, 0x84, 0x83, 0x80, 0x82, 0x82, 0x82, 0x81, 0x7F, 0x80, 0x81,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7C, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D,
	0x7E, 0x7E, 0x80, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x86,
	0x8A, 0x88, 0x89, 0x8A, 0x8A, 0x89, 0x86, 0x84, 0x85, 0x83, 0x80, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7E, 0x85, 0x8F, 0x90, 0x8E, 0x91, 0x94, 0x92, 0x8F, 0x8A, 0x86, 0x85,
	0x82, 0x7D, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7D, 0x7F, 0x82, 0x83, 0x83,
	0x84, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81,
	0x81, 0x80, 0x84, 0x8F, 0x94, 0x91, 0x8E, 0x91, 0x94, 0x91, 0x8B, 0x86,
	0x83, 0x82, 0x81, 0x7C, 0x79, 0x79, 0x7C, 0x7D, 0x7D, 0x7D, 0x7F, 0x81,
	0x83, 0x83, 0x83, 0x82, 0x83, 0x83, 0x82, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x84, 0x8E, 0x95, 0x93, 0x8E, 0x8E, 0x91, 0x91, 0x8C,
	0x86, 0x80, 0x7E, 0x7E, 0x7D, 0x7A, 0x77, 0x78, 0x7B, 0x7E, 0x7F, 0x7E,
	0x7F, 0x81, 0x83, 0x84, 0x84, 0x82, 0x81, 0x81, 0x82, 0x81, 0x7F, 0x7E,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7D, 0x7D,
	0x7E, 0x7F, 0x7F, 0x83, 0x8C, 0x97, 0x99, 0x94, 0x90, 0x8F, 0x90, 0x8E,
	0x88, 0x82, 0x7C, 0x78, 0x79, 0x7A, 0x79, 0x77, 0x76, 0x7A, 0x7D, 0x80,
	0x80, 0x81, 0x81, 0x82, 0x83, 0x85, 0x84, 0x82, 0x80, 0x7F, 0x80, 0x7F,
	0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x83, 0x8E, 0x9A, 0x9E, 0x98, 0x91, 0x8F, 0x90, 0x8E, 0x8A,
	0x83, 0x7B, 0x75, 0x74, 0x78, 0x7A, 0x78, 0x76, 0x78, 0x7C, 0x82, 0x86,
	0x88, 0x87, 0x85, 0x84, 0x86, 0x87, 0x85, 0x81, 0x7D, 0x7C, 0x7C, 0x7C,
	0x7C, 0x7C, 0x7B, 0x7B, 0x7D, 0x80, 0x82, 0x82, 0x81, 0x81, 0x82, 0x82,
	0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E,
	0x85, 0x94, 0xA1, 0xA2, 0x99, 0x92, 0x92, 0x93, 0x90, 0x89, 0x81, 0x77,
	0x70, 0x71, 0x76, 0x78, 0x76, 0x75, 0x77, 0x7D, 0x83, 0x88, 0x8A, 0x88,
	0x86, 0x85, 0x87, 0x87, 0x85, 0x80, 0x7C, 0x7A, 0x7A, 0x7B, 0x7C, 0x7B,
	0x7A, 0x7B, 0x7D, 0x81, 0x83, 0x83, 0x82, 0x82, 0x82, 0x83, 0x83, 0x82,
	0x80, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x85, 0x95, 0xA4,
	0xA5, 0x9B, 0x93, 0x93, 0x95, 0x91, 0x89, 0x7F, 0x75, 0x6E, 0x6F, 0x75,
	0x78, 0x75, 0x73, 0x76, 0x7E, 0x85, 0x8A, 0x8B, 0x89, 0x86, 0x85, 0x85,
	0x84, 0x80, 0x7B, 0x78, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7B, 0x7D, 0x80,
	0x83, 0x85, 0x84, 0x83, 0x83, 0x83, 0x83, 0x82, 0x80, 0x7E, 0x7C, 0x7C,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x87, 0x9A, 0xAA, 0xA8, 0x9B, 0x93, 0x96,
	0x97, 0x91, 0x86, 0x7A, 0x6F, 0x6B, 0x6F, 0x75, 0x75, 0x71, 0x71, 0x78,
	0x83, 0x8A, 0x8C, 0x8A, 0x88, 0x87, 0x89, 0x8A, 0x87, 0x80, 0x7A, 0x79,
	0x7B, 0x7C, 0x7B, 0x79, 0x78, 0x7A, 0x7E, 0x82, 0x84, 0x82, 0x81, 0x82,
	0x85, 0x85, 0x84, 0x81, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7C, 0x7B, 0x7D,
	0x87, 0x9C, 0xAE, 0xAB, 0x9C, 0x96, 0x9C, 0x9E, 0x94, 0x82, 0x74, 0x6D,
	0x6C, 0x71, 0x73, 0x6E, 0x6A, 0x71, 0x7F, 0x89, 0x8B, 0x89, 0x88, 0x8B,
	0x8E, 0x8F, 0x8A, 0x81, 0x7A, 0x79, 0x7B, 0x7B, 0x77, 0x73, 0x74, 0x77,
	0x7C, 0x7F, 0x80, 0x7F, 0x81, 0x85, 0x88, 0x87, 0x84, 0x81, 0x80, 0x81,
	0x80, 0x7E, 0x7B, 0x79, 0x7B, 0x7D, 0x7E, 0x88, 0xA3, 0xBB, 0xB6, 0x9F,
	0x98, 0xA5, 0xA7, 0x94, 0x7D, 0x72, 0x70, 0x72, 0x73, 0x6F, 0x67, 0x6C,
	0x7D, 0x8B, 0x8B, 0x87, 0x89, 0x90, 0x95, 0x92, 0x89, 0x7F, 0x7B, 0x7D,
	0x7D, 0x76, 0x6F, 0x70, 0x76, 0x7D, 0x7F, 0x7E, 0x7F, 0x84, 0x8A, 0x8A,
	0x85, 0x81, 0x82, 0x83, 0x80, 0x7B, 0x78, 0x79, 0x7B, 0x7C, 0x7C, 0x7B,
	0x7E, 0x81, 0x90, 0xB4, 0xC7, 0xAD, 0x94, 0xA8, 0xBD, 0xA2, 0x78, 0x6E,
	0x74, 0x72, 0x6A, 0x63, 0x5D, 0x69, 0x83, 0x8B, 0x7E, 0x83, 0x9B, 0xA3,
	0x93, 0x88, 0x8A, 0x89, 0x82, 0x78, 0x6D, 0x6C, 0x73, 0x76, 0x71, 0x72,
	0x7E, 0x88, 0x88, 0x87, 0x8A, 0x8D, 0x8D, 0x89, 0x82, 0x7D, 0x7D, 0x79,
	0x73, 0x72, 0x75, 0x78, 0x78, 0x7B, 0x80, 0x84, 0x86, 0x8C, 0xB0, 0xCC,
	0xAE, 0x94, 0xB7, 0xC4, 0x8D, 0x6C, 0x81, 0x81, 0x60, 0x58, 0x64, 0x69,
	0x72, 0x7D, 0x7D, 0x84, 0x97, 0x95, 0x87, 0x8D, 0x93, 0x84, 0x77, 0x7B,
	0x78, 0x70, 0x70, 0x73, 0x74, 0x7A, 0x7F, 0x7F, 0x84, 0x8C, 0x8A, 0x86,
	0x89, 0x89, 0x82, 0x7E, 0x7E, 0x7A, 0x77, 0x78, 0x78, 0x78, 0x7E, 0x81,
	0x7F, 0x84, 0x89, 0x85, 0x84, 0x88, 0xAC, 0xC2, 0x9C, 0x99, 0xCB, 0xB5,
	0x75, 0x86, 0x9D, 0x6C, 0x52, 0x6E, 0x6E, 0x5E, 0x6A, 0x77, 0x7D, 0x8C,
	0x8F, 0x8A, 0x99, 0x9F, 0x8B, 0x86, 0x93, 0x84, 0x70, 0x78, 0x7B, 0x6D,
	0x6D, 0x79, 0x79, 0x79, 0x80, 0x85, 0x88, 0x8A, 0x88, 0x88, 0x8A, 0x83,
	0x7D, 0x80, 0x7E, 0x76, 0x77, 0x7C, 0x79, 0x79, 0x7F, 0x81, 0x84, 0x85,
	0x85, 0x8A, 0x8B, 0xAC, 0xB8, 0x96, 0xAF, 0xCE, 0x96, 0x81, 0xAD, 0x88,
	0x53, 0x74, 0x7B, 0x4D, 0x5C, 0x7B, 0x6C, 0x6E, 0x88, 0x8B, 0x8C, 0x94,
	0x91, 0x92, 0x94, 0x83, 0x82, 0x8A, 0x75, 0x6E, 0x80, 0x76, 0x68, 0x7E,
	0x82, 0x73, 0x80, 0x8D, 0x81, 0x82, 0x8E, 0x87, 0x80, 0x85, 0x83, 0x7D,
	0x7D, 0x7B, 0x7B, 0x7B, 0x79, 0x7C, 0x80, 0x7C, 0x7F, 0x84, 0x81, 0x7B,
	0x90, 0xB2, 0x96, 0x9B, 0xD2, 0xAB, 0x87, 0xBD, 0xA3, 0x5E, 0x87, 0x8C,
	0x47, 0x5C, 0x81, 0x53, 0x58, 0x87, 0x77, 0x6F, 0x92, 0x95, 0x88, 0x92,
	0x97, 0x8E, 0x86, 0x84, 0x80, 0x76, 0x6E, 0x73, 0x72, 0x68, 0x73, 0x7D,
	0x73, 0x7C, 0x8C, 0x81, 0x83, 0x92, 0x88, 0x82, 0x8B, 0x85, 0x7B, 0x81,
	0x7F, 0x78, 0x7A, 0x7D, 0x79, 0x7A, 0x7E, 0x7F, 0x7E, 0x81, 0x7C, 0x86,
	0xA4, 0x8F, 0x9A, 0xC7, 0x9D, 0x9A, 0xC5, 0x90, 0x79, 0xA1, 0x72, 0x53,
	0x7D, 0x62, 0x47, 0x73, 0x6E, 0x5A, 0x7F, 0x87, 0x77, 0x8E, 0x97, 0x88,
	0x90, 0x94, 0x88, 0x85, 0x88, 0x80, 0x7A, 0x7C, 0x7B, 0x77, 0x78, 0x7D,
	0x7A, 0x7B, 0x81, 0x7F, 0x7D, 0x84, 0x82, 0x7F, 0x83, 0x82, 0x7E, 0x82,
	0x81, 0x7D, 0x81, 0x80, 0x7D, 0x81, 0x7F, 0x7E, 0x81, 0x7E, 0x80, 0x7F,
	0x9D, 0x98, 0x95, 0xC2, 0xA9, 0x9F, 0xC3, 0x9B, 0x85, 0xA1, 0x73, 0x5F,
	0x78, 0x58, 0x4D, 0x6D, 0x5C, 0x5B, 0x7D, 0x75, 0x77, 0x93, 0x8B, 0x8A,
	0x9A, 0x91, 0x8A, 0x91, 0x8B, 0x80, 0x86, 0x81, 0x78, 0x7E, 0x7D, 0x75,
	0x7D, 0x7D, 0x78, 0x7E, 0x7F, 0x7B, 0x80, 0x81, 0x7D, 0x82, 0x82, 0x7F,
	0x82, 0x82, 0x7F, 0x82, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7E, 0x99, 0x97, 0x92, 0xBD, 0xA6, 0xA0, 0xBD, 0x97, 0x8B, 0x9C, 0x72,
	0x69, 0x77, 0x57, 0x59, 0x6B, 0x5B, 0x65, 0x7A, 0x72, 0x7E, 0x8E, 0x87,
	0x8E, 0x96, 0x8B, 0x8E, 0x8D, 0x84, 0x83, 0x80, 0x7B, 0x79, 0x79, 0x78,
	0x78, 0x7B, 0x7B, 0x7D, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x81, 0x82, 0x82,
	0x80, 0x80, 0x81, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7F,
	0x7E, 0x80, 0x7E, 0x99, 0x8F, 0x96, 0xB8, 0x99, 0xA7, 0xB5, 0x8B, 0x97,
	0x93, 0x6C, 0x79, 0x70, 0x59, 0x68, 0x67, 0x5F, 0x71, 0x76, 0x74, 0x84,
	0x89, 0x86, 0x91, 0x8E, 0x89, 0x8D, 0x86, 0x82, 0x82, 0x7D, 0x7A, 0x7A,
	0x79, 0x78, 0x7B, 0x7C, 0x7C, 0x80, 0x80, 0x80, 0x83, 0x82, 0x81, 0x83,
	0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7B, 0x80,
	0x7B, 0x7B, 0x80, 0x79, 0x7E, 0x7F, 0x95, 0x8E, 0x99, 0xB5, 0x96, 0xAD,
	0xAE, 0x8B, 0xA0, 0x8A, 0x71, 0x80, 0x67, 0x61, 0x6C, 0x60, 0x66, 0x71,
	0x71, 0x79, 0x83, 0x85, 0x8A, 0x90, 0x8E, 0x8D, 0x8F, 0x88, 0x85, 0x84,
	0x7D, 0x7B, 0x7C, 0x76, 0x78, 0x7A, 0x78, 0x7B, 0x7F, 0x7D, 0x80, 0x84,
	0x80, 0x84, 0x84, 0x81, 0x84, 0x81, 0x80, 0x81, 0x7E, 0x7F, 0x7F, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x82, 0x7F, 0x83, 0x7D, 0x8F, 0x93, 0x8A,
	0xAE, 0x98, 0x9D, 0xB0, 0x8B, 0x9A, 0x91, 0x75, 0x83, 0x70, 0x67, 0x70,
	0x65, 0x69, 0x70, 0x71, 0x78, 0x80, 0x85, 0x87, 0x8F, 0x8E, 0x8B, 0x90,
	0x88, 0x86, 0x86, 0x7C, 0x7E, 0x7B, 0x75, 0x79, 0x77, 0x77, 0x7C, 0x7A,
	0x7D, 0x82, 0x7F, 0x84, 0x84, 0x83, 0x86, 0x82, 0x83, 0x81, 0x7F, 0x7F,
	0x7C, 0x7C, 0x7C, 0x7A, 0x7C, 0x7C, 0x7D, 0x7E, 0x80, 0x7F, 0x83, 0x80,
	0x87, 0x9A, 0x88, 0xA5, 0xA4, 0x93, 0xB2, 0x93, 0x93, 0x9B, 0x79, 0x82,
	0x7A, 0x67, 0x71, 0x69, 0x65, 0x6F, 0x6E, 0x71, 0x7C, 0x7D, 0x81, 0x8B,
	0x88, 0x8B, 0x8F, 0x89, 0x89, 0x89, 0x81, 0x81, 0x7F, 0x79, 0x7B, 0x79,
	0x76, 0x7A, 0x7A, 0x7A, 0x7F, 0x7E, 0x80, 0x84, 0x81, 0x85, 0x85, 0x83,
	0x86, 0x83, 0x82, 0x83, 0x80, 0x7F, 0x7F, 0x7D, 0x7D, 0x7D, 0x7C, 0x7E,
	0x7E, 0x7D, 0x81, 0x7D, 0x93, 0x8B, 0x94, 0xAB, 0x8F, 0xAB, 0xA1, 0x8E,
	0xA1, 0x85, 0x80, 0x84, 0x6B, 0x71, 0x6E, 0x64, 0x6E, 0x6E, 0x6D, 0x79,
	0x7C, 0x7D, 0x88, 0x87, 0x89, 0x8F, 0x89, 0x89, 0x8B, 0x82, 0x84, 0x81,
	0x7B, 0x7D, 0x79, 0x78, 0x7B, 0x78, 0x7B, 0x7D, 0x7D, 0x80, 0x80, 0x82,
	0x83, 0x82, 0x83, 0x82, 0x82, 0x82, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7D,
	0x7E, 0x7E, 0x7D, 0x80, 0x7E, 0x80, 0x7F, 0x91, 0x89, 0x93, 0xA5, 0x8E,
	0xA8, 0x9C, 0x8E, 0x9F, 0x83, 0x83, 0x83, 0x6D, 0x74, 0x6E, 0x66, 0x70,
	0x6D, 0x6F, 0x7A, 0x79, 0x7E, 0x87, 0x83, 0x89, 0x8C, 0x86, 0x8B, 0x87,
	0x82, 0x86, 0x7E, 0x7E, 0x7E, 0x7A, 0x7C, 0x7C, 0x7A, 0x7C, 0x7D, 0x7C,
	0x80, 0x7F, 0x7F, 0x82, 0x80, 0x81, 0x82, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x81, 0x7E, 0x8A, 0x8B, 0x89,
	0xA0, 0x8E, 0x9C, 0x9F, 0x8A, 0x9C, 0x87, 0x82, 0x88, 0x71, 0x78, 0x73,
	0x6A, 0x75, 0x70, 0x72, 0x7A, 0x79, 0x7C, 0x85, 0x81, 0x86, 0x89, 0x82,
	0x89, 0x84, 0x80, 0x86, 0x7D, 0x7F, 0x80, 0x7A, 0x7F, 0x7D, 0x7C, 0x80,
	0x7F, 0x7F, 0x82, 0x80, 0x80, 0x84, 0x7F, 0x82, 0x81, 0x7D, 0x82, 0x7E,
	0x7E, 0x81, 0x7D, 0x7F, 0x80, 0x7D, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x8B,
	0x87, 0x90, 0x95, 0x8E, 0x9A, 0x8F, 0x8F, 0x91, 0x83, 0x87, 0x80, 0x79,
	0x7C, 0x76, 0x77, 0x79, 0x77, 0x7A, 0x7E, 0x7D, 0x81, 0x83, 0x80, 0x86,
	0x82, 0x81, 0x84, 0x7F, 0x81, 0x80, 0x7C, 0x80, 0x7D, 0x7D, 0x80, 0x7D,
	0x80, 0x81, 0x80, 0x82, 0x81, 0x81, 0x82, 0x81, 0x80, 0x81, 0x7F, 0x7F,
	0x80, 0x7D, 0x80, 0x7F, 0x7E, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x86,
	0x86, 0x88, 0x8F, 0x8A, 0x92, 0x8F, 0x8C, 0x90, 0x87, 0x88, 0x85, 0x7F,
	0x81, 0x7D, 0x7C, 0x7D, 0x7C, 0x7D, 0x7F, 0x7F, 0x81, 0x83, 0x81, 0x84,
	0x83, 0x82, 0x84, 0x80, 0x81, 0x81, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x85,
	0x84, 0x88, 0x8A, 0x87, 0x8C, 0x88, 0x89, 0x89, 0x84, 0x86, 0x82, 0x81,
	0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x81, 0x82, 0x81, 0x83,
	0x81, 0x82, 0x82, 0x81, 0x82, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x83, 0x83,
	0x85, 0x86, 0x85, 0x87, 0x85, 0x86, 0x86, 0x84, 0x84, 0x83, 0x82, 0x82,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81,
	0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82,
	0x82, 0x83, 0x82, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81,
	0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F
};
const unsigned char WAV30[] = {
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x81,
	0x81, 0x82, 0x82, 0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x81, 0x80,
	0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x81, 0x80, 0x81, 0x82, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81,
	0x83, 0x81, 0x7E, 0x7E, 0x7E, 0x7D, 0x7C, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E,
	0x7F, 0x80, 0x82, 0x86, 0x86, 0x86, 0x86, 0x86, 0x84, 0x82, 0x81, 0x7F,
	0x7D, 0x7C, 0x7D, 0x7D, 0x88, 0x8D, 0x8D, 0x91, 0x92, 0x91, 0x8A, 0x85,
	0x84, 0x7D, 0x79, 0x78, 0x78, 0x79, 0x79, 0x7D, 0x80, 0x81, 0x83, 0x84,
	0x85, 0x83, 0x82, 0x83, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x7D, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7D, 0x8C, 0xA0, 0x98, 0x9D, 0xA2, 0x9F, 0x96, 0x86, 0x84,
	0x7F, 0x70, 0x6E, 0x70, 0x74, 0x76, 0x77, 0x83, 0x88, 0x88, 0x8A, 0x8B,
	0x8B, 0x85, 0x7F, 0x80, 0x7C, 0x78, 0x77, 0x79, 0x7C, 0x7C, 0x7E, 0x82,
	0x84, 0x84, 0x84, 0x85, 0x84, 0x81, 0x7F, 0x7E, 0x7E, 0x7B, 0x7C, 0x7D,
	0x7E, 0x7E, 0x80, 0x81, 0x82, 0x81, 0x81, 0x82, 0x81, 0x7F, 0x7F, 0x7E,
	0x7F, 0x7C, 0x84, 0xAB, 0xA9, 0xA0, 0xAE, 0xAE, 0xA2, 0x8C, 0x7F, 0x7F,
	0x71, 0x61, 0x66, 0x6D, 0x73, 0x74, 0x7E, 0x8D, 0x90, 0x8E, 0x8F, 0x90,
	0x8B, 0x81, 0x7A, 0x77, 0x75, 0x71, 0x70, 0x75, 0x7B, 0x7E, 0x81, 0x87,
	0x8A, 0x89, 0x87, 0x86, 0x84, 0x7F, 0x7B, 0x7A, 0x7A, 0x79, 0x79, 0x7C,
	0x7F, 0x81, 0x82, 0x83, 0x85, 0x84, 0x83, 0x80, 0x81, 0x81, 0x81, 0x7D,
	0x80, 0x7D, 0x94, 0xBE, 0xB1, 0xA3, 0xB5, 0xB5, 0x95, 0x7E, 0x75, 0x71,
	0x65, 0x57, 0x5E, 0x71, 0x78, 0x7A, 0x88, 0x96, 0x9A, 0x93, 0x8E, 0x8E,
	0x87, 0x7A, 0x71, 0x71, 0x72, 0x70, 0x71, 0x79, 0x82, 0x85, 0x87, 0x8A,
	0x8D, 0x8A, 0x84, 0x80, 0x7F, 0x7B, 0x77, 0x76, 0x79, 0x7B, 0x7C, 0x7F,
	0x82, 0x85, 0x85, 0x84, 0x84, 0x83, 0x81, 0x7D, 0x7D, 0x77, 0x77, 0x77,
	0x7B, 0x77, 0x8F, 0xC2, 0xBD, 0xA2, 0xB0, 0xBD, 0x97, 0x76, 0x6F, 0x6B,
	0x60, 0x59, 0x5A, 0x6D, 0x82, 0x85, 0x87, 0x98, 0xA2, 0x96, 0x8B, 0x87,
	0x83, 0x78, 0x6D, 0x6A, 0x70, 0x75, 0x76, 0x7A, 0x85, 0x8D, 0x8C, 0x89,
	0x8A, 0x89, 0x83, 0x7C, 0x79, 0x78, 0x78, 0x76, 0x78, 0x7D, 0x81, 0x83,
	0x83, 0x86, 0x87, 0x85, 0x81, 0x80, 0x7E, 0x7D, 0x7A, 0x79, 0x78, 0x7D,
	0x7C, 0x7F, 0x7D, 0x9F, 0xCC, 0xBC, 0x9B, 0xAB, 0xBB, 0x8E, 0x66, 0x6A,
	0x6E, 0x5E, 0x5B, 0x64, 0x72, 0x86, 0x91, 0x8C, 0x91, 0xA1, 0x9A, 0x81,
	0x7C, 0x82, 0x76, 0x64, 0x65, 0x70, 0x74, 0x77, 0x7D, 0x86, 0x8D, 0x92,
	0x8C, 0x87, 0x88, 0x86, 0x7A, 0x74, 0x76, 0x78, 0x76, 0x77, 0x7D, 0x81,
	0x86, 0x86, 0x86, 0x86, 0x87, 0x83, 0x7E, 0x7C, 0x7D, 0x7B, 0x79, 0x7A,
	0x7E, 0x80, 0x80, 0x83, 0x82, 0xA2, 0xCE, 0xC0, 0x96, 0xA0, 0xB8, 0x93,
	0x60, 0x61, 0x72, 0x65, 0x5C, 0x67, 0x77, 0x86, 0x95, 0x93, 0x8D, 0x97,
	0x9D, 0x88, 0x74, 0x7B, 0x81, 0x72, 0x68, 0x74, 0x7E, 0x7F, 0x81, 0x87,
	0x89, 0x8B, 0x8C, 0x85, 0x7D, 0x7E, 0x80, 0x78, 0x73, 0x78, 0x7E, 0x7D,
	0x7D, 0x82, 0x85, 0x85, 0x86, 0x83, 0x81, 0x80, 0x80, 0x7B, 0x78, 0x7B,
	0x7E, 0x7D, 0x7D, 0x81, 0x83, 0x84, 0x81, 0x92, 0xC1, 0xCF, 0xA4, 0x8B,
	0xA6, 0xA8, 0x77, 0x54, 0x64, 0x72, 0x6A, 0x67, 0x74, 0x84, 0x93, 0x9C,
	0x94, 0x8A, 0x90, 0x94, 0x80, 0x6A, 0x6C, 0x78, 0x75, 0x6E, 0x75, 0x83,
	0x89, 0x8B, 0x8C, 0x89, 0x87, 0x88, 0x83, 0x78, 0x74, 0x79, 0x7B, 0x77,
	0x78, 0x7F, 0x85, 0x86, 0x85, 0x85, 0x85, 0x83, 0x81, 0x7D, 0x78, 0x79,
	0x7C, 0x7C, 0x7B, 0x7D, 0x82, 0x84, 0x83, 0x82, 0x83, 0x82, 0x9E, 0xC9,
	0xC6, 0x95, 0x85, 0xA1, 0x9F, 0x6E, 0x51, 0x64, 0x77, 0x74, 0x71, 0x7C,
	0x89, 0x97, 0x9D, 0x94, 0x82, 0x82, 0x89, 0x80, 0x6A, 0x67, 0x76, 0x7E,
	0x7A, 0x7B, 0x84, 0x8C, 0x8D, 0x8B, 0x85, 0x7F, 0x7F, 0x7F, 0x79, 0x73,
	0x76, 0x7E, 0x81, 0x7E, 0x80, 0x85, 0x88, 0x85, 0x82, 0x81, 0x80, 0x7F,
	0x7D, 0x7B, 0x7B, 0x7D, 0x7F, 0x80, 0x80, 0x81, 0x83, 0x83, 0x81, 0x80,
	0x80, 0x9C, 0xC6, 0xC3, 0x95, 0x87, 0xA1, 0x9E, 0x6F, 0x54, 0x65, 0x78,
	0x75, 0x72, 0x7C, 0x88, 0x94, 0x9A, 0x90, 0x80, 0x81, 0x88, 0x7E, 0x6B,
	0x6B, 0x7A, 0x7F, 0x7A, 0x7C, 0x86, 0x8B, 0x8B, 0x87, 0x82, 0x7F, 0x80,
	0x7E, 0x78, 0x74, 0x7A, 0x80, 0x80, 0x7E, 0x81, 0x86, 0x8A, 0x89, 0x85,
	0x82, 0x84, 0x83, 0x7E, 0x7A, 0x7B, 0x7D, 0x7D, 0x7D, 0x7D, 0x80, 0x82,
	0x83, 0x81, 0x81, 0x80, 0x8D, 0xAB, 0xB4, 0xA0, 0x97, 0xA1, 0x9C, 0x86,
	0x74, 0x70, 0x71, 0x71, 0x6A, 0x64, 0x6E, 0x7B, 0x7C, 0x7B, 0x7F, 0x86,
	0x8B, 0x8A, 0x85, 0x84, 0x87, 0x86, 0x80, 0x7C, 0x7D, 0x7E, 0x7E, 0x7B,
	0x7A, 0x7D, 0x80, 0x7F, 0x7E, 0x7F, 0x81, 0x82, 0x81, 0x81, 0x83, 0x83,
	0x83, 0x81, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x89, 0x93, 0x90, 0x8D,
	0x93, 0x95, 0x8E, 0x89, 0x84, 0x80, 0x7F, 0x7A, 0x71, 0x6E, 0x71, 0x72,
	0x70, 0x72, 0x78, 0x7C, 0x7A, 0x7C, 0x83, 0x85, 0x7F, 0x83, 0x86, 0x80,
	0x7F, 0x84, 0x82, 0x7D, 0x7D, 0x7B, 0x7D, 0x80, 0x7D, 0x80, 0x85, 0x80,
	0x81, 0x87, 0x80, 0x7E, 0x85, 0x82, 0x7E, 0x7F, 0x7C, 0x7E, 0x80, 0x7D,
	0x80, 0x84, 0x7D, 0x80, 0x86, 0x80, 0x80, 0x83, 0x80, 0x81, 0x82, 0x80,
	0x82, 0x83, 0x80, 0x83, 0x83, 0x80, 0x85, 0x83, 0x7F, 0x83, 0x81, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x81, 0x82, 0x83, 0x87, 0x86, 0x85, 0x87,
	0x85, 0x83, 0x85, 0x82, 0x83, 0x84, 0x7E, 0x7E, 0x84, 0x80, 0x7E, 0x83,
	0x81, 0x7B, 0x7C, 0x7E, 0x7B, 0x7B, 0x7E, 0x81, 0x80, 0x81, 0x86, 0x87,
	0x84, 0x89, 0x8B, 0x89, 0x89, 0x89, 0x88, 0x85, 0x84, 0x83, 0x7E, 0x7E,
	0x7D, 0x79, 0x7D, 0x7C, 0x7A, 0x77, 0x79, 0x7A, 0x77, 0x76, 0x75, 0x75,
	0x74, 0x75, 0x77, 0x78, 0x7B, 0x7E, 0x7F, 0x83, 0x89, 0x86, 0x88, 0x8F,
	0x8B, 0x89, 0x8D, 0x88, 0x80, 0x82, 0x7F, 0x7A, 0x7A, 0x7B, 0x7A, 0x77,
	0x7C, 0x80, 0x7D, 0x80, 0x85, 0x7F, 0x81, 0x81, 0x7D, 0x7E, 0x7A, 0x77,
	0x7A, 0x7B, 0x7A, 0x7B, 0x77, 0x79, 0x79, 0x78, 0x76, 0x73, 0x75, 0x73,
	0x74, 0x77, 0x79, 0x7E, 0x7F, 0x82, 0x81, 0x80, 0x7E, 0x7A, 0x7C, 0x74,
	0x75, 0x77, 0x6E, 0x73, 0x74, 0x76, 0x78, 0x7E, 0x83, 0x80, 0x8D, 0x91,
	0x8D, 0x91, 0x95, 0x8E, 0x8D, 0x93, 0x8F, 0x8B, 0x91, 0x8F, 0x87, 0x88,
	0x84, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x84, 0x83, 0x80, 0x84, 0x84,
	0x87, 0x8A, 0x8A, 0x8A, 0x89, 0x8A, 0x89, 0x86, 0x87, 0x8A, 0x80, 0x7E,
	0x82, 0x7A, 0x77, 0x7B, 0x7A, 0x76, 0x7B, 0x7E, 0x7C, 0x7E, 0x98, 0x98,
	0x91, 0xAF, 0xA5, 0x99, 0xA2, 0x98, 0x85, 0x7F, 0x81, 0x6D, 0x69, 0x73,
	0x6A, 0x6C, 0x79, 0x7B, 0x7B, 0x85, 0x8C, 0x85, 0x89, 0x8D, 0x84, 0x83,
	0x85, 0x7D, 0x7A, 0x7D, 0x7B, 0x78, 0x7D, 0x7E, 0x7C, 0x80, 0x82, 0x80,
	0x82, 0x83, 0x81, 0x81, 0x82, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E,
	0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x7D, 0x7F, 0x7D, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7F, 0x81, 0x80, 0x80, 0x82, 0x80, 0x81, 0x80, 0x81, 0x7D, 0x87,
	0x9C, 0x8B, 0xA3, 0xAD, 0x97, 0xA7, 0x9F, 0x8E, 0x88, 0x84, 0x74, 0x6A,
	0x74, 0x64, 0x68, 0x75, 0x6E, 0x78, 0x81, 0x83, 0x85, 0x8B, 0x8B, 0x85,
	0x8B, 0x85, 0x7F, 0x82, 0x7D, 0x7A, 0x7C, 0x7C, 0x7A, 0x7C, 0x80, 0x7D,
	0x80, 0x83, 0x80, 0x82, 0x83, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x80, 0x7D,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x81, 0x7E, 0x7D, 0x7F, 0x7C,
	0x79, 0x8B, 0x96, 0x86, 0xAD, 0xA4, 0x95, 0xAF, 0x95, 0x8C, 0x8D, 0x7C,
	0x6F, 0x6F, 0x6D, 0x60, 0x6F, 0x70, 0x6E, 0x80, 0x7F, 0x83, 0x8A, 0x8A,
	0x89, 0x89, 0x89, 0x81, 0x83, 0x81, 0x7A, 0x7F, 0x7C, 0x7B, 0x7E, 0x7E,
	0x7F, 0x7F, 0x81, 0x80, 0x81, 0x82, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x7E,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x7E, 0x82, 0x7F, 0x7F, 0x81, 0x7D,
	0x80, 0x7F, 0x7D, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x7F,
	0x82, 0x7E, 0x81, 0x7D, 0x8C, 0x97, 0x86, 0xAC, 0x9F, 0x94, 0xAE, 0x8E,
	0x8B, 0x8D, 0x76, 0x70, 0x71, 0x66, 0x63, 0x70, 0x69, 0x6F, 0x80, 0x79,
	0x84, 0x8C, 0x85, 0x8C, 0x8C, 0x85, 0x86, 0x85, 0x7E, 0x7F, 0x7F, 0x79,
	0x7E, 0x7D, 0x7B, 0x80, 0x7F, 0x7E, 0x82, 0x80, 0x80, 0x83, 0x80, 0x81,
	0x81, 0x80, 0x80, 0x81, 0x7E, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x80,
	0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7E, 0x7D, 0x7F, 0x79, 0x7F, 0x7A, 0x8D, 0x8F, 0x8A, 0xAD,
	0x95, 0x9F, 0xAB, 0x8A, 0x96, 0x8A, 0x75, 0x7A, 0x6F, 0x66, 0x6B, 0x6C,
	0x68, 0x75, 0x79, 0x78, 0x88, 0x84, 0x87, 0x8E, 0x87, 0x89, 0x88, 0x82,
	0x81, 0x81, 0x7B, 0x7C, 0x7D, 0x78, 0x7D, 0x7D, 0x7B, 0x81, 0x7F, 0x80,
	0x83, 0x80, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7E, 0x81,
	0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x96, 0x87, 0x9A, 0xA8, 0x8D, 0xAA, 0x9B, 0x89, 0x9A, 0x7F,
	0x79, 0x7E, 0x6A, 0x6C, 0x6F, 0x68, 0x6E, 0x76, 0x73, 0x7C, 0x84, 0x7F,
	0x8A, 0x8A, 0x85, 0x8D, 0x86, 0x83, 0x86, 0x7F, 0x7E, 0x7F, 0x7B, 0x7B,
	0x7E, 0x7A, 0x7E, 0x80, 0x7C, 0x83, 0x81, 0x81, 0x85, 0x81, 0x81, 0x83,
	0x7F, 0x80, 0x80, 0x7D, 0x7F, 0x7F, 0x7D, 0x7F, 0x7F, 0x7E, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x81, 0x7D, 0x86, 0x91, 0x84, 0xA0,
	0x98, 0x92, 0xAB, 0x8E, 0x95, 0x96, 0x7B, 0x86, 0x79, 0x6C, 0x75, 0x6A,
	0x6B, 0x72, 0x6F, 0x75, 0x7C, 0x7D, 0x82, 0x87, 0x86, 0x88, 0x8A, 0x85,
	0x87, 0x85, 0x80, 0x82, 0x7F, 0x7D, 0x7F, 0x7C, 0x7D, 0x7E, 0x7D, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7D,
	0x7E, 0x7E, 0x7D, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x81,
	0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x8A, 0x88, 0x8E, 0x9B, 0x8E, 0x9E, 0x9A, 0x8F,
	0x9B, 0x87, 0x86, 0x85, 0x74, 0x78, 0x71, 0x6C, 0x72, 0x6E, 0x71, 0x77,
	0x77, 0x7B, 0x80, 0x80, 0x83, 0x85, 0x83, 0x85, 0x84, 0x82, 0x84, 0x81,
	0x81, 0x82, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7E,
	0x7F, 0x7E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x81,
	0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E,
	0x85, 0x86, 0x86, 0x93, 0x8C, 0x94, 0x97, 0x8D, 0x97, 0x8C, 0x87, 0x8B,
	0x7C, 0x80, 0x7B, 0x73, 0x7A, 0x73, 0x75, 0x79, 0x76, 0x7B, 0x7D, 0x7C,
	0x7F, 0x80, 0x7E, 0x81, 0x80, 0x7E, 0x82, 0x7E, 0x80, 0x81, 0x7D, 0x82,
	0x80, 0x80, 0x83, 0x80, 0x82, 0x82, 0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x85, 0x84, 0x8A,
	0x8B, 0x8B, 0x90, 0x8B, 0x8E, 0x8B, 0x87, 0x88, 0x82, 0x81, 0x7F, 0x7C,
	0x7D, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7F, 0x7F, 0x80, 0x82, 0x80, 0x82,
	0x82, 0x80, 0x82, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x7E, 0x7E, 0x7F, 0x7E,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x83, 0x82, 0x85, 0x87, 0x86, 0x89, 0x87,
	0x87, 0x88, 0x85, 0x86, 0x84, 0x83, 0x83, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x82, 0x80, 0x82, 0x81,
	0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x82, 0x82, 0x84, 0x84, 0x84, 0x85, 0x84, 0x85, 0x85, 0x85, 0x86,
	0x85, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82,
	0x82, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F
};
const unsigned char WAV4[] = {
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x81,
	0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x81,
	0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x81, 0x81,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x81, 0x7F, 0x7E, 0x82, 0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x80, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x81, 0x80, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81,
	0x7E, 0x7E, 0x80, 0x7E, 0x7E, 0x7D, 0x7D, 0x80, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x82, 0x7F, 0x81, 0x81, 0x82, 0x83, 0x81, 0x7F, 0x7D, 0x7E,
	0x7E, 0x80, 0x81, 0x82, 0x82, 0x81, 0x81, 0x82, 0x81, 0x82, 0x83, 0x83,
	0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x82, 0x88, 0x8C, 0x8E, 0x8D, 0x89, 0x84, 0x80, 0x7D, 0x7C, 0x7C, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x84, 0x8C, 0x96, 0xA2,
	0xA7, 0xA6, 0x9E, 0x8F, 0x80, 0x73, 0x6B, 0x69, 0x6C, 0x72, 0x78, 0x7C,
	0x7E, 0x7F, 0x7F, 0x81, 0x83, 0x85, 0x87, 0x87, 0x85, 0x82, 0x7E, 0x7B,
	0x7A, 0x7A, 0x7C, 0x7E, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x86, 0x90, 0x9D, 0xAB, 0xB3, 0xB3, 0xA8,
	0x95, 0x7E, 0x69, 0x59, 0x53, 0x55, 0x5F, 0x6C, 0x78, 0x83, 0x89, 0x8C,
	0x8C, 0x8C, 0x8B, 0x8A, 0x88, 0x85, 0x81, 0x7D, 0x7A, 0x78, 0x78, 0x7A,
	0x7D, 0x80, 0x83, 0x84, 0x83, 0x82, 0x80, 0x7E, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7E, 0x7E, 0x84, 0x8E, 0x9C, 0xAC, 0xB6, 0xBA, 0xB2, 0xA0, 0x88, 0x6F,
	0x5A, 0x4E, 0x4D, 0x54, 0x62, 0x71, 0x7F, 0x89, 0x8E, 0x8F, 0x8F, 0x8D,
	0x8B, 0x88, 0x86, 0x83, 0x7F, 0x7D, 0x7B, 0x7B, 0x7D, 0x80, 0x83, 0x85,
	0x85, 0x83, 0x80, 0x7C, 0x7A, 0x78, 0x79, 0x7B, 0x7E, 0x80, 0x82, 0x83,
	0x83, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x81, 0x89, 0x94, 0xA3, 0xB2, 0xB9, 0xB7, 0xAA, 0x93, 0x78, 0x60, 0x4F,
	0x4B, 0x50, 0x5D, 0x6F, 0x7E, 0x8A, 0x92, 0x95, 0x95, 0x93, 0x8F, 0x8A,
	0x84, 0x7E, 0x78, 0x75, 0x73, 0x75, 0x79, 0x7E, 0x83, 0x86, 0x87, 0x85,
	0x82, 0x7E, 0x7C, 0x7A, 0x7B, 0x7C, 0x7E, 0x80, 0x81, 0x82, 0x82, 0x81,
	0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x81, 0x81,
	0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x85, 0x91, 0xA0, 0xB0, 0xBC, 0xBB, 0xAF, 0x99, 0x7C, 0x63, 0x53,
	0x4D, 0x53, 0x61, 0x70, 0x7E, 0x88, 0x8D, 0x8E, 0x8E, 0x8B, 0x8A, 0x87,
	0x82, 0x7E, 0x7A, 0x77, 0x77, 0x79, 0x7E, 0x83, 0x86, 0x87, 0x86, 0x83,
	0x7F, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7E,
	0x80, 0x81, 0x82, 0x84, 0x8E, 0x9E, 0xAE, 0xBC, 0xBF, 0xB1, 0x98, 0x7A,
	0x5D, 0x4C, 0x4B, 0x54, 0x66, 0x79, 0x85, 0x8C, 0x8F, 0x8D, 0x8C, 0x8D,
	0x8C, 0x89, 0x86, 0x80, 0x78, 0x75, 0x75, 0x78, 0x7E, 0x83, 0x85, 0x85,
	0x83, 0x7F, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7F,
	0x81, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x81, 0x82, 0x83, 0x83, 0x81,
	0x7E, 0x7D, 0x7C, 0x7D, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x86, 0x9A, 0xB1, 0xC1,
	0xC6, 0xB8, 0x98, 0x76, 0x5D, 0x50, 0x53, 0x61, 0x6F, 0x79, 0x82, 0x87,
	0x8A, 0x90, 0x95, 0x94, 0x8E, 0x84, 0x77, 0x6E, 0x6C, 0x71, 0x77, 0x80,
	0x86, 0x86, 0x85, 0x84, 0x83, 0x83, 0x85, 0x84, 0x80, 0x7D, 0x7A, 0x78,
	0x7A, 0x7F, 0x81, 0x82, 0x83, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E,
	0x7F, 0x7E, 0x7D, 0x7D, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x8C, 0xA9, 0xC6, 0xD2, 0xC8, 0xAA, 0x7E, 0x5B, 0x4F,
	0x53, 0x5F, 0x70, 0x7A, 0x7C, 0x81, 0x8F, 0x9B, 0xA2, 0xA2, 0x94, 0x7D,
	0x6B, 0x66, 0x68, 0x6F, 0x7A, 0x80, 0x7F, 0x81, 0x87, 0x8B, 0x8E, 0x8F,
	0x89, 0x7D, 0x76, 0x73, 0x73, 0x78, 0x7F, 0x81, 0x80, 0x81, 0x83, 0x85,
	0x8A, 0x8E, 0x8A, 0x83, 0x7D, 0x78, 0x75, 0x79, 0x7D, 0x7E, 0x7E, 0x80,
	0x81, 0x82, 0x85, 0x87, 0x84, 0x80, 0x7E, 0x7B, 0x7A, 0x7C, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x82, 0x80, 0x78, 0x74, 0x74, 0x77, 0x7B, 0x8A,
	0xAB, 0xCA, 0xD1, 0xBF, 0x9E, 0x78, 0x5E, 0x5B, 0x63, 0x68, 0x6B, 0x70,
	0x76, 0x82, 0x96, 0xA5, 0xA4, 0x98, 0x88, 0x77, 0x6C, 0x6D, 0x71, 0x72,
	0x71, 0x75, 0x7C, 0x84, 0x8F, 0x96, 0x92, 0x88, 0x81, 0x7B, 0x76, 0x76,
	0x78, 0x78, 0x77, 0x7A, 0x80, 0x85, 0x88, 0x8B, 0x88, 0x82, 0x7F, 0x7D,
	0x7B, 0x7A, 0x7B, 0x7B, 0x7B, 0x7E, 0x83, 0x85, 0x85, 0x85, 0x83, 0x80,
	0x7E, 0x7E, 0x7E, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x82, 0x83, 0x82, 0x81,
	0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x7D, 0x7D, 0x7E, 0x82, 0x9A, 0xC2, 0xD8,
	0xC5, 0x9E, 0x7B, 0x65, 0x60, 0x6B, 0x74, 0x6C, 0x65, 0x71, 0x89, 0x9D,
	0xA8, 0xA6, 0x92, 0x7B, 0x73, 0x76, 0x75, 0x71, 0x70, 0x6F, 0x72, 0x7F,
	0x91, 0x97, 0x91, 0x89, 0x83, 0x7B, 0x78, 0x79, 0x78, 0x72, 0x72, 0x7A,
	0x83, 0x87, 0x8B, 0x8B, 0x85, 0x80, 0x80, 0x80, 0x7C, 0x78, 0x78, 0x79,
	0x7B, 0x80, 0x86, 0x86, 0x83, 0x82, 0x83, 0x81, 0x7F, 0x7E, 0x7C, 0x79,
	0x7A, 0x7F, 0x82, 0x81, 0x82, 0x83, 0x82, 0x80, 0x81, 0x81, 0x7E, 0x7B,
	0x7D, 0x7E, 0x7F, 0x7F, 0x81, 0x81, 0x82, 0x9A, 0xC7, 0xDB, 0xBB, 0x87,
	0x6A, 0x66, 0x6D, 0x76, 0x76, 0x68, 0x63, 0x7E, 0xA4, 0xAF, 0x9C, 0x86,
	0x7C, 0x79, 0x7C, 0x7D, 0x73, 0x64, 0x67, 0x7F, 0x92, 0x93, 0x8C, 0x86,
	0x83, 0x82, 0x85, 0x82, 0x74, 0x6B, 0x72, 0x7F, 0x85, 0x85, 0x85, 0x86,
	0x88, 0x8C, 0x8A, 0x7F, 0x74, 0x74, 0x7B, 0x7F, 0x7D, 0x7D, 0x7F, 0x83,
	0x87, 0x89, 0x85, 0x7E, 0x7B, 0x7D, 0x7F, 0x7D, 0x7B, 0x7C, 0x7F, 0x82,
	0x84, 0x84, 0x82, 0x7F, 0x7F, 0x81, 0x7F, 0x7C, 0x7B, 0x7D, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x80, 0x86, 0xA7, 0xCE, 0xCA, 0x94, 0x69, 0x70, 0x86,
	0x7E, 0x64, 0x5C, 0x6B, 0x85, 0x9D, 0xA4, 0x93, 0x7E, 0x81, 0x90, 0x89,
	0x70, 0x62, 0x6D, 0x7D, 0x85, 0x86, 0x84, 0x84, 0x89, 0x8F, 0x8B, 0x7C,
	0x71, 0x75, 0x7E, 0x7E, 0x79, 0x7A, 0x81, 0x87, 0x89, 0x87, 0x82, 0x7D,
	0x7D, 0x7F, 0x7E, 0x78, 0x78, 0x7E, 0x84, 0x83, 0x81, 0x82, 0x83, 0x82,
	0x80, 0x7E, 0x7C, 0x7C, 0x7D, 0x80, 0x80, 0x7F, 0x80, 0x83, 0x83, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x80,
	0x7F, 0x84, 0xA3, 0xC5, 0xB7, 0x7E, 0x65, 0x85, 0x99, 0x75, 0x4F, 0x61,
	0x8C, 0x99, 0x8C, 0x85, 0x8A, 0x8F, 0x8F, 0x87, 0x74, 0x66, 0x70, 0x83,
	0x83, 0x77, 0x79, 0x8C, 0x94, 0x8C, 0x83, 0x82, 0x7F, 0x7B, 0x7A, 0x7A,
	0x77, 0x79, 0x83, 0x89, 0x85, 0x81, 0x84, 0x87, 0x81, 0x7A, 0x7A, 0x7C,
	0x7C, 0x7C, 0x7F, 0x81, 0x82, 0x83, 0x84, 0x82, 0x7E, 0x7D, 0x7F, 0x7D,
	0x79, 0x7A, 0x7F, 0x82, 0x80, 0x80, 0x82, 0x83, 0x81, 0x7F, 0x7E, 0x7E,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x81, 0x82, 0x81, 0x7F, 0x8E, 0xAD, 0xB6,
	0x93, 0x71, 0x7D, 0x95, 0x82, 0x5F, 0x65, 0x87, 0x93, 0x82, 0x7E, 0x8C,
	0x93, 0x8B, 0x7F, 0x78, 0x78, 0x7C, 0x7F, 0x79, 0x77, 0x81, 0x8C, 0x88,
	0x7E, 0x7F, 0x87, 0x84, 0x79, 0x77, 0x7D, 0x80, 0x7D, 0x7E, 0x81, 0x83,
	0x85, 0x84, 0x80, 0x7E, 0x80, 0x81, 0x7D, 0x7A, 0x7E, 0x82, 0x81, 0x7E,
	0x81, 0x83, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x8D, 0x9F, 0x9E, 0x8C, 0x87, 0x92, 0x8C, 0x76,
	0x6F, 0x7E, 0x84, 0x7C, 0x7C, 0x87, 0x8C, 0x88, 0x84, 0x82, 0x80, 0x7F,
	0x7D, 0x78, 0x79, 0x81, 0x82, 0x7E, 0x80, 0x86, 0x86, 0x7F, 0x7E, 0x81,
	0x7F, 0x7C, 0x7C, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x82, 0x81, 0x7E,
	0x7E, 0x80, 0x7F, 0x7D, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x89, 0x92,
	0x90, 0x8A, 0x8F, 0x92, 0x87, 0x7F, 0x84, 0x86, 0x7F, 0x7E, 0x84, 0x84,
	0x81, 0x82, 0x83, 0x81, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7D, 0x81,
	0x82, 0x7F, 0x7E, 0x81, 0x81, 0x7F, 0x81, 0x82, 0x80, 0x80, 0x81, 0x80,
	0x7F, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x82, 0x80, 0x7F, 0x81, 0x7F, 0x7C, 0x7D,
	0x80, 0x7E, 0x7E, 0x82, 0x84, 0x83, 0x85, 0x86, 0x83, 0x82, 0x84, 0x82,
	0x81, 0x85, 0x86, 0x84, 0x84, 0x82, 0x81, 0x82, 0x82, 0x80, 0x81, 0x83,
	0x81, 0x80, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7D, 0x7D, 0x7F, 0x7E, 0x7E, 0x81, 0x83, 0x81, 0x82, 0x83, 0x82,
	0x81, 0x84, 0x83, 0x81, 0x83, 0x85, 0x82, 0x81, 0x84, 0x84, 0x80, 0x81,
	0x83, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7C,
	0x7D, 0x7D, 0x7C, 0x7D, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x82, 0x81, 0x80, 0x82, 0x81, 0x7F, 0x80,
	0x82, 0x81, 0x80, 0x82, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7C, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7D, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81, 0x82, 0x82, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80
};
const unsigned char WAV40[] = {
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x81,
	0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x7E,
	0x81, 0x80, 0x7F, 0x7C, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7F,
	0x81, 0x80, 0x7D, 0x7F, 0x80, 0x7E, 0x80, 0x82, 0x80, 0x7E, 0x7E, 0x7E,
	0x81, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F,
	0x7E, 0x80, 0x82, 0x81, 0x82, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7E, 0x7E, 0x7D, 0x7E, 0x80, 0x7D, 0x7D, 0x7F, 0x81, 0x82, 0x84, 0x84,
	0x82, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x81, 0x7E, 0x7F, 0x81,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x81, 0x86, 0x8B,
	0x8E, 0x8F, 0x8C, 0x87, 0x82, 0x7E, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x83,
	0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x83, 0x82, 0x85, 0x8D, 0x97, 0xA2,
	0xA9, 0xA8, 0x9F, 0x92, 0x80, 0x72, 0x6A, 0x67, 0x6B, 0x71, 0x77, 0x7D,
	0x80, 0x81, 0x83, 0x85, 0x87, 0x89, 0x8A, 0x88, 0x85, 0x80, 0x7B, 0x77,
	0x76, 0x76, 0x79, 0x7D, 0x80, 0x82, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x81, 0x82, 0x83, 0x8A, 0x95, 0xA1, 0xAF, 0xB6,
	0xB3, 0xA7, 0x94, 0x7D, 0x69, 0x5C, 0x56, 0x5B, 0x64, 0x6E, 0x79, 0x81,
	0x85, 0x89, 0x8B, 0x8B, 0x8C, 0x8B, 0x89, 0x85, 0x80, 0x7B, 0x79, 0x78,
	0x79, 0x7D, 0x80, 0x83, 0x84, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x88, 0x96, 0xA5, 0xB5, 0xBD, 0xB9,
	0xAB, 0x94, 0x79, 0x62, 0x54, 0x4F, 0x54, 0x60, 0x6C, 0x79, 0x82, 0x87,
	0x8B, 0x8D, 0x8E, 0x8F, 0x8E, 0x8A, 0x85, 0x7F, 0x79, 0x76, 0x76, 0x78,
	0x7C, 0x81, 0x83, 0x84, 0x84, 0x81, 0x7F, 0x7E, 0x7D, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x81, 0x80, 0x80, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x84, 0x92, 0xA3, 0xB6, 0xC2, 0xC0, 0xB1,
	0x98, 0x78, 0x5D, 0x4D, 0x48, 0x4F, 0x5E, 0x6E, 0x7B, 0x86, 0x8B, 0x8D,
	0x90, 0x91, 0x90, 0x8E, 0x89, 0x82, 0x7B, 0x76, 0x73, 0x75, 0x7A, 0x7F,
	0x85, 0x88, 0x86, 0x84, 0x80, 0x7D, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x81, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7E, 0x7F, 0x80, 0x80, 0x83, 0x90, 0xA5, 0xBA, 0xCB, 0xCF, 0xBE, 0x9F,
	0x7B, 0x57, 0x41, 0x3E, 0x47, 0x59, 0x6F, 0x7E, 0x88, 0x8E, 0x91, 0x92,
	0x94, 0x94, 0x90, 0x8A, 0x80, 0x76, 0x71, 0x70, 0x73, 0x7A, 0x81, 0x85,
	0x86, 0x85, 0x82, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7D, 0x80, 0x82, 0x83, 0x83, 0x82, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7E, 0x7D, 0x87, 0xA0, 0xBA, 0xCF, 0xD6, 0xC5, 0xA1,
	0x7A, 0x57, 0x41, 0x41, 0x4E, 0x5E, 0x6E, 0x7C, 0x82, 0x89, 0x92, 0x99,
	0x9D, 0x9D, 0x93, 0x84, 0x77, 0x6D, 0x69, 0x6D, 0x76, 0x7D, 0x82, 0x85,
	0x84, 0x84, 0x86, 0x86, 0x86, 0x85, 0x81, 0x7B, 0x78, 0x78, 0x79, 0x7D,
	0x81, 0x83, 0x83, 0x82, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7D,
	0x7D, 0x7D, 0x7F, 0x83, 0x87, 0x88, 0x91, 0xAC, 0xC6, 0xD5, 0xD5, 0xBD,
	0x90, 0x66, 0x4B, 0x3E, 0x44, 0x57, 0x66, 0x70, 0x7B, 0x84, 0x8E, 0x9D,
	0xA7, 0xA3, 0x97, 0x86, 0x73, 0x68, 0x69, 0x70, 0x77, 0x7E, 0x80, 0x7F,
	0x81, 0x86, 0x8A, 0x8B, 0x8A, 0x82, 0x79, 0x75, 0x76, 0x7A, 0x7F, 0x83,
	0x82, 0x80, 0x7F, 0x7F, 0x81, 0x84, 0x84, 0x81, 0x7D, 0x7B, 0x7A, 0x7D,
	0x81, 0x82, 0x82, 0x83, 0x83, 0x82, 0x84, 0x84, 0x91, 0xB5, 0xD6, 0xDF,
	0xD4, 0xB1, 0x7E, 0x58, 0x4C, 0x4C, 0x51, 0x5B, 0x5F, 0x62, 0x73, 0x8E,
	0xA3, 0xAE, 0xAA, 0x94, 0x7C, 0x71, 0x70, 0x74, 0x7B, 0x7B, 0x73, 0x71,
	0x7B, 0x87, 0x90, 0x93, 0x8A, 0x7C, 0x75, 0x77, 0x7D, 0x82, 0x83, 0x7C,
	0x76, 0x79, 0x80, 0x88, 0x8B, 0x88, 0x7E, 0x78, 0x79, 0x7E, 0x83, 0x85,
	0x80, 0x7A, 0x77, 0x76, 0x76, 0x78, 0x79, 0x78, 0x7A, 0x80, 0x85, 0x91,
	0xB9, 0xE5, 0xED, 0xD8, 0xB4, 0x84, 0x60, 0x59, 0x5B, 0x51, 0x4A, 0x4E,
	0x5A, 0x77, 0x9E, 0xB1, 0xA9, 0x98, 0x89, 0x7E, 0x7E, 0x7F, 0x70, 0x5F,
	0x5C, 0x67, 0x7A, 0x8F, 0x96, 0x8D, 0x84, 0x86, 0x8B, 0x8C, 0x88, 0x7A,
	0x6B, 0x6A, 0x75, 0x81, 0x85, 0x84, 0x7E, 0x7C, 0x83, 0x8D, 0x8D, 0x85,
	0x7A, 0x74, 0x76, 0x7F, 0x82, 0x7E, 0x78, 0x79, 0x7F, 0x86, 0x8B, 0x86,
	0x7E, 0x7B, 0x7E, 0x82, 0x9D, 0xCD, 0xE2, 0xCC, 0xAC, 0x93, 0x7E, 0x76,
	0x75, 0x62, 0x48, 0x4A, 0x63, 0x7E, 0x96, 0xA0, 0x96, 0x8C, 0x95, 0x9D,
	0x92, 0x7E, 0x6B, 0x5E, 0x63, 0x76, 0x7F, 0x79, 0x78, 0x80, 0x8C, 0x97,
	0x99, 0x8C, 0x7B, 0x77, 0x7C, 0x7E, 0x7B, 0x75, 0x6F, 0x73, 0x81, 0x8C,
	0x8B, 0x85, 0x80, 0x7F, 0x83, 0x85, 0x7F, 0x75, 0x73, 0x79, 0x7F, 0x82,
	0x81, 0x7E, 0x7E, 0x85, 0x89, 0x86, 0x7F, 0x7C, 0x7A, 0x84, 0xAE, 0xD7,
	0xCD, 0xA6, 0x92, 0x90, 0x8C, 0x86, 0x73, 0x53, 0x4B, 0x69, 0x86, 0x87,
	0x83, 0x87, 0x90, 0xA0, 0xA8, 0x93, 0x75, 0x6E, 0x78, 0x7A, 0x73, 0x6B,
	0x68, 0x73, 0x8B, 0x97, 0x8C, 0x82, 0x86, 0x8D, 0x8D, 0x85, 0x76, 0x6B,
	0x71, 0x7E, 0x81, 0x7C, 0x7E, 0x85, 0x8C, 0x91, 0x8C, 0x81, 0x7D, 0x82,
	0x82, 0x79, 0x73, 0x75, 0x7B, 0x80, 0x83, 0x81, 0x7F, 0x85, 0x8A, 0x86,
	0x80, 0x7D, 0x7E, 0x7D, 0x8D, 0xBE, 0xD7, 0xB3, 0x92, 0xA3, 0xB0, 0x90,
	0x6B, 0x60, 0x62, 0x6C, 0x7A, 0x76, 0x6C, 0x83, 0xA6, 0xA5, 0x8E, 0x8A,
	0x92, 0x8C, 0x81, 0x76, 0x68, 0x67, 0x78, 0x7F, 0x74, 0x75, 0x88, 0x93,
	0x8E, 0x8A, 0x87, 0x82, 0x81, 0x81, 0x76, 0x6C, 0x74, 0x7E, 0x7B, 0x77,
	0x80, 0x88, 0x88, 0x87, 0x86, 0x83, 0x81, 0x83, 0x7E, 0x77, 0x78, 0x7D,
	0x7D, 0x7A, 0x7D, 0x82, 0x83, 0x83, 0x84, 0x82, 0x81, 0x82, 0x82, 0x7E,
	0x9B, 0xC5, 0xBA, 0x91, 0x9D, 0xBF, 0xA6, 0x73, 0x6E, 0x81, 0x76, 0x66,
	0x6A, 0x71, 0x78, 0x8A, 0x91, 0x85, 0x88, 0x9C, 0x99, 0x81, 0x7A, 0x83,
	0x80, 0x72, 0x71, 0x79, 0x7C, 0x7C, 0x81, 0x83, 0x86, 0x8A, 0x8B, 0x85,
	0x82, 0x85, 0x83, 0x7B, 0x78, 0x7C, 0x7C, 0x7A, 0x7A, 0x7E, 0x80, 0x81,
	0x83, 0x83, 0x83, 0x84, 0x83, 0x80, 0x7E, 0x7F, 0x7E, 0x79, 0x77, 0x7B,
	0x7D, 0x79, 0x7A, 0x7F, 0x81, 0x7F, 0x80, 0x82, 0x88, 0xA0, 0xAD, 0x9A,
	0x93, 0xAA, 0xAE, 0x8C, 0x7C, 0x8C, 0x8B, 0x71, 0x69, 0x77, 0x7A, 0x74,
	0x76, 0x7F, 0x82, 0x86, 0x89, 0x88, 0x87, 0x8C, 0x8B, 0x83, 0x80, 0x84,
	0x82, 0x79, 0x78, 0x7E, 0x7D, 0x78, 0x7A, 0x7F, 0x80, 0x7E, 0x80, 0x82,
	0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7D,
	0x7D, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x89, 0x94, 0x91, 0x8D, 0x95, 0x9E,
	0x96, 0x8B, 0x90, 0x93, 0x88, 0x7D, 0x80, 0x82, 0x7A, 0x73, 0x77, 0x7A,
	0x76, 0x74, 0x78, 0x7C, 0x7B, 0x7B, 0x7E, 0x80, 0x81, 0x81, 0x82, 0x83,
	0x84, 0x83, 0x82, 0x82, 0x82, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7D, 0x7E,
	0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x87, 0x89, 0x86, 0x8A, 0x90, 0x8D, 0x88, 0x8B,
	0x8E, 0x88, 0x83, 0x86, 0x86, 0x7F, 0x7D, 0x80, 0x7F, 0x7B, 0x7B, 0x7D,
	0x7C, 0x7A, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x84, 0x85, 0x84, 0x88, 0x8A, 0x88, 0x87, 0x89, 0x88, 0x85,
	0x85, 0x85, 0x83, 0x81, 0x81, 0x81, 0x7E, 0x7E, 0x7E, 0x7D, 0x7C, 0x7C,
	0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x83, 0x88, 0x84, 0x88, 0x8B, 0x88, 0x87, 0x88, 0x87, 0x82, 0x82, 0x81,
	0x7E, 0x7D, 0x7D, 0x7C, 0x7B, 0x7B, 0x7D, 0x7C, 0x7C, 0x7E, 0x7E, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x7D, 0x89,
	0x92, 0x88, 0x96, 0x98, 0x8F, 0x8F, 0x8E, 0x88, 0x7E, 0x7F, 0x7D, 0x74,
	0x77, 0x7A, 0x77, 0x79, 0x7F, 0x81, 0x7F, 0x84, 0x87, 0x83, 0x83, 0x85,
	0x82, 0x7F, 0x7F, 0x7F, 0x7B, 0x7C, 0x7E, 0x7C, 0x7D, 0x7F, 0x80, 0x7F,
	0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7E, 0x80, 0x7F, 0x7D, 0x7E, 0x7F,
	0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7D,
	0x7D, 0x7F, 0x7D, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x9C,
	0x97, 0x91, 0xAD, 0xA0, 0x93, 0x97, 0x91, 0x7E, 0x74, 0x7B, 0x6E, 0x66,
	0x74, 0x75, 0x6F, 0x7A, 0x85, 0x7E, 0x81, 0x8C, 0x86, 0x81, 0x86, 0x85,
	0x7B, 0x7D, 0x81, 0x7A, 0x79, 0x81, 0x7E, 0x7C, 0x81, 0x83, 0x7F, 0x81,
	0x84, 0x80, 0x7F, 0x82, 0x80, 0x7D, 0x7F, 0x7F, 0x7F, 0x80, 0x82, 0x82,
	0x81, 0x83, 0x82, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7D, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x7F, 0x82, 0x7C, 0x94,
	0xA1, 0x8D, 0xB0, 0xAC, 0x95, 0xA2, 0x96, 0x81, 0x78, 0x79, 0x6A, 0x61,
	0x72, 0x6B, 0x6B, 0x7E, 0x7F, 0x80, 0x89, 0x8F, 0x87, 0x88, 0x8B, 0x81,
	0x7E, 0x81, 0x7A, 0x78, 0x7B, 0x7C, 0x7A, 0x7E, 0x82, 0x7E, 0x83, 0x83,
	0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x7F, 0x7C, 0x7F, 0x7F, 0x7D, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x7E,
	0x7F, 0x7F, 0x81, 0x7F, 0x82, 0x81, 0x81, 0x81, 0x82, 0x7F, 0x80, 0x7E,
	0x84, 0x9E, 0x8B, 0x9F, 0xB1, 0x93, 0xA4, 0x9E, 0x87, 0x84, 0x7E, 0x71,
	0x65, 0x70, 0x69, 0x65, 0x7B, 0x76, 0x7A, 0x88, 0x87, 0x87, 0x8C, 0x8C,
	0x83, 0x85, 0x84, 0x7A, 0x7E, 0x7C, 0x78, 0x7C, 0x7D, 0x7D, 0x7E, 0x81,
	0x81, 0x81, 0x83, 0x81, 0x80, 0x82, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7E, 0x84, 0x82, 0x82, 0x87, 0x82, 0x84, 0x85, 0x80, 0x81, 0x7F,
	0x7E, 0x7C, 0x7D, 0x7C, 0x7C, 0x7E, 0x7E, 0x7E, 0x81, 0x7F, 0x81, 0x81,
	0x80, 0x81, 0x80, 0x9B, 0x8D, 0x94, 0xB3, 0x91, 0x9F, 0xA3, 0x83, 0x88,
	0x81, 0x6E, 0x6B, 0x6F, 0x65, 0x66, 0x77, 0x6F, 0x78, 0x87, 0x7F, 0x8A,
	0x8D, 0x87, 0x8A, 0x88, 0x83, 0x80, 0x81, 0x7C, 0x7A, 0x7E, 0x7A, 0x7C,
	0x80, 0x7D, 0x82, 0x82, 0x82, 0x85, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F,
	0x7F, 0x7D, 0x7E, 0x7E, 0x7D, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x7F, 0x82, 0x7E, 0x81, 0x7D, 0x8F, 0x95, 0x89, 0xAD, 0x9A, 0x96,
	0xAD, 0x8A, 0x8E, 0x8D, 0x72, 0x76, 0x6F, 0x67, 0x68, 0x6E, 0x6D, 0x71,
	0x80, 0x7B, 0x81, 0x8B, 0x83, 0x87, 0x8B, 0x81, 0x84, 0x83, 0x7C, 0x7E,
	0x7E, 0x7A, 0x7D, 0x7E, 0x7C, 0x7F, 0x81, 0x7E, 0x82, 0x82, 0x7F, 0x83,
	0x81, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x7E, 0x7E, 0x80, 0x7D, 0x7F, 0x7F,
	0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x98,
	0x87, 0x99, 0xAC, 0x8C, 0xAC, 0x9E, 0x87, 0x9D, 0x7F, 0x77, 0x7E, 0x68,
	0x6A, 0x6E, 0x68, 0x6D, 0x76, 0x75, 0x7B, 0x86, 0x82, 0x88, 0x8D, 0x86,
	0x8B, 0x89, 0x82, 0x85, 0x80, 0x7D, 0x7E, 0x7B, 0x79, 0x7B, 0x7B, 0x7A,
	0x7E, 0x7D, 0x7E, 0x81, 0x80, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x81, 0x91, 0x87, 0x96, 0xA1, 0x8F, 0xA6, 0x99,
	0x8D, 0x9B, 0x81, 0x7F, 0x80, 0x6D, 0x72, 0x6E, 0x6B, 0x6F, 0x72, 0x75,
	0x78, 0x81, 0x80, 0x85, 0x89, 0x84, 0x89, 0x88, 0x83, 0x86, 0x81, 0x7F,
	0x81, 0x7D, 0x7C, 0x7F, 0x7C, 0x7E, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x81, 0x80, 0x80, 0x82, 0x80, 0x81, 0x82, 0x80, 0x82, 0x81,
	0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x88,
	0x87, 0x89, 0x99, 0x8D, 0x99, 0x9C, 0x8D, 0x99, 0x8B, 0x83, 0x88, 0x76,
	0x77, 0x75, 0x6D, 0x72, 0x70, 0x71, 0x76, 0x78, 0x7A, 0x7F, 0x81, 0x82,
	0x85, 0x84, 0x84, 0x86, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x85, 0x87, 0x86, 0x93, 0x8D, 0x94,
	0x98, 0x8D, 0x97, 0x8C, 0x87, 0x8A, 0x7C, 0x7E, 0x7A, 0x73, 0x78, 0x73,
	0x74, 0x77, 0x77, 0x7A, 0x7D, 0x7D, 0x7F, 0x82, 0x7F, 0x81, 0x82, 0x7E,
	0x82, 0x7F, 0x7F, 0x82, 0x7E, 0x81, 0x81, 0x80, 0x82, 0x80, 0x81, 0x81,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7F, 0x7E, 0x7E, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x7F, 0x83, 0x85, 0x85, 0x8C, 0x8A, 0x8D, 0x90, 0x8B, 0x8F, 0x8A, 0x87,
	0x88, 0x81, 0x81, 0x7F, 0x7B, 0x7D, 0x7B, 0x7B, 0x7D, 0x7D, 0x7E, 0x80,
	0x80, 0x81, 0x83, 0x81, 0x83, 0x82, 0x80, 0x82, 0x80, 0x80, 0x80, 0x7E,
	0x80, 0x7E, 0x7E, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x83, 0x83, 0x87,
	0x87, 0x88, 0x89, 0x87, 0x89, 0x87, 0x86, 0x87, 0x84, 0x84, 0x83, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81,
	0x81, 0x81, 0x82, 0x81, 0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x81, 0x82, 0x82, 0x84, 0x84, 0x84, 0x85, 0x84, 0x86,
	0x85, 0x85, 0x85, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x82, 0x81, 0x81, 0x82, 0x81, 0x82, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F
};
const unsigned char WAV5[] = {
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x81,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x7F,
	0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x7F,
	0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7E,
	0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x7E, 0x7F, 0x80,
	0x81, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x81, 0x83, 0x82,
	0x81, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7F, 0x7F, 0x7D,
	0x7D, 0x7F, 0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x82, 0x83, 0x81,
	0x7E, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x80, 0x82, 0x83,
	0x82, 0x82, 0x7E, 0x7A, 0x7A, 0x7D, 0x7E, 0x7E, 0x7F, 0x7D, 0x7D, 0x80,
	0x83, 0x84, 0x80, 0x7A, 0x79, 0x7C, 0x82, 0x88, 0x87, 0x81, 0x7E, 0x7F,
	0x83, 0x84, 0x80, 0x79, 0x76, 0x78, 0x7F, 0x83, 0x84, 0x7F, 0x83, 0x96,
	0xA5, 0xAC, 0x9A, 0x82, 0x72, 0x6F, 0x7A, 0x7D, 0x7E, 0x7A, 0x7C, 0x88,
	0x8F, 0x90, 0x85, 0x79, 0x74, 0x77, 0x80, 0x81, 0x7F, 0x7B, 0x7C, 0x82,
	0x86, 0x88, 0x81, 0x7B, 0x78, 0x7B, 0x81, 0x82, 0x81, 0x7D, 0x7D, 0x80,
	0x83, 0x84, 0x80, 0x7D, 0x7B, 0x7D, 0x81, 0x82, 0x82, 0x7E, 0x7E, 0x7F,
	0x81, 0x82, 0x80, 0x7C, 0x7A, 0x7A, 0x7D, 0x81, 0x82, 0x82, 0x7F, 0x81,
	0x7D, 0x96, 0xB7, 0xD1, 0xD0, 0xA2, 0x76, 0x50, 0x56, 0x6B, 0x81, 0x8B,
	0x84, 0x89, 0x8E, 0x9D, 0x9B, 0x8A, 0x71, 0x5F, 0x65, 0x76, 0x8B, 0x91,
	0x8C, 0x84, 0x80, 0x86, 0x86, 0x83, 0x76, 0x70, 0x71, 0x7D, 0x8A, 0x8C,
	0x89, 0x7E, 0x7C, 0x7D, 0x81, 0x81, 0x7C, 0x79, 0x78, 0x80, 0x85, 0x89,
	0x84, 0x7E, 0x7B, 0x7D, 0x83, 0x85, 0x83, 0x7D, 0x7B, 0x7D, 0x82, 0x84,
	0x83, 0x7E, 0x7D, 0x7A, 0x9B, 0xC3, 0xE1, 0xD0, 0x91, 0x59, 0x3A, 0x56,
	0x7B, 0x9A, 0x96, 0x89, 0x87, 0x92, 0xA2, 0x97, 0x7D, 0x58, 0x50, 0x63,
	0x86, 0x9E, 0x9B, 0x8D, 0x7C, 0x7E, 0x82, 0x84, 0x78, 0x6C, 0x6C, 0x78,
	0x8E, 0x95, 0x92, 0x80, 0x77, 0x75, 0x7D, 0x81, 0x7E, 0x7A, 0x78, 0x81,
	0x89, 0x8C, 0x86, 0x7D, 0x79, 0x7B, 0x80, 0x82, 0x80, 0x7E, 0x7D, 0x83,
	0x84, 0x86, 0x7F, 0x7D, 0x78, 0x7F, 0x7D, 0x8F, 0xB9, 0xD7, 0xD9, 0x99,
	0x5C, 0x31, 0x4D, 0x7D, 0xA5, 0xA6, 0x8E, 0x86, 0x8A, 0x9E, 0x91, 0x78,
	0x56, 0x57, 0x72, 0x97, 0xA7, 0x99, 0x83, 0x73, 0x7A, 0x80, 0x82, 0x76,
	0x6F, 0x76, 0x86, 0x96, 0x94, 0x86, 0x75, 0x71, 0x77, 0x80, 0x83, 0x7E,
	0x7D, 0x7F, 0x88, 0x87, 0x82, 0x76, 0x74, 0x78, 0x82, 0x88, 0x84, 0x81,
	0x7B, 0x80, 0x80, 0x83, 0x7B, 0x7C, 0x79, 0x82, 0x82, 0x87, 0x7E, 0x87,
	0xB3, 0xD5, 0xD8, 0x91, 0x4D, 0x28, 0x55, 0x92, 0xBA, 0xA9, 0x86, 0x79,
	0x86, 0x9B, 0x8B, 0x6D, 0x50, 0x63, 0x87, 0xAC, 0xA7, 0x8D, 0x70, 0x6C,
	0x79, 0x83, 0x81, 0x75, 0x76, 0x82, 0x94, 0x95, 0x88, 0x74, 0x6D, 0x74,
	0x80, 0x88, 0x84, 0x81, 0x7F, 0x84, 0x85, 0x82, 0x79, 0x75, 0x79, 0x81,
	0x87, 0x86, 0x82, 0x7D, 0x7E, 0x7E, 0x80, 0x7D, 0x7E, 0x7D, 0x82, 0x83,
	0x85, 0x7F, 0x80, 0x78, 0x8D, 0xBD, 0xDA, 0xC9, 0x74, 0x36, 0x2B, 0x71,
	0xB0, 0xC5, 0x9F, 0x7A, 0x75, 0x8A, 0x95, 0x7A, 0x5F, 0x57, 0x7F, 0xA3,
	0xB4, 0x94, 0x75, 0x62, 0x70, 0x80, 0x86, 0x7F, 0x79, 0x84, 0x8E, 0x94,
	0x84, 0x75, 0x6A, 0x73, 0x7D, 0x88, 0x87, 0x87, 0x83, 0x83, 0x7F, 0x7B,
	0x77, 0x78, 0x7D, 0x84, 0x87, 0x85, 0x82, 0x7E, 0x7D, 0x7B, 0x7E, 0x7C,
	0x81, 0x80, 0x85, 0x81, 0x83, 0x7C, 0x7F, 0x7A, 0x81, 0x7A, 0x91, 0xC6,
	0xDD, 0xC1, 0x62, 0x33, 0x3A, 0x89, 0xB3, 0xB1, 0x89, 0x7C, 0x8E, 0x99,
	0x8A, 0x60, 0x56, 0x6A, 0x9A, 0xA7, 0x9D, 0x7E, 0x75, 0x78, 0x80, 0x7B,
	0x73, 0x77, 0x85, 0x93, 0x8F, 0x82, 0x76, 0x76, 0x7B, 0x7F, 0x7E, 0x7E,
	0x82, 0x88, 0x87, 0x81, 0x7A, 0x79, 0x7B, 0x80, 0x81, 0x81, 0x81, 0x83,
	0x82, 0x80, 0x7C, 0x7B, 0x7D, 0x80, 0x81, 0x82, 0x81, 0x7F, 0x7C, 0x7C,
	0x7C, 0x81, 0x81, 0x81, 0x80, 0x7D, 0xB0, 0xD4, 0xD2, 0x86, 0x42, 0x3C,
	0x70, 0xA6, 0xA2, 0x90, 0x80, 0x99, 0x9B, 0x89, 0x60, 0x59, 0x71, 0x92,
	0x9D, 0x8E, 0x84, 0x80, 0x86, 0x7A, 0x72, 0x6E, 0x7D, 0x8A, 0x8F, 0x88,
	0x81, 0x7F, 0x7E, 0x7B, 0x76, 0x7A, 0x80, 0x88, 0x87, 0x84, 0x7E, 0x7E,
	0x7D, 0x7D, 0x7B, 0x7E, 0x81, 0x85, 0x84, 0x81, 0x7E, 0x7D, 0x7E, 0x7D,
	0x80, 0x7F, 0x82, 0x81, 0x83, 0x7E, 0x80, 0x7D, 0x80, 0x7D, 0x81, 0x7E,
	0x83, 0x7D, 0x8C, 0xC7, 0xD6, 0xB9, 0x5E, 0x42, 0x57, 0x8E, 0x9C, 0x8A,
	0x8B, 0x96, 0xAA, 0x8B, 0x70, 0x5B, 0x73, 0x83, 0x8C, 0x87, 0x8A, 0x93,
	0x8C, 0x7D, 0x6B, 0x73, 0x7B, 0x87, 0x83, 0x85, 0x88, 0x89, 0x82, 0x77,
	0x75, 0x7A, 0x82, 0x82, 0x83, 0x83, 0x85, 0x83, 0x7D, 0x79, 0x78, 0x7F,
	0x81, 0x83, 0x81, 0x82, 0x82, 0x7F, 0x7C, 0x7B, 0x7D, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x7E, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x82, 0x7D,
	0xB6, 0xD8, 0xC5, 0x7E, 0x4D, 0x64, 0x7B, 0x8A, 0x79, 0x90, 0xA6, 0xAB,
	0x86, 0x68, 0x6B, 0x78, 0x80, 0x77, 0x85, 0x93, 0x9B, 0x87, 0x75, 0x72,
	0x7A, 0x7D, 0x79, 0x7F, 0x89, 0x90, 0x86, 0x7B, 0x78, 0x79, 0x7C, 0x7A,
	0x80, 0x85, 0x89, 0x83, 0x7E, 0x7C, 0x7D, 0x7D, 0x7B, 0x7F, 0x82, 0x86,
	0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x7C, 0x80, 0x80, 0x84, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7D, 0x7D, 0x80, 0x81, 0x82, 0x7F, 0x80, 0x7F, 0x80, 0xC2,
	0xD8, 0xB1, 0x68, 0x56, 0x78, 0x7B, 0x77, 0x74, 0xA5, 0xAE, 0x97, 0x70,
	0x6E, 0x7D, 0x76, 0x71, 0x77, 0x98, 0x99, 0x8A, 0x76, 0x7F, 0x82, 0x76,
	0x70, 0x7C, 0x90, 0x8A, 0x81, 0x7C, 0x85, 0x7F, 0x76, 0x76, 0x81, 0x88,
	0x81, 0x80, 0x81, 0x85, 0x7D, 0x78, 0x7C, 0x82, 0x83, 0x7E, 0x80, 0x83,
	0x82, 0x7D, 0x7A, 0x83, 0x82, 0x81, 0x7D, 0x82, 0x82, 0x7E, 0x7D, 0x7E,
	0x83, 0x7F, 0x7F, 0x7F, 0x83, 0x7F, 0x7F, 0x7C, 0x83, 0x7C, 0xAE, 0xD4,
	0xB3, 0x80, 0x64, 0x7D, 0x6E, 0x66, 0x73, 0xA0, 0xAB, 0x8B, 0x7E, 0x7F,
	0x80, 0x65, 0x68, 0x80, 0x94, 0x8C, 0x81, 0x8A, 0x87, 0x78, 0x6A, 0x77,
	0x85, 0x84, 0x80, 0x85, 0x8D, 0x81, 0x77, 0x76, 0x80, 0x7F, 0x7C, 0x81,
	0x87, 0x87, 0x7C, 0x7D, 0x7F, 0x7F, 0x7B, 0x7C, 0x84, 0x84, 0x80, 0x7E,
	0x81, 0x80, 0x7C, 0x7C, 0x80, 0x83, 0x7F, 0x80, 0x81, 0x82, 0x7E, 0x7D,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x83, 0x7E, 0x80, 0x7D, 0x82, 0xB9, 0xB9,
	0x9C, 0x80, 0x81, 0x7C, 0x5B, 0x68, 0x83, 0x9B, 0x8B, 0x88, 0x91, 0x86,
	0x70, 0x65, 0x7B, 0x82, 0x80, 0x82, 0x90, 0x8F, 0x7B, 0x75, 0x7A, 0x7E,
	0x77, 0x7B, 0x88, 0x8D, 0x84, 0x7D, 0x83, 0x7E, 0x78, 0x77, 0x81, 0x85,
	0x80, 0x81, 0x85, 0x83, 0x7A, 0x7A, 0x80, 0x7F, 0x7E, 0x7F, 0x85, 0x83,
	0x7E, 0x7E, 0x80, 0x7F, 0x7B, 0x7F, 0x82, 0x82, 0x7E, 0x7D, 0x7F, 0x7E,
	0x7D, 0x7D, 0x82, 0x81, 0x80, 0x80, 0x81, 0x7F, 0x7E, 0x7B, 0xA8, 0xC0,
	0x9F, 0x90, 0x88, 0x82, 0x5D, 0x5E, 0x7F, 0x8B, 0x89, 0x88, 0x9B, 0x8B,
	0x71, 0x6D, 0x78, 0x7E, 0x74, 0x86, 0x95, 0x8C, 0x7E, 0x7C, 0x83, 0x74,
	0x71, 0x7E, 0x88, 0x84, 0x80, 0x89, 0x86, 0x7A, 0x76, 0x7E, 0x80, 0x7A,
	0x80, 0x88, 0x85, 0x7E, 0x7D, 0x82, 0x7C, 0x79, 0x7E, 0x88, 0x84, 0x7F,
	0x85, 0x83, 0x7D, 0x78, 0x7F, 0x80, 0x7C, 0x7F, 0x84, 0x84, 0x7D, 0x7F,
	0x81, 0x7E, 0x7C, 0x7E, 0x84, 0x7F, 0x80, 0x81, 0x84, 0x7B, 0x8E, 0xBE,
	0xA6, 0x94, 0x92, 0x85, 0x68, 0x55, 0x75, 0x7D, 0x7B, 0x8A, 0x9C, 0x94,
	0x78, 0x79, 0x7D, 0x6E, 0x6D, 0x7E, 0x8E, 0x85, 0x84, 0x8E, 0x85, 0x75,
	0x73, 0x7F, 0x7B, 0x77, 0x84, 0x8C, 0x84, 0x7E, 0x82, 0x7F, 0x74, 0x76,
	0x80, 0x80, 0x7E, 0x84, 0x89, 0x82, 0x7C, 0x80, 0x7F, 0x7A, 0x7A, 0x82,
	0x83, 0x7E, 0x82, 0x85, 0x80, 0x7C, 0x7F, 0x80, 0x7C, 0x7D, 0x82, 0x82,
	0x7F, 0x80, 0x83, 0x7C, 0x78, 0x7E, 0x7C, 0x7D, 0x7D, 0x85, 0x7F, 0x9B,
	0xBE, 0x9F, 0xA0, 0xA0, 0x87, 0x6E, 0x62, 0x75, 0x71, 0x6D, 0x8B, 0x94,
	0x8C, 0x86, 0x89, 0x84, 0x6D, 0x71, 0x7D, 0x79, 0x79, 0x85, 0x8F, 0x87,
	0x80, 0x88, 0x82, 0x76, 0x77, 0x7E, 0x7E, 0x79, 0x82, 0x89, 0x82, 0x80,
	0x83, 0x82, 0x7B, 0x79, 0x80, 0x7F, 0x7B, 0x80, 0x84, 0x82, 0x7E, 0x81,
	0x82, 0x7D, 0x7C, 0x80, 0x80, 0x7E, 0x7F, 0x83, 0x82, 0x7E, 0x80, 0x82,
	0x7E, 0x7D, 0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x81, 0x7F, 0x7F, 0x82, 0x7E,
	0x9E, 0xB2, 0x9B, 0xA5, 0xA5, 0x8F, 0x7C, 0x6F, 0x76, 0x6E, 0x65, 0x7A,
	0x86, 0x85, 0x89, 0x8D, 0x91, 0x85, 0x7A, 0x7F, 0x7B, 0x72, 0x76, 0x7D,
	0x81, 0x7F, 0x82, 0x8A, 0x86, 0x80, 0x81, 0x80, 0x7D, 0x79, 0x7B, 0x80,
	0x7D, 0x7D, 0x83, 0x85, 0x84, 0x81, 0x82, 0x84, 0x7F, 0x7C, 0x7F, 0x7E,
	0x7D, 0x7D, 0x7F, 0x82, 0x80, 0x80, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x7E, 0x7E, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x7C, 0x7C, 0x7D,
	0x7C, 0x92, 0x9E, 0x95, 0x9D, 0xA0, 0x98, 0x90, 0x82, 0x7E, 0x7D, 0x71,
	0x71, 0x79, 0x7B, 0x7F, 0x81, 0x86, 0x8C, 0x87, 0x84, 0x85, 0x81, 0x7D,
	0x7A, 0x79, 0x7D, 0x7B, 0x7A, 0x7E, 0x81, 0x81, 0x82, 0x81, 0x83, 0x83,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x81,
	0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x87, 0x8F, 0x8D, 0x8F, 0x92, 0x92, 0x91, 0x8B, 0x86, 0x86,
	0x83, 0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x7B, 0x7B, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7D,
	0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x81, 0x82, 0x84, 0x85,
	0x86, 0x87, 0x88, 0x88, 0x88, 0x88, 0x88, 0x86, 0x85, 0x84, 0x83, 0x83,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x82, 0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7B,
	0x7B, 0x7B, 0x7A, 0x7A, 0x7A, 0x7A, 0x7A, 0x79, 0x7A, 0x79, 0x79, 0x7A,
	0x7A, 0x7A, 0x7A, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x7F,
	0x80, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x7F,
	0x7F, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x82, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x82, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x81,
	0x80, 0x80, 0x81, 0x81, 0x80, 0x7D, 0x80, 0x82, 0x7E, 0x7E, 0x80, 0x81,
	0x80, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x80,
	0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7E, 0x81, 0x81, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7E,
	0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80
};
const unsigned char WAV50[] = {
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7E, 0x81, 0x81, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7F,
	0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x7E,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x81, 0x81, 0x7F, 0x80, 0x81, 0x7E, 0x80, 0x80, 0x80,
	0x7E, 0x7F, 0x82, 0x80, 0x81, 0x82, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7E,
	0x7F, 0x7F, 0x7D, 0x7F, 0x80, 0x7D, 0x7E, 0x81, 0x80, 0x7E, 0x80, 0x82,
	0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x7F, 0x81, 0x83, 0x7F, 0x81, 0x84, 0x82, 0x83, 0x83, 0x83, 0x81, 0x7E,
	0x80, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x7D,
	0x81, 0x80, 0x7B, 0x7F, 0x82, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x81,
	0x84, 0x80, 0x7F, 0x85, 0x82, 0x7F, 0x81, 0x81, 0x7F, 0x7E, 0x80, 0x82,
	0x80, 0x82, 0x85, 0x83, 0x83, 0x83, 0x83, 0x7F, 0x86, 0x92, 0x8C, 0x8E,
	0x97, 0x91, 0x8A, 0x89, 0x85, 0x7F, 0x79, 0x79, 0x7A, 0x76, 0x78, 0x7D,
	0x7E, 0x7F, 0x82, 0x85, 0x84, 0x83, 0x84, 0x81, 0x7E, 0x7D, 0x7D, 0x7B,
	0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x80,
	0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x80,
	0x82, 0x7F, 0x9A, 0xA8, 0x97, 0xAD, 0xB3, 0x9A, 0x95, 0x8F, 0x80, 0x70,
	0x66, 0x6E, 0x68, 0x63, 0x76, 0x7D, 0x7C, 0x87, 0x8F, 0x8F, 0x8A, 0x8A,
	0x8B, 0x80, 0x7A, 0x7E, 0x78, 0x74, 0x78, 0x7C, 0x7B, 0x7C, 0x83, 0x85,
	0x82, 0x84, 0x87, 0x82, 0x7F, 0x81, 0x7F, 0x7B, 0x7C, 0x7E, 0x7D, 0x7C,
	0x80, 0x81, 0x7F, 0x80, 0x83, 0x80, 0x81, 0x7F, 0xA0, 0xAC, 0x98, 0xB7,
	0xB8, 0x9D, 0x9A, 0x91, 0x81, 0x6A, 0x64, 0x6D, 0x5C, 0x60, 0x79, 0x76,
	0x7B, 0x8B, 0x91, 0x8F, 0x8A, 0x91, 0x8B, 0x7B, 0x7F, 0x7E, 0x73, 0x75,
	0x7A, 0x7A, 0x79, 0x7F, 0x86, 0x81, 0x82, 0x8B, 0x84, 0x80, 0x84, 0x82,
	0x7D, 0x7C, 0x7F, 0x7D, 0x7A, 0x7F, 0x81, 0x7C, 0x80, 0x83, 0x81, 0x7E,
	0x84, 0x7E, 0x90, 0xB3, 0x9D, 0xAE, 0xC2, 0x9F, 0x99, 0x91, 0x7B, 0x68,
	0x5B, 0x61, 0x57, 0x57, 0x72, 0x73, 0x79, 0x8E, 0x92, 0x91, 0x91, 0x93,
	0x8B, 0x7E, 0x82, 0x7D, 0x72, 0x79, 0x7B, 0x78, 0x7C, 0x82, 0x83, 0x7F,
	0x84, 0x85, 0x7E, 0x80, 0x82, 0x7D, 0x7C, 0x7E, 0x7E, 0x7B, 0x7E, 0x81,
	0x7D, 0x80, 0x82, 0x81, 0x7F, 0x81, 0x81, 0x80, 0x7C, 0x9C, 0xA7, 0x95,
	0xB9, 0xB5, 0x98, 0x9D, 0x90, 0x77, 0x66, 0x65, 0x65, 0x53, 0x65, 0x78,
	0x6E, 0x7F, 0x8D, 0x8C, 0x89, 0x8B, 0x8F, 0x7F, 0x7C, 0x85, 0x78, 0x76,
	0x80, 0x7E, 0x7D, 0x80, 0x86, 0x83, 0x7E, 0x86, 0x82, 0x7A, 0x80, 0x7F,
	0x7B, 0x7C, 0x80, 0x80, 0x7D, 0x82, 0x84, 0x7D, 0x81, 0x81, 0x7E, 0x7D,
	0x7F, 0x7F, 0x7E, 0x7C, 0x89, 0xAA, 0xA1, 0xA7, 0xC3, 0xAE, 0x9E, 0x9C,
	0x8B, 0x74, 0x63, 0x69, 0x62, 0x57, 0x6E, 0x78, 0x75, 0x84, 0x8E, 0x8D,
	0x88, 0x8D, 0x90, 0x80, 0x7E, 0x85, 0x7C, 0x78, 0x7E, 0x81, 0x7D, 0x7D,
	0x84, 0x84, 0x7D, 0x81, 0x84, 0x7D, 0x7C, 0x7F, 0x80, 0x7B, 0x7D, 0x82,
	0x7F, 0x7E, 0x82, 0x82, 0x7F, 0x7F, 0x82, 0x82, 0x7E, 0x81, 0x83, 0x80,
	0x7F, 0xA0, 0xAE, 0xA2, 0xB6, 0xBD, 0xA9, 0x9A, 0x91, 0x88, 0x70, 0x63,
	0x70, 0x6A, 0x65, 0x76, 0x82, 0x83, 0x84, 0x8D, 0x8F, 0x82, 0x80, 0x84,
	0x7A, 0x76, 0x7B, 0x7E, 0x7F, 0x7E, 0x85, 0x89, 0x83, 0x84, 0x87, 0x82,
	0x7E, 0x7D, 0x7E, 0x7D, 0x79, 0x7D, 0x81, 0x7E, 0x7F, 0x83, 0x83, 0x81,
	0x80, 0x82, 0x80, 0x7D, 0x7E, 0x80, 0x7D, 0x7E, 0x7E, 0x85, 0x99, 0x9D,
	0x9F, 0xAC, 0xAD, 0xA3, 0x9B, 0x92, 0x8B, 0x7D, 0x73, 0x76, 0x73, 0x71,
	0x77, 0x7E, 0x83, 0x84, 0x85, 0x89, 0x86, 0x80, 0x80, 0x7E, 0x7A, 0x78,
	0x79, 0x7D, 0x7D, 0x7E, 0x82, 0x85, 0x84, 0x84, 0x84, 0x84, 0x81, 0x7F,
	0x7F, 0x7F, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x82, 0x8E, 0x93, 0x96, 0x9D, 0xA1,
	0xA2, 0x9F, 0x9B, 0x99, 0x94, 0x8D, 0x89, 0x87, 0x84, 0x81, 0x7F, 0x7F,
	0x7E, 0x7C, 0x7B, 0x7B, 0x7A, 0x79, 0x78, 0x78, 0x79, 0x78, 0x78, 0x7A,
	0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x85, 0x88, 0x88, 0x8B, 0x8D, 0x8F, 0x8F, 0x8F,
	0x8F, 0x8F, 0x8D, 0x8C, 0x8B, 0x8A, 0x88, 0x87, 0x86, 0x85, 0x84, 0x82,
	0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C,
	0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7C,
	0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C,
	0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82,
	0x82, 0x81, 0x82, 0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7D, 0x80, 0x81,
	0x7F, 0x80, 0x82, 0x81, 0x81, 0x82, 0x7F, 0x7F, 0x81, 0x7E, 0x7D, 0x7D,
	0x7F, 0x7E, 0x80, 0x81, 0x81, 0x83, 0x81, 0x81, 0x80, 0x81, 0x7F, 0x7D,
	0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7F, 0x80, 0x7F, 0x7C,
	0x7D, 0x81, 0x7F, 0x80, 0x80, 0x81, 0x7D, 0x7F, 0x81, 0x7F, 0x80, 0x81,
	0x82, 0x7E, 0x81, 0x80, 0x7D, 0x7E, 0x81, 0x80, 0x7F, 0x81, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7F, 0x7E, 0x7D, 0x7F, 0x81, 0x80, 0x80, 0x7D, 0x7E, 0x7F,
	0x7E, 0x7E, 0x80, 0x82, 0x80, 0x83, 0x84, 0x83, 0x84, 0x83, 0x83, 0x80,
	0x81, 0x80, 0x7C, 0x7F, 0x7D, 0x7C, 0x7F, 0x7F, 0x7E, 0x81, 0x84, 0x82,
	0x82, 0x84, 0x82, 0x81, 0x82, 0x7F, 0x7D, 0x7E, 0x7D, 0x79, 0x7D, 0x7E,
	0x7C, 0x80, 0x83, 0x82, 0x83, 0x87, 0x85, 0x84, 0x86, 0x82, 0x7F, 0x83,
	0x81, 0x7D, 0x81, 0x84, 0x80, 0x84, 0x88, 0x83, 0x86, 0x89, 0x82, 0x81,
	0x82, 0x7D, 0x79, 0x7C, 0x7A, 0x77, 0x7C, 0x7B, 0x83, 0x88, 0x8A, 0x91,
	0x91, 0x92, 0x90, 0x8D, 0x8A, 0x84, 0x83, 0x7D, 0x7A, 0x7A, 0x78, 0x79,
	0x7A, 0x7C, 0x7D, 0x7F, 0x82, 0x82, 0x84, 0x84, 0x83, 0x84, 0x82, 0x81,
	0x80, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7F, 0x7E, 0x80, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x84,
	0x91, 0x8A, 0x97, 0x9F, 0x94, 0x9E, 0x9A, 0x8F, 0x8E, 0x86, 0x7E, 0x76,
	0x77, 0x6F, 0x6D, 0x74, 0x6F, 0x75, 0x7B, 0x7C, 0x81, 0x85, 0x86, 0x86,
	0x88, 0x88, 0x84, 0x85, 0x82, 0x7E, 0x7F, 0x7D, 0x7B, 0x7C, 0x7C, 0x7C,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7E, 0x82, 0x9A, 0x8D, 0x9B, 0xB0, 0x96, 0xA8, 0xA4, 0x8F,
	0x92, 0x85, 0x7A, 0x70, 0x6F, 0x69, 0x62, 0x71, 0x6A, 0x70, 0x7E, 0x7A,
	0x85, 0x86, 0x8A, 0x8A, 0x88, 0x8B, 0x81, 0x84, 0x81, 0x7B, 0x7E, 0x7A,
	0x7B, 0x7B, 0x7B, 0x7E, 0x7D, 0x81, 0x81, 0x81, 0x83, 0x81, 0x82, 0x81,
	0x81, 0x80, 0x7E, 0x80, 0x7D, 0x7F, 0x7F, 0x7C, 0x80, 0x7C, 0x7E, 0x7F,
	0x7C, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x81, 0x7C, 0x8F, 0x94, 0x89, 0xAE,
	0x9A, 0x98, 0xAD, 0x8D, 0x8F, 0x8C, 0x77, 0x74, 0x71, 0x69, 0x65, 0x6F,
	0x6C, 0x6E, 0x7F, 0x79, 0x82, 0x8B, 0x85, 0x8C, 0x8C, 0x87, 0x88, 0x84,
	0x80, 0x7E, 0x7E, 0x7A, 0x7B, 0x7D, 0x79, 0x7E, 0x7E, 0x7D, 0x81, 0x80,
	0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x82, 0x7E, 0x81, 0x80, 0x7F, 0x7F,
	0x81, 0x7C, 0x8E, 0x92, 0x89, 0xAB, 0x98, 0x98, 0xAC, 0x8A, 0x91, 0x8E,
	0x74, 0x7A, 0x71, 0x67, 0x6B, 0x6D, 0x6A, 0x71, 0x7B, 0x77, 0x84, 0x88,
	0x84, 0x8F, 0x89, 0x87, 0x8B, 0x83, 0x82, 0x81, 0x7D, 0x7C, 0x7C, 0x7B,
	0x7A, 0x7E, 0x7C, 0x7E, 0x81, 0x7E, 0x82, 0x81, 0x80, 0x82, 0x81, 0x80,
	0x80, 0x82, 0x7F, 0x81, 0x82, 0x7E, 0x82, 0x80, 0x7F, 0x81, 0x7F, 0x7F,
	0x80, 0x7E, 0x7E, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x7E, 0x82, 0x7F, 0x91, 0x8F, 0x8F,
	0xAB, 0x92, 0xA1, 0xA5, 0x87, 0x99, 0x86, 0x76, 0x80, 0x6B, 0x6B, 0x6E,
	0x68, 0x6D, 0x73, 0x75, 0x7A, 0x83, 0x83, 0x87, 0x8D, 0x88, 0x8B, 0x8A,
	0x84, 0x87, 0x81, 0x80, 0x7F, 0x7B, 0x7D, 0x7B, 0x7C, 0x7D, 0x7C, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x7F, 0x7E, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x81, 0x7D, 0x8B, 0x8D, 0x89, 0xA4, 0x92, 0x9A, 0xA6,
	0x8A, 0x99, 0x8E, 0x7B, 0x85, 0x73, 0x6D, 0x73, 0x68, 0x6C, 0x71, 0x6F,
	0x76, 0x7D, 0x7C, 0x84, 0x87, 0x85, 0x8A, 0x88, 0x86, 0x88, 0x83, 0x82,
	0x82, 0x7E, 0x7E, 0x7E, 0x7C, 0x7D, 0x7D, 0x7C, 0x7E, 0x7E, 0x7D, 0x7F,
	0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7E, 0x83, 0x8C, 0x84, 0x96, 0x95, 0x8F, 0xA3, 0x8F, 0x94, 0x96,
	0x80, 0x8A, 0x7D, 0x72, 0x7A, 0x6D, 0x6F, 0x74, 0x6E, 0x76, 0x79, 0x78,
	0x81, 0x82, 0x81, 0x87, 0x84, 0x84, 0x86, 0x82, 0x83, 0x82, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x7F, 0x7E, 0x81, 0x7F, 0x80, 0x81, 0x7E, 0x80, 0x7F,
	0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x86, 0x88, 0x87, 0x93, 0x8D, 0x92, 0x97, 0x8C, 0x95, 0x8B, 0x86, 0x89,
	0x7B, 0x7D, 0x79, 0x72, 0x77, 0x72, 0x73, 0x77, 0x76, 0x7A, 0x7D, 0x7D,
	0x80, 0x81, 0x80, 0x82, 0x81, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F,
	0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x7F,
	0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x84, 0x84,
	0x87, 0x8C, 0x89, 0x8F, 0x8D, 0x8B, 0x8E, 0x87, 0x88, 0x85, 0x80, 0x82,
	0x7D, 0x7D, 0x7D, 0x7B, 0x7D, 0x7D, 0x7D, 0x7F, 0x7F, 0x80, 0x82, 0x81,
	0x81, 0x82, 0x80, 0x81, 0x81, 0x7E, 0x81, 0x7E, 0x7E, 0x80, 0x7D, 0x7F,
	0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x82, 0x83, 0x85, 0x87,
	0x87, 0x89, 0x88, 0x88, 0x88, 0x86, 0x87, 0x85, 0x84, 0x84, 0x82, 0x82,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82,
	0x81, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x83, 0x83, 0x84,
	0x83, 0x84, 0x84, 0x84, 0x85, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80
};
const unsigned char WAV6[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7E, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F,
	0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F,
	0x7E, 0x81, 0x80, 0x7D, 0x80, 0x82, 0x7F, 0x7E, 0x81, 0x7F, 0x7F, 0x80,
	0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x82, 0x7F, 0x7E,
	0x81, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x80,
	0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x7D, 0x83, 0x7F, 0x7D, 0x81, 0x81, 0x7E,
	0x7E, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x7D, 0x80, 0x7F, 0x81,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x7E, 0x81, 0x80, 0x7F, 0x7E, 0x80,
	0x81, 0x7E, 0x80, 0x81, 0x80, 0x7D, 0x80, 0x81, 0x7F, 0x7E, 0x81, 0x81,
	0x7C, 0x80, 0x83, 0x7E, 0x7F, 0x82, 0x7F, 0x7B, 0x7F, 0x82, 0x7C, 0x7F,
	0x83, 0x80, 0x7C, 0x81, 0x82, 0x7D, 0x7E, 0x82, 0x80, 0x7B, 0x81, 0x83,
	0x7D, 0x7E, 0x82, 0x7E, 0x7D, 0x82, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F,
	0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x7E, 0x81, 0x80, 0x7E,
	0x7F, 0x81, 0x7F, 0x7D, 0x83, 0x7F, 0x7D, 0x81, 0x82, 0x7E, 0x7F, 0x84,
	0x80, 0x7E, 0x83, 0x80, 0x7D, 0x81, 0x80, 0x7D, 0x7D, 0x81, 0x7E, 0x7D,
	0x83, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x82, 0x7E, 0x80, 0x83, 0x80,
	0x7F, 0x81, 0x81, 0x7F, 0x81, 0x81, 0x7F, 0x82, 0x81, 0x83, 0x82, 0x81,
	0x82, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x83, 0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x83, 0x81, 0x7F,
	0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7C, 0x7D, 0x7E, 0x7D, 0x7F, 0x81,
	0x82, 0x82, 0x84, 0x85, 0x84, 0x84, 0x83, 0x84, 0x84, 0x81, 0x82, 0x81,
	0x80, 0x80, 0x7F, 0x80, 0x7E, 0x81, 0x8A, 0x88, 0x8C, 0x8F, 0x90, 0x8E,
	0x8A, 0x8B, 0x86, 0x81, 0x80, 0x7D, 0x7B, 0x79, 0x79, 0x7C, 0x7A, 0x7C,
	0x7E, 0x7F, 0x81, 0x81, 0x84, 0x83, 0x82, 0x83, 0x83, 0x82, 0x80, 0x7F,
	0x80, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x81,
	0x81, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x82, 0x92, 0x95, 0x96, 0x9D, 0x9E, 0x9C, 0x93, 0x8F,
	0x8C, 0x80, 0x79, 0x76, 0x74, 0x72, 0x6F, 0x75, 0x79, 0x7A, 0x7E, 0x83,
	0x87, 0x86, 0x87, 0x89, 0x88, 0x86, 0x83, 0x83, 0x82, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7C, 0x7C, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x81, 0x82,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7D, 0x7B,
	0x7D, 0x7A, 0x7F, 0x9B, 0x9E, 0x9E, 0xAA, 0xAC, 0xA7, 0x95, 0x8F, 0x8A,
	0x77, 0x6D, 0x6B, 0x6C, 0x6A, 0x69, 0x77, 0x7E, 0x81, 0x87, 0x8C, 0x91,
	0x8B, 0x88, 0x89, 0x83, 0x7E, 0x7A, 0x7B, 0x7A, 0x77, 0x7B, 0x7D, 0x7E,
	0x80, 0x82, 0x85, 0x83, 0x82, 0x84, 0x82, 0x80, 0x7E, 0x7E, 0x7E, 0x7C,
	0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x83,
	0x82, 0x82, 0xA1, 0xAC, 0xA1, 0xB2, 0xB5, 0xA8, 0x95, 0x8B, 0x89, 0x6F,
	0x64, 0x6A, 0x67, 0x66, 0x6B, 0x7C, 0x84, 0x80, 0x8D, 0x93, 0x8E, 0x8A,
	0x88, 0x88, 0x7C, 0x77, 0x78, 0x74, 0x72, 0x73, 0x7A, 0x7C, 0x7C, 0x84,
	0x86, 0x85, 0x85, 0x86, 0x86, 0x7F, 0x7F, 0x7F, 0x7C, 0x7B, 0x7B, 0x7E,
	0x7D, 0x7D, 0x81, 0x82, 0x80, 0x83, 0x82, 0x82, 0x7F, 0x80, 0x82, 0x82,
	0x7E, 0x8B, 0xB4, 0xA7, 0xA6, 0xC4, 0xB3, 0x9D, 0x91, 0x8E, 0x78, 0x5A,
	0x67, 0x69, 0x59, 0x67, 0x79, 0x81, 0x7F, 0x8B, 0x9B, 0x8D, 0x87, 0x90,
	0x87, 0x79, 0x76, 0x7D, 0x76, 0x6C, 0x7B, 0x7F, 0x76, 0x7F, 0x88, 0x85,
	0x80, 0x86, 0x8A, 0x7D, 0x7D, 0x84, 0x7C, 0x78, 0x7D, 0x81, 0x7B, 0x7B,
	0x85, 0x82, 0x7D, 0x82, 0x85, 0x7F, 0x7D, 0x82, 0x81, 0x7A, 0x7E, 0x7E,
	0x7E, 0x77, 0x95, 0xBD, 0x9A, 0xB4, 0xD1, 0xA4, 0x97, 0x98, 0x87, 0x61,
	0x59, 0x71, 0x58, 0x55, 0x7C, 0x7E, 0x79, 0x8A, 0x9D, 0x90, 0x82, 0x95,
	0x8B, 0x71, 0x7A, 0x80, 0x71, 0x6E, 0x80, 0x82, 0x76, 0x84, 0x8F, 0x80,
	0x80, 0x8B, 0x82, 0x78, 0x7E, 0x83, 0x77, 0x78, 0x84, 0x7F, 0x7A, 0x83,
	0x87, 0x7D, 0x7F, 0x87, 0x80, 0x79, 0x82, 0x82, 0x79, 0x7D, 0x86, 0x7F,
	0x7D, 0x86, 0x87, 0x78, 0xA0, 0xC1, 0x94, 0xB9, 0xCC, 0x96, 0x92, 0x94,
	0x78, 0x59, 0x60, 0x70, 0x54, 0x62, 0x88, 0x7B, 0x7E, 0x96, 0x97, 0x86,
	0x86, 0x92, 0x7B, 0x6F, 0x81, 0x77, 0x6E, 0x7B, 0x84, 0x7D, 0x7D, 0x8D,
	0x87, 0x7B, 0x87, 0x87, 0x76, 0x7C, 0x83, 0x79, 0x78, 0x82, 0x83, 0x7A,
	0x82, 0x87, 0x7E, 0x7F, 0x85, 0x80, 0x7A, 0x81, 0x81, 0x7B, 0x7F, 0x86,
	0x7E, 0x80, 0x85, 0x82, 0x7D, 0x82, 0x7F, 0x86, 0xB7, 0xA2, 0xA4, 0xCE,
	0xA5, 0x91, 0x99, 0x7E, 0x62, 0x5F, 0x6B, 0x5D, 0x5D, 0x81, 0x7F, 0x7B,
	0x94, 0x95, 0x87, 0x87, 0x8D, 0x7F, 0x72, 0x80, 0x7D, 0x71, 0x7F, 0x86,
	0x7D, 0x81, 0x8A, 0x84, 0x7C, 0x83, 0x82, 0x77, 0x7C, 0x81, 0x7A, 0x7C,
	0x83, 0x81, 0x7E, 0x83, 0x84, 0x7E, 0x7E, 0x83, 0x7D, 0x7C, 0x7F, 0x7C,
	0x7C, 0x7D, 0x7F, 0x7E, 0x7D, 0x82, 0x80, 0x80, 0x81, 0x82, 0x7E, 0x84,
	0xB5, 0xA3, 0x9B, 0xCE, 0xA6, 0x88, 0x9D, 0x7F, 0x5E, 0x65, 0x6B, 0x60,
	0x61, 0x82, 0x83, 0x79, 0x97, 0x95, 0x81, 0x8A, 0x8A, 0x78, 0x73, 0x7E,
	0x79, 0x71, 0x82, 0x86, 0x7C, 0x85, 0x8B, 0x81, 0x7E, 0x84, 0x7F, 0x77,
	0x7D, 0x80, 0x79, 0x7E, 0x85, 0x7F, 0x7F, 0x85, 0x83, 0x7C, 0x81, 0x83,
	0x7B, 0x7F, 0x83, 0x7D, 0x7F, 0x82, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x7E,
	0x81, 0x7E, 0x7D, 0x83, 0x7E, 0xA3, 0xAC, 0x93, 0xBE, 0xB1, 0x86, 0x97,
	0x86, 0x63, 0x67, 0x6D, 0x67, 0x66, 0x7E, 0x87, 0x7C, 0x8D, 0x94, 0x7F,
	0x80, 0x87, 0x77, 0x72, 0x7E, 0x7C, 0x77, 0x83, 0x88, 0x80, 0x84, 0x89,
	0x80, 0x7D, 0x81, 0x7D, 0x78, 0x7D, 0x80, 0x7C, 0x80, 0x85, 0x82, 0x81,
	0x84, 0x83, 0x7F, 0x7F, 0x81, 0x7D, 0x7C, 0x81, 0x7F, 0x7D, 0x82, 0x81,
	0x7F, 0x81, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x7D, 0x81, 0x7E, 0x85, 0xA7,
	0x96, 0x96, 0xB8, 0x94, 0x85, 0x99, 0x78, 0x67, 0x79, 0x6F, 0x69, 0x7A,
	0x82, 0x7F, 0x83, 0x8D, 0x86, 0x7D, 0x83, 0x7E, 0x74, 0x7B, 0x7E, 0x79,
	0x7E, 0x85, 0x83, 0x82, 0x87, 0x84, 0x7E, 0x80, 0x7F, 0x79, 0x7D, 0x81,
	0x7D, 0x81, 0x86, 0x82, 0x81, 0x84, 0x81, 0x7E, 0x7F, 0x7E, 0x7C, 0x7D,
	0x7F, 0x7E, 0x7F, 0x82, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x8C, 0x91, 0x87, 0x98, 0x99, 0x86, 0x8F,
	0x8D, 0x79, 0x7D, 0x80, 0x73, 0x77, 0x80, 0x7B, 0x7C, 0x85, 0x83, 0x80,
	0x83, 0x82, 0x7C, 0x7D, 0x7F, 0x7B, 0x7B, 0x7F, 0x7F, 0x7E, 0x82, 0x82,
	0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x7E, 0x7D, 0x7F, 0x80, 0x7E, 0x80,
	0x81, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E,
	0x85, 0x89, 0x86, 0x90, 0x92, 0x8A, 0x90, 0x8F, 0x83, 0x86, 0x85, 0x7A,
	0x7D, 0x80, 0x78, 0x7C, 0x81, 0x7D, 0x80, 0x84, 0x81, 0x81, 0x83, 0x7F,
	0x7E, 0x80, 0x7E, 0x7D, 0x7F, 0x80, 0x7F, 0x81, 0x86, 0x83, 0x84, 0x8D,
	0x88, 0x89, 0x92, 0x8B, 0x8A, 0x90, 0x88, 0x85, 0x8A, 0x82, 0x80, 0x86,
	0x80, 0x7F, 0x84, 0x82, 0x80, 0x83, 0x83, 0x80, 0x81, 0x81, 0x7D, 0x7D,
	0x7E, 0x7A, 0x7B, 0x7D, 0x7A, 0x7B, 0x7E, 0x7C, 0x7C, 0x7F, 0x7E, 0x7C,
	0x7E, 0x7F, 0x7D, 0x7E, 0x80, 0x7D, 0x7D, 0x81, 0x7E, 0x7E, 0x82, 0x7F,
	0x80, 0x83, 0x80, 0x81, 0x83, 0x80, 0x81, 0x83, 0x81, 0x82, 0x83, 0x82,
	0x83, 0x83, 0x81, 0x83, 0x82, 0x81, 0x83, 0x81, 0x81, 0x83, 0x81, 0x80,
	0x82, 0x80, 0x7F, 0x82, 0x80, 0x80, 0x82, 0x80, 0x80, 0x82, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x83,
	0x7F, 0x7D, 0x82, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x7E, 0x80, 0x7F,
	0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x7E, 0x81, 0x81, 0x7F, 0x80, 0x80,
	0x7F, 0x81, 0x82, 0x7E, 0x7E, 0x81, 0x80, 0x7F, 0x82, 0x81, 0x7F, 0x80,
	0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x82,
	0x81, 0x7D, 0x82, 0x84, 0x7F, 0x80, 0x80, 0x7D, 0x7D, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x81, 0x80, 0x7F, 0x81, 0x7E, 0x7C, 0x80, 0x80, 0x7E, 0x80,
	0x83, 0x81, 0x7F, 0x81, 0x83, 0x7F, 0x7E, 0x82, 0x81, 0x7E, 0x7F, 0x80,
	0x7E, 0x7E, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x81, 0x81, 0x80, 0x82,
	0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x81, 0x7E, 0x7D, 0x82, 0x81, 0x7E,
	0x80, 0x83, 0x7F, 0x7C, 0x81, 0x80, 0x7C, 0x7F, 0x83, 0x7E, 0x7D, 0x82,
	0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x7E, 0x82, 0x80, 0x7E, 0x81, 0x80, 0x7E,
	0x80, 0x81, 0x7E, 0x80, 0x80, 0x7E, 0x7E, 0x81, 0x7F, 0x7E, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x81, 0x7F, 0x7E, 0x7F, 0x81, 0x7E,
	0x7E, 0x83, 0x7E, 0x7D, 0x82, 0x81, 0x7D, 0x80, 0x82, 0x7D, 0x7F, 0x83,
	0x7F, 0x7D, 0x83, 0x80, 0x7C, 0x82, 0x83, 0x7D, 0x80, 0x81, 0x7D, 0x7E,
	0x82, 0x81, 0x7B, 0x81, 0x82, 0x7C, 0x7F, 0x83, 0x7D, 0x7F, 0x84, 0x7E,
	0x7E, 0x82, 0x7F, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x82, 0x7D, 0x7F,
	0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7D, 0x81, 0x80, 0x7D, 0x80, 0x82, 0x7E,
	0x7E, 0x83, 0x7F, 0x7C, 0x82, 0x81, 0x7C, 0x80, 0x83, 0x7D, 0x7D, 0x83,
	0x80, 0x7D, 0x82, 0x81, 0x7D, 0x80, 0x81, 0x7F, 0x7E, 0x81, 0x7E, 0x7E,
	0x83, 0x7F, 0x7D, 0x81, 0x80, 0x7D, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7F,
	0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x7E, 0x82, 0x7E, 0x7F,
	0x82, 0x7E, 0x7F, 0x82, 0x7F, 0x7D, 0x81, 0x80, 0x7F, 0x7F, 0x81, 0x80,
	0x7E, 0x80, 0x82, 0x7E, 0x7E, 0x82, 0x7F, 0x7E, 0x81, 0x81, 0x7E, 0x7F,
	0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x7E, 0x80, 0x80, 0x7F,
	0x7E, 0x81, 0x81, 0x7D, 0x80, 0x81, 0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x7E, 0x81, 0x81, 0x7E,
	0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x81,
	0x7E, 0x7F, 0x81, 0x80, 0x7D, 0x80, 0x81, 0x7E, 0x7E, 0x81, 0x81, 0x7C,
	0x80, 0x83, 0x7E, 0x7E, 0x82, 0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x7E, 0x81,
	0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x7E, 0x7F, 0x82, 0x7F, 0x7D, 0x82, 0x7F, 0x7D, 0x81, 0x80,
	0x7E, 0x80, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7D, 0x7F, 0x81, 0x7F, 0x7E,
	0x81, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x81, 0x81, 0x7E, 0x80, 0x81, 0x7F, 0x7E,
	0x81, 0x80, 0x7E, 0x7E, 0x82, 0x7F, 0x7D, 0x81, 0x82, 0x7D, 0x7F, 0x82,
	0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F,
	0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x7E,
	0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x7D, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x82, 0x7E, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7E, 0x81, 0x81, 0x7E, 0x80, 0x81, 0x7E, 0x7E, 0x82, 0x7F,
	0x7F, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x80, 0x7D, 0x80, 0x81, 0x7E, 0x7F,
	0x81, 0x80, 0x7D, 0x80, 0x82, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x7E, 0x80,
	0x80, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x7F, 0x82, 0x7F, 0x7E, 0x81,
	0x7F, 0x7D, 0x81, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x80, 0x81, 0x7E,
	0x7F, 0x82, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x7E, 0x7F, 0x81,
	0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x81, 0x7F, 0x7D, 0x80, 0x81,
	0x7F, 0x7E, 0x81, 0x80, 0x7D, 0x81, 0x81, 0x7D, 0x7F, 0x80, 0x7F, 0x7E,
	0x80, 0x81, 0x7E, 0x7F, 0x82, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x81,
	0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7E,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80,
	0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80
};
const unsigned char WAV60[] = {
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F,
	0x7E, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F,
	0x80, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x81,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7D, 0x81, 0x80,
	0x7D, 0x81, 0x81, 0x7F, 0x7E, 0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x7E,
	0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7E, 0x82, 0x7F, 0x7D, 0x82, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x7E, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x7F,
	0x80, 0x7E, 0x80, 0x81, 0x7F, 0x82, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7D, 0x7E, 0x80, 0x7E, 0x7D, 0x7F, 0x7F, 0x7F, 0x81, 0x82,
	0x81, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x81, 0x7E, 0x80, 0x80, 0x7D, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E,
	0x7F, 0x7F, 0x7D, 0x7D, 0x7D, 0x7B, 0x7C, 0x7C, 0x7B, 0x7C, 0x7E, 0x7E,
	0x7F, 0x7D, 0x7E, 0x7E, 0x7D, 0x7C, 0x7A, 0x7B, 0x7A, 0x7A, 0x7B, 0x7C,
	0x7E, 0x80, 0x81, 0x83, 0x85, 0x84, 0x84, 0x88, 0x87, 0x85, 0x85, 0x85,
	0x84, 0x80, 0x80, 0x8A, 0x8B, 0x89, 0x90, 0x91, 0x8F, 0x8A, 0x8A, 0x88,
	0x80, 0x7D, 0x7D, 0x7A, 0x77, 0x78, 0x7C, 0x7B, 0x7B, 0x80, 0x81, 0x82,
	0x82, 0x84, 0x86, 0x83, 0x83, 0x84, 0x82, 0x80, 0x7F, 0x7F, 0x7E, 0x7C,
	0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x82, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x81, 0x7D, 0x8D, 0xA2,
	0x99, 0xA2, 0xAB, 0xA4, 0x9A, 0x8D, 0x8D, 0x7E, 0x6C, 0x70, 0x6D, 0x6A,
	0x6C, 0x74, 0x80, 0x7D, 0x84, 0x8E, 0x8C, 0x8A, 0x88, 0x89, 0x83, 0x7A,
	0x7D, 0x7A, 0x75, 0x77, 0x7A, 0x7C, 0x7B, 0x7F, 0x85, 0x82, 0x83, 0x85,
	0x84, 0x81, 0x7F, 0x81, 0x7E, 0x7B, 0x7D, 0x7E, 0x7D, 0x7E, 0x7F, 0x81,
	0x7F, 0x81, 0x82, 0x82, 0x7E, 0x8C, 0xA8, 0x9C, 0xA3, 0xB6, 0xA7, 0x9A,
	0x91, 0x8C, 0x78, 0x65, 0x6F, 0x6A, 0x61, 0x6D, 0x79, 0x7E, 0x7D, 0x8B,
	0x93, 0x88, 0x8A, 0x8D, 0x84, 0x7C, 0x7B, 0x7E, 0x75, 0x74, 0x7E, 0x7C,
	0x7B, 0x80, 0x89, 0x84, 0x82, 0x8B, 0x86, 0x7F, 0x81, 0x81, 0x7C, 0x79,
	0x7E, 0x7E, 0x79, 0x7F, 0x83, 0x7E, 0x80, 0x83, 0x83, 0x7E, 0x81, 0x81,
	0x86, 0xAD, 0xA2, 0xA3, 0xC1, 0xAB, 0x9B, 0x96, 0x8A, 0x73, 0x61, 0x6D,
	0x63, 0x59, 0x73, 0x79, 0x78, 0x85, 0x92, 0x8F, 0x87, 0x90, 0x8B, 0x79,
	0x7E, 0x7E, 0x74, 0x74, 0x7C, 0x7E, 0x79, 0x82, 0x88, 0x80, 0x83, 0x88,
	0x82, 0x7D, 0x80, 0x80, 0x79, 0x7C, 0x81, 0x7C, 0x7D, 0x83, 0x81, 0x7F,
	0x81, 0x84, 0x7D, 0x80, 0x81, 0x7F, 0x79, 0x95, 0xB4, 0x94, 0xB3, 0xC9,
	0x97, 0x9A, 0x9C, 0x78, 0x64, 0x68, 0x6A, 0x54, 0x63, 0x7F, 0x6F, 0x7B,
	0x96, 0x8A, 0x85, 0x91, 0x8C, 0x7B, 0x7D, 0x84, 0x74, 0x74, 0x83, 0x7C,
	0x7A, 0x87, 0x86, 0x7F, 0x83, 0x87, 0x7D, 0x7C, 0x83, 0x7C, 0x78, 0x81,
	0x80, 0x7A, 0x80, 0x83, 0x7C, 0x7F, 0x83, 0x7E, 0x7D, 0x82, 0x80, 0x7C,
	0x83, 0x7E, 0x9E, 0xAB, 0x95, 0xC0, 0xB6, 0x90, 0xA2, 0x8D, 0x6B, 0x6C,
	0x6A, 0x5E, 0x5D, 0x74, 0x76, 0x74, 0x8D, 0x8E, 0x85, 0x8E, 0x8C, 0x7E,
	0x7E, 0x80, 0x77, 0x76, 0x80, 0x7E, 0x7C, 0x86, 0x86, 0x81, 0x85, 0x85,
	0x7D, 0x7D, 0x7F, 0x7A, 0x7A, 0x7F, 0x7E, 0x7D, 0x83, 0x82, 0x80, 0x83,
	0x82, 0x7E, 0x80, 0x7F, 0x7D, 0x7C, 0x7F, 0x7E, 0x7F, 0xA5, 0x9D, 0x98,
	0xC7, 0xA6, 0x95, 0xB0, 0x85, 0x6F, 0x7E, 0x65, 0x59, 0x6A, 0x6D, 0x68,
	0x7A, 0x88, 0x7F, 0x87, 0x91, 0x81, 0x80, 0x87, 0x77, 0x76, 0x80, 0x77,
	0x79, 0x84, 0x81, 0x82, 0x8A, 0x87, 0x82, 0x86, 0x83, 0x7C, 0x7E, 0x7C,
	0x78, 0x7C, 0x7D, 0x7C, 0x7F, 0x82, 0x80, 0x82, 0x83, 0x81, 0x7F, 0x81,
	0x7E, 0x7D, 0x7E, 0x83, 0x95, 0x8E, 0x9D, 0xAF, 0x9C, 0xA7, 0xAC, 0x8E,
	0x91, 0x8D, 0x71, 0x75, 0x73, 0x64, 0x6D, 0x73, 0x6E, 0x77, 0x80, 0x7D,
	0x82, 0x87, 0x80, 0x80, 0x82, 0x7B, 0x7B, 0x7D, 0x7A, 0x7C, 0x7F, 0x80,
	0x82, 0x85, 0x85, 0x86, 0x86, 0x85, 0x83, 0x82, 0x80, 0x7E, 0x7E, 0x7D,
	0x7C, 0x7D, 0x7D, 0x7D, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x7F, 0x88, 0x8F,
	0x89, 0x99, 0x9C, 0x93, 0xA2, 0x9C, 0x8F, 0x99, 0x8C, 0x80, 0x87, 0x79,
	0x73, 0x7A, 0x71, 0x71, 0x79, 0x74, 0x77, 0x7E, 0x7B, 0x7E, 0x81, 0x7D,
	0x7F, 0x80, 0x7C, 0x7D, 0x7D, 0x7B, 0x7D, 0x7D, 0x7D, 0x7F, 0x80, 0x80,
	0x82, 0x82, 0x82, 0x83, 0x81, 0x81, 0x81, 0x80, 0x82, 0x83, 0x83, 0x85,
	0x86, 0x87, 0x88, 0x89, 0x8A, 0x89, 0x8A, 0x89, 0x86, 0x86, 0x82, 0x7F,
	0x7F, 0x7A, 0x79, 0x79, 0x76, 0x77, 0x79, 0x78, 0x7C, 0x7F, 0x7F, 0x83,
	0x85, 0x85, 0x88, 0x88, 0x86, 0x87, 0x86, 0x83, 0x82, 0x80, 0x7E, 0x7D,
	0x7B, 0x7A, 0x7A, 0x7A, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C,
	0x7D, 0x7E, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7E, 0x82,
	0x81, 0x7D, 0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x7E, 0x7D, 0x80,
	0x82, 0x7F, 0x7D, 0x80, 0x7F, 0x7D, 0x81, 0x80, 0x7A, 0x7E, 0x84, 0x7F,
	0x7C, 0x83, 0x82, 0x7C, 0x81, 0x83, 0x7C, 0x7C, 0x81, 0x7F, 0x7C, 0x81,
	0x80, 0x7E, 0x81, 0x7F, 0x7D, 0x81, 0x82, 0x7F, 0x7F, 0x82, 0x81, 0x80,
	0x81, 0x80, 0x7E, 0x7F, 0x80, 0x7D, 0x7F, 0x84, 0x80, 0x7C, 0x80, 0x81,
	0x7E, 0x7D, 0x80, 0x81, 0x7F, 0x7D, 0x7D, 0x81, 0x82, 0x7E, 0x7F, 0x82,
	0x80, 0x7D, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x81, 0x82, 0x7E, 0x7F, 0x81,
	0x7C, 0x7C, 0x82, 0x80, 0x7E, 0x81, 0x84, 0x80, 0x7F, 0x82, 0x82, 0x7D,
	0x7F, 0x83, 0x7F, 0x7D, 0x80, 0x80, 0x7D, 0x7F, 0x81, 0x80, 0x7F, 0x80,
	0x82, 0x7F, 0x7F, 0x84, 0x7F, 0x7C, 0x85, 0x81, 0x7E, 0x82, 0x80, 0x7D,
	0x7E, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x82, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x82, 0x7F, 0x7D, 0x81, 0x80,
	0x7D, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x82,
	0x7F, 0x7C, 0x81, 0x82, 0x7D, 0x7D, 0x84, 0x7E, 0x7D, 0x85, 0x7E, 0x7D,
	0x84, 0x7F, 0x7C, 0x81, 0x80, 0x7D, 0x80, 0x81, 0x7E, 0x80, 0x81, 0x7E,
	0x7F, 0x81, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7E, 0x80,
	0x81, 0x7D, 0x7F, 0x82, 0x7D, 0x7F, 0x82, 0x7D, 0x7F, 0x84, 0x7E, 0x7E,
	0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7D, 0x81, 0x81, 0x7E, 0x7F, 0x82, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x82, 0x7F, 0x7D, 0x82, 0x81, 0x7C,
	0x80, 0x81, 0x7D, 0x80, 0x80, 0x7D, 0x80, 0x82, 0x7D, 0x7E, 0x84, 0x7E,
	0x7C, 0x84, 0x7F, 0x7B, 0x82, 0x82, 0x7B, 0x80, 0x84, 0x7B, 0x80, 0x83,
	0x7D, 0x7D, 0x82, 0x80, 0x7D, 0x81, 0x80, 0x7D, 0x80, 0x81, 0x7E, 0x7F,
	0x82, 0x7F, 0x7E, 0x80, 0x81, 0x7F, 0x7D, 0x82, 0x80, 0x7C, 0x81, 0x82,
	0x7B, 0x7F, 0x84, 0x7D, 0x7E, 0x84, 0x80, 0x7C, 0x82, 0x81, 0x7C, 0x7F,
	0x83, 0x7D, 0x7D, 0x84, 0x80, 0x7C, 0x82, 0x83, 0x7C, 0x80, 0x84, 0x7C,
	0x7E, 0x84, 0x7D, 0x7C, 0x83, 0x81, 0x7B, 0x82, 0x82, 0x7C, 0x80, 0x83,
	0x7C, 0x7E, 0x83, 0x7E, 0x7E, 0x83, 0x80, 0x7C, 0x82, 0x81, 0x7D, 0x80,
	0x82, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x81, 0x7C, 0x81, 0x82, 0x7D,
	0x7F, 0x82, 0x7F, 0x7D, 0x81, 0x81, 0x7C, 0x81, 0x81, 0x7E, 0x7F, 0x81,
	0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x7E, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x7E,
	0x7F, 0x82, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x7F, 0x7F, 0x81, 0x7F,
	0x7F, 0x80, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x81, 0x81, 0x7E,
	0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F,
	0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F,
	0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7E, 0x80,
	0x81, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x83, 0x80, 0x82,
	0x83, 0x82, 0x84, 0x83, 0x83, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x81, 0x82, 0x82, 0x83, 0x83, 0x82,
	0x82, 0x82, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x81, 0x7F, 0x80, 0x7E,
	0x7E, 0x80, 0x80, 0x81, 0x82, 0x86, 0x85, 0x84, 0x8A, 0x88, 0x85, 0x88,
	0x85, 0x7E, 0x7D, 0x7C, 0x75, 0x78, 0x7B, 0x7B, 0x7D, 0x83, 0x86, 0x87,
	0x8A, 0x8E, 0x8D, 0x8E, 0x8F, 0x8B, 0x89, 0x88, 0x86, 0x80, 0x82, 0x81,
	0x7C, 0x83, 0x87, 0x81, 0x8D, 0x92, 0x90, 0x9C, 0x9D, 0x9A, 0x98, 0x95,
	0x8F, 0x85, 0x85, 0x7D, 0x79, 0x7B, 0x77, 0x77, 0x76, 0x7A, 0x78, 0x79,
	0x7F, 0x7D, 0x7C, 0x90, 0x93, 0x90, 0xA6, 0xA3, 0x9C, 0xA2, 0x9C, 0x8F,
	0x88, 0x85, 0x77, 0x6F, 0x74, 0x6B, 0x6A, 0x73, 0x72, 0x75, 0x7D, 0x83,
	0x82, 0x86, 0x8A, 0x85, 0x85, 0x86, 0x80, 0x7E, 0x7E, 0x7C, 0x7A, 0x7B,
	0x7C, 0x7A, 0x7E, 0x80, 0x7E, 0x82, 0x82, 0x81, 0x83, 0x82, 0x81, 0x80,
	0x81, 0x7F, 0x7E, 0x7F, 0x7E, 0x7D, 0x7F, 0x7E, 0x7D, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x82, 0x7F, 0x95,
	0x94, 0x94, 0xB0, 0x9F, 0xA3, 0xAA, 0x97, 0x94, 0x8A, 0x80, 0x73, 0x6F,
	0x6E, 0x61, 0x6B, 0x6C, 0x6A, 0x78, 0x7A, 0x80, 0x86, 0x8A, 0x8B, 0x8A,
	0x8E, 0x88, 0x85, 0x86, 0x7E, 0x7E, 0x7C, 0x79, 0x79, 0x79, 0x7B, 0x7A,
	0x7E, 0x7F, 0x7F, 0x82, 0x83, 0x81, 0x84, 0x83, 0x81, 0x82, 0x80, 0x7F,
	0x7E, 0x7F, 0x7D, 0x7D, 0x7F, 0x7D, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x80, 0x81, 0x80, 0x81, 0x7E, 0x82, 0x7C, 0x90, 0x9B, 0x8A, 0xB2, 0xA6,
	0x9A, 0xB2, 0x96, 0x8F, 0x8C, 0x7B, 0x71, 0x6A, 0x6B, 0x5E, 0x68, 0x6E,
	0x68, 0x7C, 0x7E, 0x80, 0x8C, 0x8C, 0x8D, 0x8D, 0x8E, 0x88, 0x84, 0x85,
	0x7B, 0x7C, 0x7B, 0x76, 0x7A, 0x79, 0x7A, 0x7D, 0x80, 0x80, 0x82, 0x85,
	0x82, 0x84, 0x84, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7C, 0x7F,
	0x7D, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7E, 0x82, 0x7B, 0x91, 0x95, 0x88, 0xB1, 0x9A, 0x99, 0xAF, 0x8B,
	0x91, 0x8B, 0x75, 0x74, 0x6F, 0x68, 0x63, 0x6E, 0x6B, 0x6D, 0x80, 0x79,
	0x83, 0x8C, 0x86, 0x8D, 0x8D, 0x88, 0x87, 0x85, 0x7F, 0x7D, 0x7B, 0x77,
	0x79, 0x79, 0x79, 0x7C, 0x7D, 0x7F, 0x81, 0x82, 0x83, 0x83, 0x83, 0x82,
	0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x7D, 0x80, 0x7F,
	0x7F, 0x80, 0x82, 0x99, 0x88, 0x9D, 0xAC, 0x8E, 0xAC, 0x9B, 0x87, 0x97,
	0x7B, 0x75, 0x76, 0x68, 0x67, 0x6A, 0x6B, 0x6A, 0x78, 0x7A, 0x7B, 0x8B,
	0x85, 0x89, 0x90, 0x86, 0x8A, 0x88, 0x81, 0x82, 0x7F, 0x7C, 0x7B, 0x7B,
	0x7A, 0x7B, 0x7D, 0x7C, 0x7F, 0x81, 0x7F, 0x82, 0x82, 0x80, 0x83, 0x81,
	0x80, 0x81, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x81, 0x7C, 0x8A, 0x96, 0x86, 0xA9, 0x9D, 0x92, 0xAF, 0x8C, 0x8D, 0x94,
	0x71, 0x7B, 0x75, 0x62, 0x6F, 0x6A, 0x68, 0x74, 0x76, 0x78, 0x83, 0x86,
	0x85, 0x8F, 0x8B, 0x88, 0x8E, 0x84, 0x84, 0x83, 0x7B, 0x7D, 0x7B, 0x78,
	0x7B, 0x7A, 0x7B, 0x7D, 0x7F, 0x80, 0x80, 0x83, 0x82, 0x82, 0x84, 0x80,
	0x82, 0x80, 0x7F, 0x80, 0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x81, 0x7F, 0x81, 0x7F, 0x80, 0x82, 0x7F, 0x83, 0x81,
	0x80, 0x83, 0x7F, 0x81, 0x94, 0x86, 0x95, 0xA4, 0x8C, 0xA7, 0x9A, 0x8A,
	0x9C, 0x81, 0x7D, 0x81, 0x6C, 0x71, 0x70, 0x68, 0x6F, 0x72, 0x72, 0x79,
	0x7F, 0x7E, 0x85, 0x88, 0x84, 0x8A, 0x86, 0x83, 0x86, 0x80, 0x7F, 0x81,
	0x7C, 0x7E, 0x7E, 0x7C, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x7D, 0x7D,
	0x7F, 0x7C, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x8B, 0x89, 0x8B, 0xA0, 0x8E, 0x9D,
	0x9F, 0x8B, 0x9E, 0x89, 0x83, 0x89, 0x72, 0x78, 0x74, 0x6A, 0x72, 0x6F,
	0x70, 0x76, 0x78, 0x7B, 0x80, 0x82, 0x82, 0x87, 0x85, 0x84, 0x87, 0x82,
	0x83, 0x83, 0x7F, 0x81, 0x81, 0x7D, 0x81, 0x7F, 0x7E, 0x81, 0x7E, 0x80,
	0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x85, 0x88, 0x86, 0x95,
	0x8E, 0x93, 0x9C, 0x8C, 0x97, 0x8E, 0x83, 0x8B, 0x7A, 0x79, 0x79, 0x6E,
	0x75, 0x71, 0x70, 0x77, 0x76, 0x79, 0x7E, 0x7E, 0x81, 0x83, 0x82, 0x84,
	0x84, 0x82, 0x84, 0x82, 0x80, 0x83, 0x7F, 0x81, 0x82, 0x7F, 0x82, 0x81,
	0x80, 0x82, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x86, 0x84,
	0x8A, 0x8F, 0x8B, 0x95, 0x8F, 0x8F, 0x92, 0x87, 0x8B, 0x84, 0x7E, 0x81,
	0x78, 0x7A, 0x79, 0x76, 0x7A, 0x7A, 0x7B, 0x7D, 0x7E, 0x7E, 0x81, 0x80,
	0x80, 0x82, 0x7F, 0x80, 0x80, 0x7D, 0x81, 0x7E, 0x7E, 0x81, 0x7D, 0x81,
	0x80, 0x7F, 0x82, 0x7F, 0x81, 0x81, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x84, 0x84,
	0x86, 0x8B, 0x89, 0x8D, 0x8B, 0x8A, 0x8B, 0x86, 0x87, 0x84, 0x81, 0x81,
	0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x82, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x83, 0x83, 0x87,
	0x86, 0x87, 0x88, 0x86, 0x88, 0x86, 0x85, 0x86, 0x83, 0x83, 0x82, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81,
	0x81, 0x81, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x82, 0x83, 0x84, 0x83, 0x85,
	0x84, 0x84, 0x85, 0x84, 0x85, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x83,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F
};
const unsigned char WAV7[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x81, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7E, 0x80, 0x80, 0x80, 0x7E,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x80, 0x81, 0x7E, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x7E, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80,
	0x7E, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x7E, 0x80, 0x7F,
	0x7E, 0x81, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x7F,
	0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x82, 0x80, 0x7D, 0x80, 0x80,
	0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F,
	0x80, 0x80, 0x7E, 0x7E, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x80,
	0x80, 0x81, 0x80, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7E, 0x81, 0x80, 0x7D, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x81, 0x7E, 0x7F, 0x81, 0x80, 0x7D,
	0x80, 0x81, 0x7E, 0x7E, 0x82, 0x7F, 0x7C, 0x81, 0x82, 0x7E, 0x7F, 0x81,
	0x7E, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x83, 0x81, 0x7F, 0x80, 0x80, 0x7E,
	0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x81,
	0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x7E, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7C,
	0x7C, 0x7E, 0x7E, 0x7F, 0x80, 0x82, 0x84, 0x85, 0x85, 0x85, 0x85, 0x84,
	0x84, 0x85, 0x85, 0x85, 0x84, 0x81, 0x80, 0x80, 0x82, 0x7F, 0x7E, 0x80,
	0x7F, 0x7F, 0x7F, 0x83, 0x84, 0x83, 0x86, 0x85, 0x83, 0x82, 0x80, 0x89,
	0x8D, 0x8A, 0x90, 0x90, 0x8E, 0x88, 0x85, 0x84, 0x7A, 0x79, 0x79, 0x78,
	0x78, 0x7A, 0x80, 0x7F, 0x80, 0x84, 0x84, 0x83, 0x81, 0x82, 0x80, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x80, 0x7F, 0x81, 0x82, 0x82, 0x80, 0x80,
	0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x82, 0x81, 0x82, 0x82, 0x82, 0x80, 0x80, 0x7F,
	0x80, 0x7B, 0x92, 0xA9, 0x9E, 0xAA, 0xAD, 0xA7, 0x8F, 0x82, 0x83, 0x6B,
	0x64, 0x67, 0x71, 0x71, 0x74, 0x89, 0x8B, 0x89, 0x8B, 0x8F, 0x88, 0x7A,
	0x7F, 0x7C, 0x76, 0x75, 0x7C, 0x81, 0x7C, 0x82, 0x87, 0x85, 0x81, 0x81,
	0x84, 0x7D, 0x7A, 0x7E, 0x7E, 0x7C, 0x7D, 0x82, 0x82, 0x7E, 0x82, 0x83,
	0x80, 0x7E, 0x7F, 0x81, 0x7A, 0x7C, 0x7D, 0x7F, 0x7C, 0x7F, 0x82, 0x81,
	0x7F, 0x82, 0x82, 0x80, 0x7C, 0x88, 0xB8, 0xB0, 0xAC, 0xB8, 0xAE, 0x93,
	0x6F, 0x78, 0x66, 0x55, 0x5F, 0x72, 0x7F, 0x78, 0x92, 0x9A, 0x8A, 0x83,
	0x83, 0x82, 0x6C, 0x70, 0x7D, 0x7A, 0x7A, 0x82, 0x90, 0x85, 0x80, 0x88,
	0x84, 0x7A, 0x75, 0x80, 0x7D, 0x77, 0x7F, 0x85, 0x84, 0x7D, 0x85, 0x86,
	0x7D, 0x7D, 0x7F, 0x82, 0x7C, 0x80, 0x86, 0x81, 0x80, 0x81, 0x82, 0x7F,
	0x7A, 0x81, 0x7E, 0x7E, 0x7D, 0x83, 0x80, 0x81, 0x7C, 0x98, 0xCD, 0xAF,
	0xB1, 0xB5, 0xA0, 0x78, 0x58, 0x6F, 0x5B, 0x55, 0x70, 0x89, 0x8D, 0x81,
	0x9A, 0x95, 0x7B, 0x75, 0x7A, 0x7B, 0x69, 0x77, 0x8A, 0x85, 0x81, 0x88,
	0x90, 0x7E, 0x76, 0x80, 0x7E, 0x75, 0x77, 0x86, 0x84, 0x7C, 0x84, 0x89,
	0x80, 0x7A, 0x7F, 0x83, 0x76, 0x78, 0x82, 0x81, 0x7D, 0x7E, 0x88, 0x82,
	0x7B, 0x81, 0x82, 0x7E, 0x79, 0x81, 0x83, 0x7D, 0x7F, 0x83, 0x83, 0x7B,
	0x80, 0x80, 0xBA, 0xCB, 0xA7, 0xB4, 0xA3, 0x8B, 0x59, 0x5A, 0x6E, 0x5A,
	0x6E, 0x87, 0x9E, 0x92, 0x86, 0x96, 0x80, 0x6D, 0x69, 0x77, 0x7C, 0x72,
	0x89, 0x92, 0x8C, 0x81, 0x82, 0x86, 0x73, 0x72, 0x7D, 0x80, 0x7E, 0x7F,
	0x8C, 0x87, 0x7E, 0x7F, 0x85, 0x82, 0x77, 0x7F, 0x85, 0x81, 0x7C, 0x81,
	0x86, 0x7E, 0x7A, 0x81, 0x81, 0x7E, 0x7B, 0x83, 0x82, 0x7D, 0x7F, 0x82,
	0x82, 0x7B, 0x7E, 0x82, 0x80, 0x7C, 0x81, 0x7F, 0xBA, 0xD1, 0xA7, 0xA5,
	0x99, 0x88, 0x59, 0x4F, 0x76, 0x75, 0x79, 0x89, 0xA0, 0x9E, 0x7A, 0x7D,
	0x7E, 0x70, 0x67, 0x70, 0x8C, 0x87, 0x82, 0x8E, 0x8E, 0x83, 0x71, 0x77,
	0x7F, 0x76, 0x78, 0x83, 0x96, 0x91, 0x83, 0x89, 0x86, 0x7B, 0x70, 0x75,
	0x82, 0x7D, 0x7E, 0x86, 0x8B, 0x85, 0x7A, 0x7E, 0x7F, 0x7A, 0x79, 0x7D,
	0x86, 0x82, 0x7F, 0x84, 0x83, 0x80, 0x79, 0x7D, 0x81, 0x7D, 0x7F, 0x83,
	0x84, 0x84, 0x7C, 0x8C, 0xC5, 0xBD, 0xA0, 0x99, 0x93, 0x84, 0x5A, 0x5B,
	0x78, 0x7E, 0x7F, 0x85, 0x9A, 0x9B, 0x7E, 0x78, 0x7A, 0x79, 0x6F, 0x6E,
	0x84, 0x8B, 0x86, 0x84, 0x89, 0x8D, 0x7F, 0x74, 0x7A, 0x7E, 0x7D, 0x79,
	0x7F, 0x8A, 0x85, 0x80, 0x80, 0x81, 0x80, 0x79, 0x7A, 0x80, 0x81, 0x80,
	0x7F, 0x83, 0x84, 0x7F, 0x7D, 0x7E, 0x80, 0x7E, 0x7D, 0x7F, 0x7F, 0x7E,
	0x7D, 0x7E, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x81,
	0x7C, 0x90, 0xBC, 0xB8, 0xA4, 0x99, 0x90, 0x88, 0x6C, 0x5C, 0x6E, 0x7A,
	0x80, 0x83, 0x8A, 0x99, 0x91, 0x81, 0x7B, 0x79, 0x79, 0x74, 0x6E, 0x7A,
	0x83, 0x85, 0x86, 0x84, 0x88, 0x87, 0x7E, 0x7A, 0x7A, 0x7B, 0x7D, 0x7A,
	0x7E, 0x84, 0x84, 0x83, 0x81, 0x81, 0x82, 0x7E, 0x7B, 0x7D, 0x7E, 0x7F,
	0x7F, 0x7F, 0x81, 0x83, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7E, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x99, 0xAD, 0xA6, 0x9E, 0x96, 0x95, 0x92, 0x7E, 0x71, 0x72, 0x76, 0x7D,
	0x7C, 0x7C, 0x88, 0x8F, 0x8E, 0x8A, 0x84, 0x84, 0x83, 0x7B, 0x78, 0x77,
	0x7B, 0x7F, 0x7E, 0x7F, 0x83, 0x85, 0x86, 0x83, 0x80, 0x80, 0x7E, 0x7C,
	0x7B, 0x7A, 0x7C, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x8A,
	0x8F, 0x90, 0x90, 0x8E, 0x8F, 0x8F, 0x89, 0x85, 0x82, 0x81, 0x81, 0x7E,
	0x7C, 0x7C, 0x7E, 0x7F, 0x7E, 0x7D, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x85, 0x86,
	0x87, 0x88, 0x88, 0x8A, 0x8A, 0x89, 0x88, 0x87, 0x87, 0x86, 0x83, 0x82,
	0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x85, 0x86, 0x85, 0x86,
	0x87, 0x88, 0x86, 0x84, 0x84, 0x84, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x82, 0x82, 0x81, 0x82, 0x82, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x86, 0x94, 0x91, 0x8D, 0x91, 0x90, 0x8D,
	0x86, 0x7F, 0x82, 0x80, 0x7A, 0x7A, 0x7C, 0x7E, 0x7F, 0x7D, 0x80, 0x84,
	0x82, 0x81, 0x81, 0x82, 0x82, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F,
	0x80, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7E, 0x88, 0xA4, 0xA3, 0x98, 0x9C, 0x9A, 0x91, 0x82, 0x74, 0x77,
	0x78, 0x6F, 0x73, 0x7D, 0x86, 0x8A, 0x87, 0x8B, 0x8F, 0x86, 0x7F, 0x7D,
	0x7C, 0x7A, 0x76, 0x77, 0x7F, 0x80, 0x80, 0x83, 0x86, 0x86, 0x82, 0x7F,
	0x81, 0x7F, 0x7B, 0x7B, 0x7D, 0x7E, 0x7F, 0x7E, 0x81, 0x83, 0x80, 0x7E,
	0x7F, 0x7F, 0x7D, 0x7C, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x82, 0x81, 0x7F,
	0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x7E, 0x9B,
	0xB9, 0xA6, 0xA2, 0xA8, 0x99, 0x84, 0x6D, 0x6B, 0x74, 0x65, 0x69, 0x7E,
	0x87, 0x8C, 0x89, 0x8F, 0x94, 0x84, 0x7A, 0x7D, 0x79, 0x76, 0x72, 0x78,
	0x83, 0x80, 0x81, 0x88, 0x88, 0x85, 0x80, 0x7E, 0x81, 0x7B, 0x73, 0x77,
	0x7B, 0x7B, 0x7B, 0x7E, 0x86, 0x85, 0x80, 0x83, 0x83, 0x80, 0x7C, 0x7C,
	0x7F, 0x7E, 0x7B, 0x7F, 0x82, 0x82, 0x80, 0x81, 0x82, 0x81, 0x7D, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7E, 0x83, 0x81, 0x81, 0x7F, 0xA9, 0xCB, 0xAE, 0xAE,
	0xB6, 0xA2, 0x83, 0x64, 0x6B, 0x70, 0x5A, 0x67, 0x80, 0x8B, 0x8D, 0x88,
	0x95, 0x95, 0x7C, 0x78, 0x7B, 0x77, 0x72, 0x6F, 0x80, 0x87, 0x7F, 0x85,
	0x8B, 0x88, 0x81, 0x7A, 0x80, 0x7E, 0x75, 0x7A, 0x80, 0x81, 0x80, 0x80,
	0x87, 0x84, 0x7D, 0x80, 0x80, 0x7E, 0x7B, 0x7C, 0x81, 0x7F, 0x7E, 0x81,
	0x82, 0x82, 0x7E, 0x80, 0x82, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x7E, 0x80,
	0x81, 0x7E, 0x80, 0x7E, 0x82, 0x7B, 0xA0, 0xC9, 0xB0, 0xB1, 0xBA, 0xA6,
	0x87, 0x65, 0x6B, 0x6C, 0x51, 0x64, 0x7D, 0x85, 0x88, 0x89, 0x97, 0x8C,
	0x76, 0x7A, 0x78, 0x72, 0x6E, 0x76, 0x87, 0x82, 0x82, 0x8E, 0x8C, 0x84,
	0x7D, 0x7E, 0x80, 0x74, 0x77, 0x80, 0x7F, 0x7F, 0x80, 0x87, 0x86, 0x7D,
	0x81, 0x82, 0x7C, 0x7B, 0x7C, 0x81, 0x7E, 0x7C, 0x83, 0x83, 0x80, 0x7F,
	0x81, 0x82, 0x7D, 0x7C, 0x81, 0x7F, 0x7E, 0x7F, 0x81, 0x82, 0x7E, 0x80,
	0x82, 0x7F, 0x7E, 0x80, 0x7E, 0xA4, 0xBA, 0xA8, 0xB2, 0xB2, 0x9A, 0x7C,
	0x67, 0x6D, 0x60, 0x53, 0x6D, 0x7D, 0x83, 0x87, 0x90, 0x9C, 0x88, 0x7C,
	0x83, 0x79, 0x71, 0x6F, 0x79, 0x84, 0x7A, 0x83, 0x8E, 0x88, 0x83, 0x80,
	0x83, 0x7E, 0x73, 0x7B, 0x83, 0x7D, 0x7F, 0x84, 0x89, 0x83, 0x7E, 0x84,
	0x81, 0x7A, 0x7B, 0x7E, 0x80, 0x7C, 0x7D, 0x85, 0x82, 0x7F, 0x81, 0x82,
	0x81, 0x7C, 0x7F, 0x81, 0x7D, 0x7D, 0x80, 0x81, 0x80, 0x7E, 0x82, 0x81,
	0x7E, 0x7E, 0x80, 0x7F, 0x82, 0xA8, 0xAE, 0xA2, 0xAC, 0xA8, 0x98, 0x7F,
	0x73, 0x77, 0x66, 0x61, 0x73, 0x7B, 0x80, 0x82, 0x8E, 0x94, 0x85, 0x83,
	0x85, 0x7C, 0x76, 0x73, 0x79, 0x7B, 0x76, 0x7F, 0x85, 0x83, 0x84, 0x85,
	0x86, 0x82, 0x7C, 0x80, 0x7E, 0x7A, 0x7D, 0x7D, 0x80, 0x7F, 0x7F, 0x84,
	0x81, 0x80, 0x82, 0x80, 0x80, 0x7E, 0x7E, 0x80, 0x7D, 0x7E, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x9A, 0xA6, 0xA0, 0xA8, 0xA6, 0x9E,
	0x91, 0x84, 0x84, 0x76, 0x6C, 0x71, 0x6D, 0x6D, 0x6E, 0x72, 0x7B, 0x7A,
	0x7F, 0x88, 0x86, 0x88, 0x89, 0x88, 0x89, 0x83, 0x83, 0x83, 0x7D, 0x7D,
	0x7C, 0x7B, 0x7C, 0x7A, 0x7D, 0x7D, 0x7D, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x83, 0x81, 0x80, 0x82, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x89, 0x95, 0x97, 0x99,
	0x9A, 0x97, 0x95, 0x93, 0x93, 0x8F, 0x87, 0x83, 0x7D, 0x79, 0x78, 0x77,
	0x78, 0x77, 0x77, 0x7A, 0x7C, 0x7F, 0x83, 0x85, 0x87, 0x87, 0x88, 0x89,
	0x88, 0x88, 0x85, 0x82, 0x81, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B, 0x7A, 0x7A,
	0x7C, 0x7D, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x83, 0x83, 0x82,
	0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F,
	0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x87,
	0x93, 0x93, 0x96, 0x95, 0x91, 0x93, 0x92, 0x92, 0x8F, 0x86, 0x83, 0x7E,
	0x7C, 0x7D, 0x7B, 0x7A, 0x78, 0x78, 0x7C, 0x7E, 0x82, 0x85, 0x84, 0x86,
	0x87, 0x88, 0x89, 0x88, 0x86, 0x83, 0x81, 0x80, 0x7E, 0x7D, 0x7C, 0x7A,
	0x7A, 0x7A, 0x7C, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x82, 0x83, 0x83, 0x83,
	0x82, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x82, 0x8F, 0x92, 0x92, 0x95, 0x91, 0x91, 0x92, 0x91, 0x90,
	0x88, 0x83, 0x7F, 0x7B, 0x7D, 0x7B, 0x7A, 0x79, 0x78, 0x7B, 0x7E, 0x82,
	0x85, 0x85, 0x86, 0x87, 0x88, 0x8A, 0x88, 0x87, 0x84, 0x81, 0x80, 0x7E,
	0x7E, 0x7C, 0x7A, 0x7A, 0x79, 0x7B, 0x7D, 0x7E, 0x7F, 0x80, 0x82, 0x83,
	0x84, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7D, 0x7D, 0x7C,
	0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83,
	0x82, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x83, 0x8C, 0x8D, 0x8E, 0x8F, 0x8D,
	0x8F, 0x8F, 0x91, 0x8F, 0x89, 0x86, 0x82, 0x81, 0x80, 0x7E, 0x7D, 0x7A,
	0x7A, 0x7C, 0x7E, 0x81, 0x82, 0x83, 0x85, 0x86, 0x88, 0x89, 0x8A, 0x89,
	0x87, 0x85, 0x84, 0x83, 0x81, 0x7F, 0x7D, 0x7C, 0x7B, 0x7B, 0x7C, 0x7D,
	0x7D, 0x7E, 0x80, 0x81, 0x83, 0x84, 0x85, 0x85, 0x85, 0x85, 0x85, 0x84,
	0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x85, 0x8A,
	0x8B, 0x8B, 0x8B, 0x8A, 0x8A, 0x8A, 0x8B, 0x8A, 0x87, 0x86, 0x84, 0x83,
	0x82, 0x82, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x84,
	0x85, 0x86, 0x87, 0x87, 0x87, 0x86, 0x86, 0x86, 0x85, 0x84, 0x83, 0x82,
	0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81,
	0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x83, 0x87, 0x87, 0x89, 0x8A, 0x8A, 0x8B, 0x8B, 0x8D, 0x8B,
	0x8A, 0x89, 0x88, 0x87, 0x86, 0x85, 0x83, 0x82, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83,
	0x83, 0x84, 0x84, 0x84, 0x84, 0x85, 0x85, 0x84, 0x85, 0x84, 0x82, 0x81,
	0x81, 0x81, 0x80, 0x81, 0x82, 0x81, 0x81, 0x82, 0x83, 0x83, 0x83, 0x85,
	0x85, 0x85, 0x85, 0x85, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x82, 0x82, 0x81, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAV70[] = {
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x80, 0x81,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80,
	0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x81,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7E,
	0x80, 0x81, 0x7F, 0x7E, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x7F, 0x82,
	0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7E,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x7E, 0x7F,
	0x81, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x82, 0x7F, 0x7F,
	0x81, 0x81, 0x7E, 0x80, 0x80, 0x7D, 0x80, 0x80, 0x7E, 0x7E, 0x80, 0x80,
	0x7E, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x82, 0x80, 0x80, 0x7F,
	0x81, 0x7D, 0x7F, 0x81, 0x7D, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7E,
	0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x81, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x7D, 0x81, 0x80, 0x7E,
	0x80, 0x82, 0x7E, 0x7E, 0x82, 0x7E, 0x7D, 0x7F, 0x82, 0x7E, 0x7F, 0x83,
	0x80, 0x7F, 0x82, 0x81, 0x7D, 0x7F, 0x82, 0x7C, 0x7F, 0x82, 0x7F, 0x7F,
	0x81, 0x7F, 0x7E, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x7F,
	0x7E, 0x80, 0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x7D, 0x7F, 0x81, 0x7E, 0x80,
	0x81, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x81, 0x81,
	0x80, 0x81, 0x82, 0x82, 0x81, 0x80, 0x82, 0x80, 0x7E, 0x7F, 0x7E, 0x7E,
	0x7D, 0x7F, 0x7F, 0x7D, 0x80, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x82,
	0x82, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x82, 0x81, 0x82, 0x83, 0x82,
	0x82, 0x81, 0x82, 0x81, 0x7F, 0x82, 0x84, 0x81, 0x83, 0x86, 0x86, 0x88,
	0x88, 0x89, 0x85, 0x82, 0x83, 0x7F, 0x7F, 0x7D, 0x7F, 0x7E, 0x7C, 0x80,
	0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x87, 0x90, 0x8D, 0x92, 0x93, 0x90, 0x8A,
	0x84, 0x83, 0x7A, 0x76, 0x78, 0x77, 0x78, 0x79, 0x7F, 0x81, 0x81, 0x85,
	0x85, 0x84, 0x81, 0x82, 0x81, 0x7D, 0x7E, 0x7E, 0x7E, 0x7D, 0x7F, 0x81,
	0x80, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x81,
	0x7E, 0x99, 0xA9, 0x9F, 0xAC, 0xAC, 0xA3, 0x8A, 0x82, 0x7F, 0x67, 0x64,
	0x69, 0x72, 0x71, 0x79, 0x8C, 0x8A, 0x89, 0x8C, 0x8D, 0x84, 0x7A, 0x7F,
	0x7A, 0x75, 0x76, 0x7C, 0x7F, 0x7C, 0x84, 0x87, 0x83, 0x82, 0x82, 0x83,
	0x7C, 0x7C, 0x7F, 0x7D, 0x7C, 0x7E, 0x82, 0x80, 0x80, 0x82, 0x83, 0x7E,
	0x7F, 0x80, 0x80, 0x7C, 0x7F, 0x7F, 0x7F, 0x7D, 0x88, 0xB1, 0xA1, 0xA1,
	0xAB, 0x9F, 0x89, 0x6E, 0x7B, 0x69, 0x5D, 0x6B, 0x79, 0x80, 0x7A, 0x91,
	0x95, 0x87, 0x85, 0x84, 0x83, 0x6F, 0x76, 0x7E, 0x77, 0x7A, 0x80, 0x8C,
	0x81, 0x81, 0x89, 0x82, 0x7A, 0x79, 0x7F, 0x7A, 0x76, 0x81, 0x83, 0x81,
	0x7F, 0x86, 0x85, 0x7C, 0x7F, 0x81, 0x7E, 0x7A, 0x7E, 0x83, 0x7E, 0x7E,
	0x84, 0x81, 0x81, 0x79, 0xA9, 0xC5, 0xA7, 0xB7, 0xB5, 0x9F, 0x70, 0x68,
	0x72, 0x54, 0x5B, 0x74, 0x8A, 0x84, 0x88, 0xA1, 0x8F, 0x7E, 0x7B, 0x80,
	0x73, 0x66, 0x7E, 0x83, 0x7E, 0x81, 0x8F, 0x8D, 0x7B, 0x81, 0x84, 0x78,
	0x74, 0x7C, 0x84, 0x7B, 0x80, 0x8A, 0x86, 0x7F, 0x7F, 0x85, 0x7C, 0x77,
	0x7F, 0x82, 0x7C, 0x7E, 0x85, 0x85, 0x7C, 0x82, 0x80, 0x81, 0x74, 0x9F,
	0xD3, 0xA8, 0xAE, 0xB3, 0x9A, 0x68, 0x55, 0x73, 0x57, 0x59, 0x77, 0x92,
	0x8E, 0x80, 0x9E, 0x8E, 0x73, 0x72, 0x7B, 0x7B, 0x68, 0x82, 0x90, 0x84,
	0x82, 0x89, 0x8C, 0x74, 0x74, 0x82, 0x7A, 0x76, 0x7D, 0x8C, 0x82, 0x7C,
	0x88, 0x84, 0x7B, 0x76, 0x81, 0x80, 0x77, 0x80, 0x86, 0x82, 0x7D, 0x82,
	0x86, 0x79, 0x7C, 0x7F, 0x83, 0x77, 0xB0, 0xD8, 0xA5, 0xAB, 0xA7, 0x8A,
	0x56, 0x4F, 0x75, 0x61, 0x67, 0x8F, 0xA1, 0x94, 0x7F, 0x95, 0x87, 0x64,
	0x6C, 0x7C, 0x81, 0x73, 0x86, 0x9B, 0x86, 0x7C, 0x82, 0x83, 0x74, 0x6C,
	0x83, 0x85, 0x7B, 0x82, 0x8D, 0x87, 0x77, 0x7D, 0x84, 0x79, 0x76, 0x80,
	0x87, 0x80, 0x7D, 0x87, 0x88, 0x7B, 0x7C, 0x81, 0x82, 0x78, 0x7D, 0x82,
	0x93, 0xD1, 0xBD, 0xA4, 0xAB, 0x8D, 0x6F, 0x4F, 0x5D, 0x77, 0x6A, 0x81,
	0x9C, 0x9D, 0x8E, 0x7C, 0x85, 0x76, 0x62, 0x70, 0x7F, 0x84, 0x84, 0x89,
	0x95, 0x89, 0x79, 0x7B, 0x7B, 0x77, 0x73, 0x7C, 0x89, 0x85, 0x82, 0x86,
	0x87, 0x7F, 0x77, 0x7B, 0x7F, 0x7B, 0x7C, 0x83, 0x86, 0x82, 0x7F, 0x82,
	0x81, 0x7C, 0x7A, 0x7F, 0x82, 0x81, 0x7E, 0xB5, 0xD5, 0xAC, 0xA2, 0x9F,
	0x8C, 0x6B, 0x4C, 0x67, 0x7B, 0x71, 0x80, 0x94, 0xA1, 0x92, 0x79, 0x81,
	0x7F, 0x6C, 0x6A, 0x75, 0x86, 0x85, 0x7F, 0x8D, 0x8F, 0x83, 0x77, 0x73,
	0x7B, 0x79, 0x72, 0x7C, 0x86, 0x88, 0x85, 0x80, 0x86, 0x84, 0x79, 0x79,
	0x7C, 0x7F, 0x7E, 0x7C, 0x82, 0x87, 0x81, 0x80, 0x7F, 0x81, 0x7E, 0x7C,
	0x7A, 0x96, 0xC9, 0xBE, 0xA5, 0xA4, 0x9A, 0x8C, 0x6D, 0x55, 0x6B, 0x78,
	0x74, 0x7E, 0x89, 0x9A, 0x9B, 0x84, 0x81, 0x83, 0x79, 0x73, 0x6C, 0x75,
	0x84, 0x81, 0x81, 0x89, 0x8A, 0x89, 0x80, 0x79, 0x7E, 0x7C, 0x78, 0x7A,
	0x7C, 0x82, 0x85, 0x81, 0x83, 0x84, 0x82, 0x81, 0x7C, 0x7C, 0x7F, 0x7D,
	0x7D, 0x7F, 0x80, 0x82, 0x82, 0x7F, 0x82, 0x7F, 0x95, 0xB9, 0xB2, 0xA3,
	0x9E, 0x94, 0x8E, 0x79, 0x61, 0x67, 0x71, 0x76, 0x7C, 0x7E, 0x8B, 0x98,
	0x92, 0x8A, 0x86, 0x80, 0x80, 0x77, 0x70, 0x75, 0x7A, 0x7E, 0x81, 0x81,
	0x86, 0x8A, 0x86, 0x82, 0x80, 0x7D, 0x7E, 0x7B, 0x79, 0x7C, 0x7E, 0x80,
	0x82, 0x81, 0x83, 0x84, 0x82, 0x81, 0x7F, 0x7E, 0x7F, 0x7E, 0x7D, 0x7E,
	0x7E, 0x80, 0x81, 0x92, 0xA4, 0xA3, 0x9D, 0x98, 0x93, 0x91, 0x85, 0x76,
	0x74, 0x76, 0x79, 0x7C, 0x7A, 0x7F, 0x87, 0x89, 0x89, 0x86, 0x84, 0x86,
	0x84, 0x80, 0x7D, 0x7C, 0x7D, 0x7E, 0x7D, 0x7D, 0x7F, 0x80, 0x82, 0x81,
	0x80, 0x81, 0x81, 0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x81, 0x89, 0x8E,
	0x8E, 0x8E, 0x8E, 0x90, 0x90, 0x8C, 0x88, 0x86, 0x84, 0x83, 0x80, 0x7D,
	0x7C, 0x7D, 0x7D, 0x7D, 0x7B, 0x7C, 0x7D, 0x7E, 0x7E, 0x7D, 0x7D, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x81, 0x84, 0x85, 0x86, 0x87, 0x88, 0x8A, 0x8A,
	0x89, 0x89, 0x88, 0x87, 0x86, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x83,
	0x86, 0x85, 0x86, 0x87, 0x88, 0x89, 0x87, 0x86, 0x86, 0x85, 0x84, 0x82,
	0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x88, 0x88, 0x86, 0x89, 0x89,
	0x89, 0x86, 0x83, 0x84, 0x82, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x82, 0x91, 0x96, 0x90, 0x93, 0x95, 0x92, 0x8B, 0x82, 0x81,
	0x80, 0x79, 0x78, 0x7B, 0x7E, 0x7F, 0x7F, 0x82, 0x87, 0x85, 0x83, 0x83,
	0x82, 0x80, 0x7D, 0x7C, 0x7D, 0x7E, 0x7C, 0x7E, 0x80, 0x81, 0x81, 0x81,
	0x82, 0x82, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x94,
	0xA9, 0x9E, 0x9E, 0xA3, 0x9B, 0x8F, 0x7C, 0x76, 0x7A, 0x6E, 0x6A, 0x76,
	0x7D, 0x81, 0x82, 0x88, 0x90, 0x89, 0x82, 0x84, 0x81, 0x7B, 0x77, 0x78,
	0x7D, 0x7B, 0x7B, 0x82, 0x84, 0x83, 0x83, 0x83, 0x84, 0x80, 0x7C, 0x7E,
	0x7E, 0x7D, 0x7C, 0x7F, 0x81, 0x7F, 0x80, 0x82, 0x81, 0x80, 0x7F, 0x80,
	0x80, 0x7D, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x9F, 0xB9, 0xA7, 0xAE,
	0xB2, 0xA3, 0x8C, 0x75, 0x75, 0x70, 0x5E, 0x67, 0x76, 0x7D, 0x82, 0x87,
	0x95, 0x93, 0x87, 0x86, 0x84, 0x7B, 0x74, 0x72, 0x7A, 0x79, 0x78, 0x81,
	0x86, 0x86, 0x84, 0x84, 0x86, 0x81, 0x7B, 0x7D, 0x7D, 0x7A, 0x7B, 0x7E,
	0x81, 0x81, 0x80, 0x83, 0x84, 0x83, 0x80, 0x82, 0x81, 0x7E, 0x7D, 0x7F,
	0x7F, 0x7E, 0x7E, 0x81, 0x80, 0x83, 0xB2, 0xBE, 0xAF, 0xBB, 0xB7, 0xA5,
	0x85, 0x70, 0x74, 0x62, 0x56, 0x67, 0x75, 0x7E, 0x80, 0x8D, 0x9B, 0x8E,
	0x87, 0x89, 0x82, 0x78, 0x6F, 0x77, 0x7A, 0x74, 0x7A, 0x85, 0x86, 0x83,
	0x85, 0x8A, 0x85, 0x7D, 0x7E, 0x7F, 0x7B, 0x78, 0x7C, 0x81, 0x7E, 0x7E,
	0x83, 0x84, 0x81, 0x80, 0x81, 0x7F, 0x7B, 0x7B, 0x7E, 0x7C, 0x7C, 0x7F,
	0x82, 0x80, 0x82, 0x7F, 0x98, 0xB7, 0xAC, 0xB5, 0xBB, 0xAD, 0x98, 0x81,
	0x7D, 0x6D, 0x5A, 0x63, 0x6B, 0x70, 0x77, 0x84, 0x93, 0x8E, 0x8B, 0x90,
	0x88, 0x7C, 0x78, 0x78, 0x75, 0x70, 0x76, 0x7C, 0x7C, 0x7F, 0x85, 0x88,
	0x85, 0x84, 0x87, 0x82, 0x7E, 0x7E, 0x7D, 0x7B, 0x7A, 0x7D, 0x7F, 0x7D,
	0x80, 0x82, 0x82, 0x81, 0x81, 0x82, 0x80, 0x7E, 0x7F, 0x7F, 0x7D, 0x7E,
	0x7E, 0x7F, 0x7D, 0x86, 0xA4, 0xAA, 0xAC, 0xB5, 0xB0, 0xA5, 0x94, 0x8E,
	0x84, 0x73, 0x70, 0x6F, 0x6B, 0x6A, 0x6F, 0x78, 0x79, 0x7E, 0x83, 0x82,
	0x84, 0x86, 0x89, 0x88, 0x86, 0x85, 0x81, 0x7D, 0x7C, 0x7B, 0x7A, 0x79,
	0x79, 0x79, 0x79, 0x7B, 0x7D, 0x80, 0x81, 0x82, 0x84, 0x83, 0x83, 0x84,
	0x83, 0x82, 0x81, 0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x81, 0x80, 0x8B, 0x9E, 0xA4, 0xAB, 0xAA, 0xA4, 0xA0, 0x9B, 0x9D,
	0x97, 0x8E, 0x86, 0x7A, 0x73, 0x70, 0x71, 0x75, 0x74, 0x76, 0x76, 0x79,
	0x7F, 0x85, 0x8B, 0x8E, 0x8E, 0x8D, 0x8B, 0x8B, 0x8A, 0x88, 0x86, 0x80,
	0x7D, 0x79, 0x78, 0x78, 0x78, 0x79, 0x78, 0x79, 0x7B, 0x7E, 0x81, 0x83,
	0x85, 0x85, 0x85, 0x85, 0x84, 0x83, 0x81, 0x80, 0x7E, 0x7C, 0x7B, 0x7A,
	0x7A, 0x7A, 0x7A, 0x7E, 0x8F, 0x9B, 0xA3, 0xA9, 0xA6, 0xA3, 0x9F, 0x9F,
	0x9D, 0x96, 0x8F, 0x83, 0x7A, 0x74, 0x71, 0x72, 0x71, 0x72, 0x71, 0x73,
	0x77, 0x7C, 0x83, 0x88, 0x8C, 0x8D, 0x8C, 0x8C, 0x8C, 0x8C, 0x8A, 0x87,
	0x83, 0x7E, 0x7B, 0x79, 0x78, 0x78, 0x77, 0x78, 0x78, 0x79, 0x7C, 0x7F,
	0x81, 0x83, 0x85, 0x85, 0x85, 0x84, 0x84, 0x83, 0x82, 0x81, 0x7F, 0x7D,
	0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x88, 0x93, 0x9C, 0xA4, 0xA4, 0xA4, 0xA1,
	0x9F, 0x9E, 0x9B, 0x97, 0x8E, 0x85, 0x7D, 0x76, 0x74, 0x73, 0x73, 0x72,
	0x72, 0x73, 0x74, 0x79, 0x7E, 0x83, 0x87, 0x89, 0x8B, 0x8B, 0x8C, 0x8C,
	0x8B, 0x8A, 0x87, 0x84, 0x81, 0x7E, 0x7C, 0x7A, 0x79, 0x79, 0x78, 0x78,
	0x79, 0x7A, 0x7C, 0x7E, 0x80, 0x82, 0x83, 0x84, 0x85, 0x85, 0x85, 0x85,
	0x85, 0x84, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x86, 0x8C, 0x92, 0x97, 0x98,
	0x98, 0x97, 0x96, 0x95, 0x95, 0x93, 0x8F, 0x8B, 0x85, 0x80, 0x7D, 0x7C,
	0x7B, 0x7B, 0x7A, 0x79, 0x79, 0x79, 0x7A, 0x7D, 0x7F, 0x81, 0x82, 0x83,
	0x83, 0x83, 0x84, 0x85, 0x85, 0x85, 0x84, 0x82, 0x81, 0x80, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x82, 0x86, 0x8A,
	0x8E, 0x90, 0x90, 0x8F, 0x8D, 0x8C, 0x8B, 0x8B, 0x8A, 0x88, 0x86, 0x83,
	0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x83, 0x86, 0x88, 0x8A, 0x89, 0x88, 0x86, 0x85, 0x84, 0x84, 0x84,
	0x84, 0x84, 0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x84, 0x85, 0x86, 0x85, 0x85,
	0x84, 0x83, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7D, 0x7F, 0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7C, 0x7F, 0x7D, 0x7E,
	0x81, 0x7D, 0x7D, 0x7E, 0x80, 0x7F, 0x81, 0x82, 0x7F, 0x82, 0x83, 0x82,
	0x81, 0x83, 0x80, 0x80, 0x83, 0x82, 0x7E, 0x80, 0x82, 0x7E, 0x80, 0x80,
	0x7E, 0x7E, 0x80, 0x81, 0x80, 0x82, 0x81, 0x80, 0x82, 0x82, 0x80, 0x82,
	0x81, 0x80, 0x83, 0x83, 0x80, 0x85, 0x84, 0x85, 0x87, 0x86, 0x86, 0x83,
	0x86, 0x83, 0x85, 0x84, 0x82, 0x84, 0x84, 0x82, 0x83, 0x85, 0x84, 0x84,
	0x84, 0x84, 0x81, 0x83, 0x81, 0x7D, 0x80, 0x7E, 0x7B, 0x7F, 0x7F, 0x7E,
	0x81, 0x85, 0x82, 0x84, 0x87, 0x82, 0x83, 0x84, 0x82, 0x80, 0x81, 0x88,
	0x84, 0x88, 0x8D, 0x88, 0x8A, 0x89, 0x87, 0x83, 0x84, 0x81, 0x7D, 0x7F,
	0x7D, 0x7B, 0x7D, 0x7D, 0x7C, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x83,
	0x90, 0x8B, 0x96, 0x9F, 0x97, 0x9C, 0x9B, 0x93, 0x8C, 0x89, 0x81, 0x77,
	0x78, 0x73, 0x6E, 0x74, 0x73, 0x74, 0x7A, 0x7D, 0x7F, 0x82, 0x86, 0x84,
	0x86, 0x87, 0x83, 0x83, 0x82, 0x7F, 0x7E, 0x7E, 0x7D, 0x7C, 0x7E, 0x7D,
	0x7D, 0x80, 0x7F, 0x80, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x7D,
	0x88, 0x96, 0x8A, 0xA5, 0xA4, 0x99, 0xAA, 0x9B, 0x92, 0x91, 0x84, 0x79,
	0x73, 0x73, 0x67, 0x6A, 0x71, 0x69, 0x76, 0x7B, 0x7A, 0x85, 0x87, 0x88,
	0x8A, 0x8B, 0x89, 0x85, 0x85, 0x80, 0x7C, 0x7C, 0x79, 0x78, 0x7A, 0x7A,
	0x7A, 0x7D, 0x7F, 0x7F, 0x82, 0x84, 0x82, 0x84, 0x83, 0x81, 0x81, 0x81,
	0x7F, 0x7E, 0x7F, 0x7C, 0x7E, 0x7F, 0x7D, 0x7F, 0x7F, 0x7F, 0x7D, 0x80,
	0x7D, 0x7D, 0x80, 0x7C, 0x7D, 0x80, 0x7D, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x9B, 0x8D, 0x96, 0xB2, 0x92, 0xA5, 0xA5, 0x8A, 0x91, 0x84,
	0x77, 0x70, 0x6F, 0x69, 0x64, 0x72, 0x6C, 0x72, 0x81, 0x7B, 0x85, 0x8C,
	0x87, 0x8C, 0x8B, 0x88, 0x84, 0x84, 0x80, 0x7B, 0x7F, 0x79, 0x7A, 0x7D,
	0x7A, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x83, 0x81, 0x82, 0x81, 0x80, 0x81,
	0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7E, 0x8A, 0x96, 0x89, 0xA6, 0xA2, 0x94, 0xAD, 0x94,
	0x8C, 0x92, 0x79, 0x75, 0x74, 0x68, 0x66, 0x6C, 0x6B, 0x6D, 0x7B, 0x79,
	0x7F, 0x8B, 0x84, 0x8B, 0x8E, 0x86, 0x89, 0x86, 0x80, 0x80, 0x7D, 0x7A,
	0x7A, 0x7A, 0x79, 0x7B, 0x7C, 0x7C, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7C, 0x80, 0x7B, 0x7B, 0x7F, 0x78, 0x7E, 0x7E,
	0x7C, 0x81, 0x81, 0x7F, 0x83, 0x82, 0x82, 0x82, 0x86, 0x97, 0x88, 0xA0,
	0xA4, 0x8F, 0xAB, 0x94, 0x8A, 0x96, 0x78, 0x78, 0x78, 0x67, 0x6A, 0x6D,
	0x68, 0x6E, 0x79, 0x75, 0x81, 0x87, 0x83, 0x8D, 0x8D, 0x87, 0x8D, 0x87,
	0x82, 0x85, 0x7D, 0x7C, 0x7D, 0x78, 0x7A, 0x7C, 0x79, 0x7D, 0x7F, 0x7E,
	0x82, 0x82, 0x81, 0x84, 0x83, 0x81, 0x83, 0x81, 0x80, 0x81, 0x7F, 0x7E,
	0x7F, 0x7E, 0x7E, 0x7F, 0x7D, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x81,
	0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7B, 0x7D, 0x90, 0x83, 0x94, 0xA4, 0x8B, 0xA8, 0x9C, 0x8B, 0x9F, 0x82,
	0x7F, 0x83, 0x6C, 0x71, 0x6F, 0x67, 0x6F, 0x71, 0x72, 0x79, 0x80, 0x7F,
	0x87, 0x89, 0x86, 0x8C, 0x88, 0x85, 0x87, 0x80, 0x80, 0x7F, 0x7B, 0x7C,
	0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x7E, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x84, 0x90, 0x85, 0x9B,
	0x9B, 0x8F, 0xAA, 0x91, 0x93, 0x9A, 0x7E, 0x87, 0x7D, 0x6E, 0x77, 0x6C,
	0x6B, 0x72, 0x6E, 0x72, 0x7A, 0x79, 0x7E, 0x84, 0x82, 0x86, 0x89, 0x84,
	0x87, 0x86, 0x81, 0x84, 0x80, 0x7F, 0x81, 0x7D, 0x7E, 0x7F, 0x7C, 0x7F,
	0x7F, 0x7D, 0x7F, 0x7F, 0x7E, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x7F, 0x81, 0x7E, 0x83, 0x8A, 0x83, 0x96, 0x91, 0x90, 0xA0, 0x8D,
	0x96, 0x93, 0x82, 0x8B, 0x7C, 0x76, 0x7A, 0x6E, 0x71, 0x72, 0x6E, 0x75,
	0x76, 0x77, 0x7D, 0x7E, 0x7F, 0x84, 0x82, 0x82, 0x85, 0x82, 0x83, 0x83,
	0x80, 0x83, 0x81, 0x80, 0x82, 0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7F,
	0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x85, 0x83, 0x8B, 0x8D, 0x8C, 0x95, 0x8E, 0x91, 0x91, 0x87, 0x8C,
	0x83, 0x7F, 0x80, 0x77, 0x79, 0x77, 0x75, 0x78, 0x77, 0x79, 0x7C, 0x7C,
	0x7E, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x80, 0x7E, 0x81, 0x7E, 0x7F,
	0x81, 0x7E, 0x81, 0x80, 0x80, 0x82, 0x7F, 0x81, 0x81, 0x7F, 0x81, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x81, 0x7F, 0x81, 0x81, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x84, 0x84, 0x87,
	0x8C, 0x89, 0x8F, 0x8E, 0x8C, 0x8F, 0x88, 0x89, 0x87, 0x82, 0x84, 0x7F,
	0x7F, 0x7F, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x83, 0x80, 0x81, 0x82, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x83, 0x83, 0x87, 0x86, 0x87, 0x88,
	0x86, 0x88, 0x86, 0x86, 0x86, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x82, 0x81, 0x81, 0x82,
	0x81, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x83, 0x82, 0x83, 0x83, 0x82,
	0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80
};
const unsigned char WAV8[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x7F, 0x85, 0x86, 0x83, 0x8B, 0x85, 0x85, 0x86, 0x7F,
	0x80, 0x7D, 0x7A, 0x7C, 0x7B, 0x7C, 0x7E, 0x7F, 0x80, 0x82, 0x81, 0x81,
	0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7D, 0x89, 0x9B, 0x8B, 0xA7, 0xA2, 0x90, 0xA2, 0x84, 0x7E,
	0x7F, 0x69, 0x6F, 0x71, 0x6B, 0x79, 0x7D, 0x7D, 0x89, 0x86, 0x84, 0x8A,
	0x7F, 0x7F, 0x80, 0x79, 0x7D, 0x7F, 0x7C, 0x83, 0x82, 0x82, 0x85, 0x81,
	0x82, 0x81, 0x7D, 0x7E, 0x7D, 0x7B, 0x7F, 0x7E, 0x7E, 0x82, 0x80, 0x81,
	0x83, 0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x7D, 0x80, 0x7B, 0x7F, 0x7E,
	0x7B, 0x80, 0x7F, 0xA5, 0x90, 0xA6, 0xBE, 0x91, 0xB2, 0x96, 0x7C, 0x8B,
	0x65, 0x68, 0x6D, 0x5F, 0x71, 0x76, 0x77, 0x87, 0x88, 0x85, 0x8D, 0x86,
	0x7F, 0x84, 0x78, 0x78, 0x7E, 0x75, 0x7E, 0x81, 0x7C, 0x87, 0x83, 0x82,
	0x86, 0x80, 0x7F, 0x80, 0x7B, 0x7E, 0x7D, 0x7C, 0x80, 0x7E, 0x80, 0x82,
	0x80, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7A, 0x80, 0x7A,
	0x7D, 0x7E, 0x9A, 0x97, 0x98, 0xC0, 0x94, 0xA8, 0xA4, 0x77, 0x8E, 0x6E,
	0x63, 0x72, 0x5F, 0x6C, 0x78, 0x74, 0x83, 0x8A, 0x83, 0x8D, 0x8A, 0x7C,
	0x89, 0x7A, 0x79, 0x85, 0x74, 0x83, 0x84, 0x7C, 0x8B, 0x82, 0x82, 0x86,
	0x7D, 0x7D, 0x80, 0x78, 0x7D, 0x7E, 0x79, 0x82, 0x7F, 0x7F, 0x85, 0x7F,
	0x82, 0x83, 0x7E, 0x81, 0x7F, 0x7D, 0x7F, 0x7F, 0x7D, 0x82, 0x7D, 0x82,
	0x7D, 0x96, 0x9E, 0x8B, 0xBF, 0x99, 0x98, 0xB0, 0x73, 0x8B, 0x79, 0x5B,
	0x79, 0x60, 0x68, 0x7C, 0x71, 0x81, 0x8B, 0x82, 0x8B, 0x8D, 0x7C, 0x88,
	0x7F, 0x75, 0x85, 0x74, 0x7A, 0x84, 0x74, 0x87, 0x82, 0x7C, 0x8A, 0x7D,
	0x81, 0x83, 0x7B, 0x80, 0x7F, 0x7C, 0x7F, 0x80, 0x7E, 0x82, 0x80, 0x7F,
	0x84, 0x7D, 0x81, 0x80, 0x7D, 0x81, 0x7E, 0x7E, 0x81, 0x80, 0x81, 0x82,
	0x82, 0xA4, 0x8F, 0xA1, 0xB9, 0x88, 0xAE, 0x91, 0x73, 0x8F, 0x61, 0x68,
	0x75, 0x59, 0x77, 0x78, 0x73, 0x8C, 0x86, 0x83, 0x93, 0x82, 0x82, 0x8A,
	0x75, 0x7F, 0x80, 0x73, 0x84, 0x7E, 0x7C, 0x8B, 0x7E, 0x83, 0x87, 0x7B,
	0x83, 0x7E, 0x79, 0x81, 0x7A, 0x7D, 0x81, 0x7D, 0x81, 0x82, 0x80, 0x82,
	0x81, 0x7E, 0x82, 0x7E, 0x7F, 0x7F, 0x7E, 0x7D, 0x82, 0x7C, 0x83, 0x7D,
	0x8B, 0xA3, 0x85, 0xB7, 0xA1, 0x8D, 0xB6, 0x73, 0x88, 0x82, 0x56, 0x7C,
	0x61, 0x62, 0x80, 0x6B, 0x80, 0x8C, 0x7F, 0x90, 0x8D, 0x80, 0x8C, 0x81,
	0x77, 0x85, 0x74, 0x7B, 0x83, 0x75, 0x87, 0x81, 0x7E, 0x8A, 0x7D, 0x82,
	0x84, 0x7A, 0x81, 0x7E, 0x7A, 0x80, 0x7C, 0x7E, 0x82, 0x7E, 0x81, 0x82,
	0x80, 0x81, 0x81, 0x7D, 0x82, 0x7D, 0x7F, 0x7F, 0x7F, 0x7E, 0x82, 0x7B,
	0x8E, 0x9F, 0x86, 0xBD, 0x9A, 0x9A, 0xB7, 0x74, 0x99, 0x7C, 0x5D, 0x82,
	0x55, 0x68, 0x77, 0x5E, 0x85, 0x7E, 0x7C, 0x96, 0x84, 0x8B, 0x91, 0x7E,
	0x87, 0x82, 0x76, 0x80, 0x78, 0x76, 0x81, 0x77, 0x7F, 0x85, 0x7A, 0x88,
	0x81, 0x7E, 0x88, 0x7B, 0x81, 0x82, 0x79, 0x83, 0x7D, 0x7B, 0x85, 0x7A,
	0x82, 0x81, 0x7C, 0x85, 0x7E, 0x80, 0x83, 0x7B, 0x83, 0x7D, 0x7F, 0x81,
	0x7E, 0xA0, 0x86, 0xA9, 0xAD, 0x90, 0xC0, 0x88, 0x96, 0x93, 0x63, 0x86,
	0x5E, 0x61, 0x73, 0x58, 0x77, 0x74, 0x73, 0x8D, 0x81, 0x8A, 0x93, 0x85,
	0x8E, 0x89, 0x7C, 0x85, 0x7A, 0x76, 0x7F, 0x71, 0x7B, 0x7E, 0x76, 0x86,
	0x7D, 0x81, 0x88, 0x7D, 0x87, 0x82, 0x7E, 0x85, 0x7B, 0x80, 0x7F, 0x7C,
	0x80, 0x7D, 0x7E, 0x81, 0x7E, 0x81, 0x81, 0x7F, 0x82, 0x81, 0x80, 0x84,
	0x80, 0x81, 0x9E, 0x86, 0xA8, 0xAB, 0x92, 0xC0, 0x8A, 0x9D, 0x98, 0x69,
	0x8F, 0x5D, 0x67, 0x72, 0x50, 0x7A, 0x65, 0x71, 0x87, 0x74, 0x90, 0x8A,
	0x86, 0x96, 0x84, 0x89, 0x8A, 0x79, 0x85, 0x7A, 0x76, 0x80, 0x73, 0x7E,
	0x7D, 0x79, 0x85, 0x7C, 0x82, 0x85, 0x7E, 0x86, 0x80, 0x7F, 0x83, 0x7C,
	0x81, 0x7E, 0x7D, 0x81, 0x7C, 0x80, 0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x85,
	0x7E, 0x85, 0x7D, 0x8D, 0x96, 0x8A, 0xB3, 0x93, 0xAD, 0xA9, 0x8D, 0xAC,
	0x7A, 0x8A, 0x7C, 0x62, 0x7A, 0x58, 0x6C, 0x6A, 0x64, 0x7C, 0x70, 0x82,
	0x85, 0x85, 0x90, 0x89, 0x8E, 0x8B, 0x87, 0x86, 0x81, 0x80, 0x7C, 0x7B,
	0x79, 0x7A, 0x7A, 0x7A, 0x7D, 0x7C, 0x80, 0x80, 0x80, 0x83, 0x81, 0x82,
	0x82, 0x80, 0x82, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x80, 0x7E, 0x82,
	0x80, 0x81, 0x83, 0x80, 0x84, 0x7D, 0x95, 0x89, 0x99, 0xA7, 0x91, 0xB5,
	0x92, 0xA0, 0x9A, 0x7C, 0x93, 0x6B, 0x77, 0x6F, 0x5E, 0x74, 0x5F, 0x71,
	0x74, 0x70, 0x86, 0x7C, 0x8A, 0x8D, 0x88, 0x92, 0x89, 0x8A, 0x8A, 0x81,
	0x84, 0x7D, 0x7B, 0x7D, 0x76, 0x7B, 0x79, 0x79, 0x7E, 0x7B, 0x7F, 0x80,
	0x80, 0x83, 0x82, 0x83, 0x83, 0x81, 0x82, 0x80, 0x80, 0x81, 0x7E, 0x81,
	0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7D, 0x8A, 0x8F, 0x8B,
	0xA7, 0x93, 0xA8, 0xA3, 0x94, 0xA6, 0x83, 0x90, 0x7E, 0x71, 0x79, 0x62,
	0x6F, 0x68, 0x68, 0x74, 0x6E, 0x7C, 0x7E, 0x82, 0x8A, 0x88, 0x8D, 0x8C,
	0x8A, 0x8A, 0x86, 0x84, 0x81, 0x7D, 0x7D, 0x7A, 0x79, 0x7A, 0x79, 0x7B,
	0x7C, 0x7D, 0x80, 0x7F, 0x82, 0x81, 0x82, 0x82, 0x82, 0x83, 0x81, 0x82,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7D, 0x81,
	0x7B, 0x8D, 0x89, 0x90, 0xA2, 0x90, 0xAB, 0x99, 0x99, 0x9F, 0x84, 0x91,
	0x7C, 0x76, 0x78, 0x65, 0x6F, 0x67, 0x68, 0x71, 0x6C, 0x78, 0x7B, 0x7D,
	0x86, 0x86, 0x89, 0x8D, 0x88, 0x8B, 0x89, 0x84, 0x86, 0x7F, 0x7F, 0x7E,
	0x7A, 0x7C, 0x7A, 0x7A, 0x7C, 0x7B, 0x7E, 0x7E, 0x7F, 0x82, 0x80, 0x83,
	0x84, 0x82, 0x85, 0x81, 0x83, 0x82, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7D, 0x7F, 0x7C, 0x80, 0x7D, 0x87, 0x8C, 0x89, 0x9E, 0x91, 0x9E, 0x9E,
	0x91, 0x9C, 0x89, 0x8A, 0x84, 0x78, 0x79, 0x72, 0x6F, 0x70, 0x71, 0x71,
	0x77, 0x77, 0x7B, 0x81, 0x7F, 0x86, 0x85, 0x85, 0x88, 0x84, 0x85, 0x83,
	0x81, 0x81, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x89, 0x85,
	0x8C, 0x93, 0x8C, 0x97, 0x91, 0x8F, 0x91, 0x88, 0x86, 0x82, 0x7C, 0x79,
	0x77, 0x74, 0x74, 0x76, 0x74, 0x78, 0x7A, 0x7A, 0x7F, 0x7F, 0x82, 0x84,
	0x83, 0x84, 0x84, 0x83, 0x83, 0x82, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E,
	0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x81, 0x81, 0x83, 0x84, 0x84, 0x85,
	0x86, 0x86, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x81, 0x82, 0x84, 0x84,
	0x85, 0x87, 0x86, 0x86, 0x88, 0x85, 0x86, 0x86, 0x84, 0x84, 0x83, 0x82,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7D,
	0x7C, 0x7B, 0x7A, 0x7A, 0x79, 0x79, 0x79, 0x79, 0x79, 0x7A, 0x7A, 0x7A,
	0x7B, 0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7B,
	0x7B, 0x7B, 0x7A, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81,
	0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x82, 0x80, 0x80, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7E, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAV80[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x7F, 0x82, 0x86, 0x82, 0x8B, 0x86, 0x86, 0x87, 0x7F, 0x81, 0x7D, 0x7A,
	0x7C, 0x7A, 0x7B, 0x7E, 0x7E, 0x80, 0x82, 0x80, 0x83, 0x81, 0x80, 0x81,
	0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81,
	0x7C, 0x95, 0x8D, 0x95, 0xA9, 0x8C, 0xA3, 0x8C, 0x7F, 0x85, 0x6A, 0x70,
	0x6D, 0x68, 0x73, 0x78, 0x78, 0x89, 0x85, 0x88, 0x8F, 0x81, 0x89, 0x81,
	0x7A, 0x81, 0x76, 0x7B, 0x7D, 0x78, 0x82, 0x7F, 0x80, 0x85, 0x80, 0x83,
	0x82, 0x7E, 0x80, 0x7F, 0x7C, 0x80, 0x7C, 0x7F, 0x81, 0x7D, 0x83, 0x7F,
	0x80, 0x82, 0x7F, 0x80, 0x81, 0x7D, 0x81, 0x7E, 0x80, 0x80, 0x7F, 0x80,
	0x84, 0x9C, 0x89, 0xAB, 0xA0, 0x96, 0xAB, 0x7F, 0x8F, 0x79, 0x69, 0x74,
	0x61, 0x6A, 0x71, 0x6F, 0x7D, 0x84, 0x81, 0x90, 0x89, 0x88, 0x8E, 0x7D,
	0x86, 0x7D, 0x77, 0x81, 0x74, 0x7D, 0x7E, 0x7B, 0x83, 0x80, 0x81, 0x85,
	0x7F, 0x82, 0x82, 0x7C, 0x82, 0x7D, 0x7D, 0x81, 0x7B, 0x82, 0x7E, 0x7F,
	0x82, 0x7F, 0x81, 0x81, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x82, 0x7C, 0x8F,
	0x99, 0x8D, 0xB6, 0x98, 0xA5, 0xAA, 0x80, 0x9C, 0x71, 0x73, 0x73, 0x5A,
	0x6F, 0x66, 0x6B, 0x7D, 0x78, 0x85, 0x8E, 0x85, 0x93, 0x8B, 0x84, 0x8D,
	0x7A, 0x81, 0x7D, 0x73, 0x80, 0x74, 0x7C, 0x7F, 0x7A, 0x85, 0x80, 0x81,
	0x86, 0x7F, 0x83, 0x82, 0x7D, 0x82, 0x7C, 0x7E, 0x80, 0x7C, 0x80, 0x7F,
	0x7D, 0x83, 0x7D, 0x82, 0x80, 0x80, 0x80, 0x81, 0x7C, 0x88, 0x9A, 0x87,
	0xB5, 0x9A, 0xA6, 0xB2, 0x87, 0xA7, 0x7A, 0x7B, 0x79, 0x5B, 0x6F, 0x5F,
	0x63, 0x72, 0x6B, 0x7D, 0x83, 0x81, 0x92, 0x8B, 0x8B, 0x93, 0x81, 0x8C,
	0x7F, 0x7A, 0x81, 0x6F, 0x7D, 0x75, 0x76, 0x7F, 0x78, 0x82, 0x81, 0x80,
	0x87, 0x81, 0x84, 0x84, 0x7F, 0x82, 0x7F, 0x7D, 0x81, 0x7B, 0x80, 0x7E,
	0x7D, 0x81, 0x7D, 0x82, 0x7E, 0x82, 0x7C, 0x9B, 0x87, 0xA4, 0xAA, 0x95,
	0xC0, 0x8C, 0xA9, 0x90, 0x7A, 0x8B, 0x5F, 0x73, 0x61, 0x5E, 0x6B, 0x63,
	0x71, 0x78, 0x7A, 0x87, 0x8A, 0x89, 0x94, 0x88, 0x8E, 0x8B, 0x80, 0x89,
	0x79, 0x7F, 0x7D, 0x75, 0x80, 0x76, 0x7D, 0x7F, 0x7A, 0x83, 0x7E, 0x80,
	0x84, 0x7D, 0x84, 0x80, 0x7E, 0x84, 0x7B, 0x82, 0x7E, 0x7E, 0x82, 0x7C,
	0x82, 0x7E, 0x81, 0x7E, 0x97, 0x89, 0xA2, 0xAA, 0x98, 0xC1, 0x91, 0xAF,
	0x96, 0x82, 0x93, 0x61, 0x7B, 0x5F, 0x5F, 0x6A, 0x58, 0x71, 0x6A, 0x75,
	0x81, 0x7F, 0x8B, 0x8D, 0x8C, 0x92, 0x8C, 0x8B, 0x8B, 0x80, 0x85, 0x7C,
	0x7B, 0x7D, 0x75, 0x7C, 0x78, 0x7A, 0x7E, 0x7B, 0x81, 0x7F, 0x81, 0x82,
	0x81, 0x82, 0x83, 0x7F, 0x84, 0x7E, 0x81, 0x80, 0x7E, 0x80, 0x7E, 0x7E,
	0x84, 0x92, 0x88, 0xAA, 0x98, 0xA9, 0xAC, 0x96, 0xAE, 0x84, 0x94, 0x7D,
	0x71, 0x77, 0x5D, 0x6C, 0x60, 0x65, 0x6C, 0x6B, 0x77, 0x7C, 0x81, 0x89,
	0x8A, 0x8D, 0x91, 0x8B, 0x8F, 0x89, 0x85, 0x87, 0x7B, 0x81, 0x78, 0x7A,
	0x7C, 0x75, 0x81, 0x78, 0x81, 0x80, 0x7F, 0x86, 0x7F, 0x86, 0x81, 0x83,
	0x82, 0x80, 0x80, 0x80, 0x7D, 0x80, 0x7C, 0x7F, 0x7C, 0x82, 0x92, 0x86,
	0xA7, 0x95, 0xA8, 0xA9, 0x99, 0xAC, 0x89, 0x98, 0x80, 0x79, 0x78, 0x65,
	0x6D, 0x62, 0x66, 0x6A, 0x6A, 0x73, 0x77, 0x7C, 0x85, 0x85, 0x8C, 0x8D,
	0x8C, 0x90, 0x89, 0x8B, 0x86, 0x82, 0x83, 0x7B, 0x7D, 0x7A, 0x78, 0x7B,
	0x78, 0x7C, 0x7C, 0x7D, 0x80, 0x81, 0x82, 0x84, 0x82, 0x85, 0x82, 0x83,
	0x82, 0x80, 0x81, 0x7F, 0x7E, 0x80, 0x7B, 0x81, 0x8D, 0x85, 0xA0, 0x93,
	0xA2, 0xA6, 0x98, 0xAB, 0x8E, 0x99, 0x87, 0x7E, 0x7D, 0x6B, 0x6F, 0x66,
	0x65, 0x69, 0x66, 0x6F, 0x73, 0x76, 0x80, 0x80, 0x89, 0x8A, 0x8B, 0x8F,
	0x8A, 0x8D, 0x89, 0x86, 0x85, 0x7F, 0x80, 0x7C, 0x7A, 0x7A, 0x79, 0x79,
	0x7B, 0x79, 0x7E, 0x7D, 0x80, 0x81, 0x81, 0x84, 0x81, 0x85, 0x82, 0x82,
	0x82, 0x80, 0x81, 0x80, 0x7E, 0x80, 0x7C, 0x8C, 0x83, 0x94, 0x98, 0x95,
	0xA8, 0x95, 0xA7, 0x96, 0x95, 0x93, 0x82, 0x85, 0x75, 0x74, 0x6F, 0x69,
	0x6B, 0x6A, 0x6B, 0x71, 0x71, 0x79, 0x7C, 0x7F, 0x86, 0x84, 0x8A, 0x89,
	0x89, 0x8B, 0x87, 0x88, 0x85, 0x82, 0x82, 0x7E, 0x7E, 0x7C, 0x7A, 0x7C,
	0x7A, 0x7C, 0x7D, 0x7C, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x82, 0x80, 0x82,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x8A, 0x84, 0x96, 0x92,
	0x99, 0xA0, 0x96, 0xA3, 0x92, 0x97, 0x8E, 0x85, 0x84, 0x78, 0x78, 0x72,
	0x6F, 0x6F, 0x6F, 0x6E, 0x74, 0x72, 0x7A, 0x7B, 0x7D, 0x83, 0x81, 0x87,
	0x85, 0x87, 0x86, 0x85, 0x85, 0x83, 0x83, 0x81, 0x81, 0x7F, 0x7F, 0x7D,
	0x7E, 0x7D, 0x7C, 0x7D, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x88, 0x86,
	0x8D, 0x93, 0x91, 0x9B, 0x95, 0x99, 0x95, 0x91, 0x8F, 0x88, 0x84, 0x7E,
	0x7A, 0x75, 0x75, 0x71, 0x73, 0x72, 0x74, 0x77, 0x78, 0x7C, 0x7D, 0x80,
	0x81, 0x83, 0x84, 0x84, 0x84, 0x83, 0x84, 0x82, 0x82, 0x81, 0x80, 0x80,
	0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x86, 0x85, 0x8A, 0x8E, 0x8D, 0x91, 0x90, 0x90, 0x8F, 0x8D,
	0x8A, 0x87, 0x84, 0x81, 0x7F, 0x7C, 0x7B, 0x7A, 0x79, 0x79, 0x79, 0x7A,
	0x7A, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x82, 0x82, 0x83, 0x85, 0x85,
	0x86, 0x87, 0x86, 0x86, 0x86, 0x85, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E,
	0x80, 0x84, 0x82, 0x85, 0x86, 0x85, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81,
	0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x86, 0x84, 0x86, 0x89,
	0x87, 0x87, 0x87, 0x86, 0x84, 0x84, 0x83, 0x80, 0x80, 0x7F, 0x7D, 0x7D,
	0x7D, 0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7E, 0x86, 0x8B, 0x87, 0x90, 0x91, 0x8C, 0x8F, 0x8D, 0x88,
	0x86, 0x85, 0x81, 0x7D, 0x7F, 0x7C, 0x7A, 0x7D, 0x7D, 0x7C, 0x7F, 0x81,
	0x80, 0x81, 0x83, 0x82, 0x81, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7D, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x83,
	0x96, 0x8C, 0x95, 0xA6, 0x94, 0x9B, 0x9C, 0x8C, 0x87, 0x83, 0x7B, 0x6F,
	0x72, 0x72, 0x69, 0x74, 0x78, 0x76, 0x7F, 0x84, 0x84, 0x85, 0x8B, 0x87,
	0x83, 0x87, 0x81, 0x7D, 0x80, 0x7C, 0x7B, 0x7C, 0x7E, 0x7D, 0x7E, 0x82,
	0x80, 0x81, 0x84, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7D, 0x7F,
	0x7F, 0x7D, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x81, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x7C, 0x8B, 0x99, 0x88,
	0xA7, 0xA5, 0x95, 0xA8, 0x98, 0x8C, 0x89, 0x81, 0x73, 0x6D, 0x74, 0x65,
	0x6B, 0x76, 0x6E, 0x7A, 0x81, 0x81, 0x84, 0x8A, 0x88, 0x82, 0x89, 0x82,
	0x7D, 0x82, 0x7C, 0x7A, 0x7D, 0x7D, 0x7B, 0x7E, 0x81, 0x7E, 0x82, 0x83,
	0x7F, 0x83, 0x82, 0x7F, 0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x80,
	0x7F, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x81, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x9B, 0x90, 0x95, 0xB5,
	0x96, 0xA4, 0xA6, 0x8C, 0x8C, 0x83, 0x77, 0x6A, 0x71, 0x68, 0x63, 0x76,
	0x6D, 0x76, 0x82, 0x7F, 0x87, 0x8A, 0x8A, 0x87, 0x89, 0x86, 0x7F, 0x83,
	0x7C, 0x7B, 0x7E, 0x7A, 0x7C, 0x7D, 0x7F, 0x7F, 0x80, 0x83, 0x7F, 0x83,
	0x81, 0x7F, 0x82, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7E, 0x82, 0x7D, 0x88, 0x99, 0x84, 0xA6, 0xA3,
	0x8F, 0xAC, 0x92, 0x89, 0x8E, 0x79, 0x72, 0x72, 0x6D, 0x64, 0x70, 0x70,
	0x6D, 0x81, 0x7B, 0x81, 0x8C, 0x84, 0x8A, 0x8A, 0x85, 0x84, 0x83, 0x80,
	0x7D, 0x80, 0x7B, 0x7D, 0x80, 0x7C, 0x82, 0x80, 0x7F, 0x82, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x7E, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x85, 0x97, 0x86, 0xA1,
	0xA5, 0x8E, 0xAD, 0x94, 0x89, 0x94, 0x78, 0x76, 0x75, 0x68, 0x69, 0x6D,
	0x6B, 0x6E, 0x7B, 0x77, 0x80, 0x89, 0x82, 0x8C, 0x8A, 0x85, 0x8B, 0x83,
	0x81, 0x82, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7E, 0x7D, 0x7E, 0x81, 0x7E,
	0x81, 0x81, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7D, 0x7D, 0x7E, 0x7C,
	0x7E, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x83, 0x80, 0x81, 0x82, 0x80, 0x80,
	0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x98,
	0x88, 0x96, 0xAC, 0x8B, 0xA9, 0x9E, 0x87, 0x9B, 0x7F, 0x77, 0x7D, 0x69,
	0x6B, 0x6F, 0x68, 0x6D, 0x77, 0x75, 0x7C, 0x87, 0x81, 0x8A, 0x8D, 0x85,
	0x8C, 0x88, 0x82, 0x85, 0x7F, 0x7C, 0x7E, 0x7A, 0x7A, 0x7C, 0x7B, 0x7C,
	0x80, 0x7E, 0x80, 0x82, 0x7F, 0x82, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x7F,
	0x81, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x81, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7D, 0x83, 0x91, 0x84, 0x9D, 0x9D, 0x8F, 0xAB, 0x92, 0x91, 0x99,
	0x7C, 0x82, 0x7B, 0x6C, 0x72, 0x6D, 0x69, 0x70, 0x72, 0x71, 0x7C, 0x7E,
	0x7D, 0x89, 0x84, 0x86, 0x8B, 0x84, 0x86, 0x87, 0x80, 0x82, 0x81, 0x7D,
	0x7F, 0x7E, 0x7B, 0x7F, 0x7D, 0x7D, 0x80, 0x7E, 0x7F, 0x81, 0x7E, 0x80,
	0x84, 0x7F, 0x84, 0x86, 0x81, 0x88, 0x83, 0x82, 0x86, 0x7F, 0x81, 0x81,
	0x7C, 0x7F, 0x7C, 0x7B, 0x7D, 0x7D, 0x7C, 0x7E, 0x7E, 0x7E, 0x81, 0x7F,
	0x80, 0x82, 0x7F, 0x82, 0x80, 0x81, 0x80, 0x84, 0x8E, 0x84, 0x99, 0x95,
	0x90, 0xA5, 0x8D, 0x95, 0x95, 0x7E, 0x8A, 0x7A, 0x72, 0x79, 0x6B, 0x6E,
	0x72, 0x6E, 0x74, 0x79, 0x79, 0x7F, 0x83, 0x81, 0x86, 0x86, 0x83, 0x87,
	0x83, 0x82, 0x83, 0x7E, 0x80, 0x80, 0x7D, 0x7F, 0x7F, 0x7E, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x81,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7E, 0x87, 0x86, 0x89, 0x97, 0x8B, 0x98, 0x98, 0x8D, 0x99, 0x89, 0x86,
	0x87, 0x77, 0x7B, 0x75, 0x6E, 0x74, 0x6F, 0x71, 0x77, 0x75, 0x7A, 0x7F,
	0x7D, 0x82, 0x83, 0x80, 0x85, 0x82, 0x81, 0x84, 0x7F, 0x81, 0x82, 0x7F,
	0x82, 0x81, 0x80, 0x83, 0x81, 0x82, 0x82, 0x7F, 0x80, 0x7F, 0x7D, 0x7E,
	0x7C, 0x7C, 0x7D, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x81, 0x80,
	0x81, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x83, 0x84, 0x86, 0x8D, 0x8A,
	0x90, 0x90, 0x8D, 0x91, 0x89, 0x89, 0x87, 0x7F, 0x81, 0x7B, 0x7A, 0x7B,
	0x77, 0x7A, 0x7A, 0x7A, 0x7D, 0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x81, 0x7F,
	0x80, 0x81, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7D, 0x7F, 0x80, 0x7E, 0x80,
	0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x83, 0x84, 0x85, 0x8B, 0x88, 0x8C, 0x8C, 0x8A, 0x8C, 0x88, 0x88,
	0x87, 0x83, 0x84, 0x81, 0x80, 0x80, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x83, 0x81, 0x81, 0x82, 0x80, 0x82, 0x80, 0x80,
	0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x82, 0x83, 0x86, 0x85,
	0x86, 0x86, 0x85, 0x87, 0x85, 0x85, 0x85, 0x84, 0x84, 0x83, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x82, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F
};
const unsigned char WAV9[] = {
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83,
	0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x83, 0x87, 0x8A, 0x8C, 0x8C, 0x8C, 0x8B, 0x8B, 0x8A, 0x89, 0x87, 0x84,
	0x82, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7B, 0x7B, 0x7C, 0x7D, 0x7F, 0x80,
	0x82, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F,
	0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7F, 0x80, 0x81, 0x83, 0x83,
	0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x88, 0x92, 0x98,
	0x9F, 0x9E, 0x9A, 0x99, 0x96, 0x95, 0x92, 0x8E, 0x87, 0x7F, 0x7A, 0x76,
	0x76, 0x76, 0x76, 0x76, 0x76, 0x79, 0x7D, 0x81, 0x86, 0x89, 0x8B, 0x8B,
	0x8B, 0x8B, 0x8B, 0x8A, 0x87, 0x84, 0x80, 0x7D, 0x7B, 0x7A, 0x79, 0x78,
	0x78, 0x78, 0x79, 0x7B, 0x7D, 0x80, 0x82, 0x83, 0x85, 0x85, 0x86, 0x86,
	0x86, 0x85, 0x83, 0x82, 0x80, 0x7E, 0x7D, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B,
	0x7C, 0x7E, 0x80, 0x81, 0x83, 0x83, 0x85, 0x91, 0x9A, 0x9F, 0xA4, 0xA1,
	0x9E, 0x9C, 0x99, 0x98, 0x94, 0x8E, 0x85, 0x7E, 0x79, 0x75, 0x76, 0x76,
	0x76, 0x76, 0x77, 0x7B, 0x7E, 0x84, 0x88, 0x8C, 0x8E, 0x8E, 0x8F, 0x8F,
	0x8E, 0x8D, 0x8A, 0x86, 0x82, 0x7E, 0x7C, 0x7A, 0x79, 0x77, 0x77, 0x77,
	0x78, 0x7B, 0x7D, 0x80, 0x82, 0x84, 0x86, 0x87, 0x88, 0x88, 0x88, 0x86,
	0x85, 0x83, 0x80, 0x7E, 0x7C, 0x7B, 0x7A, 0x79, 0x79, 0x79, 0x7A, 0x7B,
	0x7D, 0x7F, 0x80, 0x82, 0x82, 0x89, 0x97, 0x9B, 0xA2, 0xA3, 0x9F, 0x9E,
	0x9A, 0x9A, 0x97, 0x92, 0x8C, 0x82, 0x7C, 0x78, 0x77, 0x78, 0x78, 0x79,
	0x78, 0x7A, 0x7D, 0x82, 0x88, 0x8B, 0x8E, 0x8E, 0x8D, 0x8E, 0x8D, 0x8D,
	0x8A, 0x88, 0x83, 0x7F, 0x7D, 0x7A, 0x7A, 0x79, 0x78, 0x79, 0x78, 0x7A,
	0x7C, 0x80, 0x84, 0x86, 0x88, 0x88, 0x89, 0x8A, 0x89, 0x8A, 0x87, 0x85,
	0x82, 0x80, 0x7E, 0x7C, 0x7C, 0x7B, 0x7A, 0x7A, 0x7A, 0x7B, 0x7D, 0x7F,
	0x80, 0x82, 0x83, 0x84, 0x94, 0x9E, 0xA2, 0xA7, 0xA3, 0xA3, 0x9F, 0x9F,
	0x9F, 0x98, 0x92, 0x87, 0x80, 0x7B, 0x78, 0x79, 0x76, 0x75, 0x74, 0x75,
	0x7A, 0x7E, 0x84, 0x87, 0x8A, 0x8B, 0x8C, 0x8E, 0x8F, 0x8F, 0x8D, 0x89,
	0x86, 0x81, 0x7F, 0x7C, 0x7A, 0x78, 0x76, 0x76, 0x76, 0x77, 0x79, 0x7B,
	0x7D, 0x7F, 0x81, 0x82, 0x84, 0x85, 0x85, 0x86, 0x85, 0x84, 0x83, 0x82,
	0x81, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7B, 0x7C, 0x7D, 0x7E,
	0x7E, 0x80, 0x96, 0xA3, 0xA8, 0xAB, 0xA9, 0xAA, 0xA2, 0x9F, 0x98, 0x91,
	0x89, 0x7F, 0x7B, 0x74, 0x72, 0x6F, 0x6F, 0x70, 0x70, 0x75, 0x77, 0x7B,
	0x7E, 0x82, 0x86, 0x87, 0x89, 0x88, 0x89, 0x87, 0x86, 0x84, 0x82, 0x81,
	0x7F, 0x7E, 0x7C, 0x7C, 0x7C, 0x7B, 0x7C, 0x7C, 0x7D, 0x7D, 0x7F, 0x7F,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x83, 0x84, 0x83, 0x83, 0x82,
	0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x7D, 0x7F, 0x7E, 0x80, 0x7D, 0x89,
	0xAA, 0xB1, 0xB3, 0xAC, 0xAF, 0xA4, 0x8D, 0x7F, 0x76, 0x75, 0x69, 0x69,
	0x6C, 0x77, 0x7A, 0x7B, 0x82, 0x86, 0x88, 0x81, 0x82, 0x81, 0x81, 0x7C,
	0x7B, 0x7F, 0x7F, 0x80, 0x7E, 0x82, 0x82, 0x81, 0x7F, 0x7F, 0x81, 0x7F,
	0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7D, 0x7A, 0x7B, 0x7C, 0x7E,
	0x7C, 0x7F, 0x81, 0x82, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x7D, 0x7F, 0x7F,
	0x80, 0x7E, 0x81, 0x80, 0x81, 0x7F, 0x81, 0x7D, 0x8D, 0xB8, 0xC0, 0xBA,
	0xA8, 0xAA, 0x95, 0x76, 0x64, 0x67, 0x76, 0x72, 0x7C, 0x8A, 0x9D, 0x94,
	0x8A, 0x85, 0x84, 0x7B, 0x6C, 0x71, 0x79, 0x81, 0x7E, 0x83, 0x8C, 0x8C,
	0x84, 0x7D, 0x7F, 0x7D, 0x79, 0x76, 0x7D, 0x85, 0x85, 0x83, 0x83, 0x87,
	0x81, 0x7D, 0x79, 0x7E, 0x7E, 0x7C, 0x7E, 0x82, 0x85, 0x81, 0x80, 0x80,
	0x82, 0x7C, 0x7D, 0x7D, 0x81, 0x7F, 0x7F, 0x80, 0x82, 0x81, 0x7E, 0x7F,
	0x80, 0x7E, 0x78, 0x7D, 0x7A, 0xA8, 0xCB, 0xC6, 0xA8, 0x90, 0x8D, 0x72,
	0x5E, 0x59, 0x7A, 0x8A, 0x8F, 0x8F, 0x9B, 0x9D, 0x85, 0x74, 0x6E, 0x79,
	0x72, 0x74, 0x7D, 0x8F, 0x90, 0x87, 0x83, 0x86, 0x85, 0x77, 0x74, 0x7A,
	0x84, 0x80, 0x80, 0x83, 0x89, 0x84, 0x7C, 0x7B, 0x7F, 0x80, 0x7B, 0x7D,
	0x82, 0x86, 0x81, 0x7F, 0x80, 0x82, 0x7F, 0x7B, 0x7E, 0x80, 0x82, 0x7E,
	0x80, 0x80, 0x81, 0x7D, 0x7D, 0x7F, 0x7F, 0x80, 0x7D, 0x82, 0x7F, 0x84,
	0x79, 0x98, 0xCA, 0xCE, 0xAC, 0x81, 0x81, 0x78, 0x69, 0x5B, 0x78, 0x98,
	0xA1, 0x92, 0x8C, 0x92, 0x85, 0x71, 0x63, 0x76, 0x83, 0x89, 0x82, 0x8A,
	0x8F, 0x8A, 0x79, 0x72, 0x78, 0x7E, 0x7D, 0x7C, 0x85, 0x8A, 0x89, 0x7D,
	0x7C, 0x7C, 0x7F, 0x7A, 0x7B, 0x81, 0x86, 0x84, 0x80, 0x7F, 0x80, 0x7F,
	0x7B, 0x7B, 0x7E, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7E, 0x7D, 0x7E,
	0x80, 0x80, 0x7F, 0x81, 0x80, 0x82, 0x7D, 0x81, 0x79, 0xA1, 0xD0, 0xD4,
	0xA8, 0x78, 0x76, 0x73, 0x6D, 0x5F, 0x7C, 0x99, 0xA8, 0x92, 0x81, 0x7D,
	0x7C, 0x72, 0x67, 0x75, 0x86, 0x95, 0x8A, 0x86, 0x80, 0x83, 0x78, 0x72,
	0x74, 0x80, 0x89, 0x86, 0x84, 0x82, 0x85, 0x7C, 0x79, 0x77, 0x7E, 0x82,
	0x83, 0x7F, 0x80, 0x81, 0x80, 0x7D, 0x7B, 0x7E, 0x81, 0x82, 0x80, 0x80,
	0x81, 0x80, 0x7F, 0x7D, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x81, 0x7F,
	0x7E, 0x7F, 0x7E, 0x82, 0x7B, 0xAA, 0xD5, 0xD7, 0x9C, 0x67, 0x63, 0x6F,
	0x77, 0x6C, 0x83, 0x9D, 0xB2, 0x96, 0x78, 0x68, 0x71, 0x77, 0x73, 0x7A,
	0x89, 0x9B, 0x92, 0x83, 0x72, 0x76, 0x77, 0x7A, 0x78, 0x82, 0x8B, 0x8E,
	0x84, 0x75, 0x72, 0x75, 0x7D, 0x7E, 0x81, 0x84, 0x89, 0x85, 0x7E, 0x78,
	0x78, 0x7D, 0x7F, 0x81, 0x81, 0x84, 0x84, 0x81, 0x7C, 0x7A, 0x7D, 0x7F,
	0x81, 0x80, 0x82, 0x82, 0x81, 0x7E, 0x7D, 0x7A, 0x78, 0x7B, 0x7E, 0x86,
	0x7E, 0x9C, 0xCF, 0xE2, 0xB4, 0x6B, 0x51, 0x61, 0x7D, 0x7C, 0x81, 0x93,
	0xAC, 0xA4, 0x82, 0x61, 0x5F, 0x73, 0x80, 0x85, 0x85, 0x91, 0x94, 0x8B,
	0x74, 0x6C, 0x73, 0x82, 0x86, 0x84, 0x84, 0x87, 0x88, 0x7E, 0x76, 0x74,
	0x7D, 0x83, 0x86, 0x82, 0x82, 0x82, 0x82, 0x7C, 0x7A, 0x7A, 0x81, 0x83,
	0x83, 0x81, 0x80, 0x80, 0x7E, 0x7D, 0x7C, 0x81, 0x84, 0x87, 0x80, 0x80,
	0x7C, 0x80, 0x7D, 0x80, 0x7D, 0x82, 0x81, 0x84, 0x7C, 0x89, 0xC4, 0xE2,
	0xCB, 0x7A, 0x53, 0x55, 0x7A, 0x81, 0x82, 0x8B, 0xA4, 0xAC, 0x8F, 0x6B,
	0x59, 0x68, 0x73, 0x7F, 0x81, 0x92, 0x96, 0x94, 0x7B, 0x6D, 0x6A, 0x76,
	0x7F, 0x83, 0x87, 0x89, 0x8D, 0x82, 0x7A, 0x71, 0x78, 0x7C, 0x84, 0x82,
	0x86, 0x84, 0x84, 0x7E, 0x79, 0x79, 0x7B, 0x89, 0x8E, 0x8F, 0x82, 0x7E,
	0x79, 0x7D, 0x7A, 0x7E, 0x7F, 0x86, 0x88, 0x84, 0x7F, 0x7B, 0x7D, 0x7C,
	0x80, 0x7D, 0x83, 0x81, 0x87, 0x7A, 0xA0, 0xD0, 0xDF, 0xAB, 0x64, 0x51,
	0x64, 0x83, 0x7E, 0x85, 0x92, 0xAF, 0xA1, 0x83, 0x61, 0x65, 0x76, 0x82,
	0x82, 0x83, 0x91, 0x94, 0x8C, 0x74, 0x6E, 0x70, 0x80, 0x81, 0x84, 0x83,
	0x8B, 0x88, 0x80, 0x76, 0x75, 0x7B, 0x81, 0x84, 0x83, 0x86, 0x84, 0x82,
	0x7B, 0x7A, 0x7A, 0x80, 0x81, 0x83, 0x82, 0x83, 0x81, 0x7F, 0x7C, 0x7C,
	0x7E, 0x80, 0x81, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x7D, 0x7F, 0x7E, 0x82,
	0x7F, 0x82, 0x7A, 0x8B, 0xC2, 0xDE, 0xC3, 0x77, 0x57, 0x5E, 0x7D, 0x7D,
	0x7D, 0x8C, 0xA8, 0xAB, 0x8B, 0x6C, 0x62, 0x75, 0x7D, 0x81, 0x7E, 0x8F,
	0x95, 0x91, 0x7A, 0x6F, 0x71, 0x7C, 0x80, 0x80, 0x85, 0x8B, 0x8C, 0x81,
	0x78, 0x75, 0x7B, 0x7F, 0x81, 0x81, 0x85, 0x86, 0x84, 0x7D, 0x7A, 0x7B,
	0x7F, 0x80, 0x80, 0x82, 0x82, 0x83, 0x7F, 0x7D, 0x7C, 0x7E, 0x80, 0x80,
	0x81, 0x82, 0x81, 0x7F, 0x7D, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80,
	0x82, 0x7A, 0xA6, 0xD3, 0xD6, 0x9A, 0x5F, 0x5A, 0x71, 0x83, 0x78, 0x84,
	0x99, 0xB1, 0x98, 0x78, 0x62, 0x6F, 0x7B, 0x7C, 0x7A, 0x84, 0x97, 0x94,
	0x85, 0x6F, 0x73, 0x78, 0x81, 0x7B, 0x81, 0x87, 0x8E, 0x85, 0x7A, 0x76,
	0x79, 0x80, 0x7E, 0x80, 0x81, 0x88, 0x84, 0x80, 0x79, 0x7C, 0x7E, 0x80,
	0x7F, 0x7C, 0x7E, 0x7E, 0x82, 0x7F, 0x7F, 0x7D, 0x80, 0x7F, 0x7F, 0x7E,
	0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x7D, 0x81, 0x7E, 0x83,
	0x7A, 0x98, 0xCB, 0xD7, 0xA8, 0x65, 0x5B, 0x6D, 0x83, 0x79, 0x82, 0x99,
	0xAF, 0x9C, 0x77, 0x65, 0x6E, 0x7E, 0x7B, 0x7E, 0x87, 0x99, 0x92, 0x80,
	0x70, 0x73, 0x7B, 0x7E, 0x7E, 0x82, 0x8B, 0x8B, 0x83, 0x77, 0x77, 0x7B,
	0x7F, 0x7E, 0x81, 0x86, 0x87, 0x82, 0x7C, 0x7B, 0x7C, 0x7F, 0x7E, 0x80,
	0x83, 0x84, 0x82, 0x7E, 0x7D, 0x7D, 0x7F, 0x7E, 0x80, 0x81, 0x82, 0x81,
	0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x80, 0x7F, 0x83, 0x80, 0x82, 0x7D, 0x80,
	0x7D, 0x85, 0xBD, 0xD2, 0xB8, 0x76, 0x65, 0x73, 0x7C, 0x71, 0x72, 0x98,
	0xAA, 0xA1, 0x7A, 0x73, 0x77, 0x7B, 0x70, 0x73, 0x88, 0x98, 0x92, 0x7F,
	0x7B, 0x74, 0x72, 0x6C, 0x78, 0x85, 0x8E, 0x8A, 0x83, 0x81, 0x7D, 0x78,
	0x72, 0x7A, 0x80, 0x87, 0x84, 0x84, 0x82, 0x80, 0x7C, 0x77, 0x7D, 0x7E,
	0x84, 0x80, 0x84, 0x82, 0x81, 0x7D, 0x7B, 0x7C, 0x7A, 0x7E, 0x7F, 0x84,
	0x81, 0x82, 0x7F, 0x7E, 0x7E, 0x7C, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x82,
	0x7D, 0x82, 0x78, 0xA1, 0xD1, 0xC4, 0x95, 0x69, 0x7C, 0x75, 0x6D, 0x64,
	0x8D, 0xA8, 0x9B, 0x86, 0x7E, 0x8B, 0x73, 0x69, 0x6A, 0x8A, 0x8E, 0x87,
	0x84, 0x8A, 0x8A, 0x74, 0x71, 0x76, 0x86, 0x80, 0x7F, 0x85, 0x8B, 0x85,
	0x77, 0x7A, 0x7C, 0x81, 0x79, 0x7F, 0x85, 0x84, 0x80, 0x7B, 0x82, 0x7E,
	0x7E, 0x7A, 0x82, 0x82, 0x80, 0x7F, 0x80, 0x82, 0x7D, 0x7D, 0x7D, 0x82,
	0x7F, 0x7F, 0x80, 0x81, 0x81, 0x7C, 0x7F, 0x7F, 0x80, 0x7E, 0x7E, 0x82,
	0x7F, 0x81, 0x7D, 0x85, 0x7A, 0xAC, 0xD2, 0xB2, 0x8F, 0x78, 0x88, 0x67,
	0x5D, 0x71, 0x98, 0x9E, 0x88, 0x92, 0x91, 0x86, 0x63, 0x6A, 0x7E, 0x83,
	0x7D, 0x83, 0x97, 0x8D, 0x7D, 0x73, 0x7F, 0x7F, 0x75, 0x7B, 0x89, 0x8D,
	0x7F, 0x7E, 0x84, 0x81, 0x76, 0x77, 0x83, 0x83, 0x7F, 0x7E, 0x87, 0x84,
	0x7B, 0x7A, 0x80, 0x81, 0x7A, 0x7E, 0x84, 0x84, 0x7E, 0x7E, 0x82, 0x80,
	0x7B, 0x79, 0x80, 0x80, 0x7D, 0x80, 0x83, 0x83, 0x7C, 0x7F, 0x80, 0x7F,
	0x7B, 0x7F, 0x82, 0x80, 0x7E, 0x81, 0x81, 0x84, 0xC4, 0xC2, 0x9F, 0x8B,
	0x88, 0x7D, 0x53, 0x6A, 0x84, 0x95, 0x86, 0x97, 0xA5, 0x85, 0x73, 0x73,
	0x7F, 0x6B, 0x70, 0x8B, 0x91, 0x85, 0x82, 0x90, 0x81, 0x70, 0x75, 0x82,
	0x7D, 0x76, 0x88, 0x8D, 0x83, 0x7A, 0x84, 0x83, 0x75, 0x78, 0x83, 0x84,
	0x7A, 0x83, 0x8A, 0x7F, 0x7A, 0x80, 0x83, 0x78, 0x7C, 0x85, 0x82, 0x7C,
	0x80, 0x86, 0x7D, 0x7B, 0x81, 0x82, 0x7B, 0x7D, 0x85, 0x80, 0x7D, 0x80,
	0x84, 0x7D, 0x7C, 0x81, 0x81, 0x7C, 0x7E, 0x84, 0x82, 0x7D, 0x87, 0xBF,
	0xAC, 0x98, 0xA8, 0x8E, 0x71, 0x60, 0x7B, 0x73, 0x71, 0x8E, 0x9A, 0x8F,
	0x84, 0x91, 0x80, 0x6C, 0x73, 0x7E, 0x79, 0x78, 0x8E, 0x8D, 0x81, 0x83,
	0x87, 0x7B, 0x71, 0x7F, 0x7D, 0x79, 0x7F, 0x88, 0x84, 0x7D, 0x86, 0x82,
	0x7A, 0x7B, 0x80, 0x7D, 0x7A, 0x83, 0x83, 0x7F, 0x80, 0x84, 0x7F, 0x7C,
	0x80, 0x7F, 0x7D, 0x7E, 0x82, 0x80, 0x7E, 0x83, 0x81, 0x7E, 0x7F, 0x80,
	0x7E, 0x7D, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7D,
	0x81, 0x7D, 0x8B, 0xB0, 0xA0, 0xA2, 0xA5, 0x8D, 0x7C, 0x70, 0x77, 0x6A,
	0x72, 0x86, 0x84, 0x8C, 0x90, 0x93, 0x87, 0x81, 0x84, 0x76, 0x75, 0x79,
	0x7A, 0x7C, 0x80, 0x89, 0x84, 0x85, 0x87, 0x81, 0x7E, 0x7C, 0x7E, 0x79,
	0x7B, 0x80, 0x7F, 0x81, 0x83, 0x84, 0x81, 0x83, 0x84, 0x7F, 0x81, 0x80,
	0x7E, 0x7E, 0x7E, 0x80, 0x7E, 0x80, 0x82, 0x80, 0x81, 0x81, 0x80, 0x80,
	0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x83, 0x9C, 0x9C, 0x9D, 0xA6, 0x96,
	0x8D, 0x84, 0x7E, 0x77, 0x71, 0x7A, 0x76, 0x7A, 0x84, 0x85, 0x89, 0x8A,
	0x8D, 0x89, 0x83, 0x85, 0x7D, 0x7A, 0x7B, 0x78, 0x78, 0x78, 0x7C, 0x7D,
	0x7E, 0x84, 0x83, 0x84, 0x85, 0x83, 0x83, 0x80, 0x80, 0x7E, 0x7C, 0x7D,
	0x7C, 0x7C, 0x7E, 0x7E, 0x80, 0x80, 0x82, 0x82, 0x81, 0x82, 0x81, 0x80,
	0x80, 0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x7C, 0x7D, 0x7E, 0x7E, 0x80, 0x80,
	0x81, 0x82, 0x81, 0x82, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x82,
	0x92, 0x96, 0x98, 0x9E, 0x97, 0x93, 0x8F, 0x8D, 0x8A, 0x80, 0x7D, 0x78,
	0x70, 0x72, 0x72, 0x74, 0x76, 0x79, 0x7E, 0x7F, 0x83, 0x8A, 0x8A, 0x8C,
	0x8C, 0x8A, 0x88, 0x85, 0x84, 0x81, 0x7C, 0x7B, 0x78, 0x77, 0x78, 0x78,
	0x7A, 0x7C, 0x7F, 0x81, 0x83, 0x86, 0x87, 0x88, 0x89, 0x88, 0x87, 0x86,
	0x83, 0x82, 0x80, 0x7D, 0x7D, 0x7B, 0x7A, 0x7A, 0x7A, 0x7B, 0x7C, 0x7E,
	0x7F, 0x80, 0x82, 0x83, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F,
	0x7D, 0x7D, 0x7C, 0x7C, 0x7B, 0x82, 0x8E, 0x90, 0x92, 0x95, 0x92, 0x93,
	0x93, 0x94, 0x92, 0x8A, 0x85, 0x80, 0x7C, 0x7C, 0x7A, 0x79, 0x77, 0x76,
	0x78, 0x7B, 0x7F, 0x83, 0x84, 0x86, 0x87, 0x88, 0x8A, 0x8A, 0x89, 0x87,
	0x84, 0x82, 0x80, 0x7E, 0x7D, 0x7B, 0x7A, 0x79, 0x79, 0x7B, 0x7C, 0x7E,
	0x7F, 0x80, 0x82, 0x83, 0x84, 0x85, 0x85, 0x84, 0x83, 0x82, 0x82, 0x80,
	0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80,
	0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x80,
	0x8A, 0x8E, 0x8F, 0x92, 0x90, 0x8F, 0x90, 0x91, 0x91, 0x8C, 0x88, 0x84,
	0x7F, 0x7F, 0x7E, 0x7C, 0x7A, 0x78, 0x79, 0x7A, 0x7D, 0x80, 0x81, 0x83,
	0x84, 0x85, 0x87, 0x88, 0x88, 0x87, 0x85, 0x84, 0x83, 0x82, 0x81, 0x7F,
	0x7E, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x82, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x82, 0x88, 0x8A, 0x8C, 0x8D, 0x8C,
	0x8C, 0x8C, 0x8D, 0x8C, 0x89, 0x87, 0x83, 0x81, 0x80, 0x7E, 0x7D, 0x7B,
	0x7A, 0x7A, 0x7B, 0x7D, 0x7F, 0x80, 0x82, 0x83, 0x84, 0x86, 0x87, 0x88,
	0x87, 0x86, 0x85, 0x84, 0x83, 0x82, 0x80, 0x7F, 0x7D, 0x7C, 0x7C, 0x7C,
	0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x84,
	0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82,
	0x81, 0x84, 0x88, 0x88, 0x89, 0x8A, 0x89, 0x89, 0x8A, 0x8B, 0x8A, 0x88,
	0x87, 0x85, 0x84, 0x83, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84,
	0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x84, 0x86, 0x87, 0x88,
	0x88, 0x89, 0x89, 0x8B, 0x8A, 0x89, 0x89, 0x88, 0x87, 0x86, 0x86, 0x85,
	0x84, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x83, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x83, 0x82, 0x83, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83,
	0x85, 0x86, 0x86, 0x87, 0x87, 0x88, 0x88, 0x88, 0x88, 0x86, 0x85, 0x85,
	0x84, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7B,
	0x7A, 0x7A, 0x7A, 0x7A, 0x7A, 0x7B, 0x7B, 0x7A, 0x7B, 0x7B, 0x7B, 0x7B,
	0x7C, 0x7C, 0x7B, 0x7C, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x81, 0x82, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B,
	0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80
};
const unsigned char WAV90[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81,
	0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x85, 0x89, 0x8C,
	0x8E, 0x8E, 0x8D, 0x8D, 0x8D, 0x8C, 0x8A, 0x87, 0x83, 0x81, 0x7F, 0x7F,
	0x7F, 0x7D, 0x7D, 0x7C, 0x7C, 0x7E, 0x7F, 0x81, 0x81, 0x82, 0x82, 0x83,
	0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7D,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x82, 0x8C, 0x94, 0x9A, 0x9E, 0x9A,
	0x99, 0x97, 0x97, 0x96, 0x92, 0x8C, 0x84, 0x7F, 0x7A, 0x78, 0x78, 0x76,
	0x76, 0x75, 0x76, 0x79, 0x7D, 0x81, 0x84, 0x86, 0x87, 0x88, 0x8A, 0x8A,
	0x8A, 0x88, 0x86, 0x83, 0x80, 0x7F, 0x7D, 0x7C, 0x7A, 0x79, 0x78, 0x78,
	0x7A, 0x7B, 0x7D, 0x7E, 0x80, 0x81, 0x82, 0x84, 0x84, 0x85, 0x84, 0x84,
	0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7F, 0x7F, 0x85, 0x94, 0x9B, 0xA4, 0xA8, 0xA4, 0xA4, 0xA2,
	0xA2, 0xA0, 0x9B, 0x94, 0x89, 0x82, 0x7B, 0x79, 0x77, 0x74, 0x73, 0x71,
	0x73, 0x75, 0x7A, 0x80, 0x84, 0x89, 0x8A, 0x8D, 0x8F, 0x90, 0x91, 0x90,
	0x8E, 0x8A, 0x86, 0x83, 0x80, 0x7E, 0x7B, 0x79, 0x77, 0x76, 0x76, 0x77,
	0x79, 0x7B, 0x7D, 0x80, 0x81, 0x84, 0x85, 0x87, 0x88, 0x88, 0x88, 0x87,
	0x86, 0x84, 0x83, 0x81, 0x7F, 0x7E, 0x7C, 0x7B, 0x7B, 0x7A, 0x7B, 0x7B,
	0x7C, 0x7E, 0x8D, 0x98, 0x9F, 0xA8, 0xA6, 0xA7, 0xA6, 0xA6, 0xA7, 0xA3,
	0x9E, 0x94, 0x8A, 0x82, 0x7C, 0x7A, 0x76, 0x74, 0x71, 0x6F, 0x72, 0x74,
	0x7B, 0x80, 0x85, 0x89, 0x8B, 0x8E, 0x90, 0x93, 0x94, 0x92, 0x90, 0x8B,
	0x88, 0x84, 0x81, 0x7E, 0x7B, 0x78, 0x76, 0x75, 0x75, 0x77, 0x79, 0x7B,
	0x7D, 0x7F, 0x82, 0x84, 0x86, 0x88, 0x89, 0x89, 0x88, 0x86, 0x86, 0x84,
	0x82, 0x80, 0x7E, 0x7C, 0x7B, 0x7A, 0x7A, 0x7A, 0x7B, 0x7B, 0x7E, 0x90,
	0x9C, 0xA2, 0xAA, 0xA9, 0xAC, 0xAA, 0xAB, 0xA9, 0xA2, 0x9B, 0x90, 0x89,
	0x81, 0x7C, 0x78, 0x74, 0x71, 0x6F, 0x71, 0x73, 0x77, 0x7B, 0x7E, 0x83,
	0x85, 0x89, 0x8B, 0x8D, 0x8E, 0x8D, 0x8C, 0x89, 0x87, 0x84, 0x81, 0x7E,
	0x7C, 0x7B, 0x79, 0x79, 0x79, 0x79, 0x7B, 0x7C, 0x7D, 0x7E, 0x80, 0x81,
	0x82, 0x82, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7C, 0x7B, 0x7D, 0x7A, 0x8D, 0xA8, 0xAE, 0xB0, 0xAD,
	0xB0, 0xA6, 0x97, 0x8C, 0x84, 0x7E, 0x71, 0x6D, 0x6B, 0x6D, 0x6B, 0x6C,
	0x72, 0x76, 0x7A, 0x7C, 0x81, 0x85, 0x86, 0x88, 0x87, 0x89, 0x86, 0x84,
	0x82, 0x80, 0x80, 0x7D, 0x7D, 0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7D, 0x7C, 0x7D, 0x7D, 0x7F, 0x7E, 0x81, 0x80, 0x82,
	0x7F, 0x82, 0x7D, 0xA2, 0xC3, 0xC0, 0xB2, 0xA3, 0xA4, 0x84, 0x6B, 0x5C,
	0x6C, 0x72, 0x72, 0x7E, 0x8F, 0x9C, 0x8F, 0x88, 0x85, 0x89, 0x7A, 0x71,
	0x75, 0x80, 0x82, 0x7D, 0x84, 0x89, 0x8B, 0x7E, 0x7D, 0x7E, 0x7F, 0x79,
	0x78, 0x80, 0x83, 0x83, 0x7F, 0x84, 0x84, 0x81, 0x7B, 0x7D, 0x7F, 0x7F,
	0x7C, 0x7E, 0x82, 0x82, 0x81, 0x7F, 0x82, 0x7F, 0x7F, 0x7C, 0x80, 0x7F,
	0x80, 0x7E, 0x81, 0x81, 0x81, 0x7E, 0x7F, 0x7F, 0x80, 0x7C, 0x89, 0xC2,
	0xCC, 0xB9, 0x93, 0x91, 0x85, 0x68, 0x57, 0x64, 0x89, 0x8A, 0x8E, 0x8D,
	0x9D, 0x8E, 0x79, 0x6A, 0x73, 0x7A, 0x77, 0x7A, 0x86, 0x94, 0x8B, 0x81,
	0x7B, 0x81, 0x7A, 0x75, 0x76, 0x82, 0x87, 0x83, 0x82, 0x83, 0x85, 0x7D,
	0x79, 0x79, 0x80, 0x81, 0x82, 0x82, 0x85, 0x84, 0x7F, 0x7C, 0x7C, 0x7F,
	0x7D, 0x7F, 0x7F, 0x84, 0x82, 0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x80,
	0x81, 0x81, 0x7F, 0x81, 0x7E, 0x86, 0xBE, 0xD2, 0xBD, 0x80, 0x71, 0x75,
	0x72, 0x65, 0x6A, 0x93, 0xA5, 0xA2, 0x82, 0x81, 0x7D, 0x79, 0x66, 0x6C,
	0x82, 0x91, 0x90, 0x84, 0x87, 0x83, 0x7F, 0x6E, 0x73, 0x7C, 0x87, 0x84,
	0x83, 0x86, 0x86, 0x87, 0x7D, 0x7C, 0x7A, 0x81, 0x80, 0x81, 0x81, 0x84,
	0x83, 0x7F, 0x7D, 0x7D, 0x7F, 0x7F, 0x7F, 0x80, 0x82, 0x82, 0x80, 0x7E,
	0x7F, 0x7E, 0x80, 0x7E, 0x81, 0x7F, 0x83, 0x7E, 0x81, 0x7F, 0x84, 0x7C,
	0x91, 0xCF, 0xDC, 0xB6, 0x6C, 0x65, 0x6D, 0x79, 0x69, 0x76, 0x9A, 0xB0,
	0xA2, 0x78, 0x6F, 0x6F, 0x7A, 0x6E, 0x76, 0x85, 0x9B, 0x94, 0x83, 0x76,
	0x76, 0x7A, 0x77, 0x7D, 0x83, 0x90, 0x8B, 0x84, 0x79, 0x7A, 0x7A, 0x7B,
	0x7C, 0x80, 0x87, 0x87, 0x84, 0x7C, 0x7C, 0x7B, 0x7E, 0x7D, 0x80, 0x83,
	0x84, 0x83, 0x7F, 0x7E, 0x7C, 0x7E, 0x7E, 0x7F, 0x82, 0x83, 0x85, 0x7E,
	0x7F, 0x7B, 0x80, 0x7D, 0x81, 0x7F, 0x84, 0xC0, 0xE4, 0xD0, 0x7C, 0x51,
	0x5A, 0x7A, 0x7E, 0x77, 0x8D, 0xA9, 0xB1, 0x87, 0x66, 0x5C, 0x75, 0x7D,
	0x81, 0x80, 0x92, 0xA0, 0x96, 0x7B, 0x67, 0x6E, 0x7A, 0x83, 0x80, 0x86,
	0x8C, 0x8F, 0x82, 0x75, 0x71, 0x79, 0x80, 0x82, 0x82, 0x85, 0x87, 0x84,
	0x7C, 0x77, 0x7A, 0x7E, 0x82, 0x81, 0x82, 0x82, 0x84, 0x80, 0x7F, 0x7C,
	0x7F, 0x7E, 0x81, 0x80, 0x82, 0x80, 0x81, 0x7E, 0x7F, 0x7D, 0x7F, 0x80,
	0x81, 0xBF, 0xE5, 0xD3, 0x7F, 0x4F, 0x5A, 0x79, 0x80, 0x75, 0x8A, 0xA7,
	0xB4, 0x8D, 0x6A, 0x60, 0x75, 0x7F, 0x7C, 0x7D, 0x8D, 0x9B, 0x90, 0x7A,
	0x6C, 0x73, 0x7D, 0x80, 0x7D, 0x83, 0x8C, 0x8C, 0x82, 0x76, 0x76, 0x7B,
	0x80, 0x7F, 0x80, 0x84, 0x87, 0x83, 0x7D, 0x79, 0x7D, 0x87, 0x8A, 0x86,
	0x7E, 0x80, 0x80, 0x80, 0x7A, 0x7C, 0x80, 0x86, 0x83, 0x80, 0x7E, 0x80,
	0x80, 0x7D, 0x7E, 0x7D, 0x85, 0x7D, 0xAD, 0xDB, 0xD9, 0x93, 0x59, 0x5D,
	0x73, 0x7D, 0x6D, 0x83, 0xA2, 0xB4, 0x92, 0x71, 0x68, 0x75, 0x78, 0x71,
	0x78, 0x8D, 0x9C, 0x90, 0x7D, 0x74, 0x79, 0x7A, 0x76, 0x77, 0x83, 0x8E,
	0x8C, 0x81, 0x7C, 0x7C, 0x7D, 0x79, 0x79, 0x7E, 0x88, 0x89, 0x84, 0x80,
	0x7E, 0x7F, 0x7B, 0x7A, 0x7C, 0x83, 0x83, 0x83, 0x80, 0x81, 0x80, 0x7D,
	0x7C, 0x7C, 0x81, 0x80, 0x83, 0x7E, 0x84, 0x7D, 0x82, 0x79, 0x8A, 0xCC,
	0xDD, 0xB8, 0x70, 0x72, 0x7C, 0x74, 0x59, 0x6D, 0xA0, 0xAD, 0x97, 0x7C,
	0x8A, 0x85, 0x73, 0x5B, 0x72, 0x8B, 0x91, 0x83, 0x84, 0x90, 0x89, 0x76,
	0x6A, 0x79, 0x82, 0x82, 0x7B, 0x86, 0x8D, 0x88, 0x79, 0x77, 0x7E, 0x7E,
	0x79, 0x7B, 0x85, 0x89, 0x82, 0x7D, 0x81, 0x81, 0x7C, 0x78, 0x7E, 0x83,
	0x83, 0x7E, 0x81, 0x83, 0x82, 0x7B, 0x7C, 0x7F, 0x81, 0x7D, 0x80, 0x80,
	0x86, 0x7A, 0x99, 0xD5, 0xC7, 0x9F, 0x7E, 0x89, 0x71, 0x58, 0x61, 0x8C,
	0x9C, 0x8C, 0x93, 0x9D, 0x95, 0x6E, 0x69, 0x76, 0x7E, 0x72, 0x7C, 0x93,
	0x96, 0x84, 0x7B, 0x86, 0x7F, 0x71, 0x6F, 0x82, 0x87, 0x82, 0x85, 0x8E,
	0x89, 0x79, 0x79, 0x7F, 0x7D, 0x75, 0x7F, 0x87, 0x85, 0x7F, 0x82, 0x86,
	0x7C, 0x79, 0x7C, 0x82, 0x7D, 0x7D, 0x83, 0x85, 0x80, 0x7D, 0x81, 0x81,
	0x7B, 0x7D, 0x7F, 0x85, 0x79, 0x9F, 0xD6, 0xBA, 0xA9, 0xA3, 0x96, 0x61,
	0x56, 0x70, 0x76, 0x77, 0x89, 0xAB, 0x97, 0x88, 0x84, 0x85, 0x6A, 0x64,
	0x7A, 0x80, 0x7E, 0x84, 0x97, 0x8B, 0x7E, 0x7D, 0x81, 0x70, 0x6E, 0x7F,
	0x81, 0x7D, 0x85, 0x8E, 0x83, 0x7D, 0x81, 0x7F, 0x76, 0x79, 0x82, 0x7F,
	0x7E, 0x84, 0x87, 0x80, 0x7E, 0x81, 0x7E, 0x7A, 0x7D, 0x82, 0x7F, 0x7F,
	0x83, 0x83, 0x7E, 0x83, 0x82, 0x81, 0x7B, 0x8E, 0xC2, 0xB1, 0xB3, 0xB8,
	0xA2, 0x7A, 0x6B, 0x71, 0x59, 0x66, 0x7C, 0x8C, 0x88, 0x96, 0x9B, 0x86,
	0x7D, 0x7B, 0x75, 0x69, 0x76, 0x7F, 0x7F, 0x86, 0x8C, 0x83, 0x7D, 0x7D,
	0x79, 0x74, 0x77, 0x7E, 0x7C, 0x81, 0x87, 0x85, 0x83, 0x83, 0x81, 0x7B,
	0x7C, 0x7D, 0x7C, 0x7D, 0x80, 0x82, 0x80, 0x83, 0x81, 0x80, 0x7E, 0x7F,
	0x7D, 0x7E, 0x7F, 0x83, 0x81, 0x84, 0x83, 0x84, 0x7E, 0x91, 0xBB, 0xAC,
	0xBD, 0xBC, 0xA3, 0x89, 0x7A, 0x70, 0x56, 0x66, 0x6E, 0x75, 0x83, 0x94,
	0x95, 0x8F, 0x94, 0x88, 0x7C, 0x77, 0x76, 0x70, 0x73, 0x7C, 0x7D, 0x82,
	0x88, 0x89, 0x87, 0x87, 0x84, 0x7E, 0x7C, 0x7B, 0x7A, 0x79, 0x7E, 0x7E,
	0x80, 0x83, 0x84, 0x84, 0x82, 0x83, 0x7E, 0x7F, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7F, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x7E, 0x80, 0x7C, 0x90,
	0xB3, 0xB1, 0xC2, 0xBD, 0xA8, 0x91, 0x81, 0x74, 0x61, 0x6A, 0x6C, 0x71,
	0x7D, 0x8A, 0x91, 0x92, 0x9A, 0x94, 0x8C, 0x87, 0x7F, 0x7B, 0x77, 0x79,
	0x78, 0x79, 0x7E, 0x7F, 0x83, 0x85, 0x89, 0x87, 0x87, 0x86, 0x81, 0x7F,
	0x7D, 0x7C, 0x7A, 0x7B, 0x7C, 0x7D, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83,
	0x81, 0x81, 0x7F, 0x7C, 0x7B, 0x7A, 0x79, 0x7B, 0x7C, 0x7E, 0x7E, 0x82,
	0x80, 0x87, 0xA3, 0xAA, 0xB2, 0xB8, 0xAA, 0x9A, 0x8B, 0x84, 0x76, 0x72,
	0x76, 0x70, 0x72, 0x78, 0x7D, 0x82, 0x8B, 0x92, 0x92, 0x94, 0x94, 0x8E,
	0x8A, 0x86, 0x81, 0x7B, 0x79, 0x77, 0x75, 0x77, 0x7A, 0x7C, 0x7F, 0x84,
	0x86, 0x86, 0x88, 0x88, 0x86, 0x85, 0x83, 0x80, 0x7D, 0x7C, 0x7B, 0x7A,
	0x7B, 0x7C, 0x7D, 0x80, 0x82, 0x83, 0x85, 0x86, 0x86, 0x85, 0x85, 0x84,
	0x82, 0x81, 0x80, 0x7D, 0x85, 0x94, 0x98, 0xA1, 0xA5, 0x9E, 0x99, 0x94,
	0x91, 0x8C, 0x8A, 0x87, 0x7E, 0x79, 0x76, 0x73, 0x75, 0x7B, 0x81, 0x84,
	0x88, 0x8A, 0x89, 0x8B, 0x8D, 0x8D, 0x8D, 0x8B, 0x87, 0x82, 0x7F, 0x7C,
	0x7A, 0x7A, 0x7A, 0x7A, 0x7B, 0x7C, 0x7D, 0x7F, 0x82, 0x84, 0x85, 0x86,
	0x86, 0x85, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7E, 0x7D, 0x7C, 0x7C,
	0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x82, 0x8C, 0x92, 0x98, 0x9E,
	0x9C, 0x99, 0x95, 0x91, 0x8E, 0x8B, 0x89, 0x85, 0x7F, 0x7B, 0x76, 0x74,
	0x74, 0x76, 0x79, 0x7C, 0x7E, 0x80, 0x81, 0x84, 0x86, 0x88, 0x8A, 0x8B,
	0x8A, 0x88, 0x85, 0x83, 0x81, 0x80, 0x7E, 0x7D, 0x7C, 0x7B, 0x7A, 0x7A,
	0x7A, 0x7C, 0x7E, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x83, 0x88, 0x8C, 0x91, 0x93, 0x92, 0x90, 0x8E, 0x8C, 0x8B, 0x8A, 0x89,
	0x87, 0x85, 0x81, 0x7E, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x82, 0x82, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x81, 0x84, 0x86, 0x88, 0x8A, 0x8A, 0x8A, 0x89,
	0x87, 0x87, 0x87, 0x87, 0x88, 0x88, 0x87, 0x86, 0x84, 0x83, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x82, 0x83, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x83, 0x83, 0x83,
	0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7C, 0x7E, 0x7E, 0x7B, 0x7C, 0x7E, 0x7D,
	0x7D, 0x80, 0x7F, 0x7D, 0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x7D, 0x7C, 0x80,
	0x7C, 0x7E, 0x80, 0x7D, 0x7D, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x82, 0x83, 0x82, 0x83, 0x83, 0x82, 0x82, 0x7F, 0x81,
	0x82, 0x80, 0x80, 0x7F, 0x7F, 0x7D, 0x7C, 0x7D, 0x7E, 0x7D, 0x7C, 0x7A,
	0x7D, 0x7D, 0x7C, 0x82, 0x82, 0x81, 0x82, 0x81, 0x80, 0x81, 0x81, 0x82,
	0x82, 0x80, 0x81, 0x82, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x81,
	0x82, 0x81, 0x81, 0x83, 0x81, 0x81, 0x83, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x89, 0x85, 0x89, 0x8E, 0x8A, 0x8A, 0x8A, 0x88,
	0x83, 0x84, 0x81, 0x7C, 0x7E, 0x7D, 0x7A, 0x7C, 0x7D, 0x7C, 0x7D, 0x80,
	0x7F, 0x7F, 0x82, 0x80, 0x80, 0x82, 0x81, 0x7F, 0x81, 0x80, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7D, 0x7E, 0x7B,
	0x7C, 0x7D, 0x7C, 0x7C, 0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0x82, 0x81,
	0x81, 0x81, 0x81, 0x7F, 0x85, 0x90, 0x8A, 0x97, 0x9D, 0x95, 0x9C, 0x99,
	0x92, 0x8C, 0x89, 0x80, 0x77, 0x79, 0x71, 0x6F, 0x74, 0x71, 0x75, 0x7A,
	0x7D, 0x7E, 0x83, 0x86, 0x84, 0x87, 0x86, 0x83, 0x83, 0x81, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7C, 0x7E, 0x7D, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x81, 0x7C, 0x8F, 0x96, 0x8C, 0xAC, 0xA1, 0x9C, 0xAC,
	0x97, 0x93, 0x8F, 0x82, 0x78, 0x72, 0x71, 0x65, 0x6B, 0x6F, 0x69, 0x78,
	0x7A, 0x7C, 0x85, 0x88, 0x89, 0x89, 0x8D, 0x87, 0x86, 0x87, 0x7E, 0x80,
	0x7E, 0x7A, 0x7C, 0x7A, 0x7C, 0x7C, 0x7D, 0x7F, 0x7E, 0x82, 0x80, 0x82,
	0x83, 0x80, 0x82, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x7C, 0x7F, 0x7E, 0x7C, 0x80, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x7D, 0x95, 0x93, 0x8D, 0xB2, 0x99,
	0x9C, 0xAC, 0x8D, 0x8F, 0x8A, 0x79, 0x71, 0x70, 0x6A, 0x5F, 0x6F, 0x69,
	0x69, 0x7E, 0x76, 0x80, 0x8A, 0x86, 0x8B, 0x8D, 0x8B, 0x86, 0x88, 0x84,
	0x7C, 0x82, 0x7B, 0x78, 0x7E, 0x78, 0x7B, 0x7E, 0x7D, 0x7F, 0x80, 0x82,
	0x81, 0x82, 0x83, 0x81, 0x82, 0x82, 0x81, 0x80, 0x82, 0x7F, 0x7F, 0x80,
	0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x98, 0x84,
	0x97, 0xAB, 0x89, 0xA8, 0x9D, 0x84, 0x98, 0x7F, 0x75, 0x79, 0x6D, 0x68,
	0x6D, 0x6F, 0x6A, 0x79, 0x7B, 0x79, 0x8A, 0x85, 0x86, 0x8E, 0x86, 0x87,
	0x87, 0x81, 0x81, 0x81, 0x7D, 0x7E, 0x7F, 0x7C, 0x7E, 0x80, 0x7D, 0x80,
	0x81, 0x7E, 0x81, 0x80, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7E, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x7E, 0x80,
	0x80, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x96, 0x8A, 0x95, 0xAD, 0x8D, 0xA8, 0xA1, 0x86, 0x99, 0x81,
	0x74, 0x7C, 0x69, 0x68, 0x6D, 0x69, 0x6C, 0x77, 0x78, 0x7C, 0x89, 0x84,
	0x8A, 0x8F, 0x87, 0x8C, 0x89, 0x82, 0x83, 0x7F, 0x7A, 0x7C, 0x7A, 0x78,
	0x7C, 0x7B, 0x7B, 0x7F, 0x7F, 0x80, 0x83, 0x81, 0x83, 0x83, 0x81, 0x82,
	0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7C, 0x8F, 0x8C, 0x8B, 0xA9, 0x91,
	0x9F, 0xA7, 0x89, 0x9B, 0x8C, 0x79, 0x84, 0x70, 0x6B, 0x71, 0x68, 0x6B,
	0x73, 0x71, 0x77, 0x81, 0x7F, 0x86, 0x8A, 0x87, 0x8B, 0x8A, 0x85, 0x87,
	0x83, 0x7F, 0x80, 0x7C, 0x7B, 0x7C, 0x7B, 0x7B, 0x7D, 0x7D, 0x7E, 0x80,
	0x80, 0x80, 0x82, 0x80, 0x81, 0x82, 0x7F, 0x81, 0x80, 0x7E, 0x80, 0x7F,
	0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x90, 0x88, 0x93, 0xA2, 0x8E, 0xA5, 0x9A, 0x8B, 0x9D, 0x7E,
	0x7E, 0x80, 0x68, 0x72, 0x6C, 0x64, 0x71, 0x6E, 0x71, 0x7B, 0x7B, 0x80,
	0x87, 0x86, 0x88, 0x8A, 0x87, 0x87, 0x87, 0x82, 0x82, 0x81, 0x7D, 0x7F,
	0x7D, 0x7C, 0x7F, 0x7E, 0x7E, 0x81, 0x80, 0x80, 0x82, 0x80, 0x81, 0x81,
	0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7D,
	0x7F, 0x7E, 0x7D, 0x80, 0x7D, 0x7F, 0x80, 0x7F, 0x80, 0x82, 0x8B, 0x86,
	0x93, 0x98, 0x8F, 0xA1, 0x93, 0x92, 0x99, 0x83, 0x89, 0x80, 0x73, 0x7A,
	0x6F, 0x6E, 0x73, 0x6E, 0x73, 0x77, 0x77, 0x7D, 0x80, 0x7F, 0x84, 0x84,
	0x82, 0x86, 0x82, 0x82, 0x84, 0x7F, 0x81, 0x81, 0x7F, 0x82, 0x80, 0x80,
	0x82, 0x80, 0x81, 0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D,
	0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x86, 0x85, 0x8A, 0x91, 0x8C, 0x96,
	0x92, 0x8F, 0x94, 0x88, 0x8A, 0x85, 0x7D, 0x7F, 0x77, 0x77, 0x77, 0x73,
	0x77, 0x77, 0x78, 0x7B, 0x7C, 0x7D, 0x7F, 0x80, 0x7F, 0x82, 0x80, 0x7F,
	0x81, 0x7E, 0x80, 0x7F, 0x7E, 0x81, 0x7E, 0x80, 0x81, 0x80, 0x82, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x82, 0x85, 0x85, 0x8C, 0x8A, 0x8E, 0x90, 0x8C, 0x8F, 0x8A,
	0x89, 0x88, 0x82, 0x83, 0x80, 0x7E, 0x7F, 0x7C, 0x7E, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x81, 0x82, 0x81, 0x82, 0x81, 0x81, 0x82, 0x7F, 0x80, 0x80,
	0x7E, 0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x83,
	0x84, 0x88, 0x86, 0x88, 0x88, 0x86, 0x88, 0x86, 0x86, 0x85, 0x83, 0x84,
	0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81,
	0x81, 0x82, 0x81, 0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x84, 0x83, 0x84,
	0x84, 0x84, 0x85, 0x84, 0x85, 0x85, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83,
	0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80
};
const unsigned char WAValt[] = {
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x83, 0x86, 0x86, 0x82,
	0x7D, 0x7A, 0x7C, 0x80, 0x83, 0x82, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E,
	0x7E, 0x7F, 0x81, 0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x7F, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x8A,
	0x99, 0xA1, 0x94, 0x78, 0x64, 0x64, 0x7A, 0x8D, 0x97, 0x8B, 0x81, 0x7A,
	0x7D, 0x7E, 0x7B, 0x77, 0x78, 0x84, 0x8C, 0x8E, 0x82, 0x78, 0x72, 0x79,
	0x80, 0x86, 0x84, 0x80, 0x7F, 0x80, 0x82, 0x7F, 0x7C, 0x7A, 0x7E, 0x82,
	0x86, 0x83, 0x7F, 0x7B, 0x7C, 0x7F, 0x81, 0x81, 0x7F, 0x7C, 0x7B, 0x7C,
	0x80, 0x82, 0x83, 0x81, 0x7F, 0x7D, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x81, 0x81, 0x7F, 0x98, 0xB1, 0xBD, 0x9C, 0x6B, 0x47, 0x51, 0x7C, 0xA1,
	0xAC, 0x94, 0x7E, 0x72, 0x7B, 0x7E, 0x7C, 0x72, 0x76, 0x84, 0x95, 0x97,
	0x86, 0x73, 0x69, 0x74, 0x82, 0x8C, 0x87, 0x81, 0x7C, 0x80, 0x82, 0x80,
	0x7A, 0x77, 0x7C, 0x83, 0x89, 0x86, 0x80, 0x79, 0x7A, 0x7E, 0x83, 0x83,
	0x81, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x7D, 0x7C, 0x7F, 0x81, 0x83, 0x80,
	0x7F, 0x7C, 0x7F, 0x7F, 0x82, 0x7E, 0x83, 0xA1, 0xBB, 0xC2, 0x94, 0x60,
	0x3D, 0x54, 0x83, 0xAB, 0xAC, 0x92, 0x7C, 0x72, 0x7C, 0x7B, 0x78, 0x6E,
	0x79, 0x89, 0x9A, 0x95, 0x83, 0x6F, 0x69, 0x75, 0x83, 0x8B, 0x86, 0x82,
	0x7E, 0x82, 0x82, 0x7E, 0x78, 0x77, 0x7D, 0x86, 0x89, 0x84, 0x7C, 0x76,
	0x7A, 0x7F, 0x85, 0x83, 0x7F, 0x7D, 0x7F, 0x82, 0x81, 0x7F, 0x7C, 0x7D,
	0x80, 0x83, 0x83, 0x80, 0x7E, 0x7C, 0x80, 0x80, 0x81, 0x7F, 0x80, 0xA3,
	0xC3, 0xD0, 0xA1, 0x5F, 0x33, 0x44, 0x7F, 0xAE, 0xB9, 0x98, 0x7E, 0x70,
	0x7C, 0x7D, 0x77, 0x6B, 0x72, 0x88, 0x9D, 0x9F, 0x87, 0x70, 0x64, 0x71,
	0x80, 0x8C, 0x87, 0x82, 0x7F, 0x83, 0x85, 0x7F, 0x77, 0x75, 0x7F, 0x89,
	0x8E, 0x85, 0x7C, 0x76, 0x7A, 0x81, 0x84, 0x82, 0x7E, 0x7E, 0x81, 0x84,
	0x82, 0x7D, 0x7A, 0x7C, 0x80, 0x84, 0x83, 0x81, 0x7C, 0x7F, 0x7E, 0x82,
	0x7E, 0x80, 0x7C, 0x83, 0xB3, 0xD6, 0xDE, 0x99, 0x4D, 0x23, 0x47, 0x8F,
	0xBD, 0xBC, 0x90, 0x79, 0x73, 0x86, 0x81, 0x72, 0x61, 0x6D, 0x8E, 0xA7,
	0xA5, 0x85, 0x6A, 0x61, 0x73, 0x85, 0x8B, 0x85, 0x7D, 0x83, 0x8B, 0x8E,
	0x83, 0x71, 0x6C, 0x74, 0x87, 0x8F, 0x8D, 0x80, 0x7A, 0x7A, 0x80, 0x82,
	0x7D, 0x7B, 0x7B, 0x83, 0x88, 0x87, 0x80, 0x79, 0x78, 0x7D, 0x82, 0x84,
	0x80, 0x7F, 0x7E, 0x7E, 0x79, 0x79, 0x78, 0x84, 0x81, 0x9C, 0xCE, 0xE4,
	0xCE, 0x6F, 0x2E, 0x20, 0x66, 0xB0, 0xCB, 0xB0, 0x80, 0x74, 0x7D, 0x8D,
	0x7C, 0x64, 0x5B, 0x75, 0xA0, 0xB1, 0xA1, 0x78, 0x61, 0x65, 0x7B, 0x8B,
	0x85, 0x7E, 0x7B, 0x89, 0x91, 0x8D, 0x7B, 0x6B, 0x6D, 0x7B, 0x8C, 0x8E,
	0x87, 0x7C, 0x7B, 0x7F, 0x82, 0x7F, 0x79, 0x78, 0x7E, 0x86, 0x8A, 0x85,
	0x7D, 0x78, 0x7B, 0x7F, 0x82, 0x7F, 0x7E, 0x7E, 0x83, 0x84, 0x83, 0x7D,
	0x7B, 0x7B, 0x80, 0x82, 0x83, 0xB3, 0xD9, 0xE5, 0xA4, 0x4B, 0x21, 0x3C,
	0x92, 0xBF, 0xC1, 0x90, 0x76, 0x7B, 0x8D, 0x8E, 0x6D, 0x5E, 0x67, 0x95,
	0xB1, 0xAA, 0x85, 0x63, 0x64, 0x76, 0x8D, 0x8A, 0x7E, 0x78, 0x81, 0x92,
	0x91, 0x83, 0x6D, 0x6A, 0x76, 0x88, 0x91, 0x89, 0x7E, 0x78, 0x7F, 0x83,
	0x83, 0x7B, 0x77, 0x79, 0x81, 0x88, 0x85, 0x81, 0x7B, 0x7C, 0x7E, 0x81,
	0x80, 0x7F, 0x7D, 0x80, 0x82, 0x83, 0x80, 0x7D, 0x7B, 0x7E, 0x81, 0x82,
	0x81, 0x7F, 0xB1, 0xD7, 0xE4, 0xA1, 0x49, 0x20, 0x3E, 0x95, 0xBE, 0xBF,
	0x89, 0x75, 0x78, 0x92, 0x90, 0x6F, 0x57, 0x5A, 0x8A, 0xAC, 0xB4, 0x8D,
	0x69, 0x5C, 0x70, 0x88, 0x8C, 0x81, 0x75, 0x7D, 0x8D, 0x96, 0x8A, 0x73,
	0x66, 0x6E, 0x84, 0x90, 0x8E, 0x80, 0x77, 0x7B, 0x82, 0x87, 0x7E, 0x77,
	0x75, 0x7F, 0x8A, 0x8B, 0x85, 0x78, 0x76, 0x7B, 0x83, 0x85, 0x80, 0x7D,
	0x7B, 0x82, 0x84, 0x84, 0x7E, 0x79, 0x7B, 0x7E, 0x86, 0x80, 0x84, 0x76,
	0x95, 0xC7, 0xE4, 0xCC, 0x6D, 0x2E, 0x20, 0x6F, 0xB2, 0xCD, 0xA8, 0x76,
	0x6E, 0x7C, 0x98, 0x82, 0x69, 0x51, 0x6F, 0x9B, 0xB7, 0xA8, 0x78, 0x5D,
	0x5B, 0x7D, 0x8F, 0x94, 0x81, 0x79, 0x81, 0x8C, 0x91, 0x7E, 0x6F, 0x67,
	0x78, 0x8C, 0x95, 0x8E, 0x7A, 0x74, 0x76, 0x83, 0x85, 0x80, 0x79, 0x78,
	0x83, 0x8A, 0x8B, 0x7F, 0x77, 0x74, 0x7D, 0x85, 0x87, 0x81, 0x79, 0x78,
	0x7E, 0x86, 0x87, 0x80, 0x79, 0x78, 0x7E, 0x84, 0x85, 0x81, 0x7A, 0x7D,
	0x7B, 0xA8, 0xD0, 0xE4, 0xB2, 0x59, 0x25, 0x2E, 0x82, 0xBA, 0xCD, 0x9A,
	0x75, 0x6A, 0x82, 0x93, 0x80, 0x66, 0x55, 0x78, 0x9E, 0xB8, 0xA0, 0x75,
	0x57, 0x5E, 0x7D, 0x93, 0x92, 0x7E, 0x75, 0x7C, 0x8E, 0x91, 0x82, 0x6D,
	0x66, 0x75, 0x8C, 0x98, 0x8E, 0x7B, 0x70, 0x76, 0x82, 0x85, 0x7E, 0x73,
	0x77, 0x82, 0x90, 0x8E, 0x81, 0x72, 0x6F, 0x7A, 0x86, 0x8B, 0x84, 0x7C,
	0x79, 0x7F, 0x85, 0x84, 0x7E, 0x78, 0x79, 0x80, 0x87, 0x88, 0x80, 0x7C,
	0x77, 0x81, 0x7C, 0x9C, 0xC4, 0xE2, 0xCA, 0x75, 0x2F, 0x19, 0x60, 0xAA,
	0xDB, 0xB9, 0x85, 0x60, 0x6A, 0x88, 0x8B, 0x7B, 0x5C, 0x69, 0x88, 0xB3,
	0xAF, 0x8D, 0x5F, 0x50, 0x68, 0x89, 0x9E, 0x8F, 0x7E, 0x74, 0x83, 0x8F,
	0x8E, 0x7A, 0x66, 0x68, 0x7C, 0x96, 0x9A, 0x8D, 0x75, 0x6D, 0x74, 0x83,
	0x8A, 0x83, 0x7A, 0x77, 0x81, 0x8A, 0x8C, 0x80, 0x75, 0x71, 0x7B, 0x86,
	0x8C, 0x86, 0x7D, 0x78, 0x7C, 0x83, 0x84, 0x82, 0x7A, 0x7A, 0x7C, 0x85,
	0x86, 0x85, 0x7C, 0x7A, 0x7A, 0x81, 0x83, 0x85, 0xA5, 0xC5, 0xDA, 0xAE,
	0x6A, 0x2C, 0x30, 0x6A, 0xAD, 0xCB, 0xAD, 0x84, 0x65, 0x70, 0x7F, 0x88,
	0x75, 0x65, 0x67, 0x83, 0xA3, 0xAA, 0x97, 0x70, 0x5D, 0x61, 0x7B, 0x8E,
	0x91, 0x84, 0x7A, 0x7B, 0x85, 0x8D, 0x86, 0x78, 0x6B, 0x70, 0x7F, 0x8F,
	0x91, 0x88, 0x7A, 0x74, 0x78, 0x80, 0x86, 0x81, 0x7D, 0x78, 0x7F, 0x84,
	0x89, 0x84, 0x7D, 0x77, 0x78, 0x7F, 0x84, 0x86, 0x81, 0x7E, 0x7B, 0x7F,
	0x82, 0x83, 0x80, 0x7C, 0x7B, 0x7E, 0x82, 0x84, 0x82, 0x7F, 0x7B, 0x7D,
	0x7C, 0x8B, 0xA7, 0xC7, 0xCE, 0xAC, 0x73, 0x41, 0x3C, 0x5C, 0x90, 0xAC,
	0xAC, 0x92, 0x7E, 0x79, 0x83, 0x86, 0x7C, 0x6C, 0x63, 0x71, 0x89, 0x9F,
	0x9E, 0x8E, 0x74, 0x6A, 0x6C, 0x7B, 0x84, 0x86, 0x7F, 0x7C, 0x7F, 0x87,
	0x8C, 0x87, 0x7D, 0x72, 0x72, 0x78, 0x85, 0x89, 0x89, 0x80, 0x7C, 0x7B,
	0x80, 0x82, 0x81, 0x7D, 0x7A, 0x7B, 0x7F, 0x86, 0x85, 0x83, 0x7C, 0x7B,
	0x7B, 0x80, 0x82, 0x83, 0x7F, 0x7E, 0x7D, 0x80, 0x82, 0x82, 0x81, 0x7D,
	0x7D, 0x7D, 0x81, 0x81, 0x83, 0x7E, 0x80, 0x7B, 0x86, 0x9D, 0xBC, 0xCB,
	0xB6, 0x87, 0x53, 0x40, 0x51, 0x80, 0xA2, 0xAE, 0x9A, 0x83, 0x75, 0x7B,
	0x85, 0x86, 0x7A, 0x6B, 0x69, 0x77, 0x90, 0x9D, 0x99, 0x84, 0x71, 0x69,
	0x72, 0x80, 0x8A, 0x87, 0x7F, 0x79, 0x7D, 0x85, 0x8B, 0x86, 0x7A, 0x71,
	0x70, 0x7B, 0x87, 0x8E, 0x89, 0x80, 0x78, 0x78, 0x7D, 0x83, 0x84, 0x80,
	0x7A, 0x7B, 0x7E, 0x85, 0x86, 0x84, 0x7D, 0x79, 0x79, 0x7F, 0x83, 0x85,
	0x82, 0x7E, 0x7C, 0x7D, 0x81, 0x81, 0x80, 0x7C, 0x7D, 0x7D, 0x82, 0x82,
	0x84, 0x7E, 0x7F, 0x7A, 0x81, 0x97, 0xB4, 0xC9, 0xBD, 0x96, 0x60, 0x44,
	0x47, 0x6E, 0x93, 0xA8, 0xA0, 0x8E, 0x7E, 0x7C, 0x81, 0x82, 0x7B, 0x6E,
	0x6A, 0x73, 0x87, 0x97, 0x9A, 0x8C, 0x7B, 0x6E, 0x6F, 0x79, 0x83, 0x86,
	0x82, 0x7D, 0x7D, 0x82, 0x87, 0x88, 0x81, 0x79, 0x74, 0x77, 0x7F, 0x87,
	0x88, 0x84, 0x7E, 0x7C, 0x7F, 0x84, 0x86, 0x83, 0x7D, 0x78, 0x79, 0x7E,
	0x84, 0x86, 0x84, 0x7F, 0x7C, 0x7C, 0x7F, 0x82, 0x82, 0x7F, 0x7D, 0x7C,
	0x7F, 0x81, 0x83, 0x81, 0x7F, 0x7D, 0x7D, 0x7F, 0x81, 0x82, 0x7E, 0x7E,
	0x7A, 0x86, 0x9B, 0xBA, 0xC7, 0xBA, 0x93, 0x66, 0x4C, 0x4F, 0x6A, 0x86,
	0x99, 0x96, 0x8E, 0x85, 0x87, 0x89, 0x88, 0x7D, 0x6F, 0x66, 0x6C, 0x7C,
	0x8E, 0x96, 0x91, 0x84, 0x77, 0x73, 0x77, 0x7E, 0x82, 0x80, 0x7B, 0x7A,
	0x7E, 0x85, 0x89, 0x89, 0x82, 0x7A, 0x76, 0x78, 0x7E, 0x83, 0x85, 0x82,
	0x7E, 0x7D, 0x7F, 0x82, 0x83, 0x81, 0x7E, 0x7B, 0x7B, 0x7E, 0x82, 0x83,
	0x81, 0x7E, 0x7C, 0x7D, 0x7F, 0x82, 0x82, 0x81, 0x7E, 0x7D, 0x7D, 0x80,
	0x81, 0x82, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x82, 0x7E, 0x86, 0x95,
	0xAF, 0xBF, 0xBC, 0xA0, 0x79, 0x5A, 0x4F, 0x5C, 0x73, 0x88, 0x8F, 0x8D,
	0x86, 0x87, 0x8B, 0x90, 0x8C, 0x80, 0x6F, 0x67, 0x69, 0x77, 0x86, 0x90,
	0x8E, 0x87, 0x7F, 0x7C, 0x7E, 0x82, 0x82, 0x7D, 0x79, 0x76, 0x7A, 0x81,
	0x8A, 0x8B, 0x87, 0x7F, 0x7A, 0x79, 0x7D, 0x81, 0x82, 0x80, 0x7D, 0x7B,
	0x7D, 0x81, 0x85, 0x85, 0x82, 0x7E, 0x7A, 0x7B, 0x7E, 0x82, 0x82, 0x81,
	0x7E, 0x7D, 0x7E, 0x80, 0x82, 0x82, 0x80, 0x7D, 0x7C, 0x7D, 0x80, 0x82,
	0x82, 0x80, 0x7F, 0x7E, 0x7E, 0x81, 0x80, 0x85, 0x8F, 0x9F, 0xAB, 0xAF,
	0xA6, 0x93, 0x7F, 0x71, 0x6E, 0x71, 0x77, 0x79, 0x7B, 0x7B, 0x80, 0x86,
	0x8C, 0x8C, 0x88, 0x80, 0x7A, 0x78, 0x7A, 0x7E, 0x7F, 0x7E, 0x7C, 0x7D,
	0x7F, 0x83, 0x85, 0x85, 0x81, 0x7E, 0x7C, 0x7D, 0x7F, 0x81, 0x80, 0x7F,
	0x7D, 0x7D, 0x80, 0x82, 0x83, 0x82, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x81,
	0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x81,
	0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x81, 0x87, 0x8F, 0x95, 0x97, 0x94, 0x90, 0x8C,
	0x8A, 0x89, 0x86, 0x81, 0x7D, 0x7A, 0x7A, 0x7D, 0x7F, 0x80, 0x7F, 0x7E,
	0x7E, 0x80, 0x82, 0x82, 0x83, 0x83, 0x85, 0x87, 0x88, 0x87, 0x86, 0x83,
	0x82, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7E, 0x80, 0x83, 0x85, 0x86, 0x87,
	0x87, 0x87, 0x87, 0x85, 0x83, 0x81, 0x80, 0x81, 0x82, 0x84, 0x84, 0x84,
	0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x83, 0x83, 0x84, 0x85, 0x84,
	0x84, 0x84, 0x83, 0x82, 0x81, 0x81, 0x81, 0x82, 0x83, 0x84, 0x85, 0x87,
	0x87, 0x87, 0x87, 0x86, 0x86, 0x85, 0x84, 0x84, 0x83, 0x83, 0x83, 0x83,
	0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x83,
	0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x82,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x80,
	0x82, 0x82, 0x81, 0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x81,
	0x81, 0x83, 0x82, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x80,
	0x7E, 0x80, 0x82, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x7D, 0x7D, 0x7E,
	0x7F, 0x80, 0x81, 0x83, 0x81, 0x81, 0x82, 0x82, 0x7F, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7D, 0x7F, 0x7F, 0x7E, 0x80, 0x81,
	0x80, 0x81, 0x83, 0x7F, 0x80, 0x82, 0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x82, 0x80,
	0x81, 0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x80,
	0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80
};
const unsigned char WAVanalog[] = {
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x8A, 0x86, 0x84, 0x86, 0x7F, 0x7B, 0x7B,
	0x7F, 0x7D, 0x80, 0x85, 0x82, 0x81, 0x80, 0x7F, 0x7B, 0x7D, 0x7F, 0x7F,
	0x81, 0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7D, 0x7F, 0x80, 0x80, 0x81, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x9E, 0x9C, 0x8C, 0x93, 0x82, 0x73,
	0x6D, 0x7B, 0x7A, 0x7F, 0x8F, 0x8C, 0x84, 0x80, 0x7E, 0x74, 0x74, 0x7F,
	0x80, 0x84, 0x8A, 0x88, 0x81, 0x7C, 0x7D, 0x77, 0x7A, 0x81, 0x82, 0x84,
	0x84, 0x83, 0x7D, 0x7D, 0x7C, 0x7C, 0x7E, 0x81, 0x83, 0x81, 0x82, 0x80,
	0x7E, 0x7D, 0x7E, 0x7E, 0x80, 0x82, 0x81, 0x81, 0x83, 0x80, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7E, 0x83, 0x7E, 0x84, 0x7C, 0xB6, 0xC2, 0x97, 0xA0, 0x84,
	0x69, 0x55, 0x74, 0x7F, 0x7E, 0x9E, 0x9C, 0x8A, 0x79, 0x7A, 0x6D, 0x67,
	0x80, 0x85, 0x82, 0x8A, 0x8C, 0x7E, 0x75, 0x7C, 0x78, 0x76, 0x82, 0x88,
	0x84, 0x83, 0x85, 0x7C, 0x78, 0x7C, 0x7D, 0x7E, 0x81, 0x87, 0x81, 0x80,
	0x80, 0x7D, 0x7B, 0x7D, 0x80, 0x80, 0x81, 0x83, 0x83, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x80, 0x80, 0x82, 0x7F, 0x85, 0x78, 0xB4, 0xD0, 0x9C, 0xA2,
	0x8D, 0x6C, 0x50, 0x70, 0x83, 0x7C, 0x9E, 0xA3, 0x8F, 0x78, 0x7C, 0x6F,
	0x63, 0x7B, 0x87, 0x8B, 0x8A, 0x92, 0x84, 0x73, 0x78, 0x75, 0x78, 0x7C,
	0x8B, 0x89, 0x84, 0x85, 0x7E, 0x78, 0x76, 0x7E, 0x7E, 0x80, 0x87, 0x85,
	0x81, 0x7E, 0x7E, 0x7B, 0x7B, 0x7E, 0x82, 0x7F, 0x78, 0x7E, 0x7C, 0x7B,
	0x7E, 0x82, 0x82, 0x7E, 0x83, 0x7E, 0x7D, 0x7D, 0x80, 0xC7, 0xCA, 0xA2,
	0xA2, 0x87, 0x64, 0x4E, 0x77, 0x7F, 0x86, 0xA1, 0xA4, 0x8F, 0x75, 0x7B,
	0x69, 0x66, 0x75, 0x88, 0x8A, 0x8A, 0x94, 0x82, 0x78, 0x73, 0x77, 0x75,
	0x7B, 0x8B, 0x87, 0x88, 0x83, 0x81, 0x78, 0x76, 0x7D, 0x7C, 0x82, 0x83,
	0x88, 0x81, 0x7F, 0x7E, 0x7B, 0x7B, 0x7E, 0x80, 0x7B, 0x7F, 0x81, 0x7F,
	0x7E, 0x81, 0x80, 0x7D, 0x7E, 0x81, 0x7D, 0x82, 0x7A, 0xA9, 0xD9, 0xB0,
	0xA3, 0x94, 0x78, 0x51, 0x63, 0x82, 0x7D, 0x96, 0xA4, 0xA0, 0x80, 0x7B,
	0x78, 0x63, 0x6A, 0x7E, 0x8A, 0x86, 0x92, 0x91, 0x7E, 0x77, 0x76, 0x76,
	0x73, 0x81, 0x89, 0x87, 0x87, 0x86, 0x80, 0x76, 0x7A, 0x7B, 0x7C, 0x80,
	0x86, 0x86, 0x81, 0x82, 0x7E, 0x7C, 0x7A, 0x7F, 0x7E, 0x7D, 0x83, 0x81,
	0x81, 0x7E, 0x80, 0x7E, 0x7B, 0x80, 0x7E, 0x81, 0x7D, 0x8F, 0xD3, 0xC2,
	0xA5, 0x9E, 0x8A, 0x60, 0x53, 0x7B, 0x7A, 0x88, 0x9D, 0xA8, 0x8B, 0x7C,
	0x7E, 0x69, 0x66, 0x75, 0x89, 0x85, 0x8E, 0x94, 0x86, 0x78, 0x75, 0x78,
	0x70, 0x7B, 0x87, 0x89, 0x86, 0x87, 0x84, 0x78, 0x78, 0x7A, 0x7C, 0x7D,
	0x85, 0x87, 0x83, 0x82, 0x80, 0x7C, 0x79, 0x7E, 0x82, 0x82, 0x84, 0x86,
	0x82, 0x7E, 0x7D, 0x7D, 0x7C, 0x7E, 0x82, 0x81, 0x84, 0x7F, 0xBD, 0xD0,
	0xAB, 0xA4, 0x97, 0x78, 0x50, 0x6E, 0x79, 0x7D, 0x91, 0xA5, 0x9B, 0x7D,
	0x82, 0x70, 0x63, 0x68, 0x81, 0x85, 0x88, 0x96, 0x8E, 0x7E, 0x75, 0x77,
	0x6F, 0x74, 0x83, 0x8A, 0x89, 0x89, 0x88, 0x7C, 0x76, 0x77, 0x79, 0x7B,
	0x82, 0x89, 0x86, 0x84, 0x80, 0x7E, 0x76, 0x7C, 0x83, 0x83, 0x85, 0x87,
	0x88, 0x7D, 0x7E, 0x7C, 0x7B, 0x7A, 0x81, 0x83, 0x83, 0x82, 0xBB, 0xD1,
	0xAE, 0xA9, 0x9E, 0x7F, 0x53, 0x6B, 0x76, 0x78, 0x8A, 0xA3, 0x9D, 0x81,
	0x84, 0x74, 0x65, 0x61, 0x79, 0x7F, 0x83, 0x93, 0x95, 0x88, 0x7B, 0x7C,
	0x72, 0x6E, 0x78, 0x83, 0x86, 0x88, 0x8D, 0x87, 0x7D, 0x7A, 0x78, 0x77,
	0x78, 0x82, 0x85, 0x86, 0x86, 0x85, 0x7F, 0x7A, 0x81, 0x80, 0x80, 0x82,
	0x87, 0x83, 0x7F, 0x81, 0x7F, 0x7C, 0x7C, 0x80, 0x80, 0x7E, 0xAE, 0xC9,
	0xB6, 0xAC, 0xA7, 0x8E, 0x63, 0x67, 0x6F, 0x70, 0x78, 0x92, 0x9B, 0x8C,
	0x8A, 0x83, 0x75, 0x66, 0x6F, 0x76, 0x79, 0x80, 0x8D, 0x8D, 0x84, 0x83,
	0x80, 0x79, 0x75, 0x7B, 0x7F, 0x80, 0x82, 0x86, 0x85, 0x80, 0x7F, 0x7F,
	0x7C, 0x7B, 0x7E, 0x81, 0x80, 0x81, 0x83, 0x81, 0x80, 0x7F, 0x80, 0x7E,
	0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x7D, 0x8C, 0xAD,
	0xB0, 0xAD, 0xA5, 0xA3, 0x8A, 0x77, 0x76, 0x75, 0x74, 0x73, 0x82, 0x82,
	0x7F, 0x7C, 0x84, 0x84, 0x7F, 0x81, 0x85, 0x85, 0x80, 0x82, 0x82, 0x81,
	0x7E, 0x7E, 0x80, 0x7F, 0x7D, 0x7E, 0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x83,
	0x9E, 0xA7, 0xAA, 0xA7, 0xA4, 0x9F, 0x90, 0x8A, 0x83, 0x81, 0x78, 0x74,
	0x72, 0x70, 0x70, 0x6E, 0x73, 0x75, 0x79, 0x7A, 0x7E, 0x82, 0x83, 0x86,
	0x85, 0x88, 0x86, 0x86, 0x85, 0x84, 0x83, 0x80, 0x80, 0x7E, 0x7E, 0x7C,
	0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x86, 0x9E, 0xA6, 0xA9, 0xA4, 0xA2, 0x9E, 0x92, 0x8A, 0x81, 0x80,
	0x78, 0x74, 0x71, 0x71, 0x73, 0x71, 0x74, 0x75, 0x7A, 0x7C, 0x7E, 0x81,
	0x82, 0x86, 0x84, 0x86, 0x85, 0x86, 0x84, 0x82, 0x82, 0x80, 0x81, 0x7E,
	0x7E, 0x7D, 0x7D, 0x7D, 0x7C, 0x7E, 0x7D, 0x7F, 0x7D, 0x7D, 0x7D, 0x7E,
	0x7F, 0x7E, 0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7E, 0x94, 0xA9, 0xAB, 0xA8, 0x9F, 0xA2, 0x99, 0x8D,
	0x7C, 0x77, 0x78, 0x75, 0x73, 0x6F, 0x77, 0x7B, 0x7E, 0x7C, 0x7D, 0x82,
	0x84, 0x84, 0x80, 0x81, 0x82, 0x83, 0x80, 0x7E, 0x7F, 0x80, 0x81, 0x7E,
	0x7E, 0x7E, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x7E, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0xA5, 0xB5, 0xB8, 0xA9,
	0x9C, 0x99, 0x8C, 0x7D, 0x68, 0x69, 0x6D, 0x79, 0x78, 0x7C, 0x82, 0x8C,
	0x8F, 0x88, 0x83, 0x7F, 0x82, 0x7D, 0x7B, 0x76, 0x7B, 0x7E, 0x81, 0x80,
	0x7F, 0x82, 0x83, 0x84, 0x7F, 0x7F, 0x7D, 0x81, 0x82, 0x82, 0x81, 0x81,
	0x82, 0x81, 0x81, 0x7E, 0x7F, 0x7D, 0x80, 0x7E, 0x80, 0x7E, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x81, 0x7E, 0x82,
	0x7D, 0x9E, 0xB6, 0xC0, 0xAF, 0x94, 0x89, 0x80, 0x7C, 0x68, 0x65, 0x67,
	0x7D, 0x87, 0x8C, 0x87, 0x8A, 0x8C, 0x8B, 0x82, 0x77, 0x75, 0x77, 0x7E,
	0x7B, 0x7E, 0x7D, 0x85, 0x86, 0x87, 0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x7C,
	0x7D, 0x7D, 0x83, 0x82, 0x82, 0x7F, 0x80, 0x80, 0x81, 0x7E, 0x7D, 0x7E,
	0x7F, 0x81, 0x80, 0x80, 0x7F, 0x81, 0x80, 0x81, 0x7E, 0x7F, 0x7E, 0x80,
	0x7F, 0x80, 0x7F, 0x81, 0x7F, 0x82, 0x7D, 0x8D, 0xB3, 0xC7, 0xC6, 0xA2,
	0x89, 0x77, 0x77, 0x6D, 0x64, 0x62, 0x72, 0x8A, 0x98, 0x98, 0x8C, 0x86,
	0x82, 0x81, 0x77, 0x6F, 0x6D, 0x77, 0x83, 0x89, 0x85, 0x80, 0x7F, 0x81,
	0x82, 0x7D, 0x78, 0x77, 0x7D, 0x83, 0x85, 0x82, 0x7F, 0x80, 0x82, 0x82,
	0x7E, 0x7B, 0x7B, 0x7F, 0x82, 0x82, 0x80, 0x7F, 0x81, 0x81, 0x81, 0x7E,
	0x7D, 0x7D, 0x7E, 0x80, 0x7F, 0x7F, 0x7E, 0x81, 0x80, 0x81, 0x7F, 0x7F,
	0x7E, 0x7F, 0x80, 0x7E, 0x9A, 0xB9, 0xCB, 0xBB, 0x9A, 0x7C, 0x6D, 0x6E,
	0x6B, 0x69, 0x69, 0x7B, 0x8F, 0x9E, 0x98, 0x88, 0x78, 0x74, 0x77, 0x78,
	0x77, 0x75, 0x7C, 0x86, 0x90, 0x8E, 0x85, 0x7A, 0x78, 0x7A, 0x7D, 0x7C,
	0x7B, 0x7C, 0x82, 0x88, 0x88, 0x83, 0x7D, 0x7A, 0x7C, 0x7F, 0x7F, 0x7E,
	0x7D, 0x80, 0x84, 0x86, 0x83, 0x7F, 0x7C, 0x7C, 0x7F, 0x80, 0x80, 0x7E,
	0x7F, 0x80, 0x83, 0x82, 0x80, 0x7D, 0x7D, 0x7F, 0x7F, 0x81, 0x7E, 0x81,
	0x7C, 0x8D, 0xAC, 0xC6, 0xC7, 0xAA, 0x87, 0x6C, 0x68, 0x6B, 0x70, 0x6F,
	0x73, 0x7F, 0x92, 0x9D, 0x98, 0x85, 0x74, 0x6C, 0x71, 0x79, 0x7D, 0x7D,
	0x7D, 0x84, 0x8C, 0x8F, 0x88, 0x7D, 0x74, 0x75, 0x7A, 0x81, 0x81, 0x80,
	0x7F, 0x82, 0x87, 0x87, 0x83, 0x7C, 0x78, 0x79, 0x7E, 0x82, 0x82, 0x80,
	0x7F, 0x80, 0x83, 0x83, 0x81, 0x7D, 0x7B, 0x7C, 0x80, 0x82, 0x82, 0x80,
	0x7F, 0x7F, 0x81, 0x81, 0x80, 0x7E, 0x7C, 0x7F, 0x81, 0x86, 0x84, 0x8B,
	0x9F, 0xB8, 0xC4, 0xB8, 0x99, 0x76, 0x64, 0x63, 0x6D, 0x75, 0x79, 0x7B,
	0x84, 0x90, 0x98, 0x94, 0x84, 0x73, 0x6B, 0x6E, 0x79, 0x81, 0x83, 0x82,
	0x82, 0x86, 0x8B, 0x8B, 0x85, 0x7A, 0x73, 0x74, 0x7A, 0x81, 0x85, 0x83,
	0x80, 0x80, 0x82, 0x84, 0x83, 0x7E, 0x7A, 0x79, 0x7C, 0x81, 0x84, 0x83,
	0x81, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x7D, 0x7C, 0x7D, 0x81, 0x83, 0x85,
	0x83, 0x80, 0x7E, 0x7D, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x7D, 0x88, 0x9D,
	0xB5, 0xC2, 0xBA, 0xA1, 0x82, 0x6D, 0x65, 0x6A, 0x70, 0x75, 0x77, 0x7D,
	0x86, 0x91, 0x97, 0x93, 0x87, 0x77, 0x6D, 0x6B, 0x72, 0x7B, 0x82, 0x83,
	0x82, 0x82, 0x84, 0x87, 0x88, 0x85, 0x7F, 0x78, 0x75, 0x77, 0x7D, 0x82,
	0x85, 0x84, 0x81, 0x7F, 0x80, 0x82, 0x82, 0x81, 0x7E, 0x7C, 0x7B, 0x7E,
	0x81, 0x84, 0x84, 0x82, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x7D, 0x7E, 0x80, 0x82, 0x82, 0x81, 0x7F, 0x7F, 0x7D, 0x82, 0x90, 0xA5,
	0xB6, 0xBC, 0xB4, 0xA0, 0x89, 0x76, 0x6D, 0x6C, 0x6F, 0x71, 0x73, 0x74,
	0x7A, 0x82, 0x8C, 0x92, 0x92, 0x8B, 0x81, 0x78, 0x74, 0x76, 0x79, 0x7D,
	0x7E, 0x7E, 0x7E, 0x80, 0x83, 0x87, 0x87, 0x86, 0x82, 0x7F, 0x7E, 0x80,
	0x82, 0x83, 0x82, 0x80, 0x7D, 0x7C, 0x7E, 0x80, 0x81, 0x82, 0x81, 0x7F,
	0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x81,
	0x81, 0x7F, 0x7D, 0x7A, 0x78, 0x77, 0x79, 0x7C, 0x7E, 0x86, 0x93, 0xA5,
	0xB2, 0xB7, 0xAD, 0x9A, 0x84, 0x72, 0x69, 0x69, 0x6D, 0x72, 0x75, 0x78,
	0x7C, 0x82, 0x8A, 0x90, 0x92, 0x8D, 0x85, 0x7C, 0x76, 0x74, 0x76, 0x79,
	0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x84, 0x87, 0x87, 0x84, 0x81, 0x7D, 0x7B,
	0x7B, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x81,
	0x7F, 0x7F, 0x7E, 0x80, 0x82, 0x83, 0x83, 0x81, 0x80, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x82, 0x89, 0x97, 0xA7,
	0xB1, 0xB1, 0xA4, 0x91, 0x7D, 0x70, 0x6C, 0x6F, 0x73, 0x77, 0x78, 0x79,
	0x7C, 0x82, 0x89, 0x8F, 0x90, 0x8C, 0x85, 0x7E, 0x7A, 0x79, 0x7B, 0x7C,
	0x7D, 0x7C, 0x7B, 0x7C, 0x7F, 0x82, 0x85, 0x86, 0x84, 0x81, 0x7F, 0x7E,
	0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x8C, 0x9F, 0xB3,
	0xBB, 0xB4, 0x9D, 0x82, 0x6D, 0x66, 0x69, 0x71, 0x76, 0x78, 0x79, 0x7D,
	0x86, 0x90, 0x96, 0x94, 0x8B, 0x7E, 0x75, 0x72, 0x75, 0x79, 0x7D, 0x7D,
	0x7D, 0x7E, 0x82, 0x88, 0x8B, 0x8A, 0x84, 0x7D, 0x78, 0x78, 0x7B, 0x7E,
	0x80, 0x80, 0x7F, 0x80, 0x81, 0x84, 0x84, 0x83, 0x7F, 0x7C, 0x7B, 0x7C,
	0x7E, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x7E, 0x7C, 0x7B,
	0x7D, 0x7F, 0x81, 0x81, 0x81, 0x7F, 0x80, 0x7E, 0x82, 0x92, 0xA9, 0xBD,
	0xBB, 0xA5, 0x81, 0x66, 0x5C, 0x66, 0x75, 0x81, 0x84, 0x84, 0x85, 0x8D,
	0x94, 0x94, 0x8B, 0x7C, 0x70, 0x6C, 0x74, 0x7E, 0x86, 0x87, 0x85, 0x82,
	0x83, 0x84, 0x84, 0x81, 0x7B, 0x76, 0x77, 0x7C, 0x82, 0x86, 0x86, 0x83,
	0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7D, 0x7C, 0x7C, 0x80, 0x83, 0x85, 0x83,
	0x80, 0x7D, 0x7C, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x82, 0x82,
	0x81, 0x7E, 0x7D, 0x7D, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x89, 0x9D, 0xB3,
	0xB5, 0xA0, 0x7C, 0x5F, 0x58, 0x68, 0x7F, 0x8D, 0x8E, 0x86, 0x84, 0x88,
	0x8F, 0x8C, 0x80, 0x6E, 0x67, 0x6D, 0x7E, 0x8C, 0x91, 0x8A, 0x80, 0x7B,
	0x7D, 0x82, 0x82, 0x7D, 0x76, 0x75, 0x7B, 0x85, 0x8A, 0x88, 0x7F, 0x79,
	0x78, 0x7E, 0x83, 0x84, 0x7F, 0x7B, 0x7B, 0x7F, 0x85, 0x86, 0x83, 0x7D,
	0x79, 0x7A, 0x80, 0x83, 0x84, 0x80, 0x7D, 0x7D, 0x80, 0x83, 0x83, 0x80,
	0x7D, 0x7B, 0x7D, 0x80, 0x82, 0x82, 0x80, 0x7E, 0x7E, 0x80, 0x83, 0x86,
	0x88, 0x86, 0x81, 0x7C, 0x79, 0x7B, 0x7E, 0x81, 0x83, 0x82, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7D, 0x7C, 0x7D, 0x80, 0x82, 0x83, 0x81, 0x7F, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x85, 0x8A, 0x8C, 0x87, 0x7F, 0x76, 0x75, 0x7B, 0x82, 0x86, 0x85, 0x81,
	0x7E, 0x7F, 0x80, 0x80, 0x7E, 0x7C, 0x7D, 0x80, 0x84, 0x84, 0x82, 0x7D,
	0x7B, 0x7C, 0x80, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7F,
	0x7D, 0x7F, 0x82, 0x84, 0x84, 0x81, 0x7D, 0x7B, 0x7C, 0x80, 0x83, 0x82,
	0x81, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x81,
	0x7F, 0x7E, 0x7D, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7D, 0x7E, 0x7E, 0x81,
	0x7F, 0x84, 0x95, 0xA7, 0xAE, 0x97, 0x75, 0x55, 0x54, 0x6D, 0x91, 0xA4,
	0x9E, 0x88, 0x71, 0x6D, 0x73, 0x7F, 0x81, 0x7F, 0x7D, 0x82, 0x8A, 0x8D,
	0x86, 0x76, 0x6D, 0x6E, 0x7E, 0x8C, 0x93, 0x8A, 0x7D, 0x74, 0x74, 0x7E,
	0x83, 0x85, 0x80, 0x7E, 0x7E, 0x83, 0x84, 0x81, 0x7C, 0x77, 0x7A, 0x81,
	0x88, 0x87, 0x82, 0x7A, 0x78, 0x7B, 0x81, 0x85, 0x84, 0x81, 0x7E, 0x7F,
	0x7F, 0x81, 0x7F, 0x7E, 0x7C, 0x80, 0x82, 0x84, 0x81, 0x7F, 0x7B, 0x7C,
	0x7E, 0x82, 0x82, 0x81, 0x97, 0xAC, 0xBE, 0xA7, 0x7C, 0x4C, 0x40, 0x5D,
	0x8C, 0xB2, 0xAE, 0x96, 0x73, 0x68, 0x6B, 0x7A, 0x7F, 0x7E, 0x7D, 0x84,
	0x91, 0x93, 0x8A, 0x73, 0x66, 0x67, 0x7C, 0x90, 0x98, 0x8E, 0x7C, 0x71,
	0x73, 0x7D, 0x85, 0x85, 0x7E, 0x7B, 0x7F, 0x87, 0x8A, 0x86, 0x7B, 0x74,
	0x76, 0x7F, 0x88, 0x8A, 0x83, 0x7B, 0x78, 0x7C, 0x81, 0x85, 0x81, 0x7D,
	0x7B, 0x7F, 0x83, 0x85, 0x81, 0x7C, 0x79, 0x7C, 0x82, 0x85, 0x84, 0x7F,
	0x7B, 0x7C, 0x80, 0x84, 0x86, 0x7E, 0x8F, 0xA7, 0xC1, 0xB6, 0x8A, 0x56,
	0x3B, 0x54, 0x83, 0xB2, 0xB3, 0x99, 0x71, 0x64, 0x6B, 0x7E, 0x86, 0x7F,
	0x78, 0x7A, 0x8C, 0x96, 0x93, 0x7A, 0x66, 0x63, 0x78, 0x92, 0x9E, 0x92,
	0x7A, 0x6B, 0x6E, 0x7F, 0x8B, 0x8A, 0x7E, 0x76, 0x7A, 0x85, 0x8C, 0x87,
	0x7A, 0x70, 0x73, 0x81, 0x8D, 0x8E, 0x83, 0x77, 0x73, 0x7B, 0x85, 0x89,
	0x83, 0x7C, 0x7B, 0x82, 0x8A, 0x89, 0x80, 0x75, 0x72, 0x7B, 0x86, 0x8D,
	0x87, 0x7E, 0x76, 0x79, 0x80, 0x85, 0x85, 0x7D, 0x91, 0xAC, 0xC8, 0xB6,
	0x86, 0x4C, 0x38, 0x58, 0x8E, 0xBA, 0xB3, 0x94, 0x6A, 0x64, 0x6D, 0x84,
	0x85, 0x7D, 0x75, 0x7D, 0x91, 0x9A, 0x91, 0x73, 0x62, 0x61, 0x7D, 0x93,
	0x9D, 0x8C, 0x78, 0x6D, 0x74, 0x84, 0x89, 0x84, 0x78, 0x76, 0x7E, 0x8C,
	0x8E, 0x84, 0x73, 0x6C, 0x74, 0x84, 0x8F, 0x8C, 0x80, 0x76, 0x77, 0x7F,
	0x86, 0x84, 0x7D, 0x78, 0x7C, 0x84, 0x89, 0x85, 0x7C, 0x76, 0x78, 0x81,
	0x86, 0x87, 0x7F, 0x7B, 0x79, 0x80, 0x83, 0x84, 0x82, 0x7F, 0x9B, 0xB4,
	0xC4, 0xA3, 0x73, 0x4A, 0x4D, 0x75, 0x9B, 0xAD, 0x97, 0x83, 0x72, 0x7C,
	0x80, 0x7F, 0x72, 0x6E, 0x7B, 0x90, 0x9E, 0x92, 0x7C, 0x66, 0x69, 0x79,
	0x8C, 0x8F, 0x84, 0x7B, 0x79, 0x82, 0x85, 0x82, 0x77, 0x74, 0x7B, 0x87,
	0x8E, 0x87, 0x7D, 0x74, 0x79, 0x80, 0x86, 0x83, 0x7E, 0x7B, 0x7F, 0x84,
	0x84, 0x80, 0x79, 0x7A, 0x7D, 0x85, 0x85, 0x82, 0x7C, 0x7C, 0x7E, 0x82,
	0x82, 0x7F, 0x7C, 0x7E, 0x81, 0x84, 0x81, 0x7E, 0x7B, 0x7E, 0x80, 0x83,
	0x9F, 0xB2, 0xBA, 0x98, 0x6F, 0x53, 0x5B, 0x7C, 0x94, 0x9E, 0x8D, 0x87,
	0x80, 0x85, 0x7D, 0x72, 0x6B, 0x73, 0x88, 0x94, 0x96, 0x83, 0x77, 0x71,
	0x7A, 0x80, 0x81, 0x7F, 0x7D, 0x85, 0x88, 0x88, 0x7D, 0x76, 0x75, 0x7C,
	0x85, 0x86, 0x84, 0x7E, 0x7E, 0x80, 0x82, 0x7F, 0x7C, 0x7B, 0x7F, 0x84,
	0x84, 0x81, 0x7D, 0x7C, 0x7E, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x82, 0x82,
	0x80, 0x7E, 0x7D, 0x7F, 0x80, 0x82, 0x7F, 0x7F, 0x7E, 0x81, 0x80, 0x81,
	0x7D, 0x82, 0xA2, 0xB4, 0xB5, 0x8C, 0x67, 0x59, 0x6A, 0x87, 0x8F, 0x8F,
	0x85, 0x8B, 0x8E, 0x89, 0x77, 0x68, 0x6D, 0x7C, 0x90, 0x91, 0x88, 0x7E,
	0x7B, 0x7F, 0x7E, 0x7B, 0x76, 0x7B, 0x84, 0x8B, 0x88, 0x7E, 0x79, 0x79,
	0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x84, 0x85, 0x81, 0x7C, 0x7A, 0x7D, 0x80,
	0x83, 0x80, 0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x7D, 0x7C, 0x80, 0x81, 0x82,
	0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7E, 0x9B, 0xAF, 0xB4, 0x95, 0x6C, 0x61, 0x69, 0x84,
	0x88, 0x89, 0x87, 0x8D, 0x94, 0x88, 0x79, 0x69, 0x6E, 0x7C, 0x87, 0x8A,
	0x84, 0x85, 0x85, 0x83, 0x7C, 0x73, 0x76, 0x7D, 0x86, 0x87, 0x83, 0x81,
	0x80, 0x81, 0x7D, 0x7B, 0x7A, 0x7E, 0x83, 0x84, 0x83, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7C, 0x7F, 0x81, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7E,
	0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x81, 0x80, 0x81, 0x7F, 0x80, 0x7D, 0x86, 0xAB, 0xB0, 0xA3, 0x84, 0x71,
	0x7A, 0x77, 0x77, 0x75, 0x80, 0x96, 0x96, 0x8E, 0x7E, 0x79, 0x7E, 0x78,
	0x77, 0x77, 0x80, 0x8C, 0x8A, 0x86, 0x7F, 0x7E, 0x80, 0x7A, 0x7A, 0x7A,
	0x81, 0x86, 0x81, 0x7F, 0x7F, 0x80, 0x81, 0x7B, 0x7C, 0x7F, 0x80, 0x82,
	0x7F, 0x80, 0x82, 0x80, 0x80, 0x7D, 0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x7C, 0x7C, 0x7E, 0x7E,
	0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x7D, 0x9A, 0xB0,
	0xA5, 0x99, 0x8A, 0x88, 0x83, 0x6D, 0x6C, 0x76, 0x82, 0x8B, 0x86, 0x8A,
	0x91, 0x89, 0x81, 0x79, 0x77, 0x7C, 0x77, 0x78, 0x7F, 0x84, 0x87, 0x84,
	0x82, 0x85, 0x81, 0x7C, 0x7B, 0x7B, 0x7E, 0x7E, 0x7D, 0x81, 0x83, 0x83,
	0x82, 0x80, 0x80, 0x7F, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7E, 0x89, 0xA0, 0x9E, 0x99, 0xA3, 0xA1, 0x94, 0x8A, 0x80, 0x7E, 0x79,
	0x6E, 0x73, 0x7B, 0x7B, 0x7D, 0x83, 0x86, 0x89, 0x84, 0x82, 0x84, 0x80,
	0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7C, 0x81, 0x83, 0x7E, 0x7F, 0x82, 0x7F,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x83, 0x8A, 0x8A, 0x8C, 0x92, 0x91, 0x8E,
	0x8F, 0x8C, 0x88, 0x85, 0x81, 0x7E, 0x7C, 0x79, 0x79, 0x7A, 0x79, 0x79,
	0x7B, 0x7B, 0x7C, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81,
	0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x82, 0x82,
	0x84, 0x86, 0x86, 0x87, 0x88, 0x88, 0x87, 0x87, 0x86, 0x85, 0x84, 0x82,
	0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x83,
	0x83, 0x83, 0x83, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x81, 0x7F,
	0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7E,
	0x7E, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7E, 0x80, 0x80, 0x81,
	0x7E, 0x7E, 0x81, 0x7F, 0x7F, 0x81, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x7E,
	0x80, 0x80, 0x7E, 0x80, 0x82, 0x7D, 0x7E, 0x83, 0x7E, 0x7D, 0x83, 0x80,
	0x7D, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x80, 0x82, 0x7E, 0x7F, 0x83, 0x7E,
	0x7F, 0x81, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x82, 0x80, 0x7E, 0x7E,
	0x83, 0x7F, 0x7C, 0x82, 0x7F, 0x7D, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7E,
	0x80, 0x80, 0x7E, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x81, 0x80,
	0x81, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x81, 0x7F, 0x81, 0x81,
	0x7D, 0x81, 0x81, 0x7C, 0x7E, 0x7F, 0x7E, 0x7E, 0x81, 0x7F, 0x7E, 0x81,
	0x7F, 0x7E, 0x80, 0x82, 0x7F, 0x81, 0x81, 0x7F, 0x80, 0x82, 0x7F, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x80,
	0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E,
	0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x81, 0x81, 0x7E, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81,
	0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80
};
const unsigned char WAVand[] = {
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x83, 0x81,
	0x82, 0x82, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x88, 0x8A, 0x84, 0x8B,
	0x82, 0x7C, 0x7D, 0x7C, 0x7A, 0x7F, 0x84, 0x81, 0x84, 0x83, 0x7E, 0x7D,
	0x7D, 0x7C, 0x7D, 0x81, 0x81, 0x81, 0x83, 0x80, 0x7E, 0x7E, 0x7E, 0x7D,
	0x7F, 0x80, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x81,
	0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7C, 0x8C, 0x9C, 0x8A, 0x96, 0x8D,
	0x79, 0x77, 0x76, 0x74, 0x76, 0x88, 0x85, 0x86, 0x8B, 0x81, 0x7A, 0x7A,
	0x7A, 0x77, 0x80, 0x85, 0x82, 0x86, 0x84, 0x7E, 0x7C, 0x7D, 0x7A, 0x7D,
	0x83, 0x82, 0x84, 0x84, 0x81, 0x7D, 0x7E, 0x7C, 0x7D, 0x7F, 0x82, 0x81,
	0x82, 0x82, 0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x81, 0x80, 0x82, 0x81, 0x81,
	0x7F, 0x80, 0x7D, 0x7F, 0x7E, 0x80, 0x78, 0x95, 0xB0, 0x91, 0xA5, 0x96,
	0x74, 0x6F, 0x70, 0x6B, 0x70, 0x8E, 0x8A, 0x8A, 0x93, 0x83, 0x75, 0x77,
	0x75, 0x72, 0x7F, 0x89, 0x85, 0x89, 0x89, 0x7D, 0x79, 0x7B, 0x77, 0x77,
	0x80, 0x82, 0x81, 0x87, 0x84, 0x7E, 0x7E, 0x7D, 0x7B, 0x7C, 0x82, 0x80,
	0x82, 0x85, 0x80, 0x7E, 0x7F, 0x7C, 0x7D, 0x7E, 0x82, 0x7F, 0x83, 0x81,
	0x80, 0x7E, 0x7F, 0x7E, 0x7D, 0x82, 0x7E, 0x81, 0x82, 0x7E, 0x84, 0xC6,
	0xAA, 0x9E, 0xB3, 0x77, 0x65, 0x68, 0x68, 0x63, 0x88, 0x99, 0x89, 0x98,
	0x8F, 0x73, 0x70, 0x75, 0x6D, 0x77, 0x8D, 0x89, 0x89, 0x90, 0x80, 0x75,
	0x7A, 0x76, 0x74, 0x82, 0x86, 0x83, 0x88, 0x86, 0x7D, 0x7A, 0x7D, 0x78,
	0x7B, 0x83, 0x82, 0x82, 0x85, 0x82, 0x7C, 0x7F, 0x7C, 0x7C, 0x7F, 0x81,
	0x81, 0x82, 0x83, 0x7E, 0x7F, 0x7F, 0x7B, 0x80, 0x7E, 0x82, 0x7E, 0x85,
	0x7E, 0x82, 0x7D, 0x8A, 0xCE, 0xA1, 0xA8, 0xAC, 0x71, 0x66, 0x67, 0x6A,
	0x66, 0x91, 0x98, 0x8B, 0x9A, 0x89, 0x72, 0x70, 0x74, 0x6D, 0x7A, 0x90,
	0x88, 0x8C, 0x8E, 0x80, 0x75, 0x7A, 0x76, 0x74, 0x84, 0x86, 0x84, 0x89,
	0x85, 0x7B, 0x7D, 0x7A, 0x7A, 0x7C, 0x82, 0x83, 0x82, 0x86, 0x7F, 0x7E,
	0x7D, 0x7C, 0x7D, 0x7E, 0x84, 0x7A, 0x81, 0x7F, 0x7D, 0x7E, 0x80, 0x80,
	0x7E, 0x83, 0x7F, 0x7F, 0x81, 0x7E, 0x7E, 0x81, 0x7F, 0xC9, 0xB5, 0x9C,
	0xB9, 0x7A, 0x62, 0x65, 0x6C, 0x63, 0x88, 0xA0, 0x8C, 0x98, 0x91, 0x72,
	0x6B, 0x75, 0x6D, 0x76, 0x8D, 0x8E, 0x87, 0x8F, 0x83, 0x74, 0x77, 0x79,
	0x74, 0x7F, 0x8A, 0x83, 0x87, 0x87, 0x7D, 0x7A, 0x7C, 0x7A, 0x7A, 0x83,
	0x82, 0x83, 0x83, 0x82, 0x7D, 0x78, 0x7B, 0x7A, 0x7C, 0x81, 0x84, 0x82,
	0x83, 0x81, 0x7E, 0x7C, 0x7E, 0x7C, 0x7F, 0x80, 0x83, 0x7F, 0x83, 0x7D,
	0x81, 0x79, 0x96, 0xD7, 0x9C, 0xB0, 0xA8, 0x69, 0x62, 0x67, 0x6C, 0x65,
	0xA0, 0x97, 0x8F, 0x9A, 0x85, 0x6F, 0x6A, 0x79, 0x6A, 0x7F, 0x91, 0x89,
	0x8B, 0x8B, 0x7F, 0x70, 0x7B, 0x76, 0x77, 0x86, 0x85, 0x87, 0x84, 0x86,
	0x7B, 0x79, 0x7E, 0x77, 0x80, 0x7C, 0x7C, 0x81, 0x7C, 0x81, 0x7D, 0x82,
	0x7D, 0x80, 0x80, 0x7D, 0x81, 0x7E, 0x81, 0x7D, 0x82, 0x7E, 0x80, 0x7F,
	0x80, 0x7E, 0x80, 0x7E, 0x81, 0x7E, 0x82, 0x7B, 0x98, 0xDA, 0x9D, 0xAC,
	0xA9, 0x67, 0x5F, 0x68, 0x6F, 0x67, 0x9F, 0x9B, 0x8D, 0x97, 0x86, 0x6E,
	0x69, 0x7A, 0x6D, 0x7F, 0x91, 0x8C, 0x88, 0x8A, 0x7F, 0x70, 0x7A, 0x77,
	0x79, 0x83, 0x89, 0x86, 0x83, 0x85, 0x7A, 0x79, 0x7C, 0x7C, 0x7E, 0x82,
	0x86, 0x81, 0x82, 0x81, 0x7B, 0x7C, 0x7E, 0x7D, 0x80, 0x82, 0x82, 0x80,
	0x82, 0x7E, 0x7D, 0x7E, 0x7F, 0x7D, 0x81, 0x81, 0x80, 0x80, 0x81, 0x7A,
	0x78, 0x80, 0x7A, 0xCF, 0xBC, 0x9F, 0xBB, 0x7E, 0x60, 0x5C, 0x73, 0x5E,
	0x89, 0xA5, 0x90, 0x98, 0x8E, 0x7B, 0x62, 0x75, 0x71, 0x72, 0x8D, 0x8F,
	0x8B, 0x89, 0x87, 0x75, 0x72, 0x82, 0x79, 0x81, 0x8C, 0x89, 0x80, 0x83,
	0x81, 0x73, 0x7D, 0x7D, 0x7E, 0x81, 0x87, 0x83, 0x7F, 0x83, 0x7C, 0x7B,
	0x7C, 0x81, 0x7E, 0x82, 0x84, 0x80, 0x80, 0x80, 0x7E, 0x7C, 0x80, 0x81,
	0x80, 0x84, 0x81, 0x82, 0x7E, 0x80, 0x7E, 0x7C, 0x83, 0x7A, 0xCA, 0xC3,
	0x9A, 0xBB, 0x85, 0x60, 0x5B, 0x75, 0x61, 0x80, 0xA9, 0x8F, 0x96, 0x8F,
	0x7F, 0x61, 0x75, 0x73, 0x71, 0x89, 0x8E, 0x8C, 0x83, 0x8B, 0x75, 0x73,
	0x7A, 0x77, 0x7E, 0x83, 0x8C, 0x81, 0x86, 0x82, 0x78, 0x7B, 0x7B, 0x7D,
	0x7E, 0x85, 0x83, 0x82, 0x82, 0x7D, 0x7F, 0x79, 0x80, 0x7D, 0x80, 0x83,
	0x7D, 0x82, 0x7D, 0x80, 0x7C, 0x80, 0x7E, 0x80, 0x81, 0x80, 0x81, 0x80,
	0x7E, 0x80, 0x7D, 0x82, 0x79, 0x9A, 0xDA, 0xA0, 0xAF, 0xA9, 0x6D, 0x5C,
	0x67, 0x71, 0x63, 0x9E, 0x9B, 0x91, 0x96, 0x89, 0x72, 0x65, 0x79, 0x6E,
	0x7B, 0x8E, 0x90, 0x88, 0x88, 0x86, 0x70, 0x76, 0x7A, 0x77, 0x80, 0x89,
	0x89, 0x82, 0x86, 0x7E, 0x78, 0x7A, 0x7D, 0x7D, 0x7F, 0x88, 0x82, 0x86,
	0x85, 0x7E, 0x7F, 0x7B, 0x7E, 0x7B, 0x82, 0x80, 0x82, 0x83, 0x80, 0x81,
	0x7C, 0x81, 0x7B, 0x80, 0x7F, 0x82, 0x80, 0x82, 0x7F, 0x80, 0x7D, 0x82,
	0x78, 0xA4, 0xD8, 0x9C, 0xB4, 0xA1, 0x6B, 0x59, 0x67, 0x6E, 0x63, 0xA0,
	0x9A, 0x92, 0x94, 0x8A, 0x6F, 0x64, 0x7B, 0x6A, 0x7F, 0x8D, 0x90, 0x8A,
	0x86, 0x87, 0x6D, 0x78, 0x76, 0x79, 0x80, 0x87, 0x8C, 0x7F, 0x8A, 0x7E,
	0x7D, 0x7A, 0x7E, 0x7E, 0x7D, 0x87, 0x80, 0x84, 0x80, 0x80, 0x7D, 0x7B,
	0x81, 0x7B, 0x82, 0x80, 0x82, 0x81, 0x7F, 0x82, 0x7B, 0x81, 0x7C, 0x82,
	0x7E, 0x81, 0x82, 0x7E, 0x82, 0x75, 0x75, 0x7B, 0x75, 0x8C, 0xDA, 0xB5,
	0xAC, 0xB9, 0x7F, 0x5E, 0x5A, 0x71, 0x59, 0x86, 0xA1, 0x96, 0x96, 0x92,
	0x83, 0x61, 0x73, 0x6F, 0x70, 0x83, 0x90, 0x90, 0x85, 0x8F, 0x7A, 0x6E,
	0x76, 0x73, 0x78, 0x7E, 0x8F, 0x85, 0x86, 0x89, 0x7C, 0x79, 0x77, 0x7D,
	0x77, 0x83, 0x85, 0x84, 0x84, 0x83, 0x80, 0x79, 0x7E, 0x7C, 0x7C, 0x80,
	0x82, 0x83, 0x80, 0x83, 0x7F, 0x7D, 0x7F, 0x7E, 0x7F, 0x7E, 0x83, 0x7F,
	0x82, 0x7F, 0x81, 0x7C, 0x83, 0x78, 0xAA, 0xD3, 0xA6, 0xBC, 0xA7, 0x7F,
	0x5D, 0x6A, 0x68, 0x5D, 0x8F, 0x94, 0x97, 0x92, 0x99, 0x7C, 0x6B, 0x76,
	0x6A, 0x71, 0x7C, 0x8F, 0x87, 0x8C, 0x90, 0x7E, 0x7A, 0x77, 0x79, 0x72,
	0x7F, 0x84, 0x83, 0x88, 0x86, 0x83, 0x7B, 0x7E, 0x7A, 0x79, 0x7E, 0x81,
	0x82, 0x82, 0x85, 0x81, 0x7E, 0x81, 0x81, 0x7D, 0x81, 0x82, 0x80, 0x80,
	0x82, 0x7F, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7E, 0x80, 0x80, 0xC3, 0xC0, 0xAD, 0xBD, 0x9E, 0x7B, 0x60, 0x74, 0x5C,
	0x6A, 0x8B, 0x92, 0x92, 0x95, 0x9B, 0x77, 0x77, 0x73, 0x6D, 0x6D, 0x7E,
	0x89, 0x83, 0x91, 0x8C, 0x84, 0x7B, 0x7C, 0x76, 0x72, 0x7E, 0x7F, 0x84,
	0x85, 0x8A, 0x82, 0x7F, 0x7F, 0x7B, 0x7A, 0x7B, 0x81, 0x7E, 0x83, 0x84,
	0x82, 0x81, 0x7E, 0x80, 0x7A, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x83, 0x7F,
	0x82, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x81, 0x80, 0x81, 0x80, 0x83,
	0xB7, 0xBA, 0xAC, 0xBA, 0xA6, 0x89, 0x6E, 0x76, 0x64, 0x63, 0x7C, 0x86,
	0x8C, 0x90, 0x9D, 0x8A, 0x80, 0x80, 0x75, 0x6E, 0x73, 0x7D, 0x7C, 0x83,
	0x8C, 0x89, 0x84, 0x84, 0x81, 0x7A, 0x7C, 0x7C, 0x7D, 0x7E, 0x82, 0x83,
	0x82, 0x83, 0x82, 0x81, 0x7E, 0x7F, 0x7E, 0x7D, 0x7E, 0x80, 0x80, 0x80,
	0x82, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x81,
	0x82, 0x81, 0x82, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0xA2, 0xB0, 0xA4,
	0xAF, 0xA3, 0x93, 0x7D, 0x7C, 0x75, 0x67, 0x74, 0x79, 0x7F, 0x82, 0x8E,
	0x92, 0x89, 0x8D, 0x88, 0x80, 0x79, 0x7A, 0x79, 0x73, 0x78, 0x7A, 0x7B,
	0x7D, 0x81, 0x85, 0x82, 0x85, 0x85, 0x82, 0x81, 0x80, 0x80, 0x7C, 0x7D,
	0x7E, 0x7D, 0x7D, 0x7E, 0x80, 0x7F, 0x80, 0x82, 0x81, 0x81, 0x81, 0x80,
	0x7D, 0x7D, 0x7E, 0x7C, 0x7D, 0x7D, 0x7E, 0x7D, 0x7E, 0x80, 0x7F, 0x80,
	0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x92, 0xA0, 0x9D, 0xA4, 0x9F, 0x99,
	0x91, 0x8D, 0x8E, 0x82, 0x7E, 0x7A, 0x74, 0x71, 0x71, 0x77, 0x76, 0x78,
	0x7E, 0x7F, 0x82, 0x85, 0x8A, 0x8B, 0x8A, 0x8B, 0x89, 0x86, 0x85, 0x83,
	0x81, 0x7D, 0x7C, 0x7B, 0x78, 0x79, 0x7A, 0x7B, 0x7B, 0x7D, 0x7F, 0x7F,
	0x7F, 0x81, 0x81, 0x82, 0x81, 0x82, 0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7D, 0x7C, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x80, 0x86, 0x93, 0x93, 0x96, 0x99, 0x94, 0x93, 0x90, 0x92,
	0x90, 0x89, 0x87, 0x80, 0x7B, 0x79, 0x79, 0x7B, 0x79, 0x7B, 0x7B, 0x7C,
	0x7F, 0x83, 0x87, 0x88, 0x89, 0x89, 0x88, 0x88, 0x87, 0x87, 0x85, 0x82,
	0x80, 0x7D, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7F, 0x81,
	0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x80, 0x7F, 0x7E,
	0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7D, 0x7F, 0x7F, 0x80, 0x81,
	0x81, 0x82, 0x89, 0x8F, 0x90, 0x94, 0x93, 0x91, 0x8F, 0x8D, 0x8E, 0x8B,
	0x89, 0x85, 0x80, 0x7D, 0x7A, 0x7A, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7F,
	0x82, 0x85, 0x88, 0x89, 0x89, 0x89, 0x89, 0x88, 0x88, 0x87, 0x85, 0x83,
	0x80, 0x7E, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7F, 0x81,
	0x82, 0x83, 0x84, 0x84, 0x84, 0x85, 0x85, 0x85, 0x84, 0x83, 0x81, 0x80,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x80,
	0x81, 0x87, 0x8B, 0x8E, 0x92, 0x92, 0x91, 0x8F, 0x8E, 0x8E, 0x8C, 0x8A,
	0x87, 0x82, 0x7F, 0x7B, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x7A, 0x7C,
	0x7F, 0x81, 0x84, 0x86, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x86, 0x84,
	0x82, 0x80, 0x7E, 0x7D, 0x7C, 0x7C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C,
	0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83,
	0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x80, 0x83, 0x86, 0x89, 0x8B, 0x8B, 0x8B, 0x8B, 0x8B, 0x8A, 0x8A, 0x89,
	0x87, 0x85, 0x82, 0x80, 0x7E, 0x7D, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C,
	0x7D, 0x7E, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83,
	0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x81, 0x83, 0x84, 0x86, 0x86, 0x86, 0x85, 0x84, 0x84, 0x83, 0x83, 0x82,
	0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81,
	0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7E, 0x7D, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7D, 0x7E, 0x80, 0x7F, 0x80, 0x82, 0x82, 0x82, 0x83, 0x82, 0x80, 0x80,
	0x7F, 0x7E, 0x7F, 0x7F, 0x81, 0x81, 0x82, 0x81, 0x7E, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x83, 0x82, 0x81,
	0x81, 0x80, 0x7F, 0x7D, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x82, 0x81, 0x82, 0x82, 0x7F, 0x80, 0x7F, 0x7E, 0x7C, 0x7D, 0x7E, 0x7D,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82,
	0x80, 0x81, 0x81, 0x80, 0x7F, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7E,
	0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x81,
	0x81, 0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80,
	0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVasr[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x84, 0x8D, 0x86,
	0x93, 0x8D, 0x85, 0x8A, 0x7C, 0x79, 0x79, 0x76, 0x76, 0x7E, 0x7C, 0x80,
	0x87, 0x81, 0x84, 0x83, 0x7D, 0x7F, 0x7D, 0x7B, 0x7E, 0x80, 0x7E, 0x81,
	0x82, 0x7E, 0x81, 0x7F, 0x7D, 0x80, 0x7E, 0x7E, 0x81, 0x7F, 0x80, 0x82,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x81, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x9A, 0x8F, 0x98, 0xA5, 0x89,
	0x92, 0x83, 0x71, 0x73, 0x6F, 0x68, 0x77, 0x7C, 0x7A, 0x8D, 0x86, 0x86,
	0x8B, 0x7F, 0x7E, 0x7E, 0x78, 0x79, 0x80, 0x7C, 0x82, 0x86, 0x80, 0x87,
	0x82, 0x7F, 0x82, 0x7C, 0x7B, 0x7F, 0x7C, 0x7E, 0x82, 0x7E, 0x82, 0x83,
	0x7E, 0x82, 0x80, 0x7D, 0x80, 0x7E, 0x7D, 0x81, 0x7E, 0x80, 0x82, 0x7F,
	0x81, 0x80, 0x7F, 0x7F, 0x9B, 0x8F, 0x9C, 0xAA, 0x8C, 0x9B, 0x87, 0x75,
	0x77, 0x6B, 0x65, 0x74, 0x72, 0x76, 0x8B, 0x80, 0x8A, 0x8E, 0x80, 0x86,
	0x80, 0x77, 0x7E, 0x7B, 0x77, 0x84, 0x7E, 0x81, 0x88, 0x80, 0x82, 0x82,
	0x7A, 0x7D, 0x7C, 0x78, 0x7F, 0x7E, 0x7E, 0x84, 0x82, 0x82, 0x85, 0x7F,
	0x80, 0x80, 0x7C, 0x7F, 0x7E, 0x7D, 0x81, 0x7E, 0x81, 0x80, 0x82, 0x7D,
	0x8D, 0x9E, 0x8C, 0xAF, 0x9C, 0x92, 0x9D, 0x7A, 0x7A, 0x75, 0x63, 0x6B,
	0x72, 0x6A, 0x81, 0x82, 0x80, 0x92, 0x86, 0x86, 0x8A, 0x7B, 0x7E, 0x7E,
	0x74, 0x7E, 0x7D, 0x7A, 0x86, 0x81, 0x81, 0x87, 0x7E, 0x82, 0x80, 0x7A,
	0x7E, 0x7C, 0x79, 0x81, 0x7D, 0x7F, 0x84, 0x7E, 0x83, 0x82, 0x7F, 0x81,
	0x80, 0x7C, 0x82, 0x7C, 0x7F, 0x7F, 0x80, 0x7C, 0x94, 0x9A, 0x91, 0xBB,
	0x93, 0xA2, 0x9D, 0x78, 0x87, 0x6C, 0x63, 0x6C, 0x64, 0x68, 0x7E, 0x73,
	0x86, 0x8F, 0x81, 0x95, 0x87, 0x81, 0x8A, 0x76, 0x7C, 0x7D, 0x74, 0x7E,
	0x7E, 0x7A, 0x87, 0x81, 0x81, 0x88, 0x7D, 0x82, 0x81, 0x7A, 0x80, 0x7E,
	0x7A, 0x85, 0x7C, 0x80, 0x85, 0x7D, 0x83, 0x83, 0x7B, 0x85, 0x7C, 0x7E,
	0x80, 0x7E, 0x7B, 0x90, 0x9A, 0x8D, 0xBC, 0x95, 0xA7, 0xA7, 0x7E, 0x94,
	0x72, 0x69, 0x71, 0x61, 0x65, 0x79, 0x69, 0x84, 0x89, 0x7D, 0x9A, 0x85,
	0x88, 0x91, 0x78, 0x84, 0x7E, 0x71, 0x82, 0x77, 0x77, 0x87, 0x77, 0x84,
	0x87, 0x7A, 0x8B, 0x80, 0x7C, 0x88, 0x78, 0x7E, 0x83, 0x74, 0x86, 0x81,
	0x7B, 0x8F, 0x7B, 0x88, 0x88, 0x7B, 0x88, 0x7E, 0x79, 0x85, 0x96, 0x84,
	0xAE, 0x9F, 0x9A, 0xB7, 0x84, 0x9E, 0x84, 0x6E, 0x7D, 0x60, 0x66, 0x6E,
	0x63, 0x74, 0x7D, 0x75, 0x8E, 0x87, 0x86, 0x97, 0x7F, 0x8C, 0x87, 0x77,
	0x88, 0x75, 0x7B, 0x80, 0x75, 0x80, 0x81, 0x79, 0x87, 0x80, 0x7D, 0x89,
	0x79, 0x83, 0x81, 0x78, 0x85, 0x7B, 0x7C, 0x84, 0x79, 0x83, 0x7F, 0x7D,
	0x83, 0x7E, 0x7A, 0x91, 0x90, 0x8F, 0xB4, 0x93, 0xAF, 0xA6, 0x8C, 0xA2,
	0x78, 0x7D, 0x76, 0x60, 0x6C, 0x66, 0x62, 0x76, 0x70, 0x79, 0x8B, 0x7C,
	0x91, 0x8C, 0x83, 0x93, 0x7E, 0x85, 0x84, 0x76, 0x82, 0x7A, 0x77, 0x82,
	0x78, 0x7F, 0x84, 0x7A, 0x87, 0x80, 0x7F, 0x86, 0x7B, 0x81, 0x81, 0x7A,
	0x83, 0x7C, 0x7D, 0x82, 0x7C, 0x80, 0x84, 0x77, 0x98, 0x8F, 0x91, 0xBA,
	0x8E, 0xB9, 0xA2, 0x91, 0xA7, 0x75, 0x84, 0x73, 0x61, 0x6D, 0x63, 0x60,
	0x75, 0x69, 0x78, 0x87, 0x77, 0x94, 0x87, 0x87, 0x95, 0x7E, 0x8C, 0x84,
	0x79, 0x85, 0x78, 0x7A, 0x82, 0x77, 0x81, 0x81, 0x7B, 0x87, 0x7F, 0x80,
	0x87, 0x7A, 0x84, 0x7F, 0x7B, 0x83, 0x7B, 0x7E, 0x81, 0x7B, 0x82, 0x80,
	0x7F, 0x9D, 0x85, 0xA8, 0xA6, 0x96, 0xB9, 0x8B, 0x9E, 0x8C, 0x77, 0x81,
	0x68, 0x6B, 0x6B, 0x66, 0x6D, 0x76, 0x71, 0x82, 0x82, 0x81, 0x91, 0x82,
	0x8C, 0x8A, 0x7F, 0x8A, 0x7C, 0x7F, 0x80, 0x79, 0x7E, 0x7E, 0x7A, 0x81,
	0x7F, 0x7D, 0x85, 0x7B, 0x84, 0x80, 0x7D, 0x84, 0x7D, 0x80, 0x80, 0x7D,
	0x80, 0x80, 0x7E, 0x82, 0x7E, 0x97, 0x8B, 0x9C, 0xAB, 0x92, 0xB3, 0x92,
	0x94, 0x93, 0x72, 0x7F, 0x69, 0x65, 0x6B, 0x64, 0x69, 0x76, 0x71, 0x81,
	0x85, 0x81, 0x92, 0x85, 0x8B, 0x8C, 0x80, 0x88, 0x7F, 0x7C, 0x81, 0x79,
	0x7C, 0x7F, 0x79, 0x80, 0x7F, 0x7C, 0x85, 0x7D, 0x81, 0x82, 0x7D, 0x82,
	0x7F, 0x7E, 0x81, 0x7E, 0x7F, 0x83, 0x7C, 0x85, 0x7C, 0x95, 0x8F, 0x96,
	0xAE, 0x90, 0xAE, 0x97, 0x8D, 0x95, 0x72, 0x7A, 0x6D, 0x62, 0x6B, 0x65,
	0x69, 0x75, 0x75, 0x7E, 0x89, 0x83, 0x90, 0x8B, 0x88, 0x8E, 0x81, 0x88,
	0x81, 0x7F, 0x81, 0x7C, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7D, 0x80, 0x7E, 0x7F, 0x81, 0x7E, 0x81, 0x80, 0x80, 0x82, 0x7F, 0x82,
	0x7E, 0x86, 0x98, 0x87, 0xAB, 0x9C, 0x9A, 0xAE, 0x85, 0x99, 0x82, 0x71,
	0x78, 0x62, 0x65, 0x6A, 0x63, 0x6F, 0x79, 0x75, 0x88, 0x88, 0x86, 0x95,
	0x86, 0x8C, 0x8C, 0x7E, 0x87, 0x7D, 0x79, 0x80, 0x78, 0x7B, 0x80, 0x79,
	0x80, 0x81, 0x7B, 0x84, 0x7F, 0x7E, 0x85, 0x7B, 0x81, 0x81, 0x7C, 0x83,
	0x7F, 0x7E, 0x84, 0x7C, 0x82, 0x7F, 0x86, 0x97, 0x89, 0xA8, 0x9C, 0x9A,
	0xA7, 0x86, 0x92, 0x7D, 0x71, 0x73, 0x64, 0x69, 0x6B, 0x6D, 0x74, 0x7F,
	0x7E, 0x88, 0x8B, 0x85, 0x8F, 0x84, 0x85, 0x85, 0x7B, 0x81, 0x7C, 0x7C,
	0x7F, 0x7D, 0x7E, 0x81, 0x7E, 0x80, 0x81, 0x7D, 0x80, 0x7F, 0x7C, 0x80,
	0x7C, 0x7F, 0x7F, 0x7E, 0x81, 0x80, 0x80, 0x82, 0x80, 0x81, 0x80, 0x81,
	0x99, 0x8B, 0xA1, 0xA7, 0x93, 0xA8, 0x8A, 0x86, 0x81, 0x68, 0x6E, 0x65,
	0x62, 0x6D, 0x70, 0x75, 0x85, 0x84, 0x89, 0x92, 0x86, 0x8B, 0x88, 0x7D,
	0x83, 0x7B, 0x7A, 0x7F, 0x7B, 0x7E, 0x82, 0x7E, 0x82, 0x82, 0x7D, 0x81,
	0x7E, 0x7C, 0x7F, 0x7D, 0x7D, 0x81, 0x7E, 0x81, 0x82, 0x80, 0x81, 0x7F,
	0x7E, 0x7E, 0x7B, 0x7F, 0x79, 0x8C, 0x9B, 0x90, 0xB0, 0xA2, 0x99, 0xA0,
	0x80, 0x7B, 0x72, 0x62, 0x63, 0x69, 0x68, 0x75, 0x81, 0x81, 0x8D, 0x8E,
	0x88, 0x8C, 0x83, 0x7E, 0x7F, 0x7B, 0x7C, 0x7F, 0x80, 0x80, 0x86, 0x82,
	0x81, 0x82, 0x7C, 0x7D, 0x7C, 0x7A, 0x7C, 0x7E, 0x7E, 0x81, 0x83, 0x82,
	0x83, 0x82, 0x80, 0x80, 0x7E, 0x7E, 0x7D, 0x80, 0x7D, 0x81, 0x7F, 0x8C,
	0xA3, 0x92, 0xAC, 0xA8, 0x8F, 0x97, 0x7E, 0x6E, 0x6B, 0x66, 0x61, 0x6D,
	0x79, 0x78, 0x8A, 0x8D, 0x87, 0x8D, 0x85, 0x7D, 0x7E, 0x7B, 0x77, 0x7D,
	0x80, 0x7E, 0x87, 0x85, 0x84, 0x89, 0x81, 0x81, 0x80, 0x7C, 0x7C, 0x7C,
	0x7E, 0x7D, 0x81, 0x81, 0x7F, 0x82, 0x80, 0x7F, 0x7F, 0x7F, 0x7D, 0x7F,
	0x80, 0x7F, 0x81, 0x82, 0x7F, 0x83, 0xA4, 0x97, 0xA0, 0xB5, 0x92, 0x91,
	0x87, 0x6F, 0x64, 0x68, 0x67, 0x65, 0x7F, 0x81, 0x83, 0x92, 0x89, 0x84,
	0x82, 0x7C, 0x75, 0x78, 0x7D, 0x7B, 0x85, 0x89, 0x87, 0x87, 0x86, 0x7E,
	0x7B, 0x7B, 0x76, 0x79, 0x7D, 0x7B, 0x80, 0x83, 0x80, 0x81, 0x81, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7E, 0x82, 0x81, 0x82, 0x82, 0x82, 0x7F, 0x80, 0x7D,
	0x86, 0xAC, 0x99, 0xA8, 0xB7, 0x91, 0x8C, 0x7E, 0x6B, 0x5A, 0x68, 0x73,
	0x6C, 0x8B, 0x91, 0x8A, 0x8E, 0x89, 0x7B, 0x70, 0x78, 0x71, 0x74, 0x85,
	0x86, 0x89, 0x8D, 0x8A, 0x81, 0x7D, 0x7B, 0x73, 0x77, 0x7C, 0x7E, 0x83,
	0x87, 0x88, 0x83, 0x83, 0x7E, 0x79, 0x7A, 0x7B, 0x7B, 0x80, 0x83, 0x84,
	0x83, 0x85, 0x80, 0x7E, 0x7D, 0x7B, 0x7C, 0x82, 0xB2, 0xA7, 0xA7, 0xBF,
	0x9A, 0x84, 0x78, 0x6D, 0x56, 0x61, 0x78, 0x72, 0x87, 0x95, 0x8F, 0x8A,
	0x85, 0x7F, 0x6E, 0x73, 0x77, 0x76, 0x82, 0x8A, 0x8C, 0x88, 0x89, 0x82,
	0x78, 0x78, 0x77, 0x77, 0x7B, 0x83, 0x85, 0x85, 0x88, 0x83, 0x7F, 0x7C,
	0x7B, 0x7A, 0x7B, 0x80, 0x81, 0x81, 0x83, 0x83, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7A, 0x80, 0x7D, 0x98, 0xB7, 0xA4, 0xB1, 0xB0, 0x92, 0x7C, 0x73, 0x6E,
	0x5C, 0x6E, 0x7F, 0x7F, 0x8C, 0x92, 0x8E, 0x7E, 0x7D, 0x77, 0x6B, 0x71,
	0x76, 0x7D, 0x81, 0x8C, 0x8E, 0x88, 0x87, 0x81, 0x7A, 0x75, 0x78, 0x79,
	0x7B, 0x82, 0x85, 0x86, 0x86, 0x85, 0x81, 0x7C, 0x7B, 0x7A, 0x7A, 0x7D,
	0x80, 0x82, 0x83, 0x85, 0x82, 0x7D, 0x7C, 0x79, 0x76, 0x79, 0x79, 0x92,
	0xA5, 0xA2, 0xB0, 0xB0, 0xA1, 0x8E, 0x85, 0x79, 0x66, 0x6C, 0x71, 0x76,
	0x7D, 0x8A, 0x8E, 0x89, 0x8A, 0x83, 0x7A, 0x75, 0x74, 0x75, 0x74, 0x7C,
	0x82, 0x85, 0x87, 0x89, 0x88, 0x82, 0x80, 0x7D, 0x7A, 0x79, 0x7B, 0x7D,
	0x7E, 0x82, 0x84, 0x84, 0x83, 0x82, 0x81, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D,
	0x7F, 0x80, 0x81, 0x82, 0x81, 0x7F, 0x7F, 0x8D, 0x94, 0x93, 0x9E, 0xA0,
	0x9C, 0x94, 0x92, 0x8A, 0x7D, 0x7C, 0x7A, 0x77, 0x77, 0x7D, 0x81, 0x7F,
	0x83, 0x84, 0x81, 0x7E, 0x7D, 0x7D, 0x78, 0x7A, 0x7C, 0x7C, 0x7E, 0x81,
	0x83, 0x82, 0x83, 0x84, 0x82, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x81, 0x8D, 0x91, 0x94, 0x9C, 0x9F, 0x9D, 0x99, 0x99, 0x93,
	0x8B, 0x89, 0x86, 0x82, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x82, 0x80, 0x80,
	0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x87,
	0x89, 0x8B, 0x90, 0x92, 0x92, 0x92, 0x94, 0x92, 0x90, 0x91, 0x90, 0x8D,
	0x8C, 0x8C, 0x8A, 0x87, 0x87, 0x86, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7D, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7C, 0x7B, 0x7C, 0x7A, 0x7B, 0x7B, 0x7B, 0x79, 0x79, 0x7B,
	0x7A, 0x79, 0x79, 0x7C, 0x78, 0x79, 0x7C, 0x7A, 0x79, 0x7A, 0x7C, 0x7A,
	0x7B, 0x7E, 0x7D, 0x7D, 0x80, 0x81, 0x7E, 0x7F, 0x82, 0x7F, 0x80, 0x83,
	0x82, 0x82, 0x82, 0x82, 0x80, 0x84, 0x82, 0x81, 0x83, 0x82, 0x82, 0x80,
	0x82, 0x81, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x7F, 0x82, 0x82, 0x80, 0x80,
	0x80, 0x80, 0x7E, 0x7F, 0x7E, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x81,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x82, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x7E, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x81, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E,
	0x81, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x81, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7E,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x82, 0x80, 0x82, 0x81,
	0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x7F,
	0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x82, 0x82, 0x83, 0x83, 0x83, 0x85,
	0x84, 0x84, 0x83, 0x83, 0x81, 0x80, 0x80, 0x7D, 0x7E, 0x7D, 0x7C, 0x7E,
	0x7E, 0x7F, 0x81, 0x84, 0x85, 0x85, 0x86, 0x86, 0x84, 0x83, 0x80, 0x7E,
	0x7E, 0x7D, 0x7C, 0x7E, 0x80, 0x82, 0x82, 0x84, 0x85, 0x84, 0x83, 0x81,
	0x88, 0x88, 0x86, 0x87, 0x87, 0x86, 0x81, 0x7F, 0x7F, 0x7C, 0x7A, 0x79,
	0x7C, 0x7C, 0x7C, 0x7F, 0x81, 0x82, 0x82, 0x83, 0x84, 0x82, 0x81, 0x80,
	0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x83, 0x85, 0x85, 0x84, 0x83, 0x83, 0x7F, 0x7D, 0x7C, 0x7C, 0x7D,
	0x7C, 0x7E, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x86, 0x88, 0x87, 0x85, 0x83, 0x83, 0x80, 0x7D, 0x7C,
	0x7C, 0x7F, 0x80, 0x80, 0x82, 0x82, 0x83, 0x81, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x80, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x84, 0x90, 0x8F, 0x8C, 0x87, 0x85, 0x85,
	0x7C, 0x78, 0x78, 0x7B, 0x7F, 0x7E, 0x80, 0x84, 0x86, 0x85, 0x81, 0x7F,
	0x7F, 0x7E, 0x7C, 0x7B, 0x7D, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x80,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x8F, 0x97, 0x93,
	0x8B, 0x80, 0x80, 0x7E, 0x77, 0x74, 0x75, 0x7D, 0x86, 0x85, 0x85, 0x84,
	0x85, 0x84, 0x7E, 0x79, 0x79, 0x7B, 0x7F, 0x7F, 0x7F, 0x82, 0x84, 0x86,
	0x83, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7D, 0x7F, 0x81, 0x82, 0x82, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x85, 0x94, 0x97, 0x91, 0x83, 0x78, 0x78, 0x79, 0x79, 0x78, 0x78,
	0x81, 0x89, 0x8B, 0x86, 0x7C, 0x7A, 0x7B, 0x7E, 0x7F, 0x7D, 0x7E, 0x82,
	0x85, 0x86, 0x81, 0x7C, 0x7B, 0x7D, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x83,
	0x82, 0x7F, 0x7D, 0x7C, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x81, 0x83, 0x82,
	0x80, 0x7D, 0x7D, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x80,
	0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x7C,
	0x7B, 0x7C, 0x7F, 0x83, 0x83, 0x81, 0x95, 0xA6, 0xA9, 0x98, 0x74, 0x5F,
	0x5F, 0x71, 0x87, 0x8B, 0x88, 0x83, 0x83, 0x89, 0x84, 0x78, 0x6D, 0x6D,
	0x7D, 0x8C, 0x92, 0x8A, 0x7C, 0x79, 0x7D, 0x83, 0x84, 0x7B, 0x77, 0x79,
	0x83, 0x8C, 0x88, 0x7F, 0x76, 0x76, 0x7F, 0x85, 0x86, 0x80, 0x7A, 0x7C,
	0x82, 0x86, 0x83, 0x7B, 0x78, 0x7B, 0x82, 0x87, 0x84, 0x7E, 0x7A, 0x7B,
	0x7F, 0x83, 0x81, 0x7E, 0x7C, 0x7E, 0x83, 0x84, 0x81, 0x7D, 0x7A, 0x7D,
	0x81, 0x84, 0x82, 0x7E, 0x7D, 0x7D, 0x81, 0x82, 0x81, 0x7C, 0x87, 0xAA,
	0xBA, 0xB5, 0x8C, 0x5B, 0x4D, 0x59, 0x7A, 0x96, 0x94, 0x8B, 0x82, 0x82,
	0x89, 0x81, 0x72, 0x67, 0x69, 0x81, 0x97, 0x9C, 0x8E, 0x75, 0x6B, 0x72,
	0x7F, 0x88, 0x83, 0x7B, 0x7B, 0x82, 0x8C, 0x8B, 0x7D, 0x71, 0x70, 0x7B,
	0x89, 0x8D, 0x85, 0x7B, 0x76, 0x7D, 0x84, 0x86, 0x80, 0x78, 0x78, 0x80,
	0x88, 0x89, 0x81, 0x78, 0x76, 0x7D, 0x85, 0x87, 0x82, 0x7B, 0x7A, 0x7E,
	0x85, 0x85, 0x80, 0x7A, 0x7A, 0x7E, 0x83, 0x83, 0x80, 0x7B, 0x7C, 0x7F,
	0x85, 0x82, 0x87, 0xAF, 0xC6, 0xC3, 0x9C, 0x5C, 0x3F, 0x4E, 0x75, 0xA1,
	0xA6, 0x92, 0x81, 0x79, 0x82, 0x86, 0x76, 0x67, 0x66, 0x79, 0x99, 0xA7,
	0x9A, 0x7E, 0x66, 0x66, 0x79, 0x87, 0x8A, 0x81, 0x79, 0x80, 0x8B, 0x8D,
	0x83, 0x71, 0x6A, 0x75, 0x86, 0x92, 0x8D, 0x7E, 0x75, 0x77, 0x80, 0x87,
	0x83, 0x7A, 0x77, 0x7D, 0x88, 0x8A, 0x81, 0x76, 0x72, 0x79, 0x87, 0x8B,
	0x85, 0x7C, 0x77, 0x7B, 0x84, 0x86, 0x81, 0x7A, 0x78, 0x7E, 0x86, 0x87,
	0x82, 0x79, 0x78, 0x7D, 0x84, 0x85, 0x86, 0xB0, 0xD2, 0xCF, 0xA7, 0x5E,
	0x2F, 0x41, 0x71, 0xA0, 0xB1, 0x97, 0x81, 0x80, 0x85, 0x88, 0x78, 0x5D,
	0x5C, 0x77, 0x99, 0xAC, 0x9C, 0x78, 0x65, 0x68, 0x7C, 0x8C, 0x86, 0x79,
	0x77, 0x81, 0x91, 0x94, 0x81, 0x6E, 0x6C, 0x78, 0x8C, 0x92, 0x85, 0x78,
	0x75, 0x7D, 0x89, 0x89, 0x7D, 0x74, 0x75, 0x81, 0x8D, 0x8B, 0x7F, 0x75,
	0x76, 0x7F, 0x88, 0x86, 0x7E, 0x78, 0x7A, 0x83, 0x89, 0x85, 0x7D, 0x7A,
	0x7E, 0x86, 0x88, 0x82, 0x79, 0x78, 0x7C, 0x85, 0x86, 0x83, 0x78, 0x95,
	0xDA, 0xEE, 0xC6, 0x7C, 0x32, 0x2D, 0x69, 0x99, 0xA7, 0x98, 0x7D, 0x82,
	0x9D, 0x9B, 0x7E, 0x59, 0x48, 0x67, 0x9D, 0xB0, 0x9E, 0x7D, 0x67, 0x71,
	0x8A, 0x8B, 0x77, 0x68, 0x6C, 0x87, 0xA1, 0x9B, 0x7F, 0x69, 0x68, 0x7C,
	0x8F, 0x8B, 0x7A, 0x72, 0x7A, 0x8B, 0x94, 0x87, 0x72, 0x6B, 0x76, 0x8A,
	0x94, 0x8A, 0x78, 0x75, 0x7E, 0x87, 0x87, 0x7C, 0x72, 0x77, 0x85, 0x8D,
	0x88, 0x7D, 0x74, 0x79, 0x84, 0x88, 0x81, 0x7A, 0x78, 0x80, 0x88, 0x88,
	0x7E, 0x78, 0x79, 0x83, 0xB5, 0xDF, 0xC2, 0x84, 0x5D, 0x52, 0x66, 0x89,
	0x8B, 0x79, 0x81, 0x9A, 0xA2, 0x98, 0x7B, 0x59, 0x5A, 0x7C, 0x8F, 0x8D,
	0x85, 0x7D, 0x80, 0x8F, 0x8D, 0x76, 0x68, 0x6E, 0x7E, 0x8E, 0x92, 0x7E,
	0x6F, 0x78, 0x86, 0x86, 0x7E, 0x76, 0x74, 0x81, 0x8F, 0x89, 0x7A, 0x76,
	0x7B, 0x82, 0x86, 0x81, 0x77, 0x79, 0x84, 0x88, 0x83, 0x7D, 0x79, 0x7B,
	0x84, 0x85, 0x7F, 0x7A, 0x7D, 0x80, 0x81, 0x80, 0x7D, 0x7B, 0x80, 0x84,
	0x82, 0x7E, 0x7D, 0x7F, 0x80, 0x82, 0x7F, 0x7E, 0x7D, 0x9E, 0xD2, 0xCF,
	0x93, 0x64, 0x5F, 0x6B, 0x7C, 0x83, 0x77, 0x78, 0x99, 0xAD, 0x98, 0x7B,
	0x72, 0x71, 0x77, 0x81, 0x7D, 0x74, 0x81, 0x96, 0x93, 0x82, 0x78, 0x76,
	0x77, 0x7F, 0x82, 0x79, 0x7A, 0x88, 0x8D, 0x84, 0x7D, 0x7B, 0x7A, 0x7D,
	0x82, 0x7F, 0x7A, 0x80, 0x88, 0x88, 0x86, 0x84, 0x7D, 0x7B, 0x7F, 0x80,
	0x7B, 0x7C, 0x83, 0x84, 0x83, 0x82, 0x80, 0x7D, 0x7E, 0x80, 0x7E, 0x7C,
	0x7F, 0x82, 0x82, 0x80, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x7E, 0x86,
	0x8A, 0x86, 0x7D, 0x9A, 0xD3, 0xD7, 0x91, 0x60, 0x6F, 0x82, 0x77, 0x6C,
	0x71, 0x80, 0x9C, 0xAD, 0x96, 0x71, 0x73, 0x86, 0x7F, 0x6B, 0x6E, 0x7D,
	0x89, 0x92, 0x90, 0x7F, 0x78, 0x83, 0x85, 0x72, 0x6C, 0x7C, 0x87, 0x84,
	0x84, 0x85, 0x81, 0x80, 0x84, 0x7E, 0x73, 0x78, 0x84, 0x83, 0x7D, 0x81,
	0x85, 0x82, 0x80, 0x81, 0x7D, 0x79, 0x7F, 0x83, 0x7E, 0x7D, 0x82, 0x83,
	0x80, 0x7F, 0x80, 0x7E, 0x7D, 0x80, 0x80, 0x7E, 0x7E, 0x82, 0x81, 0x7F,
	0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x82, 0xA7, 0xDC,
	0xD0, 0x86, 0x65, 0x81, 0x8A, 0x69, 0x5C, 0x73, 0x89, 0x99, 0xA3, 0x95,
	0x7A, 0x7D, 0x8E, 0x7F, 0x61, 0x67, 0x82, 0x8B, 0x85, 0x87, 0x89, 0x84,
	0x84, 0x86, 0x79, 0x6C, 0x77, 0x86, 0x82, 0x7A, 0x82, 0x8A, 0x85, 0x7D,
	0x79, 0x75, 0x77, 0x80, 0x84, 0x7D, 0x7C, 0x86, 0x8A, 0x81, 0x7B, 0x7D,
	0x7E, 0x7C, 0x7E, 0x7F, 0x7E, 0x7F, 0x85, 0x85, 0x7E, 0x7D, 0x80, 0x81,
	0x7D, 0x7D, 0x80, 0x80, 0x7F, 0x7F, 0x7A, 0x76, 0x7D, 0x85, 0x82, 0x7B,
	0x7E, 0x84, 0x82, 0x7E, 0x7E, 0x99, 0xCD, 0xD7, 0x99, 0x5E, 0x6C, 0x8D,
	0x7E, 0x5C, 0x64, 0x84, 0x9A, 0xA1, 0x9A, 0x82, 0x74, 0x82, 0x8A, 0x73,
	0x61, 0x74, 0x8D, 0x8E, 0x86, 0x86, 0x85, 0x81, 0x82, 0x82, 0x75, 0x6E,
	0x7B, 0x8A, 0x86, 0x7D, 0x81, 0x87, 0x84, 0x7E, 0x7D, 0x7B, 0x78, 0x7E,
	0x85, 0x81, 0x7C, 0x81, 0x87, 0x84, 0x7F, 0x7F, 0x7F, 0x7D, 0x7E, 0x81,
	0x80, 0x7D, 0x80, 0x84, 0x82, 0x7E, 0x7E, 0x80, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x80, 0x82, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x7E, 0x80, 0x7F,
	0x88, 0xB6, 0xDD, 0xBE, 0x75, 0x60, 0x80, 0x8A, 0x6B, 0x5C, 0x73, 0x8F,
	0x9F, 0xA2, 0x91, 0x78, 0x76, 0x87, 0x83, 0x69, 0x63, 0x7C, 0x90, 0x8E,
	0x86, 0x84, 0x82, 0x82, 0x83, 0x7D, 0x73, 0x73, 0x81, 0x89, 0x83, 0x7E,
	0x82, 0x86, 0x83, 0x7E, 0x7C, 0x7A, 0x7B, 0x81, 0x83, 0x7F, 0x7E, 0x82,
	0x85, 0x81, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x82,
	0x7E, 0x79, 0x7C, 0x81, 0x81, 0x7D, 0x7E, 0x81, 0x82, 0x81, 0x7F, 0x7F,
	0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x82, 0x81, 0x9A, 0xCC, 0xD8, 0x9C,
	0x63, 0x6F, 0x8F, 0x7F, 0x5C, 0x64, 0x89, 0x9D, 0x9D, 0x96, 0x88, 0x7D,
	0x82, 0x87, 0x75, 0x62, 0x6F, 0x8B, 0x90, 0x83, 0x81, 0x8A, 0x8A, 0x82,
	0x7C, 0x78, 0x74, 0x79, 0x84, 0x84, 0x7D, 0x7F, 0x89, 0x89, 0x7F, 0x7B,
	0x7E, 0x7E, 0x7C, 0x7D, 0x80, 0x7F, 0x80, 0x84, 0x84, 0x7F, 0x7D, 0x80,
	0x81, 0x7D, 0x7C, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80,
	0x7E, 0x7D, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x82, 0x9C, 0xBF, 0xBD, 0x90, 0x76, 0x86, 0x8E, 0x73, 0x5F,
	0x70, 0x89, 0x90, 0x8F, 0x8E, 0x89, 0x86, 0x88, 0x83, 0x71, 0x6C, 0x7D,
	0x8D, 0x87, 0x7E, 0x84, 0x8E, 0x89, 0x7D, 0x79, 0x7A, 0x7C, 0x7E, 0x80,
	0x7E, 0x7F, 0x86, 0x88, 0x81, 0x7C, 0x7E, 0x81, 0x7E, 0x7B, 0x7D, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x7F, 0x82, 0x83, 0x80, 0x7D, 0x7F, 0x82, 0x81,
	0x7D, 0x7F, 0x82, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x81, 0x80, 0x7E, 0x80, 0x81, 0x80, 0x7E, 0x81, 0x98, 0xB3, 0xAE,
	0x8F, 0x84, 0x94, 0x8D, 0x6D, 0x64, 0x7C, 0x8C, 0x84, 0x81, 0x8C, 0x91,
	0x8A, 0x81, 0x7B, 0x77, 0x79, 0x7E, 0x7D, 0x7A, 0x82, 0x8C, 0x88, 0x7F,
	0x7E, 0x83, 0x80, 0x79, 0x79, 0x81, 0x85, 0x84, 0x82, 0x83, 0x84, 0x83,
	0x7E, 0x7B, 0x7D, 0x80, 0x7F, 0x7E, 0x80, 0x83, 0x83, 0x80, 0x7F, 0x80,
	0x80, 0x7E, 0x7D, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7E,
	0x7D, 0x7E, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x81, 0x7F, 0x7F, 0x80, 0x7F,
	0x7E, 0x7F, 0x8C, 0x9F, 0x9E, 0x89, 0x85, 0x92, 0x8A, 0x71, 0x6E, 0x82,
	0x86, 0x7C, 0x7E, 0x8C, 0x8D, 0x83, 0x7C, 0x7D, 0x7F, 0x7D, 0x78, 0x78,
	0x81, 0x87, 0x81, 0x7E, 0x84, 0x87, 0x7F, 0x79, 0x7D, 0x81, 0x7D, 0x7C,
	0x80, 0x83, 0x82, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x7C, 0x7E, 0x80, 0x80,
	0x7F, 0x80, 0x82, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x88, 0x8F, 0x8B, 0x85, 0x8B,
	0x8C, 0x80, 0x7B, 0x81, 0x81, 0x7B, 0x7E, 0x84, 0x84, 0x81, 0x83, 0x83,
	0x81, 0x80, 0x7E, 0x7D, 0x7F, 0x80, 0x7E, 0x7F, 0x82, 0x81, 0x7E, 0x80,
	0x81, 0x7F, 0x7D, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x83,
	0x84, 0x84, 0x85, 0x84, 0x82, 0x83, 0x82, 0x81, 0x82, 0x84, 0x84, 0x83,
	0x82, 0x81, 0x83, 0x81, 0x7E, 0x82, 0x84, 0x7F, 0x7E, 0x82, 0x81, 0x7E,
	0x7F, 0x7F, 0x7C, 0x7D, 0x7E, 0x7B, 0x7B, 0x7C, 0x7B, 0x7A, 0x7C, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7E, 0x81, 0x80, 0x7F, 0x82, 0x83, 0x7F, 0x81, 0x83,
	0x7E, 0x7D, 0x82, 0x80, 0x7E, 0x82, 0x82, 0x7E, 0x80, 0x81, 0x7E, 0x7E,
	0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x82, 0x82, 0x80, 0x81, 0x82, 0x80,
	0x81, 0x82, 0x82, 0x82, 0x83, 0x81, 0x81, 0x83, 0x82, 0x7F, 0x83, 0x83,
	0x80, 0x81, 0x83, 0x81, 0x80, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x82,
	0x82, 0x81, 0x83, 0x82, 0x81, 0x83, 0x82, 0x80, 0x81, 0x82, 0x80, 0x80,
	0x82, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVbillion[] = {
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x7F, 0x80, 0x80, 0x7C, 0x7B, 0x7C, 0x7A, 0x79, 0x7A, 0x7C, 0x7A, 0x7B,
	0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7C, 0x7C,
	0x7D, 0x7D, 0x7D, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x7F,
	0x81, 0x8A, 0x88, 0x88, 0x8E, 0x8C, 0x89, 0x89, 0x87, 0x85, 0x81, 0x7F,
	0x7F, 0x7B, 0x7A, 0x7C, 0x7B, 0x7C, 0x7D, 0x7E, 0x80, 0x80, 0x81, 0x82,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x7E,
	0x89, 0x9A, 0x8E, 0x98, 0xA4, 0x95, 0x93, 0x92, 0x89, 0x80, 0x77, 0x7A,
	0x75, 0x6C, 0x78, 0x79, 0x76, 0x80, 0x85, 0x86, 0x87, 0x88, 0x8B, 0x84,
	0x82, 0x85, 0x7D, 0x7A, 0x7D, 0x7A, 0x79, 0x7A, 0x7E, 0x7E, 0x7E, 0x83,
	0x83, 0x81, 0x84, 0x84, 0x81, 0x80, 0x80, 0x7F, 0x7D, 0x7D, 0x7E, 0x7D,
	0x7D, 0x80, 0x7F, 0x7F, 0x80, 0x82, 0x80, 0x81, 0x80, 0x82, 0x7D, 0x86,
	0xA8, 0x97, 0x9C, 0xBD, 0xA2, 0x98, 0xA1, 0x8E, 0x7D, 0x73, 0x75, 0x6B,
	0x5D, 0x73, 0x74, 0x6B, 0x81, 0x88, 0x84, 0x8A, 0x8F, 0x8F, 0x83, 0x85,
	0x88, 0x76, 0x78, 0x7E, 0x74, 0x76, 0x7C, 0x7E, 0x7E, 0x7F, 0x88, 0x83,
	0x81, 0x88, 0x83, 0x7E, 0x81, 0x80, 0x7C, 0x7B, 0x7F, 0x7E, 0x7B, 0x80,
	0x81, 0x7E, 0x81, 0x82, 0x81, 0x7E, 0x80, 0x81, 0x7C, 0x7E, 0x81, 0xA4,
	0xA2, 0x9B, 0xBF, 0xAE, 0x9B, 0x9E, 0x8F, 0x7C, 0x68, 0x6E, 0x6A, 0x57,
	0x6E, 0x76, 0x72, 0x81, 0x8C, 0x8E, 0x89, 0x8F, 0x92, 0x80, 0x80, 0x83,
	0x79, 0x75, 0x7A, 0x7F, 0x79, 0x7C, 0x86, 0x82, 0x80, 0x85, 0x85, 0x80,
	0x7E, 0x83, 0x7E, 0x7A, 0x7E, 0x7F, 0x7C, 0x7E, 0x80, 0x82, 0x7E, 0x82,
	0x83, 0x7F, 0x80, 0x81, 0x7F, 0x7D, 0x7D, 0x80, 0x7B, 0x83, 0xAC, 0xA5,
	0xA1, 0xB9, 0xB2, 0x9F, 0x8B, 0x8D, 0x7B, 0x5F, 0x66, 0x6B, 0x66, 0x68,
	0x79, 0x88, 0x82, 0x89, 0x95, 0x8D, 0x86, 0x84, 0x85, 0x7A, 0x73, 0x7D,
	0x7C, 0x7A, 0x7D, 0x86, 0x88, 0x81, 0x85, 0x87, 0x82, 0x7E, 0x7D, 0x7F,
	0x7B, 0x79, 0x7D, 0x7F, 0x7E, 0x7F, 0x82, 0x84, 0x80, 0x81, 0x82, 0x80,
	0x7F, 0x7D, 0x80, 0x7C, 0x7F, 0x7B, 0x7E, 0x7B, 0x95, 0xB5, 0xA8, 0xAE,
	0xB1, 0xB2, 0x97, 0x7E, 0x7F, 0x71, 0x66, 0x5E, 0x6B, 0x78, 0x76, 0x81,
	0x8C, 0x95, 0x8F, 0x89, 0x8C, 0x85, 0x7D, 0x74, 0x77, 0x77, 0x74, 0x76,
	0x7A, 0x82, 0x82, 0x83, 0x85, 0x87, 0x85, 0x80, 0x7F, 0x7E, 0x7C, 0x7A,
	0x7A, 0x7E, 0x7E, 0x80, 0x80, 0x82, 0x84, 0x81, 0x82, 0x7F, 0x81, 0x7E,
	0x7E, 0x7D, 0x7F, 0x7E, 0x80, 0x7B, 0x81, 0xAB, 0xBA, 0xB7, 0xA2, 0xA1,
	0xA1, 0x8A, 0x73, 0x63, 0x6F, 0x70, 0x70, 0x72, 0x83, 0x94, 0x93, 0x91,
	0x8D, 0x91, 0x88, 0x7B, 0x73, 0x73, 0x77, 0x74, 0x76, 0x7C, 0x86, 0x88,
	0x85, 0x85, 0x85, 0x86, 0x7F, 0x7A, 0x78, 0x7A, 0x7C, 0x7B, 0x7D, 0x80,
	0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x7E, 0x7C, 0x7B, 0x7D, 0x7D, 0x7E,
	0x7E, 0x81, 0x82, 0x83, 0x7E, 0x99, 0xBA, 0xC6, 0xB4, 0x95, 0x91, 0x8B,
	0x83, 0x67, 0x5F, 0x69, 0x7C, 0x86, 0x84, 0x8D, 0x96, 0x9E, 0x93, 0x85,
	0x7C, 0x7A, 0x78, 0x70, 0x6F, 0x74, 0x80, 0x86, 0x87, 0x88, 0x8A, 0x8E,
	0x8A, 0x84, 0x7C, 0x7A, 0x7A, 0x7A, 0x79, 0x7A, 0x7F, 0x84, 0x86, 0x86,
	0x84, 0x84, 0x82, 0x80, 0x7C, 0x7B, 0x7B, 0x7D, 0x7E, 0x7F, 0x80, 0x82,
	0x84, 0x82, 0x82, 0x7E, 0x9A, 0xB6, 0xC6, 0xB2, 0x95, 0x86, 0x82, 0x82,
	0x6D, 0x63, 0x61, 0x79, 0x88, 0x91, 0x8D, 0x8E, 0x94, 0x93, 0x8B, 0x79,
	0x73, 0x70, 0x78, 0x76, 0x78, 0x7A, 0x84, 0x8B, 0x8C, 0x89, 0x83, 0x86,
	0x86, 0x87, 0x7F, 0x7A, 0x78, 0x7C, 0x80, 0x80, 0x80, 0x7F, 0x84, 0x85,
	0x86, 0x81, 0x7F, 0x7D, 0x7F, 0x7F, 0x7D, 0x7D, 0x7D, 0x81, 0x81, 0x83,
	0x7F, 0x82, 0x7E, 0x86, 0x9E, 0xB8, 0xC4, 0xB2, 0x9A, 0x82, 0x7E, 0x7A,
	0x73, 0x67, 0x64, 0x70, 0x83, 0x94, 0x94, 0x91, 0x8B, 0x8E, 0x8A, 0x84,
	0x76, 0x6E, 0x6F, 0x76, 0x7E, 0x80, 0x82, 0x83, 0x89, 0x8B, 0x8A, 0x81,
	0x79, 0x74, 0x76, 0x79, 0x7B, 0x7C, 0x7C, 0x81, 0x85, 0x88, 0x86, 0x83,
	0x7E, 0x7E, 0x7D, 0x7E, 0x7B, 0x7B, 0x7C, 0x7F, 0x82, 0x84, 0x82, 0x81,
	0x80, 0x80, 0x80, 0x7E, 0x8D, 0xA2, 0xBA, 0xBB, 0xAA, 0x8F, 0x7C, 0x76,
	0x75, 0x73, 0x6B, 0x6A, 0x72, 0x85, 0x93, 0x99, 0x91, 0x89, 0x83, 0x83,
	0x81, 0x7A, 0x73, 0x6F, 0x74, 0x7D, 0x86, 0x87, 0x86, 0x83, 0x85, 0x86,
	0x85, 0x80, 0x7A, 0x76, 0x78, 0x7D, 0x80, 0x81, 0x80, 0x81, 0x82, 0x85,
	0x84, 0x82, 0x7D, 0x7C, 0x7C, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x81, 0x82,
	0x83, 0x80, 0x80, 0x7D, 0x81, 0x91, 0xA7, 0xB8, 0xB4, 0xA2, 0x89, 0x7B,
	0x75, 0x76, 0x72, 0x6E, 0x6C, 0x75, 0x84, 0x92, 0x96, 0x91, 0x89, 0x83,
	0x82, 0x80, 0x7C, 0x74, 0x72, 0x73, 0x7C, 0x83, 0x88, 0x86, 0x84, 0x83,
	0x85, 0x85, 0x82, 0x7D, 0x78, 0x78, 0x7A, 0x7F, 0x80, 0x81, 0x80, 0x81,
	0x82, 0x84, 0x83, 0x81, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F,
	0x81, 0x82, 0x82, 0x81, 0x7F, 0x7F, 0x8B, 0x9C, 0xAF, 0xB0, 0xA5, 0x8F,
	0x80, 0x78, 0x78, 0x77, 0x72, 0x6E, 0x70, 0x7C, 0x88, 0x92, 0x91, 0x8C,
	0x85, 0x84, 0x82, 0x81, 0x7B, 0x75, 0x72, 0x76, 0x7D, 0x83, 0x85, 0x84,
	0x83, 0x81, 0x83, 0x83, 0x81, 0x7D, 0x7A, 0x79, 0x7C, 0x7E, 0x80, 0x80,
	0x80, 0x80, 0x82, 0x83, 0x82, 0x80, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7F, 0x80, 0x81, 0x81, 0x83, 0x81, 0x88, 0x96, 0xA9, 0xB1, 0xAC,
	0x9C, 0x8A, 0x81, 0x7C, 0x7A, 0x72, 0x6D, 0x6B, 0x75, 0x80, 0x8B, 0x8E,
	0x8D, 0x8A, 0x8A, 0x89, 0x86, 0x80, 0x78, 0x74, 0x74, 0x79, 0x7C, 0x7F,
	0x80, 0x84, 0x86, 0x89, 0x87, 0x85, 0x81, 0x7E, 0x7D, 0x7C, 0x7B, 0x7A,
	0x7B, 0x7D, 0x80, 0x82, 0x83, 0x82, 0x83, 0x82, 0x82, 0x80, 0x7F, 0x7D,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7E, 0x81, 0x82, 0x86, 0x84, 0x8C, 0x9B, 0xAB,
	0xAF, 0xA2, 0x95, 0x89, 0x88, 0x81, 0x79, 0x6D, 0x6C, 0x72, 0x7D, 0x84,
	0x86, 0x88, 0x8B, 0x90, 0x8F, 0x8B, 0x81, 0x7C, 0x79, 0x7A, 0x78, 0x77,
	0x7A, 0x7E, 0x84, 0x85, 0x87, 0x86, 0x87, 0x85, 0x83, 0x7F, 0x7C, 0x7B,
	0x7B, 0x7C, 0x7B, 0x7D, 0x7F, 0x81, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81,
	0x80, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7F, 0x7F, 0x82, 0x7F, 0x8E,
	0xA1, 0xAC, 0xA7, 0x9B, 0x99, 0x95, 0x8F, 0x7C, 0x71, 0x6F, 0x73, 0x76,
	0x74, 0x7A, 0x82, 0x8D, 0x8E, 0x8D, 0x8B, 0x8B, 0x89, 0x82, 0x7B, 0x77,
	0x78, 0x77, 0x77, 0x78, 0x7C, 0x82, 0x83, 0x85, 0x85, 0x87, 0x86, 0x83,
	0x80, 0x7E, 0x7E, 0x7B, 0x7B, 0x7A, 0x7D, 0x7E, 0x7F, 0x80, 0x82, 0x83,
	0x83, 0x82, 0x81, 0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x80,
	0x7F, 0x93, 0xA4, 0xA3, 0xA2, 0xA1, 0xA6, 0x97, 0x88, 0x7E, 0x7B, 0x76,
	0x6B, 0x6D, 0x73, 0x7B, 0x7C, 0x81, 0x8A, 0x8E, 0x8D, 0x89, 0x89, 0x87,
	0x80, 0x7C, 0x7A, 0x7B, 0x77, 0x78, 0x7B, 0x7E, 0x7F, 0x80, 0x84, 0x84,
	0x84, 0x83, 0x83, 0x82, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F,
	0x7F, 0x80, 0x81, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7E, 0x7E, 0x7D, 0x7E,
	0x7D, 0x7F, 0x7D, 0x8C, 0x9F, 0x98, 0xA4, 0xAC, 0xA7, 0x9D, 0x97, 0x93,
	0x7F, 0x78, 0x73, 0x6D, 0x6A, 0x6A, 0x73, 0x74, 0x7A, 0x82, 0x86, 0x88,
	0x87, 0x8B, 0x84, 0x82, 0x82, 0x7C, 0x7B, 0x7A, 0x7B, 0x7A, 0x7B, 0x7F,
	0x7E, 0x81, 0x82, 0x83, 0x83, 0x82, 0x83, 0x80, 0x80, 0x80, 0x7D, 0x7E,
	0x7D, 0x7E, 0x7E, 0x7E, 0x80, 0x7D, 0x7F, 0x7F, 0x7C, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x96, 0x93, 0x98, 0xAE, 0xA0, 0xA6,
	0xA4, 0x99, 0x8E, 0x86, 0x7E, 0x6D, 0x6F, 0x69, 0x65, 0x6D, 0x6D, 0x73,
	0x79, 0x80, 0x84, 0x88, 0x8C, 0x88, 0x8C, 0x88, 0x84, 0x84, 0x7E, 0x7E,
	0x7C, 0x7B, 0x7B, 0x7C, 0x7D, 0x7D, 0x80, 0x80, 0x80, 0x82, 0x80, 0x82,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7D, 0x7E, 0x7E, 0x7C, 0x7E, 0x7D, 0x7E,
	0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x81, 0x80, 0x82, 0x7D, 0x8F, 0x94, 0x93,
	0xAD, 0x9D, 0xA8, 0xA8, 0x93, 0x99, 0x85, 0x7D, 0x78, 0x6C, 0x6B, 0x68,
	0x6A, 0x6A, 0x71, 0x76, 0x79, 0x84, 0x82, 0x89, 0x8B, 0x88, 0x8C, 0x86,
	0x85, 0x83, 0x7E, 0x7E, 0x7B, 0x7B, 0x7A, 0x7B, 0x7B, 0x7C, 0x7F, 0x7E,
	0x81, 0x81, 0x81, 0x83, 0x82, 0x81, 0x82, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x82,
	0x7D, 0x8C, 0x97, 0x94, 0xB0, 0xA3, 0xA8, 0xAB, 0x93, 0x98, 0x85, 0x78,
	0x76, 0x69, 0x67, 0x6A, 0x6A, 0x6F, 0x7A, 0x7C, 0x84, 0x8D, 0x89, 0x91,
	0x8E, 0x88, 0x8B, 0x81, 0x7F, 0x7D, 0x76, 0x78, 0x77, 0x76, 0x7A, 0x7C,
	0x7D, 0x81, 0x83, 0x84, 0x86, 0x85, 0x84, 0x84, 0x81, 0x80, 0x7F, 0x7D,
	0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x82, 0x82, 0x81,
	0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x96, 0x93, 0xA2, 0xB1, 0x9E, 0xAE,
	0x9C, 0x8F, 0x8C, 0x78, 0x72, 0x6C, 0x6A, 0x67, 0x71, 0x74, 0x77, 0x87,
	0x84, 0x8C, 0x90, 0x89, 0x8D, 0x87, 0x82, 0x7F, 0x7C, 0x77, 0x77, 0x79,
	0x76, 0x7C, 0x7E, 0x7D, 0x85, 0x83, 0x84, 0x87, 0x83, 0x82, 0x83, 0x7F,
	0x7D, 0x7F, 0x7B, 0x7D, 0x7E, 0x7D, 0x7F, 0x81, 0x80, 0x81, 0x83, 0x80,
	0x82, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x82, 0x9A,
	0x96, 0xA3, 0xAE, 0x9C, 0xA2, 0x93, 0x82, 0x7C, 0x70, 0x69, 0x67, 0x6D,
	0x6C, 0x77, 0x81, 0x80, 0x8D, 0x8C, 0x8A, 0x8C, 0x86, 0x82, 0x7E, 0x7C,
	0x77, 0x79, 0x7B, 0x78, 0x80, 0x7D, 0x7E, 0x83, 0x7E, 0x81, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x82, 0x7F, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7E, 0x81, 0x7F, 0x80, 0x80, 0x80,
	0x7E, 0x80, 0x7D, 0x84, 0xA1, 0x97, 0xA8, 0xB4, 0x9C, 0x9F, 0x8F, 0x7C,
	0x70, 0x6B, 0x63, 0x60, 0x70, 0x6F, 0x7A, 0x89, 0x87, 0x8E, 0x8F, 0x8A,
	0x85, 0x83, 0x7D, 0x77, 0x7B, 0x77, 0x77, 0x7D, 0x7C, 0x7F, 0x82, 0x83,
	0x83, 0x82, 0x83, 0x7F, 0x80, 0x7E, 0x7D, 0x7F, 0x7E, 0x7F, 0x7F, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x80, 0x81, 0x80, 0x81, 0x7F, 0x81, 0x7D, 0x88, 0xA5, 0x97, 0xAA,
	0xB1, 0x98, 0x97, 0x86, 0x77, 0x68, 0x69, 0x67, 0x64, 0x79, 0x7C, 0x82,
	0x8E, 0x8E, 0x8C, 0x89, 0x87, 0x7B, 0x78, 0x79, 0x73, 0x77, 0x7C, 0x7E,
	0x81, 0x85, 0x87, 0x83, 0x85, 0x82, 0x7E, 0x7D, 0x7D, 0x7B, 0x7C, 0x7F,
	0x7F, 0x80, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7E, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x7C, 0x8D, 0xA8, 0x9A, 0xAE, 0xAE, 0x97, 0x90, 0x80, 0x74, 0x63, 0x6A,
	0x6C, 0x6B, 0x7E, 0x85, 0x88, 0x8E, 0x91, 0x8B, 0x83, 0x83, 0x7B, 0x74,
	0x78, 0x78, 0x78, 0x7D, 0x83, 0x82, 0x84, 0x87, 0x83, 0x81, 0x80, 0x7E,
	0x7B, 0x7C, 0x7E, 0x7C, 0x7F, 0x81, 0x81, 0x81, 0x82, 0x81, 0x7F, 0x7E,
	0x7D, 0x7D, 0x7B, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0xA2, 0xA8, 0xA1, 0xB7, 0xA4, 0x93,
	0x85, 0x7C, 0x6B, 0x60, 0x71, 0x6E, 0x76, 0x85, 0x8D, 0x8E, 0x8D, 0x92,
	0x85, 0x7E, 0x7E, 0x77, 0x73, 0x75, 0x7C, 0x7B, 0x80, 0x87, 0x85, 0x85,
	0x85, 0x84, 0x7E, 0x7D, 0x7E, 0x79, 0x7B, 0x7E, 0x7F, 0x7F, 0x82, 0x85,
	0x81, 0x83, 0x83, 0x80, 0x7E, 0x7E, 0x7E, 0x7C, 0x7E, 0x80, 0x7F, 0x80,
	0x81, 0x81, 0x80, 0x81, 0x80, 0x7E, 0x80, 0x7E, 0x80, 0x7C, 0x9C, 0xAC,
	0x9E, 0xB3, 0xA9, 0x96, 0x86, 0x7D, 0x71, 0x60, 0x6C, 0x71, 0x72, 0x80,
	0x8B, 0x90, 0x8D, 0x92, 0x8E, 0x81, 0x7F, 0x7B, 0x75, 0x73, 0x78, 0x7B,
	0x7B, 0x82, 0x87, 0x85, 0x86, 0x86, 0x83, 0x7E, 0x7E, 0x7D, 0x79, 0x7D,
	0x7F, 0x7F, 0x81, 0x83, 0x84, 0x82, 0x82, 0x83, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7D, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x9B, 0xA2, 0x9E, 0xAD, 0xA3, 0x99, 0x8E, 0x88, 0x81, 0x72,
	0x76, 0x75, 0x6E, 0x75, 0x79, 0x7C, 0x7E, 0x85, 0x89, 0x86, 0x88, 0x89,
	0x85, 0x82, 0x81, 0x7F, 0x7B, 0x7B, 0x7D, 0x7A, 0x7B, 0x7E, 0x7F, 0x80,
	0x81, 0x83, 0x83, 0x82, 0x84, 0x83, 0x81, 0x82, 0x81, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x80, 0x81, 0x80, 0x80, 0x7E, 0x88, 0x9B, 0x9A, 0x9F, 0xA3, 0x9C, 0x99,
	0x95, 0x96, 0x91, 0x87, 0x85, 0x7D, 0x74, 0x75, 0x75, 0x75, 0x76, 0x77,
	0x7C, 0x7B, 0x7F, 0x86, 0x87, 0x89, 0x8A, 0x8A, 0x89, 0x86, 0x86, 0x85,
	0x82, 0x80, 0x7E, 0x7C, 0x7B, 0x7A, 0x7B, 0x7B, 0x7C, 0x7D, 0x7E, 0x80,
	0x81, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x80, 0x7F, 0x7E,
	0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x81, 0x81, 0x88, 0x97, 0x99, 0x9B,
	0x9D, 0x99, 0x99, 0x96, 0x96, 0x93, 0x88, 0x83, 0x7D, 0x78, 0x79, 0x77,
	0x77, 0x76, 0x75, 0x7A, 0x7D, 0x82, 0x87, 0x88, 0x89, 0x8A, 0x8A, 0x8C,
	0x8A, 0x89, 0x86, 0x81, 0x7F, 0x7D, 0x7B, 0x7B, 0x79, 0x78, 0x79, 0x79,
	0x7C, 0x7E, 0x80, 0x82, 0x82, 0x84, 0x85, 0x85, 0x86, 0x85, 0x83, 0x82,
	0x80, 0x80, 0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x81, 0x91,
	0x97, 0x98, 0x9C, 0x97, 0x97, 0x97, 0x95, 0x94, 0x8B, 0x83, 0x7F, 0x78,
	0x79, 0x78, 0x76, 0x76, 0x74, 0x78, 0x7C, 0x80, 0x85, 0x86, 0x87, 0x89,
	0x8A, 0x8C, 0x8B, 0x89, 0x86, 0x82, 0x80, 0x7E, 0x7C, 0x7B, 0x79, 0x78,
	0x78, 0x7A, 0x7C, 0x7E, 0x80, 0x81, 0x82, 0x84, 0x85, 0x86, 0x85, 0x84,
	0x83, 0x82, 0x81, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B, 0x7C, 0x7D, 0x7F,
	0x8C, 0x94, 0x94, 0x98, 0x96, 0x95, 0x96, 0x95, 0x94, 0x8C, 0x85, 0x80,
	0x7A, 0x7A, 0x78, 0x76, 0x76, 0x74, 0x78, 0x7B, 0x80, 0x84, 0x85, 0x87,
	0x89, 0x8B, 0x8C, 0x8B, 0x8A, 0x87, 0x83, 0x81, 0x7F, 0x7D, 0x7B, 0x79,
	0x78, 0x77, 0x79, 0x7B, 0x7C, 0x7E, 0x80, 0x82, 0x84, 0x85, 0x86, 0x86,
	0x86, 0x85, 0x83, 0x82, 0x81, 0x7F, 0x7D, 0x7C, 0x7B, 0x7A, 0x7B, 0x7B,
	0x82, 0x8C, 0x8D, 0x91, 0x93, 0x92, 0x95, 0x95, 0x96, 0x92, 0x8B, 0x88,
	0x82, 0x80, 0x7D, 0x7A, 0x78, 0x75, 0x76, 0x78, 0x7B, 0x7E, 0x80, 0x83,
	0x84, 0x87, 0x8A, 0x8B, 0x8C, 0x8A, 0x88, 0x86, 0x84, 0x83, 0x80, 0x7E,
	0x7B, 0x79, 0x79, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7F, 0x81, 0x84, 0x85,
	0x86, 0x86, 0x86, 0x86, 0x85, 0x84, 0x83, 0x81, 0x7F, 0x7E, 0x7D, 0x7D,
	0x82, 0x86, 0x86, 0x88, 0x89, 0x8A, 0x8C, 0x8E, 0x90, 0x8D, 0x8B, 0x89,
	0x87, 0x86, 0x84, 0x82, 0x7F, 0x7D, 0x7C, 0x7C, 0x7D, 0x7E, 0x7E, 0x7F,
	0x80, 0x82, 0x84, 0x86, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x86, 0x85,
	0x83, 0x82, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x86,
	0x8A, 0x89, 0x8A, 0x8A, 0x89, 0x8A, 0x8A, 0x8B, 0x89, 0x88, 0x87, 0x85,
	0x84, 0x84, 0x83, 0x82, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81,
	0x82, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83,
	0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x84, 0x87,
	0x87, 0x88, 0x89, 0x89, 0x89, 0x8B, 0x8C, 0x8A, 0x89, 0x88, 0x87, 0x86,
	0x86, 0x85, 0x84, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x83, 0x82,
	0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x82, 0x82,
	0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x85, 0x85, 0x85, 0x86, 0x87,
	0x87, 0x85, 0x86, 0x87, 0x85, 0x85, 0x86, 0x85, 0x84, 0x84, 0x84, 0x83,
	0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F
};
const unsigned char WAVcrop[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x82, 0x81, 0x7E, 0x7F, 0x81, 0x81,
	0x7F, 0x7E, 0x7E, 0x81, 0x80, 0x7E, 0x7D, 0x80, 0x82, 0x81, 0x7E, 0x7E,
	0x80, 0x81, 0x7F, 0x7E, 0x80, 0x82, 0x82, 0x7F, 0x7D, 0x7F, 0x83, 0x83,
	0x7F, 0x7C, 0x7D, 0x81, 0x82, 0x7F, 0x7B, 0x7D, 0x82, 0x83, 0x81, 0x7D,
	0x7D, 0x80, 0x81, 0x7F, 0x7E, 0x80, 0x82, 0x81, 0x7E, 0x7D, 0x7F, 0x80,
	0x7F, 0x7D, 0x7D, 0x80, 0x82, 0x81, 0x7E, 0x7E, 0x81, 0x84, 0x82, 0x7E,
	0x7B, 0x7D, 0x81, 0x83, 0x80, 0x7D, 0x7E, 0x82, 0x83, 0x80, 0x7C, 0x7D,
	0x82, 0x83, 0x80, 0x7D, 0x7D, 0x7F, 0x81, 0x82, 0x82, 0x7E, 0x7B, 0x7D,
	0x84, 0x85, 0x7F, 0x7B, 0x7C, 0x82, 0x84, 0x80, 0x7C, 0x7D, 0x81, 0x82,
	0x80, 0x7D, 0x7C, 0x7E, 0x82, 0x82, 0x7F, 0x7D, 0x7E, 0x82, 0x84, 0x81,
	0x7D, 0x7C, 0x7E, 0x80, 0x81, 0x81, 0x7E, 0x7C, 0x7F, 0x82, 0x81, 0x81,
	0x80, 0x7F, 0x7D, 0x7C, 0x7F, 0x84, 0x84, 0x80, 0x7C, 0x7A, 0x7F, 0x85,
	0x85, 0x7E, 0x78, 0x7A, 0x82, 0x86, 0x80, 0x79, 0x7A, 0x83, 0x87, 0x84,
	0x7D, 0x7B, 0x7F, 0x85, 0x85, 0x7D, 0x79, 0x7E, 0x83, 0x83, 0x7E, 0x79,
	0x79, 0x81, 0x87, 0x85, 0x80, 0x7E, 0x7F, 0x81, 0x82, 0x80, 0x7E, 0x7E,
	0x7F, 0x7D, 0x7D, 0x7F, 0x80, 0x81, 0x81, 0x7D, 0x7E, 0x84, 0x85, 0x80,
	0x77, 0x76, 0x7F, 0x88, 0x84, 0x78, 0x74, 0x7E, 0x8A, 0x8B, 0x80, 0x77,
	0x7B, 0x83, 0x87, 0x83, 0x7B, 0x77, 0x7C, 0x85, 0x86, 0x7F, 0x79, 0x7B,
	0x81, 0x85, 0x85, 0x80, 0x7B, 0x7B, 0x7E, 0x82, 0x82, 0x7E, 0x7C, 0x7D,
	0x7F, 0x83, 0x85, 0x82, 0x7B, 0x77, 0x7C, 0x85, 0x87, 0x7D, 0x74, 0x7A,
	0x88, 0x89, 0x83, 0x7C, 0x7D, 0x83, 0x83, 0x7D, 0x78, 0x7B, 0x81, 0x85,
	0x81, 0x7D, 0x7F, 0x82, 0x82, 0x7F, 0x7F, 0x81, 0x82, 0x81, 0x80, 0x7E,
	0x7F, 0x81, 0x80, 0x7F, 0x7E, 0x80, 0x85, 0x84, 0x82, 0x7E, 0x7B, 0x7C,
	0x7F, 0x82, 0x82, 0x80, 0x7C, 0x7E, 0x82, 0x84, 0x7F, 0x7C, 0x80, 0x84,
	0x84, 0x81, 0x7D, 0x7C, 0x80, 0x81, 0x80, 0x7E, 0x7C, 0x7D, 0x7F, 0x81,
	0x82, 0x7F, 0x80, 0x83, 0x83, 0x83, 0x81, 0x7C, 0x7D, 0x80, 0x80, 0x80,
	0x7D, 0x7D, 0x7E, 0x80, 0x82, 0x81, 0x7B, 0x7B, 0x82, 0x85, 0x81, 0x7D,
	0x7C, 0x7D, 0x82, 0x83, 0x7E, 0x7C, 0x7D, 0x7E, 0x83, 0x85, 0x81, 0x7B,
	0x77, 0x7D, 0x86, 0x88, 0x7D, 0x74, 0x7A, 0x85, 0x8B, 0x83, 0x7A, 0x79,
	0x81, 0x85, 0x84, 0x80, 0x7A, 0x7A, 0x83, 0x85, 0x81, 0x7D, 0x79, 0x7A,
	0x82, 0x88, 0x84, 0x7D, 0x79, 0x7C, 0x85, 0x87, 0x81, 0x7B, 0x7A, 0x7F,
	0x84, 0x85, 0x80, 0x7A, 0x7C, 0x81, 0x84, 0x86, 0x80, 0x78, 0x7E, 0x84,
	0x87, 0x83, 0x7A, 0x76, 0x7C, 0x84, 0x85, 0x82, 0x7D, 0x7D, 0x81, 0x83,
	0x81, 0x7E, 0x7D, 0x7C, 0x81, 0x85, 0x82, 0x7C, 0x7A, 0x7E, 0x83, 0x82,
	0x7E, 0x7E, 0x7F, 0x7E, 0x7D, 0x81, 0x84, 0x81, 0x7D, 0x7D, 0x7F, 0x81,
	0x84, 0x80, 0x7D, 0x7C, 0x7E, 0x81, 0x82, 0x7F, 0x7E, 0x7E, 0x7E, 0x83,
	0x84, 0x80, 0x7A, 0x79, 0x80, 0x86, 0x84, 0x7A, 0x77, 0x7E, 0x86, 0x88,
	0x80, 0x79, 0x7C, 0x82, 0x84, 0x82, 0x7C, 0x79, 0x7E, 0x84, 0x83, 0x7E,
	0x7B, 0x7C, 0x81, 0x85, 0x81, 0x7D, 0x7D, 0x7E, 0x80, 0x82, 0x81, 0x7F,
	0x7E, 0x7F, 0x80, 0x82, 0x83, 0x7F, 0x7C, 0x7D, 0x80, 0x83, 0x83, 0x7F,
	0x7A, 0x7D, 0x82, 0x83, 0x7E, 0x7B, 0x7C, 0x80, 0x84, 0x81, 0x7D, 0x7D,
	0x7E, 0x80, 0x82, 0x82, 0x7F, 0x7E, 0x7F, 0x80, 0x83, 0x83, 0x7F, 0x7C,
	0x7E, 0x81, 0x83, 0x82, 0x7F, 0x7D, 0x7F, 0x83, 0x84, 0x81, 0x7C, 0x7C,
	0x80, 0x84, 0x83, 0x7E, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x7E,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x80,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x86, 0x89, 0x87, 0x83, 0x82,
	0x82, 0x83, 0x82, 0x80, 0x7D, 0x7D, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x7F,
	0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7E, 0x7E, 0x80, 0x8B, 0x9E, 0xA7, 0x9E, 0x93, 0x8E, 0x8C, 0x87,
	0x81, 0x7B, 0x73, 0x72, 0x79, 0x7F, 0x7F, 0x7F, 0x81, 0x84, 0x85, 0x86,
	0x84, 0x80, 0x7D, 0x7E, 0x80, 0x7E, 0x7B, 0x7C, 0x7E, 0x7F, 0x80, 0x81,
	0x81, 0x80, 0x80, 0x82, 0x81, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7D, 0x87, 0xA9, 0xC7, 0xC1, 0xA0, 0x8D, 0x8B, 0x88, 0x7D, 0x70, 0x65,
	0x62, 0x70, 0x86, 0x8F, 0x88, 0x85, 0x8C, 0x92, 0x8E, 0x85, 0x7C, 0x74,
	0x73, 0x79, 0x7E, 0x7A, 0x78, 0x7E, 0x87, 0x8B, 0x89, 0x85, 0x81, 0x7E,
	0x7F, 0x80, 0x7C, 0x77, 0x78, 0x7D, 0x81, 0x83, 0x83, 0x82, 0x81, 0x82,
	0x83, 0x81, 0x7D, 0x7B, 0x7C, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x8E,
	0xBB, 0xE2, 0xD3, 0x9F, 0x82, 0x84, 0x84, 0x74, 0x64, 0x57, 0x58, 0x71,
	0x95, 0xA1, 0x92, 0x89, 0x92, 0x99, 0x8F, 0x80, 0x70, 0x65, 0x68, 0x78,
	0x81, 0x7C, 0x79, 0x84, 0x90, 0x93, 0x8F, 0x87, 0x7C, 0x77, 0x7B, 0x7E,
	0x77, 0x72, 0x77, 0x81, 0x86, 0x88, 0x87, 0x83, 0x81, 0x83, 0x84, 0x7E,
	0x77, 0x77, 0x7B, 0x7E, 0x80, 0x81, 0x81, 0x81, 0x84, 0x87, 0xA7, 0xDC,
	0xE5, 0xAE, 0x7B, 0x7C, 0x88, 0x7A, 0x62, 0x57, 0x56, 0x6D, 0x95, 0xA9,
	0x96, 0x86, 0x90, 0x9D, 0x91, 0x7B, 0x6B, 0x62, 0x67, 0x79, 0x85, 0x7D,
	0x79, 0x87, 0x98, 0x95, 0x8B, 0x7E, 0x73, 0x70, 0x79, 0x7D, 0x74, 0x71,
	0x7E, 0x8C, 0x8D, 0x89, 0x84, 0x80, 0x7E, 0x82, 0x7E, 0x76, 0x72, 0x7B,
	0x82, 0x84, 0x82, 0x83, 0x82, 0x84, 0x84, 0x83, 0x7A, 0x85, 0xC9, 0xF4,
	0xDB, 0x90, 0x73, 0x80, 0x7C, 0x69, 0x57, 0x4D, 0x5F, 0x96, 0xB8, 0xA2,
	0x83, 0x89, 0x96, 0x8D, 0x78, 0x65, 0x58, 0x66, 0x86, 0x93, 0x82, 0x7C,
	0x8C, 0x97, 0x90, 0x82, 0x73, 0x6B, 0x76, 0x85, 0x81, 0x76, 0x7B, 0x89,
	0x8E, 0x8A, 0x81, 0x77, 0x76, 0x80, 0x83, 0x7B, 0x75, 0x7D, 0x85, 0x88,
	0x85, 0x80, 0x7A, 0x7E, 0x84, 0x81, 0x7A, 0x79, 0x80, 0x84, 0xC2, 0xF2,
	0xE8, 0xA3, 0x72, 0x73, 0x67, 0x62, 0x5C, 0x51, 0x65, 0xA6, 0xC2, 0xA3,
	0x83, 0x80, 0x7C, 0x79, 0x75, 0x61, 0x58, 0x7A, 0x9E, 0x9A, 0x88, 0x83,
	0x82, 0x83, 0x86, 0x77, 0x64, 0x66, 0x78, 0x81, 0x85, 0x84, 0x81, 0x83,
	0x8C, 0x85, 0x76, 0x72, 0x78, 0x7E, 0x84, 0x84, 0x7E, 0x7F, 0x87, 0x87,
	0x7E, 0x79, 0x79, 0x7C, 0x82, 0x84, 0x7E, 0x7D, 0x82, 0x86, 0x81, 0xB5,
	0xED, 0xD2, 0x9A, 0x75, 0x5B, 0x60, 0x78, 0x6C, 0x63, 0x84, 0xA5, 0xA9,
	0x9E, 0x7C, 0x61, 0x6C, 0x7D, 0x77, 0x72, 0x7B, 0x86, 0x98, 0x9B, 0x83,
	0x6F, 0x72, 0x7B, 0x7E, 0x7E, 0x76, 0x77, 0x88, 0x8E, 0x87, 0x7E, 0x75,
	0x77, 0x82, 0x83, 0x7C, 0x7C, 0x7E, 0x85, 0x89, 0x82, 0x78, 0x7A, 0x7D,
	0x83, 0x82, 0x7E, 0x7B, 0x81, 0x84, 0x83, 0x7F, 0x7A, 0x7C, 0x81, 0x84,
	0x88, 0xCE, 0xF3, 0xD2, 0x9B, 0x56, 0x41, 0x65, 0x78, 0x7A, 0x82, 0x89,
	0xA6, 0xB4, 0x92, 0x6B, 0x58, 0x5B, 0x7C, 0x8B, 0x83, 0x83, 0x8A, 0x92,
	0x95, 0x7E, 0x67, 0x68, 0x75, 0x85, 0x88, 0x7E, 0x7E, 0x85, 0x8A, 0x87,
	0x78, 0x6F, 0x76, 0x81, 0x89, 0x86, 0x7E, 0x7E, 0x82, 0x84, 0x82, 0x78,
	0x77, 0x7E, 0x83, 0x88, 0x81, 0x7D, 0x7D, 0x80, 0x82, 0x80, 0x7A, 0x7C,
	0x7C, 0x85, 0x7E, 0x9D, 0xDB, 0xDD, 0xBE, 0x72, 0x3E, 0x4E, 0x6C, 0x8B,
	0x91, 0x85, 0x96, 0xA1, 0x9C, 0x82, 0x5A, 0x55, 0x6C, 0x89, 0x9A, 0x8E,
	0x82, 0x84, 0x86, 0x85, 0x75, 0x67, 0x6B, 0x7D, 0x90, 0x93, 0x87, 0x7B,
	0x79, 0x7E, 0x7F, 0x7A, 0x76, 0x7B, 0x85, 0x8D, 0x89, 0x7E, 0x77, 0x79,
	0x7F, 0x82, 0x7F, 0x7D, 0x7F, 0x84, 0x86, 0x82, 0x7B, 0x79, 0x7C, 0x83,
	0x88, 0x83, 0x82, 0x7A, 0x82, 0x7A, 0x9C, 0xD3, 0xD7, 0xBC, 0x69, 0x44,
	0x4C, 0x73, 0x98, 0x92, 0x8F, 0x8D, 0x99, 0x98, 0x7B, 0x60, 0x57, 0x6F,
	0x90, 0x9C, 0x94, 0x80, 0x7B, 0x7F, 0x83, 0x7B, 0x70, 0x72, 0x80, 0x91,
	0x92, 0x85, 0x77, 0x73, 0x7D, 0x81, 0x82, 0x7C, 0x7D, 0x84, 0x88, 0x88,
	0x7C, 0x78, 0x76, 0x80, 0x84, 0x83, 0x7F, 0x7E, 0x80, 0x83, 0x81, 0x7D,
	0x7A, 0x7C, 0x80, 0x84, 0x83, 0x7E, 0x7F, 0x7C, 0x83, 0x7B, 0xAC, 0xD3,
	0xD5, 0xA3, 0x4E, 0x3E, 0x50, 0x91, 0xA4, 0x9D, 0x8B, 0x85, 0x97, 0x8B,
	0x78, 0x59, 0x5F, 0x7C, 0x9C, 0xA5, 0x8E, 0x7C, 0x71, 0x7B, 0x7E, 0x79,
	0x75, 0x79, 0x8B, 0x93, 0x8F, 0x7E, 0x71, 0x73, 0x7C, 0x84, 0x82, 0x80,
	0x80, 0x85, 0x87, 0x81, 0x7A, 0x75, 0x7B, 0x82, 0x86, 0x83, 0x7F, 0x7F,
	0x81, 0x81, 0x7F, 0x7B, 0x7C, 0x7F, 0x84, 0x83, 0x82, 0x7C, 0x7F, 0x7D,
	0x83, 0x7C, 0x8C, 0xC7, 0xDB, 0xC8, 0x6D, 0x3B, 0x3D, 0x77, 0xA8, 0xA4,
	0x95, 0x80, 0x92, 0x91, 0x83, 0x63, 0x5B, 0x75, 0x94, 0xA5, 0x91, 0x7D,
	0x73, 0x7B, 0x82, 0x7B, 0x76, 0x76, 0x87, 0x91, 0x90, 0x80, 0x73, 0x74,
	0x7C, 0x84, 0x81, 0x80, 0x7F, 0x84, 0x87, 0x81, 0x7B, 0x76, 0x7C, 0x82,
	0x86, 0x85, 0x7F, 0x7F, 0x7D, 0x81, 0x7E, 0x7E, 0x7D, 0x80, 0x83, 0x83,
	0x80, 0x7E, 0x7C, 0x80, 0x7E, 0x83, 0x7A, 0x95, 0xCB, 0xDC, 0xBF, 0x62,
	0x3B, 0x41, 0x84, 0xA6, 0xA4, 0x8F, 0x82, 0x95, 0x8C, 0x7F, 0x5B, 0x60,
	0x77, 0x99, 0xA1, 0x8F, 0x7E, 0x74, 0x7D, 0x7C, 0x79, 0x74, 0x7B, 0x8B,
	0x90, 0x8D, 0x7B, 0x76, 0x75, 0x7E, 0x81, 0x80, 0x81, 0x80, 0x89, 0x80,
	0x7C, 0x71, 0x77, 0x80, 0x87, 0x87, 0x7F, 0x7E, 0x7D, 0x81, 0x7E, 0x7C,
	0x7B, 0x7F, 0x84, 0x84, 0x82, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x7D, 0x81,
	0x7D, 0xAD, 0xD2, 0xD7, 0x9C, 0x4A, 0x37, 0x51, 0x98, 0xA9, 0xA6, 0x89,
	0x89, 0x90, 0x86, 0x72, 0x58, 0x69, 0x82, 0xA2, 0x9D, 0x8B, 0x78, 0x74,
	0x7C, 0x7A, 0x79, 0x76, 0x82, 0x8D, 0x91, 0x87, 0x78, 0x74, 0x76, 0x80,
	0x80, 0x80, 0x80, 0x83, 0x88, 0x83, 0x7E, 0x76, 0x7A, 0x7E, 0x84, 0x83,
	0x81, 0x80, 0x7F, 0x81, 0x7E, 0x7D, 0x7C, 0x7E, 0x82, 0x82, 0x82, 0x7E,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7D, 0x88, 0x8A, 0xB9, 0xD5, 0xCF, 0x91, 0x46,
	0x3C, 0x5C, 0x9F, 0xAC, 0xA5, 0x8A, 0x89, 0x8E, 0x83, 0x71, 0x5A, 0x6D,
	0x86, 0xA3, 0x9C, 0x89, 0x77, 0x73, 0x7C, 0x7A, 0x7B, 0x77, 0x84, 0x8B,
	0x8C, 0x82, 0x76, 0x78, 0x79, 0x83, 0x7F, 0x80, 0x80, 0x82, 0x86, 0x7F,
	0x7E, 0x77, 0x7E, 0x7F, 0x84, 0x82, 0x7F, 0x81, 0x7F, 0x81, 0x7D, 0x7E,
	0x7C, 0x80, 0x82, 0x82, 0x81, 0x7E, 0x7C, 0x7D, 0x7D, 0x82, 0x7F, 0x84,
	0x7A, 0x94, 0xC6, 0xD9, 0xBC, 0x63, 0x38, 0x41, 0x84, 0xAF, 0xAC, 0x92,
	0x7E, 0x8D, 0x8D, 0x82, 0x63, 0x5E, 0x75, 0x96, 0xA5, 0x93, 0x80, 0x70,
	0x73, 0x77, 0x78, 0x7C, 0x7F, 0x8C, 0x8E, 0x8B, 0x7E, 0x74, 0x75, 0x79,
	0x81, 0x81, 0x84, 0x84, 0x85, 0x83, 0x7E, 0x7A, 0x78, 0x7D, 0x80, 0x84,
	0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7F, 0x83, 0x85, 0x84, 0x7E, 0x7C, 0x7C,
	0x81, 0x82, 0x81, 0x7F, 0x7F, 0x80, 0x83, 0x7D, 0xA0, 0xCD, 0xD8, 0xAC,
	0x54, 0x34, 0x4C, 0x92, 0xB4, 0xA8, 0x8C, 0x7F, 0x8E, 0x8E, 0x7E, 0x5E,
	0x5B, 0x75, 0x99, 0xA7, 0x95, 0x7F, 0x73, 0x78, 0x7B, 0x7A, 0x76, 0x7B,
	0x89, 0x91, 0x8F, 0x81, 0x76, 0x75, 0x7A, 0x7F, 0x80, 0x81, 0x83, 0x86,
	0x86, 0x80, 0x7B, 0x77, 0x7C, 0x7A, 0x79, 0x77, 0x7D, 0x88, 0x89, 0x86,
	0x79, 0x77, 0x79, 0x7F, 0x82, 0x7F, 0x80, 0x7E, 0x84, 0x81, 0x80, 0x7A,
	0x7D, 0x7C, 0x8E, 0xC9, 0xE1, 0xD0, 0x77, 0x37, 0x36, 0x6F, 0xAE, 0xAD,
	0x98, 0x79, 0x85, 0x92, 0x8D, 0x77, 0x62, 0x71, 0x85, 0x97, 0x8D, 0x80,
	0x7C, 0x81, 0x88, 0x7F, 0x77, 0x74, 0x80, 0x89, 0x88, 0x82, 0x7A, 0x7E,
	0x81, 0x83, 0x7E, 0x7A, 0x7D, 0x81, 0x84, 0x7F, 0x7C, 0x7D, 0x80, 0x83,
	0x81, 0x7E, 0x7D, 0x7F, 0x81, 0x81, 0x7F, 0x7D, 0x7F, 0x80, 0x81, 0x7F,
	0x7E, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0xA5, 0xCA, 0xD9,
	0xBC, 0x81, 0x64, 0x60, 0x7E, 0x8A, 0x89, 0x83, 0x85, 0x92, 0x8F, 0x87,
	0x76, 0x76, 0x7F, 0x87, 0x87, 0x7D, 0x7C, 0x7E, 0x86, 0x85, 0x7F, 0x7B,
	0x7C, 0x83, 0x83, 0x81, 0x7D, 0x7D, 0x82, 0x83, 0x83, 0x7E, 0x7D, 0x7F,
	0x81, 0x82, 0x7F, 0x7E, 0x7E, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x80, 0x80,
	0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x86, 0x93, 0x9C, 0x9F, 0x95, 0x8A, 0x83, 0x81, 0x83,
	0x81, 0x80, 0x7F, 0x81, 0x84, 0x82, 0x7F, 0x7B, 0x7C, 0x7E, 0x80, 0x80,
	0x7E, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x83, 0x85,
	0x87, 0x87, 0x86, 0x85, 0x85, 0x85, 0x84, 0x83, 0x82, 0x82, 0x82, 0x82,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVfail[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x81, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x7E,
	0x81, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x82, 0x80, 0x80, 0x81, 0x7E,
	0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7F, 0x82, 0x80, 0x7F, 0x81, 0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x80,
	0x7F, 0x80, 0x82, 0x81, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7D, 0x7D, 0x7E,
	0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x7D, 0x7E, 0x80, 0x7E, 0x7C, 0x7C,
	0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x81, 0x81, 0x81, 0x83, 0x83, 0x7F, 0x81,
	0x83, 0x7F, 0x7F, 0x80, 0x7D, 0x7B, 0x7D, 0x7E, 0x7F, 0x7F, 0x83, 0x83,
	0x81, 0x83, 0x84, 0x82, 0x81, 0x83, 0x85, 0x83, 0x81, 0x83, 0x83, 0x82,
	0x82, 0x82, 0x84, 0x82, 0x7E, 0x80, 0x80, 0x7C, 0x7C, 0x7E, 0x7E, 0x7B,
	0x7C, 0x7F, 0x7F, 0x7F, 0x83, 0x87, 0x87, 0x86, 0x87, 0x87, 0x82, 0x81,
	0x7F, 0x8A, 0x92, 0x8A, 0x92, 0x98, 0x8F, 0x8A, 0x88, 0x83, 0x7D, 0x76,
	0x79, 0x7A, 0x75, 0x7B, 0x81, 0x81, 0x83, 0x85, 0x87, 0x84, 0x81, 0x82,
	0x80, 0x7B, 0x7C, 0x7D, 0x7B, 0x7D, 0x7E, 0x81, 0x81, 0x81, 0x83, 0x82,
	0x80, 0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F,
	0x82, 0xA1, 0xA3, 0x98, 0xB1, 0xA9, 0x90, 0x8F, 0x86, 0x77, 0x6B, 0x6A,
	0x74, 0x6B, 0x70, 0x86, 0x83, 0x83, 0x8E, 0x8E, 0x87, 0x82, 0x84, 0x80,
	0x75, 0x7A, 0x7D, 0x77, 0x7C, 0x82, 0x82, 0x81, 0x84, 0x86, 0x81, 0x7F,
	0x83, 0x7F, 0x7A, 0x7E, 0x7F, 0x7B, 0x7E, 0x81, 0x80, 0x7F, 0x82, 0x83,
	0x80, 0x7F, 0x82, 0x7F, 0x7D, 0x7E, 0x7D, 0x7C, 0x7C, 0x7D, 0x7F, 0x7D,
	0x83, 0xB4, 0xAC, 0x9E, 0xCA, 0xB0, 0x8E, 0x98, 0x84, 0x6B, 0x60, 0x66,
	0x6D, 0x5D, 0x75, 0x8C, 0x7C, 0x8B, 0x9B, 0x8D, 0x86, 0x87, 0x86, 0x75,
	0x73, 0x80, 0x74, 0x73, 0x85, 0x81, 0x7F, 0x87, 0x88, 0x84, 0x7E, 0x85,
	0x81, 0x76, 0x7F, 0x7F, 0x78, 0x7E, 0x81, 0x7F, 0x7F, 0x83, 0x84, 0x7F,
	0x80, 0x83, 0x7E, 0x7D, 0x80, 0x7E, 0x7C, 0x80, 0x80, 0x80, 0x7F, 0x84,
	0x7C, 0x91, 0xC0, 0x9D, 0xAF, 0xD2, 0x9A, 0x93, 0x98, 0x74, 0x61, 0x60,
	0x6A, 0x5D, 0x61, 0x88, 0x7E, 0x7E, 0x9C, 0x92, 0x86, 0x8B, 0x88, 0x7B,
	0x71, 0x7F, 0x78, 0x6D, 0x84, 0x82, 0x7A, 0x88, 0x89, 0x83, 0x80, 0x86,
	0x81, 0x76, 0x80, 0x80, 0x75, 0x7F, 0x83, 0x7C, 0x81, 0x85, 0x82, 0x7E,
	0x83, 0x82, 0x7C, 0x7E, 0x81, 0x7C, 0x7C, 0x81, 0x7F, 0x7B, 0x82, 0x81,
	0x7C, 0x82, 0x80, 0xAE, 0xAE, 0x9A, 0xD2, 0xB1, 0x8E, 0xA4, 0x80, 0x65,
	0x65, 0x65, 0x5F, 0x5C, 0x7D, 0x7F, 0x77, 0x98, 0x93, 0x83, 0x8F, 0x8A,
	0x7C, 0x77, 0x80, 0x79, 0x71, 0x84, 0x81, 0x7B, 0x89, 0x87, 0x80, 0x82,
	0x83, 0x7F, 0x78, 0x7F, 0x7E, 0x76, 0x82, 0x81, 0x7D, 0x83, 0x83, 0x80,
	0x7F, 0x83, 0x7F, 0x7C, 0x80, 0x7F, 0x7D, 0x81, 0x81, 0x80, 0x81, 0x82,
	0x80, 0x7F, 0x7F, 0x82, 0x78, 0xA2, 0xB5, 0x91, 0xC9, 0xC1, 0x8C, 0xA6,
	0x8D, 0x64, 0x67, 0x66, 0x5D, 0x59, 0x78, 0x7D, 0x74, 0x96, 0x92, 0x84,
	0x93, 0x8B, 0x7D, 0x7E, 0x7E, 0x79, 0x75, 0x81, 0x80, 0x7B, 0x88, 0x85,
	0x7F, 0x85, 0x81, 0x7C, 0x7C, 0x7D, 0x7B, 0x7A, 0x81, 0x80, 0x7F, 0x84,
	0x83, 0x80, 0x82, 0x81, 0x7E, 0x7D, 0x7F, 0x7D, 0x7D, 0x80, 0x7F, 0x7F,
	0x82, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x7E, 0xAF, 0xA9, 0x9B,
	0xD6, 0xAB, 0x92, 0xA9, 0x7A, 0x63, 0x69, 0x60, 0x57, 0x61, 0x7F, 0x71,
	0x7D, 0x9B, 0x7F, 0x85, 0x90, 0x78, 0x78, 0x7E, 0x79, 0x77, 0x80, 0x88,
	0x7F, 0x89, 0x8D, 0x7F, 0x85, 0x82, 0x79, 0x7B, 0x7B, 0x79, 0x7B, 0x7F,
	0x81, 0x81, 0x83, 0x84, 0x81, 0x80, 0x83, 0x7D, 0x7E, 0x82, 0x7C, 0x81,
	0x81, 0x80, 0x80, 0x81, 0x80, 0x7E, 0x7F, 0x80, 0x7C, 0x80, 0x7F, 0x7E,
	0x80, 0x83, 0xB4, 0xA5, 0xA1, 0xD6, 0xA2, 0x92, 0xA5, 0x71, 0x60, 0x69,
	0x5F, 0x59, 0x69, 0x83, 0x77, 0x87, 0x9A, 0x82, 0x87, 0x89, 0x77, 0x76,
	0x7A, 0x79, 0x77, 0x82, 0x89, 0x81, 0x8C, 0x8B, 0x7F, 0x83, 0x7E, 0x78,
	0x78, 0x7B, 0x7B, 0x7B, 0x83, 0x84, 0x82, 0x87, 0x85, 0x81, 0x81, 0x7F,
	0x7C, 0x7B, 0x7D, 0x7D, 0x7E, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7E,
	0x7F, 0x7D, 0x7D, 0x7F, 0x80, 0x7D, 0x84, 0x7C, 0xA1, 0xB8, 0x95, 0xC5,
	0xBD, 0x89, 0x9C, 0x85, 0x60, 0x61, 0x66, 0x60, 0x60, 0x81, 0x82, 0x7D,
	0x97, 0x8C, 0x80, 0x87, 0x7D, 0x74, 0x75, 0x7C, 0x7A, 0x7C, 0x8B, 0x86,
	0x85, 0x8B, 0x83, 0x7E, 0x7D, 0x7C, 0x7A, 0x79, 0x80, 0x80, 0x80, 0x86,
	0x83, 0x82, 0x82, 0x7F, 0x7D, 0x7C, 0x7C, 0x7E, 0x7C, 0x81, 0x81, 0x81,
	0x82, 0x82, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x81, 0x80,
	0x84, 0x80, 0x83, 0x7F, 0xA8, 0xB8, 0x99, 0xC7, 0xB9, 0x8B, 0x96, 0x80,
	0x60, 0x5C, 0x66, 0x65, 0x61, 0x84, 0x89, 0x7F, 0x96, 0x8F, 0x7F, 0x80,
	0x7E, 0x75, 0x70, 0x7E, 0x7E, 0x7A, 0x8D, 0x8B, 0x84, 0x8A, 0x86, 0x7E,
	0x7A, 0x7C, 0x79, 0x75, 0x80, 0x80, 0x7E, 0x85, 0x85, 0x82, 0x81, 0x82,
	0x7E, 0x7B, 0x7E, 0x7E, 0x7C, 0x81, 0x81, 0x80, 0x82, 0x82, 0x7F, 0x7F,
	0x7D, 0x7E, 0x7C, 0x7C, 0x7F, 0x7F, 0x7F, 0x83, 0x81, 0x80, 0x82, 0x80,
	0x7F, 0x80, 0xB6, 0xB2, 0xA0, 0xCE, 0xAD, 0x89, 0x8C, 0x77, 0x5F, 0x58,
	0x6C, 0x6D, 0x6A, 0x8D, 0x91, 0x87, 0x90, 0x8F, 0x80, 0x74, 0x7A, 0x77,
	0x6D, 0x7A, 0x84, 0x7F, 0x84, 0x8C, 0x87, 0x7F, 0x82, 0x81, 0x77, 0x78,
	0x7F, 0x7C, 0x7C, 0x84, 0x84, 0x80, 0x82, 0x84, 0x7F, 0x7C, 0x80, 0x7F,
	0x7B, 0x7E, 0x82, 0x7E, 0x7F, 0x83, 0x81, 0x7E, 0x80, 0x81, 0x7E, 0x7D,
	0x80, 0x80, 0x7E, 0x81, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x7E, 0x82,
	0x7B, 0xA7, 0xC4, 0x9F, 0xB9, 0xB7, 0x88, 0x7A, 0x6E, 0x6E, 0x60, 0x64,
	0x8A, 0x88, 0x86, 0x9A, 0x96, 0x88, 0x7B, 0x7D, 0x79, 0x69, 0x74, 0x82,
	0x7D, 0x81, 0x8B, 0x8D, 0x83, 0x7F, 0x84, 0x7C, 0x74, 0x7B, 0x7F, 0x7A,
	0x7D, 0x84, 0x84, 0x80, 0x7F, 0x83, 0x80, 0x7A, 0x7E, 0x7F, 0x7E, 0x7D,
	0x81, 0x83, 0x80, 0x7F, 0x82, 0x80, 0x7D, 0x7E, 0x80, 0x7F, 0x7E, 0x80,
	0x82, 0x80, 0x7F, 0x80, 0x81, 0x7D, 0x77, 0x7B, 0x7E, 0x7B, 0x7E, 0x80,
	0x85, 0x80, 0x88, 0xCB, 0xC0, 0x9E, 0xA7, 0x94, 0x81, 0x5A, 0x5C, 0x7E,
	0x73, 0x78, 0x92, 0x9D, 0x97, 0x7E, 0x82, 0x84, 0x6D, 0x69, 0x77, 0x82,
	0x7B, 0x78, 0x88, 0x8B, 0x7F, 0x79, 0x7D, 0x82, 0x7A, 0x76, 0x81, 0x86,
	0x82, 0x7E, 0x82, 0x86, 0x7E, 0x79, 0x7E, 0x81, 0x7E, 0x7D, 0x80, 0x84,
	0x81, 0x7D, 0x80, 0x81, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x7F, 0x80, 0x80,
	0x80, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80,
	0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x88, 0xC4, 0xC5, 0xA5, 0x93, 0x86, 0x84,
	0x62, 0x5C, 0x71, 0x88, 0x96, 0x8A, 0x8E, 0x90, 0x85, 0x76, 0x66, 0x73,
	0x7C, 0x80, 0x83, 0x86, 0x90, 0x89, 0x7D, 0x77, 0x77, 0x7C, 0x7A, 0x7C,
	0x83, 0x87, 0x88, 0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x7C, 0x7E, 0x82, 0x84,
	0x82, 0x7F, 0x7F, 0x80, 0x7F, 0x7D, 0x7D, 0x80, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x84, 0x83, 0x84, 0x7E, 0x7F, 0x7E, 0x80, 0x7E, 0x80, 0x7E, 0x8E, 0xBD,
	0xC3, 0xAC, 0x7A, 0x6A, 0x72, 0x73, 0x73, 0x6E, 0x89, 0x9C, 0xA0, 0x8C,
	0x76, 0x75, 0x75, 0x79, 0x72, 0x79, 0x87, 0x93, 0x93, 0x83, 0x7B, 0x76,
	0x7C, 0x7A, 0x79, 0x7C, 0x83, 0x8B, 0x88, 0x83, 0x7B, 0x7B, 0x7D, 0x7D,
	0x7D, 0x7D, 0x82, 0x85, 0x85, 0x81, 0x7E, 0x7D, 0x7E, 0x7F, 0x7E, 0x7E,
	0x7F, 0x81, 0x81, 0x82, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7D, 0x99, 0xB8, 0xC9, 0xAC, 0x7A, 0x59, 0x59, 0x75,
	0x84, 0x8A, 0x83, 0x8E, 0x97, 0x9B, 0x88, 0x71, 0x66, 0x6C, 0x7F, 0x86,
	0x88, 0x83, 0x87, 0x89, 0x88, 0x7E, 0x74, 0x72, 0x78, 0x83, 0x85, 0x86,
	0x84, 0x87, 0x88, 0x84, 0x7C, 0x75, 0x76, 0x7C, 0x84, 0x85, 0x85, 0x81,
	0x81, 0x81, 0x81, 0x7D, 0x7B, 0x7B, 0x7E, 0x82, 0x83, 0x83, 0x80, 0x80,
	0x7E, 0x80, 0x7E, 0x7F, 0x7D, 0x80, 0x81, 0x84, 0x83, 0x81, 0x7F, 0x7D,
	0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x80, 0x82, 0x80, 0x81, 0x7E, 0x91, 0xAA,
	0xC0, 0xB6, 0x91, 0x67, 0x53, 0x61, 0x78, 0x8D, 0x8D, 0x8C, 0x89, 0x90,
	0x8F, 0x87, 0x73, 0x67, 0x67, 0x77, 0x89, 0x90, 0x8E, 0x83, 0x80, 0x7E,
	0x81, 0x7D, 0x7A, 0x75, 0x78, 0x7F, 0x88, 0x8A, 0x86, 0x7F, 0x7B, 0x7C,
	0x7D, 0x80, 0x7E, 0x7E, 0x7D, 0x81, 0x84, 0x85, 0x82, 0x7E, 0x7C, 0x7C,
	0x7E, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x7F, 0x7D, 0x7D,
	0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7E, 0x80, 0x7E, 0x86, 0x97, 0xAE, 0xB7, 0xAB, 0x8D, 0x6B, 0x5B, 0x5F,
	0x73, 0x85, 0x8E, 0x8C, 0x8A, 0x89, 0x8B, 0x8A, 0x82, 0x76, 0x6D, 0x6E,
	0x78, 0x85, 0x8C, 0x8C, 0x85, 0x7F, 0x7D, 0x7E, 0x7F, 0x7E, 0x7B, 0x79,
	0x7B, 0x80, 0x85, 0x87, 0x85, 0x80, 0x7C, 0x7B, 0x7D, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x82, 0x82, 0x81, 0x7E, 0x7D, 0x7D, 0x7F, 0x81, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x81, 0x7F, 0x7F, 0x7E, 0x82, 0x8E, 0x9F, 0xAC, 0xAB, 0x9C, 0x82,
	0x6E, 0x66, 0x6C, 0x79, 0x84, 0x88, 0x88, 0x86, 0x88, 0x8A, 0x8A, 0x86,
	0x7D, 0x75, 0x72, 0x76, 0x7E, 0x85, 0x88, 0x86, 0x82, 0x80, 0x80, 0x81,
	0x80, 0x7E, 0x7C, 0x7A, 0x7C, 0x7F, 0x83, 0x85, 0x83, 0x81, 0x7E, 0x7D,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x82, 0x81, 0x80, 0x7F,
	0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x87, 0x93, 0xA1, 0xA8, 0xA5, 0x99, 0x89,
	0x7C, 0x77, 0x79, 0x7E, 0x81, 0x82, 0x82, 0x83, 0x85, 0x88, 0x8A, 0x87,
	0x83, 0x7D, 0x7B, 0x7B, 0x7E, 0x81, 0x82, 0x81, 0x80, 0x80, 0x81, 0x81,
	0x82, 0x80, 0x7F, 0x7D, 0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x81, 0x85, 0x8C, 0x94, 0x9A, 0x9A, 0x94, 0x8D, 0x86, 0x84, 0x84, 0x85,
	0x85, 0x84, 0x82, 0x82, 0x83, 0x85, 0x87, 0x87, 0x85, 0x82, 0x81, 0x81,
	0x81, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x82, 0x86, 0x8B, 0x8E, 0x8E, 0x8B, 0x88, 0x85,
	0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x82, 0x82, 0x83, 0x83, 0x82, 0x81,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x83, 0x86, 0x88, 0x88, 0x86, 0x84, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x82, 0x84, 0x85, 0x85, 0x84, 0x83, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x83,
	0x84, 0x84, 0x83, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x82, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83, 0x81, 0x81, 0x81,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x82,
	0x82, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F
};
const unsigned char WAVfile[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7E, 0x7E,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x81,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x80, 0x81,
	0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x81, 0x80, 0x7E, 0x7D, 0x7F, 0x81, 0x81, 0x82, 0x80, 0x7E, 0x80,
	0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x7D, 0x7C, 0x7C, 0x7F,
	0x7E, 0x7C, 0x7A, 0x7C, 0x80, 0x83, 0x84, 0x81, 0x81, 0x83, 0x87, 0x87,
	0x84, 0x80, 0x7E, 0x82, 0x87, 0x89, 0x89, 0x83, 0x7F, 0x7C, 0x80, 0x85,
	0x86, 0x85, 0x81, 0x80, 0x81, 0x81, 0x84, 0x8F, 0x96, 0x9A, 0x93, 0x87,
	0x7D, 0x78, 0x7A, 0x7B, 0x7C, 0x7C, 0x7F, 0x84, 0x87, 0x88, 0x83, 0x7E,
	0x7B, 0x7B, 0x7E, 0x7E, 0x7F, 0x7B, 0x79, 0x79, 0x7C, 0x80, 0x81, 0x81,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7D, 0x7D, 0x7F, 0x81, 0x81, 0x81,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0x83,
	0x84, 0x86, 0x86, 0x83, 0x7F, 0x7B, 0x7B, 0x7F, 0x9C, 0xB4, 0xC5, 0xB5,
	0x92, 0x71, 0x5D, 0x67, 0x71, 0x7F, 0x7F, 0x81, 0x89, 0x92, 0x9B, 0x91,
	0x80, 0x6E, 0x67, 0x71, 0x7C, 0x87, 0x85, 0x82, 0x81, 0x84, 0x8A, 0x86,
	0x80, 0x74, 0x72, 0x77, 0x81, 0x88, 0x86, 0x83, 0x7D, 0x7F, 0x81, 0x83,
	0x80, 0x7A, 0x79, 0x7A, 0x82, 0x85, 0x85, 0x81, 0x7D, 0x7D, 0x7F, 0x80,
	0x7C, 0x78, 0x75, 0x7C, 0x81, 0x89, 0x86, 0x83, 0x79, 0x8F, 0xB8, 0xD9,
	0xDA, 0xA2, 0x6A, 0x3E, 0x4D, 0x6F, 0x90, 0x98, 0x87, 0x85, 0x89, 0xA0,
	0x9E, 0x8B, 0x69, 0x55, 0x60, 0x7A, 0x97, 0x99, 0x8F, 0x7E, 0x7B, 0x84,
	0x87, 0x84, 0x71, 0x6C, 0x6F, 0x83, 0x91, 0x92, 0x89, 0x79, 0x77, 0x7A,
	0x83, 0x82, 0x7C, 0x77, 0x78, 0x83, 0x89, 0x8B, 0x82, 0x7A, 0x77, 0x7A,
	0x84, 0x84, 0x84, 0x7C, 0x7D, 0x7E, 0x84, 0x85, 0x7F, 0x7E, 0x75, 0x9C,
	0xC5, 0xE8, 0xCE, 0x88, 0x49, 0x31, 0x5C, 0x87, 0xAA, 0x99, 0x88, 0x82,
	0x92, 0xA3, 0x93, 0x75, 0x51, 0x55, 0x6E, 0x95, 0xA2, 0x98, 0x84, 0x77,
	0x7D, 0x82, 0x82, 0x73, 0x6C, 0x70, 0x84, 0x94, 0x96, 0x89, 0x78, 0x72,
	0x77, 0x80, 0x82, 0x7E, 0x7A, 0x7C, 0x86, 0x8B, 0x89, 0x7F, 0x76, 0x78,
	0x80, 0x89, 0x87, 0x80, 0x79, 0x7B, 0x81, 0x87, 0x83, 0x7E, 0x78, 0x7E,
	0x7D, 0x9A, 0xC3, 0xDE, 0xCD, 0x84, 0x48, 0x2E, 0x5E, 0x91, 0xB2, 0xA3,
	0x89, 0x82, 0x8D, 0x9C, 0x89, 0x6E, 0x54, 0x64, 0x85, 0xA5, 0xA5, 0x8E,
	0x77, 0x70, 0x7C, 0x82, 0x81, 0x74, 0x74, 0x7E, 0x90, 0x96, 0x8C, 0x7A,
	0x6E, 0x73, 0x7D, 0x86, 0x84, 0x80, 0x7D, 0x83, 0x87, 0x87, 0x7D, 0x7A,
	0x7A, 0x83, 0x86, 0x84, 0x7F, 0x7B, 0x80, 0x81, 0x85, 0x7E, 0x7E, 0x7A,
	0x82, 0x81, 0x87, 0x7B, 0x94, 0xC0, 0xDF, 0xCA, 0x75, 0x36, 0x29, 0x6F,
	0xAB, 0xC5, 0x9F, 0x7C, 0x76, 0x8D, 0x9B, 0x82, 0x60, 0x4F, 0x72, 0x9C,
	0xB7, 0xA0, 0x7D, 0x63, 0x6B, 0x7F, 0x88, 0x81, 0x76, 0x7B, 0x8A, 0x98,
	0x8F, 0x7C, 0x6A, 0x6C, 0x7A, 0x89, 0x8B, 0x85, 0x7E, 0x7F, 0x82, 0x83,
	0x7C, 0x75, 0x76, 0x7F, 0x89, 0x8A, 0x85, 0x7C, 0x7A, 0x7B, 0x80, 0x80,
	0x7F, 0x7D, 0x82, 0x82, 0x86, 0x7E, 0x80, 0x75, 0x8E, 0xC0, 0xE0, 0xC9,
	0x6C, 0x30, 0x2B, 0x7D, 0xBA, 0xC7, 0x97, 0x71, 0x77, 0x8F, 0x98, 0x75,
	0x5A, 0x59, 0x88, 0xAC, 0xB0, 0x8C, 0x6B, 0x65, 0x76, 0x87, 0x83, 0x7B,
	0x79, 0x87, 0x94, 0x91, 0x7F, 0x6E, 0x6D, 0x79, 0x87, 0x8A, 0x85, 0x7E,
	0x7F, 0x82, 0x82, 0x7D, 0x78, 0x79, 0x7F, 0x86, 0x86, 0x83, 0x7D, 0x7D,
	0x7C, 0x80, 0x7E, 0x7F, 0x7E, 0x82, 0x83, 0x82, 0x7F, 0x7D, 0x7D, 0x7F,
	0x7F, 0x85, 0xBD, 0xDB, 0xD3, 0x7C, 0x39, 0x34, 0x70, 0xAF, 0xAE, 0x98,
	0x7C, 0x91, 0x97, 0x8F, 0x64, 0x54, 0x67, 0x90, 0xA9, 0x9B, 0x87, 0x75,
	0x7E, 0x7C, 0x7C, 0x6F, 0x76, 0x84, 0x94, 0x93, 0x85, 0x79, 0x74, 0x7B,
	0x7B, 0x7F, 0x7D, 0x84, 0x87, 0x89, 0x82, 0x7B, 0x78, 0x7A, 0x7F, 0x80,
	0x82, 0x82, 0x84, 0x83, 0x7F, 0x7D, 0x7B, 0x7D, 0x7F, 0x81, 0x82, 0x80,
	0x83, 0x7E, 0x81, 0x7B, 0x7F, 0x7F, 0x89, 0x82, 0x94, 0xCB, 0xD9, 0xB9,
	0x59, 0x39, 0x50, 0x93, 0xAC, 0x98, 0x89, 0x8B, 0xA4, 0x90, 0x73, 0x52,
	0x66, 0x86, 0x9D, 0x96, 0x86, 0x85, 0x84, 0x85, 0x72, 0x6D, 0x73, 0x83,
	0x8A, 0x88, 0x84, 0x83, 0x84, 0x7C, 0x76, 0x74, 0x7D, 0x85, 0x87, 0x84,
	0x80, 0x81, 0x7F, 0x7D, 0x7A, 0x7B, 0x80, 0x83, 0x85, 0x81, 0x80, 0x7E,
	0x7F, 0x7D, 0x7D, 0x7E, 0x81, 0x84, 0x83, 0x83, 0x7D, 0x80, 0x7B, 0x81,
	0x7C, 0x82, 0x7E, 0x85, 0x7C, 0x93, 0xD5, 0xDA, 0xB2, 0x50, 0x3F, 0x60,
	0x95, 0x9D, 0x86, 0x8F, 0x9D, 0xAC, 0x81, 0x62, 0x58, 0x76, 0x8F, 0x8B,
	0x86, 0x85, 0x94, 0x8B, 0x79, 0x68, 0x70, 0x82, 0x88, 0x86, 0x81, 0x88,
	0x88, 0x80, 0x75, 0x73, 0x7C, 0x83, 0x85, 0x81, 0x83, 0x84, 0x82, 0x7C,
	0x78, 0x7C, 0x7F, 0x84, 0x81, 0x83, 0x85, 0x84, 0x7F, 0x79, 0x7B, 0x7F,
	0x82, 0x81, 0x81, 0x82, 0x82, 0x81, 0x7C, 0x7E, 0x7C, 0x82, 0x7F, 0x81,
	0x81, 0x80, 0x83, 0x79, 0xBC, 0xE1, 0xCB, 0x78, 0x3D, 0x5D, 0x7F, 0x9B,
	0x81, 0x93, 0xA6, 0xAA, 0x86, 0x5D, 0x67, 0x75, 0x8B, 0x7E, 0x87, 0x94,
	0x98, 0x88, 0x6D, 0x70, 0x77, 0x84, 0x7E, 0x82, 0x8A, 0x8E, 0x87, 0x76,
	0x76, 0x79, 0x81, 0x7E, 0x7F, 0x85, 0x87, 0x86, 0x7A, 0x7B, 0x7B, 0x80,
	0x7E, 0x7E, 0x83, 0x84, 0x84, 0x7C, 0x7E, 0x7D, 0x7F, 0x7E, 0x7F, 0x82,
	0x82, 0x83, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x81, 0x80, 0x82, 0x81,
	0x88, 0x80, 0x83, 0x75, 0xA0, 0xE8, 0xCC, 0x90, 0x54, 0x72, 0x7C, 0x6E,
	0x6E, 0x8C, 0xBC, 0xA1, 0x83, 0x6B, 0x7B, 0x7B, 0x68, 0x73, 0x87, 0xA2,
	0x8F, 0x7F, 0x7B, 0x7E, 0x7D, 0x68, 0x76, 0x85, 0x90, 0x87, 0x7D, 0x85,
	0x7F, 0x7B, 0x70, 0x7C, 0x86, 0x84, 0x83, 0x7F, 0x87, 0x80, 0x7A, 0x78,
	0x7E, 0x84, 0x7F, 0x82, 0x81, 0x85, 0x7F, 0x7B, 0x7D, 0x7E, 0x82, 0x78,
	0x7B, 0x7F, 0x83, 0x80, 0x7C, 0x83, 0x80, 0x80, 0x7B, 0x7D, 0x83, 0x7E,
	0x81, 0x7C, 0x84, 0x7E, 0x80, 0x7B, 0x8C, 0xD9, 0xC9, 0x99, 0x6B, 0x73,
	0x7F, 0x5D, 0x6C, 0x89, 0xB2, 0x99, 0x7E, 0x84, 0x80, 0x75, 0x5D, 0x76,
	0x90, 0x8F, 0x87, 0x82, 0x8F, 0x7E, 0x6E, 0x6F, 0x7F, 0x88, 0x7E, 0x84,
	0x89, 0x89, 0x7A, 0x73, 0x7D, 0x7F, 0x7E, 0x7D, 0x85, 0x89, 0x80, 0x7B,
	0x79, 0x80, 0x7C, 0x7B, 0x81, 0x85, 0x85, 0x7E, 0x7E, 0x81, 0x7D, 0x7C,
	0x7D, 0x83, 0x83, 0x7F, 0x81, 0x80, 0x81, 0x7C, 0x7D, 0x80, 0x80, 0x80,
	0x7F, 0x82, 0x80, 0x7E, 0x7F, 0x82, 0x87, 0x7F, 0x82, 0x7A, 0x9D, 0xD3,
	0xAF, 0x8C, 0x76, 0x80, 0x74, 0x57, 0x79, 0x95, 0xA2, 0x89, 0x84, 0x90,
	0x7A, 0x69, 0x67, 0x82, 0x8C, 0x80, 0x88, 0x8E, 0x8B, 0x74, 0x70, 0x76,
	0x73, 0x79, 0x7C, 0x8D, 0x8B, 0x82, 0x7F, 0x7C, 0x7D, 0x74, 0x7A, 0x83,
	0x84, 0x85, 0x80, 0x85, 0x7F, 0x79, 0x7B, 0x7C, 0x83, 0x7F, 0x82, 0x83,
	0x82, 0x7F, 0x7B, 0x7F, 0x7E, 0x7E, 0x7D, 0x80, 0x83, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7D, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x7D, 0x7F,
	0x7F, 0x81, 0x7D, 0x8A, 0xCC, 0xBE, 0x92, 0x79, 0x79, 0x7D, 0x5A, 0x65,
	0x86, 0x9F, 0x95, 0x82, 0x8E, 0x87, 0x72, 0x65, 0x71, 0x89, 0x84, 0x82,
	0x89, 0x8F, 0x84, 0x70, 0x76, 0x7D, 0x7F, 0x7B, 0x80, 0x8D, 0x88, 0x7E,
	0x7A, 0x7E, 0x7F, 0x78, 0x7C, 0x84, 0x8A, 0x83, 0x7E, 0x80, 0x80, 0x7D,
	0x79, 0x7E, 0x83, 0x83, 0x80, 0x80, 0x82, 0x80, 0x7C, 0x7C, 0x7F, 0x82,
	0x7F, 0x7F, 0x82, 0x81, 0x80, 0x7C, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x7F,
	0x7B, 0x7B, 0x7E, 0x81, 0x81, 0x7F, 0x81, 0x7F, 0x82, 0x78, 0x94, 0xC4,
	0xB8, 0x95, 0x6A, 0x73, 0x7B, 0x6D, 0x71, 0x81, 0xA5, 0x9B, 0x87, 0x7D,
	0x7D, 0x7F, 0x6B, 0x71, 0x7F, 0x93, 0x93, 0x84, 0x84, 0x81, 0x81, 0x73,
	0x72, 0x7D, 0x86, 0x89, 0x81, 0x84, 0x84, 0x81, 0x7A, 0x76, 0x7D, 0x81,
	0x83, 0x80, 0x82, 0x85, 0x81, 0x7D, 0x7A, 0x7E, 0x80, 0x7F, 0x7F, 0x81,
	0x83, 0x82, 0x7E, 0x7D, 0x7E, 0x7F, 0x7F, 0x7E, 0x80, 0x82, 0x81, 0x7F,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x82, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x82, 0xA9, 0xC0, 0xB6, 0x88, 0x62, 0x68,
	0x74, 0x81, 0x78, 0x85, 0x97, 0xA1, 0x93, 0x79, 0x72, 0x74, 0x7C, 0x77,
	0x7A, 0x85, 0x90, 0x91, 0x83, 0x7B, 0x79, 0x7C, 0x7B, 0x78, 0x7D, 0x84,
	0x8B, 0x87, 0x81, 0x7C, 0x7D, 0x7E, 0x7C, 0x7C, 0x7D, 0x84, 0x85, 0x84,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x80, 0x81, 0x83, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x82, 0x83, 0x84, 0x81, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7E, 0x80, 0x7D, 0x81,
	0x7C, 0x91, 0xB4, 0xC2, 0xAE, 0x77, 0x5F, 0x5F, 0x7C, 0x84, 0x84, 0x87,
	0x95, 0xA5, 0x98, 0x83, 0x69, 0x6C, 0x75, 0x82, 0x82, 0x82, 0x89, 0x8F,
	0x90, 0x82, 0x77, 0x71, 0x79, 0x7E, 0x81, 0x81, 0x83, 0x87, 0x87, 0x83,
	0x7B, 0x78, 0x7A, 0x7E, 0x81, 0x7F, 0x7F, 0x80, 0x83, 0x83, 0x80, 0x7D,
	0x7C, 0x7E, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7C, 0x7E, 0x7F, 0x82, 0x81, 0x81, 0x7E, 0x7F, 0x99, 0xB1, 0xBF,
	0xA4, 0x7D, 0x5C, 0x5F, 0x74, 0x87, 0x8D, 0x88, 0x8C, 0x90, 0x97, 0x89,
	0x7A, 0x6B, 0x6F, 0x79, 0x86, 0x87, 0x84, 0x83, 0x84, 0x88, 0x84, 0x7E,
	0x75, 0x77, 0x7B, 0x84, 0x85, 0x85, 0x81, 0x81, 0x81, 0x81, 0x7E, 0x7B,
	0x7B, 0x7D, 0x81, 0x83, 0x83, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7D,
	0x7E, 0x7E, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x7E, 0x80, 0x7E, 0x80, 0x7E, 0x80,
	0x7F, 0x81, 0x7E, 0x85, 0x99, 0xB1, 0xBF, 0xAE, 0x8D, 0x67, 0x5B, 0x61,
	0x79, 0x87, 0x8E, 0x8B, 0x8C, 0x8F, 0x90, 0x89, 0x7A, 0x6E, 0x6B, 0x75,
	0x80, 0x8B, 0x8A, 0x87, 0x82, 0x83, 0x81, 0x80, 0x7A, 0x77, 0x77, 0x7E,
	0x84, 0x88, 0x87, 0x82, 0x7E, 0x7D, 0x7E, 0x7E, 0x7F, 0x7D, 0x7E, 0x7E,
	0x82, 0x83, 0x83, 0x80, 0x7E, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x81, 0x8D, 0xA0, 0xB1,
	0xB1, 0x9E, 0x7F, 0x67, 0x60, 0x6A, 0x7A, 0x86, 0x8A, 0x89, 0x89, 0x8C,
	0x8E, 0x8B, 0x82, 0x76, 0x6F, 0x70, 0x79, 0x83, 0x89, 0x89, 0x85, 0x81,
	0x81, 0x81, 0x80, 0x7E, 0x7A, 0x79, 0x7B, 0x80, 0x84, 0x86, 0x84, 0x81,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7C, 0x7D, 0x7E, 0x81, 0x82, 0x82,
	0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x84, 0x8E, 0x9D, 0xA5, 0xA4, 0x96, 0x82, 0x72, 0x6C, 0x71, 0x7A, 0x82,
	0x85, 0x86, 0x86, 0x88, 0x8A, 0x8A, 0x85, 0x7E, 0x77, 0x75, 0x78, 0x7E,
	0x83, 0x85, 0x84, 0x82, 0x81, 0x82, 0x83, 0x83, 0x81, 0x7F, 0x7C, 0x7C,
	0x7E, 0x80, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x81, 0x88, 0x92, 0x9C, 0xA0, 0x9C, 0x90, 0x83, 0x7A, 0x78, 0x7A, 0x7F,
	0x81, 0x81, 0x81, 0x82, 0x85, 0x87, 0x87, 0x85, 0x80, 0x7D, 0x7B, 0x7C,
	0x7F, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x80, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x87,
	0x8F, 0x96, 0x9A, 0x97, 0x91, 0x89, 0x83, 0x81, 0x82, 0x83, 0x83, 0x82,
	0x81, 0x81, 0x83, 0x84, 0x85, 0x84, 0x82, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x84, 0x88, 0x8B, 0x8C, 0x8A, 0x87,
	0x85, 0x83, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x82, 0x82, 0x82, 0x81,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x82, 0x84,
	0x86, 0x86, 0x85, 0x84, 0x83, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x82, 0x84, 0x84, 0x84, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82,
	0x83, 0x84, 0x83, 0x82, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82, 0x81,
	0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80
};
const unsigned char WAVfrequency[] = {
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x81, 0x81,
	0x7E, 0x80, 0x80, 0x7D, 0x81, 0x80, 0x7E, 0x80, 0x7F, 0x7E, 0x81, 0x81,
	0x7E, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7D, 0x7E, 0x81, 0x81, 0x80, 0x7E,
	0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x81, 0x80,
	0x7D, 0x82, 0x81, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x7E, 0x81, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7E, 0x80, 0x82, 0x80, 0x7E, 0x80, 0x81, 0x80, 0x80,
	0x7F, 0x7D, 0x80, 0x81, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0x80, 0x7E, 0x7F,
	0x81, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x7E, 0x7D, 0x80, 0x81, 0x80,
	0x7F, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x82, 0x7F, 0x7E,
	0x80, 0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x81, 0x81, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x7F, 0x82, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7D, 0x7F,
	0x81, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x83, 0x7F, 0x7E, 0x7C, 0x7F, 0x82,
	0x81, 0x7E, 0x7C, 0x7F, 0x82, 0x82, 0x7F, 0x7E, 0x7E, 0x81, 0x81, 0x80,
	0x80, 0x7E, 0x7D, 0x7F, 0x81, 0x82, 0x7F, 0x7E, 0x7F, 0x80, 0x82, 0x82,
	0x7E, 0x7D, 0x80, 0x81, 0x81, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80,
	0x81, 0x80, 0x7C, 0x7F, 0x82, 0x81, 0x7F, 0x7E, 0x7E, 0x81, 0x82, 0x7E,
	0x7E, 0x80, 0x7F, 0x7F, 0x82, 0x80, 0x7E, 0x7E, 0x7E, 0x81, 0x82, 0x80,
	0x7F, 0x7F, 0x7E, 0x81, 0x82, 0x7F, 0x7E, 0x7D, 0x7F, 0x82, 0x81, 0x80,
	0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x82, 0x84, 0x84, 0x83, 0x83, 0x82,
	0x82, 0x81, 0x80, 0x7F, 0x7D, 0x7D, 0x7E, 0x7C, 0x7A, 0x7B, 0x7D, 0x7E,
	0x7E, 0x7E, 0x7D, 0x7E, 0x81, 0x81, 0x7F, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F,
	0x7E, 0x7E, 0x7E, 0x86, 0x90, 0x91, 0x8C, 0x87, 0x85, 0x86, 0x86, 0x83,
	0x7E, 0x79, 0x79, 0x7B, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x81, 0x83, 0x83,
	0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x86, 0x9D, 0xB0, 0xAD,
	0x9A, 0x91, 0x92, 0x92, 0x8A, 0x7E, 0x70, 0x67, 0x6B, 0x77, 0x7C, 0x79,
	0x78, 0x7E, 0x88, 0x8F, 0x90, 0x8B, 0x84, 0x82, 0x84, 0x84, 0x7E, 0x78,
	0x75, 0x76, 0x7A, 0x7C, 0x7D, 0x7C, 0x7E, 0x83, 0x87, 0x86, 0x83, 0x82,
	0x82, 0x82, 0x81, 0x7E, 0x7B, 0x7A, 0x7C, 0x7E, 0x7E, 0x7E, 0x7E, 0x80,
	0x82, 0x86, 0x99, 0xB2, 0xB4, 0x9F, 0x92, 0x96, 0x97, 0x88, 0x76, 0x69,
	0x65, 0x6D, 0x76, 0x74, 0x6F, 0x78, 0x8A, 0x93, 0x90, 0x8D, 0x8A, 0x8B,
	0x8C, 0x87, 0x7B, 0x72, 0x74, 0x79, 0x78, 0x75, 0x76, 0x7B, 0x82, 0x87,
	0x88, 0x85, 0x86, 0x89, 0x88, 0x82, 0x7D, 0x7C, 0x7C, 0x7B, 0x7A, 0x78,
	0x7A, 0x7E, 0x81, 0x81, 0x81, 0x83, 0x86, 0x9D, 0xBD, 0xB7, 0x97, 0x98,
	0xAE, 0xA2, 0x80, 0x72, 0x70, 0x6D, 0x70, 0x70, 0x6B, 0x76, 0x8F, 0x93,
	0x89, 0x90, 0x9C, 0x97, 0x8B, 0x85, 0x7F, 0x7B, 0x79, 0x72, 0x6B, 0x71,
	0x7B, 0x7A, 0x79, 0x83, 0x8A, 0x8A, 0x8A, 0x8A, 0x87, 0x86, 0x84, 0x7D,
	0x78, 0x79, 0x79, 0x75, 0x75, 0x7B, 0x7E, 0x7E, 0x81, 0x84, 0x86, 0x85,
	0x9D, 0xBF, 0xAF, 0x95, 0xB1, 0xBD, 0x8E, 0x79, 0x89, 0x7B, 0x62, 0x65,
	0x65, 0x64, 0x76, 0x7B, 0x73, 0x88, 0x9D, 0x90, 0x8B, 0x9C, 0x98, 0x84,
	0x83, 0x83, 0x78, 0x72, 0x72, 0x6F, 0x74, 0x79, 0x76, 0x7C, 0x89, 0x86,
	0x83, 0x8C, 0x8D, 0x84, 0x83, 0x85, 0x7E, 0x7B, 0x7B, 0x78, 0x78, 0x7C,
	0x79, 0x7C, 0x81, 0x81, 0x7D, 0x97, 0xB8, 0xA1, 0x9C, 0xC9, 0xB8, 0x87,
	0x9D, 0xA3, 0x6C, 0x65, 0x7A, 0x61, 0x55, 0x6A, 0x6A, 0x6D, 0x7E, 0x80,
	0x86, 0x99, 0x90, 0x89, 0x9A, 0x91, 0x7B, 0x85, 0x86, 0x6F, 0x71, 0x7D,
	0x70, 0x6E, 0x7D, 0x7B, 0x79, 0x84, 0x85, 0x84, 0x89, 0x87, 0x85, 0x87,
	0x82, 0x7F, 0x82, 0x7C, 0x79, 0x7D, 0x7D, 0x77, 0x7E, 0x7F, 0x86, 0xAB,
	0xA3, 0x98, 0xC6, 0xB9, 0x8B, 0xAF, 0xA8, 0x66, 0x7B, 0x86, 0x4C, 0x57,
	0x75, 0x53, 0x5A, 0x7F, 0x71, 0x74, 0x91, 0x8C, 0x8B, 0x97, 0x91, 0x8E,
	0x8F, 0x84, 0x83, 0x82, 0x75, 0x78, 0x7C, 0x6F, 0x73, 0x7E, 0x73, 0x74,
	0x84, 0x7B, 0x79, 0x88, 0x81, 0x7E, 0x89, 0x84, 0x7E, 0x87, 0x83, 0x7E,
	0x82, 0x81, 0x7C, 0x84, 0xA1, 0x95, 0x98, 0xC3, 0xAB, 0x99, 0xBF, 0xA0,
	0x79, 0x98, 0x7C, 0x52, 0x6F, 0x64, 0x43, 0x65, 0x6B, 0x55, 0x76, 0x85,
	0x74, 0x8D, 0x9A, 0x88, 0x94, 0x9C, 0x89, 0x8B, 0x8F, 0x7F, 0x7D, 0x80,
	0x77, 0x75, 0x79, 0x77, 0x76, 0x7B, 0x7D, 0x7C, 0x80, 0x84, 0x81, 0x84,
	0x86, 0x82, 0x82, 0x85, 0x7F, 0x80, 0x81, 0x7E, 0x7C, 0x87, 0x9C, 0x8D,
	0xA3, 0xBD, 0x9D, 0xAF, 0xBE, 0x8E, 0x99, 0x9E, 0x69, 0x75, 0x79, 0x4F,
	0x61, 0x6C, 0x50, 0x69, 0x79, 0x67, 0x81, 0x8D, 0x7F, 0x92, 0x98, 0x88,
	0x93, 0x93, 0x84, 0x88, 0x87, 0x7A, 0x7C, 0x7E, 0x74, 0x77, 0x7B, 0x76,
	0x79, 0x7F, 0x7B, 0x7E, 0x84, 0x7F, 0x82, 0x85, 0x7F, 0x82, 0x81, 0x7D,
	0x7E, 0x7F, 0x79, 0x85, 0x95, 0x88, 0xA6, 0xAC, 0x9C, 0xBA, 0xAC, 0x98,
	0xAD, 0x8F, 0x7E, 0x8D, 0x6A, 0x66, 0x71, 0x57, 0x61, 0x6C, 0x5D, 0x6F,
	0x78, 0x72, 0x84, 0x89, 0x84, 0x92, 0x91, 0x8A, 0x93, 0x8C, 0x86, 0x8A,
	0x82, 0x7D, 0x81, 0x79, 0x78, 0x7C, 0x76, 0x78, 0x7C, 0x79, 0x7D, 0x7F,
	0x7D, 0x81, 0x81, 0x81, 0x83, 0x83, 0x81, 0x85, 0x81, 0x87, 0x93, 0x89,
	0xA0, 0x9F, 0x9A, 0xAD, 0x9F, 0x9C, 0xA4, 0x8E, 0x8C, 0x8B, 0x75, 0x79,
	0x72, 0x64, 0x6E, 0x68, 0x64, 0x71, 0x6C, 0x71, 0x7C, 0x79, 0x81, 0x87,
	0x83, 0x8B, 0x8C, 0x87, 0x8E, 0x89, 0x87, 0x8A, 0x84, 0x83, 0x85, 0x7F,
	0x80, 0x80, 0x7C, 0x7E, 0x7D, 0x7B, 0x7E, 0x7C, 0x7C, 0x7E, 0x7C, 0x7D,
	0x7F, 0x7D, 0x7F, 0x7F, 0x88, 0x86, 0x8E, 0x97, 0x92, 0xA0, 0x9D, 0x9C,
	0xA3, 0x98, 0x97, 0x96, 0x8A, 0x89, 0x83, 0x79, 0x7A, 0x74, 0x70, 0x73,
	0x6E, 0x70, 0x73, 0x71, 0x76, 0x78, 0x78, 0x7D, 0x7D, 0x7D, 0x81, 0x80,
	0x80, 0x82, 0x80, 0x82, 0x82, 0x81, 0x83, 0x82, 0x82, 0x84, 0x83, 0x83,
	0x84, 0x83, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x81, 0x7F, 0x80, 0x82,
	0x80, 0x84, 0x84, 0x85, 0x89, 0x87, 0x8A, 0x8B, 0x89, 0x8A, 0x89, 0x87,
	0x88, 0x85, 0x84, 0x84, 0x82, 0x82, 0x82, 0x81, 0x83, 0x83, 0x83, 0x85,
	0x85, 0x85, 0x86, 0x85, 0x86, 0x85, 0x83, 0x83, 0x81, 0x80, 0x80, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x83, 0x84, 0x84, 0x86,
	0x86, 0x87, 0x87, 0x87, 0x87, 0x86, 0x86, 0x85, 0x84, 0x83, 0x83, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x83,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x82, 0x81,
	0x7E, 0x7D, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7D, 0x7E, 0x81, 0x83,
	0x81, 0x7E, 0x7D, 0x7E, 0x80, 0x82, 0x81, 0x7E, 0x7D, 0x7F, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7E,
	0x7F, 0x81, 0x82, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80,
	0x7F, 0x7E, 0x7F, 0x81, 0x82, 0x81, 0x7F, 0x80, 0x82, 0x82, 0x7F, 0x7D,
	0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x82, 0x82, 0x80, 0x7D, 0x7C,
	0x7E, 0x80, 0x81, 0x80, 0x7E, 0x7D, 0x80, 0x82, 0x82, 0x7F, 0x7B, 0x7B,
	0x80, 0x83, 0x83, 0x80, 0x7D, 0x7D, 0x7F, 0x81, 0x81, 0x7F, 0x7F, 0x80,
	0x81, 0x83, 0x82, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7E,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7D, 0x7E, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E,
	0x7D, 0x7D, 0x7F, 0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x82,
	0x81, 0x7E, 0x7C, 0x7D, 0x7F, 0x81, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x81,
	0x82, 0x82, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80,
	0x81, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x81,
	0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7E, 0x7D, 0x7D, 0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81, 0x82, 0x83, 0x83, 0x83,
	0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7E, 0x80, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x7F, 0x7F, 0x84, 0x8A, 0x8D, 0x8D, 0x8A, 0x84, 0x82, 0x81, 0x80,
	0x80, 0x7D, 0x7B, 0x7B, 0x7C, 0x7E, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x83,
	0x93, 0xA4, 0xAF, 0xB0, 0xA3, 0x92, 0x86, 0x7D, 0x7A, 0x75, 0x6D, 0x69,
	0x6A, 0x71, 0x7E, 0x86, 0x89, 0x87, 0x84, 0x84, 0x86, 0x86, 0x83, 0x7D,
	0x78, 0x78, 0x7A, 0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x84, 0x85, 0x82,
	0x7F, 0x7D, 0x7E, 0x80, 0x80, 0x7F, 0x7D, 0x7D, 0x7F, 0x81, 0x82, 0x81,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x8E, 0xAE, 0xC2,
	0xC8, 0xBA, 0x9D, 0x89, 0x7D, 0x72, 0x6A, 0x5D, 0x57, 0x62, 0x73, 0x87,
	0x93, 0x92, 0x8F, 0x8D, 0x8C, 0x8C, 0x83, 0x76, 0x6F, 0x6D, 0x74, 0x7D,
	0x80, 0x80, 0x80, 0x83, 0x88, 0x88, 0x84, 0x7E, 0x7A, 0x7B, 0x7D, 0x7E,
	0x7D, 0x7B, 0x7E, 0x82, 0x84, 0x84, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7E,
	0x7C, 0x7C, 0x7F, 0x80, 0x82, 0x80, 0x80, 0x80, 0x9D, 0xCC, 0xD5, 0xC9,
	0xAC, 0x8F, 0x89, 0x7F, 0x67, 0x56, 0x4E, 0x5F, 0x7D, 0x8A, 0x8F, 0x90,
	0x92, 0x9B, 0x98, 0x87, 0x76, 0x6C, 0x6E, 0x75, 0x76, 0x75, 0x79, 0x81,
	0x8D, 0x90, 0x88, 0x83, 0x81, 0x80, 0x7E, 0x77, 0x74, 0x78, 0x7D, 0x82,
	0x82, 0x81, 0x84, 0x86, 0x85, 0x82, 0x7D, 0x7B, 0x7D, 0x7D, 0x7C, 0x7C,
	0x7E, 0x80, 0x83, 0x82, 0x82, 0x80, 0x83, 0x7B, 0x95, 0xCA, 0xC8, 0xB7,
	0xA3, 0x91, 0x91, 0x7B, 0x5A, 0x59, 0x63, 0x74, 0x82, 0x7F, 0x8C, 0x9C,
	0x9B, 0x94, 0x85, 0x79, 0x7B, 0x75, 0x6D, 0x6F, 0x74, 0x7F, 0x87, 0x86,
	0x88, 0x8B, 0x87, 0x82, 0x7C, 0x79, 0x7A, 0x78, 0x78, 0x7C, 0x7F, 0x83,
	0x84, 0x84, 0x85, 0x83, 0x81, 0x7E, 0x7C, 0x7C, 0x7C, 0x7C, 0x7E, 0x7F,
	0x81, 0x81, 0x82, 0x81, 0x82, 0x80, 0x7F, 0x7E, 0x7E, 0x79, 0x8C, 0xC4,
	0xC5, 0xB8, 0xB5, 0xA3, 0x95, 0x76, 0x60, 0x66, 0x63, 0x62, 0x74, 0x7F,
	0x91, 0x97, 0x94, 0x99, 0x92, 0x84, 0x7D, 0x73, 0x70, 0x70, 0x6F, 0x78,
	0x7F, 0x84, 0x88, 0x8A, 0x8B, 0x88, 0x83, 0x80, 0x7C, 0x78, 0x77, 0x78,
	0x7A, 0x7D, 0x7F, 0x83, 0x85, 0x85, 0x85, 0x83, 0x81, 0x7F, 0x7D, 0x7B,
	0x7C, 0x7B, 0x7D, 0x7F, 0x81, 0x81, 0x83, 0x81, 0x80, 0x7F, 0x7E, 0x7D,
	0x7D, 0x7C, 0x86, 0xB9, 0xBF, 0xB7, 0xBE, 0xA8, 0x94, 0x7B, 0x72, 0x70,
	0x61, 0x64, 0x75, 0x7C, 0x84, 0x92, 0x9B, 0x9C, 0x94, 0x91, 0x8A, 0x7C,
	0x73, 0x74, 0x77, 0x73, 0x7A, 0x81, 0x83, 0x86, 0x8A, 0x8E, 0x8A, 0x86,
	0x85, 0x81, 0x7A, 0x79, 0x7A, 0x79, 0x7A, 0x7D, 0x81, 0x82, 0x83, 0x86,
	0x86, 0x83, 0x83, 0x81, 0x7E, 0x7C, 0x7C, 0x7B, 0x76, 0x77, 0x7A, 0x7A,
	0x7D, 0x80, 0x82, 0x83, 0x82, 0x84, 0x82, 0x81, 0x7F, 0xA0, 0xBC, 0xB1,
	0xB7, 0xAD, 0x9A, 0x8A, 0x7E, 0x82, 0x74, 0x6B, 0x72, 0x72, 0x74, 0x7E,
	0x8B, 0x91, 0x8C, 0x90, 0x92, 0x8A, 0x88, 0x87, 0x82, 0x7B, 0x77, 0x79,
	0x77, 0x75, 0x7B, 0x7E, 0x7F, 0x81, 0x84, 0x86, 0x84, 0x85, 0x86, 0x82,
	0x80, 0x7F, 0x7E, 0x7C, 0x7B, 0x7C, 0x7D, 0x7C, 0x7F, 0x81, 0x81, 0x82,
	0x83, 0x83, 0x83, 0x82, 0x83, 0x81, 0x80, 0x80, 0x7E, 0x7E, 0x7D, 0x7E,
	0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x9A, 0xAF, 0xAE, 0xB4, 0xAD, 0xA2, 0x97,
	0x8E, 0x90, 0x81, 0x74, 0x6F, 0x62, 0x5F, 0x62, 0x6A, 0x72, 0x72, 0x7B,
	0x81, 0x83, 0x8C, 0x92, 0x96, 0x94, 0x8F, 0x8E, 0x87, 0x82, 0x81, 0x7D,
	0x78, 0x74, 0x72, 0x72, 0x72, 0x76, 0x7B, 0x7C, 0x7E, 0x81, 0x83, 0x86,
	0x88, 0x8A, 0x89, 0x87, 0x85, 0x83, 0x81, 0x80, 0x7E, 0x7D, 0x7A, 0x79,
	0x79, 0x79, 0x7B, 0x7C, 0x7E, 0x7F, 0x7F, 0x81, 0x82, 0x83, 0x84, 0x84,
	0x83, 0x83, 0x90, 0x9D, 0xA0, 0xA6, 0xA3, 0x9D, 0x99, 0x96, 0x98, 0x94,
	0x8D, 0x87, 0x7D, 0x77, 0x74, 0x75, 0x78, 0x78, 0x79, 0x79, 0x79, 0x7E,
	0x83, 0x88, 0x8B, 0x8B, 0x8B, 0x89, 0x88, 0x88, 0x85, 0x83, 0x80, 0x7B,
	0x79, 0x76, 0x76, 0x77, 0x77, 0x79, 0x79, 0x7A, 0x7C, 0x7E, 0x81, 0x83,
	0x84, 0x85, 0x85, 0x85, 0x84, 0x84, 0x83, 0x82, 0x80, 0x7F, 0x7D, 0x7C,
	0x7C, 0x7B, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82,
	0x8A, 0x94, 0x99, 0x9E, 0x9E, 0x9B, 0x98, 0x95, 0x94, 0x92, 0x8E, 0x89,
	0x82, 0x7C, 0x78, 0x76, 0x77, 0x78, 0x78, 0x79, 0x7A, 0x7C, 0x7F, 0x83,
	0x87, 0x89, 0x8A, 0x8A, 0x89, 0x89, 0x88, 0x88, 0x87, 0x84, 0x82, 0x7F,
	0x7C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7F, 0x80, 0x82,
	0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x7F, 0x82, 0x8B,
	0x90, 0x96, 0x9A, 0x99, 0x98, 0x97, 0x95, 0x95, 0x93, 0x91, 0x8D, 0x88,
	0x83, 0x7F, 0x7D, 0x7C, 0x7B, 0x7B, 0x7A, 0x79, 0x79, 0x7A, 0x7C, 0x7F,
	0x81, 0x83, 0x83, 0x84, 0x84, 0x85, 0x86, 0x86, 0x86, 0x85, 0x84, 0x82,
	0x81, 0x80, 0x81, 0x84, 0x85, 0x88, 0x89, 0x8A, 0x8A, 0x8A, 0x8A, 0x89,
	0x87, 0x85, 0x83, 0x7F, 0x7B, 0x78, 0x75, 0x73, 0x73, 0x73, 0x72, 0x72,
	0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x74, 0x75, 0x77, 0x79, 0x7B,
	0x7D, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7B, 0x7A, 0x7A, 0x7A, 0x79,
	0x7A, 0x7A, 0x79, 0x7A, 0x79, 0x79, 0x78, 0x78, 0x76, 0x76, 0x76, 0x75,
	0x76, 0x77, 0x77, 0x78, 0x79, 0x7A, 0x7A, 0x7C, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x82, 0x83,
	0x84, 0x85, 0x85, 0x85, 0x84, 0x83, 0x84, 0x85, 0x84, 0x84, 0x86, 0x85,
	0x85, 0x84, 0x83, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7D, 0x7C, 0x7C,
	0x7B, 0x7B, 0x7C, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7B, 0x7C, 0x7D, 0x7C,
	0x7D, 0x7F, 0x7D, 0x7D, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F,
	0x81, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x81, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x7F,
	0x7E, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x80,
	0x7F, 0x7E, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x7E, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x81, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x81, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x7E, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x7E, 0x81, 0x80,
	0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x7F,
	0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7E, 0x81, 0x80, 0x7E, 0x7F, 0x81,
	0x7E, 0x7E, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7D, 0x80, 0x81, 0x7F, 0x7F,
	0x81, 0x80, 0x7D, 0x80, 0x81, 0x7E, 0x7D, 0x82, 0x80, 0x7C, 0x81, 0x82,
	0x7E, 0x7E, 0x81, 0x80, 0x7E, 0x80, 0x82, 0x7F, 0x7E, 0x80, 0x81, 0x7E,
	0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x7D, 0x80, 0x81, 0x7F, 0x80, 0x7F,
	0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x7E, 0x81, 0x82, 0x7E, 0x80, 0x83, 0x7F, 0x81, 0x81, 0x81, 0x7E,
	0x7E, 0x81, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7D, 0x81, 0x80, 0x7E, 0x81,
	0x7F, 0x7D, 0x7F, 0x7F, 0x7F, 0x7C, 0x7F, 0x7F, 0x7D, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x82, 0x81, 0x7F, 0x81, 0x80, 0x7D,
	0x7E, 0x7E, 0x7C, 0x7C, 0x7D, 0x7D, 0x7B, 0x7E, 0x80, 0x7E, 0x7F, 0x7F,
	0x80, 0x7E, 0x7E, 0x7E, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7F, 0x80,
	0x80, 0x83, 0x84, 0x81, 0x84, 0x86, 0x82, 0x81, 0x80, 0x7F, 0x7D, 0x7A,
	0x7C, 0x7B, 0x78, 0x7A, 0x7B, 0x7B, 0x7D, 0x80, 0x83, 0x85, 0x87, 0x8A,
	0x8A, 0x8A, 0x89, 0x86, 0x87, 0x86, 0x81, 0x80, 0x7E, 0x7C, 0x79, 0x77,
	0x79, 0x79, 0x79, 0x7C, 0x80, 0x80, 0x82, 0x84, 0x88, 0x92, 0x90, 0x91,
	0x98, 0x93, 0x8F, 0x8D, 0x89, 0x84, 0x7C, 0x7C, 0x79, 0x74, 0x76, 0x78,
	0x78, 0x7B, 0x7F, 0x83, 0x83, 0x85, 0x89, 0x87, 0x85, 0x85, 0x83, 0x80,
	0x7E, 0x7E, 0x7B, 0x7A, 0x7B, 0x7C, 0x7C, 0x7D, 0x80, 0x80, 0x81, 0x83,
	0x83, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7D, 0x7D, 0x7E, 0x7E,
	0x7D, 0x80, 0x81, 0x80, 0x82, 0x83, 0x82, 0x81, 0x82, 0x81, 0x7F, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x80, 0x7E, 0x80, 0x7F, 0x89,
	0x9B, 0x91, 0x9B, 0xAA, 0x9B, 0x9A, 0x9A, 0x8E, 0x81, 0x7A, 0x7A, 0x6B,
	0x67, 0x72, 0x6C, 0x6E, 0x7A, 0x7E, 0x80, 0x85, 0x8D, 0x8B, 0x87, 0x8D,
	0x88, 0x80, 0x82, 0x7F, 0x7A, 0x78, 0x7B, 0x7A, 0x76, 0x7D, 0x80, 0x7C,
	0x81, 0x84, 0x81, 0x82, 0x84, 0x81, 0x7E, 0x80, 0x80, 0x7C, 0x7E, 0x7F,
	0x7D, 0x7E, 0x80, 0x7F, 0x7E, 0x81, 0x82, 0x7F, 0x81, 0x81, 0x7F, 0x7F,
	0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7D, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x83, 0x9B, 0x94, 0x96, 0xB3, 0x9D, 0x9B, 0xA6, 0x8E, 0x85,
	0x80, 0x78, 0x6A, 0x66, 0x71, 0x64, 0x69, 0x7C, 0x74, 0x7D, 0x8A, 0x88,
	0x8A, 0x8B, 0x8E, 0x85, 0x82, 0x87, 0x79, 0x79, 0x7D, 0x75, 0x77, 0x7B,
	0x7B, 0x7C, 0x7F, 0x84, 0x80, 0x84, 0x87, 0x81, 0x83, 0x84, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7C, 0x7D, 0x7F, 0x7C, 0x7F, 0x80, 0x7D, 0x80, 0x80, 0x7F,
	0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7E, 0x81, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x88, 0x9D, 0x8B, 0xA2, 0xB0, 0x93,
	0xA7, 0xA0, 0x86, 0x8A, 0x80, 0x6F, 0x6A, 0x6D, 0x66, 0x61, 0x74, 0x70,
	0x72, 0x87, 0x82, 0x86, 0x91, 0x8C, 0x8B, 0x8B, 0x8A, 0x82, 0x7F, 0x82,
	0x76, 0x79, 0x7C, 0x75, 0x7A, 0x7D, 0x7B, 0x7F, 0x82, 0x81, 0x82, 0x85,
	0x83, 0x81, 0x84, 0x80, 0x7F, 0x80, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D, 0x7E,
	0x80, 0x7E, 0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x82, 0x7E, 0x82, 0x7E, 0x8C,
	0x9C, 0x86, 0xAE, 0xA6, 0x90, 0xB4, 0x92, 0x88, 0x95, 0x75, 0x74, 0x71,
	0x69, 0x65, 0x67, 0x73, 0x67, 0x7A, 0x82, 0x7A, 0x91, 0x8C, 0x8A, 0x95,
	0x8B, 0x8B, 0x88, 0x83, 0x7E, 0x7A, 0x7B, 0x73, 0x77, 0x79, 0x74, 0x7C,
	0x7D, 0x7D, 0x84, 0x83, 0x84, 0x86, 0x85, 0x84, 0x83, 0x83, 0x80, 0x7E,
	0x80, 0x79, 0x7B, 0x7E, 0x76, 0x7D, 0x7D, 0x7A, 0x81, 0x7F, 0x7F, 0x83,
	0x82, 0x82, 0x83, 0x82, 0x81, 0x80, 0x81, 0x7E, 0x7F, 0x7F, 0x7D, 0x7E,
	0x7E, 0x7E, 0x7E, 0x80, 0x7D, 0x97, 0x8F, 0x91, 0xB5, 0x92, 0xA4, 0xAE,
	0x87, 0x9B, 0x8C, 0x74, 0x80, 0x6D, 0x68, 0x6B, 0x69, 0x69, 0x6E, 0x7A,
	0x75, 0x81, 0x8A, 0x82, 0x91, 0x8E, 0x87, 0x91, 0x86, 0x83, 0x85, 0x7D,
	0x7A, 0x7C, 0x7A, 0x77, 0x7E, 0x7C, 0x7B, 0x84, 0x7F, 0x82, 0x87, 0x80,
	0x84, 0x84, 0x80, 0x82, 0x80, 0x7E, 0x7F, 0x7D, 0x7D, 0x7D, 0x7E, 0x7D,
	0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x82, 0x81, 0x80, 0x81, 0x80, 0x7F,
	0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x92,
	0x8B, 0x90, 0xAA, 0x8F, 0xA4, 0xA5, 0x89, 0x9F, 0x88, 0x7C, 0x85, 0x6F,
	0x70, 0x6F, 0x6A, 0x6D, 0x6F, 0x75, 0x74, 0x7F, 0x81, 0x80, 0x8C, 0x87,
	0x88, 0x8E, 0x84, 0x87, 0x86, 0x7F, 0x80, 0x7F, 0x7A, 0x7C, 0x7C, 0x79,
	0x7D, 0x7D, 0x7C, 0x7F, 0x80, 0x7F, 0x82, 0x82, 0x80, 0x83, 0x80, 0x80,
	0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x81, 0x80, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x83, 0x8F, 0x87, 0x99, 0x9A, 0x91, 0xA7, 0x93,
	0x94, 0x99, 0x81, 0x88, 0x7D, 0x71, 0x77, 0x6D, 0x6D, 0x6F, 0x6F, 0x72,
	0x76, 0x7B, 0x7C, 0x82, 0x85, 0x84, 0x89, 0x87, 0x86, 0x89, 0x84, 0x83,
	0x84, 0x80, 0x80, 0x80, 0x7D, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7D, 0x7E,
	0x7F, 0x7D, 0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x84, 0x8B, 0x85,
	0x97, 0x93, 0x92, 0xA2, 0x8E, 0x97, 0x94, 0x82, 0x8C, 0x7C, 0x77, 0x7A,
	0x6D, 0x72, 0x71, 0x6F, 0x75, 0x75, 0x78, 0x7C, 0x7F, 0x7F, 0x83, 0x84,
	0x82, 0x85, 0x83, 0x82, 0x84, 0x7F, 0x82, 0x81, 0x7F, 0x82, 0x80, 0x80,
	0x81, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7E, 0x7F,
	0x7F, 0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x82, 0x86, 0x85, 0x8D, 0x8E, 0x8E, 0x96, 0x8E, 0x93, 0x90, 0x88,
	0x8B, 0x81, 0x7F, 0x7E, 0x76, 0x79, 0x75, 0x75, 0x77, 0x76, 0x7A, 0x7B,
	0x7D, 0x7E, 0x80, 0x80, 0x80, 0x82, 0x80, 0x82, 0x81, 0x7F, 0x82, 0x7E,
	0x80, 0x80, 0x7E, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x83, 0x84, 0x86, 0x8C, 0x8A, 0x8E, 0x8F, 0x8C,
	0x8F, 0x8A, 0x88, 0x87, 0x81, 0x82, 0x7E, 0x7C, 0x7D, 0x7B, 0x7C, 0x7D,
	0x7D, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x82, 0x83, 0x82, 0x81, 0x82, 0x80,
	0x80, 0x80, 0x7E, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x82, 0x83, 0x85, 0x87, 0x86, 0x89,
	0x87, 0x88, 0x88, 0x85, 0x87, 0x84, 0x84, 0x84, 0x81, 0x82, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x82, 0x81, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x83, 0x85, 0x84, 0x85,
	0x85, 0x85, 0x86, 0x85, 0x86, 0x85, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x81,
	0x82, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F
};
const unsigned char WAVhigh[] = {
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7F,
	0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7F,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x82, 0x81, 0x7E, 0x7E,
	0x7E, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7D, 0x7F, 0x81, 0x82, 0x80,
	0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x81, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x81, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x7E, 0x7E, 0x7C, 0x80,
	0x81, 0x83, 0x80, 0x7E, 0x7E, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x81, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x80, 0x81,
	0x80, 0x7F, 0x7D, 0x7D, 0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x7F, 0x80,
	0x7E, 0x80, 0x81, 0x81, 0x80, 0x7E, 0x7F, 0x81, 0x82, 0x7F, 0x7E, 0x7E,
	0x80, 0x82, 0x82, 0x80, 0x7E, 0x7D, 0x7E, 0x80, 0x81, 0x82, 0x80, 0x81,
	0x7E, 0x7E, 0x7F, 0x81, 0x82, 0x80, 0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x7F, 0x80, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7E,
	0x80, 0x81, 0x81, 0x80, 0x7E, 0x7D, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7E, 0x80, 0x82,
	0x81, 0x80, 0x80, 0x81, 0x82, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x80, 0x80, 0x83, 0x82, 0x81, 0x7D, 0x7D, 0x7F, 0x81, 0x83,
	0x80, 0x82, 0x81, 0x83, 0x7F, 0x7F, 0x7F, 0x82, 0x83, 0x82, 0x81, 0x7E,
	0x7D, 0x7C, 0x81, 0x7C, 0x7B, 0x79, 0x7F, 0x84, 0x86, 0x88, 0x82, 0x81,
	0x80, 0x86, 0x85, 0x87, 0x86, 0x87, 0x85, 0x80, 0x7F, 0x7D, 0x84, 0x82,
	0x80, 0x7B, 0x7B, 0x7E, 0x82, 0x85, 0x82, 0x83, 0x84, 0x88, 0x89, 0x8A,
	0x89, 0x83, 0x83, 0x83, 0x82, 0x7B, 0x74, 0x77, 0x7C, 0x86, 0x80, 0x7B,
	0x76, 0x78, 0x78, 0x77, 0x7E, 0x85, 0x8E, 0x87, 0x81, 0x77, 0x78, 0x7C,
	0x7A, 0x7C, 0x77, 0x7E, 0x7F, 0x80, 0x7D, 0x7A, 0x7F, 0x7D, 0x8D, 0x9C,
	0xA2, 0x94, 0x7D, 0x77, 0x7E, 0x8D, 0x8D, 0x86, 0x7D, 0x7D, 0x82, 0x81,
	0x7F, 0x7B, 0x80, 0x83, 0x84, 0x7E, 0x7B, 0x7D, 0x81, 0x85, 0x82, 0x80,
	0x7E, 0x7F, 0x81, 0x80, 0x80, 0x7E, 0x81, 0x80, 0x81, 0x7F, 0x7E, 0x7F,
	0x80, 0x81, 0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7E, 0x92, 0xAA, 0xAF, 0x97, 0x74, 0x6B, 0x79, 0x94, 0x96, 0x8A,
	0x79, 0x79, 0x83, 0x87, 0x83, 0x7A, 0x7D, 0x82, 0x88, 0x81, 0x7B, 0x78,
	0x7F, 0x86, 0x85, 0x7F, 0x7A, 0x7D, 0x81, 0x84, 0x81, 0x7D, 0x7D, 0x80,
	0x83, 0x81, 0x7E, 0x7D, 0x7F, 0x81, 0x81, 0x80, 0x7D, 0x7F, 0x80, 0x81,
	0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x7D, 0x93, 0xB6, 0xC0, 0xA1, 0x67, 0x53,
	0x69, 0x99, 0xA8, 0x96, 0x77, 0x71, 0x82, 0x8E, 0x8A, 0x77, 0x75, 0x80,
	0x90, 0x8C, 0x80, 0x74, 0x79, 0x84, 0x89, 0x83, 0x7A, 0x7B, 0x81, 0x87,
	0x82, 0x7D, 0x7A, 0x7F, 0x83, 0x84, 0x7F, 0x7C, 0x7D, 0x81, 0x83, 0x80,
	0x7E, 0x7D, 0x81, 0x81, 0x80, 0x7D, 0x7E, 0x80, 0x83, 0x80, 0x7F, 0x7D,
	0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x82, 0xAC,
	0xC2, 0xB6, 0x78, 0x4E, 0x58, 0x87, 0xAB, 0x9E, 0x82, 0x6F, 0x81, 0x8C,
	0x8A, 0x74, 0x6F, 0x7D, 0x91, 0x93, 0x82, 0x75, 0x75, 0x83, 0x87, 0x83,
	0x7A, 0x7C, 0x84, 0x88, 0x83, 0x7A, 0x79, 0x7F, 0x84, 0x84, 0x7F, 0x7D,
	0x7E, 0x82, 0x81, 0x7E, 0x7B, 0x7D, 0x82, 0x83, 0x81, 0x7D, 0x7E, 0x7F,
	0x82, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x7D, 0x80, 0x7F, 0x82,
	0x7D, 0x82, 0x7B, 0x9A, 0xC2, 0xC5, 0x98, 0x52, 0x4C, 0x6E, 0xA4, 0xA5,
	0x8F, 0x7E, 0x85, 0x92, 0x82, 0x6F, 0x65, 0x7F, 0x95, 0x9A, 0x87, 0x77,
	0x78, 0x7F, 0x84, 0x7B, 0x7A, 0x80, 0x8B, 0x8B, 0x80, 0x79, 0x77, 0x80,
	0x82, 0x83, 0x7E, 0x7F, 0x81, 0x82, 0x80, 0x7C, 0x7D, 0x7F, 0x82, 0x81,
	0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0x80, 0x7E,
	0x80, 0x7F, 0x81, 0x7E, 0x81, 0x7E, 0x83, 0x7C, 0x8E, 0xC0, 0xCB, 0xA8,
	0x57, 0x44, 0x61, 0x9A, 0xA6, 0x92, 0x87, 0x8B, 0x96, 0x7C, 0x68, 0x60,
	0x7F, 0x98, 0x9B, 0x8A, 0x7A, 0x7D, 0x7D, 0x7C, 0x73, 0x7A, 0x87, 0x90,
	0x8D, 0x7D, 0x79, 0x76, 0x7E, 0x7C, 0x80, 0x82, 0x87, 0x87, 0x7F, 0x7B,
	0x78, 0x7E, 0x7F, 0x83, 0x81, 0x83, 0x82, 0x80, 0x7D, 0x7B, 0x7D, 0x7F,
	0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x83, 0x85, 0x82,
	0x80, 0x77, 0xA4, 0xCF, 0xCA, 0x88, 0x42, 0x4B, 0x79, 0xA6, 0x9A, 0x8C,
	0x8B, 0x97, 0x8D, 0x6A, 0x5E, 0x6D, 0x92, 0x9A, 0x8F, 0x80, 0x7F, 0x83,
	0x79, 0x72, 0x72, 0x85, 0x8E, 0x8D, 0x80, 0x7B, 0x7D, 0x7D, 0x7C, 0x79,
	0x81, 0x86, 0x89, 0x81, 0x7B, 0x7B, 0x7D, 0x80, 0x7D, 0x80, 0x82, 0x85,
	0x81, 0x7D, 0x7C, 0x7D, 0x80, 0x80, 0x80, 0x80, 0x82, 0x85, 0x85, 0x80,
	0x7C, 0x7A, 0x7F, 0x80, 0x84, 0x7F, 0x84, 0x7C, 0x90, 0xC6, 0xCE, 0xA7,
	0x52, 0x41, 0x63, 0x99, 0xA5, 0x90, 0x8E, 0x91, 0x94, 0x70, 0x5F, 0x65,
	0x89, 0x9B, 0x92, 0x87, 0x81, 0x86, 0x79, 0x70, 0x6F, 0x82, 0x91, 0x8F,
	0x84, 0x7A, 0x7E, 0x7C, 0x7B, 0x77, 0x7F, 0x88, 0x8A, 0x84, 0x7B, 0x7B,
	0x7D, 0x7F, 0x7D, 0x7F, 0x83, 0x85, 0x83, 0x7D, 0x7B, 0x7F, 0x82, 0x82,
	0x7E, 0x7F, 0x81, 0x83, 0x7F, 0x7E, 0x7E, 0x80, 0x81, 0x80, 0x7E, 0x80,
	0x80, 0x82, 0x7C, 0x87, 0xC3, 0xD3, 0xB1, 0x5A, 0x3D, 0x5F, 0x92, 0xA5,
	0x8F, 0x91, 0x94, 0x93, 0x6D, 0x59, 0x66, 0x8B, 0x9C, 0x8F, 0x83, 0x80,
	0x87, 0x7A, 0x6E, 0x6E, 0x83, 0x91, 0x8E, 0x81, 0x7B, 0x7F, 0x7E, 0x7A,
	0x76, 0x80, 0x88, 0x8B, 0x82, 0x7B, 0x7C, 0x7E, 0x7F, 0x7E, 0x85, 0x86,
	0x87, 0x7C, 0x7B, 0x7B, 0x81, 0x81, 0x80, 0x81, 0x82, 0x84, 0x7E, 0x7E,
	0x7B, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x7D, 0x7F, 0x7B, 0xA8,
	0xD3, 0xC7, 0x86, 0x3F, 0x4E, 0x77, 0xA0, 0x95, 0x90, 0x98, 0x9B, 0x87,
	0x60, 0x5F, 0x74, 0x95, 0x92, 0x8B, 0x85, 0x89, 0x83, 0x71, 0x6C, 0x76,
	0x8C, 0x8F, 0x88, 0x7F, 0x80, 0x81, 0x7A, 0x75, 0x79, 0x84, 0x89, 0x85,
	0x7F, 0x7D, 0x7F, 0x7D, 0x7B, 0x7B, 0x82, 0x85, 0x84, 0x7F, 0x7D, 0x7E,
	0x7F, 0x7E, 0x7D, 0x81, 0x82, 0x83, 0x7F, 0x7E, 0x7D, 0x80, 0x7E, 0x80,
	0x7F, 0x82, 0x80, 0x84, 0x80, 0x83, 0x79, 0x94, 0xCF, 0xCC, 0x9C, 0x4A,
	0x4E, 0x72, 0x99, 0x94, 0x89, 0x99, 0x9E, 0x90, 0x64, 0x60, 0x72, 0x90,
	0x90, 0x87, 0x87, 0x8C, 0x88, 0x72, 0x6B, 0x75, 0x89, 0x91, 0x8A, 0x84,
	0x81, 0x80, 0x78, 0x75, 0x7A, 0x86, 0x8A, 0x86, 0x81, 0x7E, 0x80, 0x7B,
	0x7B, 0x7C, 0x84, 0x86, 0x84, 0x7F, 0x7D, 0x7F, 0x7D, 0x7E, 0x7D, 0x82,
	0x83, 0x83, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7D, 0x80, 0x81, 0x82, 0x7F,
	0x7F, 0x7F, 0x81, 0x7D, 0xAF, 0xD6, 0xBD, 0x79, 0x41, 0x60, 0x81, 0x98,
	0x87, 0x92, 0xA3, 0x9B, 0x7B, 0x59, 0x6A, 0x7F, 0x93, 0x83, 0x85, 0x8C,
	0x8F, 0x7D, 0x69, 0x72, 0x7F, 0x8E, 0x82, 0x83, 0x83, 0x88, 0x7D, 0x73,
	0x77, 0x80, 0x89, 0x82, 0x81, 0x81, 0x83, 0x7F, 0x78, 0x7B, 0x80, 0x86,
	0x82, 0x7F, 0x80, 0x7B, 0x7A, 0x77, 0x81, 0x83, 0x85, 0x80, 0x7E, 0x80,
	0x7D, 0x7D, 0x7B, 0x81, 0x82, 0x83, 0x7F, 0x7F, 0x7E, 0x80, 0x7C, 0x80,
	0x7D, 0xB4, 0xD7, 0xB7, 0x74, 0x46, 0x6B, 0x7F, 0x8E, 0x84, 0x9E, 0xAA,
	0x93, 0x6E, 0x5A, 0x75, 0x81, 0x89, 0x82, 0x92, 0x95, 0x85, 0x6F, 0x69,
	0x7C, 0x83, 0x85, 0x82, 0x8A, 0x8A, 0x80, 0x74, 0x73, 0x7F, 0x83, 0x83,
	0x82, 0x85, 0x85, 0x7E, 0x79, 0x7A, 0x80, 0x82, 0x81, 0x82, 0x83, 0x82,
	0x7D, 0x7C, 0x7C, 0x81, 0x81, 0x80, 0x82, 0x81, 0x81, 0x7C, 0x7E, 0x7E,
	0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7E, 0x7D, 0x81, 0x7B, 0x97, 0xC8,
	0xB5, 0x8B, 0x6A, 0x78, 0x78, 0x68, 0x76, 0x92, 0xAA, 0x8F, 0x7C, 0x77,
	0x7B, 0x73, 0x6A, 0x80, 0x91, 0x95, 0x82, 0x7D, 0x7F, 0x7A, 0x73, 0x73,
	0x86, 0x8B, 0x89, 0x7E, 0x7F, 0x7F, 0x77, 0x76, 0x7B, 0x86, 0x85, 0x82,
	0x82, 0x82, 0x7E, 0x78, 0x7A, 0x80, 0x82, 0x82, 0x81, 0x84, 0x80, 0x7D,
	0x7B, 0x7E, 0x80, 0x7F, 0x80, 0x82, 0x82, 0x80, 0x7C, 0x7B, 0x7D, 0x7D,
	0x7F, 0x80, 0x83, 0x81, 0x80, 0x7E, 0x80, 0x7A, 0xA0, 0xBC, 0x9F, 0x8E,
	0x83, 0x87, 0x67, 0x61, 0x7C, 0x8D, 0x90, 0x84, 0x90, 0x8A, 0x75, 0x6B,
	0x71, 0x83, 0x7D, 0x84, 0x90, 0x8F, 0x83, 0x76, 0x7D, 0x78, 0x75, 0x7B,
	0x85, 0x8A, 0x83, 0x84, 0x83, 0x7C, 0x77, 0x78, 0x80, 0x80, 0x81, 0x85,
	0x85, 0x82, 0x7C, 0x7E, 0x7D, 0x7C, 0x7D, 0x81, 0x84, 0x7F, 0x80, 0x81,
	0x7D, 0x7D, 0x7C, 0x81, 0x7F, 0x80, 0x82, 0x82, 0x80, 0x7E, 0x7F, 0x7F,
	0x7D, 0x7F, 0x81, 0x80, 0x80, 0x81, 0xA9, 0xAA, 0x92, 0x95, 0x8D, 0x7D,
	0x63, 0x71, 0x80, 0x7A, 0x85, 0x93, 0x94, 0x81, 0x7E, 0x80, 0x71, 0x6F,
	0x7A, 0x83, 0x81, 0x85, 0x8E, 0x85, 0x7C, 0x7C, 0x7C, 0x77, 0x78, 0x82,
	0x84, 0x82, 0x85, 0x86, 0x80, 0x7B, 0x7D, 0x7D, 0x7B, 0x7D, 0x83, 0x82,
	0x80, 0x83, 0x82, 0x7E, 0x7D, 0x7F, 0x7E, 0x7D, 0x80, 0x82, 0x80, 0x80,
	0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x81,
	0x7E, 0x80, 0x7D, 0x8F, 0xA0, 0x8D, 0x9A, 0x99, 0x83, 0x7B, 0x79, 0x77,
	0x6D, 0x79, 0x86, 0x80, 0x86, 0x8C, 0x86, 0x7C, 0x7C, 0x7D, 0x75, 0x78,
	0x81, 0x81, 0x81, 0x86, 0x87, 0x7F, 0x7E, 0x80, 0x7B, 0x7C, 0x80, 0x82,
	0x82, 0x83, 0x85, 0x81, 0x7F, 0x80, 0x7D, 0x7C, 0x7D, 0x7F, 0x7F, 0x80,
	0x83, 0x81, 0x80, 0x80, 0x7F, 0x7D, 0x7E, 0x7F, 0x7E, 0x7F, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x84, 0x92, 0x8C, 0x8E, 0x96, 0x8A, 0x83, 0x81, 0x7D, 0x75, 0x77, 0x7E,
	0x7B, 0x7F, 0x86, 0x84, 0x82, 0x82, 0x81, 0x7B, 0x7B, 0x7D, 0x7B, 0x7D,
	0x81, 0x81, 0x81, 0x83, 0x82, 0x7F, 0x7F, 0x7F, 0x7D, 0x7D, 0x7F, 0x7F,
	0x7F, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x86, 0x88,
	0x86, 0x8B, 0x89, 0x84, 0x83, 0x81, 0x7D, 0x7C, 0x7E, 0x7D, 0x7E, 0x81,
	0x81, 0x80, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x83, 0x83, 0x83, 0x85, 0x84,
	0x82, 0x82, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVlogic[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x84, 0x85, 0x86, 0x86,
	0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x85, 0x8A, 0x90, 0x94, 0x94, 0x92, 0x8D, 0x89, 0x86, 0x84, 0x81, 0x7E,
	0x7A, 0x76, 0x74, 0x74, 0x76, 0x79, 0x7C, 0x7D, 0x7E, 0x7F, 0x81, 0x83,
	0x85, 0x86, 0x86, 0x84, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7C,
	0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82,
	0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x80, 0x80, 0x81, 0x85, 0x8D, 0x96, 0x9D, 0x9F, 0x9C, 0x96,
	0x8F, 0x8A, 0x88, 0x86, 0x83, 0x7D, 0x77, 0x72, 0x70, 0x71, 0x75, 0x7A,
	0x7D, 0x7E, 0x7F, 0x80, 0x83, 0x86, 0x89, 0x8A, 0x89, 0x86, 0x83, 0x80,
	0x7F, 0x7F, 0x7E, 0x7D, 0x7B, 0x79, 0x79, 0x7A, 0x7D, 0x7F, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x83, 0x84, 0x84, 0x83, 0x81, 0x80, 0x7E, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x80, 0x81, 0x81, 0x84, 0x8B,
	0x95, 0x9F, 0xA6, 0xA6, 0xA1, 0x98, 0x91, 0x8C, 0x8A, 0x87, 0x82, 0x7A,
	0x73, 0x6E, 0x6D, 0x70, 0x75, 0x7A, 0x7D, 0x7E, 0x80, 0x83, 0x87, 0x8B,
	0x8D, 0x8D, 0x8B, 0x87, 0x84, 0x81, 0x80, 0x7F, 0x7D, 0x7B, 0x79, 0x77,
	0x77, 0x79, 0x7B, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x85, 0x85, 0x85,
	0x84, 0x82, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D,
	0x7E, 0x80, 0x81, 0x81, 0x84, 0x8B, 0x98, 0xA6, 0xB0, 0xB3, 0xAD, 0xA2,
	0x98, 0x90, 0x8D, 0x89, 0x84, 0x7B, 0x71, 0x69, 0x67, 0x6A, 0x70, 0x77,
	0x7B, 0x7D, 0x7F, 0x82, 0x87, 0x8C, 0x90, 0x90, 0x8D, 0x87, 0x82, 0x7F,
	0x7E, 0x7E, 0x7D, 0x7B, 0x78, 0x76, 0x76, 0x78, 0x7B, 0x7F, 0x81, 0x81,
	0x81, 0x81, 0x82, 0x84, 0x85, 0x85, 0x84, 0x82, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7E, 0x7E, 0x7C, 0x7C, 0x7B, 0x7C, 0x7E, 0x7F, 0x80, 0x80, 0x83, 0x8E,
	0x9F, 0xB0, 0xBB, 0xBA, 0xAE, 0x9C, 0x8D, 0x84, 0x80, 0x7D, 0x78, 0x6F,
	0x66, 0x62, 0x63, 0x6B, 0x74, 0x7C, 0x80, 0x81, 0x82, 0x85, 0x89, 0x8C,
	0x8D, 0x8B, 0x85, 0x81, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7B, 0x7A, 0x7A,
	0x7C, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x82, 0x82, 0x82, 0x81,
	0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x80, 0x81, 0x7E, 0x83, 0x92, 0xAB, 0xC0, 0xC4, 0xB5, 0x97, 0x7A, 0x68,
	0x66, 0x6D, 0x74, 0x74, 0x71, 0x6F, 0x75, 0x7F, 0x8A, 0x8C, 0x87, 0x7E,
	0x78, 0x79, 0x7E, 0x84, 0x84, 0x80, 0x7C, 0x7A, 0x7E, 0x83, 0x86, 0x84,
	0x7F, 0x7B, 0x7B, 0x7E, 0x82, 0x83, 0x82, 0x7E, 0x7C, 0x7D, 0x80, 0x83,
	0x82, 0x7F, 0x7B, 0x79, 0x7B, 0x80, 0x83, 0x83, 0x80, 0x7F, 0x7E, 0x80,
	0x81, 0x82, 0x7F, 0x7E, 0x7C, 0x7F, 0x7F, 0x86, 0x9B, 0xB7, 0xCD, 0xC7,
	0xA9, 0x7B, 0x5B, 0x50, 0x60, 0x75, 0x85, 0x88, 0x88, 0x8A, 0x91, 0x92,
	0x89, 0x76, 0x66, 0x65, 0x71, 0x85, 0x91, 0x91, 0x86, 0x7E, 0x7B, 0x7F,
	0x80, 0x7E, 0x77, 0x75, 0x79, 0x84, 0x8B, 0x8C, 0x84, 0x7B, 0x77, 0x7A,
	0x7F, 0x81, 0x7F, 0x7B, 0x7D, 0x81, 0x87, 0x86, 0x83, 0x7B, 0x79, 0x79,
	0x80, 0x83, 0x84, 0x7F, 0x7E, 0x7D, 0x81, 0x82, 0x81, 0x7E, 0x7A, 0x91,
	0xB4, 0xD9, 0xD3, 0xA8, 0x66, 0x3D, 0x3E, 0x64, 0x90, 0xA5, 0xA1, 0x91,
	0x88, 0x87, 0x87, 0x7A, 0x6A, 0x5F, 0x6A, 0x82, 0x9B, 0xA1, 0x93, 0x7C,
	0x6E, 0x6E, 0x79, 0x81, 0x82, 0x7D, 0x7D, 0x83, 0x8B, 0x8C, 0x84, 0x78,
	0x70, 0x74, 0x7E, 0x87, 0x88, 0x84, 0x7E, 0x7E, 0x7F, 0x82, 0x7F, 0x7D,
	0x79, 0x7D, 0x81, 0x86, 0x85, 0x81, 0x7C, 0x7B, 0x7D, 0x80, 0x82, 0x7F,
	0x80, 0x7B, 0x98, 0xBB, 0xDE, 0xCB, 0x90, 0x47, 0x29, 0x47, 0x84, 0xB6,
	0xB6, 0x9E, 0x7E, 0x7D, 0x81, 0x86, 0x74, 0x64, 0x61, 0x7A, 0x98, 0xA8,
	0x9C, 0x80, 0x6B, 0x69, 0x76, 0x81, 0x84, 0x7E, 0x7E, 0x82, 0x8D, 0x8D,
	0x85, 0x76, 0x71, 0x73, 0x80, 0x86, 0x89, 0x83, 0x80, 0x7F, 0x81, 0x80,
	0x7E, 0x7A, 0x7A, 0x7E, 0x84, 0x86, 0x83, 0x80, 0x7C, 0x7D, 0x7E, 0x81,
	0x7F, 0x80, 0x7E, 0x83, 0x7E, 0x9C, 0xBB, 0xD5, 0xB8, 0x77, 0x3E, 0x36,
	0x69, 0x9E, 0xBB, 0xA3, 0x89, 0x76, 0x83, 0x89, 0x83, 0x6A, 0x61, 0x6F,
	0x8F, 0xA4, 0xA0, 0x86, 0x6F, 0x6B, 0x76, 0x82, 0x83, 0x7E, 0x7C, 0x84,
	0x8D, 0x92, 0x87, 0x79, 0x6D, 0x73, 0x7C, 0x89, 0x89, 0x86, 0x7F, 0x7F,
	0x80, 0x81, 0x7D, 0x7A, 0x79, 0x80, 0x85, 0x88, 0x83, 0x7F, 0x7B, 0x7C,
	0x7E, 0x80, 0x80, 0x7E, 0x81, 0x7F, 0x86, 0x7B, 0x9E, 0xC0, 0xDF, 0xB8,
	0x6E, 0x33, 0x36, 0x77, 0xAB, 0xBF, 0x98, 0x81, 0x76, 0x8C, 0x8A, 0x7B,
	0x5F, 0x60, 0x7D, 0x9F, 0xAB, 0x93, 0x78, 0x65, 0x72, 0x7D, 0x87, 0x7D,
	0x7C, 0x7F, 0x8E, 0x90, 0x86, 0x75, 0x6D, 0x75, 0x81, 0x8A, 0x87, 0x81,
	0x7E, 0x81, 0x83, 0x80, 0x7A, 0x77, 0x7B, 0x83, 0x87, 0x86, 0x7F, 0x7D,
	0x7B, 0x80, 0x7E, 0x81, 0x7B, 0x82, 0x7C, 0x7D, 0x74, 0x7C, 0x7C, 0x92,
	0xC4, 0xDA, 0xCD, 0x75, 0x3F, 0x2D, 0x6F, 0xA0, 0xB7, 0x9B, 0x84, 0x86,
	0x8E, 0x90, 0x6C, 0x5D, 0x5B, 0x87, 0x9F, 0xAA, 0x8C, 0x78, 0x6E, 0x79,
	0x80, 0x7D, 0x79, 0x79, 0x8A, 0x8F, 0x91, 0x7D, 0x75, 0x70, 0x7C, 0x81,
	0x85, 0x81, 0x81, 0x84, 0x84, 0x82, 0x7A, 0x78, 0x79, 0x81, 0x85, 0x84,
	0x82, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7A, 0x7C, 0x7C, 0x82, 0x82, 0x86,
	0x7E, 0x81, 0x76, 0x97, 0xC9, 0xDF, 0xB8, 0x5F, 0x37, 0x46, 0x8F, 0xAA,
	0xA6, 0x83, 0x85, 0x95, 0x9A, 0x81, 0x5B, 0x5B, 0x72, 0x9C, 0x9F, 0x94,
	0x7B, 0x78, 0x7A, 0x7D, 0x77, 0x73, 0x7D, 0x88, 0x92, 0x89, 0x81, 0x77,
	0x7A, 0x7B, 0x7D, 0x7D, 0x7F, 0x85, 0x87, 0x86, 0x7E, 0x7B, 0x7A, 0x7D,
	0x7E, 0x80, 0x80, 0x83, 0x83, 0x82, 0x7E, 0x7B, 0x7A, 0x7D, 0x80, 0x82,
	0x81, 0x81, 0x80, 0x81, 0x7E, 0x7E, 0x7C, 0x81, 0xB5, 0xD7, 0xD4, 0x8A,
	0x4E, 0x45, 0x6E, 0x96, 0x95, 0x8E, 0x8B, 0xA3, 0x9E, 0x88, 0x61, 0x5F,
	0x71, 0x89, 0x8E, 0x87, 0x8B, 0x8E, 0x8F, 0x7C, 0x70, 0x6C, 0x7B, 0x84,
	0x87, 0x84, 0x85, 0x88, 0x85, 0x7D, 0x74, 0x77, 0x7D, 0x83, 0x83, 0x82,
	0x83, 0x84, 0x82, 0x7D, 0x79, 0x7C, 0x7D, 0x7F, 0x7E, 0x81, 0x82, 0x83,
	0x80, 0x7D, 0x7D, 0x7D, 0x80, 0x7E, 0x80, 0x7F, 0x83, 0x7F, 0x83, 0x79,
	0x97, 0xC6, 0xD4, 0xB3, 0x6F, 0x5D, 0x65, 0x82, 0x7D, 0x7E, 0x8C, 0xA4,
	0xA9, 0x8B, 0x78, 0x6E, 0x7C, 0x76, 0x75, 0x78, 0x8B, 0x96, 0x8F, 0x83,
	0x7A, 0x7F, 0x7B, 0x78, 0x73, 0x7E, 0x87, 0x8A, 0x85, 0x80, 0x82, 0x80,
	0x7E, 0x77, 0x7B, 0x7E, 0x84, 0x82, 0x82, 0x83, 0x82, 0x80, 0x7C, 0x7C,
	0x7D, 0x80, 0x7F, 0x80, 0x81, 0x83, 0x81, 0x80, 0x7E, 0x7F, 0x7E, 0x7F,
	0x7D, 0x80, 0x80, 0x83, 0x7C, 0x9C, 0xC0, 0xC7, 0xAE, 0x8B, 0x88, 0x7C,
	0x74, 0x62, 0x71, 0x85, 0x92, 0x90, 0x8E, 0x97, 0x91, 0x86, 0x73, 0x75,
	0x77, 0x79, 0x77, 0x7C, 0x89, 0x8B, 0x89, 0x82, 0x84, 0x81, 0x7D, 0x76,
	0x78, 0x7E, 0x7F, 0x80, 0x80, 0x86, 0x83, 0x80, 0x7C, 0x7E, 0x7D, 0x7B,
	0x7B, 0x7D, 0x81, 0x80, 0x81, 0x81, 0x83, 0x81, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7D, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x80, 0x81, 0x7D, 0x94, 0xA7,
	0xAB, 0xA9, 0xAB, 0xB0, 0x9F, 0x90, 0x82, 0x83, 0x79, 0x72, 0x72, 0x7A,
	0x81, 0x7E, 0x82, 0x86, 0x8A, 0x82, 0x7F, 0x7F, 0x7F, 0x7B, 0x78, 0x7C,
	0x7E, 0x7F, 0x7D, 0x81, 0x83, 0x83, 0x80, 0x80, 0x82, 0x80, 0x7F, 0x7E,
	0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x81, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x81, 0x86, 0x89, 0x8B, 0x8D, 0x91, 0x91, 0x90, 0x8E,
	0x8D, 0x8A, 0x86, 0x83, 0x82, 0x80, 0x7D, 0x7C, 0x7C, 0x7C, 0x7B, 0x7B,
	0x7B, 0x7C, 0x7B, 0x7B, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B,
	0x7D, 0x7E, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x82, 0x82, 0x83, 0x84,
	0x85, 0x85, 0x85, 0x85, 0x86, 0x87, 0x86, 0x86, 0x84, 0x85, 0x83, 0x82,
	0x81, 0x82, 0x80, 0x81, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C, 0x79, 0x7A, 0x79,
	0x7A, 0x79, 0x7A, 0x7A, 0x7C, 0x7C, 0x7D, 0x7F, 0x7F, 0x7E, 0x83, 0x82,
	0x81, 0x83, 0x82, 0x82, 0x81, 0x83, 0x7F, 0x82, 0x7F, 0x80, 0x81, 0x7D,
	0x7F, 0x7D, 0x80, 0x7D, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x81,
	0x80, 0x81, 0x82, 0x82, 0x82, 0x83, 0x84, 0x80, 0x82, 0x83, 0x7F, 0x83,
	0x81, 0x80, 0x81, 0x82, 0x80, 0x80, 0x81, 0x81, 0x7F, 0x81, 0x80, 0x7E,
	0x82, 0x80, 0x7F, 0x80, 0x82, 0x80, 0x80, 0x83, 0x7F, 0x81, 0x83, 0x7E,
	0x81, 0x81, 0x81, 0x7E, 0x81, 0x83, 0x7E, 0x81, 0x83, 0x7E, 0x80, 0x85,
	0x7C, 0x81, 0x7F, 0x81, 0x7D, 0x7F, 0x82, 0x7A, 0x83, 0x7D, 0x7F, 0x7D,
	0x81, 0x7F, 0x7D, 0x83, 0x7D, 0x83, 0x80, 0x81, 0x82, 0x82, 0x82, 0x81,
	0x84, 0x7F, 0x82, 0x81, 0x7F, 0x82, 0x7D, 0x81, 0x80, 0x7C, 0x7F, 0x7F,
	0x7E, 0x7D, 0x7F, 0x81, 0x7A, 0x81, 0x82, 0x7B, 0x81, 0x7E, 0x80, 0x7C,
	0x81, 0x80, 0x7F, 0x7E, 0x83, 0x80, 0x7C, 0x85, 0x7F, 0x7D, 0x7E, 0x84,
	0x78, 0x82, 0x80, 0x80, 0x7F, 0x81, 0x83, 0x7E, 0x82, 0x81, 0x82, 0x7F,
	0x85, 0x7E, 0x83, 0x7F, 0x81, 0x81, 0x7D, 0x84, 0x7D, 0x82, 0x81, 0x82,
	0x82, 0x81, 0x85, 0x7F, 0x84, 0x7E, 0x84, 0x81, 0x7E, 0x84, 0x7D, 0x81,
	0x7D, 0x7D, 0x7F, 0x7D, 0x7E, 0x7C, 0x7A, 0x80, 0x79, 0x7E, 0x7E, 0x7D,
	0x84, 0x80, 0x83, 0x88, 0x84, 0x8A, 0x8C, 0x85, 0x8D, 0x83, 0x8A, 0x81,
	0x85, 0x83, 0x7D, 0x86, 0x7A, 0x83, 0x7B, 0x81, 0x80, 0x7D, 0x89, 0x81,
	0x85, 0x8A, 0x85, 0x88, 0x87, 0x87, 0x86, 0x82, 0x88, 0x7F, 0x81, 0x81,
	0x7D, 0x7F, 0x7C, 0x80, 0x7B, 0x7C, 0x7E, 0x7A, 0x7B, 0x7D, 0x79, 0x7B,
	0x7D, 0x7D, 0x7F, 0x81, 0x81, 0x7F, 0x86, 0x81, 0x83, 0x83, 0x83, 0x85,
	0x80, 0x87, 0x82, 0x82, 0x83, 0x82, 0x7E, 0x88, 0x8B, 0x84, 0x92, 0x8F,
	0x8D, 0x8E, 0x8D, 0x8B, 0x84, 0x87, 0x83, 0x7B, 0x7F, 0x7C, 0x79, 0x7A,
	0x7C, 0x7D, 0x7B, 0x80, 0x81, 0x7F, 0x84, 0x84, 0x82, 0x84, 0x83, 0x83,
	0x80, 0x81, 0x81, 0x7D, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F,
	0x81, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7C, 0x7E, 0x7D, 0x7A, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x7F, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7D,
	0x80, 0x7C, 0x8B, 0x94, 0x8B, 0x9E, 0x9C, 0x97, 0x98, 0x93, 0x8E, 0x82,
	0x80, 0x7D, 0x70, 0x74, 0x75, 0x71, 0x76, 0x7B, 0x80, 0x80, 0x86, 0x8B,
	0x87, 0x89, 0x8B, 0x85, 0x83, 0x81, 0x7F, 0x7A, 0x79, 0x7B, 0x78, 0x78,
	0x7E, 0x7F, 0x7F, 0x85, 0x86, 0x85, 0x86, 0x88, 0x84, 0x82, 0x82, 0x80,
	0x7C, 0x7C, 0x7D, 0x7A, 0x7B, 0x7E, 0x7E, 0x7E, 0x81, 0x82, 0x81, 0x82,
	0x84, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7D, 0x7D, 0x7C, 0x7B, 0x7C, 0x7D,
	0x7C, 0x7E, 0x80, 0x80, 0x80, 0x83, 0x81, 0x82, 0x7E, 0x93, 0xA2, 0x93,
	0xAD, 0xB0, 0xA0, 0xA3, 0x9D, 0x91, 0x7F, 0x7A, 0x7A, 0x65, 0x69, 0x73,
	0x69, 0x70, 0x7C, 0x7F, 0x80, 0x87, 0x8F, 0x88, 0x85, 0x8D, 0x83, 0x7C,
	0x80, 0x7D, 0x77, 0x77, 0x7E, 0x7B, 0x78, 0x82, 0x83, 0x7E, 0x84, 0x86,
	0x82, 0x80, 0x83, 0x82, 0x7C, 0x7E, 0x82, 0x7D, 0x7C, 0x83, 0x81, 0x7E,
	0x82, 0x84, 0x80, 0x7F, 0x83, 0x80, 0x7C, 0x80, 0x80, 0x7D, 0x7E, 0x81,
	0x7F, 0x7D, 0x81, 0x82, 0x7E, 0x80, 0x81, 0x80, 0x7E, 0x80, 0x80, 0x7D,
	0x80, 0x81, 0x81, 0x7D, 0xA0, 0xAE, 0x98, 0xB8, 0xB8, 0x99, 0x98, 0x90,
	0x7E, 0x68, 0x68, 0x71, 0x5F, 0x66, 0x81, 0x7A, 0x7E, 0x90, 0x92, 0x8A,
	0x89, 0x90, 0x83, 0x75, 0x7F, 0x7B, 0x6D, 0x73, 0x7D, 0x77, 0x76, 0x83,
	0x87, 0x7F, 0x84, 0x8B, 0x81, 0x7E, 0x83, 0x80, 0x78, 0x7B, 0x80, 0x7C,
	0x7A, 0x82, 0x83, 0x7D, 0x82, 0x85, 0x80, 0x7E, 0x82, 0x80, 0x7C, 0x7D,
	0x83, 0x80, 0x7E, 0x84, 0x84, 0x7F, 0x81, 0x82, 0x80, 0x7C, 0x7F, 0x80,
	0x7B, 0x7E, 0x81, 0x7F, 0x7E, 0x82, 0x81, 0x80, 0x7E, 0x83, 0x7C, 0x95,
	0xB1, 0x99, 0xAA, 0xB5, 0x98, 0x8C, 0x85, 0x7B, 0x69, 0x62, 0x76, 0x6F,
	0x6E, 0x87, 0x8A, 0x86, 0x8A, 0x8F, 0x89, 0x7A, 0x7F, 0x7F, 0x72, 0x76,
	0x7E, 0x7C, 0x7C, 0x83, 0x88, 0x82, 0x81, 0x87, 0x80, 0x7B, 0x7E, 0x7F,
	0x78, 0x75, 0x7F, 0x7C, 0x78, 0x80, 0x83, 0x80, 0x7F, 0x85, 0x84, 0x7D,
	0x80, 0x82, 0x7C, 0x7C, 0x80, 0x80, 0x7D, 0x7F, 0x83, 0x80, 0x7E, 0x82,
	0x81, 0x7E, 0x7E, 0x80, 0x80, 0x7C, 0x81, 0x82, 0x7F, 0x80, 0x83, 0x80,
	0x7F, 0x7F, 0x81, 0x7D, 0x7E, 0x80, 0x83, 0xA6, 0xA6, 0x9C, 0xB0, 0xA3,
	0x8D, 0x81, 0x7A, 0x71, 0x60, 0x6A, 0x79, 0x72, 0x7E, 0x8C, 0x8D, 0x88,
	0x86, 0x8A, 0x7E, 0x74, 0x7D, 0x7B, 0x77, 0x7C, 0x84, 0x85, 0x81, 0x86,
	0x87, 0x7F, 0x7D, 0x80, 0x7D, 0x79, 0x7C, 0x81, 0x7F, 0x7F, 0x84, 0x83,
	0x80, 0x80, 0x81, 0x7E, 0x7C, 0x7E, 0x81, 0x82, 0x81, 0x84, 0x85, 0x81,
	0x80, 0x81, 0x7E, 0x7C, 0x7D, 0x7F, 0x7E, 0x7F, 0x81, 0x82, 0x80, 0x80,
	0x81, 0x7F, 0x7D, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x80,
	0x80, 0x7C, 0x8F, 0xA4, 0x95, 0x9C, 0xA6, 0x93, 0x83, 0x7D, 0x7B, 0x70,
	0x6A, 0x7C, 0x80, 0x7B, 0x87, 0x8C, 0x86, 0x7E, 0x7F, 0x7F, 0x74, 0x74,
	0x7F, 0x7D, 0x7D, 0x84, 0x88, 0x85, 0x81, 0x85, 0x82, 0x7B, 0x7D, 0x7F,
	0x7D, 0x7D, 0x82, 0x83, 0x80, 0x81, 0x83, 0x7F, 0x7D, 0x7F, 0x7E, 0x7D,
	0x7E, 0x81, 0x81, 0x80, 0x81, 0x82, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F,
	0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x8D, 0x99,
	0x8E, 0x98, 0x9C, 0x8B, 0x85, 0x83, 0x7C, 0x75, 0x76, 0x7F, 0x7D, 0x7F,
	0x8A, 0x88, 0x82, 0x84, 0x82, 0x7B, 0x79, 0x7B, 0x7B, 0x7A, 0x80, 0x84,
	0x81, 0x83, 0x85, 0x81, 0x7E, 0x7E, 0x7E, 0x7B, 0x7C, 0x80, 0x80, 0x7F,
	0x83, 0x84, 0x81, 0x82, 0x82, 0x7E, 0x7E, 0x7F, 0x7E, 0x7D, 0x80, 0x81,
	0x7F, 0x81, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x84, 0x8C, 0x86, 0x8D, 0x93, 0x89,
	0x8A, 0x8C, 0x81, 0x80, 0x82, 0x7D, 0x7D, 0x80, 0x81, 0x80, 0x82, 0x84,
	0x81, 0x80, 0x84, 0x7E, 0x7D, 0x80, 0x7A, 0x7C, 0x81, 0x7C, 0x80, 0x86,
	0x82, 0x84, 0x88, 0x84, 0x83, 0x85, 0x81, 0x7E, 0x82, 0x80, 0x7D, 0x83,
	0x86, 0x83, 0x88, 0x8C, 0x85, 0x88, 0x8C, 0x83, 0x84, 0x87, 0x7F, 0x80,
	0x83, 0x7E, 0x81, 0x83, 0x80, 0x82, 0x83, 0x80, 0x82, 0x81, 0x80, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x81, 0x82, 0x81, 0x82, 0x82, 0x82, 0x81, 0x83,
	0x83, 0x82, 0x84, 0x85, 0x84, 0x85, 0x85, 0x83, 0x83, 0x83, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E,
	0x7F, 0x7F, 0x7D, 0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7C, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x81, 0x7E, 0x7E, 0x82, 0x80, 0x7C,
	0x81, 0x81, 0x7D, 0x80, 0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x7F,
	0x7E, 0x81, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x81, 0x81, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7E, 0x7E, 0x81, 0x81, 0x7E,
	0x80, 0x81, 0x7E, 0x7F, 0x82, 0x7E, 0x7D, 0x80, 0x80, 0x7D, 0x80, 0x81,
	0x7D, 0x81, 0x82, 0x7E, 0x7F, 0x81, 0x7E, 0x7F, 0x81, 0x7E, 0x7F, 0x80,
	0x80, 0x81, 0x7F, 0x7E, 0x83, 0x80, 0x80, 0x82, 0x7E, 0x7D, 0x80, 0x7F,
	0x7F, 0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x7E,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F, 0x80,
	0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80,
	0x80, 0x7E, 0x81, 0x81, 0x7E, 0x82, 0x82, 0x7E, 0x82, 0x80, 0x7D, 0x7F,
	0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x80, 0x7E, 0x80,
	0x7E, 0x7D, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x82, 0x7F, 0x7E,
	0x80, 0x7F, 0x7D, 0x80, 0x80, 0x7D, 0x81, 0x80, 0x7E, 0x80, 0x81, 0x7F,
	0x80, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F,
	0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x7E, 0x80,
	0x7F, 0x7D, 0x80, 0x81, 0x7E, 0x80, 0x81, 0x7E, 0x80, 0x81, 0x7F, 0x80,
	0x81, 0x7E, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVloop[] = {
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x81, 0x82, 0x84, 0x86, 0x86, 0x86, 0x86, 0x85, 0x84, 0x84, 0x83,
	0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x86, 0x8C, 0x90, 0x92, 0x91, 0x8F,
	0x8C, 0x8A, 0x89, 0x86, 0x83, 0x7F, 0x7A, 0x78, 0x77, 0x78, 0x79, 0x79,
	0x7A, 0x7B, 0x7D, 0x80, 0x83, 0x85, 0x86, 0x85, 0x85, 0x85, 0x84, 0x84,
	0x82, 0x81, 0x7F, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E,
	0x7F, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x82, 0x89, 0x91,
	0x97, 0x9A, 0x99, 0x96, 0x92, 0x90, 0x8F, 0x8C, 0x87, 0x80, 0x7A, 0x75,
	0x74, 0x74, 0x75, 0x76, 0x76, 0x77, 0x7A, 0x7E, 0x83, 0x86, 0x88, 0x89,
	0x88, 0x88, 0x88, 0x88, 0x87, 0x84, 0x80, 0x7D, 0x7B, 0x7A, 0x7A, 0x7A,
	0x79, 0x79, 0x79, 0x7B, 0x7C, 0x7E, 0x80, 0x81, 0x82, 0x82, 0x83, 0x84,
	0x84, 0x84, 0x83, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7C,
	0x7D, 0x7E, 0x82, 0x88, 0x8F, 0x95, 0x98, 0x98, 0x96, 0x95, 0x95, 0x93,
	0x91, 0x8B, 0x85, 0x7F, 0x7C, 0x7A, 0x79, 0x78, 0x76, 0x75, 0x75, 0x78,
	0x7B, 0x7F, 0x81, 0x82, 0x83, 0x85, 0x87, 0x88, 0x89, 0x87, 0x85, 0x83,
	0x82, 0x81, 0x80, 0x7F, 0x7D, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7D, 0x7D,
	0x7D, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81,
	0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7F, 0x83, 0x8A, 0x8E, 0x90,
	0x90, 0x8F, 0x90, 0x90, 0x91, 0x8E, 0x8A, 0x85, 0x82, 0x80, 0x7F, 0x7E,
	0x7B, 0x79, 0x77, 0x79, 0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x80, 0x82, 0x84,
	0x85, 0x84, 0x83, 0x83, 0x84, 0x83, 0x82, 0x81, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7E, 0x83, 0x8D, 0x95, 0x9A, 0x97, 0x97, 0x97, 0x9A, 0x98, 0x92, 0x8B,
	0x84, 0x82, 0x80, 0x7D, 0x78, 0x74, 0x73, 0x76, 0x79, 0x7A, 0x7A, 0x7B,
	0x7E, 0x82, 0x85, 0x85, 0x84, 0x85, 0x86, 0x86, 0x84, 0x82, 0x80, 0x7F,
	0x7F, 0x7E, 0x7C, 0x7B, 0x7C, 0x7D, 0x7E, 0x7E, 0x7D, 0x7F, 0x80, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x91, 0x9E, 0xA6, 0xA1, 0x9B,
	0x9E, 0x9B, 0x97, 0x86, 0x7B, 0x76, 0x76, 0x76, 0x6E, 0x6D, 0x70, 0x7C,
	0x81, 0x82, 0x83, 0x86, 0x8D, 0x8C, 0x88, 0x81, 0x7F, 0x7F, 0x7D, 0x79,
	0x75, 0x77, 0x7B, 0x7F, 0x7F, 0x7E, 0x82, 0x85, 0x87, 0x84, 0x81, 0x80,
	0x81, 0x81, 0x7D, 0x7B, 0x7A, 0x7D, 0x7F, 0x7E, 0x7F, 0x81, 0x84, 0x85,
	0x83, 0x82, 0x81, 0x82, 0x7F, 0x7E, 0x7B, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F,
	0x9C, 0xAB, 0xB2, 0xA6, 0x9F, 0xA3, 0x9A, 0x8E, 0x73, 0x6C, 0x6B, 0x70,
	0x70, 0x6A, 0x73, 0x7F, 0x8D, 0x8D, 0x89, 0x8D, 0x8E, 0x90, 0x83, 0x7B,
	0x77, 0x78, 0x79, 0x72, 0x74, 0x77, 0x81, 0x84, 0x83, 0x85, 0x86, 0x8B,
	0x86, 0x82, 0x7E, 0x7D, 0x7E, 0x7A, 0x79, 0x77, 0x7B, 0x7E, 0x7E, 0x80,
	0x80, 0x85, 0x84, 0x83, 0x81, 0x80, 0x82, 0x7E, 0x7E, 0x7B, 0x7D, 0x7E,
	0x7E, 0x7D, 0x80, 0x7E, 0x8F, 0xAB, 0xB0, 0xAF, 0xA4, 0xA8, 0xA5, 0x92,
	0x80, 0x6D, 0x71, 0x6C, 0x67, 0x66, 0x6C, 0x80, 0x84, 0x8A, 0x8C, 0x92,
	0x98, 0x8F, 0x88, 0x80, 0x7F, 0x7B, 0x72, 0x71, 0x70, 0x78, 0x7B, 0x7C,
	0x81, 0x85, 0x8B, 0x89, 0x87, 0x86, 0x84, 0x83, 0x7A, 0x77, 0x78, 0x77,
	0x79, 0x76, 0x7B, 0x7F, 0x82, 0x84, 0x82, 0x86, 0x86, 0x84, 0x82, 0x7E,
	0x80, 0x7C, 0x7C, 0x7A, 0x7C, 0x7D, 0x7F, 0x7D, 0x88, 0xAC, 0xB1, 0xB0,
	0xAA, 0xAD, 0xB0, 0x96, 0x83, 0x77, 0x73, 0x6E, 0x5E, 0x61, 0x6C, 0x76,
	0x7D, 0x7D, 0x8D, 0x95, 0x96, 0x92, 0x8B, 0x8E, 0x86, 0x7C, 0x76, 0x72,
	0x76, 0x72, 0x72, 0x77, 0x7C, 0x84, 0x83, 0x86, 0x8D, 0x8C, 0x8B, 0x86,
	0x85, 0x85, 0x7D, 0x7B, 0x78, 0x79, 0x79, 0x78, 0x7A, 0x7E, 0x81, 0x82,
	0x83, 0x85, 0x86, 0x84, 0x83, 0x80, 0x81, 0x7E, 0x7D, 0x7B, 0x7D, 0x7A,
	0x8C, 0xA9, 0xA2, 0xA7, 0xAD, 0xAF, 0xAC, 0x92, 0x8B, 0x86, 0x77, 0x6E,
	0x62, 0x68, 0x6D, 0x6A, 0x73, 0x7C, 0x88, 0x8E, 0x8C, 0x93, 0x94, 0x90,
	0x8B, 0x82, 0x81, 0x7B, 0x73, 0x72, 0x72, 0x75, 0x7A, 0x7B, 0x82, 0x88,
	0x8A, 0x8D, 0x8B, 0x8C, 0x8A, 0x84, 0x82, 0x7D, 0x7B, 0x79, 0x76, 0x78,
	0x78, 0x7A, 0x7C, 0x7F, 0x82, 0x84, 0x84, 0x86, 0x85, 0x85, 0x83, 0x81,
	0x7F, 0x7D, 0x7A, 0x7D, 0x99, 0x9D, 0x9A, 0xA6, 0xA9, 0xAA, 0x9D, 0x90,
	0x90, 0x84, 0x74, 0x6E, 0x6A, 0x6D, 0x6A, 0x6A, 0x76, 0x7D, 0x82, 0x87,
	0x8B, 0x92, 0x90, 0x8C, 0x8C, 0x87, 0x83, 0x7C, 0x75, 0x76, 0x73, 0x70,
	0x72, 0x75, 0x7A, 0x7D, 0x7F, 0x86, 0x88, 0x88, 0x89, 0x88, 0x86, 0x84,
	0x7F, 0x7E, 0x7C, 0x79, 0x79, 0x79, 0x7A, 0x7C, 0x7C, 0x7F, 0x82, 0x82,
	0x84, 0x84, 0x85, 0x84, 0x84, 0x80, 0x8D, 0xA3, 0x9C, 0x9D, 0xA8, 0xA6,
	0xA1, 0x93, 0x8A, 0x8A, 0x7B, 0x6E, 0x6E, 0x6C, 0x6D, 0x6C, 0x6F, 0x7B,
	0x81, 0x82, 0x89, 0x8D, 0x8F, 0x8D, 0x89, 0x88, 0x82, 0x7C, 0x78, 0x75,
	0x74, 0x74, 0x73, 0x77, 0x7B, 0x7D, 0x81, 0x84, 0x87, 0x88, 0x87, 0x86,
	0x85, 0x82, 0x80, 0x7E, 0x7C, 0x7B, 0x7A, 0x7A, 0x7C, 0x7D, 0x7E, 0x80,
	0x81, 0x82, 0x83, 0x82, 0x83, 0x81, 0x81, 0x7E, 0x8B, 0x9E, 0x99, 0x9B,
	0xA3, 0xA2, 0x9F, 0x92, 0x87, 0x87, 0x7C, 0x70, 0x6E, 0x6D, 0x70, 0x71,
	0x71, 0x7B, 0x83, 0x84, 0x88, 0x8A, 0x8D, 0x8D, 0x87, 0x84, 0x83, 0x7E,
	0x7B, 0x77, 0x77, 0x79, 0x79, 0x79, 0x7C, 0x7F, 0x82, 0x83, 0x83, 0x85,
	0x86, 0x83, 0x82, 0x81, 0x80, 0x7E, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E,
	0x7F, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x7F, 0x8F, 0x9D, 0x99,
	0x9A, 0x9E, 0x9E, 0x9B, 0x8D, 0x83, 0x83, 0x7B, 0x72, 0x6F, 0x6D, 0x73,
	0x77, 0x76, 0x7C, 0x84, 0x87, 0x8A, 0x88, 0x89, 0x8D, 0x8A, 0x85, 0x82,
	0x7F, 0x7F, 0x7C, 0x78, 0x79, 0x7B, 0x7C, 0x7D, 0x7D, 0x80, 0x83, 0x84,
	0x83, 0x83, 0x83, 0x83, 0x81, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7C, 0x7D,
	0x7F, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x8D, 0x9B, 0x9A,
	0x99, 0x9A, 0x9A, 0x99, 0x8F, 0x82, 0x7F, 0x7B, 0x77, 0x72, 0x6E, 0x72,
	0x79, 0x7B, 0x7E, 0x81, 0x86, 0x8B, 0x8A, 0x87, 0x87, 0x86, 0x84, 0x81,
	0x7C, 0x7A, 0x7B, 0x7B, 0x7A, 0x7A, 0x7B, 0x7F, 0x81, 0x82, 0x82, 0x83,
	0x84, 0x84, 0x82, 0x80, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7D, 0x7E, 0x7E,
	0x7F, 0x7F, 0x81, 0x82, 0x82, 0x82, 0x82, 0x80, 0x86, 0x93, 0x97, 0x97,
	0x96, 0x94, 0x95, 0x92, 0x88, 0x80, 0x7B, 0x79, 0x79, 0x75, 0x73, 0x77,
	0x7B, 0x80, 0x82, 0x82, 0x85, 0x88, 0x88, 0x87, 0x84, 0x82, 0x82, 0x80,
	0x7E, 0x7C, 0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x81, 0x82, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x89, 0x91, 0x93, 0x94, 0x92,
	0x90, 0x91, 0x8D, 0x86, 0x80, 0x7C, 0x7B, 0x7A, 0x78, 0x77, 0x79, 0x7C,
	0x80, 0x82, 0x82, 0x84, 0x85, 0x86, 0x85, 0x83, 0x80, 0x7F, 0x7E, 0x7D,
	0x7C, 0x7B, 0x7B, 0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x82, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x86, 0x8A, 0x8C, 0x8D, 0x8B, 0x8B, 0x8C,
	0x8A, 0x87, 0x83, 0x80, 0x80, 0x7F, 0x7D, 0x7C, 0x7C, 0x7D, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x81, 0x83, 0x85, 0x86, 0x87, 0x88, 0x88, 0x89, 0x89, 0x88,
	0x87, 0x86, 0x85, 0x84, 0x83, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x82, 0x83, 0x84, 0x85, 0x85, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86,
	0x86, 0x85, 0x85, 0x84, 0x84, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80,
	0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7D, 0x7E, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x7F, 0x7F, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVlow[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x83, 0x85, 0x86, 0x86, 0x86,
	0x85, 0x85, 0x84, 0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D,
	0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x83, 0x89,
	0x8F, 0x93, 0x94, 0x92, 0x8E, 0x8B, 0x89, 0x87, 0x84, 0x7F, 0x7B, 0x77,
	0x75, 0x76, 0x77, 0x77, 0x78, 0x78, 0x79, 0x7C, 0x7F, 0x82, 0x83, 0x84,
	0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x81, 0x82,
	0x82, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7F, 0x82, 0x89, 0x92, 0x99, 0x9D, 0x9C, 0x98, 0x93, 0x8F, 0x8C,
	0x8A, 0x85, 0x7F, 0x79, 0x74, 0x73, 0x74, 0x76, 0x78, 0x79, 0x79, 0x7B,
	0x7D, 0x81, 0x84, 0x86, 0x86, 0x85, 0x84, 0x83, 0x83, 0x83, 0x82, 0x80,
	0x7E, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x84, 0x8C, 0x97, 0x9E, 0xA1,
	0x9D, 0x99, 0x94, 0x92, 0x8F, 0x8B, 0x84, 0x7C, 0x76, 0x72, 0x73, 0x74,
	0x76, 0x76, 0x76, 0x77, 0x7A, 0x7E, 0x83, 0x85, 0x85, 0x84, 0x84, 0x84,
	0x85, 0x85, 0x84, 0x81, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D,
	0x7D, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7F,
	0x82, 0x8A, 0x95, 0x9F, 0xA1, 0x9D, 0x95, 0x90, 0x8D, 0x8C, 0x88, 0x81,
	0x78, 0x72, 0x71, 0x73, 0x76, 0x77, 0x77, 0x77, 0x79, 0x7D, 0x83, 0x86,
	0x86, 0x85, 0x84, 0x84, 0x85, 0x85, 0x84, 0x80, 0x7D, 0x7B, 0x7C, 0x7D,
	0x7D, 0x7C, 0x7B, 0x7B, 0x7D, 0x7F, 0x81, 0x81, 0x81, 0x80, 0x80, 0x82,
	0x82, 0x82, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x84, 0x8F, 0x9C, 0xA5, 0xA4, 0x9E,
	0x96, 0x94, 0x92, 0x90, 0x88, 0x7E, 0x75, 0x71, 0x72, 0x75, 0x75, 0x74,
	0x73, 0x75, 0x7B, 0x80, 0x85, 0x85, 0x84, 0x83, 0x84, 0x85, 0x86, 0x83,
	0x81, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7D, 0x7C, 0x7C, 0x7E, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x8D, 0x9E, 0xB2, 0xB4, 0xAD, 0x9C, 0x92, 0x8D, 0x8A, 0x84, 0x77, 0x6C,
	0x65, 0x6B, 0x73, 0x7B, 0x7B, 0x7D, 0x7B, 0x80, 0x83, 0x86, 0x82, 0x7E,
	0x7B, 0x7B, 0x7E, 0x7F, 0x7F, 0x7C, 0x7C, 0x7E, 0x82, 0x83, 0x83, 0x7F,
	0x7F, 0x7F, 0x81, 0x81, 0x80, 0x7E, 0x7C, 0x7E, 0x80, 0x82, 0x80, 0x7F,
	0x7F, 0x83, 0x85, 0x86, 0x82, 0x7F, 0x7E, 0x7E, 0x80, 0x7F, 0x7E, 0x7C,
	0x7F, 0x80, 0x84, 0x82, 0x81, 0x96, 0xB1, 0xCB, 0xC2, 0xA8, 0x85, 0x76,
	0x75, 0x77, 0x70, 0x64, 0x63, 0x72, 0x8D, 0x9B, 0x9B, 0x89, 0x81, 0x7D,
	0x85, 0x80, 0x77, 0x6A, 0x6C, 0x79, 0x89, 0x8F, 0x88, 0x82, 0x7E, 0x86,
	0x86, 0x84, 0x76, 0x72, 0x73, 0x7F, 0x85, 0x86, 0x81, 0x7D, 0x82, 0x85,
	0x89, 0x81, 0x7E, 0x78, 0x7E, 0x81, 0x83, 0x80, 0x7C, 0x7E, 0x80, 0x86,
	0x82, 0x81, 0x7A, 0x7E, 0x7D, 0x83, 0x7F, 0x80, 0x7B, 0x81, 0xA6, 0xC9,
	0xE1, 0xBF, 0x95, 0x68, 0x66, 0x6C, 0x76, 0x6E, 0x6A, 0x79, 0x94, 0xB0,
	0xA9, 0x97, 0x76, 0x73, 0x71, 0x7D, 0x73, 0x6E, 0x6D, 0x7F, 0x93, 0x9A,
	0x94, 0x80, 0x7B, 0x77, 0x81, 0x7A, 0x78, 0x6E, 0x79, 0x83, 0x90, 0x8D,
	0x86, 0x83, 0x82, 0x88, 0x80, 0x7C, 0x71, 0x77, 0x7D, 0x87, 0x86, 0x83,
	0x81, 0x81, 0x85, 0x82, 0x80, 0x77, 0x7A, 0x7B, 0x83, 0x82, 0x83, 0x7E,
	0x82, 0x81, 0x87, 0xAE, 0xCE, 0xDF, 0xB3, 0x85, 0x5E, 0x67, 0x74, 0x79,
	0x70, 0x6A, 0x85, 0xA0, 0xB7, 0xA0, 0x89, 0x6E, 0x73, 0x77, 0x7A, 0x70,
	0x6B, 0x79, 0x8B, 0x9E, 0x95, 0x8A, 0x79, 0x7B, 0x7C, 0x7D, 0x75, 0x70,
	0x76, 0x83, 0x90, 0x8D, 0x87, 0x7F, 0x7F, 0x81, 0x7E, 0x79, 0x74, 0x79,
	0x7F, 0x88, 0x86, 0x84, 0x80, 0x81, 0x83, 0x7F, 0x7D, 0x77, 0x7C, 0x7D,
	0x84, 0x81, 0x83, 0x7F, 0x83, 0x81, 0x83, 0x7B, 0x8D, 0xB9, 0xD5, 0xD0,
	0x95, 0x73, 0x61, 0x79, 0x78, 0x71, 0x64, 0x73, 0x98, 0xAA, 0xAB, 0x8A,
	0x7F, 0x76, 0x81, 0x78, 0x6E, 0x67, 0x71, 0x8A, 0x93, 0x95, 0x86, 0x83,
	0x83, 0x85, 0x7E, 0x72, 0x70, 0x74, 0x83, 0x87, 0x87, 0x83, 0x83, 0x87,
	0x84, 0x80, 0x77, 0x77, 0x79, 0x7F, 0x81, 0x80, 0x81, 0x82, 0x86, 0x83,
	0x81, 0x7C, 0x7B, 0x7D, 0x7D, 0x80, 0x7D, 0x81, 0x81, 0x85, 0x81, 0x82,
	0x7D, 0x80, 0x7C, 0x88, 0xB5, 0xCE, 0xD2, 0x9E, 0x7C, 0x6A, 0x75, 0x77,
	0x68, 0x65, 0x6F, 0x96, 0xA4, 0xA6, 0x8E, 0x82, 0x81, 0x7F, 0x7A, 0x68,
	0x6A, 0x73, 0x88, 0x90, 0x8C, 0x88, 0x84, 0x8A, 0x83, 0x7C, 0x71, 0x71,
	0x7A, 0x7F, 0x85, 0x81, 0x85, 0x85, 0x89, 0x84, 0x7D, 0x79, 0x78, 0x7D,
	0x7D, 0x7F, 0x7E, 0x81, 0x85, 0x84, 0x84, 0x87, 0x88, 0x88, 0x81, 0x7D,
	0x7A, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x84, 0x83, 0x85, 0x7E, 0x81, 0x7A,
	0x98, 0xC0, 0xD0, 0xBF, 0x8B, 0x79, 0x70, 0x7B, 0x6F, 0x62, 0x68, 0x7D,
	0xA0, 0xA2, 0x9D, 0x8A, 0x85, 0x86, 0x7B, 0x72, 0x64, 0x6F, 0x7B, 0x89,
	0x8C, 0x86, 0x8B, 0x88, 0x8B, 0x7E, 0x76, 0x72, 0x74, 0x7F, 0x7D, 0x82,
	0x80, 0x87, 0x88, 0x86, 0x82, 0x7A, 0x7C, 0x79, 0x7A, 0x79, 0x7B, 0x81,
	0x83, 0x87, 0x82, 0x83, 0x80, 0x7F, 0x7E, 0x7B, 0x7D, 0x7C, 0x80, 0x80,
	0x82, 0x82, 0x81, 0x82, 0x80, 0x7F, 0x7E, 0x7C, 0x80, 0x7A, 0x92, 0xBD,
	0xD2, 0xCC, 0x99, 0x7E, 0x70, 0x74, 0x70, 0x60, 0x68, 0x79, 0x9A, 0xA4,
	0x9B, 0x8E, 0x83, 0x86, 0x7C, 0x72, 0x68, 0x6B, 0x7D, 0x86, 0x8E, 0x88,
	0x88, 0x8A, 0x86, 0x82, 0x75, 0x74, 0x75, 0x7D, 0x81, 0x81, 0x83, 0x84,
	0x88, 0x85, 0x80, 0x7C, 0x79, 0x7C, 0x7D, 0x7E, 0x7E, 0x80, 0x83, 0x84,
	0x84, 0x80, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7F, 0x81, 0x83, 0x80,
	0x81, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x81, 0x80, 0x84, 0xAA,
	0xC4, 0xC9, 0xA6, 0x7C, 0x70, 0x6E, 0x78, 0x6D, 0x69, 0x75, 0x8C, 0xA3,
	0x9D, 0x90, 0x7F, 0x7C, 0x7E, 0x78, 0x71, 0x69, 0x74, 0x82, 0x8E, 0x8F,
	0x85, 0x83, 0x81, 0x83, 0x7E, 0x75, 0x74, 0x77, 0x82, 0x85, 0x85, 0x82,
	0x81, 0x84, 0x82, 0x80, 0x79, 0x79, 0x7C, 0x80, 0x82, 0x81, 0x80, 0x82,
	0x81, 0x7E, 0x79, 0x78, 0x7B, 0x7F, 0x82, 0x81, 0x81, 0x81, 0x82, 0x82,
	0x7F, 0x7D, 0x7C, 0x7D, 0x80, 0x7F, 0x81, 0x7F, 0x81, 0x81, 0x82, 0x7F,
	0x83, 0xA9, 0xBF, 0xC4, 0xA1, 0x7C, 0x6F, 0x71, 0x7F, 0x77, 0x71, 0x73,
	0x86, 0x9D, 0x9D, 0x90, 0x7B, 0x75, 0x7B, 0x7D, 0x7C, 0x71, 0x75, 0x80,
	0x8D, 0x91, 0x86, 0x7F, 0x7A, 0x7F, 0x80, 0x7C, 0x78, 0x77, 0x80, 0x86,
	0x88, 0x84, 0x7E, 0x7E, 0x7F, 0x82, 0x7F, 0x7A, 0x7B, 0x7D, 0x83, 0x84,
	0x82, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x7D, 0x7C, 0x7E, 0x81, 0x82, 0x81,
	0x7F, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x7D, 0x7A, 0x7C, 0x7C, 0x7E, 0x80,
	0x80, 0x82, 0x7F, 0x86, 0xA5, 0xB9, 0xBE, 0xA0, 0x7E, 0x6D, 0x6B, 0x77,
	0x75, 0x74, 0x75, 0x84, 0x98, 0x9C, 0x94, 0x7F, 0x74, 0x75, 0x79, 0x7D,
	0x77, 0x7A, 0x81, 0x8E, 0x93, 0x8C, 0x81, 0x77, 0x78, 0x7C, 0x7E, 0x7D,
	0x79, 0x7D, 0x84, 0x89, 0x89, 0x81, 0x7C, 0x7A, 0x7E, 0x7F, 0x7F, 0x7D,
	0x7C, 0x81, 0x84, 0x85, 0x82, 0x7E, 0x7D, 0x7F, 0x82, 0x83, 0x80, 0x7D,
	0x7D, 0x80, 0x83, 0x82, 0x7F, 0x7D, 0x7E, 0x80, 0x82, 0x80, 0x7E, 0x7E,
	0x7F, 0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x97, 0xB0, 0xBC, 0xB0, 0x8C,
	0x76, 0x68, 0x70, 0x76, 0x74, 0x75, 0x78, 0x8A, 0x98, 0x9B, 0x8F, 0x7A,
	0x73, 0x72, 0x7A, 0x7E, 0x7A, 0x79, 0x7C, 0x88, 0x8F, 0x8C, 0x83, 0x78,
	0x77, 0x7B, 0x7F, 0x80, 0x7C, 0x7C, 0x7F, 0x86, 0x8A, 0x86, 0x7F, 0x79,
	0x7A, 0x7E, 0x81, 0x81, 0x7D, 0x7D, 0x7F, 0x84, 0x86, 0x82, 0x7E, 0x7B,
	0x7D, 0x80, 0x81, 0x81, 0x7D, 0x7E, 0x7F, 0x82, 0x83, 0x80, 0x7E, 0x7C,
	0x7E, 0x81, 0x81, 0x80, 0x7D, 0x7E, 0x7F, 0x82, 0x81, 0x84, 0x98, 0xA9,
	0xB5, 0xA8, 0x8C, 0x75, 0x67, 0x6F, 0x76, 0x7A, 0x7A, 0x79, 0x85, 0x90,
	0x97, 0x92, 0x81, 0x75, 0x6F, 0x76, 0x7D, 0x80, 0x7E, 0x7A, 0x7F, 0x85,
	0x8C, 0x8B, 0x82, 0x7A, 0x75, 0x7A, 0x7F, 0x82, 0x80, 0x7C, 0x7D, 0x81,
	0x86, 0x87, 0x82, 0x7D, 0x79, 0x7B, 0x80, 0x82, 0x81, 0x7E, 0x7D, 0x7F,
	0x83, 0x86, 0x85, 0x82, 0x7E, 0x7D, 0x7E, 0x80, 0x81, 0x7F, 0x7E, 0x7D,
	0x7F, 0x82, 0x82, 0x82, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x7E, 0x82,
	0x93, 0xA3, 0xAE, 0xA5, 0x90, 0x7C, 0x70, 0x72, 0x77, 0x7A, 0x78, 0x76,
	0x7C, 0x86, 0x92, 0x95, 0x8D, 0x81, 0x77, 0x76, 0x7A, 0x7E, 0x7E, 0x7A,
	0x7A, 0x7D, 0x84, 0x8A, 0x89, 0x84, 0x7D, 0x7A, 0x7C, 0x7F, 0x80, 0x7E,
	0x7C, 0x7B, 0x7D, 0x81, 0x83, 0x83, 0x80, 0x7D, 0x7D, 0x7E, 0x81, 0x81,
	0x7F, 0x7D, 0x7D, 0x7F, 0x81, 0x82, 0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x81,
	0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x7F, 0x7D, 0x7C, 0x7D, 0x7E,
	0x85, 0x90, 0x99, 0x9F, 0x9A, 0x91, 0x86, 0x7E, 0x7C, 0x7B, 0x7C, 0x7A,
	0x79, 0x7C, 0x81, 0x87, 0x8A, 0x89, 0x85, 0x80, 0x7E, 0x7E, 0x7F, 0x7F,
	0x7D, 0x7B, 0x7B, 0x7E, 0x81, 0x83, 0x83, 0x81, 0x7F, 0x7E, 0x7F, 0x80,
	0x80, 0x7F, 0x7E, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x83,
	0x8A, 0x93, 0x99, 0x97, 0x90, 0x87, 0x82, 0x80, 0x81, 0x81, 0x7F, 0x7C,
	0x7C, 0x7E, 0x82, 0x86, 0x86, 0x83, 0x80, 0x7E, 0x7F, 0x81, 0x82, 0x81,
	0x7E, 0x7D, 0x7E, 0x80, 0x82, 0x82, 0x81, 0x7F, 0x7E, 0x7F, 0x80, 0x81,
	0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x80, 0x7E, 0x7D, 0x7E, 0x7F,
	0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x82, 0x86, 0x8C,
	0x91, 0x92, 0x90, 0x8B, 0x88, 0x87, 0x87, 0x87, 0x86, 0x84, 0x82, 0x82,
	0x83, 0x84, 0x84, 0x83, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7F,
	0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x82, 0x83, 0x85, 0x86, 0x85,
	0x83, 0x82, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x82, 0x82, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x81, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80
};
const unsigned char WAVmixed[] = {
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x85, 0x88,
	0x89, 0x8B, 0x8A, 0x8A, 0x8B, 0x8A, 0x89, 0x87, 0x84, 0x83, 0x81, 0x7F,
	0x7E, 0x7D, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80,
	0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x8A, 0x91, 0x92, 0x96, 0x96, 0x94, 0x96, 0x94, 0x90, 0x8E, 0x87, 0x83,
	0x81, 0x7D, 0x7B, 0x79, 0x76, 0x75, 0x75, 0x75, 0x77, 0x78, 0x7A, 0x7C,
	0x7D, 0x80, 0x81, 0x82, 0x83, 0x84, 0x83, 0x84, 0x83, 0x82, 0x82, 0x81,
	0x80, 0x80, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7E,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x89, 0x98, 0x9A, 0x9D, 0xA1, 0x9C, 0x9F, 0x9F, 0x97,
	0x93, 0x8C, 0x84, 0x83, 0x7E, 0x79, 0x78, 0x74, 0x74, 0x76, 0x75, 0x78,
	0x7A, 0x7A, 0x7E, 0x80, 0x80, 0x83, 0x83, 0x83, 0x85, 0x83, 0x84, 0x84,
	0x81, 0x82, 0x81, 0x7F, 0x80, 0x7E, 0x7D, 0x7E, 0x7D, 0x7D, 0x7E, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x89, 0x9B, 0x9C, 0xA0, 0xA4,
	0x9F, 0xA3, 0xA6, 0x9B, 0x97, 0x92, 0x8A, 0x8A, 0x84, 0x7C, 0x7A, 0x76,
	0x75, 0x77, 0x74, 0x75, 0x77, 0x77, 0x7C, 0x7D, 0x7D, 0x80, 0x81, 0x82,
	0x85, 0x84, 0x83, 0x84, 0x83, 0x83, 0x83, 0x80, 0x80, 0x80, 0x7F, 0x81,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x87,
	0x9B, 0x9E, 0xA0, 0xA6, 0xA2, 0xA5, 0xA9, 0x9D, 0x97, 0x92, 0x89, 0x87,
	0x81, 0x77, 0x76, 0x73, 0x71, 0x73, 0x71, 0x71, 0x76, 0x77, 0x7A, 0x7D,
	0x7D, 0x81, 0x83, 0x83, 0x85, 0x85, 0x84, 0x85, 0x84, 0x83, 0x83, 0x83,
	0x83, 0x83, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x81, 0x7F, 0x89, 0xA3, 0xA2, 0xA0, 0xAC, 0xA9, 0xA4, 0xA0, 0x94,
	0x90, 0x88, 0x7B, 0x79, 0x73, 0x6D, 0x6F, 0x6D, 0x6E, 0x73, 0x73, 0x79,
	0x7D, 0x7F, 0x84, 0x86, 0x86, 0x89, 0x88, 0x87, 0x87, 0x84, 0x82, 0x7E,
	0x7C, 0x7C, 0x79, 0x79, 0x7B, 0x7A, 0x7D, 0x7E, 0x7F, 0x82, 0x82, 0x83,
	0x83, 0x82, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7D, 0x7E, 0x7F,
	0x7E, 0x80, 0x7F, 0x80, 0x81, 0x84, 0x80, 0xA4, 0xBE, 0xA8, 0xBF, 0xC5,
	0xA2, 0x9B, 0x8F, 0x7A, 0x6B, 0x5E, 0x6A, 0x65, 0x61, 0x7C, 0x81, 0x7F,
	0x91, 0x94, 0x91, 0x8E, 0x8A, 0x89, 0x7C, 0x77, 0x7D, 0x72, 0x74, 0x80,
	0x7C, 0x81, 0x87, 0x88, 0x88, 0x83, 0x85, 0x82, 0x7A, 0x7E, 0x7C, 0x79,
	0x7C, 0x7E, 0x7E, 0x7F, 0x82, 0x84, 0x81, 0x81, 0x83, 0x7F, 0x7E, 0x7F,
	0x7E, 0x7D, 0x7E, 0x7F, 0x7E, 0x7E, 0x83, 0x7E, 0x81, 0x7E, 0x92, 0xB7,
	0xA1, 0xB5, 0xC3, 0x9D, 0x95, 0x89, 0x74, 0x61, 0x5D, 0x6A, 0x61, 0x6D,
	0x86, 0x84, 0x8B, 0x94, 0x91, 0x88, 0x82, 0x83, 0x78, 0x70, 0x7C, 0x7C,
	0x79, 0x85, 0x89, 0x85, 0x84, 0x88, 0x81, 0x7A, 0x7E, 0x7B, 0x77, 0x7D,
	0x7F, 0x7F, 0x80, 0x85, 0x83, 0x81, 0x82, 0x81, 0x7C, 0x7E, 0x7F, 0x7D,
	0x7E, 0x80, 0x81, 0x7F, 0x83, 0x80, 0x80, 0x7F, 0x80, 0x7D, 0x7E, 0x7E,
	0x80, 0x7C, 0x90, 0xB5, 0x9B, 0xB2, 0xBE, 0x99, 0x90, 0x84, 0x73, 0x58,
	0x62, 0x6C, 0x5F, 0x7A, 0x88, 0x86, 0x8B, 0x90, 0x8B, 0x7A, 0x81, 0x7A,
	0x71, 0x7C, 0x7F, 0x81, 0x84, 0x8C, 0x88, 0x81, 0x85, 0x7D, 0x77, 0x79,
	0x7A, 0x79, 0x7C, 0x84, 0x82, 0x83, 0x86, 0x82, 0x80, 0x7D, 0x7E, 0x7B,
	0x7B, 0x80, 0x7E, 0x81, 0x84, 0x84, 0x83, 0x82, 0x82, 0x7E, 0x7E, 0x7D,
	0x7D, 0x7D, 0x7F, 0x81, 0x7F, 0x82, 0x81, 0xA9, 0xA5, 0x9E, 0xC1, 0xA3,
	0x91, 0x8B, 0x7A, 0x62, 0x5C, 0x6F, 0x5F, 0x70, 0x87, 0x82, 0x88, 0x8E,
	0x8A, 0x7A, 0x7D, 0x7C, 0x6E, 0x79, 0x80, 0x7E, 0x85, 0x8D, 0x8B, 0x84,
	0x87, 0x80, 0x77, 0x7B, 0x79, 0x76, 0x7C, 0x82, 0x81, 0x83, 0x87, 0x83,
	0x80, 0x80, 0x7E, 0x79, 0x7D, 0x82, 0x7D, 0x85, 0x88, 0x82, 0x85, 0x84,
	0x7F, 0x7C, 0x7E, 0x7B, 0x7A, 0x7E, 0x80, 0x7D, 0x83, 0x82, 0x82, 0x7E,
	0x8D, 0xAE, 0x93, 0xB0, 0xBC, 0x92, 0x9C, 0x8D, 0x72, 0x67, 0x6B, 0x67,
	0x5F, 0x7C, 0x7F, 0x7A, 0x92, 0x8D, 0x83, 0x87, 0x82, 0x77, 0x75, 0x7D,
	0x76, 0x79, 0x86, 0x83, 0x83, 0x8B, 0x86, 0x80, 0x81, 0x7F, 0x78, 0x7B,
	0x7D, 0x7A, 0x7E, 0x83, 0x82, 0x83, 0x86, 0x83, 0x80, 0x81, 0x7F, 0x7C,
	0x7D, 0x7E, 0x7D, 0x7F, 0x81, 0x80, 0x81, 0x82, 0x80, 0x7F, 0x81, 0x7E,
	0x7E, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0xA7, 0x9E, 0x9B, 0xC1, 0x99,
	0x96, 0x9A, 0x77, 0x72, 0x6F, 0x6B, 0x68, 0x71, 0x82, 0x79, 0x88, 0x92,
	0x81, 0x8A, 0x87, 0x7A, 0x7B, 0x7A, 0x78, 0x76, 0x7F, 0x81, 0x7C, 0x89,
	0x85, 0x80, 0x87, 0x81, 0x7A, 0x7B, 0x7B, 0x76, 0x77, 0x7F, 0x7A, 0x7E,
	0x86, 0x80, 0x82, 0x86, 0x80, 0x80, 0x80, 0x7E, 0x7C, 0x7E, 0x80, 0x7C,
	0x80, 0x82, 0x7F, 0x82, 0x82, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x7D, 0x7B,
	0x7F, 0x79, 0x94, 0x99, 0x8B, 0xB0, 0x9D, 0x8C, 0xA1, 0x83, 0x78, 0x7F,
	0x70, 0x70, 0x76, 0x7B, 0x7C, 0x80, 0x8C, 0x84, 0x85, 0x8B, 0x7D, 0x7D,
	0x81, 0x76, 0x7A, 0x7D, 0x7D, 0x81, 0x82, 0x88, 0x86, 0x84, 0x88, 0x80,
	0x7F, 0x81, 0x7A, 0x7C, 0x7E, 0x7C, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x83,
	0x7F, 0x80, 0x80, 0x7D, 0x7E, 0x7F, 0x7D, 0x7F, 0x80, 0x80, 0x81, 0x82,
	0x81, 0x81, 0x83, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7D, 0x88, 0x93,
	0x89, 0x98, 0x9E, 0x8B, 0x95, 0x91, 0x7D, 0x82, 0x7F, 0x74, 0x79, 0x7C,
	0x7A, 0x7D, 0x84, 0x83, 0x82, 0x87, 0x84, 0x80, 0x82, 0x7F, 0x7B, 0x7D,
	0x7D, 0x7B, 0x7E, 0x80, 0x7F, 0x81, 0x83, 0x81, 0x81, 0x82, 0x80, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x82, 0x81,
	0x80, 0x82, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x84, 0x8A, 0x85, 0x8F, 0x93,
	0x8A, 0x90, 0x91, 0x84, 0x88, 0x87, 0x7C, 0x7F, 0x7D, 0x76, 0x79, 0x79,
	0x77, 0x7C, 0x7C, 0x7B, 0x7F, 0x7F, 0x7D, 0x7E, 0x7F, 0x7D, 0x7B, 0x7E,
	0x7D, 0x7A, 0x7F, 0x7D, 0x7A, 0x81, 0x7F, 0x7C, 0x85, 0x81, 0x7E, 0x86,
	0x80, 0x7E, 0x86, 0x80, 0x7D, 0x84, 0x80, 0x7D, 0x83, 0x81, 0x7D, 0x83,
	0x82, 0x7E, 0x83, 0x82, 0x7E, 0x81, 0x81, 0x7E, 0x80, 0x80, 0x7C, 0x7E,
	0x7E, 0x7B, 0x7C, 0x7D, 0x7C, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81,
	0x81, 0x82, 0x81, 0x80, 0x81, 0x81, 0x81, 0x82, 0x83, 0x82, 0x82, 0x83,
	0x82, 0x82, 0x82, 0x81, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x81,
	0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x81, 0x7E, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x82, 0x7F, 0x7E, 0x82, 0x81, 0x7E,
	0x80, 0x80, 0x7E, 0x80, 0x80, 0x7D, 0x7F, 0x81, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x80,
	0x80, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x82, 0x7F,
	0x7C, 0x81, 0x83, 0x81, 0x7D, 0x7F, 0x82, 0x7F, 0x7E, 0x81, 0x81, 0x7E,
	0x7E, 0x81, 0x7F, 0x7D, 0x81, 0x83, 0x7E, 0x7F, 0x81, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x7F, 0x7D,
	0x7F, 0x80, 0x7E, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x80, 0x80, 0x82,
	0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x81, 0x81, 0x7E, 0x7F, 0x83,
	0x81, 0x7C, 0x80, 0x84, 0x7E, 0x7D, 0x81, 0x80, 0x7D, 0x80, 0x82, 0x7F,
	0x7F, 0x81, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x82, 0x80, 0x7D,
	0x83, 0x82, 0x7F, 0x81, 0x82, 0x80, 0x7C, 0x81, 0x82, 0x7B, 0x7E, 0x83,
	0x7C, 0x7B, 0x84, 0x80, 0x7D, 0x82, 0x84, 0x7E, 0x7E, 0x83, 0x81, 0x7C,
	0x80, 0x83, 0x7D, 0x7E, 0x81, 0x80, 0x7D, 0x81, 0x81, 0x7D, 0x80, 0x82,
	0x7F, 0x7F, 0x83, 0x7F, 0x7D, 0x82, 0x81, 0x7C, 0x81, 0x83, 0x7D, 0x7E,
	0x82, 0x7F, 0x7D, 0x82, 0x80, 0x7B, 0x81, 0x81, 0x7C, 0x81, 0x82, 0x7D,
	0x80, 0x84, 0x7D, 0x7E, 0x81, 0x7D, 0x7E, 0x80, 0x80, 0x7F, 0x82, 0x80,
	0x7E, 0x81, 0x82, 0x7D, 0x80, 0x83, 0x7E, 0x7F, 0x81, 0x7F, 0x7D, 0x81,
	0x81, 0x7C, 0x81, 0x82, 0x7C, 0x81, 0x83, 0x7C, 0x80, 0x84, 0x7D, 0x7C,
	0x85, 0x7F, 0x7B, 0x82, 0x81, 0x7D, 0x7F, 0x83, 0x7C, 0x80, 0x83, 0x7E,
	0x7F, 0x83, 0x7E, 0x7E, 0x82, 0x7E, 0x7E, 0x80, 0x80, 0x7D, 0x7F, 0x82,
	0x7E, 0x7C, 0x83, 0x80, 0x7C, 0x83, 0x81, 0x7C, 0x81, 0x82, 0x7C, 0x7F,
	0x83, 0x7D, 0x7E, 0x83, 0x7E, 0x7E, 0x84, 0x7F, 0x7D, 0x84, 0x81, 0x7B,
	0x82, 0x81, 0x7B, 0x82, 0x81, 0x7B, 0x80, 0x83, 0x7D, 0x7D, 0x83, 0x7F,
	0x7D, 0x81, 0x82, 0x7C, 0x80, 0x83, 0x7B, 0x7E, 0x83, 0x7F, 0x7C, 0x83,
	0x81, 0x7B, 0x82, 0x83, 0x7C, 0x7F, 0x84, 0x7D, 0x7D, 0x84, 0x80, 0x7C,
	0x82, 0x80, 0x7C, 0x81, 0x81, 0x7D, 0x7F, 0x82, 0x7F, 0x7E, 0x82, 0x80,
	0x7D, 0x7F, 0x82, 0x7E, 0x7F, 0x82, 0x80, 0x7F, 0x81, 0x80, 0x7E, 0x80,
	0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7D, 0x80, 0x81, 0x7D, 0x80, 0x82, 0x7D,
	0x7F, 0x82, 0x7E, 0x7E, 0x82, 0x7E, 0x7E, 0x82, 0x7F, 0x7E, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7E, 0x82, 0x7F, 0x7D, 0x81, 0x80, 0x7E, 0x80, 0x81,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x81, 0x80,
	0x7D, 0x81, 0x81, 0x7E, 0x80, 0x81, 0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7F,
	0x81, 0x7F, 0x7F, 0x81, 0x80, 0x7D, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7E, 0x7F, 0x81, 0x7F,
	0x7E, 0x81, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x81, 0x7F, 0x7E, 0x81, 0x80,
	0x7E, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7F,
	0x7E, 0x81, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7E, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7D, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x81, 0x81, 0x7E, 0x7F, 0x81, 0x7E,
	0x7E, 0x81, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x81, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81,
	0x80, 0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x81, 0x80, 0x7F, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVmode[] = {
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x85, 0x88, 0x8A, 0x8C,
	0x8A, 0x89, 0x89, 0x89, 0x89, 0x87, 0x84, 0x82, 0x7F, 0x7F, 0x7F, 0x7D,
	0x7D, 0x7B, 0x7B, 0x7B, 0x7C, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x83, 0x8E, 0x94,
	0x98, 0x99, 0x93, 0x92, 0x91, 0x90, 0x8F, 0x8A, 0x83, 0x7F, 0x7C, 0x7D,
	0x7C, 0x7A, 0x78, 0x76, 0x77, 0x79, 0x7A, 0x7B, 0x7B, 0x7B, 0x7C, 0x7E,
	0x80, 0x81, 0x81, 0x81, 0x81, 0x82, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7E, 0x7D, 0x7D,
	0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x86,
	0x96, 0x9C, 0xA1, 0x9F, 0x95, 0x94, 0x93, 0x93, 0x93, 0x8A, 0x83, 0x7D,
	0x7A, 0x7C, 0x7B, 0x79, 0x75, 0x71, 0x73, 0x74, 0x77, 0x79, 0x77, 0x78,
	0x79, 0x7C, 0x80, 0x81, 0x82, 0x82, 0x81, 0x83, 0x85, 0x85, 0x86, 0x83,
	0x83, 0x82, 0x82, 0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7D, 0x7D, 0x7D, 0x7D, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x81, 0x92, 0x9F, 0xA4, 0xA7, 0x9C, 0x95, 0x95, 0x93, 0x96, 0x91, 0x88,
	0x81, 0x7A, 0x7A, 0x7A, 0x78, 0x76, 0x70, 0x6E, 0x6F, 0x71, 0x76, 0x76,
	0x76, 0x77, 0x77, 0x7C, 0x80, 0x82, 0x83, 0x82, 0x83, 0x85, 0x86, 0x88,
	0x87, 0x86, 0x85, 0x83, 0x84, 0x83, 0x82, 0x82, 0x7E, 0x7B, 0x7A, 0x79,
	0x7A, 0x7A, 0x7A, 0x7A, 0x79, 0x7A, 0x7B, 0x7C, 0x7E, 0x7E, 0x7E, 0x80,
	0x80, 0x82, 0x93, 0xA2, 0xA7, 0xAB, 0xA0, 0x97, 0x96, 0x95, 0x98, 0x96,
	0x8D, 0x85, 0x7C, 0x7B, 0x7B, 0x7A, 0x78, 0x71, 0x6E, 0x6D, 0x6E, 0x73,
	0x75, 0x75, 0x75, 0x75, 0x79, 0x7C, 0x80, 0x83, 0x82, 0x83, 0x84, 0x86,
	0x88, 0x88, 0x88, 0x87, 0x85, 0x85, 0x84, 0x84, 0x83, 0x82, 0x81, 0x7F,
	0x7F, 0x7E, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7D,
	0x7E, 0x7E, 0x83, 0x98, 0xA4, 0xAC, 0xAC, 0x9E, 0x97, 0x94, 0x94, 0x98,
	0x92, 0x8A, 0x81, 0x7A, 0x7A, 0x79, 0x79, 0x76, 0x70, 0x6E, 0x6D, 0x72,
	0x76, 0x78, 0x79, 0x78, 0x7A, 0x7D, 0x81, 0x85, 0x86, 0x85, 0x85, 0x85,
	0x87, 0x87, 0x87, 0x86, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7D, 0x7C, 0x7A,
	0x7A, 0x7B, 0x7C, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x80, 0x81, 0x81, 0x80,
	0x81, 0x80, 0x87, 0xA0, 0xB0, 0xBB, 0xB6, 0xA3, 0x97, 0x8D, 0x8E, 0x8D,
	0x86, 0x7B, 0x6E, 0x6B, 0x6F, 0x75, 0x7B, 0x78, 0x75, 0x74, 0x78, 0x81,
	0x85, 0x86, 0x82, 0x7F, 0x80, 0x82, 0x86, 0x85, 0x82, 0x7E, 0x7D, 0x7F,
	0x81, 0x82, 0x80, 0x7D, 0x7C, 0x7D, 0x7F, 0x81, 0x81, 0x82, 0x81, 0x82,
	0x82, 0x82, 0x81, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x81, 0x7E, 0x94, 0xB3, 0xC5, 0xCB, 0xB2, 0x95, 0x7D, 0x74, 0x78, 0x77,
	0x74, 0x6C, 0x6A, 0x76, 0x85, 0x92, 0x90, 0x86, 0x7C, 0x79, 0x7E, 0x82,
	0x80, 0x7A, 0x75, 0x78, 0x80, 0x88, 0x8A, 0x84, 0x7D, 0x7B, 0x7E, 0x82,
	0x83, 0x7F, 0x7A, 0x79, 0x7E, 0x84, 0x86, 0x83, 0x7C, 0x79, 0x7A, 0x7E,
	0x81, 0x80, 0x7D, 0x7C, 0x7F, 0x83, 0x84, 0x83, 0x7E, 0x7C, 0x7D, 0x80,
	0x81, 0x82, 0xA5, 0xC3, 0xD6, 0xCA, 0xA0, 0x7F, 0x65, 0x68, 0x6D, 0x6E,
	0x6C, 0x6D, 0x7D, 0x91, 0x9D, 0x99, 0x86, 0x77, 0x71, 0x77, 0x7D, 0x7A,
	0x75, 0x74, 0x7E, 0x8B, 0x91, 0x8D, 0x80, 0x78, 0x78, 0x7D, 0x82, 0x7E,
	0x79, 0x77, 0x7F, 0x87, 0x8B, 0x86, 0x7E, 0x79, 0x7C, 0x83, 0x84, 0x81,
	0x7B, 0x7A, 0x7E, 0x85, 0x86, 0x82, 0x7C, 0x7B, 0x7D, 0x84, 0x82, 0x81,
	0x78, 0x8A, 0xBC, 0xD7, 0xE0, 0xB4, 0x85, 0x67, 0x63, 0x73, 0x6F, 0x6A,
	0x62, 0x74, 0x93, 0xA6, 0xA6, 0x88, 0x73, 0x6C, 0x76, 0x82, 0x7B, 0x72,
	0x6C, 0x7A, 0x90, 0x99, 0x93, 0x7D, 0x73, 0x75, 0x80, 0x86, 0x7E, 0x75,
	0x72, 0x7E, 0x8D, 0x90, 0x87, 0x79, 0x75, 0x7B, 0x86, 0x88, 0x80, 0x78,
	0x78, 0x81, 0x89, 0x89, 0x7F, 0x78, 0x77, 0x80, 0x85, 0x86, 0x7C, 0x7A,
	0x78, 0x92, 0xC4, 0xD9, 0xD7, 0xA6, 0x7F, 0x69, 0x69, 0x74, 0x69, 0x65,
	0x65, 0x7F, 0x9F, 0xAD, 0xA3, 0x84, 0x73, 0x70, 0x7A, 0x7D, 0x73, 0x6C,
	0x6F, 0x85, 0x97, 0x99, 0x8B, 0x79, 0x74, 0x7A, 0x83, 0x80, 0x77, 0x72,
	0x78, 0x88, 0x90, 0x8D, 0x7F, 0x77, 0x78, 0x82, 0x82, 0x7B, 0x71, 0x71,
	0x7D, 0x88, 0x8D, 0x84, 0x7C, 0x7A, 0x80, 0x85, 0x83, 0x7A, 0x75, 0x78,
	0x84, 0x85, 0xA0, 0xC1, 0xD1, 0xCC, 0xA2, 0x82, 0x65, 0x66, 0x69, 0x69,
	0x6B, 0x70, 0x87, 0x97, 0xA0, 0x95, 0x82, 0x75, 0x72, 0x78, 0x78, 0x75,
	0x74, 0x79, 0x89, 0x90, 0x91, 0x85, 0x7B, 0x78, 0x7B, 0x80, 0x7C, 0x79,
	0x77, 0x7F, 0x87, 0x8A, 0x86, 0x7E, 0x7B, 0x7D, 0x7E, 0x7C, 0x77, 0x77,
	0x7A, 0x83, 0x87, 0x86, 0x81, 0x7E, 0x7F, 0x81, 0x81, 0x7D, 0x7A, 0x7B,
	0x80, 0x83, 0x85, 0x7F, 0x9F, 0xC2, 0xD7, 0xC9, 0x98, 0x77, 0x62, 0x6E,
	0x70, 0x6C, 0x67, 0x6C, 0x8A, 0x9F, 0xA7, 0x93, 0x7B, 0x73, 0x75, 0x7F,
	0x78, 0x71, 0x6E, 0x7A, 0x8E, 0x95, 0x90, 0x7F, 0x78, 0x7A, 0x81, 0x81,
	0x79, 0x74, 0x76, 0x83, 0x8C, 0x8B, 0x82, 0x7A, 0x7E, 0x85, 0x89, 0x83,
	0x79, 0x77, 0x7C, 0x85, 0x86, 0x80, 0x7C, 0x7A, 0x82, 0x85, 0x84, 0x7D,
	0x79, 0x7C, 0x81, 0x85, 0x80, 0x7E, 0x79, 0xA0, 0xC7, 0xD7, 0xC3, 0x90,
	0x76, 0x68, 0x70, 0x6A, 0x5E, 0x5E, 0x6F, 0x95, 0xA8, 0xA6, 0x8F, 0x7B,
	0x7A, 0x7B, 0x7C, 0x6F, 0x67, 0x6E, 0x81, 0x94, 0x94, 0x8B, 0x7E, 0x7D,
	0x82, 0x82, 0x7B, 0x71, 0x72, 0x7B, 0x88, 0x8C, 0x85, 0x7F, 0x7C, 0x82,
	0x84, 0x80, 0x79, 0x75, 0x7B, 0x82, 0x87, 0x84, 0x7E, 0x7E, 0x80, 0x84,
	0x82, 0x7D, 0x79, 0x7B, 0x80, 0x84, 0x82, 0x7F, 0x7C, 0x81, 0x80, 0x8E,
	0xB2, 0xC6, 0xC9, 0xA5, 0x83, 0x6F, 0x6C, 0x74, 0x6D, 0x6A, 0x6D, 0x81,
	0x9A, 0xA2, 0x9A, 0x85, 0x79, 0x79, 0x7B, 0x7A, 0x70, 0x6E, 0x76, 0x86,
	0x92, 0x8F, 0x85, 0x7D, 0x7E, 0x82, 0x80, 0x7A, 0x76, 0x7A, 0x85, 0x8B,
	0x8B, 0x82, 0x7E, 0x7E, 0x81, 0x82, 0x7D, 0x78, 0x78, 0x7E, 0x85, 0x86,
	0x82, 0x7E, 0x7E, 0x81, 0x83, 0x80, 0x7B, 0x7A, 0x7D, 0x82, 0x83, 0x82,
	0x7E, 0x7F, 0x7F, 0x83, 0x7E, 0x87, 0xA9, 0xBE, 0xC7, 0xAA, 0x89, 0x75,
	0x6F, 0x77, 0x70, 0x6A, 0x69, 0x79, 0x93, 0x9F, 0x9B, 0x89, 0x7C, 0x7C,
	0x7E, 0x7E, 0x73, 0x6C, 0x72, 0x7F, 0x8E, 0x8F, 0x87, 0x80, 0x7F, 0x85,
	0x84, 0x7E, 0x75, 0x72, 0x7A, 0x83, 0x88, 0x84, 0x7F, 0x7F, 0x82, 0x86,
	0x83, 0x7C, 0x77, 0x79, 0x80, 0x84, 0x83, 0x7E, 0x7D, 0x80, 0x84, 0x84,
	0x80, 0x7B, 0x7B, 0x80, 0x83, 0x84, 0x80, 0x7D, 0x7D, 0x82, 0x82, 0x83,
	0x7B, 0x88, 0xAC, 0xBF, 0xC5, 0xA4, 0x85, 0x75, 0x73, 0x7B, 0x70, 0x68,
	0x67, 0x78, 0x94, 0x9E, 0x9A, 0x87, 0x7B, 0x7E, 0x81, 0x80, 0x73, 0x6A,
	0x70, 0x7E, 0x8E, 0x8F, 0x86, 0x7F, 0x7E, 0x85, 0x86, 0x7F, 0x75, 0x70,
	0x79, 0x83, 0x88, 0x85, 0x7D, 0x7D, 0x82, 0x87, 0x85, 0x7C, 0x77, 0x77,
	0x7F, 0x84, 0x84, 0x80, 0x7D, 0x81, 0x85, 0x86, 0x81, 0x7B, 0x79, 0x7C,
	0x81, 0x83, 0x7F, 0x7D, 0x7E, 0x81, 0x85, 0x82, 0x80, 0x79, 0x88, 0xAB,
	0xBD, 0xBF, 0xA2, 0x85, 0x79, 0x76, 0x7C, 0x71, 0x66, 0x68, 0x77, 0x92,
	0x9D, 0x97, 0x88, 0x7C, 0x81, 0x84, 0x81, 0x75, 0x6A, 0x6F, 0x7C, 0x8B,
	0x8E, 0x85, 0x7F, 0x7F, 0x86, 0x89, 0x81, 0x76, 0x71, 0x77, 0x82, 0x87,
	0x85, 0x7D, 0x7C, 0x83, 0x89, 0x89, 0x80, 0x78, 0x77, 0x7D, 0x84, 0x83,
	0x7E, 0x7B, 0x7D, 0x84, 0x87, 0x84, 0x7D, 0x79, 0x7C, 0x81, 0x83, 0x80,
	0x7B, 0x7B, 0x7F, 0x84, 0x84, 0x81, 0x7C, 0x7E, 0x9D, 0xB4, 0xBD, 0xAE,
	0x8E, 0x7F, 0x79, 0x7C, 0x78, 0x68, 0x64, 0x6B, 0x82, 0x97, 0x97, 0x8E,
	0x81, 0x80, 0x86, 0x85, 0x7D, 0x6F, 0x6A, 0x74, 0x82, 0x8C, 0x88, 0x80,
	0x7E, 0x82, 0x89, 0x87, 0x7C, 0x74, 0x72, 0x7B, 0x84, 0x85, 0x80, 0x7B,
	0x7E, 0x85, 0x89, 0x85, 0x7C, 0x77, 0x7A, 0x80, 0x84, 0x81, 0x7C, 0x7B,
	0x7F, 0x85, 0x86, 0x82, 0x7C, 0x7A, 0x7E, 0x83, 0x81, 0x7D, 0x78, 0x79,
	0x7F, 0x84, 0x83, 0x80, 0x7B, 0x85, 0xA4, 0xB6, 0xBB, 0xA6, 0x8A, 0x7F,
	0x7A, 0x7C, 0x74, 0x65, 0x63, 0x6D, 0x84, 0x95, 0x94, 0x8C, 0x81, 0x83,
	0x89, 0x86, 0x7B, 0x6C, 0x68, 0x72, 0x80, 0x88, 0x85, 0x7F, 0x7F, 0x86,
	0x8D, 0x8A, 0x7E, 0x75, 0x74, 0x7B, 0x83, 0x82, 0x7D, 0x79, 0x7D, 0x86,
	0x8A, 0x86, 0x7E, 0x79, 0x7B, 0x81, 0x83, 0x7F, 0x7B, 0x7C, 0x81, 0x87,
	0x87, 0x81, 0x7D, 0x7C, 0x80, 0x83, 0x81, 0x7C, 0x7A, 0x7C, 0x81, 0x85,
	0x82, 0x7F, 0x7B, 0x8B, 0xA6, 0xB3, 0xB3, 0x9E, 0x89, 0x83, 0x7F, 0x7D,
	0x70, 0x62, 0x65, 0x72, 0x85, 0x8E, 0x8A, 0x87, 0x87, 0x8D, 0x90, 0x85,
	0x79, 0x70, 0x71, 0x7B, 0x7E, 0x7D, 0x7A, 0x7C, 0x85, 0x8C, 0x8B, 0x84,
	0x7C, 0x7C, 0x7F, 0x81, 0x7E, 0x78, 0x77, 0x7C, 0x83, 0x86, 0x83, 0x80,
	0x80, 0x83, 0x85, 0x82, 0x7D, 0x7A, 0x7C, 0x7F, 0x81, 0x7F, 0x7D, 0x7E,
	0x82, 0x84, 0x83, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7F, 0x7C, 0x7D, 0x7F,
	0x85, 0x9B, 0xA5, 0xA7, 0xA0, 0x93, 0x8F, 0x8A, 0x7F, 0x75, 0x69, 0x6A,
	0x74, 0x7A, 0x80, 0x81, 0x85, 0x8D, 0x90, 0x8E, 0x87, 0x7E, 0x7C, 0x7B,
	0x7A, 0x78, 0x75, 0x78, 0x7E, 0x83, 0x85, 0x84, 0x82, 0x84, 0x84, 0x82,
	0x7E, 0x7A, 0x7A, 0x7C, 0x7D, 0x7D, 0x7D, 0x7F, 0x82, 0x83, 0x83, 0x81,
	0x80, 0x80, 0x81, 0x7F, 0x7D, 0x7C, 0x7D, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x81, 0x82, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7E, 0x81, 0x95, 0xA1,
	0xA0, 0x9B, 0x91, 0x91, 0x8F, 0x83, 0x77, 0x6F, 0x6F, 0x78, 0x79, 0x7A,
	0x7D, 0x83, 0x8C, 0x8E, 0x89, 0x86, 0x83, 0x83, 0x7E, 0x75, 0x72, 0x73,
	0x77, 0x7B, 0x7A, 0x7D, 0x82, 0x87, 0x89, 0x86, 0x82, 0x82, 0x81, 0x7F,
	0x7C, 0x78, 0x7A, 0x7C, 0x7D, 0x7E, 0x7E, 0x81, 0x84, 0x84, 0x83, 0x81,
	0x80, 0x81, 0x7E, 0x7C, 0x7B, 0x7B, 0x7D, 0x7E, 0x7D, 0x7F, 0x81, 0x82,
	0x83, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x92, 0x9B, 0x9A, 0x97, 0x91,
	0x93, 0x91, 0x84, 0x7A, 0x75, 0x75, 0x79, 0x77, 0x77, 0x7E, 0x85, 0x8A,
	0x89, 0x87, 0x89, 0x88, 0x85, 0x80, 0x7A, 0x7A, 0x7C, 0x7A, 0x7A, 0x7B,
	0x7E, 0x82, 0x83, 0x82, 0x83, 0x84, 0x84, 0x82, 0x7F, 0x7E, 0x7E, 0x7D,
	0x7D, 0x7C, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x80, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x7F, 0x86, 0x93, 0x92, 0x91, 0x91, 0x8F, 0x8E, 0x86, 0x7D,
	0x7B, 0x79, 0x78, 0x77, 0x76, 0x7C, 0x80, 0x82, 0x84, 0x85, 0x87, 0x88,
	0x84, 0x81, 0x80, 0x7E, 0x7D, 0x7B, 0x7A, 0x7C, 0x7D, 0x7E, 0x7F, 0x80,
	0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x89, 0x8D, 0x8A, 0x8D, 0x8D, 0x8D, 0x8A, 0x83, 0x81, 0x81, 0x7C, 0x7A,
	0x79, 0x7B, 0x7E, 0x7D, 0x7F, 0x82, 0x83, 0x84, 0x83, 0x83, 0x83, 0x81,
	0x7F, 0x7E, 0x7D, 0x7D, 0x7C, 0x7B, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x81,
	0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x86, 0x86, 0x87,
	0x89, 0x89, 0x8A, 0x88, 0x85, 0x85, 0x83, 0x80, 0x7F, 0x7D, 0x7D, 0x7C,
	0x7B, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7D, 0x7C, 0x7B, 0x7B, 0x7C, 0x7B, 0x7A, 0x7A, 0x7B, 0x7B, 0x7B,
	0x7C, 0x7E, 0x7D, 0x7D, 0x7F, 0x7F, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81,
	0x81, 0x81, 0x82, 0x83, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80,
	0x7F, 0x7F, 0x7E, 0x7C, 0x7C, 0x7D, 0x7C, 0x7C, 0x7D, 0x7D, 0x7C, 0x7E,
	0x7E, 0x7E, 0x7E, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7D,
	0x7E, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x82, 0x82, 0x80,
	0x83, 0x82, 0x81, 0x81, 0x81, 0x7E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7D, 0x7E,
	0x7E, 0x7F, 0x82, 0x80, 0x7F, 0x82, 0x81, 0x80, 0x80, 0x83, 0x81, 0x7E,
	0x80, 0x7F, 0x7E, 0x7E, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7E, 0x7D, 0x7F,
	0x7F, 0x7D, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x81, 0x7D, 0x7F, 0x80, 0x7F,
	0x7D, 0x7E, 0x7F, 0x7C, 0x7D, 0x7E, 0x7F, 0x7E, 0x7D, 0x7F, 0x7E, 0x7F,
	0x80, 0x81, 0x81, 0x80, 0x82, 0x83, 0x82, 0x81, 0x81, 0x7F, 0x7D, 0x7D,
	0x7F, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81,
	0x81, 0x82, 0x83, 0x81, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x7E, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7D, 0x7F, 0x7F, 0x7E, 0x80, 0x81, 0x81, 0x80,
	0x82, 0x83, 0x80, 0x81, 0x83, 0x80, 0x7F, 0x80, 0x7F, 0x7B, 0x7D, 0x7E,
	0x7E, 0x7E, 0x83, 0x84, 0x81, 0x82, 0x85, 0x82, 0x7F, 0x80, 0x7F, 0x7D,
	0x7D, 0x81, 0x7F, 0x7F, 0x81, 0x82, 0x7F, 0x7F, 0x83, 0x81, 0x80, 0x83,
	0x84, 0x82, 0x82, 0x83, 0x82, 0x7F, 0x7F, 0x7F, 0x7C, 0x7D, 0x7E, 0x7C,
	0x7B, 0x7E, 0x80, 0x7F, 0x80, 0x83, 0x83, 0x81, 0x80, 0x82, 0x7F, 0x7D,
	0x7F, 0x80, 0x7E, 0x7F, 0x81, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x7D, 0x7F,
	0x7F, 0x7E, 0x80, 0x81, 0x7E, 0x7E, 0x7F, 0x7F, 0x7D, 0x7E, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x83, 0x82,
	0x81, 0x83, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F
};
const unsigned char WAVnot[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x83, 0x83, 0x83, 0x83,
	0x83, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x86, 0x8A, 0x8E, 0x90, 0x90, 0x8F, 0x8E,
	0x8E, 0x8E, 0x8C, 0x89, 0x85, 0x81, 0x7E, 0x7C, 0x7C, 0x7B, 0x7A, 0x79,
	0x79, 0x7A, 0x7B, 0x7D, 0x7F, 0x81, 0x82, 0x83, 0x84, 0x84, 0x85, 0x85,
	0x84, 0x83, 0x82, 0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7C,
	0x7D, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x83, 0x84, 0x84, 0x84, 0x84,
	0x83, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x80, 0x8B, 0x92, 0x98, 0x9C,
	0x99, 0x99, 0x98, 0x98, 0x98, 0x94, 0x8F, 0x87, 0x81, 0x7C, 0x7A, 0x7A,
	0x77, 0x77, 0x76, 0x77, 0x7A, 0x7D, 0x82, 0x85, 0x87, 0x89, 0x89, 0x8B,
	0x8B, 0x8B, 0x8A, 0x87, 0x85, 0x81, 0x7F, 0x7D, 0x7C, 0x7B, 0x79, 0x79,
	0x78, 0x7A, 0x7B, 0x7D, 0x7F, 0x81, 0x82, 0x84, 0x85, 0x87, 0x87, 0x87,
	0x86, 0x85, 0x83, 0x82, 0x81, 0x7F, 0x7E, 0x7D, 0x7B, 0x7B, 0x7B, 0x86,
	0x91, 0x96, 0x9E, 0x9D, 0x9C, 0x9D, 0x9C, 0x9E, 0x9A, 0x95, 0x8D, 0x85,
	0x80, 0x7A, 0x78, 0x75, 0x72, 0x71, 0x70, 0x73, 0x76, 0x7B, 0x80, 0x84,
	0x87, 0x89, 0x8C, 0x8E, 0x8E, 0x8F, 0x8C, 0x8A, 0x86, 0x82, 0x80, 0x7D,
	0x7B, 0x78, 0x77, 0x76, 0x76, 0x77, 0x79, 0x7B, 0x7C, 0x7D, 0x7F, 0x81,
	0x83, 0x84, 0x85, 0x85, 0x84, 0x83, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x7C,
	0x7B, 0x7B, 0x7B, 0x85, 0x90, 0x95, 0x9D, 0x9D, 0x9C, 0x9C, 0x9C, 0x9E,
	0x9B, 0x97, 0x90, 0x88, 0x83, 0x7D, 0x7C, 0x7A, 0x78, 0x77, 0x75, 0x76,
	0x79, 0x7D, 0x82, 0x85, 0x89, 0x8A, 0x8B, 0x8D, 0x8E, 0x8F, 0x8D, 0x8B,
	0x87, 0x83, 0x81, 0x7E, 0x7D, 0x7B, 0x79, 0x78, 0x77, 0x79, 0x7A, 0x7D,
	0x7F, 0x81, 0x82, 0x84, 0x85, 0x87, 0x87, 0x88, 0x87, 0x86, 0x84, 0x82,
	0x81, 0x7F, 0x7E, 0x7D, 0x7B, 0x7A, 0x7B, 0x7A, 0x83, 0x92, 0x97, 0x9F,
	0xA2, 0x9F, 0xA0, 0x9E, 0xA2, 0x9F, 0x99, 0x93, 0x88, 0x82, 0x7C, 0x7B,
	0x7A, 0x76, 0x75, 0x72, 0x74, 0x77, 0x7D, 0x82, 0x85, 0x88, 0x89, 0x8B,
	0x8E, 0x90, 0x91, 0x8E, 0x8C, 0x88, 0x84, 0x81, 0x7D, 0x7B, 0x77, 0x75,
	0x74, 0x73, 0x75, 0x75, 0x78, 0x7A, 0x7C, 0x7F, 0x80, 0x84, 0x84, 0x86,
	0x86, 0x86, 0x86, 0x85, 0x84, 0x82, 0x81, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B,
	0x7B, 0x7B, 0x91, 0x9F, 0xA3, 0xAA, 0xA9, 0xAC, 0xA5, 0xA5, 0xA3, 0x9A,
	0x94, 0x89, 0x85, 0x7C, 0x76, 0x74, 0x71, 0x71, 0x6F, 0x73, 0x74, 0x77,
	0x7B, 0x7E, 0x83, 0x84, 0x87, 0x89, 0x89, 0x87, 0x85, 0x84, 0x81, 0x7F,
	0x7E, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7E, 0x7E, 0x7F, 0x80,
	0x80, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7F,
	0x7F, 0x82, 0x83, 0x83, 0x83, 0x84, 0x82, 0x9F, 0xB6, 0xB6, 0xB8, 0xB5,
	0xB5, 0x9D, 0x8B, 0x83, 0x79, 0x6E, 0x63, 0x6A, 0x6B, 0x6C, 0x6E, 0x76,
	0x7F, 0x7E, 0x82, 0x86, 0x89, 0x87, 0x85, 0x86, 0x84, 0x82, 0x7D, 0x7F,
	0x7E, 0x7D, 0x7D, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7D, 0x7F, 0x7E, 0x7F, 0x7D, 0x80, 0x7F, 0x82, 0x7D, 0x90,
	0xC6, 0xC9, 0xBF, 0xAF, 0xB3, 0x9C, 0x70, 0x62, 0x63, 0x6E, 0x62, 0x6F,
	0x87, 0x96, 0x92, 0x88, 0x92, 0x8B, 0x7F, 0x69, 0x6D, 0x76, 0x74, 0x77,
	0x7D, 0x90, 0x8B, 0x87, 0x82, 0x84, 0x80, 0x74, 0x76, 0x7A, 0x81, 0x7D,
	0x80, 0x86, 0x88, 0x83, 0x7D, 0x80, 0x7F, 0x7C, 0x79, 0x7D, 0x81, 0x80,
	0x80, 0x7F, 0x83, 0x7F, 0x7E, 0x7D, 0x7F, 0x80, 0x7D, 0x80, 0x7F, 0x84,
	0x7D, 0x83, 0x79, 0xA7, 0xDD, 0xD1, 0xB3, 0x92, 0x9B, 0x77, 0x58, 0x4E,
	0x70, 0x88, 0x84, 0x8E, 0x9C, 0xA7, 0x8A, 0x7F, 0x7A, 0x80, 0x74, 0x6D,
	0x7B, 0x88, 0x8E, 0x82, 0x87, 0x89, 0x86, 0x78, 0x74, 0x7B, 0x7F, 0x7E,
	0x7C, 0x85, 0x88, 0x85, 0x7E, 0x7E, 0x80, 0x7D, 0x7A, 0x7B, 0x81, 0x83,
	0x80, 0x80, 0x82, 0x82, 0x80, 0x7B, 0x7F, 0x7E, 0x81, 0x7D, 0x80, 0x81,
	0x83, 0x7F, 0x7F, 0x7F, 0x81, 0x7C, 0x89, 0xDA, 0xE6, 0xC5, 0x89, 0x83,
	0x83, 0x62, 0x50, 0x5C, 0x96, 0x9D, 0x9B, 0x8B, 0x9B, 0x92, 0x75, 0x61,
	0x66, 0x80, 0x7E, 0x81, 0x84, 0x97, 0x92, 0x81, 0x75, 0x76, 0x7D, 0x76,
	0x77, 0x7E, 0x8C, 0x8B, 0x83, 0x7F, 0x80, 0x81, 0x78, 0x77, 0x7B, 0x84,
	0x83, 0x82, 0x83, 0x85, 0x83, 0x7C, 0x7B, 0x7C, 0x80, 0x7E, 0x7F, 0x81,
	0x84, 0x83, 0x7F, 0x7E, 0x7E, 0x7F, 0x7E, 0x7D, 0x82, 0x7F, 0xBF, 0xEE,
	0xD8, 0x98, 0x6B, 0x7A, 0x6F, 0x62, 0x57, 0x87, 0xAF, 0xB1, 0x94, 0x81,
	0x88, 0x7A, 0x6B, 0x5C, 0x75, 0x8C, 0x96, 0x8B, 0x87, 0x8C, 0x85, 0x77,
	0x69, 0x73, 0x7F, 0x86, 0x83, 0x84, 0x8A, 0x88, 0x80, 0x75, 0x78, 0x7C,
	0x80, 0x7F, 0x82, 0x86, 0x86, 0x82, 0x7C, 0x7B, 0x7D, 0x7E, 0x7D, 0x7F,
	0x82, 0x84, 0x82, 0x80, 0x7D, 0x7F, 0x7D, 0x7F, 0x7D, 0x82, 0x7F, 0x85,
	0x7A, 0x9C, 0xE2, 0xE9, 0xB4, 0x66, 0x67, 0x70, 0x74, 0x5D, 0x6E, 0x9D,
	0xB6, 0xAA, 0x7D, 0x74, 0x71, 0x7A, 0x69, 0x6D, 0x7E, 0x99, 0x9B, 0x8A,
	0x7D, 0x78, 0x7D, 0x74, 0x73, 0x75, 0x88, 0x8E, 0x8B, 0x81, 0x7E, 0x7E,
	0x7C, 0x7A, 0x78, 0x80, 0x84, 0x88, 0x83, 0x80, 0x7E, 0x7E, 0x7D, 0x7B,
	0x7E, 0x80, 0x84, 0x82, 0x82, 0x7E, 0x7F, 0x7E, 0x7E, 0x7D, 0x80, 0x80,
	0x83, 0x80, 0x81, 0x7D, 0x84, 0xC8, 0xEA, 0xD1, 0x7A, 0x55, 0x65, 0x7C,
	0x77, 0x67, 0x85, 0xA5, 0xB9, 0x8F, 0x6F, 0x5E, 0x73, 0x7C, 0x79, 0x78,
	0x86, 0x9C, 0x95, 0x84, 0x6B, 0x71, 0x77, 0x81, 0x7C, 0x7F, 0x87, 0x8E,
	0x8B, 0x7C, 0x77, 0x77, 0x7F, 0x7F, 0x7F, 0x80, 0x85, 0x87, 0x82, 0x7D,
	0x79, 0x7C, 0x7F, 0x81, 0x7F, 0x81, 0x83, 0x83, 0x80, 0x7C, 0x7D, 0x7D,
	0x81, 0x7F, 0x81, 0x7F, 0x83, 0x7E, 0x83, 0x77, 0x8E, 0xCE, 0xED, 0xC6,
	0x6C, 0x4F, 0x5F, 0x83, 0x7A, 0x73, 0x83, 0xAA, 0xB4, 0x90, 0x68, 0x58,
	0x71, 0x7F, 0x84, 0x7B, 0x88, 0x94, 0x97, 0x82, 0x6C, 0x6A, 0x77, 0x85,
	0x82, 0x7B, 0x78, 0x83, 0x88, 0x84, 0x77, 0x75, 0x7C, 0x85, 0x84, 0x7E,
	0x7D, 0x80, 0x85, 0x81, 0x7B, 0x7A, 0x7E, 0x83, 0x82, 0x80, 0x7E, 0x80,
	0x82, 0x80, 0x7E, 0x7C, 0x80, 0x80, 0x83, 0x78, 0x76, 0x75, 0x81, 0x85,
	0x82, 0xB2, 0xE4, 0xE7, 0x98, 0x4E, 0x40, 0x6B, 0x8C, 0x87, 0x82, 0x91,
	0xAF, 0xA7, 0x81, 0x57, 0x59, 0x73, 0x8B, 0x8B, 0x85, 0x89, 0x92, 0x8F,
	0x7A, 0x6B, 0x6B, 0x7E, 0x88, 0x8A, 0x83, 0x83, 0x85, 0x84, 0x7B, 0x74,
	0x76, 0x7F, 0x87, 0x86, 0x83, 0x80, 0x81, 0x80, 0x7D, 0x7A, 0x7B, 0x80,
	0x84, 0x83, 0x81, 0x7E, 0x7F, 0x7F, 0x7E, 0x83, 0x8A, 0x8A, 0x84, 0x7A,
	0x7A, 0x7C, 0x83, 0x7F, 0x82, 0x7D, 0x90, 0xCE, 0xEF, 0xD1, 0x71, 0x3C,
	0x45, 0x80, 0x97, 0x91, 0x87, 0x99, 0xAD, 0x9D, 0x74, 0x52, 0x5D, 0x7B,
	0x96, 0x8D, 0x85, 0x82, 0x8F, 0x8A, 0x7B, 0x68, 0x6C, 0x7E, 0x8D, 0x8D,
	0x83, 0x81, 0x81, 0x83, 0x7A, 0x76, 0x75, 0x81, 0x87, 0x88, 0x82, 0x7E,
	0x7E, 0x7F, 0x7E, 0x7A, 0x7D, 0x80, 0x85, 0x86, 0x85, 0x81, 0x7E, 0x7C,
	0x7C, 0x7E, 0x80, 0x81, 0x82, 0x83, 0x81, 0x80, 0x7C, 0x7F, 0x7C, 0x83,
	0x7A, 0x9B, 0xD4, 0xEB, 0xB8, 0x5C, 0x36, 0x51, 0x8E, 0x9C, 0x93, 0x86,
	0x9C, 0xA9, 0x98, 0x6B, 0x53, 0x62, 0x84, 0x98, 0x90, 0x88, 0x86, 0x8D,
	0x83, 0x74, 0x67, 0x73, 0x84, 0x91, 0x8C, 0x83, 0x80, 0x81, 0x7F, 0x78,
	0x75, 0x7A, 0x85, 0x89, 0x88, 0x80, 0x7F, 0x7A, 0x7B, 0x77, 0x7C, 0x81,
	0x86, 0x86, 0x81, 0x7F, 0x7C, 0x7D, 0x7C, 0x7E, 0x7E, 0x82, 0x82, 0x84,
	0x7F, 0x7F, 0x7C, 0x7F, 0x7D, 0x81, 0x7E, 0x83, 0x7E, 0x8B, 0xC3, 0xDD,
	0xC2, 0x6D, 0x46, 0x52, 0x87, 0x96, 0x8F, 0x87, 0x98, 0xA6, 0x92, 0x6F,
	0x57, 0x6A, 0x83, 0x96, 0x8B, 0x87, 0x85, 0x8C, 0x81, 0x73, 0x6A, 0x76,
	0x86, 0x8D, 0x89, 0x81, 0x81, 0x80, 0x7F, 0x77, 0x7B, 0x7E, 0x88, 0x85,
	0x84, 0x7E, 0x7F, 0x7E, 0x7E, 0x7C, 0x7D, 0x81, 0x83, 0x84, 0x7F, 0x7F,
	0x7D, 0x7F, 0x7E, 0x7F, 0x7F, 0x81, 0x82, 0x81, 0x80, 0x7D, 0x7F, 0x7E,
	0x80, 0x83, 0x87, 0x85, 0x7F, 0x7D, 0x79, 0xAB, 0xD2, 0xCB, 0x86, 0x4D,
	0x52, 0x79, 0x97, 0x89, 0x87, 0x8D, 0xA5, 0x96, 0x78, 0x5C, 0x67, 0x81,
	0x90, 0x8D, 0x82, 0x88, 0x89, 0x87, 0x72, 0x6E, 0x72, 0x86, 0x8B, 0x89,
	0x81, 0x80, 0x82, 0x7D, 0x7A, 0x75, 0x7F, 0x84, 0x89, 0x83, 0x80, 0x7E,
	0x7E, 0x7E, 0x7B, 0x7D, 0x80, 0x85, 0x83, 0x81, 0x7D, 0x7E, 0x7E, 0x7F,
	0x7E, 0x81, 0x83, 0x84, 0x80, 0x7E, 0x7D, 0x7F, 0x80, 0x7F, 0x80, 0x81,
	0x82, 0x80, 0x7F, 0x7D, 0x7F, 0x80, 0xB1, 0xCE, 0xBE, 0x78, 0x4B, 0x59,
	0x7F, 0x96, 0x87, 0x89, 0x92, 0xA3, 0x8C, 0x6C, 0x59, 0x6D, 0x89, 0x91,
	0x8B, 0x84, 0x8A, 0x87, 0x7D, 0x6D, 0x6F, 0x7D, 0x8B, 0x8B, 0x84, 0x81,
	0x81, 0x80, 0x79, 0x76, 0x7B, 0x83, 0x88, 0x85, 0x80, 0x7E, 0x7F, 0x7E,
	0x7B, 0x80, 0x84, 0x87, 0x82, 0x7E, 0x7D, 0x7F, 0x80, 0x7E, 0x7F, 0x80,
	0x84, 0x81, 0x80, 0x7D, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x82, 0x80, 0x81,
	0x7D, 0x7F, 0x7E, 0x81, 0x7D, 0x8D, 0xBF, 0xCA, 0xA4, 0x5E, 0x4F, 0x6B,
	0x8D, 0x8E, 0x85, 0x91, 0x9E, 0x99, 0x73, 0x62, 0x68, 0x84, 0x8C, 0x88,
	0x85, 0x8B, 0x8D, 0x7C, 0x70, 0x6E, 0x7F, 0x87, 0x88, 0x82, 0x83, 0x84,
	0x80, 0x79, 0x74, 0x7B, 0x83, 0x87, 0x83, 0x81, 0x81, 0x80, 0x7C, 0x7A,
	0x7C, 0x81, 0x84, 0x82, 0x80, 0x7F, 0x80, 0x7E, 0x7D, 0x7E, 0x80, 0x83,
	0x81, 0x81, 0x7E, 0x80, 0x7E, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x81, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0xA2, 0xB7, 0xA7, 0x7E, 0x65, 0x71,
	0x7A, 0x7E, 0x7B, 0x8E, 0x9C, 0x95, 0x7E, 0x6E, 0x75, 0x7B, 0x7E, 0x7C,
	0x86, 0x91, 0x8E, 0x81, 0x75, 0x79, 0x7C, 0x7C, 0x7B, 0x82, 0x8A, 0x88,
	0x81, 0x7A, 0x7D, 0x7D, 0x7C, 0x7C, 0x81, 0x86, 0x85, 0x80, 0x7D, 0x7E,
	0x7E, 0x7D, 0x7D, 0x80, 0x83, 0x83, 0x7F, 0x80, 0x80, 0x76, 0x76, 0x7F,
	0x89, 0x87, 0x7B, 0x7B, 0x81, 0x86, 0x84, 0x83, 0x86, 0x85, 0x82, 0x82,
	0x83, 0x83, 0x82, 0x80, 0x87, 0x94, 0x90, 0x87, 0x8B, 0x94, 0x9E, 0x93,
	0x87, 0x7C, 0x75, 0x75, 0x75, 0x7B, 0x74, 0x78, 0x81, 0x87, 0x83, 0x7B,
	0x80, 0x79, 0x74, 0x73, 0x7F, 0x81, 0x7E, 0x83, 0x80, 0x7F, 0x7C, 0x82,
	0x80, 0x7A, 0x74, 0x7B, 0x86, 0x87, 0x8A, 0x8B, 0x8D, 0x88, 0x82, 0x7A,
	0x79, 0x7A, 0x7A, 0x79, 0x7C, 0x85, 0x86, 0x84, 0x85, 0x89, 0x8A, 0x89,
	0x87, 0x82, 0x80, 0x7E, 0x7C, 0x80, 0x84, 0x8B, 0x8C, 0x88, 0x7C, 0x7D,
	0x82, 0x7C, 0x7B, 0x7F, 0x8C, 0x8B, 0x82, 0x7F, 0x7F, 0x7C, 0x72, 0x78,
	0x83, 0x88, 0x84, 0x7F, 0x82, 0x7D, 0x75, 0x72, 0x78, 0x7A, 0x7B, 0x82,
	0x89, 0x89, 0x7A, 0x74, 0x74, 0x79, 0x73, 0x70, 0x7A, 0x81, 0x82, 0x7A,
	0x7D, 0x80, 0x7F, 0x77, 0x77, 0x82, 0x80, 0x7C, 0x7E, 0x88, 0x86, 0x7D,
	0x7A, 0x7F, 0x81, 0x7D, 0x80, 0x86, 0x86, 0x82, 0x81, 0x84, 0x82, 0x7C,
	0x7A, 0x7D, 0x81, 0x81, 0x81, 0x83, 0x84, 0x81, 0x7C, 0x7A, 0x7B, 0x7B,
	0x79, 0x78, 0x79, 0x7C, 0x7C, 0x7C, 0x7D, 0x80, 0x7E, 0x7C, 0x7D, 0x80,
	0x7E, 0x7C, 0x7F, 0x80, 0x7F, 0x7F, 0x82, 0x82, 0x7E, 0x7D, 0x7F, 0x7F,
	0x7D, 0x7D, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x82, 0x82,
	0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVoff[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x81, 0x83, 0x84, 0x82, 0x80, 0x7D, 0x7D, 0x7F, 0x81, 0x82,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x87, 0x8E, 0x93,
	0x8D, 0x80, 0x74, 0x70, 0x77, 0x82, 0x8A, 0x89, 0x84, 0x7E, 0x7D, 0x7D,
	0x7E, 0x7D, 0x7C, 0x7D, 0x81, 0x85, 0x86, 0x83, 0x7D, 0x79, 0x7A, 0x7E,
	0x83, 0x83, 0x82, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7D, 0x7F, 0x81,
	0x82, 0x81, 0x7E, 0x7D, 0x7C, 0x80, 0x81, 0x82, 0x80, 0x7F, 0x7E, 0x7F,
	0x80, 0x80, 0x80, 0x7E, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x7E, 0x7F, 0x7E,
	0x81, 0x80, 0x82, 0x7D, 0x86, 0x98, 0xAB, 0xAD, 0x93, 0x70, 0x52, 0x58,
	0x70, 0x94, 0xA1, 0x9A, 0x84, 0x74, 0x73, 0x79, 0x7F, 0x7C, 0x7A, 0x79,
	0x85, 0x8D, 0x91, 0x85, 0x76, 0x6C, 0x71, 0x7F, 0x8B, 0x8E, 0x85, 0x7D,
	0x77, 0x7D, 0x81, 0x84, 0x7F, 0x7B, 0x7A, 0x80, 0x87, 0x87, 0x83, 0x79,
	0x78, 0x79, 0x82, 0x85, 0x86, 0x80, 0x7C, 0x7B, 0x7E, 0x82, 0x82, 0x80,
	0x7C, 0x7C, 0x80, 0x83, 0x84, 0x80, 0x7B, 0x77, 0x78, 0x7E, 0x84, 0x88,
	0x82, 0x99, 0xB2, 0xCE, 0xBB, 0x88, 0x49, 0x2C, 0x46, 0x7E, 0xB7, 0xBD,
	0xA5, 0x75, 0x63, 0x62, 0x79, 0x82, 0x82, 0x79, 0x7B, 0x8A, 0x97, 0x98,
	0x7F, 0x68, 0x59, 0x6C, 0x85, 0x9F, 0x9C, 0x89, 0x72, 0x6A, 0x74, 0x82,
	0x8B, 0x84, 0x7C, 0x78, 0x81, 0x88, 0x8C, 0x81, 0x75, 0x70, 0x76, 0x85,
	0x8E, 0x8D, 0x80, 0x76, 0x74, 0x7C, 0x87, 0x8A, 0x88, 0x7D, 0x79, 0x79,
	0x81, 0x83, 0x84, 0x7E, 0x7B, 0x7C, 0x81, 0x86, 0x83, 0x82, 0x75, 0x94,
	0xBB, 0xE7, 0xD8, 0x99, 0x45, 0x15, 0x2F, 0x72, 0xBE, 0xCD, 0xB5, 0x79,
	0x60, 0x5E, 0x79, 0x84, 0x80, 0x73, 0x72, 0x88, 0x9D, 0xA5, 0x89, 0x6A,
	0x50, 0x61, 0x7F, 0xA1, 0xA3, 0x8F, 0x73, 0x67, 0x72, 0x82, 0x8D, 0x84,
	0x7B, 0x73, 0x7F, 0x8A, 0x92, 0x85, 0x74, 0x68, 0x6E, 0x81, 0x90, 0x94,
	0x86, 0x78, 0x70, 0x78, 0x81, 0x89, 0x83, 0x7D, 0x78, 0x7E, 0x84, 0x89,
	0x84, 0x7B, 0x75, 0x77, 0x81, 0x88, 0x89, 0x80, 0x7C, 0x74, 0x9E, 0xCC,
	0xEF, 0xD1, 0x83, 0x31, 0x15, 0x43, 0x8F, 0xCC, 0xC6, 0xA0, 0x6B, 0x61,
	0x6A, 0x81, 0x80, 0x74, 0x6C, 0x7B, 0x99, 0xA8, 0x9E, 0x76, 0x59, 0x52,
	0x72, 0x92, 0xA5, 0x96, 0x7E, 0x6C, 0x6C, 0x77, 0x7E, 0x7F, 0x79, 0x7E,
	0x84, 0x91, 0x8D, 0x82, 0x70, 0x6A, 0x73, 0x83, 0x90, 0x8D, 0x84, 0x77,
	0x78, 0x7B, 0x84, 0x81, 0x7F, 0x79, 0x7D, 0x83, 0x89, 0x86, 0x7E, 0x77,
	0x75, 0x7C, 0x82, 0x87, 0x83, 0x7F, 0x7C, 0x7E, 0x80, 0xA5, 0xC7, 0xDD,
	0xB7, 0x74, 0x37, 0x2F, 0x60, 0x9B, 0xC1, 0xB0, 0x8F, 0x6C, 0x6F, 0x77,
	0x82, 0x77, 0x6E, 0x71, 0x88, 0xA1, 0xA2, 0x8D, 0x6B, 0x5E, 0x66, 0x82,
	0x93, 0x94, 0x84, 0x79, 0x79, 0x82, 0x86, 0x7F, 0x75, 0x71, 0x7C, 0x8A,
	0x92, 0x89, 0x7B, 0x70, 0x74, 0x7F, 0x88, 0x88, 0x7F, 0x7B, 0x7B, 0x83,
	0x86, 0x85, 0x7D, 0x78, 0x7A, 0x81, 0x86, 0x85, 0x7F, 0x7B, 0x7A, 0x80,
	0x83, 0x84, 0x7E, 0x7D, 0x7C, 0x82, 0x82, 0x85, 0xA6, 0xC4, 0xD4, 0xA7,
	0x6A, 0x33, 0x3E, 0x70, 0xAB, 0xBD, 0xA4, 0x82, 0x6C, 0x77, 0x7D, 0x81,
	0x6D, 0x6E, 0x78, 0x98, 0xA3, 0x98, 0x78, 0x61, 0x63, 0x77, 0x90, 0x91,
	0x89, 0x79, 0x7C, 0x80, 0x89, 0x80, 0x76, 0x70, 0x79, 0x89, 0x90, 0x8C,
	0x7C, 0x75, 0x75, 0x80, 0x85, 0x85, 0x7D, 0x7C, 0x7E, 0x85, 0x86, 0x81,
	0x7A, 0x77, 0x7D, 0x83, 0x87, 0x83, 0x7E, 0x7A, 0x7E, 0x81, 0x83, 0x80,
	0x7D, 0x7C, 0x80, 0x82, 0x85, 0x7C, 0x8E, 0xB1, 0xCC, 0xBC, 0x7F, 0x48,
	0x38, 0x67, 0x9B, 0xBB, 0xA6, 0x85, 0x6F, 0x76, 0x83, 0x82, 0x75, 0x69,
	0x77, 0x8F, 0xA3, 0x98, 0x7E, 0x64, 0x65, 0x79, 0x8C, 0x90, 0x84, 0x7B,
	0x7E, 0x8A, 0x8E, 0x82, 0x71, 0x6B, 0x77, 0x8A, 0x94, 0x8C, 0x7D, 0x73,
	0x78, 0x81, 0x86, 0x81, 0x7C, 0x7A, 0x82, 0x88, 0x87, 0x7F, 0x77, 0x77,
	0x7E, 0x86, 0x86, 0x82, 0x7B, 0x7C, 0x80, 0x86, 0x83, 0x80, 0x79, 0x7D,
	0x7F, 0x86, 0x81, 0x85, 0xA4, 0xBF, 0xC4, 0x90, 0x58, 0x39, 0x5A, 0x90,
	0xB7, 0xAE, 0x8B, 0x72, 0x71, 0x82, 0x82, 0x7A, 0x6B, 0x77, 0x8B, 0xA0,
	0x99, 0x83, 0x6B, 0x68, 0x77, 0x86, 0x8D, 0x85, 0x81, 0x7E, 0x85, 0x83,
	0x7F, 0x75, 0x76, 0x7D, 0x89, 0x8C, 0x85, 0x7D, 0x77, 0x7B, 0x7F, 0x83,
	0x7F, 0x7F, 0x7E, 0x83, 0x83, 0x82, 0x7C, 0x79, 0x7B, 0x80, 0x84, 0x84,
	0x81, 0x7D, 0x7E, 0x7E, 0x80, 0x7F, 0x7F, 0x7E, 0x82, 0x80, 0x83, 0x7C,
	0x8D, 0xA9, 0xBD, 0xAB, 0x75, 0x4F, 0x4D, 0x7C, 0xA1, 0xAF, 0x95, 0x7E,
	0x74, 0x7E, 0x84, 0x7C, 0x74, 0x73, 0x87, 0x94, 0x97, 0x84, 0x75, 0x6F,
	0x79, 0x83, 0x86, 0x83, 0x7F, 0x82, 0x85, 0x85, 0x7E, 0x78, 0x77, 0x7E,
	0x85, 0x87, 0x83, 0x7E, 0x7D, 0x7E, 0x7E, 0x7C, 0x7A, 0x7C, 0x81, 0x85,
	0x84, 0x80, 0x7C, 0x7C, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x81, 0x81,
	0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x97, 0xAD, 0xB8, 0x9D,
	0x76, 0x5B, 0x62, 0x81, 0x95, 0x99, 0x88, 0x80, 0x7D, 0x86, 0x85, 0x7E,
	0x78, 0x7A, 0x84, 0x89, 0x89, 0x7F, 0x7B, 0x7B, 0x82, 0x84, 0x82, 0x7D,
	0x7C, 0x80, 0x83, 0x83, 0x7F, 0x7D, 0x7D, 0x7F, 0x80, 0x80, 0x7E, 0x7E,
	0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x8C, 0x9C, 0xA9, 0xA4, 0x90, 0x7E, 0x76, 0x7F, 0x87,
	0x8C, 0x87, 0x83, 0x81, 0x83, 0x83, 0x7F, 0x7D, 0x7C, 0x82, 0x85, 0x84,
	0x80, 0x7C, 0x7D, 0x7F, 0x82, 0x81, 0x7E, 0x7C, 0x7C, 0x7E, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x84, 0x8F, 0x98,
	0x9B, 0x95, 0x8D, 0x86, 0x86, 0x88, 0x89, 0x89, 0x87, 0x88, 0x86, 0x85,
	0x80, 0x7C, 0x7C, 0x7D, 0x80, 0x80, 0x7F, 0x7C, 0x7B, 0x7B, 0x7B, 0x7B,
	0x7A, 0x7B, 0x7C, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x82, 0x85, 0x87, 0x88, 0x87, 0x87, 0x86, 0x86, 0x86,
	0x86, 0x86, 0x86, 0x86, 0x85, 0x85, 0x84, 0x84, 0x84, 0x83, 0x82, 0x82,
	0x81, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81,
	0x81, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82,
	0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7E,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7E,
	0x7F, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x7F,
	0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80
};
const unsigned char WAVok[] = {
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81,
	0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7C, 0x7A, 0x7B, 0x7E, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7D, 0x7A, 0x7A, 0x7C, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7D,
	0x7E, 0x7F, 0x80, 0x82, 0x81, 0x82, 0x83, 0x84, 0x83, 0x7F, 0x7D, 0x7C,
	0x7E, 0x80, 0x81, 0x8C, 0x96, 0x97, 0x8E, 0x7C, 0x73, 0x74, 0x79, 0x7E,
	0x7D, 0x7F, 0x85, 0x8A, 0x8B, 0x84, 0x7B, 0x78, 0x79, 0x7D, 0x7F, 0x7E,
	0x7F, 0x81, 0x84, 0x84, 0x80, 0x7D, 0x7B, 0x7D, 0x80, 0x7F, 0x7F, 0x7F,
	0x81, 0x82, 0x82, 0x80, 0x7E, 0x7D, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81,
	0x7E, 0x89, 0xA1, 0xAA, 0xA4, 0x88, 0x70, 0x6C, 0x71, 0x7A, 0x7A, 0x77,
	0x80, 0x8B, 0x96, 0x92, 0x82, 0x77, 0x73, 0x78, 0x7E, 0x7B, 0x7A, 0x7D,
	0x85, 0x8C, 0x88, 0x80, 0x79, 0x78, 0x7D, 0x80, 0x7E, 0x7C, 0x7D, 0x82,
	0x86, 0x86, 0x81, 0x7C, 0x7C, 0x7E, 0x80, 0x7F, 0x7D, 0x7E, 0x80, 0x83,
	0x84, 0x80, 0x7E, 0x7D, 0x7F, 0x80, 0x80, 0x7D, 0x7D, 0x7D, 0x85, 0xA6,
	0xBB, 0xBB, 0xA2, 0x7A, 0x69, 0x67, 0x6D, 0x72, 0x6D, 0x74, 0x86, 0x98,
	0xA2, 0x94, 0x80, 0x75, 0x72, 0x79, 0x78, 0x74, 0x75, 0x7C, 0x8B, 0x92,
	0x8D, 0x84, 0x7C, 0x7C, 0x80, 0x7D, 0x79, 0x75, 0x79, 0x83, 0x88, 0x88,
	0x82, 0x7D, 0x7F, 0x80, 0x81, 0x7D, 0x79, 0x7A, 0x7F, 0x84, 0x85, 0x81,
	0x7E, 0x7F, 0x80, 0x83, 0x7E, 0x7D, 0x79, 0x8F, 0xBB, 0xCE, 0xCA, 0xA0,
	0x74, 0x66, 0x64, 0x6C, 0x69, 0x5F, 0x6A, 0x81, 0x9F, 0xAC, 0x9B, 0x84,
	0x74, 0x75, 0x7D, 0x79, 0x6F, 0x69, 0x72, 0x88, 0x96, 0x94, 0x87, 0x7A,
	0x7B, 0x82, 0x84, 0x7D, 0x71, 0x6F, 0x7A, 0x88, 0x8E, 0x87, 0x7E, 0x7B,
	0x80, 0x86, 0x84, 0x7B, 0x74, 0x75, 0x80, 0x88, 0x87, 0x80, 0x7B, 0x7C,
	0x84, 0x86, 0x83, 0x9B, 0xB4, 0xC2, 0xBC, 0x95, 0x74, 0x62, 0x62, 0x6D,
	0x6B, 0x68, 0x6D, 0x7D, 0x98, 0xA4, 0x9C, 0x8A, 0x77, 0x75, 0x7B, 0x7C,
	0x76, 0x6D, 0x6F, 0x7E, 0x8E, 0x95, 0x8D, 0x7F, 0x7A, 0x7D, 0x84, 0x82,
	0x78, 0x71, 0x72, 0x7E, 0x8A, 0x8C, 0x85, 0x7C, 0x7C, 0x82, 0x87, 0x84,
	0x7B, 0x74, 0x77, 0x7F, 0x87, 0x86, 0x80, 0x7B, 0x7D, 0xA1, 0xBF, 0xC7,
	0xB7, 0x8E, 0x76, 0x70, 0x70, 0x72, 0x63, 0x5C, 0x68, 0x80, 0x9E, 0xA6,
	0x98, 0x86, 0x79, 0x7E, 0x85, 0x7E, 0x72, 0x65, 0x6A, 0x7E, 0x8F, 0x94,
	0x89, 0x7D, 0x7C, 0x84, 0x8B, 0x86, 0x77, 0x6E, 0x70, 0x7E, 0x8B, 0x8A,
	0x81, 0x79, 0x7B, 0x85, 0x8A, 0x86, 0x7A, 0x72, 0x76, 0x81, 0x88, 0x87,
	0x7D, 0x7B, 0x9C, 0xBD, 0xCE, 0xC1, 0x97, 0x79, 0x6E, 0x71, 0x76, 0x67,
	0x58, 0x5A, 0x6F, 0x92, 0xA3, 0x9C, 0x8A, 0x7A, 0x7C, 0x84, 0x83, 0x76,
	0x65, 0x62, 0x73, 0x87, 0x94, 0x8E, 0x80, 0x7D, 0x83, 0x8D, 0x8D, 0x7E,
	0x70, 0x6C, 0x76, 0x85, 0x89, 0x83, 0x79, 0x78, 0x83, 0x8C, 0x8C, 0x81,
	0x75, 0x73, 0x7B, 0x84, 0x85, 0x7D, 0x8E, 0xAB, 0xC3, 0xCD, 0xB5, 0x95,
	0x80, 0x76, 0x79, 0x71, 0x61, 0x58, 0x5B, 0x74, 0x8E, 0x98, 0x94, 0x88,
	0x84, 0x8B, 0x8F, 0x89, 0x78, 0x68, 0x68, 0x75, 0x85, 0x8B, 0x84, 0x7E,
	0x80, 0x8A, 0x92, 0x8E, 0x81, 0x74, 0x72, 0x7A, 0x82, 0x82, 0x7B, 0x75,
	0x79, 0x84, 0x8C, 0x8B, 0x81, 0x7A, 0x7A, 0x81, 0x85, 0x8F, 0xA2, 0xB0,
	0xBB, 0xB6, 0xA4, 0x94, 0x84, 0x7B, 0x75, 0x69, 0x63, 0x62, 0x69, 0x79,
	0x85, 0x8B, 0x8D, 0x8B, 0x8E, 0x8F, 0x8C, 0x85, 0x7A, 0x73, 0x73, 0x76,
	0x7A, 0x7B, 0x7A, 0x7C, 0x81, 0x87, 0x8B, 0x88, 0x85, 0x81, 0x81, 0x82,
	0x81, 0x7E, 0x7A, 0x78, 0x7B, 0x7F, 0x81, 0x81, 0x7F, 0x7F, 0x82, 0x83,
	0x8D, 0xA0, 0xAD, 0xB4, 0xAF, 0xA2, 0x9A, 0x91, 0x8A, 0x81, 0x72, 0x69,
	0x67, 0x6C, 0x78, 0x7F, 0x82, 0x84, 0x87, 0x8E, 0x93, 0x92, 0x8B, 0x82,
	0x7C, 0x7C, 0x7B, 0x7A, 0x77, 0x74, 0x76, 0x7B, 0x81, 0x85, 0x84, 0x83,
	0x83, 0x84, 0x86, 0x85, 0x81, 0x7C, 0x7A, 0x7C, 0x80, 0x82, 0x81, 0x7F,
	0x7F, 0x82, 0x84, 0x8B, 0x97, 0xA0, 0xA6, 0xA5, 0x9F, 0x9B, 0x95, 0x90,
	0x89, 0x7F, 0x77, 0x72, 0x72, 0x76, 0x79, 0x7B, 0x7D, 0x80, 0x85, 0x8A,
	0x8C, 0x8B, 0x87, 0x84, 0x83, 0x81, 0x80, 0x7D, 0x79, 0x77, 0x78, 0x7A,
	0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x83, 0x85, 0x84, 0x83, 0x81, 0x81, 0x81,
	0x80, 0x7F, 0x7E, 0x7C, 0x7C, 0x7D, 0x82, 0x8D, 0x97, 0x9F, 0xA2, 0x9F,
	0x9E, 0x9D, 0x9C, 0x9A, 0x93, 0x8A, 0x82, 0x7D, 0x7C, 0x7B, 0x79, 0x77,
	0x76, 0x78, 0x7D, 0x82, 0x85, 0x86, 0x86, 0x87, 0x89, 0x8A, 0x8A, 0x87,
	0x84, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x7B, 0x7A, 0x7A, 0x7C, 0x7D, 0x7D,
	0x7D, 0x7D, 0x7E, 0x80, 0x81, 0x82, 0x81, 0x81, 0x81, 0x83, 0x87, 0x8C,
	0x8E, 0x8E, 0x8D, 0x8C, 0x8D, 0x8E, 0x8D, 0x8B, 0x87, 0x85, 0x83, 0x83,
	0x82, 0x80, 0x7E, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7C, 0x7C, 0x7C, 0x7E,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x81, 0x83, 0x83, 0x83, 0x84, 0x84, 0x85, 0x86, 0x85, 0x85,
	0x85, 0x85, 0x85, 0x85, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x81, 0x80, 0x7F, 0x81,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x81, 0x7F, 0x7F, 0x83, 0x7F, 0x7D,
	0x84, 0x7F, 0x81, 0x84, 0x7B, 0x81, 0x7E, 0x7E, 0x82, 0x7E, 0x80, 0x7F,
	0x80, 0x80, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7C, 0x80, 0x80, 0x7B,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x82, 0x7D, 0x81, 0x81, 0x7D, 0x7F, 0x7C,
	0x7E, 0x7E, 0x80, 0x80, 0x7E, 0x84, 0x7C, 0x81, 0x84, 0x7F, 0x85, 0x7D,
	0x7F, 0x7F, 0x7C, 0x82, 0x7B, 0x7E, 0x81, 0x7B, 0x84, 0x81, 0x80, 0x83,
	0x81, 0x82, 0x7F, 0x7F, 0x7F, 0x7D, 0x80, 0x7D, 0x7C, 0x81, 0x81, 0x80,
	0x82, 0x80, 0x7F, 0x83, 0x7F, 0x80, 0x80, 0x7E, 0x7D, 0x7E, 0x7E, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x7F,
	0x80, 0x7E, 0x7F, 0x7E, 0x7E, 0x83, 0x7E, 0x82, 0x7F, 0x80, 0x81, 0x7F,
	0x82, 0x7F, 0x80, 0x7D, 0x80, 0x7D, 0x80, 0x7F, 0x81, 0x81, 0x80, 0x81,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x7E, 0x7F, 0x7E, 0x7E, 0x80,
	0x7D, 0x82, 0x7E, 0x80, 0x7F, 0x7F, 0x81, 0x7F, 0x82, 0x7E, 0x81, 0x80,
	0x81, 0x80, 0x80, 0x80, 0x7E, 0x81, 0x7F, 0x82, 0x7F, 0x82, 0x80, 0x80,
	0x82, 0x7F, 0x82, 0x81, 0x7F, 0x80, 0x7D, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F,
	0x81, 0x7F, 0x82, 0x7E, 0x82, 0x7F, 0x81, 0x82, 0x81, 0x81, 0x80, 0x80,
	0x7E, 0x7F, 0x7D, 0x80, 0x7E, 0x80, 0x7E, 0x7F, 0x80, 0x7F, 0x81, 0x81,
	0x81, 0x7F, 0x81, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7E, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x7D, 0x80, 0x7E,
	0x7F, 0x80, 0x81, 0x80, 0x82, 0x82, 0x81, 0x82, 0x80, 0x7F, 0x7F, 0x7F,
	0x7E, 0x81, 0x7F, 0x80, 0x7F, 0x81, 0x7F, 0x80, 0x81, 0x7F, 0x81, 0x7F,
	0x80, 0x80, 0x7F, 0x81, 0x82, 0x80, 0x82, 0x82, 0x7F, 0x81, 0x80, 0x7F,
	0x82, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x81, 0x80, 0x7E, 0x82, 0x7E, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7D, 0x80, 0x7E, 0x7F, 0x82,
	0x81, 0x84, 0x86, 0x85, 0x86, 0x85, 0x84, 0x83, 0x80, 0x80, 0x7D, 0x7D,
	0x7E, 0x7C, 0x7E, 0x80, 0x81, 0x83, 0x85, 0x84, 0x85, 0x85, 0x84, 0x81,
	0x81, 0x7F, 0x7D, 0x7E, 0x7D, 0x7D, 0x7F, 0x7E, 0x81, 0x89, 0x88, 0x90,
	0x93, 0x91, 0x96, 0x92, 0x8F, 0x8C, 0x87, 0x81, 0x81, 0x7D, 0x7B, 0x7D,
	0x7B, 0x7D, 0x80, 0x80, 0x81, 0x82, 0x81, 0x82, 0x82, 0x80, 0x81, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x8E,
	0x91, 0x97, 0xA6, 0xA0, 0xA4, 0xA0, 0x96, 0x8D, 0x86, 0x7B, 0x73, 0x75,
	0x6F, 0x74, 0x7A, 0x7B, 0x81, 0x85, 0x85, 0x84, 0x84, 0x7F, 0x7C, 0x7C,
	0x78, 0x7A, 0x7C, 0x7D, 0x80, 0x83, 0x84, 0x84, 0x85, 0x82, 0x81, 0x7F,
	0x7D, 0x7D, 0x7C, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x81, 0x81,
	0x7F, 0x7D, 0x7C, 0x7C, 0x7A, 0x7C, 0x7D, 0x7E, 0x7F, 0x82, 0x80, 0x82,
	0x81, 0x85, 0xA0, 0x99, 0xA9, 0xB5, 0xA6, 0xA6, 0x9B, 0x89, 0x79, 0x76,
	0x69, 0x66, 0x72, 0x6F, 0x7A, 0x84, 0x84, 0x88, 0x89, 0x85, 0x7D, 0x7E,
	0x79, 0x76, 0x7C, 0x7C, 0x7F, 0x85, 0x87, 0x85, 0x86, 0x84, 0x7F, 0x7E,
	0x7C, 0x79, 0x7B, 0x7D, 0x7E, 0x80, 0x84, 0x82, 0x82, 0x83, 0x80, 0x7E,
	0x7F, 0x7C, 0x7B, 0x7F, 0x7D, 0x7E, 0x82, 0x81, 0x80, 0x82, 0x80, 0x7F,
	0x7F, 0x80, 0x7C, 0x81, 0x7C, 0xA2, 0xAC, 0xA1, 0xC3, 0xAF, 0x9C, 0x94,
	0x81, 0x68, 0x62, 0x6C, 0x5E, 0x72, 0x82, 0x7F, 0x8D, 0x8E, 0x88, 0x7D,
	0x7F, 0x75, 0x6D, 0x7B, 0x77, 0x7F, 0x88, 0x8A, 0x8A, 0x89, 0x87, 0x7C,
	0x7D, 0x79, 0x74, 0x7B, 0x7C, 0x80, 0x83, 0x86, 0x85, 0x82, 0x83, 0x7C,
	0x7D, 0x7B, 0x7B, 0x7E, 0x7F, 0x83, 0x83, 0x84, 0x82, 0x80, 0x80, 0x7D,
	0x7D, 0x7D, 0x7D, 0x80, 0x7F, 0x83, 0x80, 0x84, 0x7D, 0x9D, 0xB1, 0x99,
	0xBD, 0xB0, 0x93, 0x8F, 0x80, 0x6A, 0x5D, 0x74, 0x67, 0x71, 0x8D, 0x83,
	0x8A, 0x8C, 0x84, 0x77, 0x78, 0x77, 0x6B, 0x7D, 0x80, 0x80, 0x8C, 0x8C,
	0x89, 0x84, 0x84, 0x79, 0x76, 0x7C, 0x76, 0x7D, 0x82, 0x83, 0x86, 0x85,
	0x86, 0x7C, 0x7B, 0x7C, 0x74, 0x7B, 0x7C, 0x7F, 0x82, 0x85, 0x86, 0x81,
	0x84, 0x7E, 0x7C, 0x7D, 0x7B, 0x7E, 0x7F, 0x82, 0x83, 0x81, 0x85, 0x7E,
	0x81, 0x7A, 0x8E, 0xB4, 0x99, 0xB3, 0xBB, 0x96, 0x90, 0x82, 0x6F, 0x5C,
	0x6D, 0x6E, 0x6B, 0x8B, 0x88, 0x87, 0x8C, 0x85, 0x79, 0x73, 0x7A, 0x6D,
	0x78, 0x85, 0x7F, 0x8C, 0x8C, 0x8A, 0x82, 0x81, 0x7C, 0x72, 0x7D, 0x78,
	0x7D, 0x7F, 0x7E, 0x84, 0x7B, 0x81, 0x7C, 0x7B, 0x7E, 0x7B, 0x82, 0x7F,
	0x84, 0x83, 0x82, 0x83, 0x7F, 0x80, 0x7D, 0x7D, 0x7F, 0x7D, 0x82, 0x7F,
	0x82, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x80, 0x7E, 0x93, 0xB9, 0x9E, 0xB3,
	0xBA, 0x8D, 0x87, 0x7A, 0x67, 0x5A, 0x6F, 0x73, 0x71, 0x91, 0x8C, 0x86,
	0x8C, 0x7F, 0x75, 0x70, 0x78, 0x70, 0x7B, 0x8A, 0x84, 0x8E, 0x8D, 0x85,
	0x80, 0x7B, 0x78, 0x72, 0x7A, 0x7D, 0x7D, 0x88, 0x86, 0x85, 0x85, 0x80,
	0x7B, 0x7A, 0x7B, 0x7A, 0x7E, 0x82, 0x82, 0x85, 0x83, 0x82, 0x7F, 0x7E,
	0x7C, 0x7B, 0x7E, 0x7E, 0x80, 0x82, 0x83, 0x7F, 0x7E, 0x7F, 0x79, 0x7B,
	0x7E, 0x7C, 0x82, 0x81, 0xAF, 0xAA, 0x9B, 0xC0, 0x99, 0x83, 0x81, 0x70,
	0x60, 0x66, 0x7D, 0x70, 0x84, 0x95, 0x82, 0x88, 0x84, 0x77, 0x70, 0x76,
	0x78, 0x75, 0x8B, 0x89, 0x88, 0x90, 0x86, 0x7E, 0x7C, 0x79, 0x75, 0x78,
	0x81, 0x7E, 0x85, 0x89, 0x83, 0x83, 0x7F, 0x7C, 0x78, 0x7C, 0x7D, 0x7C,
	0x84, 0x84, 0x82, 0x85, 0x81, 0x7E, 0x7C, 0x7F, 0x7E, 0x7E, 0x85, 0x82,
	0x82, 0x84, 0x80, 0x7F, 0x7D, 0x7F, 0x7B, 0x7E, 0x81, 0x7E, 0x82, 0x84,
	0xAF, 0x9E, 0x9C, 0xBA, 0x8C, 0x85, 0x81, 0x6E, 0x63, 0x6D, 0x7B, 0x70,
	0x89, 0x8E, 0x7E, 0x8A, 0x7F, 0x75, 0x75, 0x77, 0x76, 0x7A, 0x88, 0x84,
	0x88, 0x8D, 0x84, 0x80, 0x7E, 0x79, 0x77, 0x7C, 0x7E, 0x7E, 0x86, 0x85,
	0x83, 0x83, 0x80, 0x7D, 0x7B, 0x7D, 0x7B, 0x7E, 0x7F, 0x82, 0x80, 0x83,
	0x81, 0x7F, 0x80, 0x7E, 0x7D, 0x7E, 0x7F, 0x7E, 0x82, 0x81, 0x81, 0x80,
	0x81, 0x7E, 0x80, 0x7D, 0x7F, 0x7D, 0x81, 0x7D, 0x90, 0xAE, 0x8E, 0xAF,
	0xAC, 0x85, 0x92, 0x7D, 0x6A, 0x69, 0x71, 0x6B, 0x73, 0x8A, 0x7E, 0x88,
	0x8F, 0x7F, 0x7E, 0x7E, 0x76, 0x74, 0x7D, 0x7D, 0x7E, 0x8B, 0x86, 0x85,
	0x88, 0x80, 0x7D, 0x7C, 0x7B, 0x78, 0x7E, 0x80, 0x81, 0x86, 0x86, 0x84,
	0x83, 0x80, 0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7F, 0x81, 0x82, 0x82, 0x82,
	0x80, 0x80, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x80, 0x80, 0x82, 0x80, 0x81,
	0x80, 0x7E, 0x7D, 0x7F, 0x79, 0x8C, 0xA1, 0x8B, 0xAD, 0xA8, 0x8B, 0x9B,
	0x82, 0x6F, 0x70, 0x6D, 0x65, 0x71, 0x7F, 0x78, 0x88, 0x8D, 0x80, 0x89,
	0x82, 0x78, 0x7B, 0x7A, 0x78, 0x7D, 0x83, 0x80, 0x86, 0x89, 0x81, 0x85,
	0x80, 0x7A, 0x7D, 0x7A, 0x7A, 0x7E, 0x80, 0x80, 0x83, 0x83, 0x81, 0x82,
	0x7F, 0x7E, 0x7F, 0x7C, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x82, 0x81, 0x81,
	0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x81, 0x9C, 0x8E, 0x9A, 0xAF, 0x8D, 0x9A, 0x90, 0x75, 0x79,
	0x6F, 0x66, 0x6B, 0x75, 0x73, 0x7D, 0x89, 0x81, 0x8D, 0x89, 0x81, 0x85,
	0x7D, 0x7B, 0x7C, 0x7C, 0x7C, 0x81, 0x83, 0x82, 0x86, 0x83, 0x81, 0x82,
	0x7C, 0x7C, 0x7B, 0x7B, 0x7C, 0x7E, 0x80, 0x80, 0x83, 0x83, 0x81, 0x83,
	0x7E, 0x81, 0x80, 0x7E, 0x82, 0x7F, 0x81, 0x82, 0x80, 0x81, 0x80, 0x7F,
	0x7E, 0x7F, 0x7E, 0x7D, 0x7F, 0x7E, 0x80, 0x80, 0x80, 0x80, 0x82, 0x7E,
	0x91, 0x93, 0x8D, 0xA9, 0x94, 0x94, 0x9B, 0x7D, 0x81, 0x79, 0x69, 0x71,
	0x70, 0x6C, 0x79, 0x7D, 0x7C, 0x89, 0x85, 0x82, 0x8A, 0x7E, 0x7F, 0x81,
	0x78, 0x7C, 0x7F, 0x7B, 0x82, 0x83, 0x80, 0x85, 0x84, 0x80, 0x83, 0x7E,
	0x7C, 0x7E, 0x7A, 0x7B, 0x7D, 0x7B, 0x7F, 0x80, 0x7F, 0x82, 0x81, 0x80,
	0x82, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x80, 0x80, 0x7F, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x82, 0x8F, 0x8A,
	0x96, 0x97, 0x90, 0x99, 0x8A, 0x89, 0x85, 0x7A, 0x7C, 0x78, 0x76, 0x79,
	0x7B, 0x7C, 0x81, 0x83, 0x81, 0x87, 0x82, 0x81, 0x83, 0x7C, 0x7F, 0x7D,
	0x7A, 0x7F, 0x7D, 0x7F, 0x83, 0x80, 0x82, 0x84, 0x81, 0x82, 0x81, 0x7F,
	0x80, 0x7E, 0x7D, 0x80, 0x7D, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x7F, 0x81,
	0x80, 0x7F, 0x81, 0x7F, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7E, 0x80, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x85, 0x89, 0x89, 0x92, 0x8C, 0x8F,
	0x8F, 0x88, 0x8B, 0x84, 0x82, 0x82, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E, 0x80,
	0x80, 0x81, 0x84, 0x81, 0x85, 0x83, 0x81, 0x84, 0x80, 0x82, 0x81, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x81, 0x7F, 0x80,
	0x81, 0x7F, 0x81, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x83, 0x85, 0x86, 0x8B, 0x88, 0x8A, 0x8A, 0x87, 0x89, 0x86,
	0x86, 0x85, 0x83, 0x83, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x82, 0x81,
	0x83, 0x81, 0x82, 0x83, 0x81, 0x83, 0x82, 0x82, 0x82, 0x81, 0x81, 0x82,
	0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80,
	0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x83, 0x83,
	0x85, 0x86, 0x85, 0x87, 0x85, 0x86, 0x86, 0x85, 0x86, 0x84, 0x84, 0x83,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80
};
const unsigned char WAVon[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x81, 0x82, 0x83, 0x82, 0x80, 0x7E, 0x7D, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x82, 0x86, 0x89, 0x86, 0x80, 0x7B, 0x7B,
	0x7E, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x80, 0x7E, 0x7D, 0x7E, 0x80,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x81, 0x8A, 0x92, 0x94, 0x88,
	0x7A, 0x70, 0x74, 0x7D, 0x85, 0x85, 0x84, 0x83, 0x84, 0x82, 0x7E, 0x79,
	0x78, 0x7E, 0x84, 0x87, 0x84, 0x80, 0x7C, 0x7D, 0x7E, 0x7F, 0x7E, 0x7F,
	0x80, 0x83, 0x83, 0x80, 0x7E, 0x7C, 0x7E, 0x7F, 0x81, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x7F, 0x7E, 0x7E, 0x7F, 0x80,
	0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x80, 0x7F, 0x85,
	0x93, 0x9F, 0x9B, 0x87, 0x72, 0x68, 0x70, 0x7F, 0x8A, 0x8A, 0x87, 0x85,
	0x85, 0x81, 0x7B, 0x74, 0x75, 0x7D, 0x86, 0x8B, 0x87, 0x81, 0x7C, 0x7C,
	0x7C, 0x7E, 0x7D, 0x7F, 0x81, 0x85, 0x84, 0x81, 0x7D, 0x7B, 0x7C, 0x7F,
	0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7E, 0x8E, 0xA5, 0xB3, 0xA3, 0x80, 0x5F, 0x5A,
	0x6E, 0x88, 0x94, 0x90, 0x89, 0x85, 0x86, 0x80, 0x77, 0x6D, 0x71, 0x7E,
	0x8D, 0x91, 0x8B, 0x7E, 0x77, 0x78, 0x7C, 0x7E, 0x7E, 0x7F, 0x82, 0x87,
	0x86, 0x82, 0x7B, 0x78, 0x7A, 0x80, 0x82, 0x82, 0x7F, 0x7F, 0x80, 0x82,
	0x81, 0x7D, 0x7C, 0x7D, 0x80, 0x82, 0x82, 0x80, 0x7E, 0x7E, 0x7F, 0x80,
	0x7F, 0x7F, 0x7E, 0x80, 0x80, 0x82, 0x7F, 0x7F, 0x7D, 0x80, 0x7F, 0x82,
	0x9D, 0xBA, 0xC5, 0xA3, 0x71, 0x4C, 0x53, 0x74, 0x96, 0x9E, 0x94, 0x87,
	0x85, 0x87, 0x80, 0x72, 0x67, 0x6E, 0x82, 0x96, 0x98, 0x8B, 0x79, 0x73,
	0x75, 0x7E, 0x7F, 0x7F, 0x7D, 0x84, 0x88, 0x88, 0x80, 0x77, 0x74, 0x79,
	0x82, 0x86, 0x85, 0x7F, 0x7F, 0x7E, 0x82, 0x7E, 0x7D, 0x7A, 0x7E, 0x81,
	0x85, 0x83, 0x80, 0x7C, 0x7D, 0x7F, 0x80, 0x81, 0x7E, 0x80, 0x7F, 0x83,
	0x7E, 0x7F, 0x79, 0x7F, 0x7D, 0x85, 0x80, 0x86, 0xAC, 0xD5, 0xDE, 0xA8,
	0x64, 0x36, 0x4B, 0x79, 0xA5, 0xA6, 0x96, 0x86, 0x89, 0x8D, 0x83, 0x6B,
	0x5B, 0x67, 0x85, 0xA2, 0xA1, 0x8D, 0x72, 0x6E, 0x74, 0x82, 0x7F, 0x7C,
	0x78, 0x84, 0x8E, 0x91, 0x83, 0x74, 0x6D, 0x75, 0x83, 0x89, 0x87, 0x7E,
	0x7D, 0x80, 0x85, 0x81, 0x7C, 0x76, 0x7B, 0x81, 0x89, 0x85, 0x81, 0x79,
	0x7E, 0x82, 0x87, 0x82, 0x7D, 0x79, 0x7E, 0x83, 0x85, 0x82, 0x7C, 0x7C,
	0x7D, 0x84, 0x81, 0x83, 0x77, 0xA1, 0xD4, 0xEE, 0xCA, 0x7E, 0x3B, 0x3A,
	0x6A, 0x9B, 0xAB, 0x97, 0x8B, 0x8A, 0x9B, 0x8F, 0x76, 0x54, 0x5A, 0x77,
	0xA0, 0xA9, 0x97, 0x79, 0x6E, 0x77, 0x82, 0x82, 0x75, 0x72, 0x7C, 0x92,
	0x97, 0x8D, 0x75, 0x6C, 0x70, 0x82, 0x89, 0x86, 0x7D, 0x7C, 0x82, 0x89,
	0x86, 0x7B, 0x74, 0x76, 0x82, 0x88, 0x88, 0x7F, 0x7B, 0x7B, 0x82, 0x82,
	0x80, 0x7A, 0x7B, 0x80, 0x85, 0x85, 0x80, 0x7C, 0x7A, 0x80, 0x81, 0x84,
	0x7C, 0x80, 0x7A, 0x8D, 0xBC, 0xE5, 0xDC, 0x9A, 0x58, 0x3C, 0x5C, 0x85,
	0xA0, 0x97, 0x8F, 0x8F, 0x9A, 0x94, 0x7A, 0x5D, 0x57, 0x72, 0x92, 0xA4,
	0x96, 0x82, 0x75, 0x7B, 0x7F, 0x7E, 0x73, 0x72, 0x7D, 0x8F, 0x96, 0x8B,
	0x7A, 0x70, 0x75, 0x7E, 0x84, 0x80, 0x7E, 0x7F, 0x86, 0x88, 0x83, 0x79,
	0x75, 0x79, 0x82, 0x86, 0x84, 0x7F, 0x7D, 0x80, 0x81, 0x81, 0x7C, 0x7B,
	0x7C, 0x83, 0x84, 0x84, 0x7E, 0x7D, 0x7D, 0x81, 0x81, 0x81, 0x7E, 0x7F,
	0x80, 0x82, 0x81, 0x7E, 0xA3, 0xCE, 0xE2, 0xB5, 0x74, 0x46, 0x51, 0x77,
	0x95, 0x98, 0x8D, 0x8E, 0x96, 0x9A, 0x82, 0x67, 0x57, 0x6B, 0x87, 0x9D,
	0x97, 0x88, 0x7B, 0x7C, 0x7F, 0x7B, 0x73, 0x72, 0x7D, 0x8C, 0x94, 0x8A,
	0x7D, 0x73, 0x78, 0x7D, 0x82, 0x7E, 0x7E, 0x80, 0x87, 0x87, 0x82, 0x79,
	0x77, 0x7A, 0x81, 0x84, 0x82, 0x80, 0x7F, 0x82, 0x82, 0x81, 0x7B, 0x7C,
	0x7D, 0x83, 0x82, 0x83, 0x7E, 0x7F, 0x7E, 0x81, 0x7F, 0x7E, 0x7E, 0x80,
	0x81, 0x82, 0x80, 0x7F, 0x7E, 0x81, 0xAB, 0xD1, 0xDB, 0xA7, 0x6B, 0x48,
	0x5A, 0x7E, 0x93, 0x92, 0x8B, 0x94, 0x99, 0x96, 0x78, 0x61, 0x5C, 0x75,
	0x8D, 0x9A, 0x8F, 0x83, 0x7E, 0x80, 0x7F, 0x76, 0x71, 0x74, 0x84, 0x8F,
	0x90, 0x83, 0x7B, 0x76, 0x7C, 0x7E, 0x7E, 0x7B, 0x7F, 0x84, 0x88, 0x85,
	0x7D, 0x79, 0x79, 0x7F, 0x81, 0x82, 0x7F, 0x81, 0x81, 0x83, 0x80, 0x7D,
	0x7B, 0x7D, 0x81, 0x82, 0x82, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7E,
	0x80, 0x83, 0x85, 0x82, 0x7F, 0x7C, 0x7E, 0x7E, 0x82, 0x7C, 0x93, 0xBE,
	0xDB, 0xC5, 0x83, 0x52, 0x49, 0x6F, 0x8B, 0x96, 0x8C, 0x8F, 0x97, 0x99,
	0x85, 0x68, 0x5B, 0x69, 0x86, 0x96, 0x94, 0x85, 0x80, 0x7F, 0x81, 0x78,
	0x72, 0x72, 0x80, 0x8C, 0x90, 0x87, 0x7C, 0x78, 0x7B, 0x7E, 0x7D, 0x7D,
	0x7E, 0x85, 0x87, 0x86, 0x7E, 0x7A, 0x79, 0x7E, 0x81, 0x81, 0x80, 0x80,
	0x82, 0x81, 0x7F, 0x7C, 0x7C, 0x7E, 0x81, 0x82, 0x81, 0x80, 0x7F, 0x80,
	0x7F, 0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x81, 0x7F, 0x7F, 0x7E, 0x80, 0x7E,
	0x80, 0x7E, 0x81, 0x7E, 0x86, 0xAE, 0xCF, 0xCE, 0x93, 0x5B, 0x46, 0x64,
	0x87, 0x95, 0x8F, 0x8C, 0x96, 0x97, 0x89, 0x6A, 0x5E, 0x67, 0x84, 0x93,
	0x94, 0x87, 0x82, 0x81, 0x7F, 0x78, 0x70, 0x74, 0x80, 0x8D, 0x8D, 0x87,
	0x7D, 0x7D, 0x7E, 0x7F, 0x7B, 0x7A, 0x7E, 0x85, 0x88, 0x83, 0x7E, 0x7B,
	0x7D, 0x7F, 0x80, 0x7E, 0x80, 0x81, 0x83, 0x82, 0x7E, 0x7D, 0x7D, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x83, 0x85, 0x83, 0x7F, 0x7C,
	0x7D, 0x7F, 0x81, 0x80, 0x80, 0x81, 0x81, 0x81, 0x7F, 0x7E, 0x7E, 0x80,
	0x80, 0xA5, 0xC9, 0xD0, 0x9D, 0x61, 0x4D, 0x63, 0x85, 0x8B, 0x8B, 0x8C,
	0x9E, 0x9C, 0x89, 0x6A, 0x62, 0x70, 0x82, 0x89, 0x85, 0x89, 0x8C, 0x8C,
	0x7E, 0x73, 0x6F, 0x79, 0x83, 0x85, 0x85, 0x83, 0x86, 0x83, 0x7E, 0x77,
	0x78, 0x7D, 0x82, 0x84, 0x82, 0x82, 0x84, 0x89, 0x87, 0x81, 0x79, 0x7A,
	0x7E, 0x82, 0x81, 0x80, 0x82, 0x84, 0x83, 0x7E, 0x7C, 0x7D, 0x7F, 0x80,
	0x80, 0x80, 0x81, 0x82, 0x81, 0x7E, 0x7E, 0x7E, 0x80, 0x7F, 0x80, 0x7F,
	0x81, 0x82, 0x82, 0x80, 0x7F, 0x7E, 0x80, 0x7F, 0x80, 0x7E, 0x85, 0xB5,
	0xCF, 0xC3, 0x86, 0x64, 0x68, 0x79, 0x7B, 0x70, 0x82, 0x9A, 0xAD, 0x96,
	0x7E, 0x71, 0x78, 0x7A, 0x73, 0x75, 0x80, 0x92, 0x91, 0x89, 0x7E, 0x7F,
	0x7E, 0x79, 0x74, 0x78, 0x83, 0x88, 0x87, 0x82, 0x82, 0x82, 0x7F, 0x7A,
	0x78, 0x7D, 0x81, 0x83, 0x81, 0x82, 0x82, 0x82, 0x7E, 0x7C, 0x7C, 0x7F,
	0x7E, 0x78, 0x79, 0x7D, 0x84, 0x80, 0x7F, 0x7F, 0x81, 0x81, 0x7D, 0x7C,
	0x7C, 0x81, 0x7F, 0x7F, 0x7F, 0x81, 0x82, 0x7F, 0x7E, 0x7E, 0x80, 0x7F,
	0x7F, 0x7E, 0x81, 0x80, 0x81, 0x7E, 0x81, 0x7E, 0x8C, 0xB5, 0xBE, 0xAE,
	0x88, 0x82, 0x81, 0x78, 0x69, 0x69, 0x85, 0x92, 0x95, 0x8A, 0x8F, 0x90,
	0x86, 0x75, 0x6E, 0x78, 0x7E, 0x7F, 0x7E, 0x87, 0x8E, 0x8B, 0x81, 0x7B,
	0x7E, 0x7C, 0x78, 0x77, 0x7D, 0x84, 0x84, 0x82, 0x82, 0x85, 0x82, 0x7D,
	0x7B, 0x7C, 0x7F, 0x7E, 0x7E, 0x80, 0x83, 0x83, 0x80, 0x7F, 0x80, 0x80,
	0x7D, 0x7D, 0x7E, 0x80, 0x80, 0x80, 0x7F, 0x7D, 0x7D, 0x7C, 0x7D, 0x7D,
	0x7E, 0x7F, 0x7F, 0x81, 0x80, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x9A, 0xAD, 0xAC, 0x9E, 0x93, 0x95,
	0x86, 0x79, 0x6E, 0x72, 0x76, 0x73, 0x75, 0x79, 0x84, 0x84, 0x83, 0x84,
	0x86, 0x87, 0x81, 0x80, 0x7E, 0x80, 0x7D, 0x7B, 0x7D, 0x7E, 0x80, 0x7E,
	0x80, 0x81, 0x81, 0x81, 0x7F, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x84, 0x94, 0x99, 0x9B, 0x9B, 0x99, 0x9B, 0x95, 0x94, 0x8F, 0x89,
	0x84, 0x7D, 0x7C, 0x78, 0x76, 0x75, 0x74, 0x76, 0x77, 0x7A, 0x7D, 0x80,
	0x83, 0x84, 0x86, 0x87, 0x88, 0x88, 0x86, 0x85, 0x83, 0x82, 0x80, 0x7E,
	0x7D, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C, 0x7C, 0x7E, 0x7F, 0x80, 0x81, 0x81,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7D, 0x7E, 0x7D,
	0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x82, 0x8E, 0x92, 0x94, 0x95,
	0x94, 0x95, 0x93, 0x95, 0x92, 0x8C, 0x87, 0x81, 0x7F, 0x7D, 0x7B, 0x7A,
	0x77, 0x77, 0x78, 0x7B, 0x7E, 0x80, 0x82, 0x83, 0x85, 0x87, 0x88, 0x89,
	0x88, 0x86, 0x84, 0x82, 0x80, 0x7F, 0x7D, 0x7B, 0x79, 0x79, 0x79, 0x7A,
	0x7B, 0x7C, 0x7D, 0x7F, 0x80, 0x82, 0x83, 0x84, 0x84, 0x84, 0x84, 0x83,
	0x82, 0x81, 0x80, 0x7F, 0x7E, 0x7D, 0x7C, 0x7B, 0x7B, 0x7B, 0x7B, 0x7C,
	0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x88,
	0x8D, 0x8E, 0x90, 0x8F, 0x8E, 0x8D, 0x8E, 0x8E, 0x8A, 0x88, 0x83, 0x81,
	0x7F, 0x7E, 0x7E, 0x7C, 0x7B, 0x7B, 0x7C, 0x7E, 0x80, 0x82, 0x83, 0x84,
	0x85, 0x86, 0x88, 0x88, 0x88, 0x86, 0x85, 0x84, 0x82, 0x82, 0x80, 0x7F,
	0x7D, 0x7C, 0x7C, 0x7C, 0x7D, 0x7D, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x83,
	0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7F,
	0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x81,
	0x86, 0x8B, 0x8C, 0x8E, 0x8F, 0x8F, 0x8F, 0x90, 0x91, 0x8F, 0x8D, 0x8A,
	0x88, 0x86, 0x84, 0x83, 0x80, 0x7F, 0x7D, 0x7D, 0x7D, 0x7D, 0x7F, 0x7F,
	0x80, 0x81, 0x82, 0x84, 0x85, 0x86, 0x86, 0x86, 0x87, 0x87, 0x86, 0x86,
	0x85, 0x84, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x82, 0x86,
	0x86, 0x88, 0x89, 0x89, 0x89, 0x8B, 0x8D, 0x8B, 0x8B, 0x8A, 0x89, 0x88,
	0x87, 0x87, 0x85, 0x84, 0x83, 0x82, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x84, 0x85, 0x86, 0x86, 0x86,
	0x86, 0x86, 0x87, 0x87, 0x86, 0x85, 0x85, 0x84, 0x83, 0x83, 0x82, 0x82,
	0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x81, 0x83, 0x83, 0x83, 0x84, 0x84, 0x83, 0x83, 0x84, 0x83, 0x83,
	0x83, 0x83, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82,
	0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F
};
const unsigned char WAVpause[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVpoint[] = {
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7D, 0x81, 0x81, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x81, 0x81, 0x81, 0x7F, 0x80, 0x7F, 0x7F, 0x82, 0x80, 0x7F,
	0x80, 0x7E, 0x7C, 0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x81, 0x81, 0x81,
	0x81, 0x80, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7E,
	0x7F, 0x7F, 0x7F, 0x80, 0x7E, 0x7F, 0x80, 0x7E, 0x7D, 0x7E, 0x81, 0x81,
	0x81, 0x80, 0x7F, 0x81, 0x83, 0x82, 0x80, 0x80, 0x7F, 0x80, 0x83, 0x83,
	0x82, 0x81, 0x7E, 0x7E, 0x7F, 0x82, 0x83, 0x81, 0x80, 0x7F, 0x7F, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x7F, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x80,
	0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x81, 0x82, 0x82,
	0x83, 0x84, 0x83, 0x82, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x82, 0x81, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81,
	0x80, 0x7E, 0x7D, 0x7D, 0x7D, 0x7F, 0x7F, 0x80, 0x84, 0x87, 0x8B, 0x8C,
	0x8A, 0x86, 0x82, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x80, 0x80, 0x84, 0x8C, 0x94, 0x9A, 0x9A, 0x94, 0x8B, 0x81, 0x7A, 0x78,
	0x7A, 0x7D, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x83, 0x84, 0x84, 0x82, 0x7F,
	0x7D, 0x7C, 0x7C, 0x7E, 0x80, 0x81, 0x81, 0x7F, 0x7E, 0x7D, 0x7E, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x86, 0x8F, 0x9A,
	0xA0, 0x9F, 0x97, 0x89, 0x7C, 0x74, 0x72, 0x75, 0x7B, 0x7F, 0x82, 0x82,
	0x81, 0x81, 0x83, 0x84, 0x85, 0x83, 0x7F, 0x7C, 0x7A, 0x7A, 0x7C, 0x7F,
	0x82, 0x83, 0x82, 0x81, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7E, 0x7E,
	0x7D, 0x7E, 0x7F, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x7E, 0x83, 0x8F, 0x9E, 0xAD, 0xB3, 0xAE, 0x9D, 0x88,
	0x75, 0x6A, 0x68, 0x6D, 0x76, 0x7E, 0x83, 0x85, 0x86, 0x86, 0x87, 0x87,
	0x85, 0x81, 0x7B, 0x77, 0x75, 0x76, 0x7B, 0x80, 0x85, 0x87, 0x86, 0x83,
	0x80, 0x7E, 0x7E, 0x7E, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7E, 0x80, 0x81,
	0x82, 0x82, 0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x81, 0x7F,
	0x87, 0x97, 0xAB, 0xBB, 0xC0, 0xB4, 0x9A, 0x7E, 0x66, 0x5C, 0x5E, 0x6B,
	0x79, 0x84, 0x89, 0x89, 0x88, 0x87, 0x86, 0x85, 0x81, 0x7A, 0x74, 0x71,
	0x73, 0x7A, 0x82, 0x89, 0x8C, 0x8A, 0x85, 0x7F, 0x7B, 0x7A, 0x7B, 0x7D,
	0x7E, 0x7E, 0x7F, 0x7F, 0x81, 0x82, 0x84, 0x83, 0x82, 0x7F, 0x7C, 0x7B,
	0x7C, 0x7E, 0x80, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7E, 0x88, 0x9C, 0xB1,
	0xC2, 0xC3, 0xB2, 0x93, 0x74, 0x5D, 0x56, 0x5D, 0x6D, 0x7C, 0x86, 0x8A,
	0x8A, 0x89, 0x89, 0x88, 0x84, 0x7D, 0x75, 0x6F, 0x70, 0x76, 0x80, 0x8A,
	0x8E, 0x8C, 0x86, 0x7F, 0x7B, 0x79, 0x7B, 0x7C, 0x7E, 0x7E, 0x7E, 0x7F,
	0x81, 0x84, 0x85, 0x84, 0x81, 0x7D, 0x7A, 0x79, 0x7A, 0x7D, 0x7F, 0x82,
	0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7E, 0x80, 0x92, 0xAA, 0xC1, 0xCB,
	0xC0, 0xA0, 0x7B, 0x5C, 0x4E, 0x54, 0x65, 0x79, 0x86, 0x8B, 0x8B, 0x8A,
	0x88, 0x86, 0x80, 0x78, 0x6E, 0x6A, 0x6E, 0x79, 0x86, 0x91, 0x94, 0x8F,
	0x85, 0x7C, 0x77, 0x77, 0x7A, 0x7C, 0x7E, 0x7E, 0x7F, 0x81, 0x84, 0x86,
	0x86, 0x82, 0x7D, 0x79, 0x78, 0x7A, 0x7F, 0x83, 0x85, 0x85, 0x83, 0x80,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7E, 0x7F, 0x7C, 0x87, 0xA2, 0xBE, 0xD0, 0xCD,
	0xB1, 0x84, 0x5E, 0x48, 0x4A, 0x5D, 0x75, 0x86, 0x8D, 0x8D, 0x8B, 0x8A,
	0x8A, 0x86, 0x7D, 0x72, 0x6A, 0x6C, 0x77, 0x86, 0x92, 0x95, 0x8E, 0x83,
	0x79, 0x75, 0x76, 0x7B, 0x7E, 0x7F, 0x7E, 0x7F, 0x81, 0x85, 0x87, 0x86,
	0x81, 0x7B, 0x77, 0x78, 0x7C, 0x81, 0x84, 0x83, 0x80, 0x7D, 0x7D, 0x7E,
	0x81, 0x81, 0x81, 0x7E, 0x7E, 0x7D, 0x81, 0x80, 0x8A, 0xA5, 0xBF, 0xD0,
	0xCA, 0xAC, 0x7C, 0x56, 0x43, 0x4A, 0x60, 0x7B, 0x8A, 0x8F, 0x8E, 0x8B,
	0x8B, 0x89, 0x82, 0x76, 0x6C, 0x69, 0x73, 0x83, 0x91, 0x96, 0x8F, 0x83,
	0x78, 0x75, 0x78, 0x7C, 0x7E, 0x7D, 0x7C, 0x7E, 0x84, 0x88, 0x8A, 0x85,
	0x7D, 0x76, 0x75, 0x7A, 0x81, 0x85, 0x85, 0x83, 0x82, 0x82, 0x83, 0x82,
	0x7F, 0x7B, 0x79, 0x7A, 0x7E, 0x83, 0x85, 0x84, 0x7F, 0x7F, 0x7B, 0x92,
	0xB6, 0xD2, 0xD6, 0xB9, 0x89, 0x5B, 0x4B, 0x50, 0x66, 0x77, 0x80, 0x80,
	0x86, 0x8F, 0x97, 0x94, 0x83, 0x6E, 0x61, 0x68, 0x79, 0x8C, 0x91, 0x8C,
	0x81, 0x7D, 0x80, 0x85, 0x83, 0x7C, 0x72, 0x71, 0x79, 0x86, 0x8E, 0x8C,
	0x82, 0x79, 0x78, 0x7C, 0x83, 0x83, 0x80, 0x7B, 0x7C, 0x81, 0x87, 0x87,
	0x81, 0x7A, 0x78, 0x7B, 0x81, 0x85, 0x82, 0x7E, 0x7B, 0x7F, 0x82, 0x86,
	0x81, 0x7F, 0x77, 0x8C, 0xB8, 0xD7, 0xDA, 0xB3, 0x82, 0x57, 0x53, 0x5F,
	0x73, 0x79, 0x78, 0x7E, 0x8E, 0xA1, 0xA3, 0x91, 0x73, 0x61, 0x63, 0x76,
	0x85, 0x87, 0x80, 0x7C, 0x82, 0x8E, 0x92, 0x88, 0x76, 0x6B, 0x6F, 0x7E,
	0x89, 0x89, 0x80, 0x7A, 0x7C, 0x85, 0x8A, 0x83, 0x77, 0x71, 0x77, 0x82,
	0x8A, 0x86, 0x7E, 0x79, 0x7D, 0x85, 0x88, 0x81, 0x79, 0x76, 0x7C, 0x85,
	0x87, 0x83, 0x7B, 0x7B, 0x7E, 0x86, 0x84, 0x81, 0x77, 0x8C, 0xBE, 0xD9,
	0xD6, 0xA8, 0x7D, 0x67, 0x6C, 0x74, 0x6B, 0x60, 0x63, 0x7F, 0x9F, 0xAB,
	0x9A, 0x7E, 0x70, 0x76, 0x81, 0x7F, 0x72, 0x69, 0x72, 0x8A, 0x98, 0x94,
	0x81, 0x74, 0x78, 0x83, 0x87, 0x7D, 0x74, 0x78, 0x85, 0x90, 0x8C, 0x7F,
	0x76, 0x79, 0x83, 0x85, 0x7E, 0x76, 0x77, 0x81, 0x89, 0x88, 0x7F, 0x79,
	0x7C, 0x83, 0x85, 0x7F, 0x79, 0x78, 0x80, 0x86, 0x85, 0x7F, 0x7B, 0x7D,
	0x82, 0x80, 0x7C, 0x78, 0x7D, 0xB3, 0xD9, 0xD1, 0xA6, 0x78, 0x72, 0x78,
	0x79, 0x65, 0x56, 0x66, 0x8C, 0xA7, 0xA3, 0x8B, 0x7D, 0x81, 0x8A, 0x82,
	0x6C, 0x61, 0x6C, 0x85, 0x92, 0x8C, 0x80, 0x7E, 0x87, 0x8A, 0x80, 0x71,
	0x6E, 0x79, 0x84, 0x86, 0x7F, 0x7C, 0x84, 0x8A, 0x88, 0x7E, 0x76, 0x79,
	0x7F, 0x82, 0x7E, 0x7A, 0x7E, 0x84, 0x88, 0x82, 0x7D, 0x7C, 0x80, 0x81,
	0x80, 0x7F, 0x80, 0x83, 0x83, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7E,
	0x7E, 0x81, 0x81, 0xAF, 0xD6, 0xC3, 0x9B, 0x76, 0x7D, 0x87, 0x72, 0x5C,
	0x5A, 0x7C, 0x9D, 0x9D, 0x90, 0x88, 0x92, 0x94, 0x7D, 0x69, 0x68, 0x75,
	0x7E, 0x7A, 0x7D, 0x89, 0x93, 0x91, 0x84, 0x7E, 0x7E, 0x7C, 0x76, 0x72,
	0x76, 0x80, 0x84, 0x85, 0x85, 0x86, 0x88, 0x82, 0x7C, 0x7A, 0x7A, 0x7C,
	0x7D, 0x81, 0x84, 0x85, 0x85, 0x84, 0x83, 0x80, 0x7D, 0x7B, 0x7C, 0x7D,
	0x7E, 0x7F, 0x81, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7F, 0x7D, 0x7D, 0x7D,
	0x7E, 0x80, 0x80, 0xAF, 0xCD, 0xAF, 0x94, 0x8B, 0x8B, 0x7B, 0x5E, 0x64,
	0x78, 0x7C, 0x82, 0x8C, 0x9C, 0x9C, 0x8D, 0x87, 0x84, 0x7A, 0x6F, 0x6D,
	0x75, 0x7C, 0x7D, 0x85, 0x8D, 0x8E, 0x8A, 0x84, 0x82, 0x7E, 0x77, 0x75,
	0x77, 0x79, 0x7B, 0x80, 0x85, 0x87, 0x86, 0x85, 0x83, 0x7F, 0x7B, 0x7A,
	0x7A, 0x7B, 0x7C, 0x7F, 0x82, 0x83, 0x83, 0x83, 0x83, 0x7F, 0x7F, 0x7D,
	0x7D, 0x7D, 0x7D, 0x7F, 0x80, 0x80, 0x83, 0x87, 0x84, 0x82, 0x81, 0x80,
	0x7D, 0x7D, 0x7D, 0x80, 0x7C, 0x8B, 0xB8, 0xB3, 0x9B, 0x9F, 0x95, 0x7F,
	0x6E, 0x6D, 0x77, 0x6D, 0x71, 0x8B, 0x90, 0x8C, 0x91, 0x95, 0x8D, 0x7D,
	0x78, 0x79, 0x70, 0x6E, 0x79, 0x7E, 0x7F, 0x85, 0x8C, 0x8B, 0x85, 0x83,
	0x82, 0x7B, 0x76, 0x7A, 0x7B, 0x7A, 0x7D, 0x83, 0x84, 0x83, 0x85, 0x85,
	0x81, 0x7E, 0x7E, 0x7D, 0x7B, 0x7C, 0x7E, 0x7E, 0x7F, 0x81, 0x82, 0x81,
	0x81, 0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x80, 0x80,
	0x81, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x7F, 0x7F, 0x80, 0x7E, 0x9F, 0xB3,
	0x9F, 0xAA, 0xA8, 0x89, 0x7C, 0x78, 0x6F, 0x68, 0x6D, 0x7C, 0x7E, 0x80,
	0x90, 0x8F, 0x87, 0x89, 0x86, 0x7D, 0x78, 0x7A, 0x7A, 0x76, 0x7B, 0x82,
	0x80, 0x82, 0x87, 0x84, 0x81, 0x81, 0x82, 0x7E, 0x7D, 0x80, 0x7F, 0x7D,
	0x80, 0x81, 0x7F, 0x80, 0x81, 0x80, 0x7F, 0x80, 0x80, 0x7E, 0x7F, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x81, 0x80, 0x81, 0x82, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x81, 0x7E, 0x8C, 0xA5, 0x9D, 0xA0, 0xA4, 0x90, 0x84, 0x7F,
	0x77, 0x70, 0x71, 0x79, 0x79, 0x7D, 0x87, 0x86, 0x86, 0x89, 0x86, 0x81,
	0x80, 0x7F, 0x7B, 0x7A, 0x7D, 0x7C, 0x7D, 0x81, 0x81, 0x80, 0x82, 0x82,
	0x80, 0x80, 0x81, 0x7E, 0x7E, 0x7F, 0x7E, 0x7E, 0x80, 0x80, 0x7F, 0x80,
	0x82, 0x81, 0x81, 0x82, 0x81, 0x80, 0x80, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x94, 0x99, 0x99, 0xA1, 0x96, 0x8B, 0x86, 0x7E, 0x77, 0x75, 0x78, 0x76,
	0x79, 0x80, 0x81, 0x83, 0x87, 0x86, 0x85, 0x84, 0x83, 0x7F, 0x7D, 0x7E,
	0x7B, 0x7C, 0x7E, 0x7E, 0x7F, 0x81, 0x81, 0x81, 0x82, 0x82, 0x80, 0x80,
	0x80, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x82, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7E, 0x85, 0x95, 0x95, 0x9A,
	0x9D, 0x91, 0x8D, 0x88, 0x82, 0x7E, 0x7D, 0x7B, 0x76, 0x78, 0x7B, 0x7A,
	0x81, 0x85, 0x86, 0x88, 0x88, 0x87, 0x84, 0x84, 0x82, 0x7E, 0x7E, 0x7D,
	0x7A, 0x7C, 0x7C, 0x7D, 0x7F, 0x81, 0x81, 0x82, 0x83, 0x84, 0x83, 0x83,
	0x82, 0x80, 0x80, 0x7F, 0x7E, 0x7E, 0x7E, 0x7D, 0x7E, 0x7F, 0x7F, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7E, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x85, 0x8C, 0x8D, 0x92, 0x92, 0x8D, 0x8C,
	0x8A, 0x88, 0x86, 0x84, 0x81, 0x7C, 0x7A, 0x7B, 0x7A, 0x7D, 0x7F, 0x7F,
	0x80, 0x81, 0x83, 0x84, 0x86, 0x87, 0x86, 0x85, 0x84, 0x81, 0x81, 0x80,
	0x7F, 0x7E, 0x7D, 0x7C, 0x7C, 0x7C, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x81,
	0x81, 0x81, 0x82, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x7F, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7E, 0x7E, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x82, 0x86, 0x87, 0x89, 0x8A, 0x88, 0x88, 0x87, 0x87, 0x86,
	0x85, 0x83, 0x80, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E,
	0x7F, 0x80, 0x81, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80,
	0x80, 0x7F, 0x7F, 0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82,
	0x84, 0x86, 0x87, 0x86, 0x85, 0x84, 0x83, 0x84, 0x84, 0x84, 0x85, 0x84,
	0x84, 0x84, 0x83, 0x83, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x7F, 0x80, 0x80, 0x82, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80,
	0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x7F, 0x7E, 0x7E, 0x7D, 0x7D, 0x7D, 0x7D, 0x7E, 0x7E, 0x7E, 0x7E,
	0x7E, 0x7F, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80,
	0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F,
	0x7F, 0x7F, 0x7E, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x81, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x81,
	0x82, 0x80, 0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7E, 0x7D, 0x7E, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x7F,
	0x80, 0x81, 0x81, 0x82, 0x81, 0x81, 0x7F, 0x7E, 0x7E, 0x7E, 0x7F, 0x7F,
	0x80, 0x80, 0x80, 0x7F, 0x7F, 0x81, 0x7E, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x7F, 0x7E, 0x7F, 0x7F, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7E, 0x7F,
	0x7F, 0x81, 0x7F, 0x80, 0x82, 0x80, 0x82, 0x80, 0x80, 0x7F, 0x7E, 0x80,
	0x7E, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x81, 0x80, 0x80, 0x81,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x81,
	0x80, 0x81, 0x80, 0x7F, 0x80, 0x7E, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x81, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
};
const unsigned char WAVpower[] = {
	0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F,
	0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80,
	0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x7F,
	0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F,
	0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x82, 0x82, 0x80, 0x82, 0x82, 0x82,
	0x83, 0x81, 0x80, 0x7E, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x81, 0x80, 0x80,
	0x7F, 0x80, 0x81, 0x81, 0x82, 0x83, 0x81, 0x82, 0x81, 0x80, 0x80, 0x80,
	0x7E, 0x7F, 0x80, 0x81, 0x82, 0x82, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F,
	0x81, 0x83, 0x82, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x82, 0x80, 0x7E,
	0x7E, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x82, 0x83, 0x84, 0x83,
	0x81, 0x83, 0x83, 0x81, 0x83, 0x84, 0x85, 0x84, 0x81, 0x81, 0x7F, 0x81,
	0x80, 0x7D, 0x7F, 0x7E, 0x7E, 0x81, 0x80, 0x81, 0x83, 0x84, 0x83, 0x7D,
	0x7B, 0x81, 0x81, 0x80, 0x7F, 0x7E, 0x80, 0x80, 0x81, 0x83, 0x81, 0x81,
	0x7F, 0x81, 0x83, 0x7F, 0x81, 0x81, 0x80, 0x85, 0x84, 0x80, 0x84, 0x85,
	0x86, 0x88, 0x83, 0x82, 0x7E, 0x80, 0x85, 0x85, 0x84, 0x81, 0x81, 0x81,
	0x81, 0x85, 0x85, 0x85, 0x82, 0x7C, 0x7E, 0x80, 0x86, 0x84, 0x7D, 0x80,
	0x80, 0x81, 0x81, 0x81, 0x84, 0x7E, 0x7E, 0x7E, 0x7D, 0x80, 0x81, 0x82,
	0x7F, 0x7E, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7E, 0x7C, 0x7E, 0x7F, 0x7F,
	0x7E, 0x7E, 0x81, 0x81, 0x81, 0x82, 0x80, 0x7D, 0x7E, 0x7F, 0x81, 0x81,
	0x81, 0x84, 0x82, 0x80, 0x7D, 0x84, 0x87, 0x85, 0x88, 0x82, 0x80, 0x7C,
	0x7C, 0x82, 0x83, 0x85, 0x80, 0x81, 0x80, 0x7E, 0x7D, 0x7F, 0x86, 0x85,
	0x85, 0x85, 0x81, 0x81, 0x80, 0x80, 0x82, 0x80, 0x80, 0x7E, 0x7B, 0x7D,
	0x7E, 0x83, 0x83, 0x81, 0x80, 0x7D, 0x81, 0x84, 0x83, 0x81, 0x7F, 0x80,
	0x81, 0x84, 0x85, 0x85, 0x82, 0x7C, 0x7B, 0x7F, 0x85, 0x88, 0x7E, 0x7D,
	0x7F, 0x80, 0x82, 0x81, 0x85, 0x83, 0x7E, 0x7A, 0x7C, 0x83, 0x88, 0x83,
	0x7B, 0x7D, 0x7F, 0x82, 0x81, 0x83, 0x83, 0x7C, 0x7D, 0x7D, 0x7E, 0x81,
	0x83, 0x83, 0x80, 0x7D, 0x7A, 0x7E, 0x7E, 0x7F, 0x82, 0x7E, 0x7B, 0x7A,
	0x7B, 0x7D, 0x7F, 0x82, 0x80, 0x80, 0x81, 0x81, 0x84, 0x85, 0x81, 0x7D,
	0x7E, 0x80, 0x80, 0x84, 0x82, 0x84, 0x82, 0x7B, 0x7A, 0x83, 0x86, 0x80,
	0x7F, 0x7E, 0x81, 0x80, 0x7D, 0x80, 0x81, 0x81, 0x7F, 0x7D, 0x81, 0x7E,
	0x87, 0x90, 0x88, 0x81, 0x7A, 0x7E, 0x84, 0x83, 0x84, 0x80, 0x7F, 0x7D,
	0x7D, 0x81, 0x81, 0x81, 0x7F, 0x7E, 0x7F, 0x7F, 0x81, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x80, 0x7F,
	0x80, 0x7F, 0x83, 0x97, 0x9A, 0x8F, 0x7E, 0x77, 0x81, 0x88, 0x8B, 0x86,
	0x81, 0x7D, 0x7A, 0x7D, 0x81, 0x84, 0x84, 0x7F, 0x7C, 0x7B, 0x7E, 0x80,
	0x82, 0x81, 0x80, 0x7E, 0x7E, 0x7E, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x7E,
	0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x80,
	0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x8C, 0xA5, 0xA6, 0x95, 0x79, 0x73, 0x81,
	0x8C, 0x90, 0x87, 0x82, 0x7F, 0x7C, 0x7C, 0x7D, 0x84, 0x86, 0x82, 0x7B,
	0x76, 0x7A, 0x80, 0x83, 0x82, 0x7F, 0x7E, 0x7E, 0x7E, 0x7E, 0x7F, 0x82,
	0x81, 0x80, 0x7E, 0x7E, 0x7F, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F,
	0x7F, 0x80, 0x80, 0x80, 0x7F, 0x80, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x7F, 0x80, 0x7F, 0x80, 0x7E, 0x8E, 0xB0, 0xB6, 0xA3,
	0x81, 0x75, 0x82, 0x8E, 0x93, 0x8B, 0x88, 0x86, 0x7F, 0x7A, 0x79, 0x81,
	0x89, 0x88, 0x82, 0x7C, 0x7D, 0x80, 0x80, 0x80, 0x80, 0x82, 0x81, 0x7F,
	0x7E, 0x7E, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x7F, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x81, 0x81, 0x81, 0x80, 0x7F, 0x7F, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x7F, 0x84,
	0xAE, 0xC4, 0xB0, 0x84, 0x65, 0x75, 0x89, 0x90, 0x88, 0x84, 0x8C, 0x88,
	0x7B, 0x71, 0x77, 0x88, 0x8C, 0x84, 0x7C, 0x7D, 0x83, 0x81, 0x7C, 0x7B,
	0x81, 0x86, 0x83, 0x7D, 0x7C, 0x7F, 0x82, 0x80, 0x7E, 0x7E, 0x81, 0x82,
	0x7F, 0x7D, 0x7E, 0x81, 0x81, 0x80, 0x7F, 0x80, 0x81, 0x80, 0x7E, 0x7F,
	0x80, 0x81, 0x80, 0x7F, 0x7F, 0x80, 0x80, 0x7F, 0x7F, 0x7F, 0x80, 0x80,
	0x7F, 0x7F, 0x7F, 0x82, 0xB3, 0xD1, 0xB3, 0x7C, 0x53, 0x6B, 0x88, 0x96,
	0x92, 0x8D, 0x9A, 0x92, 0x7E, 0x69, 0x6C, 0x83, 0x8E, 0x8D, 0x85, 0x84,
	0x87, 0x7F, 0x77, 0x74, 0x7E, 